/*
 * Decompiled with CFR 0.152.
 */
package com.odi;

public abstract class ReplicationStateHandler {
    public static final short ACTIVE = 1;
    public static final short SYNCHRONIZING_ACTIVE = 2;
    public static final short STANDBY = 3;
    public static final short SYNCHRONIZING_STANDBY = 4;
    public static final short DEEP_SYNCHRONIZING_STANDBY = 5;
    public static final short SHUTDOWN = 6;

    public void newState(short state) {
        System.out.println("New state " + ReplicationStateHandler.stateToString(state));
    }

    public void shutdownState(String shutdownReason, Exception e) {
        String reason = shutdownReason != null ? shutdownReason : "unknown";
        System.out.println("Shutdown state. Cause: " + reason);
        if (e != null) {
            e.printStackTrace();
        }
    }

    public void newMessage(String message, boolean warning) {
        if (message != null) {
            System.out.println("Replication message: " + message + (warning ? "(Warning)" : "(info)"));
        }
    }

    public static String stateToString(short state) {
        switch (state) {
            case 1: {
                return "ACTIVE";
            }
            case 2: {
                return "SYNCHRONIZING ACTIVE";
            }
            case 3: {
                return "STANDBY";
            }
            case 4: {
                return "SYNCHRONIZING STANDBY";
            }
            case 5: {
                return "DEEP SYNCHRONIZING STANDBY";
            }
            case 6: {
                return "SHUTDOWN";
            }
        }
        return "UNKNOWN REPLICATION STATE";
    }
}

