/*
 * Decompiled with CFR 0.152.
 */
package com.odi.filter.classfile;

import com.odi.filter.classfile.AnnotatedClassAttribute;
import com.odi.filter.classfile.AnnotatedMethodAttribute;
import com.odi.filter.classfile.CodeAttribute;
import com.odi.filter.classfile.CodeEnv;
import com.odi.filter.classfile.ConstUtf8;
import com.odi.filter.classfile.ConstantPool;
import com.odi.filter.classfile.ConstantValueAttribute;
import com.odi.filter.classfile.ExceptionsAttribute;
import com.odi.filter.classfile.GenericAttribute;
import com.odi.filter.classfile.LineNumberTableAttribute;
import com.odi.filter.classfile.LocalVariableTableAttribute;
import com.odi.filter.classfile.SourceFileAttribute;
import com.odi.filter.classfile.VMConstants;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public abstract class ClassAttribute
implements VMConstants {
    private ConstUtf8 attributeName;

    public ConstUtf8 attrName() {
        return this.attributeName;
    }

    ClassAttribute(ConstUtf8 theAttrName) {
        this.attributeName = theAttrName;
    }

    static ClassAttribute read(DataInputStream data, ConstantPool pool) throws IOException {
        ClassAttribute attr = null;
        int attrNameIndex = data.readUnsignedShort();
        ConstUtf8 attrName8 = (ConstUtf8)pool.constantAt(attrNameIndex);
        String attrName = attrName8.asString();
        int attrLength = data.readInt();
        if (attrName.equals("Code")) {
            attr = CodeAttribute.read(attrName8, attrLength, data, pool);
        } else if (attrName.equals("SourceFile")) {
            attr = SourceFileAttribute.read(attrName8, data, pool);
        } else if (attrName.equals("ConstantValue")) {
            attr = ConstantValueAttribute.read(attrName8, data, pool);
        } else if (attrName.equals("Exceptions")) {
            attr = ExceptionsAttribute.read(attrName8, data, pool);
        } else if (attrName.equals("com.odi.annotatedClass")) {
            attr = AnnotatedClassAttribute.read(attrName8, data, pool);
        } else {
            byte[] attrBytes = new byte[attrLength];
            data.readFully(attrBytes);
            attr = new GenericAttribute(attrName8, attrBytes);
        }
        return attr;
    }

    static ClassAttribute read(DataInputStream data, CodeEnv env) throws IOException {
        ClassAttribute attr = null;
        int attrNameIndex = data.readUnsignedShort();
        ConstUtf8 attrName8 = (ConstUtf8)env.pool().constantAt(attrNameIndex);
        String attrName = attrName8.asString();
        int attrLength = data.readInt();
        if (attrName.equals("LineNumberTable")) {
            attr = LineNumberTableAttribute.read(attrName8, data, env);
        } else if (attrName.equals("LocalVariableTable")) {
            attr = LocalVariableTableAttribute.read(attrName8, data, env);
        } else if (attrName.equals("com.odi.annotatedMethod")) {
            attr = AnnotatedMethodAttribute.read(attrName8, data, env);
        } else {
            byte[] attrBytes = new byte[attrLength];
            data.readFully(attrBytes);
            attr = new GenericAttribute(attrName8, attrBytes);
        }
        return attr;
    }

    abstract void write(DataOutputStream var1) throws IOException;

    abstract void print(PrintStream var1, int var2);
}

