/*
 * Decompiled with CFR 0.152.
 */
package com.odi.util;

import com.odi.ClassInfo;
import com.odi.IPersistent;
import com.odi.Placement;
import com.odi.util.BTreeEntryNotFoundException;
import com.odi.util.BTreeImpl;
import com.odi.util.BTreeIterator;
import com.odi.util.StorageBTreeImpl;
import java.io.PrintStream;

public abstract class BTree
implements IPersistent {
    private static boolean useStorageBTrees = new Boolean(System.getProperty("_PSEUseUtilBTrees", "false")) == false;
    public static final int FIXED_SIZE_KEYS = 1;
    public static final int DUPLICATE_KEYS = 2;

    public static BTree create(Placement placement, int keySize, int flags) {
        if (useStorageBTrees) {
            return new StorageBTreeImpl(placement, keySize, flags);
        }
        return new BTreeImpl(placement, keySize, flags);
    }

    public abstract Object get(byte[] var1) throws BTreeEntryNotFoundException;

    public abstract boolean containsKey(byte[] var1);

    public abstract boolean contains(byte[] var1, Object var2);

    public abstract Object put(byte[] var1, Object var2);

    public abstract void insertKnownNewValue(byte[] var1, Object var2);

    public abstract Object insertUniqueKey(byte[] var1, Object var2);

    public abstract int size();

    public abstract int sizeEstimate();

    public abstract boolean isSizeMaintained();

    public abstract void maintainSize(boolean var1);

    public abstract Object remove(byte[] var1);

    public abstract void remove(byte[] var1, Object var2);

    public abstract void clear();

    public abstract BTreeIterator iterator();

    public abstract BTreeIterator reverseIterator();

    public abstract BTreeIterator iterator(byte[] var1);

    public abstract BTreeIterator reverseIterator(byte[] var1);

    public abstract byte[] getFirstKey();

    public abstract byte[] getLastKey();

    public abstract int getKeySize();

    public abstract boolean hasFixedSizeKeys();

    public void setPathInfo(String info) {
    }

    public abstract void printStats(PrintStream var1);

    public abstract void printContents(PrintStream var1);

    public abstract boolean checkValid(PrintStream var1);

    int getModifications() {
        return 0;
    }

    static {
        ClassInfo.register(ClassInfo.getDynamic("com.odi.util.BTree"));
    }
}

