/*
 * Decompiled with CFR 0.152.
 */
package com.odi.util.query;

import com.odi.FatalInternalException;
import com.odi.util.CharIterator;
import com.odi.util.IndexIterator;
import com.odi.util.IndexMap;
import com.odi.util.IndexedCollection;
import com.odi.util.OSHashSet;
import com.odi.util.query.FreeVariableBindings;
import com.odi.util.query.Methods;
import com.odi.util.query.MethodsGenerator;
import com.odi.util.query.PatternMatcher;
import com.odi.util.query.PrintableNode;
import com.odi.util.query.QPT;
import com.odi.util.query.QueryEvalNode;
import com.odi.util.query.QueryEvalTree;
import com.odi.util.query.QueryException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Vector;

public final class IndexFilterEvalNode
extends QueryEvalNode {
    static final String UNBOUND_HIGH = new String("[UNBOUND_HIGH]");
    static final String UNBOUND_LOW = new String("[UNBOUND_LOW]");
    private Class elementType;
    private String indexPath;
    private QPT.Expr indexOperand;
    Vector ranges = new Vector();
    IndexMap index;
    private int fieldIndex = -1;
    Methods methods;
    QPT qpt;
    int lookups;

    String getIndexPath() {
        return this.indexPath;
    }

    public IndexFilterEvalNode(Class queryElementType, Class indexElementType, String indexPath, QPT.Expr indexOperand, QPT.Expr value, byte operation) {
        this.elementType = indexElementType;
        this.indexPath = indexPath;
        this.indexOperand = indexOperand;
        this.qpt = value.qpt();
        if (operation == 6) {
            this.ranges.addElement(new UnboundRange(value, 1));
            this.ranges.addElement(new UnboundRange(value, 2));
        } else {
            this.ranges.addElement(new UnboundRange(value, operation));
        }
        if (!indexElementType.equals(queryElementType)) {
            QPT qPT = this.qpt;
            qPT.getClass();
            int n = indexOperand.pos;
            QPT qPT2 = this.qpt;
            qPT2.getClass();
            this.retainAll(new QPT.InstanceOf(qPT, n, new QPT.ThisRef(qPT2, indexOperand.pos), queryElementType));
        }
    }

    public void addAll(IndexFilterEvalNode otherNode) {
        this.assertState((byte)1);
        otherNode.assertState((byte)1);
        if (otherNode.elementType != this.elementType || !otherNode.indexPath.equals(this.indexPath)) {
            throw new FatalInternalException("Node uses different index");
        }
        Enumeration otherRanges = otherNode.ranges.elements();
        while (otherRanges.hasMoreElements()) {
            this.ranges.addElement(otherRanges.nextElement());
        }
    }

    public void retainAll(IndexFilterEvalNode otherNode) {
        this.assertState((byte)1);
        otherNode.assertState((byte)1);
        if (otherNode.elementType != this.elementType || !otherNode.indexPath.equals(this.indexPath)) {
            throw new FatalInternalException("Node uses different index");
        }
        Vector<UnboundRange> newRanges = new Vector<UnboundRange>();
        Enumeration otherRanges = otherNode.ranges.elements();
        while (otherRanges.hasMoreElements()) {
            UnboundRange otherRange = (UnboundRange)otherRanges.nextElement();
            Enumeration rangesEnum = this.ranges.elements();
            while (rangesEnum.hasMoreElements()) {
                UnboundRange range = (UnboundRange)((UnboundRange)rangesEnum.nextElement()).clone();
                range.retainAll(otherRange);
                newRanges.addElement(range);
            }
        }
        this.ranges = newRanges;
    }

    public void retainAll(QPT.Expr value, byte operation) {
        this.assertState((byte)1);
        Enumeration rangesEnum = this.ranges.elements();
        while (rangesEnum.hasMoreElements()) {
            UnboundRange range = (UnboundRange)rangesEnum.nextElement();
            range.retainAll(value, operation);
        }
    }

    public void retainAll(QPT.Expr predicate) {
        this.assertState((byte)1);
        Enumeration rangesEnum = this.ranges.elements();
        while (rangesEnum.hasMoreElements()) {
            UnboundRange range = (UnboundRange)rangesEnum.nextElement();
            range.retainAll(predicate);
        }
    }

    public static String getPatternUpperBound(String pattern) {
        if (pattern == null) {
            return "";
        }
        String lowerBound = PatternMatcher.constantPrefix(pattern);
        StringBuffer buffer = new StringBuffer(lowerBound);
        for (int pos = buffer.length() - 1; pos >= 0; --pos) {
            char c = buffer.charAt(pos);
            if (c != '\uffff') {
                if (PatternMatcher.isCaseInsensitive(pattern)) {
                    int max = buffer.length();
                    for (int i = 0; i < max; ++i) {
                        char lower;
                        c = buffer.charAt(i);
                        char upper = Character.toUpperCase(c);
                        c = upper > (lower = Character.toLowerCase(c)) ? upper : lower;
                        buffer.setCharAt(i, c);
                    }
                }
                buffer.setCharAt(pos, (char)(c + '\u0001'));
                return buffer.toString();
            }
            buffer.setLength(pos);
        }
        return UNBOUND_HIGH;
    }

    @Override
    protected void computeMethodsInternal(MethodsGenerator generator) {
        QPT.Expr accessor;
        try {
            accessor = new QPT(this.elementType, this.indexPath, null, 2).getRoot();
            if (this.indexOperand instanceof QPT.Cast) {
                QPT.Cast castOperand = (QPT.Cast)this.indexOperand;
                QPT qPT = this.qpt;
                qPT.getClass();
                accessor = new QPT.Cast(qPT, accessor.pos, castOperand.target, accessor);
            }
        }
        catch (QueryException e) {
            throw new FatalInternalException(e.toString());
        }
        this.fieldIndex = generator.addGetField(accessor);
        Enumeration rangesEnum = this.ranges.elements();
        while (rangesEnum.hasMoreElements()) {
            UnboundRange range = (UnboundRange)rangesEnum.nextElement();
            range.computeMethods(generator);
        }
    }

    @Override
    protected QueryEvalNode bindInternal(FreeVariableBindings freeVariableBindings, Collection collection, Methods methods) {
        return new IndexFilterEvalNode(this, freeVariableBindings, collection, methods);
    }

    @Override
    protected void collectStatisticsInternal(QueryEvalTree tree) {
        tree.indexLookups += this.lookups;
    }

    @Override
    protected boolean hasFastContainsInternal() {
        return true;
    }

    @Override
    protected boolean containsInternal(Object object) {
        if (!this.elementType.isInstance(object)) {
            return false;
        }
        Object key = this.getKey(object);
        ++this.lookups;
        if (!this.index.containsKey(key)) {
            return false;
        }
        Enumeration rangesEnum = this.ranges.elements();
        while (rangesEnum.hasMoreElements()) {
            BoundRange range = (BoundRange)rangesEnum.nextElement();
            if (!range.contains(key, object)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Iterator iteratorInternal(boolean allowDuplicates) {
        return new NodeIterator();
    }

    @Override
    protected Set computeSet() {
        OSHashSet result = new OSHashSet(1);
        Iterator iterator = this.iterator(true);
        while (iterator.hasNext()) {
            result.add(iterator.next());
        }
        return result;
    }

    @Override
    protected void estimateSize() {
    }

    @Override
    protected Object pickInternal() {
        BoundRange range;
        ++this.lookups;
        if (!(this.ranges.size() != 1 || !(range = (BoundRange)this.ranges.firstElement()).lowEqualsHigh() || range.hasPredicate() && this.index.duplicates())) {
            Object value = this.index.get(range.low);
            if (value != null && range.containsValue(value)) {
                return value;
            }
            throw new NoSuchElementException();
        }
        return super.pickInternal();
    }

    @Override
    String toPrintString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("{index filter on ");
        buffer.append(this.elementType.getName()).append(".").append(this.indexPath);
        buffer.append(" for ");
        String separator = "";
        Enumeration enumerateRanges = this.ranges.elements();
        while (enumerateRanges.hasMoreElements()) {
            PrintableNode range = (PrintableNode)enumerateRanges.nextElement();
            buffer.append(separator).append(range.toPrintString());
            separator = ", ";
        }
        if (this.lookups != 0) {
            buffer.append(", lookups=").append(this.lookups);
        }
        buffer.append("}");
        return buffer.toString();
    }

    @Override
    public void print(PrintWriter out, int indentLevel) {
        String text = this.indentedString(indentLevel, this.toPrintString());
        if (text.length() <= 80) {
            out.println(text);
        } else {
            out.println(this.indentedString(indentLevel, "{index filter on " + this.elementType.getName() + "." + this.indexPath));
            out.println(this.indentedString(indentLevel, "for"));
            Enumeration enumerateRanges = this.ranges.elements();
            while (enumerateRanges.hasMoreElements()) {
                PrintableNode range = (PrintableNode)enumerateRanges.nextElement();
                range.print(out, indentLevel + 1);
            }
            if (this.lookups != 0) {
                out.println(this.indentedString(indentLevel, "lookups=" + this.lookups));
            }
            out.println(this.indentedString(indentLevel, "}"));
        }
    }

    static int compareKeys(Object key1, Object key2) {
        if (key1 == key2 || key1 != null && key1.equals(key2)) {
            return 0;
        }
        if (key1 == UNBOUND_LOW || key2 == UNBOUND_HIGH) {
            return -1;
        }
        if (key1 == UNBOUND_HIGH || key2 == UNBOUND_LOW) {
            return 1;
        }
        if (key1 == null) {
            if (!(key2 instanceof String)) {
                throw new FatalInternalException("Null in non-string query node");
            }
            return -1;
        }
        if (key2 == null) {
            if (!(key1 instanceof String)) {
                throw new FatalInternalException("Null in non-string query node");
            }
            return 1;
        }
        if (key1 instanceof String) {
            return ((String)key1).compareTo((String)key2);
        }
        if (key1 instanceof Integer) {
            return (Integer)key1 - (Integer)key2;
        }
        if (key1 instanceof Long) {
            long lkey2;
            long lkey1 = (Long)key1;
            return lkey1 < (lkey2 = ((Long)key2).longValue()) ? -1 : (lkey1 > lkey2 ? 1 : 0);
        }
        if (key1 instanceof Float) {
            float fkey2;
            float fkey1 = ((Float)key1).floatValue();
            return fkey1 < (fkey2 = ((Float)key2).floatValue()) ? -1 : (fkey1 > fkey2 ? 1 : 0);
        }
        if (key1 instanceof Double) {
            double dkey2;
            double dkey1 = (Double)key1;
            return dkey1 < (dkey2 = ((Double)key2).doubleValue()) ? -1 : (dkey1 > dkey2 ? 1 : 0);
        }
        return 1;
    }

    private IndexFilterEvalNode(IndexFilterEvalNode unbound, FreeVariableBindings freeVariableBindings, Collection collection, Methods methods) {
        this.minSize = 0;
        this.maxSize = 0x3FFFFFFF;
        this.elementType = unbound.elementType;
        this.indexPath = unbound.indexPath;
        this.indexOperand = unbound.indexOperand;
        if (!(collection instanceof IndexedCollection)) {
            throw new FatalInternalException("Collection is not indexed");
        }
        boolean needOrder = this.elementType.isPrimitive() || this.elementType == String.class;
        this.index = ((IndexedCollection)collection).getSuperIndex(this.elementType, this.indexPath, needOrder);
        if (this.index == null) {
            throw new FatalInternalException("Index not found");
        }
        this.fieldIndex = unbound.fieldIndex;
        this.methods = methods;
        this.qpt = unbound.qpt;
        Enumeration unboundRanges = unbound.ranges.elements();
        while (unboundRanges.hasMoreElements()) {
            UnboundRange range = (UnboundRange)unboundRanges.nextElement();
            this.ranges.addElement(range.bind(this));
        }
        int max = this.ranges.size();
        for (int i = 0; i < max - 1; ++i) {
            for (int j = max - 1; j > i; --j) {
                BoundRange prevRange;
                BoundRange thisRange = (BoundRange)this.ranges.elementAt(j);
                if (thisRange.compareTo(prevRange = (BoundRange)this.ranges.elementAt(j - 1)) >= 0) continue;
                this.ranges.setElementAt(thisRange, j - 1);
                this.ranges.setElementAt(prevRange, j);
            }
        }
    }

    private Object getKey(Object object) {
        return this.methods.getField(this.fieldIndex, object);
    }

    public final class NodeIterator
    implements Iterator {
        private Vector ranges;
        private IndexIterator indexIterator;
        private Object next = this;

        NodeIterator() {
            this.ranges = (Vector)IndexFilterEvalNode.this.ranges.clone();
            Object first = ((BoundRange)this.ranges.elementAt((int)0)).low;
            this.indexIterator = first == UNBOUND_LOW ? IndexFilterEvalNode.this.index.iterator() : IndexFilterEvalNode.this.index.iterator(first);
        }

        @Override
        public boolean hasNext() {
            if (this.next != this) {
                return true;
            }
            while (this.indexIterator.hasNext() && !this.ranges.isEmpty()) {
                BoundRange range;
                if (this.ranges.size() == 1 && (range = (BoundRange)this.ranges.elementAt(0)).isScannable()) {
                    if (range.scanAdvance(this.indexIterator)) {
                        Object value;
                        if (range.matchesPattern(this.indexIterator) && range.containsValue(value = this.indexIterator.currentValue())) {
                            this.next = value;
                            return true;
                        }
                    } else {
                        return false;
                    }
                }
                this.indexIterator.advance();
                ++IndexFilterEvalNode.this.lookups;
                boolean iteratorOK = false;
                for (int i = 0; i < this.ranges.size(); ++i) {
                    Object value;
                    BoundRange range2 = (BoundRange)this.ranges.elementAt(i);
                    if (range2.lowGreaterThanHigh()) {
                        this.ranges.removeElementAt(i);
                        --i;
                        continue;
                    }
                    int result = range2.compareKey(this.indexIterator);
                    if (result > 0) {
                        this.ranges.removeElementAt(i);
                        --i;
                        continue;
                    }
                    if (result < 0) {
                        if (!range2.equalsLowKey(this.indexIterator)) break;
                        iteratorOK = true;
                        break;
                    }
                    if (range2.matchesPattern(this.indexIterator) && range2.containsValue(value = this.indexIterator.currentValue())) {
                        this.next = value;
                        return true;
                    }
                    iteratorOK = true;
                }
                if (this.ranges.isEmpty()) {
                    return false;
                }
                if (iteratorOK) continue;
                BoundRange firstRange = (BoundRange)this.ranges.elementAt(0);
                this.indexIterator = IndexFilterEvalNode.this.index.iterator(firstRange.low);
            }
            return false;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No next element");
            }
            Object result = this.next;
            this.next = this;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("The remove() method is not supported on this iterator.");
        }
    }

    class BoundRange
    extends PrintableNode {
        Object low = UNBOUND_LOW;
        private Object high = UNBOUND_HIGH;
        private boolean includeLow;
        private boolean includeHigh;
        private QPT.Expr predicate;
        int predicateIndex;
        private QPT.Expr pattern;
        private PatternMatcher matcher;
        String substringToMatch;
        boolean caseInsensitive;

        BoundRange(UnboundRange unbound) {
            if (unbound.lowIndex >= 0) {
                this.low = IndexFilterEvalNode.this.methods.expression(unbound.lowIndex);
                if (unbound.lowInclusiveIndex >= 0) {
                    Object lowInclusive = IndexFilterEvalNode.this.methods.expression(unbound.lowInclusiveIndex);
                    if (this.low == null ? this.low == lowInclusive : this.low.equals(lowInclusive)) {
                        this.includeLow = true;
                    }
                }
            }
            if (unbound.highIndex >= 0) {
                this.high = IndexFilterEvalNode.this.methods.expression(unbound.highIndex);
                if (unbound.highInclusiveIndex >= 0) {
                    Object highInclusive = IndexFilterEvalNode.this.methods.expression(unbound.highInclusiveIndex);
                    if (this.high == null ? this.high == highInclusive : this.high.equals(highInclusive)) {
                        this.includeHigh = true;
                    }
                }
            }
            this.predicate = unbound.predicate;
            this.predicateIndex = unbound.predicateIndex;
            this.substringToMatch = null;
            if (unbound.patternIndex >= 0) {
                Object patternValue;
                this.pattern = unbound.pattern;
                this.matcher = new PatternMatcher((String)IndexFilterEvalNode.this.methods.expression(unbound.patternIndex));
                if (this.low != null && this.low.equals("")) {
                    this.low = UNBOUND_LOW;
                    this.includeLow = false;
                }
                if (this.high == UNBOUND_HIGH && (patternValue = IndexFilterEvalNode.this.methods.expression(unbound.patternIndex)) instanceof String) {
                    String patternStr = (String)patternValue;
                    this.substringToMatch = PatternMatcher.simpleSubstring(patternStr);
                    if (this.substringToMatch != null) {
                        this.caseInsensitive = PatternMatcher.isCaseInsensitive(patternStr);
                        if (this.caseInsensitive) {
                            this.substringToMatch = this.substringToMatch.toLowerCase();
                        }
                    }
                }
            }
        }

        boolean contains(Object key, Object value) {
            return this.compareKey(key) == 0 && this.matchesPattern(key) && this.containsValue(value);
        }

        boolean containsValue(Object value) {
            if (this.predicateIndex == -1) {
                return true;
            }
            return IndexFilterEvalNode.this.methods.predicate(this.predicateIndex, value);
        }

        boolean matchesPattern(Object key) {
            if (this.matcher == null) {
                return true;
            }
            return this.matcher.match((String)key);
        }

        boolean matchesPattern(IndexIterator iterator) {
            if (this.matcher == null) {
                return true;
            }
            CharIterator keyCharIterator = iterator.currentStringKeyCharIterator();
            if (keyCharIterator.isNull()) {
                return false;
            }
            return this.matcher.match(keyCharIterator);
        }

        boolean isScannable() {
            if (Boolean.getBoolean("com.odi.disablePatternMatchingOptimizations")) {
                return false;
            }
            return this.substringToMatch != null && this.high == UNBOUND_HIGH;
        }

        boolean scanAdvance(IndexIterator iterator) {
            return iterator.advanceToSubstringMatch(this.substringToMatch, this.caseInsensitive);
        }

        int compareKey(Object key) {
            int comparison = IndexFilterEvalNode.compareKeys(key, this.low);
            if (comparison < 0) {
                return -1;
            }
            if (comparison == 0) {
                return this.includeLow ? 0 : -1;
            }
            comparison = IndexFilterEvalNode.compareKeys(key, this.high);
            if (comparison > 0) {
                return 1;
            }
            if (comparison == 0) {
                return this.includeHigh ? 0 : 1;
            }
            return 0;
        }

        int compareKey(IndexIterator iterator) {
            int comparison;
            if (this.low != UNBOUND_LOW) {
                comparison = iterator.compareKey(this.low);
                if (comparison > 0) {
                    return -1;
                }
                if (comparison == 0) {
                    return this.includeLow ? 0 : -1;
                }
            }
            if (this.high != UNBOUND_HIGH) {
                comparison = iterator.compareKey(this.high);
                if (comparison < 0) {
                    return 1;
                }
                if (comparison == 0) {
                    return this.includeHigh ? 0 : 1;
                }
            }
            return 0;
        }

        boolean equalsLowKey(IndexIterator iterator) {
            if (this.low == UNBOUND_LOW) {
                return false;
            }
            return iterator.compareKey(this.low) == 0;
        }

        boolean lowGreaterThanHigh() {
            int comparison = IndexFilterEvalNode.compareKeys(this.low, this.high);
            if (this.low instanceof String) {
                return comparison > 0;
            }
            if (comparison > 0) {
                return true;
            }
            if (comparison == 0) {
                return !this.includeLow || !this.includeHigh;
            }
            return false;
        }

        int compareTo(BoundRange otherRange) {
            int keyValue = IndexFilterEvalNode.compareKeys(this.low, otherRange.low);
            if (keyValue != 0) {
                return keyValue;
            }
            if (this.includeLow == otherRange.includeLow) {
                return 0;
            }
            if (this.includeLow) {
                return -1;
            }
            return 1;
        }

        boolean lowEqualsHigh() {
            return IndexFilterEvalNode.compareKeys(this.low, this.high) == 0;
        }

        boolean hasPredicate() {
            return this.predicateIndex != -1;
        }

        @Override
        String toPrintString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("{");
            String separator = "";
            if (this.low != UNBOUND_LOW) {
                buffer.append(this.includeLow ? ">= " : "> ").append(this.low);
                separator = ", ";
            }
            if (this.high != UNBOUND_HIGH) {
                buffer.append(separator).append(this.includeHigh ? "<= " : "< ");
                buffer.append(this.high);
                separator = ", ";
            }
            if (this.predicate != null) {
                buffer.append(separator).append("where ").append(this.predicate);
            }
            if (this.pattern != null) {
                buffer.append(separator).append("matching ").append(this.pattern);
            }
            buffer.append("}");
            return buffer.toString();
        }

        @Override
        public void print(PrintWriter out, int indentLevel) {
            String text = this.indentedString(indentLevel, this.toPrintString());
            if (text.length() <= 80) {
                out.println(text);
            } else {
                out.println(this.indentedString(indentLevel, "{"));
                if (this.low != UNBOUND_LOW) {
                    out.println(this.indentedString(indentLevel, (this.includeLow ? ">= " : "> ") + this.low));
                }
                if (this.high != UNBOUND_HIGH) {
                    out.println(this.indentedString(indentLevel, (this.includeHigh ? "<= " : "< ") + this.high));
                }
                if (this.predicate != null) {
                    out.println(this.indentedString(indentLevel, "where"));
                    this.predicate.print(out, indentLevel + 1);
                }
                if (this.pattern != null) {
                    out.println(this.indentedString(indentLevel, "matching"));
                    this.pattern.print(out, indentLevel + 1);
                }
                out.println(this.indentedString(indentLevel, "}"));
            }
        }
    }

    final class UnboundRange
    extends PrintableNode
    implements Cloneable {
        private QPT.Expr low;
        private QPT.Expr high;
        private QPT.Expr lowInclusive;
        private QPT.Expr highInclusive;
        QPT.Expr predicate;
        QPT.Expr pattern;
        int lowIndex = -1;
        int highIndex = -1;
        int lowInclusiveIndex = -1;
        int highInclusiveIndex = -1;
        int predicateIndex = -1;
        int patternIndex = -1;

        UnboundRange(QPT.Expr value, byte operation) {
            switch (operation) {
                case 3: {
                    this.high = this.highInclusive = value;
                    break;
                }
                case 1: {
                    this.high = value;
                    break;
                }
                case 4: {
                    this.low = this.lowInclusive = value;
                }
                case 2: {
                    this.low = value;
                    break;
                }
                case 5: {
                    this.low = this.lowInclusive = value;
                    this.high = this.highInclusive = value;
                    break;
                }
                case 23: {
                    this.pattern = value;
                    Vector<QPT.Expr> args = new Vector<QPT.Expr>();
                    args.addElement(value);
                    QPT qPT = IndexFilterEvalNode.this.qpt;
                    qPT.getClass();
                    this.lowInclusive = this.low = new QPT.MethodSelect(qPT, -1, PatternMatcher.class, "constantPrefix", args).getFoldedExpr();
                    QPT qPT2 = IndexFilterEvalNode.this.qpt;
                    qPT2.getClass();
                    this.high = new QPT.MethodSelect(qPT2, -1, IndexFilterEvalNode.class, "getPatternUpperBound", args).getFoldedExpr();
                    break;
                }
                default: {
                    throw new FatalInternalException("Bad operation: " + operation);
                }
            }
        }

        void retainAll(UnboundRange other) {
            if (other.low != null) {
                this.low = this.createMax(this.low, other.low);
            }
            if (other.lowInclusive != null) {
                this.lowInclusive = this.createMax(this.lowInclusive, other.lowInclusive);
            }
            if (other.high != null) {
                this.high = this.createMin(this.high, other.high);
            }
            if (other.highInclusive != null) {
                this.highInclusive = this.createMin(this.highInclusive, other.highInclusive);
            }
            if (other.predicate != null) {
                this.retainAll(other.predicate);
            }
            if (other.pattern != null) {
                this.retainAllPattern(other.pattern);
            }
        }

        void retainAll(QPT.Expr value, byte operation) {
            switch (operation) {
                case 3: {
                    this.highInclusive = this.createMin(this.highInclusive, value);
                }
                case 1: {
                    this.high = this.createMin(this.high, value);
                    break;
                }
                case 4: {
                    this.lowInclusive = this.createMax(this.lowInclusive, value);
                }
                case 2: {
                    this.low = this.createMax(this.low, value);
                    break;
                }
                case 23: {
                    this.retainAllPattern(value);
                    Vector<QPT.Expr> args = new Vector<QPT.Expr>();
                    args.addElement(value);
                    QPT qPT = IndexFilterEvalNode.this.qpt;
                    qPT.getClass();
                    QPT.MethodSelect addedLowInclusive = new QPT.MethodSelect(qPT, -1, PatternMatcher.class, "constantPrefix", args);
                    this.lowInclusive = this.createMax(this.lowInclusive, addedLowInclusive);
                    this.low = this.createMax(this.low, addedLowInclusive);
                    QPT qPT2 = IndexFilterEvalNode.this.qpt;
                    qPT2.getClass();
                    this.high = this.createMin(this.high, new QPT.MethodSelect(qPT2, -1, IndexFilterEvalNode.class, "getPatternUpperBound", args));
                    break;
                }
                default: {
                    throw new FatalInternalException("Bad operation: " + operation);
                }
            }
        }

        void retainAll(QPT.Expr otherPredicate) {
            if (this.predicate == null) {
                this.predicate = otherPredicate;
            } else {
                Vector<QPT.Expr> ops = new Vector<QPT.Expr>();
                ops.addElement(this.predicate);
                ops.addElement(otherPredicate);
                QPT qPT = otherPredicate.qpt();
                qPT.getClass();
                this.predicate = new QPT.ConditionalAndOr(qPT, -1, 7, ops);
            }
        }

        void retainAllPattern(QPT.Expr otherPattern) {
            if (this.pattern == null) {
                this.pattern = otherPattern;
            } else {
                QPT qPT = otherPattern.qpt();
                qPT.getClass();
                this.retainAll(new QPT.PatternMatch(qPT, -1, IndexFilterEvalNode.this.indexOperand, otherPattern));
            }
        }

        void computeMethods(MethodsGenerator generator) {
            if (this.predicate != null) {
                this.predicateIndex = generator.addPredicate(this.predicate);
            }
            if (this.pattern != null) {
                this.patternIndex = generator.addExpression(this.pattern);
            }
            if (this.low != null) {
                this.lowIndex = generator.addExpression(this.low);
            }
            if (this.lowInclusive != null) {
                this.lowInclusiveIndex = generator.addExpression(this.lowInclusive);
            }
            if (this.high != null) {
                this.highIndex = generator.addExpression(this.high);
            }
            if (this.highInclusive != null) {
                this.highInclusiveIndex = generator.addExpression(this.highInclusive);
            }
        }

        BoundRange bind(IndexFilterEvalNode parent) {
            IndexFilterEvalNode indexFilterEvalNode = parent;
            indexFilterEvalNode.getClass();
            return indexFilterEvalNode.new BoundRange(this);
        }

        @Override
        String toPrintString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("{");
            String separator = "";
            if (this.low != null) {
                buffer.append("> ").append(this.low);
                separator = ", ";
            }
            if (this.lowInclusive != null) {
                buffer.append(separator).append(">= ").append(this.lowInclusive);
                separator = ", ";
            }
            if (this.high != null) {
                buffer.append(separator).append("< ").append(this.high);
                separator = ", ";
            }
            if (this.highInclusive != null) {
                buffer.append(separator).append("<= ").append(this.highInclusive);
                separator = ", ";
            }
            if (this.predicate != null) {
                buffer.append(separator).append("where ").append(this.predicate);
            }
            if (this.pattern != null) {
                buffer.append(separator).append("matching ").append(this.pattern);
            }
            buffer.append("}");
            return buffer.toString();
        }

        @Override
        public void print(PrintWriter out, int indentLevel) {
            String text = this.indentedString(indentLevel, this.toPrintString());
            if (text.length() <= 80) {
                out.println(text);
            } else {
                out.println(this.indentedString(indentLevel, "{"));
                if (this.low != null) {
                    out.println(this.indentedString(indentLevel, "> "));
                    this.low.print(out, indentLevel + 1);
                }
                if (this.lowInclusive != null) {
                    out.println(this.indentedString(indentLevel, ">= "));
                    this.lowInclusive.print(out, indentLevel + 1);
                }
                if (this.high != null) {
                    out.println(this.indentedString(indentLevel, "< "));
                    this.high.print(out, indentLevel + 1);
                }
                if (this.highInclusive != null) {
                    out.println(this.indentedString(indentLevel, "<= "));
                    this.highInclusive.print(out, indentLevel + 1);
                }
                if (this.predicate != null) {
                    out.println(this.indentedString(indentLevel, "where "));
                    this.predicate.print(out, indentLevel + 1);
                }
                if (this.pattern != null) {
                    out.println(this.indentedString(indentLevel, "matching "));
                    this.pattern.print(out, indentLevel + 1);
                }
                out.println(this.indentedString(indentLevel, "}"));
            }
        }

        private QPT.Expr createMin(QPT.Expr x, QPT.Expr y) {
            if (x == null) {
                return y;
            }
            QPT qPT = IndexFilterEvalNode.this.qpt;
            qPT.getClass();
            return new QPT.MinOrMax(qPT, -1, 21, x, y).getFoldedExpr();
        }

        private QPT.Expr createMax(QPT.Expr x, QPT.Expr y) {
            if (x == null) {
                return y;
            }
            QPT qPT = IndexFilterEvalNode.this.qpt;
            qPT.getClass();
            return new QPT.MinOrMax(qPT, -1, 22, x, y).getFoldedExpr();
        }

        public synchronized Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new FatalInternalException("Attempt to clone Methods failed");
            }
        }
    }
}

