/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.agent;

import com.sonicsw.mf.common.runtime.IComponentIdentity;
import com.sonicsw.mf.common.runtime.IComponentState;
import com.sonicsw.mf.framework.agent.Agent;
import com.sonicsw.mf.framework.agent.AgentStrings;
import com.sonicsw.mx.util.CLI;
import com.sonicsw.mx.util.IEmptyArray;
import com.sonicsw.mx.util.Sorter;
import java.lang.reflect.Method;
import java.util.Hashtable;

public class AgentCLI
extends CLI {
    private static volatile Agent m_agent;

    public static void init(Agent agent) throws NoSuchMethodException {
        m_agent = agent;
        AgentCLI.setPrompt((String)(m_agent.getContainerName() + "> "));
    }

    public static String shutdown() {
        SHOW_PROMPT = false;
        m_agent.shutdown();
        return null;
    }

    public static String shutdownHelp() {
        return AgentStrings.m_shutdownHelp;
    }

    public static String restart() throws Exception {
        SHOW_PROMPT = false;
        m_agent.restart();
        return null;
    }

    public static String restartHelp() {
        return AgentStrings.m_restartHelp;
    }

    public static String reloadComponent(String ID) throws Exception {
        if (ID == null || ID.length() == 0) {
            return AgentCLI.reloadComponentHelp();
        }
        m_agent.reloadComponent(ID);
        return null;
    }

    public static String reloadComponentHelp() {
        return AgentStrings.m_reloadComponentHelp;
    }

    public static String resumeLogging() {
        m_agent.setLogToConsole(Boolean.TRUE);
        return null;
    }

    public static String resumeLoggingHelp() {
        return AgentStrings.m_resumeLoggingHelp;
    }

    public static String pauseLogging() {
        m_agent.setLogToConsole(Boolean.FALSE);
        return null;
    }

    public static String pauseLoggingHelp() {
        return AgentStrings.m_pauseLoggingHelp;
    }

    public static String showStatus() throws Exception {
        String fullStatusString = "";
        int largestName = 0;
        Hashtable<String, CharSequence> statusStrings = new Hashtable<String, CharSequence>(20);
        IComponentState[] components = m_agent.getContainerState().getComponentStates();
        Object[] componentNames = new String[components.length];
        for (int i = 0; i < components.length; ++i) {
            IComponentIdentity identity = (IComponentIdentity)components[i].getRuntimeIdentity();
            try {
                Object[] attributeValues = m_agent.getAttributeValues(identity.getCanonicalName(), new String[]{"ConfigID", "StateString", "LastErrorLevelString", "Uptime"});
                String componentName = identity.getComponentName();
                StringBuffer statusString = new StringBuffer();
                statusString.append('[');
                statusString.append(attributeValues[0]);
                statusString.append(", ");
                statusString.append(attributeValues[1]);
                statusString.append(", ");
                statusString.append(attributeValues[2]);
                statusString.append(", ");
                statusString.append(AgentCLI.formatUptimeString((Long)attributeValues[3]));
                statusString.append(']');
                statusStrings.put(componentName, statusString);
                statusStrings.put(componentName, statusString.toString());
                componentNames[i] = componentName;
                if (componentName.length() <= largestName) continue;
                largestName = componentName.length();
                continue;
            }
            catch (Exception e) {
                System.out.println("Problem with " + identity.getCanonicalName());
                e.printStackTrace();
            }
        }
        Object[] cNames = Sorter.sort((Object[])componentNames);
        for (int index = 0; index < cNames.length; ++index) {
            Object cName = componentNames[index];
            fullStatusString = fullStatusString + (String)cName;
            for (int spacing = largestName + 1; spacing > ((String)cName).length(); --spacing) {
                fullStatusString = fullStatusString + " ";
            }
            fullStatusString = fullStatusString + (String)statusStrings.get(componentNames[index]);
            if (index >= cNames.length - 1) continue;
            fullStatusString = fullStatusString + "\n";
        }
        return fullStatusString;
    }

    public static String showStatusHelp() {
        return AgentStrings.m_showStatusHelp;
    }

    public static String ping(String containerName, String timeoutString) {
        if (containerName == null || containerName.length() == 0) {
            return AgentCLI.pingHelp();
        }
        long timeout = 0L;
        if (timeoutString != null && timeoutString.length() > 0) {
            try {
                timeout = Long.parseLong(timeoutString) * 1000L;
                if (timeout <= 0L) {
                    return AgentCLI.pingHelp();
                }
            }
            catch (Exception e) {
                return AgentCLI.pingHelp();
            }
        }
        return m_agent.remotePing(containerName, timeout);
    }

    public static String pingHelp() {
        return AgentStrings.m_pingHelp;
    }

    public static String startComponent(String ID) throws Exception {
        if (ID == null || ID.length() == 0) {
            return AgentCLI.startComponentHelp();
        }
        m_agent.startComponent(ID);
        return null;
    }

    public static String startComponentHelp() {
        return AgentStrings.m_startComponentHelp;
    }

    public static String stopComponent(String ID) throws Exception {
        if (ID == null || ID.length() == 0) {
            return AgentCLI.stopComponentHelp();
        }
        m_agent.stopComponent(ID);
        return null;
    }

    public static String stopComponentHelp() {
        return AgentStrings.m_stopComponentHelp;
    }

    public static String clearError(String ID) throws Exception {
        if (ID == null || ID.length() == 0) {
            return AgentCLI.clearErrorHelp();
        }
        m_agent.clearError(ID);
        return null;
    }

    public static String clearErrorHelp() {
        return AgentStrings.m_clearErrorHelp;
    }

    private static String formatUptimeString(long milli) {
        String uptime = "";
        int hours = (int)(milli / 3600000L);
        uptime = hours < 10 ? uptime + "0" + hours : uptime + hours;
        uptime = uptime + ":";
        int minutes = (int)(milli % 3600000L) / 60000;
        uptime = minutes < 10 ? uptime + "0" + minutes : uptime + minutes;
        uptime = uptime + ":";
        int seconds = (int)(milli % 3600000L) % 60000 / 1000;
        uptime = seconds < 10 ? uptime + "0" + seconds : uptime + seconds;
        return uptime;
    }

    static {
        m_cliClassObject = AgentCLI.class;
        try {
            AgentCLI.addCommand((String)"shutdown", (Method)m_cliClassObject.getDeclaredMethod("shutdown", IEmptyArray.EMPTY_CLASS_ARRAY), (Method)m_cliClassObject.getDeclaredMethod("shutdownHelp", IEmptyArray.EMPTY_CLASS_ARRAY));
            AgentCLI.addCommand((String)"restart", (Method)m_cliClassObject.getDeclaredMethod("restart", IEmptyArray.EMPTY_CLASS_ARRAY), (Method)m_cliClassObject.getDeclaredMethod("restartHelp", IEmptyArray.EMPTY_CLASS_ARRAY));
            AgentCLI.addCommand((String)"reload", (Method)m_cliClassObject.getDeclaredMethod("reloadComponent", String.class), (Method)m_cliClassObject.getDeclaredMethod("reloadComponentHelp", IEmptyArray.EMPTY_CLASS_ARRAY));
            AgentCLI.addCommand((String)"start", (Method)m_cliClassObject.getDeclaredMethod("startComponent", String.class), (Method)m_cliClassObject.getDeclaredMethod("startComponentHelp", IEmptyArray.EMPTY_CLASS_ARRAY));
            AgentCLI.addCommand((String)"stop", (Method)m_cliClassObject.getDeclaredMethod("stopComponent", String.class), (Method)m_cliClassObject.getDeclaredMethod("stopComponentHelp", IEmptyArray.EMPTY_CLASS_ARRAY));
            AgentCLI.addCommand((String)"clearError", (Method)m_cliClassObject.getDeclaredMethod("clearError", String.class), (Method)m_cliClassObject.getDeclaredMethod("clearErrorHelp", IEmptyArray.EMPTY_CLASS_ARRAY));
            AgentCLI.addCommand((String)"resume logging", (Method)m_cliClassObject.getDeclaredMethod("resumeLogging", IEmptyArray.EMPTY_CLASS_ARRAY), (Method)m_cliClassObject.getDeclaredMethod("resumeLoggingHelp", IEmptyArray.EMPTY_CLASS_ARRAY));
            AgentCLI.addCommand((String)"pause logging", (Method)m_cliClassObject.getDeclaredMethod("pauseLogging", IEmptyArray.EMPTY_CLASS_ARRAY), (Method)m_cliClassObject.getDeclaredMethod("pauseLoggingHelp", IEmptyArray.EMPTY_CLASS_ARRAY));
            AgentCLI.addCommand((String)">", (Method)m_cliClassObject.getDeclaredMethod("resumeLogging", IEmptyArray.EMPTY_CLASS_ARRAY), (Method)m_cliClassObject.getDeclaredMethod("resumeLoggingHelp", IEmptyArray.EMPTY_CLASS_ARRAY));
            AgentCLI.addCommand((String)"<", (Method)m_cliClassObject.getDeclaredMethod("pauseLogging", IEmptyArray.EMPTY_CLASS_ARRAY), (Method)m_cliClassObject.getDeclaredMethod("pauseLoggingHelp", IEmptyArray.EMPTY_CLASS_ARRAY));
            AgentCLI.addCommand((String)"show status", (Method)m_cliClassObject.getDeclaredMethod("showStatus", IEmptyArray.EMPTY_CLASS_ARRAY), (Method)m_cliClassObject.getDeclaredMethod("showStatusHelp", IEmptyArray.EMPTY_CLASS_ARRAY));
            AgentCLI.addCommand((String)"ping", (Method)m_cliClassObject.getDeclaredMethod("ping", String.class, String.class), (Method)m_cliClassObject.getDeclaredMethod("pingHelp", IEmptyArray.EMPTY_CLASS_ARRAY));
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }
}

