/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.agent;

import com.sonicsw.mf.common.IComponentContext;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.framework.agent.Agent;

public class ContainerStateNotifier
extends Thread {
    private Agent m_agent;
    private IComponentContext m_context;
    private long m_notificationInterval;
    private boolean m_run = true;
    private boolean DEBUG = false;
    private boolean DEBUG_THREADS = false;

    public ContainerStateNotifier(Agent agent, IComponentContext context) {
        super("Container State Notifier");
        this.setDaemon(true);
        this.m_agent = agent;
        this.m_context = context;
        this.m_notificationInterval = this.getInitialNotificationInterval();
        if (this.DEBUG) {
            System.out.println("ContainerStateNotifier: m_notificationInterval = " + this.m_notificationInterval);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.m_run) {
            if (this.m_notificationInterval > 0L) {
                this.m_agent.sendContainerStateNotification();
                if (this.DEBUG_THREADS) {
                    System.out.println("ContainerStateNotifier: sent container state notification...");
                }
            }
            ContainerStateNotifier containerStateNotifier = this;
            synchronized (containerStateNotifier) {
                block8: {
                    try {
                        this.wait(this.m_notificationInterval);
                    }
                    catch (InterruptedException ie) {
                        if (!this.DEBUG_THREADS) break block8;
                        System.out.println("ContainerStateNotifier.run: notification thread interrupted during wait(interval)...");
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void cleanup() {
        this.m_run = false;
        ContainerStateNotifier containerStateNotifier = this;
        synchronized (containerStateNotifier) {
            this.notifyAll();
        }
    }

    private long getInitialNotificationInterval() {
        long notificationInterval;
        block8: {
            notificationInterval = 48000L;
            try {
                IElement containerConfig = this.m_context.getConfiguration(true);
                if (containerConfig == null) {
                    return notificationInterval;
                }
                IAttributeSet monitoringAttrs = (IAttributeSet)containerConfig.getAttributes().getAttribute("MONITORING");
                if (monitoringAttrs != null) {
                    Integer pollInterval = (Integer)monitoringAttrs.getAttribute("STATUS_POLL_INTERVAL");
                    if (this.DEBUG) {
                        System.out.println("ContainerStateNotifier: pollInterval = " + pollInterval);
                    }
                    if (pollInterval != null) {
                        if (this.DEBUG) {
                            System.out.println("ContainerStateNotifier: poll interval value = " + pollInterval.longValue());
                        }
                        notificationInterval = pollInterval.longValue() * 800L;
                    }
                }
            }
            catch (Exception e) {
                if (!this.DEBUG) break block8;
                System.out.println("ContainerStateNotifier.getNotificationInterval: exception while retrieving polling interval, e = " + e.getMessage());
            }
        }
        if (this.DEBUG) {
            System.out.println("ContainerStateNotifier: return notification interval = " + notificationInterval);
        }
        return notificationInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setNotificationInterval(long notificationInterval) {
        if (this.DEBUG) {
            System.out.println("ContainerStateNotifier.setNotificationInterval: old notification interval = " + this.m_notificationInterval + ", new notification interval = " + notificationInterval);
        }
        ContainerStateNotifier containerStateNotifier = this;
        synchronized (containerStateNotifier) {
            this.m_notificationInterval = notificationInterval;
            this.notifyAll();
        }
    }

    long getNotificationInterval() {
        return this.m_notificationInterval;
    }
}

