/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.agent;

import com.sonicsw.mf.common.config.IBlob;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.runtime.IFileDescriptor;
import com.sonicsw.mf.common.runtime.IRemoteCallResult;
import com.sonicsw.mf.common.runtime.IRemoteExecResult;
import com.sonicsw.mf.common.runtime.impl.ExecUtility;
import com.sonicsw.mf.common.runtime.impl.FileDescriptor;
import com.sonicsw.mf.common.runtime.impl.RemoteCallResult;
import com.sonicsw.mf.common.runtime.impl.RemoteCallResultWithData;
import com.sonicsw.mf.common.util.ZipSerializer;
import com.sonicsw.mf.framework.IContainer;
import com.sonicsw.mf.framework.IHostManager;
import com.sonicsw.mf.framework.agent.Agent;
import com.sonicsw.mf.framework.agent.ContainerDS;
import com.sonicsw.mf.framework.agent.ContainerImpl;
import com.sonicsw.mf.framework.agent.ContainerSetup;
import com.sonicsw.mf.framework.agent.ContainerUtil;
import com.sonicsw.mf.framework.agent.ci.LauncherContainerDriver;
import com.sonicsw.mf.framework.agent.ci.LauncherFilesInstaller;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Set;
import progress.message.net.ProgressInetAddress;

class HostManager
implements IHostManager {
    private static final String SONICSW_MF_HM_HOSTNAMES_PROPERTY = "sonicsw.mf.hm.hostnames";
    private static final File SONIC_CONTAINERS_DIR = new File(System.getProperty("sonicsw.mf.containers_directory"));
    private static final String LAUNCH_CONTAINER_SCRIPT = "launchcontainer";
    private static final String CONTAINER_LAUNCH_FAILED_TEXT = "com.sonicsw.mf.framework.agent.HostManager.launchContainer failed: ";
    private static final String LOG_EXIT_TEXT = "Exiting...";
    private static final String FILELOG_SUFFIX = ".log";
    private final ContainerDS m_directory;
    private final String m_containerCanonicalName;
    private final String m_domainName;
    private final ContainerImpl m_containerImpl;

    HostManager(String domainName, String containerCanonicalName, ContainerImpl containerImpl) {
        this.m_containerImpl = containerImpl;
        this.m_directory = this.m_containerImpl.getDS();
        this.m_domainName = domainName;
        this.m_containerCanonicalName = containerCanonicalName;
    }

    @Override
    public IRemoteCallResult installLauncher(String targetSonicHome) {
        if (IContainer.CURRENT_LAUNCHER_VERSION == null) {
            return new RemoteCallResult(false, "com.sonicsw.mf.framework.agent.HostManager.installLauncher failed: This container was not started from launcher install");
        }
        try {
            new LauncherFilesInstaller().installLauncherFiles(new File(System.getProperty("sonicsw.mf.container_archive_root")), new File(targetSonicHome));
            return new RemoteCallResult(true, null);
        }
        catch (Throwable t) {
            return new RemoteCallResult(false, ContainerUtil.printStackTrace(t, "com.sonicsw.mf.framework.agent.HostManager.installLauncher failed:"));
        }
    }

    @Override
    public IRemoteCallResult setupContainer(String containerDSPath, Properties unconfiguredProps, String INIEncryptionPassword) {
        if (IContainer.CURRENT_LAUNCHER_VERSION == null) {
            return new RemoteCallResult(false, "com.sonicsw.mf.framework.agent.HostManager.setupContainer failed: This container was not started from launcher install");
        }
        try {
            File launcherFilesPath = new File(Agent.SONICSW_HOME, IContainer.LAUNCHER_DIR);
            IElement containerConfig = this.m_directory.getElementByLogicalName(this.m_containerCanonicalName, containerDSPath);
            File destDir = ContainerSetup.setupContainer(containerDSPath, containerConfig, launcherFilesPath.getAbsolutePath(), unconfiguredProps, null, INIEncryptionPassword);
            return new RemoteCallResult(true, destDir.getCanonicalPath());
        }
        catch (Throwable t) {
            return new RemoteCallResult(false, ContainerUtil.printStackTrace(t, "com.sonicsw.mf.framework.agent.HostManager.setupContainer failed:"));
        }
    }

    @Override
    public IRemoteCallResult setupContainer(Properties properties, String INIEncryptionPassword) {
        return this.setupContainerInternal(Agent.SONICSW_HOME, IContainer.LAUNCHER_DIR, properties, INIEncryptionPassword);
    }

    @Override
    public IRemoteCallResult setupContainer(String sonicHome, String launcherVesrion, Properties properties, String INIEncryptionPassword) {
        String launcherDirectory = launcherVesrion != null ? "Launcher/" + launcherVesrion : IContainer.LAUNCHER_DIR;
        return this.setupContainerInternal(sonicHome, launcherDirectory, properties, INIEncryptionPassword);
    }

    private IRemoteCallResult setupContainerInternal(String sonicHome, String launcherDirectory, Properties properties, String INIEncryptionPassword) {
        if (IContainer.CURRENT_LAUNCHER_VERSION == null) {
            return new RemoteCallResult(false, "com.sonicsw.mf.framework.agent.HostManager.setupContainer failed: This container was not started from launcher install");
        }
        try {
            File launcherFilesPath = new File(sonicHome, launcherDirectory);
            File destDir = ContainerSetup.setupContainer(launcherFilesPath.getAbsolutePath(), properties, INIEncryptionPassword);
            return new RemoteCallResult(true, destDir.getCanonicalPath());
        }
        catch (Throwable t) {
            return new RemoteCallResult(false, ContainerUtil.printStackTrace(t, "com.sonicsw.mf.framework.agent.HostManager.setupContainer failed:"));
        }
    }

    @Override
    public IRemoteCallResult deleteFiles(String pathOfdirectoryOrFile, Boolean deleteContent0) {
        boolean deleteContent;
        File fileToDelete = new File(pathOfdirectoryOrFile);
        boolean bl = deleteContent = deleteContent0 != null && deleteContent0 != false;
        if (!fileToDelete.exists()) {
            return new RemoteCallResult(true, null);
        }
        if (!deleteContent && fileToDelete.isDirectory() && fileToDelete.listFiles().length > 0) {
            return new RemoteCallResult(false, fileToDelete.getAbsolutePath() + " is not empty");
        }
        if (this.deleteFile(fileToDelete)) {
            return new RemoteCallResult(true, null);
        }
        return new RemoteCallResult(false, "Failed to delete " + fileToDelete.getAbsolutePath());
    }

    @Override
    public IRemoteCallResult launchContainer(String containerName, Boolean launchAsWindowsService) {
        return this.launchContainerInternal(SONIC_CONTAINERS_DIR, containerName, launchAsWindowsService);
    }

    @Override
    public IRemoteCallResult launchContainer(String sonicHome, String containerName, Boolean launchAsWindowsService) {
        try {
            return this.launchContainerInternal(ContainerSetup.findSonicContainersDir(new File(sonicHome)), containerName, launchAsWindowsService);
        }
        catch (Throwable t) {
            return new RemoteCallResult(false, ContainerUtil.printStackTrace(t, "com.sonicsw.mf.framework.agent.HostManager.launchContainer failed:"));
        }
    }

    private IRemoteCallResult launchContainerInternal(File containersDir, String containerName, Boolean launchAsWindowsService0) {
        boolean launchAsWindowsService = launchAsWindowsService0 == null ? false : launchAsWindowsService0;
        File workingDir = new File(containersDir, this.m_domainName + "." + containerName);
        if (!workingDir.exists() || !workingDir.isDirectory()) {
            return new RemoteCallResult(false, workingDir.getAbsolutePath() + " does not exist");
        }
        if (!workingDir.isDirectory()) {
            return new RemoteCallResult(false, workingDir.getAbsolutePath() + " is not a directory");
        }
        File launchScript = null;
        String outputFileName = "/dev/null";
        if (launchAsWindowsService) {
            if (!ContainerSetup.ON_WINDOWS) {
                return new RemoteCallResult(false, "The container can be launched as a Windows Service on Windows only");
            }
            launchScript = new File(workingDir, "winservice.bat");
        } else if (ContainerSetup.ON_WINDOWS) {
            launchScript = new File(workingDir, "launchcontainer.bat");
        } else {
            launchScript = new File(workingDir, "launchcontainer_batch.sh");
            if (!Boolean.getBoolean("sonic.mf.no_batch_output")) {
                outputFileName = new File(workingDir, containerName + ".out").getAbsolutePath();
            }
        }
        if (!launchScript.exists()) {
            return new RemoteCallResult(false, launchScript.getAbsolutePath() + " does not exist");
        }
        ArrayList<String> exeCmd = new ArrayList<String>();
        if (launchAsWindowsService) {
            exeCmd.add("cmd.exe");
            exeCmd.add("/C");
            exeCmd.add("\"" + launchScript.getAbsolutePath() + "\"");
            exeCmd.add("/start");
        } else if (ContainerSetup.ON_WINDOWS) {
            exeCmd.add("cmd.exe");
            exeCmd.add("/C");
            exeCmd.add("start");
            exeCmd.add("cmd.exe");
            exeCmd.add("/C");
            exeCmd.add("\"" + launchScript.getAbsolutePath() + "\"");
        } else {
            exeCmd.add(launchScript.getAbsolutePath());
            exeCmd.add(outputFileName);
        }
        IRemoteExecResult result = this.remoteExec(exeCmd.toArray(new String[exeCmd.size()]), null, workingDir.getAbsolutePath(), null);
        if (!result.isSuccessful()) {
            return new RemoteCallResult(false, CONTAINER_LAUNCH_FAILED_TEXT + result.getOutput());
        }
        if (result.getExitCode() != 0) {
            return new RemoteCallResult(false, CONTAINER_LAUNCH_FAILED_TEXT + ExecUtility.execResultOutputToString((IRemoteExecResult)result));
        }
        return new RemoteCallResult(true, null);
    }

    @Override
    public IRemoteCallResult removeContainer(String containerName) {
        boolean ok;
        String logNameBasename;
        String fullContainerName = this.m_domainName + "." + containerName;
        File workingDir = new File(SONIC_CONTAINERS_DIR, fullContainerName);
        File logDir = this.getContainerLogDirectory(workingDir, logNameBasename = fullContainerName + FILELOG_SUFFIX);
        if (!logDir.isAbsolute()) {
            logDir = new File(workingDir, logDir.getPath());
        }
        File logFile = new File(logDir, logNameBasename);
        StringBuilder output = new StringBuilder();
        try {
            LauncherContainerDriver.shutdownLocalContainer((File)workingDir, (boolean)true, (boolean)true);
        }
        catch (Exception e) {
            return new RemoteCallResult(false, "com.sonicsw.mf.framework.agent.HostManager.removeContainer failed in shutdownLocalContainer: " + e.toString());
        }
        if (ContainerSetup.ON_WINDOWS) {
            String winserviceScriptName = new File(workingDir, "winservice.bat").getAbsolutePath();
            String[] waitCmd = new String[]{winserviceScriptName, "/wait_for_stop"};
            this.remoteExec(waitCmd, null, workingDir.getAbsolutePath(), null);
            String[] removeCmd = new String[]{winserviceScriptName, "/remove"};
            IRemoteExecResult removeResult = this.remoteExec(removeCmd, null, workingDir.getAbsolutePath(), null);
            if (removeResult.isSuccessful()) {
                output.append(new String(removeResult.getProcessStdOutput()));
            } else {
                output.append("winserve /remove failed with:\n");
                output.append(removeResult.getOutput());
                output.append('\n');
            }
        }
        if (!(ok = this.deleteFile(workingDir))) {
            output.append("Failed to delete directory \"" + workingDir.getAbsolutePath() + "\"");
        }
        return new RemoteCallResult(ok, output.length() > 0 ? output.toString() : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getContainerLogDirectory(File workingDir, String logNameBasename) {
        File logDir = null;
        File logLocationFile = new File(workingDir, "log_location");
        if (logLocationFile.exists()) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(logLocationFile)));){
                String line = reader.readLine();
                if (line != null && (line = line.trim()).length() > 0) {
                    logDir = new File(line);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (logDir == null) {
            logDir = new File(workingDir, logNameBasename);
        }
        return logDir;
    }

    @Override
    public Properties getJVMProperties() {
        return System.getProperties();
    }

    @Override
    public IRemoteCallResult bytesToFile(byte[] src, String destinationFilePath, Boolean rewriteIfExists0) {
        boolean rewriteIfExists = rewriteIfExists0 == null ? false : rewriteIfExists0;
        try {
            File destinationFile = new File(destinationFilePath);
            if (destinationFile.exists() && !rewriteIfExists) {
                return new RemoteCallResult(false, "com.sonicsw.mf.framework.agent.HostManager.bytesToFile failed: " + destinationFilePath + " already exists");
            }
            if (destinationFile.exists()) {
                this.deleteObsolete(destinationFile);
                if (destinationFile.exists()) {
                    return new RemoteCallResult(false, "com.sonicsw.mf.framework.agent.HostManager.bytesToFile failed: Could not delete" + destinationFilePath);
                }
            }
            new ZipSerializer(destinationFile.getParentFile()).expandZipFromBytes(src, destinationFile.getName());
            return new RemoteCallResult(true, null);
        }
        catch (Throwable t) {
            return new RemoteCallResult(false, ContainerUtil.printStackTrace(t, "com.sonicsw.mf.framework.agent.HostManager.bytesToFile failed to unzip into \"" + destinationFilePath + "\":"));
        }
    }

    @Override
    public RemoteCallResultWithData fileToBytes(String srcFilePath) {
        try {
            File srcFile = new File(srcFilePath);
            if (!srcFile.exists()) {
                return new RemoteCallResultWithData(false, "com.sonicsw.mf.framework.agent.HostManager.fileToBytes failed: " + srcFilePath + " does not exist", null);
            }
            byte[] zipBytes = new ZipSerializer(srcFile.getParentFile()).zipFileOrDir(srcFile.getName());
            return new RemoteCallResultWithData(true, null, (Object)zipBytes);
        }
        catch (Throwable t) {
            return new RemoteCallResultWithData(false, ContainerUtil.printStackTrace(t, "com.sonicsw.mf.framework.agent.HostManager.fileToBytes failed to zip \"" + srcFilePath + "\":"), null);
        }
    }

    @Override
    public IRemoteCallResult downloadFileFromDS(String dsFilePath, String destinationFilePath, Boolean rewriteIfExists0, Boolean expandZip0) {
        boolean rewriteIfExists;
        boolean expandZip = expandZip0 == null ? false : expandZip0;
        boolean bl = rewriteIfExists = rewriteIfExists0 == null ? false : rewriteIfExists0;
        if (expandZip) {
            return this.downloadAndExpand(dsFilePath, destinationFilePath, rewriteIfExists);
        }
        return this.downloadToFile(dsFilePath, destinationFilePath, rewriteIfExists);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRemoteCallResult downloadAndExpand(String dsFilePath, String destinationPath, boolean rewriteIfExists) {
        File destinationFile = new File(destinationPath);
        if (destinationFile.exists()) {
            if (!rewriteIfExists) {
                return new RemoteCallResult(false, "com.sonicsw.mf.framework.agent.HostManager.downloadFileFromDS failed: " + destinationPath + " already exists");
            }
            this.deleteObsolete(destinationFile);
            if (destinationFile.exists()) {
                return new RemoteCallResult(false, "com.sonicsw.mf.framework.agent.HostManager.downloadFileFromDS failed: Could not delete" + destinationPath);
            }
        }
        File absolutePathFile = new File(destinationFile.getAbsolutePath());
        File hostDir = absolutePathFile.getParentFile();
        String fileName = absolutePathFile.getName();
        File tmpDownloadFile = new File(hostDir, fileName + ".tmp");
        tmpDownloadFile.delete();
        IRemoteCallResult result = this.downloadFileFromDSInternal(dsFilePath, tmpDownloadFile);
        if (!result.isSuccessful()) {
            return result;
        }
        try {
            new ZipSerializer(hostDir).expandZip(tmpDownloadFile, destinationFile);
        }
        catch (Throwable t) {
            RemoteCallResult remoteCallResult = new RemoteCallResult(false, ContainerUtil.printStackTrace(t, "com.sonicsw.mf.framework.agent.HostManager.downloadFileFromDS failed to unzip into \"" + absolutePathFile.getPath() + "\": "));
            return remoteCallResult;
        }
        finally {
            tmpDownloadFile.delete();
        }
        return new RemoteCallResult(true, null);
    }

    private IRemoteCallResult downloadToFile(String dsFilePath, String destinationFilePath, boolean rewriteIfExists) {
        File destinationFile = new File(destinationFilePath);
        if (destinationFile.exists() && !rewriteIfExists) {
            return new RemoteCallResult(false, "com.sonicsw.mf.framework.agent.HostManager.downloadFileFromDS failed: " + destinationFilePath + " already exists");
        }
        if (destinationFile.exists() && destinationFile.isDirectory()) {
            return new RemoteCallResult(false, "com.sonicsw.mf.framework.agent.HostManager.downloadFileFromDS failed: " + destinationFilePath + " is a directory");
        }
        if (destinationFile.exists() && !destinationFile.delete()) {
            return new RemoteCallResult(false, "com.sonicsw.mf.framework.agent.HostManager.downloadFileFromDS failed: Could not delete" + destinationFilePath);
        }
        return this.downloadFileFromDSInternal(dsFilePath, destinationFile);
    }

    private void createParents(File filePath) throws IOException {
        File parentPath = filePath.getParentFile();
        if (!parentPath.exists() && !parentPath.mkdirs()) {
            throw new IOException(" \"" + parentPath.getAbsolutePath() + "\" does not exist and cannot be created");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRemoteCallResult downloadFileFromDSInternal(String dsFilePath, File destinationFile) {
        RandomAccessFile dest = null;
        boolean success = false;
        RemoteCallResult remoteCallResult = null;
        try {
            IBlob blob;
            byte[] bytes;
            this.createParents(destinationFile);
            dest = new RandomAccessFile(destinationFile, "rw");
            int offset = 0;
            while ((bytes = (blob = this.m_directory.getFSBlob(dsFilePath, false, offset)).getBlobBytes()) != null && bytes.length != 0) {
                dest.write(bytes);
                offset += bytes.length;
            }
            success = true;
            remoteCallResult = new RemoteCallResult(true, null);
        }
        catch (Throwable t) {
            RemoteCallResult remoteCallResult2 = new RemoteCallResult(false, ContainerUtil.printStackTrace(t, "com.sonicsw.mf.framework.agent.HostManager.downloadFileFromDS failed:"));
            return remoteCallResult2;
        }
        finally {
            if (dest != null) {
                try {
                    dest.close();
                    if (!success) {
                        destinationFile.delete();
                    }
                }
                catch (Throwable t) {
                    remoteCallResult = new RemoteCallResult(false, ContainerUtil.printStackTrace(t, "com.sonicsw.mf.framework.agent.HostManager.downloadFileFromDS close failed:"));
                }
            }
        }
        return remoteCallResult;
    }

    private void deleteObsolete(File fileToDelete) {
        if (fileToDelete.isDirectory()) {
            String[] files = fileToDelete.list();
            for (int i = 0; i < files.length; ++i) {
                this.deleteObsolete(new File(fileToDelete, files[i]));
            }
            fileToDelete.delete();
        } else {
            fileToDelete.delete();
        }
    }

    @Override
    public IFileDescriptor[] listDirectory(String dirPath) {
        File dir = new File(dirPath);
        if (!dir.exists() || !dir.isDirectory()) {
            return null;
        }
        File[] files = dir.listFiles();
        IFileDescriptor[] resultList = new IFileDescriptor[files.length];
        for (int i = 0; i < files.length; ++i) {
            resultList[i] = new FileDescriptor(new File(files[i].getAbsolutePath()));
        }
        return resultList;
    }

    @Override
    public IRemoteExecResult remoteExec(String[] cmdarray, String[] envp, String workDirPath, byte[] inputBytes) {
        return ExecUtility.exec((String[])cmdarray, (String[])envp, (String)workDirPath, (byte[])inputBytes);
    }

    private boolean deleteFile(File fileToDelete) {
        boolean ok = true;
        if (fileToDelete.isDirectory()) {
            String[] files = fileToDelete.list();
            for (int i = 0; i < files.length; ++i) {
                if (this.deleteFile(new File(fileToDelete, files[i]))) continue;
                ok = false;
            }
            if (!fileToDelete.delete()) {
                ok = false;
            }
        } else if (!fileToDelete.delete()) {
            ok = false;
        }
        return ok;
    }

    @Override
    public String[] getAllHostnamesAndIPs(Boolean includeLoopback) {
        String hostnames = System.getProperty(SONICSW_MF_HM_HOSTNAMES_PROPERTY);
        if (null != hostnames) {
            return hostnames.split(",");
        }
        Set hostnamesAndIps = ProgressInetAddress.getAllHostnamesAndIps((boolean)includeLoopback);
        return hostnamesAndIps.toArray(new String[hostnamesAndIps.size()]);
    }
}

