/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.directory;

import com.sonicsw.mf.common.IDirectoryAdminService;
import com.sonicsw.mf.common.IDirectoryFileSystemService;
import com.sonicsw.mf.common.config.IAttributeList;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.config.MergeUtil;
import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mf.common.config.impl.EntityName;
import com.sonicsw.mf.common.config.query.From;
import com.sonicsw.mf.common.config.query.FromDirectory;
import com.sonicsw.mf.common.config.query.Query;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.dirconfig.ElementFactory;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.dirconfig.IDirIdentity;
import com.sonicsw.mf.common.runtime.impl.CanonicalName;
import com.sonicsw.mf.common.view.impl.LogicalNameSpace;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public final class Convert5to6 {
    private static final String VIEW_ELEMENT_NAME = "/_MFSchema/view";
    private static final String TOOL_ATTRIBUTES = "TOOL_ATTRIBUTES";
    private static final String _MFAttributesValues = "_MFAttributesValues";
    private static final String _MFLinkObject = "_MFLinkObject";
    private static final String MQ_AUTHORIZATION_POLICY = "MQ_AUTHORIZATION_POLICY";
    private static final String _MFComplexLink = "_MFComplexLink";
    private static final String _MFComplexAttributes = "_MFComplexAttributes";
    private static final String TYPE_ATT = "TYPE=";
    private static final String SYSTEM_ATT = "SYSTEM=";
    private static final String _Default = "_Default";
    private static final String _MQPolicyDescriptor = "_MQPolicyDescriptor";
    private static final String MX_DIR = "/mx";
    private static final String _MFview = "_MFview";
    private static final String[] SEED_FILES = new String[]{"hints.seed", "matypes21.seed", "mftypes20.seed", "mftypes21.seed", "mqtypes50.seed", "mqtypes60.seed", "smctypes.seed"};
    private static final String VERSION_99 = "99";
    private static final String VERSION_100 = "100";
    private static final String VERSION_5 = "5.0";
    private static final String VERSION_6 = "6.0";
    private static final String RELEASE_VERSION_5 = "5.0";
    private static final String RELEASE_VERSION_6 = "6.0";
    private static final String RELEASE_VERSION_21 = "2.1";
    private static final String CONFIG_VERSION_ATTRIBUTE_5 = "CONFIG_VERSION=5.0";
    private static final String CONFIG_VERSION_ATTRIBUTE_99 = "CONFIG_VERSION=99";
    private static final String CONFIG_VERSION_ATTRIBUTE_100 = "CONFIG_VERSION=100";
    private static final String PRODUCT_VERSION = "PRODUCT_VERSION=";
    private static final String PRODUCT_VERSION_ATTRIBUTE_5 = "PRODUCT_VERSION=5.0";
    private static final String PRODUCT_VERSION_ATTRIBUTE_6 = "PRODUCT_VERSION=6.0";
    private static final String PRODUCT_VERSION_ESB_CONTAINER = "PRODUCT_VERSION=5.5";
    private static final String MF_AUTHENTICATION_DOMAIN = "MF_AUTHENTICATION_DOMAIN";
    private static final String MF_DIRECTORY_SERVICE = "MF_DIRECTORY_SERVICE";
    private static final String MF_AGENT_MANAGER = "MF_AGENT_MANAGER";
    private static final String MF_ACTIVATION_DAEMON = "MF_ACTIVATION_DAEMON";
    private static final String MF_COMPONENT_COLLECTION = "MF_COMPONENT_COLLECTION";
    private static final String MF_CONTAINER_COLLECTION = "MF_CONTAINER_COLLECTION";
    private static final String MF_COLLECTION_MONITOR = "MF_COLLECTION_MONITOR";
    private static final HashSet MF_TYPES_ALWAYS_UPGRADED = new HashSet();
    private static final String MQ_BROKER = "MQ_BROKER";
    private static final String MQ_CLUSTER = "MQ_CLUSTER";
    private static final String CONFIG_ELEMENT_REFERENCES = "CONFIG_ELEMENT_REFERENCES";
    private static final String ACCEPTOR_CONFIG_ELEMENT_REF = "ACCEPTOR_CONFIG_ELEMENT_REF";
    private static final String ACCEPTORS = "Acceptors";
    private static final String ACCEPTOR_LIST = "ACCEPTOR_LIST";
    private static final String ACCEPTOR_NAME = "ACCEPTOR_NAME";
    private static final String MQ_ACCEPTORS = "MQ_ACCEPTORS";
    private static final String PROTOCOLS = "PROTOCOLS";
    private static final String DIRECT_URL_MAP = "DIRECT_URL_MAP";
    private static final String PROTOCOL = "PROTOCOL";
    private static final String URL = "URL";
    private static final String ROUTING_CONFIG_ELEMENT_REF = "ROUTING_CONFIG_ELEMENT_REF";
    private static final String ROUTING = "Routing";
    private static final String ROUTE_LIST = "ROUTE_LIST";
    private static final String QUEUE_CONFIG_ELEMENT_REF = "QUEUE_CONFIG_ELEMENT_REF";
    private static final String QUEUES = "Queues";
    private static final String MQ_QUEUES = "MQ_QUEUES";
    private static final String GLOBAL_SUBSCRIPTIONS_CONFIG_ELEMENT_REF = "GLOBAL_SUBSCRIPTIONS_CONFIG_ELEMENT_REF";
    private static final String GLOBAL_SUBSCRIPTIONS = "Global Subscriptions";
    private static final String MQ_GLOBAL_SUBSCRIPTIONS = "MQ_GLOBAL_SUBSCRIPTIONS";
    private static final String FORWARD_NOTIFICATIONS = "FORWARD_NOTIFICATIONS";
    private static final String COMPONENTS = "COMPONENTS";
    private static final String COMPONENT_RUNTIME_ID = "COMPONENT_RUNTIME_ID";
    private static final String CONFIG_REF = "CONFIG_REF";
    private static final String MONITOR_METRICS = "MONITOR_METRICS";
    private static final String CONTAINERS = "CONTAINERS";
    private static final String CONTAINER_RUNTIME_ID = "CONTAINER_RUNTIME_ID";
    private static final String CONTAINERS_DIR = "/containers";
    private static final String CONTAINER_NAME = "CONTAINER_NAME";
    private static final String PROTOTYPE_TYPE = "TEMPLATE_TYPE=prototype";
    private static final String INSTANCE_TYPE = "TEMPLATE_TYPE=instance";
    private static final String _MFDomainDescriptor = "_MFDomainDescriptor";
    private static final String CONNECTION_PARAMETERS_5 = "CONNECTION_PARAMETERS";
    private static final String AUTH_SPI_CONNECTION_PARAMETERS_6 = "AUTH_SPI_CONNECTION_PARAMETERS";
    private static final String MGMT_SPI_CONNECTION_PARAMETERS_6 = "MGMT_SPI_CONNECTION_PARAMETERS";
    private static final String XQ_CONTAINER = "XQ_CONTAINER";
    private static final String MF_MANAGEMENT_SPI = "MF_MANAGEMENT_SPI";
    private static final String LOAD_AT_STARTUP = "LOAD_AT_STARTUP";
    private static final String MGMT_SPI_FOLDER = "/Management SPIs";
    private static final String MF_AUTHENTICATION_SPI = "MF_AUTHENTICATION_SPI";
    private static final String AUTH_SPI_FOLDER = "/Authentication SPIs";
    IDirectoryAdminService m_ds;

    public static void convert(IDirectoryAdminService ds) throws Exception {
        new Convert5to6(ds).doConvert();
    }

    public static void doUpgrade5to6(IDirectoryAdminService ds, String configType, String configLogicalPath) throws Exception {
        if (configType.equals(MF_AUTHENTICATION_DOMAIN)) {
            Convert5to6.upgradeAuthDomain(ds, configLogicalPath);
        } else if (configType.equals(MQ_AUTHORIZATION_POLICY)) {
            Convert5to6.upgradePoliciesDomain(ds, configLogicalPath);
        } else if (configType.equals(MF_MANAGEMENT_SPI)) {
            Convert5to6.upgradeManagementSPI(ds, configLogicalPath);
        } else if (configType.equals(MF_AUTHENTICATION_SPI)) {
            Convert5to6.upgradeAuthSPI(ds, configLogicalPath);
        } else {
            throw new DirectoryServiceException("Cannot upgrade config type " + configType);
        }
    }

    private static void upgradeAuthDomain(IDirectoryAdminService ds, String logicalPath) throws Exception {
        String checkLogicalPath = logicalPath;
        if (checkLogicalPath.indexOf(_MFDomainDescriptor) == -1) {
            checkLogicalPath = checkLogicalPath + "/" + _MFDomainDescriptor;
        }
        LogicalNameSpace logical = new LogicalNameSpace();
        logical.init(ds, null, null);
        String descriptorName = logical.storageFromLogical(checkLogicalPath);
        IDirElement descriptor = ds.getElement(descriptorName, true);
        IAttributeSet descriptorSet = descriptor.getAttributes();
        IAttributeSet connectionParameters5 = (IAttributeSet)descriptorSet.getAttribute(CONNECTION_PARAMETERS_5);
        if (connectionParameters5 != null && !descriptorSet.getAttributeMetaData(CONNECTION_PARAMETERS_5).isFromTemplate()) {
            IAttributeSet authSPIParam6 = descriptorSet.createAttributeSet(AUTH_SPI_CONNECTION_PARAMETERS_6);
            HashMap paramTable = connectionParameters5.getAttributes();
            for (String key : paramTable.keySet()) {
                Object value = paramTable.get(key);
                authSPIParam6.setObjectAttribute(key, value);
            }
            IAttributeSet mgmtSPIParam6 = descriptorSet.createAttributeSet(MGMT_SPI_CONNECTION_PARAMETERS_6);
            for (String key : paramTable.keySet()) {
                Object value = paramTable.get(key);
                mgmtSPIParam6.setObjectAttribute(key, value);
            }
            descriptorSet.deleteAttribute(CONNECTION_PARAMETERS_5);
        }
        ds.setElement(descriptor.doneUpdate(), null);
        ds.setElementReleaseVersion(descriptorName, VERSION_100);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(TOOL_ATTRIBUTES, Convert5to6.generateUpgradedMFAttributes(MF_AUTHENTICATION_DOMAIN));
        ((IDirectoryFileSystemService)ds).setMetaAttributes(checkLogicalPath.substring(0, checkLogicalPath.indexOf("/_MFDomainDescriptor")), map);
        String groupsDirectory = descriptorName.substring(0, descriptorName.lastIndexOf("/")) + "/_MFGroups";
        Query findGroups = new Query();
        FromDirectory fromDirectory = new FromDirectory(groupsDirectory);
        findGroups.setFrom((From)fromDirectory);
        IDirElement[] groups = ds.getElements(findGroups, false);
        for (int i = 0; i < groups.length; ++i) {
            String storageId = groups[i].getIdentity().getName();
            String directoryName = storageId.substring(0, storageId.lastIndexOf("/") + 1);
            String groupName = (String)groups[i].getAttributes().getAttribute("GROUP_NAME");
            IDirElement newGroup = ds.cloneElement(storageId, directoryName + groupName, null);
            ds.setElement(newGroup.doneUpdate(), null);
            ds.deleteElement(storageId, null);
            ds.setElementReleaseVersion(directoryName + groupName, VERSION_100);
        }
        String usersDirectory = descriptorName.substring(0, descriptorName.lastIndexOf("/")) + "/_MFUsers";
        Query findUsers = new Query();
        fromDirectory = new FromDirectory(usersDirectory);
        findUsers.setFrom((From)fromDirectory);
        IDirElement[] users = ds.getElements(findUsers, false);
        for (int i = 0; i < users.length; ++i) {
            String storageId = users[i].getIdentity().getName();
            String directoryName = storageId.substring(0, storageId.lastIndexOf("/") + 1);
            String userName = (String)users[i].getAttributes().getAttribute("USER_NAME");
            IDirElement newUser = ds.cloneElement(storageId, directoryName + userName, null);
            ds.setElement(newUser.doneUpdate(), null);
            ds.deleteElement(users[i].getIdentity().getName(), null);
            ds.setElementReleaseVersion(directoryName + userName, VERSION_100);
        }
    }

    private static void upgradePoliciesDomain(IDirectoryAdminService ds, String logicalPath) throws Exception {
        String checkLogicalPath = logicalPath;
        if (checkLogicalPath.indexOf(_MQPolicyDescriptor) == -1) {
            checkLogicalPath = checkLogicalPath + "/" + _MQPolicyDescriptor;
        }
        LogicalNameSpace logical = new LogicalNameSpace();
        logical.init(ds, null, null);
        String descriptorName = logical.storageFromLogical(checkLogicalPath);
        ds.setElementReleaseVersion(descriptorName, VERSION_100);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(TOOL_ATTRIBUTES, Convert5to6.generateUpgradedMQAttributes(MQ_AUTHORIZATION_POLICY));
        ((IDirectoryFileSystemService)ds).setMetaAttributes(checkLogicalPath.substring(0, checkLogicalPath.indexOf("/_MQPolicyDescriptor")), map);
        String aclsDirectory = descriptorName.substring(0, descriptorName.lastIndexOf("/")) + "/_MQACLs";
        Query findAcls = new Query();
        FromDirectory fromDirectory = new FromDirectory(aclsDirectory);
        findAcls.setFrom((From)fromDirectory);
        IDirElement[] acls = ds.getElements(findAcls, false);
        for (int i = 0; i < acls.length; ++i) {
            ds.setElementReleaseVersion(acls[i].getIdentity().getName(), VERSION_100);
        }
        String qopsDirectory = descriptorName.substring(0, descriptorName.lastIndexOf("/")) + "/_MQQoPs";
        Query findQops = new Query();
        fromDirectory = new FromDirectory(qopsDirectory);
        findQops.setFrom((From)fromDirectory);
        IDirElement[] qops = ds.getElements(findQops, false);
        for (int i = 0; i < qops.length; ++i) {
            ds.setElementReleaseVersion(qops[i].getIdentity().getName(), VERSION_100);
        }
    }

    private static void upgradeManagementSPI(IDirectoryAdminService ds, String logicalPath) throws Exception {
        LogicalNameSpace logical = new LogicalNameSpace();
        logical.init(ds, null, null);
        String spiName = logical.storageFromLogical(logicalPath);
        IDirElement spiElement = ds.getElement(spiName, true);
        IAttributeSet spiSet = spiElement.getAttributes();
        if (!spiSet.getAttributeMetaData(LOAD_AT_STARTUP).isFromTemplate()) {
            Boolean loadAtStartup = (Boolean)spiSet.getAttribute(LOAD_AT_STARTUP);
            Boolean newValue = loadAtStartup != null ? loadAtStartup : Boolean.TRUE;
            spiSet.setBooleanAttribute(LOAD_AT_STARTUP, newValue);
        }
        ds.setElement(spiElement.doneUpdate(), null);
        ds.setElementReleaseVersion(spiName, VERSION_100);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(TOOL_ATTRIBUTES, Convert5to6.generateUpgradedMFAttributes(MF_MANAGEMENT_SPI));
        ((IDirectoryFileSystemService)ds).setMetaAttributes(logicalPath, map);
    }

    private static void upgradeAuthSPI(IDirectoryAdminService ds, String logicalPath) throws Exception {
        LogicalNameSpace logical = new LogicalNameSpace();
        logical.init(ds, null, null);
        String spiName = logical.storageFromLogical(logicalPath);
        ds.setElementReleaseVersion(spiName, VERSION_100);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(TOOL_ATTRIBUTES, Convert5to6.generateUpgradedMFAttributes(MF_AUTHENTICATION_SPI));
        ((IDirectoryFileSystemService)ds).setMetaAttributes(logicalPath, map);
    }

    Convert5to6(IDirectoryAdminService ds) {
        this.m_ds = ds;
    }

    private void doConvert() throws Exception {
        IDirElement viewElement = this.m_ds.getElement(VIEW_ELEMENT_NAME, true);
        ArrayList links = new ArrayList();
        Convert5to6.findAttributeSetsByNameContained((IElement)viewElement, _MFLinkObject, links);
        ArrayList linkValues = this.getAllLinkValues(links);
        this.fixAllComplexLinks(links);
        this.m_ds.setElement(viewElement.doneUpdate(), null);
        viewElement = this.m_ds.getElement(VIEW_ELEMENT_NAME, true);
        System.out.println(viewElement);
        this.fixAttributeDefinitions(viewElement);
        ArrayList lists = new ArrayList();
        Convert5to6.findAttributeSetsByName((IElement)viewElement, _MFAttributesValues, lists);
        this.fixAllAttributeLists(lists);
        this.m_ds.setElement(viewElement.doneUpdate(), null);
        LogicalNameSpace logical = new LogicalNameSpace();
        logical.init(this.m_ds, null, null);
        this.addToLogicalNameSpaceAndUpgradeIfNeeded(linkValues, logical);
        this.addTemplateAttributes(logical);
        logical.storeUpdates();
        ArrayList mgmtSPIs = new ArrayList();
        ArrayList authSPIs = new ArrayList();
        this.modifyReleaseVersion(VERSION_99, VERSION_100, mgmtSPIs, authSPIs);
        logical = new LogicalNameSpace();
        logical.init(this.m_ds, null, null);
        if (this.addSPIsToView(logical, mgmtSPIs, authSPIs)) {
            logical.storeUpdates();
        }
        this.m_ds.deleteDirectory(MX_DIR, null);
        Convert5to6.loadSeedFiles(this.m_ds);
    }

    private boolean addSPIsToView(LogicalNameSpace logical, ArrayList mgmtSPIs, ArrayList authSPIs) throws Exception {
        String configAttributes;
        HashMap<String, String> map;
        String logicalName;
        int i;
        if (mgmtSPIs.isEmpty() && authSPIs.isEmpty()) {
            return false;
        }
        if (!mgmtSPIs.isEmpty()) {
            logical.createFolder(MGMT_SPI_FOLDER);
        }
        if (!authSPIs.isEmpty()) {
            logical.createFolder(AUTH_SPI_FOLDER);
        }
        for (i = 0; i < mgmtSPIs.size(); ++i) {
            logicalName = "/Management SPIs/SPI" + i;
            map = new HashMap<String, String>();
            configAttributes = Convert5to6.generateNewAttributes(MF_MANAGEMENT_SPI, VERSION_99);
            map.put(TOOL_ATTRIBUTES, configAttributes);
            logical.addSimpleEntry(logicalName, (String)mgmtSPIs.get(i));
            logical.setMetaAttributes(logicalName, map);
        }
        for (i = 0; i < authSPIs.size(); ++i) {
            logicalName = "/Authentication SPIs/SPI" + i;
            map = new HashMap();
            configAttributes = Convert5to6.generateNewAttributes(MF_AUTHENTICATION_SPI, VERSION_99);
            map.put(TOOL_ATTRIBUTES, configAttributes);
            logical.addSimpleEntry(logicalName, (String)authSPIs.get(i));
            logical.setMetaAttributes(logicalName, map);
        }
        return true;
    }

    private void addToLogicalNameSpaceAndUpgradeIfNeeded(ArrayList linkValues, LogicalNameSpace logical) throws Exception {
        for (int i = 0; i < linkValues.size(); ++i) {
            String storageName = (String)linkValues.get(i);
            IDirElement element = this.m_ds.getElement(storageName, false);
            if (element == null) continue;
            String elementType = element.getIdentity().getType();
            if (elementType.equals(MQ_BROKER) || elementType.equals(MQ_CLUSTER)) {
                this.convertBrokerOrCluster(storageName, logical);
                continue;
            }
            if (!MF_TYPES_ALWAYS_UPGRADED.contains(elementType)) continue;
            this.upgradeMFComponents(elementType, storageName);
        }
    }

    private void upgradeMFComponents(String elementType, String storageName) throws Exception {
        HashMap containerNameMap = this.mapLogicalContainerNames();
        if (elementType.equals(MF_COMPONENT_COLLECTION)) {
            this.convertComponentCollection(storageName, containerNameMap);
        } else if (elementType.equals(MF_CONTAINER_COLLECTION)) {
            this.convertContainerCollection(storageName, containerNameMap);
        }
    }

    private void convertComponentCollection(String storageName, HashMap containerNameMap) throws Exception {
        IDirElement element = this.m_ds.getElement(storageName, true, true);
        IAttributeSet elementSet = element.getAttributes();
        if (elementSet.getAttributeMetaData(COMPONENTS).isFromTemplate()) {
            return;
        }
        IAttributeList componentList = (IAttributeList)elementSet.getAttribute(COMPONENTS);
        IAttributeSet newComponentMap = elementSet.createAttributeSet(COMPONENTS);
        elementSet.createAttributeList(MONITOR_METRICS);
        elementSet.createAttributeList(FORWARD_NOTIFICATIONS);
        for (int i = 0; i < componentList.getCount(); ++i) {
            String fullName = (String)componentList.getItem(i);
            CanonicalName canonicalName = new CanonicalName(fullName);
            String containerStorageName = (String)containerNameMap.get(canonicalName.getContainerName());
            IDirElement containerElement = this.m_ds.getElement(containerStorageName, false);
            IAttributeSet containerSet = containerElement.getAttributes();
            IAttributeSet componentsSet = (IAttributeSet)containerSet.getAttribute(COMPONENTS);
            IAttributeSet component = (IAttributeSet)componentsSet.getAttribute(canonicalName.getComponentName());
            Reference configRef = (Reference)component.getAttribute(CONFIG_REF);
            IAttributeSet newComponent = newComponentMap.createAttributeSet(fullName);
            newComponent.setReferenceAttribute(CONFIG_REF, configRef);
            newComponent.setStringAttribute(COMPONENT_RUNTIME_ID, fullName);
        }
        this.m_ds.setElement(element.doneUpdate(), null);
    }

    private void convertContainerCollection(String storageName, HashMap containerNameMap) throws Exception {
        IDirElement element = this.m_ds.getElement(storageName, true, true);
        IAttributeSet elementSet = element.getAttributes();
        if (elementSet.getAttributeMetaData(CONTAINERS).isFromTemplate()) {
            return;
        }
        IAttributeList componentList = (IAttributeList)elementSet.getAttribute(CONTAINERS);
        IAttributeSet newComponentMap = elementSet.createAttributeSet(CONTAINERS);
        for (int i = 0; i < componentList.getCount(); ++i) {
            String fullName = (String)componentList.getItem(i);
            CanonicalName canonicalName = new CanonicalName(fullName);
            String containerStorageName = (String)containerNameMap.get(canonicalName.getContainerName());
            IAttributeSet newComponent = newComponentMap.createAttributeSet(fullName);
            newComponent.setReferenceAttribute(CONFIG_REF, new Reference(containerStorageName));
            newComponent.setStringAttribute(CONTAINER_RUNTIME_ID, fullName);
        }
        this.m_ds.setElement(element.doneUpdate(), null);
    }

    private HashMap mapLogicalContainerNames() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        IElementIdentity[] ids = this.m_ds.listElements(CONTAINERS_DIR);
        for (int i = 0; i < ids.length; ++i) {
            IDirElement element = this.m_ds.getElement(ids[i].getName(), false);
            IAttributeSet elementSet = element.getAttributes();
            String containerName = (String)elementSet.getAttribute(CONTAINER_NAME);
            map.put(containerName, ids[i].getName());
        }
        return map;
    }

    private void convertBrokerOrCluster(String storageName, LogicalNameSpace logical) throws Exception {
        Reference queuesgConfigRef;
        Reference routingConfigRef;
        IDirElement element = this.m_ds.getElement(storageName, false);
        IAttributeSet elementSet = element.getAttributes();
        IAttributeSet references = (IAttributeSet)elementSet.getAttribute(CONFIG_ELEMENT_REFERENCES);
        String logicalPath = Convert5to6.moveConfigTo_Default(storageName, logical, element.isTemplate(), element.getSuperElementName() != null);
        Reference acceptorConfigRef = (Reference)references.getAttribute(ACCEPTOR_CONFIG_ELEMENT_REF);
        if (acceptorConfigRef != null) {
            String acceptorElementName = acceptorConfigRef.getElementName();
            String acceptorsPath = this.createConfig_Default_Structure(logical, logicalPath, ACCEPTORS, acceptorElementName, MQ_ACCEPTORS, "5.0");
            IDirElement acceptorElement = this.m_ds.getElement(acceptorElementName, false);
            IAttributeSet acceptorsSet = acceptorElement.getAttributes();
            IAttributeList acceptors = (IAttributeList)acceptorsSet.getAttribute(ACCEPTOR_LIST);
            for (int i = 0; i < acceptors.getCount(); ++i) {
                Reference acceptorRef = (Reference)acceptors.getItem(i);
                String accStorageName = acceptorRef.getElementName();
                IDirElement accElement = this.m_ds.getElement(accStorageName, false);
                this.addAcceptorProtocols(accElement, acceptorsPath, logical);
                IAttributeSet accSet = accElement.getAttributes();
                String accName = (String)accSet.getAttribute(ACCEPTOR_NAME);
                this.createConfigElement(logical, acceptorsPath, accName, accStorageName, accElement.getIdentity().getType(), "5.0");
            }
        }
        if ((routingConfigRef = (Reference)references.getAttribute(ROUTING_CONFIG_ELEMENT_REF)) != null) {
            String routingElementName = routingConfigRef.getElementName();
            IDirElement routingElement = this.m_ds.getElement(routingElementName, false);
            String routingsPath = this.createConfig_Default_Structure(logical, logicalPath, ROUTING, routingElementName, routingElement.getIdentity().getType(), "5.0");
            IAttributeSet routeAtts = routingElement.getAttributes();
            IAttributeList routes = (IAttributeList)routeAtts.getAttribute(ROUTE_LIST);
            for (int i = 0; i < routes.getCount(); ++i) {
                Reference routeRef = (Reference)routes.getItem(i);
                String routeStorageName = routeRef.getElementName();
                IElementIdentity routeID = (IElementIdentity)this.m_ds.getIdentity(routeStorageName);
                this.createConfigElement(logical, routingsPath, "ROUTE" + i, routeStorageName, routeID.getType(), "5.0");
            }
            Reference globalsConfigRef = (Reference)references.getAttribute(GLOBAL_SUBSCRIPTIONS_CONFIG_ELEMENT_REF);
            if (globalsConfigRef != null) {
                String globalsElementName = globalsConfigRef.getElementName();
                this.createConfigElement(logical, routingsPath, GLOBAL_SUBSCRIPTIONS, globalsElementName, MQ_GLOBAL_SUBSCRIPTIONS, "5.0");
            }
        }
        if ((queuesgConfigRef = (Reference)references.getAttribute(QUEUE_CONFIG_ELEMENT_REF)) != null) {
            String queuesElementName = queuesgConfigRef.getElementName();
            this.createConfigElement(logical, logicalPath, QUEUES, queuesElementName, MQ_QUEUES, "5.0");
        }
    }

    private void addAcceptorProtocols(IDirElement acceptorElement, String acceptorsPath, LogicalNameSpace logical) throws Exception {
        IAttributeSet acceptorSet = acceptorElement.getAttributes();
        IAttributeList protocolsList = (IAttributeList)acceptorSet.getAttribute("DIRECT_LIST");
        if (protocolsList == null) {
            return;
        }
        for (int i = 0; i < protocolsList.getCount(); ++i) {
            String protocolStorage = ((Reference)protocolsList.getItem(i)).getElementName();
            IDirElement protocolElement = this.m_ds.getElement(protocolStorage, false);
            IElementIdentity protocolElementID = protocolElement.getIdentity();
            this.createConfigElement(logical, acceptorsPath, PROTOCOL + Convert5to6.getEntityName(protocolStorage).getBaseName(), protocolStorage, protocolElementID.getType(), "5.0");
            this.addAcceptorUrlsAndMapItems(protocolElement, acceptorsPath, logical);
        }
    }

    private void addAcceptorUrlsAndMapItems(IDirElement protocolElement, String acceptorsPath, LogicalNameSpace logical) throws Exception {
        IAttributeList mapItemList;
        IAttributeSet protocolSet = protocolElement.getAttributes();
        IAttributeList urlsList = (IAttributeList)protocolSet.getAttribute("URLS");
        if (urlsList != null) {
            for (int i = 0; i < urlsList.getCount(); ++i) {
                String urlsStorage = ((Reference)urlsList.getItem(i)).getElementName();
                IElementIdentity urlElementID = (IElementIdentity)this.m_ds.getIdentity(urlsStorage);
                this.createConfigElement(logical, acceptorsPath, URL + Convert5to6.getEntityName(urlsStorage).getBaseName(), urlsStorage, urlElementID.getType(), "5.0");
            }
        }
        if ((mapItemList = (IAttributeList)protocolSet.getAttribute("DIRECT_CONTENT_MAP")) == null) {
            return;
        }
        for (int i = 0; i < mapItemList.getCount(); ++i) {
            String mapItemName = ((Reference)mapItemList.getItem(i)).getElementName();
            IElementIdentity mapItemID = (IElementIdentity)this.m_ds.getIdentity(mapItemName);
            this.createConfigElement(logical, acceptorsPath, URL + Convert5to6.getEntityName(mapItemName).getBaseName(), mapItemName, mapItemID.getType(), "5.0");
        }
    }

    private static String moveConfigTo_Default(String storageName, LogicalNameSpace logical, boolean isTemplate, boolean isInstance) throws Exception {
        String logicalName = logical.logicalFromStorage(storageName);
        HashMap map = logical.getMetaAttributes(logicalName);
        EntityName logicalNameE = Convert5to6.getEntityName(logicalName);
        String logicalBaseName = logicalNameE.getBaseName();
        String parentFolder = logicalNameE.getParent();
        logical.rename(logicalName, parentFolder + "/" + _Default);
        logical.createFolder(logicalName);
        String toolsAttributes = (String)map.get(TOOL_ATTRIBUTES);
        toolsAttributes = Convert5to6.appendTemplateAttribute(toolsAttributes, isTemplate, isInstance);
        map.put(TOOL_ATTRIBUTES, toolsAttributes);
        logical.setMetaAttributes(logicalName, map);
        logical.rename(parentFolder + "/" + _Default, logicalName + "/" + _Default);
        return logicalName;
    }

    private String createConfig_Default_Structure(LogicalNameSpace logical, String hostFolder, String configName, String configStorageName, String elementType, String releaseVersion) throws Exception {
        String configPath = hostFolder + "/" + configName;
        logical.createFolder(configPath);
        HashMap<String, String> map = new HashMap<String, String>();
        String configAttributes = Convert5to6.generateNewAttributes(elementType, releaseVersion);
        IDirElement element = this.m_ds.getElement(configStorageName, false);
        configAttributes = Convert5to6.appendTemplateAttribute(configAttributes, element.isTemplate(), element.getSuperElementName() != null);
        map.put(TOOL_ATTRIBUTES, configAttributes);
        logical.setMetaAttributes(configPath, map);
        this.createConfigElement(logical, configPath, _Default, configStorageName, elementType, releaseVersion);
        return configPath;
    }

    private void createConfigElement(LogicalNameSpace logical, String hostFolder, String configName, String configStorageName, String elementType, String releaseVersion) throws Exception {
        String configPath = hostFolder + "/" + configName;
        HashMap<String, String> map = new HashMap<String, String>();
        String configAttributes = Convert5to6.generateNewAttributes(elementType, releaseVersion);
        map.put(TOOL_ATTRIBUTES, configAttributes);
        logical.addSimpleEntry(configPath, configStorageName);
        logical.setMetaAttributes(configPath, map);
    }

    private static EntityName getEntityName(String name) {
        try {
            return new EntityName(name);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Error(e.toString());
        }
    }

    private void fixAllComplexLinks(ArrayList links) throws Exception {
        ArrayList linkValues = new ArrayList();
        for (int i = 0; i < links.size(); ++i) {
            IAttributeSet link = (IAttributeSet)links.get(i);
            IAttributeList attValues = (IAttributeList)link.getAttribute(_MFAttributesValues);
            String elementType = (String)attValues.getItem(0);
            String elementVersion = (String)attValues.getItem(1);
            if (elementType.equals(MQ_AUTHORIZATION_POLICY) || elementType.equals(MF_AUTHENTICATION_DOMAIN)) {
                link.setBooleanAttribute(_MFComplexLink, Boolean.TRUE);
                IAttributeSet complexAttributes = link.createAttributeSet(_MFComplexAttributes);
                String toolAttributesValue = Convert5to6.generateNewAttributes(elementType, elementVersion);
                complexAttributes.setStringAttribute(TOOL_ATTRIBUTES, toolAttributesValue);
            }
            if (!elementType.equals(MQ_AUTHORIZATION_POLICY)) continue;
            String descriptorName = (String)link.getAttribute(_MFLinkObject);
            IDirElement descriptor = this.m_ds.getElement(descriptorName, false);
            EntityName descriptorNameE = Convert5to6.getEntityName(descriptorName);
            String newName = descriptorNameE.getParent() + "/" + _MQPolicyDescriptor;
            link.setStringAttribute(_MFLinkObject, newName);
            IElementIdentity descID = descriptor.getIdentity();
            IDirElement renamedElement = ElementFactory.createElement((String)newName, (String)descID.getType(), (String)descID.getReleaseVersion());
            MergeUtil.mergeModifications((IDirElement)renamedElement, (IDirElement)descriptor);
            this.m_ds.deleteElement(descID.getName(), null);
            this.m_ds.setElement(renamedElement.doneUpdate(), null);
        }
    }

    private static String appendTemplateAttribute(String existingAttributes0, boolean isTemplate, boolean isInstance) {
        String existingAttributes;
        String string = existingAttributes = existingAttributes0 == null ? "" : existingAttributes0 + ";";
        if (isTemplate) {
            return existingAttributes + PROTOTYPE_TYPE;
        }
        if (isInstance) {
            return existingAttributes + INSTANCE_TYPE;
        }
        return existingAttributes0;
    }

    private static String generateNewAttributes(String elementType, String releaseVersion) {
        if (elementType.equals(XQ_CONTAINER)) {
            return TYPE_ATT + elementType + ";" + CONFIG_VERSION_ATTRIBUTE_5 + ";" + PRODUCT_VERSION_ESB_CONTAINER;
        }
        if (MF_TYPES_ALWAYS_UPGRADED.contains(elementType)) {
            return Convert5to6.generateUpgradedMFAttributes(elementType);
        }
        return TYPE_ATT + elementType + ";" + CONFIG_VERSION_ATTRIBUTE_99 + ";" + PRODUCT_VERSION + releaseVersion;
    }

    private static String generateUpgradedMFAttributes(String elementType) {
        return TYPE_ATT + elementType + ";" + CONFIG_VERSION_ATTRIBUTE_100 + ";" + PRODUCT_VERSION + RELEASE_VERSION_21;
    }

    private static String generateUpgradedMQAttributes(String elementType) {
        return TYPE_ATT + elementType + ";" + CONFIG_VERSION_ATTRIBUTE_100 + ";" + PRODUCT_VERSION + "6.0";
    }

    private ArrayList getAllLinkValues(ArrayList links) throws Exception {
        ArrayList<String> linkValues = new ArrayList<String>();
        for (int i = 0; i < links.size(); ++i) {
            IAttributeSet link = (IAttributeSet)links.get(i);
            String linkValue = (String)link.getAttribute(_MFLinkObject);
            linkValues.add(linkValue);
        }
        return linkValues;
    }

    private void fixAttributeDefinitions(IDirElement view) throws Exception {
        IAttributeSet viewAtts = view.getAttributes();
        IAttributeList mFFolderAttributesSetType = viewAtts.createAttributeList("_MFFolderAttributesSetType");
        mFFolderAttributesSetType.addStringItem(TOOL_ATTRIBUTES);
        IAttributeList mFLinkAttributesSetType = viewAtts.createAttributeList("_MFLinkAttributesSetType");
        mFLinkAttributesSetType.addStringItem(TOOL_ATTRIBUTES);
    }

    private void fixAllAttributeLists(ArrayList lists) throws Exception {
        for (int i = 0; i < lists.size(); ++i) {
            this.fixAttributeValues((IAttributeList)lists.get(i));
        }
    }

    private void fixAttributeValues(IAttributeList list) throws Exception {
        String toolAttributesValue = "";
        if (list.getCount() == 5) {
            String elementType = (String)list.getItem(0);
            String elementversion = (String)list.getItem(1);
            if (!elementType.equals(MQ_AUTHORIZATION_POLICY) && !elementType.equals(MF_AUTHENTICATION_DOMAIN)) {
                toolAttributesValue = Convert5to6.generateNewAttributes(elementType, elementversion);
            }
        } else if (list.getCount() == 1) {
            String systemFolderValue = (String)list.getItem(0);
            if (systemFolderValue.length() > 0) {
                toolAttributesValue = SYSTEM_ATT + systemFolderValue;
            }
        } else {
            throw new Error("Bad view attributes list.");
        }
        for (int i = list.getCount() - 1; i >= 0; --i) {
            list.deleteAttributeItem(i);
        }
        list.addStringItem(toolAttributesValue);
    }

    private static void findAttributeSetsByName(IElement element, String name, ArrayList lists) {
        Convert5to6.findAttributeSetsByName(element.getAttributes(), name, lists);
    }

    private static void findAttributeSetsByName(IAttributeSet attSet, String name, ArrayList lists) {
        HashMap map = attSet.getAttributes();
        Set keys = map.keySet();
        for (String key : keys) {
            Object value = map.get(key);
            if (key.equals(name)) {
                lists.add(value);
                continue;
            }
            if (!(value instanceof IAttributeSet)) continue;
            Convert5to6.findAttributeSetsByName((IAttributeSet)value, name, lists);
        }
    }

    private static void findAttributeSetsByNameContained(IElement element, String name, ArrayList lists) {
        Convert5to6.findAttributeSetsByNameContained(element.getAttributes(), name, lists);
    }

    private static void findAttributeSetsByNameContained(IAttributeSet attSet, String name, ArrayList lists) {
        HashMap map = attSet.getAttributes();
        Set keys = map.keySet();
        for (String key : keys) {
            Object value = map.get(key);
            if (key.equals(name)) {
                lists.add(attSet);
                return;
            }
            if (!(value instanceof IAttributeSet)) continue;
            Convert5to6.findAttributeSetsByNameContained((IAttributeSet)value, name, lists);
        }
    }

    private void addTemplateAttributes(LogicalNameSpace logical) throws Exception {
        this.addTemplateAttributes("/", logical);
    }

    private void addTemplateAttributes(String dirName, LogicalNameSpace logical) throws Exception {
        if (dirName.equals("/_MFSystem")) {
            return;
        }
        IElementIdentity[] elements = this.m_ds.listElements(dirName);
        for (int i = 0; i < elements.length; ++i) {
            boolean isI;
            String storageName = elements[i].getName();
            IDirElement element = this.m_ds.getElement(storageName, false);
            boolean isT = element.isTemplate();
            boolean bl = isI = element.getSuperElementName() != null;
            if (!isT && !isI) continue;
            String logicalName = logical.logicalFromStorage(storageName);
            HashMap map = logical.getMetaAttributes(logicalName);
            String toolsAttributes = (String)map.get(TOOL_ATTRIBUTES);
            toolsAttributes = Convert5to6.appendTemplateAttribute(toolsAttributes, isT, isI);
            map.put(TOOL_ATTRIBUTES, toolsAttributes);
            logical.setMetaAttributes(logicalName, map);
        }
        IDirIdentity[] directories = this.m_ds.listDirectories(dirName);
        for (int i = 0; i < directories.length; ++i) {
            this.addTemplateAttributes(directories[i].getName(), logical);
        }
    }

    private void modifyReleaseVersion(String oldVersion, String newVersion, ArrayList mgmtSPIs, ArrayList authSPIs) throws Exception {
        this.modifyReleaseVersion("/", oldVersion, newVersion, mgmtSPIs, authSPIs);
    }

    private void modifyReleaseVersion(String dirName, String oldVersion, String newVersion, ArrayList mgmtSPIs, ArrayList authSPIs) throws Exception {
        if (dirName.equals("/_MFSystem")) {
            return;
        }
        IElementIdentity[] elements = this.m_ds.listElements(dirName);
        for (int i = 0; i < elements.length; ++i) {
            String type = elements[i].getType();
            if (type != null) {
                if (type.equals(MF_MANAGEMENT_SPI)) {
                    mgmtSPIs.add(elements[i].getName());
                }
                if (type.equals(MF_AUTHENTICATION_SPI)) {
                    authSPIs.add(elements[i].getName());
                }
                if (type.equals(XQ_CONTAINER)) continue;
            }
            String version = MF_TYPES_ALWAYS_UPGRADED.contains(elements[i].getType()) ? newVersion : oldVersion;
            this.m_ds.setElementReleaseVersion(elements[i].getName(), version);
        }
        IDirIdentity[] directories = this.m_ds.listDirectories(dirName);
        for (int i = 0; i < directories.length; ++i) {
            this.modifyReleaseVersion(directories[i].getName(), oldVersion, newVersion, mgmtSPIs, authSPIs);
        }
    }

    private static void loadSeedFiles(IDirectoryAdminService ds) throws Exception {
        try {
            for (int i = 0; i < SEED_FILES.length; ++i) {
                Convert5to6.doImport(ds, SEED_FILES[i]);
            }
        }
        catch (FileNotFoundException e) {
            throw new Exception("Version 6.0 seed files must be present in the working directory: " + e.getMessage());
        }
    }

    static void doImport(IDirectoryAdminService ds, String filename) throws Exception {
        int c;
        FileInputStream in = new FileInputStream(filename);
        StringBuffer buf = new StringBuffer();
        while ((c = in.read()) != -1) {
            buf.append((char)c);
        }
        in.close();
        String XMLData = buf.toString();
        ds.importFromXML(XMLData);
    }

    static {
        MF_TYPES_ALWAYS_UPGRADED.add(MF_DIRECTORY_SERVICE);
        MF_TYPES_ALWAYS_UPGRADED.add(MF_AGENT_MANAGER);
        MF_TYPES_ALWAYS_UPGRADED.add(MF_COMPONENT_COLLECTION);
        MF_TYPES_ALWAYS_UPGRADED.add(MF_CONTAINER_COLLECTION);
        MF_TYPES_ALWAYS_UPGRADED.add(MF_COLLECTION_MONITOR);
        MF_TYPES_ALWAYS_UPGRADED.add(_MFview);
    }
}

