/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.directory.storage.pse;

import com.odi.Database;
import com.odi.DatabaseNotFoundException;
import com.odi.DatabaseRootNotFoundException;
import com.odi.ObjectStore;
import com.odi.Session;
import com.odi.Transaction;
import com.odi.util.OSTreeSet;
import com.odi.util.query.Query;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.config.IIdentity;
import com.sonicsw.mf.common.config.impl.Blob;
import com.sonicsw.mf.common.config.impl.DirIdentity;
import com.sonicsw.mf.common.config.impl.Element;
import com.sonicsw.mf.common.config.impl.EntityName;
import com.sonicsw.mf.common.dirconfig.ElementFactory;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.dirconfig.IDirIdentity;
import com.sonicsw.mf.framework.directory.ILogger;
import com.sonicsw.mf.framework.directory.storage.IStorage;
import com.sonicsw.mf.framework.directory.storage.ParentDirDoesNotExistException;
import com.sonicsw.mf.framework.directory.storage.StorageException;
import com.sonicsw.mf.framework.directory.storage.pse.CollectionElement;
import com.sonicsw.mf.framework.directory.storage.pse.DSBlob;
import com.sonicsw.mf.framework.directory.storage.pse.DSBlobChunk;
import com.sonicsw.mf.framework.directory.storage.pse.DSDirectory;
import com.sonicsw.mf.framework.directory.storage.pse.DSElement;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class PSEStorage
implements IStorage {
    Database m_store;
    Session m_session;
    String m_domain;
    OSTreeSet m_data;
    OSTreeSet m_directories;
    String m_domainDir;
    String m_tempDir;
    String m_password = null;
    String m_dbPath = null;
    ILogger m_logger;
    HashMap m_collections;
    Transaction m_transaction = null;
    boolean m_sharedDB = false;
    boolean m_startsUpdateTransactions = false;
    public static String DB_EXTENSION = ".odb";
    String DB_DATA_ROOT_NAME = "data";
    String DB_DIRECTORIES_ROOT_NAME = "directories";
    String DB_ELEMENT_NAME_ATTRIBUTE = "getElementName()";
    String DB_PARENT_DIRECTORY_ATTRIBUTE = "getParentDirectory()";
    String DB_DIRECTORY_NAME_ATTRIBUTE = "getDirectoryName()";
    String DB_GET_PARENT_DIR_NAME_ATTRIBUTE = "getParentDirectoryName()";
    String DB_GROUP_ELEMENT_NAME = "getGroupName()";
    Class DB_ELEMENT_CLASS = DSElement.class;
    Class DB_DIRECTORY_CLASS = DSDirectory.class;
    String DB_COLLECTION_NAME_ATTRIBUTE = "getName()";
    Class DB_COLLECTION_CLASS = CollectionElement.class;
    private static int COPY_CHUNK_SIZE = 1000000;
    private static String TEMPFILES_DIR_NAME = "tempFiles";
    private static boolean DEBUG;
    private static boolean DEBUG_TRANSACTION;
    private static boolean DSDUMP;
    private static HashMap m_corruptIds;
    private static final String[] EMPTY_STRING_ARRAY;

    private void showDB(String fileName) throws IOException {
        this.beginOSTransaction("showDB", 6);
        PrintStream dbPrintStream = new PrintStream(new FileOutputStream(this.m_dbPath + "\\" + fileName));
        this.m_store.show(dbPrintStream, true, true);
        dbPrintStream.close();
    }

    static void twoStoresOneDBTest(PSEStorage store1, PSEStorage store2) throws Exception {
        store1.startTransaction();
        store2.createDirectory(new EntityName("/_MFSystem"));
        store2.createDirectory(new EntityName("/_MFSystem/stuff"));
        store2.setElement(new EntityName("/_MFSystem/system_element"), ElementFactory.createElement((String)"/_MFSystem/system_element", (String)"MF_CONTAINER", (String)"3.0"));
        store1.commitTransaction();
        System.out.println("Done with twoStoresOneDBTest");
    }

    public PSEStorage(PSEStorage existingStorage) throws StorageException {
        this.m_password = existingStorage.m_password;
        this.m_domainDir = existingStorage.m_domainDir;
        this.m_tempDir = existingStorage.m_tempDir;
        this.m_domain = existingStorage.m_domain;
        this.m_dbPath = existingStorage.m_dbPath;
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("NO_READ_LOCK", Boolean.TRUE);
        this.setSession();
        this.joinSession();
        try {
            this.m_store = Database.open(this.m_dbPath, 7, params);
            if (DEBUG) {
                System.out.println("PSEStorage opened database with path " + this.m_dbPath + " in session " + this.m_session);
            }
            this.beginOSTransaction("PSEStorage", 7);
            this.m_data = (OSTreeSet)this.m_store.getRoot(this.DB_DATA_ROOT_NAME);
            this.m_directories = (OSTreeSet)this.m_store.getRoot(this.DB_DIRECTORIES_ROOT_NAME);
            this.m_sharedDB = true;
            this.m_startsUpdateTransactions = true;
        }
        catch (DatabaseNotFoundException ex) {
            throw new StorageException("PSEStorage unable to open database in separate session " + ex.toString(), ex);
        }
        this.commitOSTransaction();
    }

    public PSEStorage(String hostDirName, String domainName, String dataDirName, String password, HashMap properties) throws StorageException {
        this.m_password = password;
        File dbDir = new File(hostDirName, domainName);
        File dbPath = new File(dbDir, dataDirName + DB_EXTENSION);
        try {
            boolean madeTempDir;
            this.m_domainDir = dbDir.getCanonicalPath();
            this.m_dbPath = dbPath.getCanonicalPath();
            File tempDir = new File(this.m_domainDir, TEMPFILES_DIR_NAME);
            if (!tempDir.exists() && !(madeTempDir = tempDir.mkdir())) {
                throw new StorageException("PSEStorage is unable to create the temporary file directory");
            }
            this.m_tempDir = tempDir.getCanonicalPath();
            this.setSession();
            this.joinSession();
            HashMap<String, Boolean> params = properties != null ? new HashMap(properties) : new HashMap<String, Boolean>();
            params.put("NO_READ_LOCK", Boolean.TRUE);
            try {
                this.m_domain = domainName;
                if (DEBUG) {
                    System.out.println("PSEStorage trying to open database with path " + this.m_dbPath + " in session " + this.m_session);
                }
                this.m_store = Database.open(this.m_dbPath, 7, params);
                if (DEBUG) {
                    System.out.println("PSEStorage opened database with path " + dbPath.getCanonicalPath() + " in session " + this.m_session);
                }
                this.beginOSTransaction("PSEStorage", 7);
                this.m_data = (OSTreeSet)this.m_store.getRoot(this.DB_DATA_ROOT_NAME);
                this.m_directories = (OSTreeSet)this.m_store.getRoot(this.DB_DIRECTORIES_ROOT_NAME);
            }
            catch (DatabaseNotFoundException ex) {
                this.m_store = Database.create(this.m_dbPath, 128, params);
                if (DEBUG) {
                    System.out.println("PSEStorage created DB with path " + dbPath.getCanonicalPath() + " in session " + this.m_session);
                }
                this.beginOSTransaction("PSEStorage", 7);
                this.m_data = new OSTreeSet(this.m_store, this.DB_ELEMENT_CLASS, this.DB_ELEMENT_NAME_ATTRIBUTE);
                this.m_store.createRoot(this.DB_DATA_ROOT_NAME, this.m_data);
                this.m_directories = new OSTreeSet(this.m_store, this.DB_DIRECTORY_CLASS, this.DB_DIRECTORY_NAME_ATTRIBUTE);
                this.m_store.createRoot(this.DB_DIRECTORIES_ROOT_NAME, this.m_directories);
                this.m_directories.add(new DSDirectory("/"));
                this.m_data.addIndex(DSElement.class, this.DB_PARENT_DIRECTORY_ATTRIBUTE);
                this.m_data.addIndex(DSElement.class, this.DB_GROUP_ELEMENT_NAME);
                this.m_directories.addIndex(DSDirectory.class, this.DB_GET_PARENT_DIR_NAME_ATTRIBUTE);
            }
            this.cleanTempDir();
            this.commitOSTransaction();
        }
        catch (IOException ioEx) {
            throw new StorageException("Unable to open database " + dbPath, ioEx);
        }
    }

    private void cleanTempDir() {
        File tempDir = new File(this.m_tempDir);
        if (tempDir.exists()) {
            File[] tempFiles = tempDir.listFiles();
            for (int i = 0; i < tempFiles.length; ++i) {
                boolean deleted = tempFiles[i].delete();
                if (deleted || this.m_logger == null) continue;
                this.m_logger.logMessage("PSEStorage unable to remove temporary file " + tempFiles[i].getName(), 2);
            }
        }
    }

    @Override
    public String getDomain() {
        return this.m_domain;
    }

    @Override
    public IDirElement getElement(EntityName elementName) throws StorageException {
        block10: {
            this.joinSession();
            if (DEBUG) {
                System.out.println("PSEStorage.getElement " + elementName.getName());
            }
            this.beginOSTransaction("getElement", 6);
            DSElement el = (DSElement)this.m_data.getFromPrimaryIndex(elementName.getName());
            if (el != null) {
                if (DEBUG) {
                    System.out.println("PSEStorage.getElement " + elementName.getName() + " element was not null");
                }
                try {
                    return el.getIDirElement(this.m_password);
                }
                catch (Throwable t) {
                    if (DSDUMP) {
                        m_corruptIds.put(elementName.getName(), new Object[]{t, t.getStackTrace()});
                    }
                    if (t instanceof StorageException) {
                        throw (StorageException)t;
                    }
                    if (t instanceof Exception) {
                        if (DEBUG) {
                            System.out.println("PSEStorage.getElement caught exception, trace follows: ");
                            t.printStackTrace();
                        }
                        StorageException se = new StorageException("Unable to get element " + el.getElementName() + " from PSEStorage, see cause");
                        se.initCause(t);
                        throw se;
                    }
                    if (!(t instanceof Error)) break block10;
                    throw (Error)t;
                }
            }
        }
        if (DEBUG) {
            System.out.println("PSEStorage.getElement " + elementName.getName() + " returning null");
        }
        return null;
    }

    @Override
    public IDirElement[] getElements(EntityName elementName) throws StorageException {
        block6: {
            this.joinSession();
            this.beginOSTransaction("getElements", 6);
            DSElement el = (DSElement)this.m_data.getFromPrimaryIndex(elementName.getName());
            if (el != null) {
                try {
                    return new IDirElement[]{el.getIDirElement(this.m_password)};
                }
                catch (Throwable t) {
                    if (DSDUMP) {
                        m_corruptIds.put(elementName.getName(), new Object[]{t, t.getStackTrace()});
                    }
                    if (t instanceof Exception) {
                        if (DEBUG) {
                            t.printStackTrace();
                        }
                        StorageException se = new StorageException("PSEStorage unable to getElements " + elementName.getName() + ", see cause");
                        se.initCause(t);
                        throw se;
                    }
                    if (!(t instanceof Error)) break block6;
                    throw (Error)t;
                }
            }
        }
        return new IDirElement[0];
    }

    @Override
    public IDirElement[] getAllElements(EntityName dirName) throws StorageException {
        IDirElement[] els;
        this.joinSession();
        this.beginOSTransaction("getAllElements", 6);
        try {
            els = this.listElementsInternal(dirName);
        }
        catch (Exception e) {
            throw new StorageException("PSEStorage unable to getAllElements, see cause", e);
        }
        return els;
    }

    @Override
    public IElementIdentity[] listElements(EntityName dirName) throws StorageException {
        IElementIdentity[] ids;
        this.joinSession();
        this.beginOSTransaction("listElements", 6);
        try {
            ids = this.listElementIdsInternal(dirName);
        }
        catch (Exception e) {
            throw new StorageException("PSEStorage unable to listElements, see cause", e);
        }
        return ids;
    }

    private IElementIdentity[] listElementIdsInternal(EntityName dirName) throws Exception {
        if (this.internalGetDirectory(dirName) == null) {
            throw new StorageException("Directory " + dirName.getName() + " does not exist");
        }
        Query elQuery = new Query(DSElement.class, "getParentDirectory() == \"" + dirName.getName() + "\"");
        Iterator elsIterator = elQuery.iterator(this.m_data);
        ArrayList<IElementIdentity> elsList = new ArrayList<IElementIdentity>();
        int elIndex = 0;
        while (elsIterator.hasNext()) {
            DSElement pseEl = null;
            try {
                pseEl = (DSElement)elsIterator.next();
                elsList.add(pseEl.getElementIdentity(this.m_password));
            }
            catch (Throwable t) {
                if (DSDUMP) {
                    if (pseEl != null) {
                        try {
                            m_corruptIds.put(pseEl.getElementName(), new Object[]{t, t.getStackTrace()});
                        }
                        catch (Throwable elNameT) {
                            m_corruptIds.put(++elIndex + dirName.getName(), new Object[]{t.toString() + ", and a subsequent " + elNameT + " while listing directory " + dirName.getName(), t.getStackTrace()});
                        }
                        continue;
                    }
                    m_corruptIds.put(++elIndex + dirName.getName(), new Object[]{t.toString() + ", while listing directory " + dirName.getName(), t.getStackTrace()});
                    continue;
                }
                if (!(t instanceof Error)) continue;
                throw (Error)t;
            }
        }
        IElementIdentity[] idsArray = new IElementIdentity[elsList.size()];
        elsList.toArray(idsArray);
        return idsArray;
    }

    private IDirElement[] listElementsInternal(EntityName dirName) throws Exception {
        if (this.internalGetDirectory(dirName) == null) {
            throw new StorageException("Directory " + dirName.getName() + " does not exist");
        }
        Query elQuery = new Query(DSElement.class, "getParentDirectory() == \"" + dirName.getName() + "\"");
        Iterator elsIterator = elQuery.iterator(this.m_data);
        ArrayList<IDirElement> elsList = new ArrayList<IDirElement>();
        while (elsIterator.hasNext()) {
            DSElement pseEl = (DSElement)elsIterator.next();
            IDirElement dirEl = pseEl.getIDirElement(this.m_password);
            elsList.add(dirEl);
        }
        IDirElement[] elsArray = new IDirElement[elsList.size()];
        elsList.toArray(elsArray);
        return elsArray;
    }

    @Override
    public IDirIdentity[] listDirectories(EntityName dirName) throws StorageException {
        this.joinSession();
        this.beginOSTransaction("listDirectories", 6);
        if (this.internalGetDirectory(dirName) == null) {
            throw new StorageException("PSEStorage listDirectories, directory does not exist " + dirName.getName());
        }
        return this.listDirectoriesInternal(dirName.getName());
    }

    private IDirIdentity[] listDirectoriesInternal(String parentDir) {
        if (DEBUG) {
            System.out.println("PSEStorage.listDirectoriesInternal " + parentDir);
        }
        Query dirQuery = new Query(DSDirectory.class, "getParentDirectoryName()  == \"" + parentDir + "\"");
        Iterator dirIterator = dirQuery.iterator(this.m_directories);
        ArrayList<DirIdentity> dirIDs = new ArrayList<DirIdentity>();
        while (dirIterator.hasNext()) {
            DSDirectory dir = (DSDirectory)dirIterator.next();
            dirIDs.add(new DirIdentity(dir.getDirectoryName()));
        }
        IDirIdentity[] idsArray = new IDirIdentity[dirIDs.size()];
        dirIDs.toArray(idsArray);
        if (DEBUG) {
            System.out.println("PSEStorage.listDirectoriesInternal " + parentDir + " returning array of " + idsArray.length + " directories");
        }
        return idsArray;
    }

    @Override
    public IIdentity[] listAll(EntityName dirName) throws StorageException {
        this.joinSession();
        this.beginOSTransaction("listAll", 6);
        try {
            if (this.internalGetDirectory(dirName) == null) {
                throw new StorageException("PSEStorage listAll, directoy does not exist: " + dirName.getName());
            }
            IDirIdentity[] dirIDs = this.listDirectoriesInternal(dirName.getName());
            IElementIdentity[] elIDs = this.listElementIdsInternal(dirName);
            IIdentity[] allIds = new IIdentity[dirIDs.length + elIDs.length];
            System.arraycopy(dirIDs, 0, allIds, 0, dirIDs.length);
            System.arraycopy(elIDs, 0, allIds, dirIDs.length, elIDs.length);
            return allIds;
        }
        catch (Exception e) {
            if (e instanceof StorageException) {
                throw (StorageException)e;
            }
            StorageException se = new StorageException("PSEStorage listAll could not list for directory " + dirName.getName() + ", see cause");
            se.initCause(e);
            throw se;
        }
    }

    private void deleteElementInternal(DSElement el) {
        if (DEBUG) {
            System.out.println("PSEStorage.deleteElementInternal " + el.getElementName());
        }
        this.m_data.remove(el);
        ObjectStore.destroy(el);
    }

    @Override
    public IElementIdentity deleteElement(EntityName elementName) throws StorageException {
        this.joinSession();
        boolean startedTransaction = false;
        if (this.m_startsUpdateTransactions && (!this.m_session.inTransaction() || this.m_session.currentTransaction().getType() != 7)) {
            this.beginOSTransaction("setElement", 7);
            startedTransaction = true;
        }
        DSElement el = (DSElement)this.m_data.getFromPrimaryIndex(elementName.getName());
        try {
            if (el != null) {
                IElementIdentity id = el.getElementIdentity(this.m_password);
                this.deleteElementInternal(el);
                IElementIdentity iElementIdentity = id;
                return iElementIdentity;
            }
        }
        catch (Exception e) {
            if (e instanceof StorageException) {
                throw (StorageException)e;
            }
            StorageException se = new StorageException("PSEStorage unable to delete element " + elementName.getName() + " m_password = " + this.m_password + ", see cause");
            se.initCause(e);
            throw se;
        }
        finally {
            if (startedTransaction) {
                this.commitOSTransaction();
            }
        }
        return null;
    }

    @Override
    public IElementIdentity deleteElement(EntityName elementName, boolean force) throws StorageException {
        return this.deleteElement(elementName);
    }

    @Override
    public IElementIdentity[] deleteElements(EntityName[] elementNames) throws StorageException {
        this.joinSession();
        boolean startedTransaction = false;
        if (this.m_startsUpdateTransactions && (!this.m_session.inTransaction() || this.m_session.currentTransaction().getType() != 7)) {
            this.beginOSTransaction("setElement", 7);
            startedTransaction = true;
        }
        if (DEBUG) {
            System.out.println("PSEStorage.deleteElements, array of " + elementNames.length + " elements");
        }
        if (elementNames.length == 0) {
            return new IElementIdentity[0];
        }
        ArrayList<IElementIdentity> ids = new ArrayList<IElementIdentity>();
        try {
            IElementIdentity[] name;
            for (int i = 0; i < elementNames.length; ++i) {
                name = elementNames[i];
                DSElement el = (DSElement)this.m_data.getFromPrimaryIndex(name.getName());
                if (el == null) continue;
                this.m_data.remove(el);
                ids.add(el.getElementIdentity(this.m_password));
                ObjectStore.destroy(el);
            }
            IElementIdentity[] idsArray = new IElementIdentity[ids.size()];
            ids.toArray(idsArray);
            name = idsArray;
            return name;
        }
        catch (Exception e) {
            if (e instanceof StorageException) {
                throw (StorageException)e;
            }
            StorageException se = new StorageException("PSEStorage unable to delete elements, see cause");
            se.initCause(e);
            throw se;
        }
        finally {
            if (startedTransaction) {
                this.commitOSTransaction();
            }
        }
    }

    @Override
    public void createDirectory(EntityName dirName) throws StorageException {
        this.joinSession();
        boolean startedTransaction = false;
        if (this.m_startsUpdateTransactions && (!this.m_session.inTransaction() || this.m_session.currentTransaction().getType() != 7)) {
            this.beginOSTransaction("createDirectory", 7);
            startedTransaction = true;
        }
        try {
            this.createDirectoryInternal(dirName, false);
        }
        finally {
            if (startedTransaction) {
                this.commitOSTransaction();
            }
        }
    }

    private void createDirectoryInternal(EntityName dirName, boolean createParent) throws StorageException {
        if (this.internalGetDirectory(dirName.getParentEntity()) == null) {
            if (createParent) {
                this.createDirectoryInternal(dirName.getParentEntity(), createParent);
            } else {
                throw new ParentDirDoesNotExistException("PSEStorage unable to create directory " + dirName.getName() + " because parent directory does not exist");
            }
        }
        if (DEBUG) {
            System.out.println("PSEStorage.createDirectoryInternal " + dirName.getName());
        }
        this.m_directories.add(new DSDirectory(dirName.getName()));
    }

    @Override
    public void deleteDirectory(EntityName dirName) throws StorageException {
        DSDirectory dir;
        this.joinSession();
        boolean startedTransaction = false;
        if (this.m_startsUpdateTransactions && (!this.m_session.inTransaction() || this.m_session.currentTransaction().getType() != 7)) {
            this.beginOSTransaction("setElement", 7);
            startedTransaction = true;
        }
        if (DEBUG) {
            System.out.println("PSEStorage.deleteDirectory " + dirName.getName());
        }
        if ((dir = this.internalGetDirectory(dirName)) != null) {
            try {
                IDirElement[] ids = this.listElementsInternal(dirName);
                if (ids.length > 0) {
                    throw new StorageException("PSEStorage cannot delete directory " + dirName.getName() + "because it's not empty");
                }
                this.m_directories.remove(dir);
                ObjectStore.destroy(dir);
            }
            catch (Exception e) {
                if (e instanceof StorageException) {
                    throw (StorageException)e;
                }
                StorageException se = new StorageException("Unable to delete directory " + dirName.getName() + ", see cause");
                se.initCause(e);
                throw se;
            }
            finally {
                if (startedTransaction) {
                    this.commitOSTransaction();
                }
            }
        }
    }

    @Override
    public boolean directoryExists(EntityName dirName) {
        this.joinSession();
        this.beginOSTransaction("directoryExists", 6);
        boolean exists = this.internalGetDirectory(dirName) != null;
        return exists;
    }

    private DSDirectory internalGetDirectory(EntityName dirName) {
        return (DSDirectory)this.m_directories.getFromPrimaryIndex(dirName.getName());
    }

    @Override
    public void setElement(EntityName elementName, IDirElement element) throws StorageException {
        this.setElement(elementName, element, false);
    }

    @Override
    public void setElement(EntityName elementName, IDirElement element, boolean createParentDir) throws StorageException {
        this.joinSession();
        boolean startedTransaction = false;
        if (this.m_startsUpdateTransactions && (!this.m_session.inTransaction() || this.m_session.currentTransaction().getType() != 7)) {
            this.beginOSTransaction("setElement", 7);
            startedTransaction = true;
        }
        try {
            this.setElementInternal(elementName, element, createParentDir);
        }
        catch (Exception ex) {
            this.m_logger.logMessage("Failed to store element, trace follows...", ex, 2);
            StorageException se = new StorageException("Failed to store element, see cause");
            se.initCause(ex);
            throw se;
        }
        finally {
            if (startedTransaction) {
                this.commitOSTransaction();
            }
        }
    }

    private void setElementInternal(EntityName elementName, IDirElement element, boolean createParentDir) throws Exception {
        Boolean envelopeImport;
        if (this.internalGetDirectory(elementName.getParentEntity()) == null) {
            if (createParentDir) {
                this.createDirectoryInternal(elementName.getParentEntity(), createParentDir);
            } else {
                throw new StorageException("PSEStorage unable to set element " + elementName.getName() + " because parent directory does not exist");
            }
        }
        DSElement el = (DSElement)this.m_data.getFromPrimaryIndex(elementName.getName());
        DSBlob blob = null;
        if (el != null) {
            blob = el.getBlob();
            el.keepBlob(true);
            this.deleteElementInternal(el);
        }
        if (DEBUG) {
            System.out.println("PSEStorage.setElementInternal setting element " + elementName.getName());
        }
        if ((envelopeImport = (Boolean)Blob.getBlobState((Element)((Element)element), (String)"BLOB_ENVELOPE_ELEMENT_IMPORT")) != null && envelopeImport.booleanValue()) {
            Blob.markBlobState((Element)((Element)element), (Object)Boolean.FALSE, (String)"BLOB_ENVELOPE_ELEMENT_IMPORT");
        }
        DSElement newElement = new DSElement(new String(elementName.getName()), element, this.m_password);
        newElement.setBlob(blob);
        this.m_data.add(newElement);
    }

    @Override
    public void setElements(IDirElement[] elements, boolean createParentDir) throws StorageException {
        this.joinSession();
        boolean startedTransaction = false;
        if (this.m_startsUpdateTransactions && (!this.m_session.inTransaction() || this.m_session.currentTransaction().getType() != 7)) {
            this.beginOSTransaction("setElement", 7);
            startedTransaction = true;
        }
        try {
            for (int i = 0; i < elements.length; ++i) {
                this.setElementInternal(new EntityName(elements[i].getIdentity().getName()), elements[i], createParentDir);
            }
        }
        catch (Exception e) {
            if (e instanceof StorageException) {
                throw (StorageException)e;
            }
            StorageException se = new StorageException("PSEStorage failed during setElements, see cause");
            se.initCause(e);
            throw se;
        }
        finally {
            if (startedTransaction) {
                this.commitOSTransaction();
            }
        }
    }

    @Override
    public void close() throws StorageException {
        this.joinSession();
        Transaction currentTr = null;
        try {
            currentTr = Transaction.current();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (DEBUG) {
            System.out.println("PSEStorage.close in session " + Session.getCurrent() + " m_session == " + this.m_session + " m_transaction " + this.m_transaction + " session.inTransaction == " + this.m_session.inTransaction() + " Transaction.current() == " + currentTr);
        }
        if (this.m_transaction != null) {
            this.m_transaction.abort();
            if (DEBUG) {
                System.out.println("PSEStorage.close aborted m_transaction");
            }
            this.m_transaction = null;
        }
        this.m_store.close();
        this.m_session.terminate();
        if (DEBUG) {
            System.out.println("PSEStorage.close terminated session " + this.m_session + " and closed database " + this.m_store);
        }
    }

    @Override
    public void setBlob(EntityName blobName, byte[] blob) throws StorageException {
        this.joinSession();
        boolean startedTransaction = false;
        if (this.m_startsUpdateTransactions && (!this.m_session.inTransaction() || this.m_session.currentTransaction().getType() != 7)) {
            this.beginOSTransaction("setElement", 7);
            startedTransaction = true;
        }
        if (DEBUG) {
            System.out.println("PSEStorage.setBlob " + blobName.getName() + ", size of the array " + blob.length + " and the first byte of the array = " + blob[0]);
        }
        try {
            DSBlob header;
            String bName = blobName.getName();
            boolean newElement = false;
            DSElement blobE = (DSElement)this.m_data.getFromPrimaryIndex(bName);
            if (blobE == null) {
                blobE = new DSElement(bName, null, null);
                newElement = true;
            }
            if ((header = blobE.getBlob()) != null) {
                this.deleteBlobInternal(blobE);
            }
            header = new DSBlob();
            for (int i = 0; i <= blob.length / COPY_CHUNK_SIZE; ++i) {
                byte[] chunkBytes = blob.length - i * COPY_CHUNK_SIZE < COPY_CHUNK_SIZE ? new byte[blob.length - i * COPY_CHUNK_SIZE] : new byte[COPY_CHUNK_SIZE];
                System.arraycopy(blob, i * COPY_CHUNK_SIZE, chunkBytes, 0, chunkBytes.length);
                DSBlobChunk chunk = new DSBlobChunk(chunkBytes);
                header.addChunk(chunk);
            }
            blobE.setBlob(header);
            if (newElement) {
                this.m_data.add(blobE);
            }
        }
        catch (Exception e) {
            throw new StorageException("PSEStorage.setBlob exception, see cause", e);
        }
    }

    @Override
    public long getBlobSize(EntityName blobName) throws StorageException {
        DSBlob blob;
        this.joinSession();
        this.beginOSTransaction("getBlobSize", 6);
        DSElement blobE = (DSElement)this.m_data.getFromPrimaryIndex(blobName.getName());
        if (blobE != null && (blob = blobE.getBlob()) != null) {
            return blob.getBlobSize();
        }
        return 0L;
    }

    @Override
    public File blobToFile(EntityName blobName) {
        this.joinSession();
        this.beginOSTransaction("blobToFile", 6);
        String bName = blobName.getName();
        if (DEBUG) {
            System.out.println("PSEStorage.blobToFile " + bName);
        }
        try {
            File blobFile = new File(this.m_tempDir, blobName.getBaseName());
            DSElement blobE = (DSElement)this.m_data.getFromPrimaryIndex(bName);
            DSBlob header = null;
            if (blobE != null) {
                header = blobE.getBlob();
            }
            int blobLength = 0;
            if (header != null) {
                if (blobFile.exists() && blobFile.length() == (long)header.getBlobSize()) {
                    return blobFile;
                }
                blobLength = header.getBlobLength();
                FileOutputStream blobStream = new FileOutputStream(blobFile);
                for (int i = 0; i < blobLength; ++i) {
                    DSBlobChunk chunk = header.getBlobChunk(i);
                    byte[] chunkBytes = chunk.getBytes();
                    blobStream.write(chunkBytes);
                }
                blobStream.close();
            }
            return blobFile;
        }
        catch (Exception e) {
            throw new Error("PSEStorage blobToFile failed for " + blobName.getName() + ", see cause", e);
        }
    }

    @Override
    public byte[] getBlob(EntityName blobName) throws StorageException {
        return this.getBlob(blobName, 0, COPY_CHUNK_SIZE);
    }

    @Override
    public void deleteBlob(EntityName blobName) throws StorageException {
        this.joinSession();
        boolean startedTransaction = false;
        if (this.m_startsUpdateTransactions && (!this.m_session.inTransaction() || this.m_session.currentTransaction().getType() != 7)) {
            this.beginOSTransaction("setElement", 7);
            startedTransaction = true;
        }
        try {
            DSElement blobE = (DSElement)this.m_data.getFromPrimaryIndex(blobName.getName());
            if (blobE != null) {
                this.deleteBlobInternal(blobE);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new StorageException("PSEStorage is unable to delete blob " + blobName.getName() + ", see cause", e);
        }
        finally {
            if (startedTransaction) {
                this.commitOSTransaction();
            }
        }
    }

    @Override
    public void appendBlob(EntityName entityName, byte[] blobBytes, int offset) throws StorageException {
        this.joinSession();
        if (DEBUG && blobBytes.length > 0) {
            System.out.println("PSEStorage.appendBlob " + entityName.getName() + ", size of the array " + blobBytes.length + " at offset " + offset + " and the first byte in the array == " + blobBytes[0]);
        }
        try {
            if (this.internalGetDirectory(entityName.getParentEntity()) == null) {
                this.createDirectoryInternal(entityName.getParentEntity(), true);
            }
            String bName = entityName.getName();
            DSElement blobE = (DSElement)this.m_data.getFromPrimaryIndex(bName);
            DSBlob blobHeader = null;
            if (blobE != null) {
                blobHeader = blobE.getBlob();
                this.m_data.remove(blobE);
                if (DEBUG) {
                    System.out.println("PSEStorage.appendBlob DSElement was not null, so we removed it");
                }
                if (blobHeader == null && DEBUG) {
                    System.out.println("PSEStorage.appendBlob existing DSElement did not have a blob header");
                }
            } else {
                blobE = new DSElement(bName, null, null);
                if (DEBUG) {
                    System.out.println("PSEStorage.appendBlob creating DSElement " + bName);
                }
            }
            if (offset == 0 && blobHeader != null) {
                if (DEBUG) {
                    System.out.println("PSEStorage.appendBlob deleting blob to start a new one");
                }
                this.deleteBlobInternal(blobE);
                blobHeader = null;
            }
            if (offset != 0) {
                if (blobHeader != null && blobHeader.getBlobSize() != offset) {
                    throw new Error("PSEStorage cannot append to blob, index out of bounds. Size of blob = " + blobHeader.getBlobSize() + " and index for append = " + offset);
                }
                if (blobHeader == null) {
                    throw new Error("PSEStorage cannot append to blob, index out of bounds. Blob is non existent and index for append = " + offset);
                }
            }
            if (blobHeader == null) {
                if (DEBUG) {
                    System.out.println("PSEStorage.appendBlob creating a new blobHeader and setting it in the element ");
                }
                blobHeader = new DSBlob();
                blobE.setBlob(blobHeader);
            }
            int newLength = blobHeader.getBlobLength() + 1;
            if (DEBUG) {
                System.out.println("PSEStorage.appendBlob new blobLength == " + newLength);
            }
            DSBlobChunk blobChunk = new DSBlobChunk(blobBytes);
            blobHeader.addChunk(blobChunk);
            if (DEBUG) {
                System.out.println("PSEStorage.appendBlob adding DSElement to m_data ");
            }
            this.m_data.add(blobE);
            this.appendToTemp(entityName, blobBytes, offset);
            if (DEBUG) {
                System.out.println("PSEStorage.appendBlob exiting");
            }
        }
        catch (Exception e) {
            if (DEBUG) {
                e.printStackTrace();
            }
            if (e instanceof StorageException) {
                throw (StorageException)e;
            }
            StorageException se = new StorageException("PSEStorage unable to append blob " + entityName.getName() + ", see cause");
            se.initCause(e);
            throw se;
        }
    }

    private void deleteBlobInternal(DSElement blobE) {
        String name = blobE.getElementName();
        if (DEBUG) {
            System.out.println("PSEStorage.deleteBlobInternal " + name);
        }
        blobE.setBlob(null);
    }

    private void appendToTemp(EntityName entityName, byte[] blobBytes, int offset) {
        File tempFile = new File(this.m_tempDir, entityName.getBaseName());
        if (tempFile.length() == (long)offset) {
            try {
                FileOutputStream tempStream = new FileOutputStream(tempFile, true);
                tempStream.write(blobBytes);
                tempStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public byte[] getBlob(EntityName entityName, int offset, int length) throws StorageException {
        this.joinSession();
        this.beginOSTransaction("getBlob", 6);
        String name = entityName.getName();
        DSElement blobE = (DSElement)this.m_data.getFromPrimaryIndex(name);
        DSBlob header = null;
        if (blobE != null) {
            header = blobE.getBlob();
        }
        if (header == null) {
            return null;
        }
        int size = header.getBlobSize();
        if (offset >= size) {
            return new byte[0];
        }
        if (offset == 0 && length == size) {
            return this.getEntireBlob(header);
        }
        int blobChunkIndex = offset / COPY_CHUNK_SIZE;
        int offsetInChunk = offset % COPY_CHUNK_SIZE;
        if (offsetInChunk != 0) {
            throw new StorageException("PSEStorage cannot fetch a partial blob segment for " + name + " starting at index " + offset);
        }
        if (length != COPY_CHUNK_SIZE && blobChunkIndex + 1 != header.getBlobLength()) {
            throw new StorageException("PSEStorage cannot fetch a partial blob segment for " + name + " of length != 1000000 bytes");
        }
        DSBlobChunk chunk = header.getBlobChunk(blobChunkIndex);
        if (DEBUG) {
            System.out.println("PSEStorage.getBlob " + name + " returning blob of size " + chunk.getBytes().length + " and the first byte of the array == " + chunk.getBytes()[0]);
        }
        byte[] chunkBytes = chunk.getBytes();
        byte[] copyBytes = new byte[chunkBytes.length];
        System.arraycopy(chunkBytes, 0, copyBytes, 0, chunkBytes.length);
        return copyBytes;
    }

    private byte[] getEntireBlob(DSBlob header) {
        byte[] copyBytes = new byte[header.getBlobSize()];
        int copyBytesIndex = 0;
        for (int chunkIndex = 0; chunkIndex < header.getBlobLength(); ++chunkIndex) {
            DSBlobChunk chunk = header.getBlobChunk(chunkIndex);
            if (DEBUG) {
                System.out.println("PSEStorage.getEntireBlob fetching chunk " + chunkIndex);
            }
            byte[] chunkBytes = chunk.getBytes();
            System.arraycopy(chunkBytes, 0, copyBytes, copyBytesIndex, chunkBytes.length);
            copyBytesIndex += chunkBytes.length;
        }
        return copyBytes;
    }

    @Override
    public void startTransaction() throws StorageException {
        this.joinSession();
        this.beginOSTransaction("startTransaction", 7);
    }

    @Override
    public void commitTransaction() throws StorageException {
        this.joinSession();
        this.commitOSTransaction();
    }

    @Override
    public void rollbackTransaction() throws StorageException {
        this.joinSession();
        if (this.m_transaction != null) {
            this.m_transaction.abort(2);
            if (DEBUG_TRANSACTION) {
                System.out.println("PSEStorage.rollbackTransaction " + this.m_transaction.toString());
            }
            this.m_transaction = null;
        }
    }

    @Override
    public void closeFiles() throws StorageException {
    }

    @Override
    public void openFiles() throws StorageException {
    }

    @Override
    public void setLogger(ILogger logger) {
        this.m_logger = logger;
    }

    @Override
    public void copyBlob(EntityName fromBlobName, EntityName toBlobName) throws StorageException {
        this.joinSession();
        boolean startedTransaction = false;
        if (this.m_startsUpdateTransactions && (!this.m_session.inTransaction() || this.m_session.currentTransaction().getType() != 7)) {
            this.beginOSTransaction("setElement", 7);
            startedTransaction = true;
        }
        String fBlobName = fromBlobName.getName();
        String tBlobName = toBlobName.getName();
        boolean newElement = false;
        if (DEBUG) {
            System.out.println("PSEStorage.copyBlob " + fBlobName + " " + tBlobName);
        }
        try {
            DSElement blobE = (DSElement)this.m_data.getFromPrimaryIndex(fBlobName);
            DSBlob header = null;
            if (blobE != null) {
                header = blobE.getBlob();
            }
            if (header != null) {
                DSElement newBlobE = (DSElement)this.m_data.getFromPrimaryIndex(tBlobName);
                DSBlob newHeader = null;
                if (newBlobE != null) {
                    newHeader = newBlobE.getBlob();
                } else {
                    newBlobE = new DSElement(tBlobName, null, null);
                    newElement = true;
                }
                if (newHeader != null) {
                    this.deleteBlobInternal(newBlobE);
                }
                newHeader = new DSBlob();
                for (int i = 0; i < header.getBlobLength(); ++i) {
                    DSBlobChunk fromChunk = header.getBlobChunk(i);
                    byte[] fromChunkArray = fromChunk.getBytes();
                    byte[] newArray = new byte[fromChunkArray.length];
                    System.arraycopy(fromChunkArray, 0, newArray, 0, fromChunkArray.length);
                    DSBlobChunk newChunk = new DSBlobChunk(newArray);
                    newHeader.addChunk(newChunk);
                }
                newBlobE.setBlob(newHeader);
                if (newElement) {
                    this.m_data.add(newBlobE);
                }
            }
        }
        catch (Exception e) {
            throw new StorageException("PSEStorage.copyBlob from " + fBlobName + " to " + tBlobName + " exception, see cause", e);
        }
        finally {
            if (startedTransaction) {
                this.commitOSTransaction();
            }
        }
    }

    private void joinSession() {
        boolean printed = false;
        Session currSession = Session.getCurrent();
        if (currSession != null && currSession != this.m_session) {
            if (DEBUG) {
                System.out.println("PSEStorage.joinSession thread " + Thread.currentThread() + " leaving session " + currSession);
                printed = true;
            }
            Session.leave();
        }
        if (currSession != this.m_session) {
            this.m_session.join();
            if (DEBUG) {
                System.out.println("PSEStorage.joinSession thread " + Thread.currentThread() + " just joined session: " + Session.getCurrent());
                printed = true;
            }
        }
        if (DEBUG && !printed) {
            System.out.println("PSEStorage.joinSession didn't switch a thing, current session = " + Session.getCurrent());
        }
    }

    private void setSession() {
        this.m_session = Session.create(null, null);
        if (DEBUG) {
            System.out.println("PSEStorage.setSession creating a new session " + this.m_session);
        }
    }

    private synchronized void beginOSTransaction(String methodName, int access) {
        if (this.m_transaction != null) {
            if (access == 7) {
                this.m_transaction.abort(2);
                this.m_transaction = Transaction.begin(access);
            }
        } else {
            this.m_transaction = Transaction.begin(access);
        }
        if (DEBUG_TRANSACTION) {
            System.out.println("PSEStorage.beginOSTransaction " + methodName + " in session " + this.m_session.toString().substring(this.m_session.toString().indexOf("Session")) + " transaction == " + this.m_transaction.toString().substring(this.m_transaction.toString().indexOf("Transaction")));
        }
    }

    private void commitOSTransaction() {
        Transaction temp = this.m_transaction;
        this.m_transaction.commit(2);
        this.m_transaction = null;
        if (DEBUG_TRANSACTION) {
            System.out.println("PSEStorage.commitTransaction after transaction.commit in session " + this.m_session.toString().substring(this.m_session.toString().indexOf("Session")) + " for transaction " + temp.toString().substring(temp.toString().indexOf("Transaction")));
        }
    }

    @Override
    public void closeTransactionManager() throws StorageException {
        this.joinSession();
        if (this.m_transaction != null) {
            this.m_transaction.abort(2);
            this.m_transaction = null;
        }
    }

    @Override
    public void backup(String backupDir) {
        this.m_store.backup(backupDir + DB_EXTENSION);
    }

    @Override
    public String[] collectionToStringArray(String collectionName) throws StorageException {
        if (this.m_collections == null) {
            throw new StorageException("Collection " + collectionName + " does not exist");
        }
        try {
            this.joinSession();
            this.beginOSTransaction("collectionToStringArray", 6);
            OSTreeSet collection = (OSTreeSet)this.m_collections.get(collectionName);
            if (collection == null) {
                collection = (OSTreeSet)this.m_store.getRoot(collectionName);
                if (collection == null) {
                    throw new StorageException("Collection " + collectionName + " does not exist");
                }
                this.m_collections.put(collectionName, collection);
            }
            Iterator iter = collection.iterator();
            ArrayList<String> list = new ArrayList<String>();
            while (iter.hasNext()) {
                CollectionElement el = (CollectionElement)iter.next();
                list.add(el.getName());
            }
            return list.toArray(EMPTY_STRING_ARRAY);
        }
        catch (Throwable t) {
            throw new StorageException(t.getMessage(), t);
        }
    }

    @Override
    public void removeFromCollection(String collectionName, String item) throws StorageException {
        this.removeFromCollection(collectionName, new String[]{item});
    }

    @Override
    public void removeFromCollection(String collectionName, String[] items) throws StorageException {
        if (this.m_collections == null) {
            throw new StorageException("Collection " + collectionName + " does not exist");
        }
        boolean startedTransaction = false;
        try {
            OSTreeSet collection;
            this.joinSession();
            if (this.m_startsUpdateTransactions && (!this.m_session.inTransaction() || this.m_session.currentTransaction().getType() != 7)) {
                this.beginOSTransaction("removeFromCollection", 7);
                startedTransaction = true;
            }
            if ((collection = (OSTreeSet)this.m_collections.get(collectionName)) == null) {
                collection = (OSTreeSet)this.m_store.getRoot(collectionName);
                if (collection == null) {
                    throw new StorageException("Collection " + collectionName + " does not exist");
                }
                this.m_collections.put(collectionName, collection);
            }
            for (int i = 0; i < items.length; ++i) {
                CollectionElement el = (CollectionElement)collection.getFromPrimaryIndex(items[i]);
                collection.remove(el);
                ObjectStore.destroy(el);
            }
        }
        catch (Throwable t) {
            throw new StorageException(t.getMessage(), t);
        }
        finally {
            if (startedTransaction) {
                this.commitOSTransaction();
            }
        }
    }

    @Override
    public void addToCollection(String collectionName, String item) throws StorageException {
        if (this.m_collections == null) {
            throw new StorageException("Collection " + collectionName + " does not exist");
        }
        boolean startedTransaction = false;
        try {
            OSTreeSet collection;
            this.joinSession();
            if (this.m_startsUpdateTransactions && (!this.m_session.inTransaction() || this.m_session.currentTransaction().getType() != 7)) {
                this.beginOSTransaction("addToCollection", 7);
                startedTransaction = true;
            }
            if ((collection = (OSTreeSet)this.m_collections.get(collectionName)) == null) {
                collection = (OSTreeSet)this.m_store.getRoot(collectionName);
                if (collection == null) {
                    throw new StorageException("Collection " + collectionName + " does not exist");
                }
                this.m_collections.put(collectionName, collection);
            }
            if (collection.getFromPrimaryIndex(item) == null) {
                collection.add(new CollectionElement(item));
            }
        }
        catch (Throwable t) {
            throw new StorageException(t.getMessage(), t);
        }
        finally {
            if (startedTransaction) {
                this.commitOSTransaction();
            }
        }
    }

    @Override
    public void createCollectionIfNotCreated(String collectionName) throws StorageException {
        if (this.m_collections == null) {
            this.m_collections = new HashMap();
        }
        if (this.m_collections.get(collectionName) != null) {
            return;
        }
        boolean startedTransaction = false;
        try {
            this.joinSession();
            if (this.m_startsUpdateTransactions && (!this.m_session.inTransaction() || this.m_session.currentTransaction().getType() != 7)) {
                this.beginOSTransaction("createCollection", 7);
                startedTransaction = true;
            }
            OSTreeSet collection = null;
            try {
                collection = (OSTreeSet)this.m_store.getRoot(collectionName);
            }
            catch (DatabaseRootNotFoundException databaseRootNotFoundException) {
                // empty catch block
            }
            if (collection == null) {
                collection = new OSTreeSet(this.m_store, this.DB_COLLECTION_CLASS, this.DB_COLLECTION_NAME_ATTRIBUTE);
                this.m_store.createRoot(collectionName, collection);
            }
            this.m_collections.put(collectionName, collection);
        }
        catch (Throwable t) {
            throw new StorageException(t.getMessage(), t);
        }
        finally {
            if (startedTransaction) {
                this.commitOSTransaction();
            }
        }
    }

    public static HashMap getCorruptIds() {
        return m_corruptIds;
    }

    public static boolean hasCorruptElements() {
        return m_corruptIds.size() > 0;
    }

    static {
        DSDUMP = Boolean.getBoolean("DSDUMP");
        m_corruptIds = new HashMap();
        String debug = System.getProperty("PSE_DEBUG", "false");
        DEBUG = new Boolean(debug);
        debug = System.getProperty("PSE_DEBUG_TRANSACTION", "false");
        DEBUG_TRANSACTION = DEBUG || new Boolean(debug) != false;
        EMPTY_STRING_ARRAY = new String[0];
    }
}

