/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.replication.ftchannel.blackbird;

import com.progress.blackbird.evs.EEvsIOException;
import com.progress.blackbird.evs.EEvsNotOwnerException;
import com.progress.blackbird.evs.EEvsTimeoutException;
import com.progress.blackbird.evs.IEvsDispatcher;
import com.progress.blackbird.evs.nio.EvsDispatcher;
import com.progress.blackbird.io.EIOException;
import com.progress.blackbird.io.IIOConnection;
import com.progress.blackbird.io.IIOConnectionEventHandler;
import com.progress.blackbird.io.IIOConnectionPacketHandler;
import com.progress.blackbird.io.IIOPacket;
import com.progress.blackbird.io.evs.IOMultiNetworkConnection;
import com.progress.blackbird.io.evs.IOMultiNetworkConnectionEvents;
import com.progress.blackbird.io.evs.IONetworkConnection;
import com.progress.blackbird.io.multi.IOMultiConnection;
import com.progress.blackbird.io.multi.IOMultiConnectionWeightedFlowBalancer;
import com.progress.blackbird.pdu.PDUPacketData;
import com.progress.blackbird.pdu.PDUPacketMultiConnectionPacketManager;
import com.progress.blackbird.pdu.PDUPacketNetworkConnectionPingPacketManager;
import com.progress.blackbird.pdu.PDUPacketSerializer;
import com.sonicsw.mtstorage.replication.ftchannel.ChannelConstants;
import com.sonicsw.mtstorage.replication.ftchannel.IActiveChannel;
import com.sonicsw.mtstorage.replication.ftchannel.IChannelListener;
import com.sonicsw.mtstorage.replication.ftchannel.PermanentException;
import com.sonicsw.mtstorage.replication.ftchannel.blackbird.PassiveChannel;
import com.sonicsw.mtstorage.replication.util.BitUtil;
import com.sonicsw.mtstorage.replication.util.Tracer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;

public class ActiveChannel
implements IActiveChannel,
ChannelConstants,
IIOConnectionPacketHandler,
IIOConnectionEventHandler {
    private String[] m_urls = null;
    private int[] m_connectionsByWeights = null;
    private IONetworkConnection.Parameters[] m_urlConnectionParameters = null;
    private boolean m_connOpen = false;
    private boolean m_closing = false;
    private boolean m_dispatchRunning = false;
    private IIOConnection m_connection = null;
    private IChannelListener m_listener;
    private HashMap m_parameters = null;
    private boolean m_isPrimary;
    private boolean m_reportConnFailuers = true;
    private static final int TEST_FAIL_NONE = -1;

    public static void main(String[] args) throws Exception {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("HOST", args[0]);
        config.put("PORT", new Integer(args[1]));
        config.put("PROTOCOL", "tcp");
        HashMap[] configs = new HashMap[]{config};
        ActiveChannel ch = new ActiveChannel();
        boolean notConnected = true;
        while (notConnected) {
            try {
                ch.open(configs, null, new TestListener(), false, false, true);
                notConnected = false;
            }
            catch (Exception e) {
                e.printStackTrace();
                Thread.sleep(5000L);
            }
        }
        byte[] data = new byte[10];
        data[9] = 11;
        BitUtil.putInt(data, 0, 6);
        for (int i = 0; i < 5; ++i) {
            Thread.sleep(1000L);
            ch.send(data, 0, 10);
        }
        Thread.sleep(1000000000L);
    }

    @Override
    public synchronized void open(HashMap[] connections, HashMap parameters, IChannelListener listener, boolean alwaysRetry, boolean isPrimary, boolean reportConnFailuers) throws IOException, PermanentException {
        this.m_reportConnFailuers = reportConnFailuers;
        this.m_isPrimary = isPrimary;
        this.m_parameters = parameters;
        this.m_connectionsByWeights = PassiveChannel.sortByWeight(connections);
        if (this.m_connection == null) {
            this.createConnection(connections, listener, alwaysRetry);
        }
        try {
            Tracer.VERBOSE_TRACE("ActiveChannel trying to connect to " + this.m_urls[0] + " (showing one of the urls)");
            this.m_connection.connect();
            this.m_connOpen = true;
            Tracer.TRACE("ActiveChannel Connected to " + this.m_urls[0] + " (showing one of the urls)");
        }
        catch (EIOException e) {
            Tracer.TRACE(e);
            IOException ioe = new IOException(e.toString(), e);
            throw ioe;
        }
        catch (RuntimeException e) {
            Tracer.TRACE(e);
            if (!alwaysRetry) {
                PermanentException pe = new PermanentException(e.toString());
                pe.initCause(e);
                throw pe;
            }
            IOException ioe = new IOException(e.toString(), e);
            throw ioe;
        }
        catch (Throwable t) {
            Tracer.TRACE(t);
            PermanentException pe = new PermanentException(t.toString());
            pe.initCause(t);
            throw pe;
        }
        this.disptachInboundData();
        String testFile = System.getProperty("_TEST_PSEReplication_CommFailure");
        if (testFile != null) {
            this.testCommunication(testFile);
        }
    }

    @Override
    public void doNotReportFailure() {
        this.m_reportConnFailuers = false;
    }

    synchronized void open(IIOConnection connection, String[] urls, int[] connectionsByWeights, HashMap parameters, IChannelListener listener, boolean alwaysRetryUnused, boolean isPrimary, boolean reportConnFailuers) throws IOException {
        this.m_reportConnFailuers = reportConnFailuers;
        this.m_isPrimary = isPrimary;
        this.m_parameters = parameters;
        this.m_connection = connection;
        this.m_urls = urls;
        this.m_connectionsByWeights = connectionsByWeights;
        this.m_connOpen = true;
        this.m_listener = listener;
        this.disptachInboundData();
    }

    private void createConnection(HashMap[] connections, IChannelListener listener, boolean alwaysRetry) throws IOException, PermanentException {
        this.m_listener = listener;
        this.m_urls = new String[connections.length];
        this.m_urlConnectionParameters = new IONetworkConnection.Parameters[connections.length];
        for (int i = 0; i < this.m_urls.length; ++i) {
            this.m_urls[i] = PassiveChannel.mapToURL(connections[i], this.m_parameters, this.m_isPrimary, true);
            this.m_urlConnectionParameters[i] = ActiveChannel.createUrlConnectionParameters(this.m_parameters);
            Tracer.TRACE("ActiveChannel Connect to replication connection " + this.m_urls[i]);
        }
        try {
            this.m_connection = IOMultiNetworkConnection.create(true, this.m_urls, true, this.m_urlConnectionParameters, PDUPacketSerializer.create(), PDUPacketNetworkConnectionPingPacketManager.create(), this, PDUPacketMultiConnectionPacketManager.create(), IOMultiConnectionWeightedFlowBalancer.create(), ActiveChannel.createParameters(this.m_parameters));
        }
        catch (EIOException e) {
            Tracer.TRACE(e);
            if (alwaysRetry) {
                throw new IOException(e.toString());
            }
            throw new PermanentException(e);
        }
    }

    @Override
    public synchronized void send(byte[] data, int offset, int length) throws IOException {
        if (!this.m_connOpen || this.m_closing) {
            throw new IOException("The connection is down");
        }
        PDUPacketData packet = PDUPacketData.create(data, offset, length);
        try {
            this.m_connection.write(packet, null, 1);
            this.m_connection.flush(null);
        }
        catch (EIOException e) {
            Tracer.TRACE(e);
            throw new IOException(e.toString(), e);
        }
    }

    @Override
    public synchronized void close(boolean justMark) {
        Tracer.TRACE("ActiveChannel close; just mark closing " + justMark);
        this.m_closing = true;
        if (justMark) {
            return;
        }
        this.doClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void doClose() {
        if (this.m_connection == null) {
            return;
        }
        if (this.m_connOpen) {
            this.waitForDisptachTermination();
        }
        try {
            this.m_connection.close();
        }
        catch (Exception e) {
            Tracer.TRACE(e);
        }
        finally {
            this.m_connection = null;
            this.m_connOpen = false;
        }
    }

    private synchronized void waitForDisptachTermination() {
        while (this.m_dispatchRunning) {
            try {
                this.wait();
            }
            catch (InterruptedException ie) {
                break;
            }
        }
    }

    private synchronized void dispatchTerminated() {
        if (this.m_dispatchRunning) {
            this.m_dispatchRunning = false;
            this.notifyAll();
        }
    }

    private void disptachInboundData() {
        Thread dispatchThread = new Thread("PSE ftchannel.blackbird.ActiveChannel dipatcher"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                IEvsDispatcher dispatcher = null;
                try {
                    dispatcher = EvsDispatcher.create("reader", true, null);
                    ActiveChannel.this.m_connection.read(dispatcher, ActiveChannel.this);
                    ActiveChannel.this.m_dispatchRunning = true;
                    while (!ActiveChannel.this.m_closing) {
                        try {
                            dispatcher.dispatch(300);
                        }
                        catch (EEvsTimeoutException e) {}
                    }
                    ActiveChannel.this.m_connection.read(null, null);
                    try {
                        while (ActiveChannel.this.m_connection.isInboundStreamOpen()) {
                            dispatcher.dispatch(-1);
                        }
                    }
                    catch (Throwable t) {
                        Tracer.TRACE(t);
                    }
                }
                catch (Throwable e) {
                    ActiveChannel.this.dispatchTerminated();
                    Tracer.TRACE(e);
                    ActiveChannel.this.doClose();
                    if (!ActiveChannel.this.m_closing && ActiveChannel.this.m_listener != null) {
                        ActiveChannel.this.m_listener.connectionDropped(ActiveChannel.this.m_reportConnFailuers ? e.toString() : null);
                    }
                }
                finally {
                    ActiveChannel.this.dispatchTerminated();
                    try {
                        dispatcher.close();
                    }
                    catch (EEvsNotOwnerException e) {
                        Tracer.TRACE(e);
                    }
                    catch (EEvsIOException e) {
                        Tracer.TRACE(e);
                    }
                }
            }
        };
        dispatchThread.setDaemon(true);
        dispatchThread.start();
    }

    @Override
    public final void handlePacket(EIOException status, IIOPacket iopacket) {
        if (this.m_closing || this.m_listener == null) {
            return;
        }
        if (status != null) {
            Tracer.TRACE("ActiveChannel connection dropped: " + status.getMessage());
            String errorMessage = "Lost all replication connections: " + status.getMessage();
            this.m_listener.connectionDropped(this.m_reportConnFailuers ? errorMessage : null);
            return;
        }
        byte[] data = ((PDUPacketData)iopacket).getData();
        byte[] msgBuffer = new byte[data.length - 4];
        System.arraycopy(data, 4, msgBuffer, 0, msgBuffer.length);
        this.m_listener.messageReceived(msgBuffer);
    }

    private String cleanDescriptor(String descriptor0) {
        int descParamStart;
        String descriptor = descriptor0;
        if (descriptor0 != null && (descParamStart = descriptor0.indexOf("&weight")) != -1) {
            descriptor = descriptor0.substring(0, descParamStart);
        }
        return descriptor;
    }

    @Override
    public final void handleEvent(int event, Object data) {
        if (this.m_closing) {
            return;
        }
        String eventInfo = null;
        String eventString = "Replication connection ";
        switch (event) {
            case 300: {
                IOMultiNetworkConnectionEvents.ConnectionConnectFailEventData failEventData = (IOMultiNetworkConnectionEvents.ConnectionConnectFailEventData)data;
                String descriptor = this.cleanDescriptor(failEventData.descriptor);
                eventInfo = ((Throwable)failEventData.cause).getMessage();
                Tracer.TRACE((Throwable)failEventData.cause);
                eventString = eventString + descriptor + " failed to connect";
                break;
            }
            case 301: {
                IOMultiNetworkConnectionEvents.ConnectionUpEventData upEventData = (IOMultiNetworkConnectionEvents.ConnectionUpEventData)data;
                String descriptor = this.cleanDescriptor(upEventData.descriptor);
                eventString = eventString + descriptor + " (re)established ";
                break;
            }
            case 302: {
                IOMultiNetworkConnectionEvents.ConnectionDownEventData downEventData = (IOMultiNetworkConnectionEvents.ConnectionDownEventData)data;
                String descriptor = this.cleanDescriptor(downEventData.descriptor);
                eventInfo = ((Throwable)downEventData.cause).getMessage();
                Tracer.TRACE((Throwable)downEventData.cause);
                eventString = eventString + descriptor + " lost";
                break;
            }
            default: {
                eventString = "Event " + event + " occured in connection <unknown>";
            }
        }
        if (eventInfo != null) {
            eventString = eventString + ": " + eventInfo;
        }
        if (this.m_listener == null) {
            return;
        }
        if (this.m_reportConnFailuers) {
            this.m_listener.reportEvent(eventString, event != 301);
        }
    }

    private void testCommunication(final String testFile) {
        System.out.println("_TEST_PSEReplication_CommFailure is set: Communication Test Thread is ON; test file " + testFile);
        Thread testThread = new Thread("Test Communication"){

            @Override
            public void run() {
                while (!ActiveChannel.this.m_closing) {
                    int testWeightIndicator;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if ((testWeightIndicator = ActiveChannel.this.testCommFailure(testFile)) == -1) continue;
                    ActiveChannel.this.testStopConnection(testWeightIndicator);
                    return;
                }
            }
        };
        testThread.setDaemon(true);
        testThread.start();
    }

    private int testCommFailure(String testFile) {
        File testConnFile = new File(testFile);
        if (testConnFile.exists()) {
            try {
                FileInputStream s = new FileInputStream(testConnFile);
                int weightIndicator = ((InputStream)s).read();
                ((InputStream)s).close();
                testConnFile.delete();
                return (weightIndicator -= 48) >= 0 ? weightIndicator : 0;
            }
            catch (Exception e) {
                return -1;
            }
        }
        return -1;
    }

    private void testStopConnection(int testWeightIndicator) {
        if (testWeightIndicator >= this.m_connectionsByWeights.length) {
            testWeightIndicator = this.m_connectionsByWeights.length - 1;
        }
        int connIndicator = this.m_connectionsByWeights[testWeightIndicator];
        try {
            System.out.println("Test: Calling Blackbird's FailureGovernor.forceFail() for connection: " + this.m_urls[connIndicator]);
            IONetworkConnection netConn = ((IOMultiNetworkConnection)this.m_connection).getUnderlyingConnection(this.m_urls[connIndicator]);
            netConn.getFailureGovernor().forceFail();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static IONetworkConnection.Parameters createUrlConnectionParameters(HashMap parameters) {
        IONetworkConnection.Parameters networkConnParameters = null;
        if (parameters != null) {
            int connectionPingInterval = (Integer)parameters.get("REPLICATION_PING_INTERVAL");
            networkConnParameters = IONetworkConnection.Parameters.create(connectionPingInterval, 0);
        }
        return networkConnParameters;
    }

    static IOMultiNetworkConnection.Parameters createParameters(HashMap parameters) {
        IOMultiNetworkConnection.Parameters multiNetworkConnParameters = null;
        if (parameters != null) {
            int connectionRetryInterval = (Integer)parameters.get("REPLICATION_RETRY_INTERVAL");
            IOMultiConnection.Parameters multiConnParameters = IOMultiConnection.Parameters.create(2, 0);
            multiNetworkConnParameters = IOMultiNetworkConnection.Parameters.create("", connectionRetryInterval, 1, 0, multiConnParameters);
        }
        return multiNetworkConnParameters;
    }

    static class TestListener
    implements IChannelListener {
        TestListener() {
        }

        @Override
        public void connectionDropped(String message) {
            System.out.println("connectionDropped: " + message);
        }

        @Override
        public void reportEvent(String event, boolean warning) {
            System.out.println("reportEvent: " + event);
        }

        @Override
        public void messageReceived(byte[] message) {
            System.out.println("messageReceived: " + message.length + " bytes ");
        }
    }
}

