/*
 * Decompiled with CFR 0.152.
 */
package com.odi;

import com.odi.Database;
import com.odi.ObjectStoreException;
import com.odi.imp.ObjectManager;

public class ExternalReference
implements Cloneable {
    private static final int NULL_SEGMENTID = -1;
    private static final int NULL_CLUSTERID = -1;
    private static final long NULL_LOCATION = -1L;
    private Database database;
    private int clusterId = -1;
    private int segmentId = -1;
    private long location = -1L;

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof ExternalReference) {
            ExternalReference e = (ExternalReference)obj;
            return e.segmentId == this.segmentId && e.clusterId == this.clusterId && e.location == this.location && (e.database == this.database || e.database.getPath().equals(this.database.getPath()));
        }
        return false;
    }

    public int hashCode() {
        return (int)((long)(((com.odi.imp.Database)this.database).getDatabaseId() ^ this.segmentId) ^ this.location);
    }

    public Database getDatabase() {
        return this.database;
    }

    public int getSegmentId() {
        return this.segmentId;
    }

    public int getClusterId() {
        return this.clusterId;
    }

    public long getLocation() {
        return this.location;
    }

    public void setDatabase(Database d) {
        this.database = d;
    }

    public void setSegmentId(int segid) {
        this.segmentId = segid;
    }

    public void setClusterId(int cluid) {
        this.clusterId = cluid;
    }

    public void setLocation(long loc) {
        this.location = loc;
    }

    public ExternalReference() {
        this.setObject(null);
    }

    public ExternalReference(Object o) {
        this.setObject(o);
    }

    public ExternalReference(Database d, int segid, int cluid, long loc) {
        this.database = d;
        this.segmentId = segid;
        this.clusterId = cluid;
        this.location = loc;
    }

    public Object getObject() {
        return ObjectManager.getExtRef(this);
    }

    public void setObject(Object o) {
        if (o == null) {
            this.setNull();
        }
        ObjectManager.setExtRef(o, this);
    }

    public String toString() {
        if (this.database == null) {
            return "NULL";
        }
        String path = this.database.getPath();
        if (path.indexOf(124) != -1) {
            throw new ObjectStoreException("Cannot encode a pathname with a | in it: " + path);
        }
        if (this.segmentId == 0) {
            if (this.clusterId == 0) {
                return path + "|" + this.location;
            }
            return path + "|" + this.segmentId + " " + this.location;
        }
        return path + "|" + this.segmentId + " " + this.clusterId + " " + this.location;
    }

    public static ExternalReference fromString(String string) {
        if (string.equals("NULL")) {
            return new ExternalReference();
        }
        int vbar = string.indexOf(124);
        if (vbar == -1) {
            throw new IllegalArgumentException("Invalid encoded ExternalReference (there is no |): " + string);
        }
        String path = string.substring(0, vbar);
        int segId = 0;
        int cluId = 0;
        long loc = 0L;
        int locStart = vbar + 1;
        int space = string.indexOf(32, vbar + 1);
        if (space >= 0) {
            try {
                segId = Integer.parseInt(string.substring(vbar + 1, space));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid encoded ExternalReference (the segment id is not a number): " + string);
            }
            if (segId < 0) {
                throw new IllegalArgumentException(segId + " is not a valid segment ID");
            }
            locStart = space + 1;
            int space2 = string.indexOf(32, space + 1);
            if (space2 >= 0) {
                try {
                    cluId = Integer.parseInt(string.substring(space + 1, space2));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Invalid encoded ExternalReference (the cluster id is not a number): " + string);
                }
                if (cluId < 0 && cluId != -4) {
                    throw new IllegalArgumentException(cluId + " is not a valid cluster ID");
                }
                locStart = space2 + 1;
            }
        }
        try {
            loc = Long.parseLong(string.substring(locStart));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid encoded ExternalReference (the location is not a number): " + string);
        }
        return new ExternalReference(Database.open(path, 8), segId, cluId, loc);
    }

    public boolean isNull() {
        return this.database == null && this.segmentId == -1 && this.clusterId == -1 && this.location == -1L;
    }

    public void setNull() {
        this.database = null;
        this.segmentId = -1;
        this.clusterId = -1;
        this.location = -1L;
    }
}

