/*
 * Decompiled with CFR 0.152.
 */
package com.odi.imp.mtsonic;

import com.odi.FatalInternalException;
import com.odi.imp.ObjectAccess;
import com.odi.imp.ObjectReference;
import com.odi.imp.ReferenceType;
import com.odi.imp.mtsonic.ObjectTable;
import com.odi.imp.mtsonic.Server;

public final class ObjectAccess8ByteObjRefFormat
extends ObjectAccess {
    private static final int OIDOffset = 0;
    private static final int OIDOffset2 = 8;
    private static final int OIDMask = 0xFFFFFF;
    private static final int OIDShift = 8;
    private static final int typeCodeOffset = 3;
    private static final int typeCodeMask = 0xFFFFFF;
    private static final int typeCodeShift = 8;
    private static final int immStringFlagOffset = 4;
    private static final int immStringFlagMask = 128;
    private static final int immTypeCodeOffset = 3;
    private static final int immTypeCodeMask = 255;
    private static final int countOffset = 6;
    private static final int countMask = 65535;
    private static final int countShift = 0;
    private static final int countMax = 65535;
    private static final int immValueOffset = 4;
    private static final byte proReferenceSize = 13;
    private static final int immValueWidth = 4;
    private static final int immRefByteOffset = 7;
    private static final int immRefShortOffset = 6;
    private static final int immRefCharOffset = 6;
    private static final int immRefIntOffset = 4;
    private static final int immRefLongOffset = 0;
    private static final int immRefFloatOffset = 4;
    private static final int immRefDoubleOffset = 0;
    private static final int immRefBooleanOffset = 7;
    private static final int MAX_IMM_STRING_LENGTH = 8;
    final char[] stringBuffer = new char[8];
    Server sv;
    byte[] typeSizes;
    ObjectTable objectTable;

    ObjectAccess8ByteObjRefFormat(Server sv) {
        super(sv, true);
        this.sv = sv;
        this.referenceSize = (byte)13;
        this.typeSizes = new byte[111];
        this.typeSizes[83] = this.referenceSize;
        this.typeSizes[84] = this.referenceSize;
        this.typeSizes[79] = this.referenceSize;
        this.typeSizes[80] = this.referenceSize;
        this.typeSizes[87] = this.referenceSize;
        this.typeSizes[91] = this.referenceSize;
        for (int i = 1; i <= 4; ++i) {
            ReferenceType ref = ReferenceType.getReferenceType(i);
            this.typeSizes[74 + i] = (byte)ref.size();
        }
        this.typeSizes[98] = 1;
        this.typeSizes[100] = 2;
        this.typeSizes[102] = 4;
        this.typeSizes[104] = 8;
        this.typeSizes[107] = 1;
        this.typeSizes[108] = 2;
        this.typeSizes[109] = 4;
        this.typeSizes[110] = 8;
    }

    public void setObjectTable(ObjectTable newOT) {
        this.objectTable = newOT;
    }

    @Override
    public long decodeObjRefLocation(byte[] b, int startIndex) {
        return ObjectAccess8ByteObjRefFormat.getLong(b, startIndex + 0);
    }

    @Override
    public int decodeObjRefDatabaseId(byte[] buffer, int startIndex) {
        return this.sv.currentDatabase.getDatabaseId();
    }

    @Override
    public int decodeObjRefSegmentId(byte[] buffer, int startIndex) {
        return 0;
    }

    @Override
    public int decodeObjRefClusterId(byte[] buffer, int startIndex) {
        return 0;
    }

    @Override
    public boolean isNull(byte[] b, int i) {
        return (b[i] & b[i + 1] & b[i + 2] & b[i + 3]) == -1;
    }

    static boolean isObject(int value) {
        return value != 0xFFFFFF;
    }

    @Override
    public boolean isImmediateObject(byte[] b, int i) {
        if ((b[i + 4] & 0x80) != 0) {
            return true;
        }
        return (b[i] & b[i + 1]) == -1 && b[i + 2] == -1 && b[i + 3] != -1;
    }

    @Override
    public boolean isImmediateString(byte[] b, int i) {
        return (b[i] & b[i + 1] & b[i + 2]) != -1 && (b[i + 4] & 0x80) != 0;
    }

    @Override
    public int decodeObjRefTypeCode(byte[] b, int i) {
        return this.isImmediateObject(b, i) ? ObjectAccess8ByteObjRefFormat.decodeByte(b, i + 3) & 0xFF : ObjectAccess8ByteObjRefFormat.decode3ByteInt(b, i + 3) & 0xFFFFFF;
    }

    @Override
    public int decodeObjRefArrayElementCount(byte[] buffer, int startIndex) {
        int arrayElementCount = ObjectAccess8ByteObjRefFormat.decodeShort(buffer, startIndex + 6) >>> 0 & 0xFFFF;
        if (arrayElementCount == 65535) {
            arrayElementCount = this.objectTable.getArrayElementCount(this.decodeObjRefLocation(buffer, startIndex), this.decodeObjRefTypeCode(buffer, startIndex));
        }
        return arrayElementCount;
    }

    @Override
    public byte decodeImmByteRef(byte[] buffer, int startIndex) {
        return ObjectAccess8ByteObjRefFormat.decodeByte(buffer, startIndex + 7);
    }

    @Override
    public char decodeImmCharRef(byte[] buffer, int startIndex) {
        return ObjectAccess8ByteObjRefFormat.decodeChar(buffer, startIndex + 6);
    }

    @Override
    public short decodeImmShortRef(byte[] buffer, int startIndex) {
        return ObjectAccess8ByteObjRefFormat.decodeShort(buffer, startIndex + 6);
    }

    @Override
    public int decodeImmIntegerRef(byte[] buffer, int startIndex) {
        return ObjectAccess8ByteObjRefFormat.decodeInt(buffer, startIndex + 4);
    }

    @Override
    public long decodeImmLongRef(byte[] buffer, int startIndex) {
        if (buffer != null) {
            throw new FatalInternalException("Long immediate values are impossible.");
        }
        return 0L;
    }

    @Override
    public float decodeImmFloatRef(byte[] buffer, int startIndex) {
        return ObjectAccess8ByteObjRefFormat.decodeFloat(buffer, startIndex + 4);
    }

    @Override
    public double decodeImmDoubleRef(byte[] buffer, int startIndex) {
        if (buffer != null) {
            throw new FatalInternalException("Double immediate values are impossible.");
        }
        return 0.0;
    }

    @Override
    public boolean decodeImmBooleanRef(byte[] buffer, int startIndex) {
        return ObjectAccess8ByteObjRefFormat.decodeBoolean(buffer, startIndex + 7);
    }

    @Override
    protected boolean isImmRefEncodable(int primType) {
        return primType >= 1 && primType <= 6 || primType >= 11 && primType <= 13;
    }

    @Override
    protected boolean isImmRefEncodable(String string) {
        char charValue = '\u0000';
        switch (string.length()) {
            default: {
                return false;
            }
            case 8: {
                charValue = string.charAt(7);
                if (charValue >= '\u007f') {
                    return false;
                }
            }
            case 7: {
                charValue = string.charAt(6);
                if (charValue >= '\u00fe') {
                    return false;
                }
            }
            case 6: {
                charValue = string.charAt(5);
                if (charValue >= '\u00fe') {
                    return false;
                }
            }
            case 5: {
                charValue = string.charAt(4);
                if (charValue >= '\u00fe') {
                    return false;
                }
            }
            case 4: {
                charValue = string.charAt(3);
                if (charValue >= '\u00fe') {
                    return false;
                }
            }
            case 3: {
                charValue = string.charAt(2);
                if (charValue >= '\u00fe') {
                    return false;
                }
            }
            case 2: {
                charValue = string.charAt(1);
                if (charValue >= '\u00fe') {
                    return false;
                }
            }
            case 1: {
                charValue = string.charAt(0);
                if (charValue < '\u00fe') break;
                return false;
            }
            case 0: 
        }
        return true;
    }

    @Override
    public void encodeImmByteRef(byte[] buffer, int startIndex, byte value) {
        ObjectAccess8ByteObjRefFormat.encodeInt(buffer, startIndex, -254);
        ObjectAccess8ByteObjRefFormat.encodeByte(buffer, startIndex + 7, value);
    }

    @Override
    public void encodeImmCharRef(byte[] buffer, int startIndex, char value) {
        ObjectAccess8ByteObjRefFormat.encodeInt(buffer, startIndex, -244);
        ObjectAccess8ByteObjRefFormat.encodeChar(buffer, startIndex + 6, value);
    }

    @Override
    public void encodeImmShortRef(byte[] buffer, int startIndex, short value) {
        ObjectAccess8ByteObjRefFormat.encodeInt(buffer, startIndex, -252);
        ObjectAccess8ByteObjRefFormat.encodeShort(buffer, startIndex + 6, value);
    }

    @Override
    public void encodeImmIntegerRef(byte[] buffer, int startIndex, int value) {
        ObjectAccess8ByteObjRefFormat.encodeInt(buffer, startIndex, -250);
        ObjectAccess8ByteObjRefFormat.encodeInt(buffer, startIndex + 4, value);
    }

    @Override
    public void encodeImmLongRef(byte[] buffer, int startIndex, long value) {
        throw new FatalInternalException("Immediate OOP encoding of a long cannot be supported.");
    }

    @Override
    public void encodeImmFloatRef(byte[] buffer, int startIndex, float value) {
        ObjectAccess8ByteObjRefFormat.encodeInt(buffer, startIndex, -243);
        ObjectAccess8ByteObjRefFormat.encodeFloat(buffer, startIndex + 4, value);
    }

    @Override
    public void encodeImmDoubleRef(byte[] buffer, int startIndex, double value) {
        throw new FatalInternalException("Immediate OOP encoding of a long cannot be supported.");
    }

    @Override
    public void encodeImmBooleanRef(byte[] buffer, int startIndex, boolean value) {
        ObjectAccess8ByteObjRefFormat.encodeInt(buffer, startIndex, -245);
        ObjectAccess8ByteObjRefFormat.encodeBoolean(buffer, startIndex + 7, value);
    }

    @Override
    public String decodeImmStringRef(byte[] buffer, int startIndex) {
        if (!this.isImmediateString(buffer, startIndex)) {
            throw new FatalInternalException("Not an immediate string Ref");
        }
        int length = 0;
        int offset = 5;
        while (length < 8) {
            if (offset == 8) {
                offset = 0;
            }
            byte b = buffer[startIndex + offset];
            if (offset == 4) {
                b = (byte)(b & 0xFFFFFF7F);
            }
            if (b == 0) break;
            this.stringBuffer[length] = (char)(0xFF & b - 1);
            ++length;
            ++offset;
        }
        return new String(this.stringBuffer, 0, length);
    }

    @Override
    public void encodeImmStringRef(byte[] buffer, int startIndex, String string) {
        int length = string.length();
        int offset = 5;
        int i = 0;
        while (i < length) {
            if (offset == 8) {
                offset = 0;
            }
            ObjectAccess8ByteObjRefFormat.encodeByte(buffer, startIndex + offset, (byte)((byte)string.charAt(i) + 1));
            ++i;
            ++offset;
        }
        if (length < 8) {
            if (offset == 8) {
                offset = 0;
            }
            ObjectAccess8ByteObjRefFormat.encodeByte(buffer, startIndex + offset, (byte)0);
        }
        int n = startIndex + 4;
        buffer[n] = (byte)(buffer[n] | 0x80);
        if (length < 3) {
            ObjectAccess8ByteObjRefFormat.encodeByte(buffer, startIndex, (byte)0);
        }
    }

    @Override
    public void encodeObjRef(byte[] buffer, int startIndex, ObjectReference objRef) {
        ObjectAccess8ByteObjRefFormat.putLong(buffer, startIndex + 0, objRef.getLocation());
        ObjectAccess8ByteObjRefFormat.encode3ByteInt(buffer, startIndex + 3, objRef.getAFTypeCode());
        int arrayElementCount = objRef.getArrayElementCount();
        if (arrayElementCount > 65535) {
            arrayElementCount = 65535;
        }
        ObjectAccess8ByteObjRefFormat.encodeShort(buffer, startIndex + 6, (short)arrayElementCount);
    }

    @Override
    public void encodeNull(byte[] buffer, int startIndex) {
        buffer[startIndex++] = -1;
        buffer[startIndex++] = -1;
        buffer[startIndex++] = -1;
        buffer[startIndex] = -1;
    }

    private static long getLong(byte[] b, int off) {
        return (((long)b[off + 8 + 4] & 0xFFL) << 0) + (((long)b[off + 8 + 3] & 0xFFL) << 8) + (((long)b[off + 8 + 2] & 0xFFL) << 16) + (((long)b[off + 8 + 1] & 0xFFL) << 24) + (((long)b[off + 8] & 0xFFL) << 32) + (((long)b[off + 2] & 0xFFL) << 40) + (((long)b[off + 1] & 0xFFL) << 48) + (((long)b[off + 0] & 0xFFL) << 56);
    }

    private static void putLong(byte[] b, int off, long val) {
        b[off + 8 + 4] = (byte)(val >>> 0);
        b[off + 8 + 3] = (byte)(val >>> 8);
        b[off + 8 + 2] = (byte)(val >>> 16);
        b[off + 8 + 1] = (byte)(val >>> 24);
        b[off + 8] = (byte)(val >>> 32);
        b[off + 2] = (byte)(val >>> 40);
        b[off + 1] = (byte)(val >>> 48);
        b[off + 0] = (byte)(val >>> 56);
    }
}

