/*
 * Decompiled with CFR 0.152.
 */
package com.odi.tools;

import com.odi.tools.AccumulatorEntry;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Vector;

public class Accumulator {
    private Vector entries = new Vector(101);

    public void reset() {
        this.entries.removeAllElements();
    }

    public void Accumulate(String typeName, int totalBytes) {
        AccumulatorEntry entry = null;
        Enumeration e = this.entries.elements();
        while (e.hasMoreElements()) {
            AccumulatorEntry ent = (AccumulatorEntry)e.nextElement();
            if (!ent.typeName.equals(typeName)) continue;
            entry = ent;
            break;
        }
        if (entry == null) {
            entry = new AccumulatorEntry(typeName);
            this.entries.addElement(entry);
        }
        entry.Accumulate(totalBytes);
    }

    Enumeration elements() {
        return this.entries.elements();
    }

    public void dump(PrintStream out) {
        out.println();
        out.println("     Count    Total Bytes  Type");
        out.println("     =====    ===========  ====");
        this.sort();
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            AccumulatorEntry ent = (AccumulatorEntry)e.nextElement();
            ent.dump(out);
        }
    }

    public void sort() {
        int nElements;
        for (int i = nElements = this.entries.size(); i >= 0; --i) {
            for (int j = 0; j < i - 1; ++j) {
                AccumulatorEntry e1 = (AccumulatorEntry)this.entries.elementAt(j + 1);
                AccumulatorEntry e2 = (AccumulatorEntry)this.entries.elementAt(j);
                if (e1.typeName.compareTo(e2.typeName) >= 0) continue;
                AccumulatorEntry tmp = e1;
                this.entries.setElementAt(e2, j + 1);
                this.entries.setElementAt(tmp, j);
            }
        }
    }
}

