/*
 * Decompiled with CFR 0.152.
 */
package com.odi.util;

import com.odi.ClassInfo;
import com.odi.Cluster;
import com.odi.GenericObject;
import com.odi.IPersistent;
import com.odi.IPersistentHooks;
import com.odi.ObjectStore;
import com.odi.Placement;
import com.odi.imp.ObjectManager;
import com.odi.imp.ObjectReference;
import com.odi.imp.Reference;
import com.odi.imp.ReferenceType;
import com.odi.imp.Utilities;
import com.odi.util.BTree;
import com.odi.util.BTreeEntryNotFoundException;
import com.odi.util.BTreeIndexIterator;
import com.odi.util.BTreeIterator;
import com.odi.util.BTreeNode;
import com.odi.util.DuplicateKeyException;
import com.odi.util.IndexException;
import com.odi.util.IndexIterator;
import com.odi.util.IndexMap;
import com.odi.util.MapKeys;
import com.odi.util.Path;
import java.io.Serializable;
import java.util.Collection;
import java.util.NoSuchElementException;

public class BTreeIndex
implements IPersistent,
IPersistentHooks,
Cloneable,
IndexMap,
Serializable {
    static final long serialVersionUID = -2560325264740659334L;
    private static final ClassInfo classinfo = ClassInfo.register(ClassInfo.getDynamic("com.odi.util.BTreeIndex"));
    private transient int keyType;
    private transient ObjectManager om;
    private transient Cluster cluster;
    private BTree tree;
    private Path path;
    private boolean isOrdered;
    private boolean hasDuplicates;
    private transient ObjectReference ref;
    public transient byte objectState;

    @Override
    public void initializeContents(GenericObject genObject) {
        this.tree = (BTree)genObject.getClassField(1, classinfo);
        this.path = (Path)genObject.getClassField(2, classinfo);
        this.isOrdered = genObject.getBooleanField(3, classinfo);
        this.hasDuplicates = genObject.getBooleanField(4, classinfo);
        this.tree.setPathInfo(this.path.getClassString() + "." + this.path.getPathString());
    }

    @Override
    public void flushContents(GenericObject genObject) {
        genObject.setClassField(1, this.tree, classinfo);
        genObject.setClassField(2, this.path, classinfo);
        genObject.setBooleanField(3, this.isOrdered, classinfo);
        genObject.setBooleanField(4, this.hasDuplicates, classinfo);
    }

    @Override
    public void clearContents() {
        this.tree = null;
        this.path = null;
        this.isOrdered = false;
        this.hasDuplicates = false;
    }

    @Override
    public void preDestroyPersistent() {
        ObjectStore.fetch(this);
        ObjectStore.destroy(this.tree);
        ObjectStore.destroy(this.path);
    }

    @Override
    public void postInitializeContents() {
        this.cluster = Cluster.of(this);
        this.om = (ObjectManager)this.cluster.getSession();
        Class keyClass = this.path.getKeyType();
        this.keyType = MapKeys.keyType(keyClass, this.om);
        int keySize = MapKeys.keySize(this.keyType);
    }

    @Override
    public void preFlushContents() {
    }

    @Override
    public void preClearContents() {
    }

    @Override
    public final ObjectReference ODIgetRef() {
        return this.ref;
    }

    @Override
    public final void ODIsetRef(ObjectReference ref) {
        this.ref = ref;
    }

    @Override
    public final byte ODIgetState() {
        return this.objectState;
    }

    @Override
    public final void ODIsetState(byte objectState) {
        this.objectState = objectState;
    }

    public BTreeIndex(ClassInfo ignored) {
    }

    BTreeIndex(Path thePath, boolean order, boolean dups, Placement placement, boolean export) {
        this.hasDuplicates = dups;
        this.path = thePath;
        Class keyClass = this.path.getKeyType();
        this.om = (ObjectManager)placement.getSession();
        this.keyType = MapKeys.keyType(keyClass, this.om);
        if (!MapKeys.isReferenceType(this.keyType)) {
            this.isOrdered = true;
        } else if (!order) {
            this.isOrdered = false;
        } else {
            throw new IndexException(keyClass.getName() + " cannot be used as an index key in an ordered index");
        }
        int keySize = MapKeys.keySize(this.keyType);
        boolean fixedSizeKeys = MapKeys.fixedSizeKeys(this.keyType);
        int btreeFlags = 0;
        if (fixedSizeKeys) {
            btreeFlags |= 1;
        }
        if (dups) {
            btreeFlags |= 2;
        }
        this.tree = BTree.create(placement, keySize, btreeFlags);
        this.tree.maintainSize(false);
        this.tree.setPathInfo(this.path.getClassString() + "." + this.path.getPathString());
        ObjectStore.migrate(this, placement, export);
        this.cluster = Cluster.of(this);
    }

    @Override
    public boolean ordered() {
        ObjectStore.fetch(this);
        return this.isOrdered;
    }

    @Override
    public boolean duplicates() {
        ObjectStore.fetch(this);
        return this.hasDuplicates;
    }

    @Override
    public Path getPath() {
        ObjectStore.fetch(this);
        return this.path;
    }

    @Override
    public int size() {
        ObjectStore.fetch(this);
        return this.tree.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        ObjectStore.fetch(this);
        byte[] keybuf = this.keyToByteArray(key, false);
        return keybuf == null ? false : this.tree.containsKey(keybuf);
    }

    boolean contains(Object value) {
        Object keyValue;
        Object key;
        ObjectStore.fetch(this);
        try {
            key = this.path.getKey(value);
        }
        catch (ClassCastException e) {
            return false;
        }
        byte[] keybuf = this.keyToByteArray(key, false);
        if (keybuf == null) {
            return false;
        }
        if (this.tree.contains(keybuf, value)) {
            return true;
        }
        try {
            keyValue = this.tree.get(keybuf);
        }
        catch (BTreeEntryNotFoundException e) {
            return false;
        }
        if (value.equals(keyValue)) {
            return true;
        }
        int keylen = keybuf.length;
        byte[] currentKey = new byte[keylen];
        BTreeIterator iter = this.tree.iterator(keybuf);
        while (iter.hasNext()) {
            iter.advance();
            currentKey = iter.currentKey(currentKey);
            if (BTreeNode.compareKeys(keybuf, 0, keylen, currentKey, 0, currentKey.length) != 0) {
                return false;
            }
            if (!value.equals(iter.currentValue())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object get(Object key) {
        ObjectStore.fetch(this);
        try {
            byte[] keybuf = this.keyToByteArray(key, false);
            return keybuf == null ? null : this.tree.get(keybuf);
        }
        catch (BTreeEntryNotFoundException e) {
            return null;
        }
    }

    private Object getLocationHashCodeKey(Object key) {
        byte[] keybuf = this.keyToByteArray(key, true);
        if (!this.tree.containsKey(keybuf)) {
            return null;
        }
        int keylen = keybuf.length;
        byte[] currentKey = new byte[keylen];
        BTreeIterator iter = this.tree.iterator(keybuf);
        while (iter.hasNext()) {
            iter.advance();
            currentKey = iter.currentKey(currentKey);
            if (BTreeNode.compareKeys(keybuf, 0, keylen, currentKey, 0, currentKey.length) != 0) {
                return null;
            }
            Object currentValue = iter.currentValue();
            if (key != this.path.getKey(currentValue)) continue;
            return currentValue;
        }
        return null;
    }

    @Override
    public void put(Object key, Object value) {
        if (value == null) {
            Utilities.throwNullArgumentException("BTreeIndex", "put", "value");
        }
        if (this.duplicates()) {
            this.tree.insertKnownNewValue(this.keyToByteArray(key, true), value);
        } else {
            Object oldValue = this.putInternal(key, value);
            if (oldValue != null && oldValue != value) {
                throw new DuplicateKeyException("Duplicate key " + key + " on index path " + this.getPath().getPathString());
            }
        }
    }

    Object putInternal(Object key, Object value) {
        byte[] keybuf = this.keyToByteArray(key, true);
        return this.tree.insertUniqueKey(keybuf, value);
    }

    @Override
    public void put(Object value) {
        Object key;
        if (value == null) {
            Utilities.throwNullArgumentException("BTreeIndex", "put", "value");
        }
        ObjectStore.fetch(this);
        try {
            key = this.path.getKey(value);
        }
        catch (ClassCastException cce) {
            return;
        }
        catch (NullPointerException npe) {
            return;
        }
        this.put(key, value);
    }

    @Override
    public void remove(Object key, Object value) {
        ObjectStore.fetch(this);
        try {
            byte[] keybuf = this.keyToByteArray(key, false);
            if (keybuf == null) {
                throw new NoSuchElementException();
            }
            this.tree.remove(keybuf, value);
        }
        catch (BTreeEntryNotFoundException e) {
            throw new NoSuchElementException();
        }
        catch (NullPointerException npe) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public void remove(Object value) {
        ObjectStore.fetch(this);
        if (value == null) {
            Utilities.throwNullArgumentException("BTreeIndex", "remove", "value");
        }
        try {
            Object key = this.path.getKey(value);
            this.remove(key, value);
        }
        catch (ClassCastException cce) {
            throw new NoSuchElementException();
        }
        catch (NullPointerException npe) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public void clear() {
        ObjectStore.fetch(this);
        this.tree.clear();
    }

    @Override
    public void putAll(Collection coll) {
        ObjectStore.fetch(this);
        for (Object value : coll) {
            Object key;
            if (value == null) continue;
            try {
                key = this.path.getKey(value);
            }
            catch (ClassCastException cce) {
                continue;
            }
            catch (NullPointerException npe) {
                continue;
            }
            this.tree.insertKnownNewValue(this.keyToByteArray(key, true), value);
        }
    }

    @Override
    public IndexIterator iterator() {
        ObjectStore.fetch(this);
        BTreeIterator treeIter = this.tree.iterator();
        return new BTreeIndexIterator(this, treeIter, MapKeys.keySize(this.keyType));
    }

    @Override
    public IndexIterator reverseIterator() {
        ObjectStore.fetch(this);
        BTreeIterator treeIter = this.tree.reverseIterator();
        return new BTreeIndexIterator(this, treeIter, MapKeys.keySize(this.keyType));
    }

    @Override
    public IndexIterator iterator(Object startKey) {
        ObjectStore.fetch(this);
        byte[] keybuf = this.keyToByteArray(startKey, false);
        BTreeIterator treeIter = keybuf == null ? this.tree.iterator() : this.tree.iterator(keybuf);
        return new BTreeIndexIterator(this, treeIter, MapKeys.keySize(this.keyType));
    }

    @Override
    public IndexIterator reverseIterator(Object startKey) {
        ObjectStore.fetch(this);
        byte[] keybuf = this.keyToByteArray(startKey, false);
        BTreeIterator treeIter = keybuf == null ? this.tree.reverseIterator() : this.tree.reverseIterator(keybuf);
        return new BTreeIndexIterator(this, treeIter, MapKeys.keySize(this.keyType));
    }

    @Override
    public Object getFirstKey() {
        ObjectStore.fetch(this);
        byte[] keybuf = this.tree.getFirstKey();
        return keybuf == null ? null : this.byteArrayToKey(keybuf);
    }

    @Override
    public Object getLastKey() {
        ObjectStore.fetch(this);
        byte[] keybuf = this.tree.getLastKey();
        return keybuf == null ? null : this.byteArrayToKey(keybuf);
    }

    byte[] keyToByteArray(Object key, boolean forInsert) {
        ObjectStore.fetch(this);
        switch (this.keyType) {
            case 1: {
                return MapKeys.intToByteArray((Boolean)key == false ? 0 : 1, null);
            }
            case 2: {
                return MapKeys.intToByteArray(((Character)key).charValue(), null);
            }
            case 3: {
                return MapKeys.intToByteArray(((Number)key).intValue(), null);
            }
            case 5: {
                return MapKeys.longToByteArray(((Number)key).longValue(), null);
            }
            case 4: {
                return MapKeys.floatToByteArray(((Number)key).floatValue(), null);
            }
            case 6: {
                return MapKeys.doubleToByteArray(((Number)key).doubleValue(), null);
            }
            case 7: {
                String string = (String)key;
                int len = string == null ? 0 : string.length();
                return MapKeys.stringToByteArray(this.getChars(string, len), len, null);
            }
            case 8: {
                return (byte[])key;
            }
        }
        if (MapKeys.isReferenceType(this.keyType)) {
            ReferenceType refType = MapKeys.getReferenceType(this.keyType);
            if (key == null) {
                return refType.encodeToByteArray(refType.NULL(), null);
            }
            if (!ObjectStore.isPersistent(key)) {
                if (forInsert) {
                    ObjectStore.migrate(key, this.cluster, false);
                } else {
                    return null;
                }
            }
            return refType.encodeToByteArray(this.om.getLazyReference(refType, key), null);
        }
        throw new IndexException("keytype encoding parameter not recognized: keymap error " + this.keyType);
    }

    Object byteArrayToKey(byte[] key) {
        ObjectStore.fetch(this);
        switch (this.keyType) {
            case 1: {
                return new Boolean(MapKeys.byteArrayToInt(key) != 0);
            }
            case 2: {
                return new Character((char)MapKeys.byteArrayToInt(key));
            }
            case 3: {
                return new Integer(MapKeys.byteArrayToInt(key));
            }
            case 5: {
                return new Long(MapKeys.byteArrayToLong(key));
            }
            case 4: {
                return new Float(MapKeys.byteArrayToFloat(key));
            }
            case 6: {
                return new Double(MapKeys.byteArrayToDouble(key));
            }
            case 7: {
                return MapKeys.byteArrayToString(key, new char[key.length]);
            }
            case 8: {
                return key;
            }
        }
        if (MapKeys.isReferenceType(this.keyType)) {
            ReferenceType refType = MapKeys.getReferenceType(this.keyType);
            Reference lazyref = refType.decode(key);
            if (lazyref == refType.NULL()) {
                return null;
            }
            return this.om.resolveLazyReference(lazyref, this.cluster);
        }
        throw new IndexException("keytype decoding parameter not recognized: keymap error " + this.keyType);
    }

    public BTree getBTree() {
        return this.tree;
    }

    private char[] getChars(String string, int length) {
        if (string == null) {
            return null;
        }
        char[] result = new char[length];
        string.getChars(0, length, result, 0);
        return result;
    }

    int sizeEstimate() {
        ObjectStore.fetch(this);
        return this.tree.sizeEstimate();
    }

    boolean isSizeMaintained() {
        ObjectStore.fetch(this);
        return this.tree.isSizeMaintained();
    }

    void maintainSize(boolean maintainSize) {
        ObjectStore.fetch(this);
        this.tree.maintainSize(maintainSize);
    }

    int getKeyType() {
        ObjectStore.fetch(this);
        return this.keyType;
    }

    int getModifications() {
        ObjectStore.fetch(this);
        return this.tree.getModifications();
    }
}

