/*
 * Decompiled with CFR 0.152.
 */
package com.odi.util;

import com.odi.ClassInfo;
import com.odi.Cluster;
import com.odi.GenericObject;
import com.odi.IPersistent;
import com.odi.ObjectStore;
import com.odi.ObjectStoreException;
import com.odi.Persistent;
import com.odi.Placement;
import com.odi.Segment;
import com.odi.imp.ObjectManager;
import com.odi.imp.Utilities;
import com.odi.util.BTree;
import com.odi.util.BTreeEntryNotFoundException;
import com.odi.util.BTreeIndex;
import com.odi.util.BTreeIterator;
import com.odi.util.BTreeNode;
import com.odi.util.DuplicateIndexException;
import com.odi.util.DuplicateKeyException;
import com.odi.util.FastContains;
import com.odi.util.IndexDescriptor;
import com.odi.util.IndexDescriptorSet;
import com.odi.util.IndexException;
import com.odi.util.IndexIterator;
import com.odi.util.IndexMap;
import com.odi.util.IndexedCollection;
import com.odi.util.MapKeys;
import com.odi.util.OSAbstractSet;
import com.odi.util.OSDictionary;
import com.odi.util.OSHashtable;
import com.odi.util.OSTreeSetIndexIterator;
import com.odi.util.OSTreeSetIterator;
import com.odi.util.Path;
import com.odi.util.concurrent.ReentrantWriterPreferenceReadWriteLock;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class OSTreeSet
extends OSAbstractSet
implements IPersistent,
Cloneable,
Set,
FastContains,
IndexedCollection,
Serializable {
    static final long serialVersionUID = -6192346414638832232L;
    private static final ClassInfo classinfo = ClassInfo.register(ClassInfo.getDynamic("com.odi.util.OSTreeSet"));
    transient ReentrantWriterPreferenceReadWriteLock lock = new ReentrantWriterPreferenceReadWriteLock();
    private BTree tree;
    private OSDictionary indexes;

    @Override
    public void initializeContents(GenericObject genObject) {
        this.tree = (BTree)genObject.getClassField(1, classinfo);
        this.indexes = (OSDictionary)genObject.getClassField(2, classinfo);
    }

    @Override
    public void flushContents(GenericObject genObject) {
        genObject.setClassField(1, this.tree, classinfo);
        genObject.setClassField(2, this.indexes, classinfo);
    }

    @Override
    public void clearContents() {
        this.tree = null;
        this.indexes = null;
    }

    @Override
    public void preDestroyPersistent() {
        ObjectStore.fetch(this);
        ObjectStore.destroy(this.tree);
        if (this.indexes != null) {
            IndexIterator iterator = this.indexes.elements();
            while (iterator.hasNext()) {
                ObjectStore.destroy(iterator.next());
            }
            ObjectStore.destroy(this.indexes);
        }
    }

    public OSTreeSet(ClassInfo ignored) {
    }

    public OSTreeSet(Placement placement) {
        this.tree = BTree.create(placement, 4, 3);
        this.indexes = null;
        ObjectStore.migrate(this, placement, false);
    }

    public OSTreeSet(Placement placement, boolean export) {
        this.tree = BTree.create(placement, 4, 3);
        this.indexes = null;
        ObjectStore.migrate(this, placement, export);
    }

    public OSTreeSet(Placement placement, Class primaryIndexElementType, String primaryIndexPath) {
        if (placement == null) {
            Utilities.throwNullArgumentException("OSTreeSet", "OSTreeSet", "placement");
        }
        if (primaryIndexElementType == null) {
            Utilities.throwNullArgumentException("OSTreeSet", "OSTreeSet", "primaryIndexElementType");
        }
        if (primaryIndexPath == null) {
            Utilities.throwNullArgumentException("OSTreeSet", "OSTreeSet", "primaryIndexPath");
        }
        this.tree = null;
        ObjectStore.migrate(this, placement, false);
        Path p = new Path(primaryIndexElementType, primaryIndexPath);
        ObjectStore.migrate(p, Cluster.of(this), false);
        BTreeIndex index = new BTreeIndex(p, false, false, placement, false);
        index.maintainSize(true);
        this.indexes = new IndexesWithPrimary(5, index);
        this.indexes.put(p, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        try {
            this.lock.readLock().acquire();
            ObjectStore.fetch(this);
            if (!this.hasPrimaryIndex()) {
                int n = this.tree.size();
                return n;
            }
            int n = this.getPrimaryIndexInternal().size();
            return n;
        }
        finally {
            this.lock.readLock().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sizeEstimate() {
        try {
            this.lock.readLock().acquire();
            ObjectStore.fetch(this);
            if (!this.hasPrimaryIndex()) {
                int n = this.tree.sizeEstimate();
                return n;
            }
            int n = this.getPrimaryIndexInternal().sizeEstimate();
            return n;
        }
        finally {
            this.lock.readLock().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSizeMaintained() {
        try {
            this.lock.readLock().acquire();
            ObjectStore.fetch(this);
            if (!this.hasPrimaryIndex()) {
                boolean bl = this.tree.isSizeMaintained();
                return bl;
            }
            boolean bl = this.getPrimaryIndexInternal().isSizeMaintained();
            return bl;
        }
        finally {
            this.lock.readLock().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void maintainSize(boolean maintainSize) {
        try {
            this.lock.writeLock().acquire();
            ObjectStore.fetch(this);
            if (!this.hasPrimaryIndex()) {
                this.tree.maintainSize(maintainSize);
            } else {
                this.getPrimaryIndexInternal().maintainSize(maintainSize);
            }
        }
        finally {
            this.lock.writeLock().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        try {
            this.lock.readLock().acquire();
            boolean bl = this.size() == 0;
            return bl;
        }
        finally {
            this.lock.readLock().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object o) {
        try {
            this.lock.readLock().acquire();
            ObjectStore.fetch(this);
            if (o == null) {
                boolean bl = false;
                return bl;
            }
            if (this.hasPrimaryIndex()) {
                boolean bl = this.getPrimaryIndexInternal().contains(o);
                return bl;
            }
            byte[] key = MapKeys.intToByteArray(o.hashCode(), null);
            byte[] currentKey = new byte[4];
            if (this.tree.contains(key, o)) {
                boolean bl = true;
                return bl;
            }
            Object value = this.tree.get(key);
            if (o.equals(value)) {
                boolean bl = true;
                return bl;
            }
            BTreeIterator iter = this.tree.iterator(key);
            while (iter.hasNext()) {
                iter.advance();
                currentKey = iter.currentKey(currentKey);
                int compare = BTreeNode.compareKeys(key, 0, key.length, currentKey, 0, currentKey.length);
                if (compare != 0) {
                    boolean bl = false;
                    return bl;
                }
                if (!o.equals(iter.currentValue())) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.readLock().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator iterator() {
        try {
            this.lock.readLock().acquire();
            ObjectStore.fetch(this);
            if (!this.hasPrimaryIndex()) {
                BTreeIterator treeIter = this.tree.iterator();
                OSTreeSetIterator oSTreeSetIterator = new OSTreeSetIterator(this, treeIter);
                return oSTreeSetIterator;
            }
            BTreeIndex primaryIndex = this.getPrimaryIndexInternal();
            IndexIterator primaryIndexIter = primaryIndex.iterator();
            OSTreeSetIterator oSTreeSetIterator = new OSTreeSetIterator(this, primaryIndexIter);
            return oSTreeSetIterator;
        }
        finally {
            this.lock.readLock().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator reverseIterator() {
        try {
            this.lock.readLock().acquire();
            ObjectStore.fetch(this);
            if (!this.hasPrimaryIndex()) {
                BTreeIterator treeIter = this.tree.reverseIterator();
                OSTreeSetIterator oSTreeSetIterator = new OSTreeSetIterator(this, treeIter);
                return oSTreeSetIterator;
            }
            BTreeIndex primaryIndex = this.getPrimaryIndexInternal();
            IndexIterator primaryIndexIter = primaryIndex.reverseIterator();
            OSTreeSetIterator oSTreeSetIterator = new OSTreeSetIterator(this, primaryIndexIter);
            return oSTreeSetIterator;
        }
        finally {
            this.lock.readLock().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexIterator primaryIndexIterator() {
        try {
            this.lock.readLock().acquire();
            ObjectStore.fetch(this);
            if (!this.hasPrimaryIndex()) {
                IndexIterator indexIterator = null;
                return indexIterator;
            }
            BTreeIndex primaryIndex = this.getPrimaryIndexInternal();
            IndexIterator primaryIndexIter = primaryIndex.iterator();
            OSTreeSetIndexIterator oSTreeSetIndexIterator = new OSTreeSetIndexIterator(this, primaryIndexIter);
            return oSTreeSetIndexIterator;
        }
        finally {
            this.lock.readLock().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexIterator reversePrimaryIndexIterator() {
        try {
            this.lock.readLock().acquire();
            ObjectStore.fetch(this);
            if (!this.hasPrimaryIndex()) {
                IndexIterator indexIterator = null;
                return indexIterator;
            }
            BTreeIndex primaryIndex = this.getPrimaryIndexInternal();
            IndexIterator primaryIndexIter = primaryIndex.reverseIterator();
            OSTreeSetIndexIterator oSTreeSetIndexIterator = new OSTreeSetIndexIterator(this, primaryIndexIter);
            return oSTreeSetIndexIterator;
        }
        finally {
            this.lock.readLock().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexIterator primaryIndexIterator(Object startKey) {
        try {
            this.lock.readLock().acquire();
            ObjectStore.fetch(this);
            if (!this.hasPrimaryIndex()) {
                IndexIterator indexIterator = null;
                return indexIterator;
            }
            BTreeIndex primaryIndex = this.getPrimaryIndexInternal();
            IndexIterator primaryIndexIter = primaryIndex.iterator(startKey);
            OSTreeSetIndexIterator oSTreeSetIndexIterator = new OSTreeSetIndexIterator(this, primaryIndexIter);
            return oSTreeSetIndexIterator;
        }
        finally {
            this.lock.readLock().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexIterator reversePrimaryIndexIterator(Object startKey) {
        try {
            this.lock.readLock().acquire();
            ObjectStore.fetch(this);
            if (!this.hasPrimaryIndex()) {
                IndexIterator indexIterator = null;
                return indexIterator;
            }
            BTreeIndex primaryIndex = this.getPrimaryIndexInternal();
            IndexIterator primaryIndexIter = primaryIndex.reverseIterator(startKey);
            OSTreeSetIndexIterator oSTreeSetIndexIterator = new OSTreeSetIndexIterator(this, primaryIndexIter);
            return oSTreeSetIndexIterator;
        }
        finally {
            this.lock.readLock().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        try {
            this.lock.readLock().acquire();
            Object[] anArray = new Object[this.size()];
            Iterator iter = this.iterator();
            int i = 0;
            while (iter.hasNext()) {
                anArray[i++] = iter.next();
            }
            Object[] objectArray = anArray;
            return objectArray;
        }
        finally {
            this.lock.readLock().release();
        }
    }

    public boolean add(Object o) {
        try {
            this.lock.writeLock().acquire();
            ObjectStore.fetch(this);
            if (o == null) {
                Utilities.throwNullArgumentException("OSTreeSet", "add", "o");
            }
            byte[] key = null;
            BTreeIndex primaryIndex = null;
            if (!this.hasPrimaryIndex()) {
                key = MapKeys.intToByteArray(o.hashCode(), null);
                Object oldObject = this.tree.insertUniqueKey(key, o);
                if (o.equals(oldObject)) {
                    boolean bl = false;
                    return bl;
                }
                if (oldObject != null) {
                    BTreeIterator iterator = this.tree.iterator(key);
                    byte[] keyBuffer = new byte[4];
                    while (iterator.hasNext()) {
                        iterator.advance();
                        iterator.currentKey(keyBuffer);
                        if (BTreeNode.compareKeys(key, 0, 4, keyBuffer, 0, 4) != 0) break;
                        Object value = iterator.currentValue();
                        if (!o.equals(value)) continue;
                        boolean bl = false;
                        return bl;
                    }
                    this.tree.put(key, o);
                }
            } else {
                Object keyObject;
                primaryIndex = this.getPrimaryIndexInternal();
                try {
                    keyObject = primaryIndex.getPath().getKey(o);
                }
                catch (ClassCastException e) {
                    throw new IndexException("Attempt to add an object that is not an instance of the element type of the OSTreeSet's primary index.\nThe object is an instance of " + o.getClass().getName() + ", and the element type of the primary index is " + primaryIndex.getPath().getElementType() + ".", e);
                }
                Object oldValue = primaryIndex.putInternal(keyObject, o);
                if (oldValue != null) {
                    if (oldValue.equals(o)) {
                        boolean bl = false;
                        return bl;
                    }
                    throw new DuplicateKeyException("Duplicate key " + primaryIndex.getPath().getKey(o) + " on index path " + primaryIndex.getPath().getPathString());
                }
            }
            try {
                this.addToIndexInternal(o, primaryIndex);
                boolean keyObject = true;
                return keyObject;
            }
            catch (DuplicateKeyException e) {
                if (!this.hasPrimaryIndex()) {
                    this.tree.remove(key, o);
                } else {
                    primaryIndex.remove(o);
                }
                throw e;
            }
        }
        finally {
            this.lock.writeLock().release();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean remove(Object o) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 10[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        try {
            this.lock.writeLock().acquire();
            ObjectStore.fetch(this);
            if (!this.hasPrimaryIndex()) {
                this.tree.clear();
            }
            if (this.indexes == null) {
                return;
            }
            IndexIterator indexIterator = this.indexes.elements();
            while (indexIterator.hasNext()) {
                IndexMap index = (IndexMap)indexIterator.next();
                index.clear();
            }
        }
        finally {
            this.lock.writeLock().release();
        }
    }

    public BTree getBTree() {
        return this.tree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addIndex(Class elementType, String path) {
        try {
            this.lock.writeLock().acquire();
            this.addIndex(elementType, path, false, true);
        }
        finally {
            this.lock.writeLock().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addIndex(Class elementType, String path, boolean ordered, boolean duplicates) {
        try {
            this.lock.writeLock().acquire();
            this.addIndex(elementType, path, ordered, duplicates, Cluster.of(this));
        }
        finally {
            this.lock.writeLock().release();
        }
    }

    @Override
    public void addIndex(Class elementType, String path, boolean ordered, boolean duplicates, Placement placement) {
        try {
            this.lock.writeLock().acquire();
            if (elementType == null) {
                Utilities.throwNullArgumentException("OSTreeSet", "addIndex", "elementType");
            }
            if (path == null) {
                Utilities.throwNullArgumentException("OSTreeSet", "addIndex", "path");
            }
            Path p = new Path(elementType, path);
            ObjectStore.fetch(this);
            if (this.indexes != null && this.indexes.get(p) != null) {
                throw new DuplicateIndexException("Duplicate index on path " + path);
            }
            boolean export = placement.getSegment() != Segment.of(this);
            ObjectStore.migrate(p, Cluster.of(this), export);
            BTreeIndex index = new BTreeIndex(p, ordered, duplicates, placement, export);
            if (this.indexes == null) {
                ObjectStore.dirty(this);
                this.indexes = new OSHashtable(5);
            }
            this.indexes.put(p, index);
            try {
                index.putAll(this);
                return;
            }
            catch (DuplicateKeyException e) {
                this.indexes.remove(p);
                throw e;
            }
        }
        finally {
            this.lock.writeLock().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean dropIndex(Class elementType, String path) {
        try {
            this.lock.writeLock().acquire();
            if (elementType == null) {
                Utilities.throwNullArgumentException("OSTreeSet", "dropIndex", "elementType");
            }
            if (path == null) {
                Utilities.throwNullArgumentException("OSTreeSet", "dropIndex", "path");
            }
            Path p = null;
            try {
                p = new Path(elementType, path);
            }
            catch (IndexException e) {
                boolean bl = false;
                this.lock.writeLock().release();
                return bl;
            }
            ObjectStore.fetch(this);
            if (this.indexes == null) {
                boolean e = false;
                return e;
            }
            Object value = this.indexes.remove(p);
            if (value == null) {
                boolean bl = false;
                return bl;
            }
            if (value == this.getPrimaryIndex()) {
                this.noPrimaryIndex();
            }
            ObjectStore.destroy(value);
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.writeLock().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasIndex(Class elementType, String path, boolean ordered) {
        try {
            this.lock.readLock().acquire();
            IndexMap index = this.getIndex(elementType, path, ordered);
            if (index == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.readLock().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndexMap getIndex(Class elementType, String path, boolean ordered) {
        try {
            this.lock.readLock().acquire();
            IndexMap indexMap = this.getMatchingIndex(elementType, path, ordered, true);
            return indexMap;
        }
        finally {
            this.lock.readLock().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndexMap getSuperIndex(Class elementType, String path, boolean ordered) {
        try {
            this.lock.readLock().acquire();
            IndexMap indexMap = this.getMatchingIndex(elementType, path, ordered, false);
            return indexMap;
        }
        finally {
            this.lock.readLock().release();
        }
    }

    private IndexMap getMatchingIndex(Class elementType, String path, boolean ordered, boolean exactMatch) {
        if (elementType == null) {
            Utilities.throwNullArgumentException("OSTreeSet", "getIndex", "elementType");
        }
        if (path == null) {
            Utilities.throwNullArgumentException("OSTreeSet", "getIndex", "path");
        }
        ObjectStore.fetch(this);
        if (this.indexes == null) {
            return null;
        }
        IndexMap index = (IndexMap)this.indexes.get(new Path(elementType, path, false));
        if (index != null && (!ordered || index.ordered())) {
            return index;
        }
        IndexIterator iter = this.indexes.elements();
        while (iter.hasNext()) {
            index = (IndexMap)iter.next();
            Path indexPath = index.getPath();
            if (!path.equals(indexPath.getPathString()) || ordered && !index.ordered() || !(exactMatch ? indexPath.getElementType() == elementType : indexPath.getElementType().isAssignableFrom(elementType))) continue;
            return index;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndexDescriptorSet getIndexes() {
        try {
            this.lock.readLock().acquire();
            ObjectStore.fetch(this);
            if (this.indexes == null || this.indexes.isEmpty()) {
                IndexDescriptorSet indexDescriptorSet = null;
                return indexDescriptorSet;
            }
            IndexDescriptorSet descs = new IndexDescriptorSet(this.indexes.size());
            IndexIterator indexIterator = this.indexes.keys();
            while (indexIterator.hasNext()) {
                Path indexpath = (Path)indexIterator.next();
                IndexMap index = (IndexMap)this.indexes.get(indexpath);
                descs.add(new IndexDescriptor(indexpath, index.ordered(), index.duplicates()));
            }
            IndexDescriptorSet indexDescriptorSet = descs;
            return indexDescriptorSet;
        }
        finally {
            this.lock.readLock().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndexDescriptor getPrimaryIndexDescriptor() {
        try {
            this.lock.readLock().acquire();
            ObjectStore.fetch(this);
            if (!this.hasPrimaryIndex()) {
                IndexDescriptor indexDescriptor = null;
                return indexDescriptor;
            }
            BTreeIndex pi = this.getPrimaryIndexInternal();
            IndexDescriptor indexDescriptor = new IndexDescriptor(pi.getPath(), pi.ordered(), pi.duplicates());
            return indexDescriptor;
        }
        finally {
            this.lock.readLock().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndexDescriptorSet getSecondaryIndexDescriptors() {
        try {
            IndexDescriptorSet indexDescriptorSet;
            this.lock.readLock().acquire();
            ObjectStore.fetch(this);
            if (this.indexes == null || this.indexes.isEmpty()) {
                IndexDescriptorSet indexDescriptorSet2 = null;
                return indexDescriptorSet2;
            }
            BTreeIndex primaryIndex = null;
            if (this.hasPrimaryIndex()) {
                primaryIndex = this.getPrimaryIndexInternal();
            }
            IndexDescriptorSet descs = new IndexDescriptorSet();
            IndexIterator indexIterator = this.indexes.elements();
            while (indexIterator.hasNext()) {
                IndexMap i = (IndexMap)indexIterator.next();
                if (i == primaryIndex) continue;
                descs.add(new IndexDescriptor(i.getPath(), i.ordered(), i.duplicates()));
            }
            if (descs.isEmpty()) {
                indexDescriptorSet = null;
                return indexDescriptorSet;
            }
            indexDescriptorSet = descs;
            return indexDescriptorSet;
        }
        finally {
            this.lock.readLock().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFromIndex(Object value) {
        try {
            this.lock.writeLock().acquire();
            if (!this.contains(value)) {
                throw new NoSuchElementException();
            }
            this.removeFromIndexInternal(value);
        }
        finally {
            this.lock.writeLock().release();
        }
    }

    private boolean removeFromIndexInternal(Object value) {
        ObjectStore.fetch(this);
        if (this.indexes == null) {
            return false;
        }
        IndexIterator indexIterator = this.indexes.keys();
        BTreeIndex primaryIndex = this.hasPrimaryIndex() ? this.getPrimaryIndexInternal() : null;
        boolean foundInPrimaryIndex = false;
        while (indexIterator.hasNext()) {
            indexIterator.advance();
            IndexMap index = (IndexMap)indexIterator.currentValue();
            try {
                index.remove(value);
                if (index != primaryIndex) continue;
                foundInPrimaryIndex = true;
            }
            catch (NoSuchElementException e) {}
        }
        return foundInPrimaryIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFromIndex(Class elementType, String path, Object value) {
        try {
            this.lock.writeLock().acquire();
            if (!this.contains(value)) {
                throw new NoSuchElementException();
            }
            IndexMap index = this.getIndex(elementType, path, false);
            if (index == null) {
                return;
            }
            index.remove(value);
        }
        finally {
            this.lock.writeLock().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addToIndex(Object value) {
        try {
            this.lock.writeLock().acquire();
            ObjectStore.fetch(this);
            if (!this.hasPrimaryIndex() && !this.contains(value)) {
                throw new NoSuchElementException();
            }
            this.addToIndexInternal(value, null);
        }
        finally {
            this.lock.writeLock().release();
        }
    }

    private void addToIndexInternal(Object value, IndexMap skip) {
        ObjectStore.fetch(this);
        if (this.indexes == null) {
            return;
        }
        IndexIterator indexIterator = this.indexes.elements();
        int indexCounter = 0;
        DuplicateKeyException rethrow = null;
        Object errorString = null;
        try {
            while (indexIterator.hasNext()) {
                IndexMap index = (IndexMap)indexIterator.next();
                if (index != skip) {
                    index.put(value);
                }
                ++indexCounter;
            }
            return;
        }
        catch (DuplicateKeyException e) {
            rethrow = e;
            indexIterator = this.indexes.elements();
            for (int indexReCounter = 0; indexIterator.hasNext() && indexCounter > indexReCounter; ++indexReCounter) {
                IndexMap index = (IndexMap)indexIterator.next();
                try {
                    if (index == skip) continue;
                    index.remove(value);
                    continue;
                }
                catch (NoSuchElementException e2) {
                    // empty catch block
                }
            }
            throw rethrow;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addToIndex(Class elementType, String path, Object value) {
        try {
            this.lock.writeLock().acquire();
            if (!this.contains(value)) {
                throw new NoSuchElementException();
            }
            IndexMap index = this.getIndex(elementType, path, false);
            if (index == null) {
                return;
            }
            index.put(value);
        }
        finally {
            this.lock.writeLock().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateIndex(Class elementType, String path, Object oldKey, Object newKey, Object value) {
        try {
            this.lock.writeLock().acquire();
            IndexMap index = this.getIndex(elementType, path, false);
            if (index == null) {
                return;
            }
            try {
                index.remove(oldKey, value);
            }
            catch (BTreeEntryNotFoundException e) {
                throw new NoSuchElementException();
            }
            index.put(newKey, value);
        }
        finally {
            this.lock.writeLock().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPrimaryIndex(Class elementType, String path) {
        try {
            this.lock.writeLock().acquire();
            if (elementType == null) {
                Utilities.throwNullArgumentException("OSTreeSet", "setPrimaryIndex", "elementType");
            }
            if (path == null) {
                Utilities.throwNullArgumentException("OSTreeSet", "setPrimaryIndex", "path");
            }
            ObjectStore.fetch(this);
            BTreeIndex primaryIndex = (BTreeIndex)this.getIndex(elementType, path, false);
            if (primaryIndex == null) {
                throw new IndexException("The index was not found.");
            }
            if (primaryIndex.duplicates()) {
                throw new IndexException("The index permits duplicates.");
            }
            if (primaryIndex.size() != this.size()) {
                throw new IndexException("The index does not contain all the elements of the set.");
            }
            if (!this.hasPrimaryIndex()) {
                ObjectStore.dirty(this);
                primaryIndex.maintainSize(this.tree.isSizeMaintained());
                this.replaceIndexes(new IndexesWithPrimary(this.indexes.size(), primaryIndex));
                ObjectStore.destroy(this.tree);
                this.tree = null;
            } else {
                BTreeIndex oldPrimaryIndex = this.getPrimaryIndexInternal();
                if (oldPrimaryIndex == primaryIndex) {
                    return;
                }
                ObjectStore.dirty(this);
                primaryIndex.maintainSize(oldPrimaryIndex.isSizeMaintained());
                oldPrimaryIndex.maintainSize(false);
                ((IndexesWithPrimary)this.indexes).setPrimaryIndex(primaryIndex);
            }
        }
        finally {
            this.lock.writeLock().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noPrimaryIndex() {
        try {
            this.lock.writeLock().acquire();
            ObjectStore.fetch(this);
            if (!this.hasPrimaryIndex()) {
                return;
            }
            ObjectStore.dirty(this);
            this.tree = BTree.create(Cluster.of(this), 4, 3);
            BTreeIndex primaryIndex = this.getPrimaryIndexInternal();
            this.tree.maintainSize(primaryIndex.isSizeMaintained());
            primaryIndex.maintainSize(false);
            IndexIterator iterator = primaryIndex.iterator();
            byte[] buffer = new byte[4];
            while (iterator.hasNext()) {
                Object object = iterator.next();
                byte[] key = MapKeys.intToByteArray(object.hashCode(), buffer);
                this.tree.put(key, object);
            }
            this.replaceIndexes(new OSHashtable(Math.max(1, this.indexes.size())));
        }
        finally {
            this.lock.writeLock().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexMap getPrimaryIndex() {
        try {
            this.lock.readLock().acquire();
            ObjectStore.fetch(this);
            if (!this.hasPrimaryIndex()) {
                IndexMap indexMap = null;
                return indexMap;
            }
            BTreeIndex bTreeIndex = this.getPrimaryIndexInternal();
            return bTreeIndex;
        }
        finally {
            this.lock.readLock().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getFromPrimaryIndex(Object key) {
        try {
            this.lock.readLock().acquire();
            ObjectStore.fetch(this);
            if (!this.hasPrimaryIndex()) {
                Object var2_2 = null;
                return var2_2;
            }
            Object object = this.getPrimaryIndexInternal().get(key);
            return object;
        }
        finally {
            this.lock.readLock().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getMinPrimaryKey() {
        try {
            this.lock.readLock().acquire();
            ObjectStore.fetch(this);
            if (!this.hasPrimaryIndex()) {
                Object var1_1 = null;
                return var1_1;
            }
            Object object = this.getPrimaryIndexInternal().getFirstKey();
            return object;
        }
        finally {
            this.lock.readLock().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getMaxPrimaryKey() {
        try {
            this.lock.readLock().acquire();
            ObjectStore.fetch(this);
            if (!this.hasPrimaryIndex()) {
                Object var1_1 = null;
                return var1_1;
            }
            Object object = this.getPrimaryIndexInternal().getLastKey();
            return object;
        }
        finally {
            this.lock.readLock().release();
        }
    }

    private BTreeIndex getPrimaryIndexInternal() {
        return ((IndexesWithPrimary)this.indexes).getPrimaryIndex();
    }

    protected boolean hasPrimaryIndex() {
        return this.tree == null;
    }

    private void replaceIndexes(OSDictionary newIndexes) {
        IndexIterator indexesIterator = this.indexes.elements();
        while (indexesIterator.hasNext()) {
            indexesIterator.advance();
            newIndexes.put(indexesIterator.currentKey(), indexesIterator.currentValue());
        }
        ObjectStore.destroy(this.indexes);
        this.indexes = newIndexes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.lock.readLock().acquire();
            if (Persistent.hasReadBarrier(this)) {
                throw new ObjectStoreException("OSTreeSet.writeObject() invoked without a preceding call to ObjectStore.deepFetch()");
            }
            Class primaryIndexElementType = null;
            String primaryIndexPath = null;
            if (!this.hasPrimaryIndex()) {
                out.writeInt(this.size());
            } else {
                out.writeInt(-1);
                out.writeInt(this.size());
                out.writeBoolean(this.isSizeMaintained());
                out.writeBoolean(true);
                BTreeIndex primaryIndex = this.getPrimaryIndexInternal();
                Path p = primaryIndex.getPath();
                primaryIndexElementType = p.getElementType();
                primaryIndexPath = p.getPathString();
                out.writeUTF(primaryIndexPath);
                out.writeUTF(primaryIndexElementType.getName());
                out.writeBoolean(primaryIndex.ordered());
            }
            for (Object object : this) {
                ObjectStore.deepFetch(object);
                out.writeObject(object);
            }
            IndexDescriptorSet indexSet = this.getIndexes();
            if (indexSet == null) {
                out.writeInt(0);
            } else {
                if (primaryIndexElementType != null) {
                    out.writeInt(indexSet.size() - 1);
                } else {
                    out.writeInt(indexSet.size());
                }
                for (IndexDescriptor descriptor : indexSet) {
                    if (descriptor.elementClass() == primaryIndexElementType && descriptor.pathString().equals(primaryIndexPath)) continue;
                    out.writeObject(descriptor);
                }
            }
        }
        finally {
            this.lock.readLock().release();
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.lock = new ReentrantWriterPreferenceReadWriteLock();
        Placement placement = ObjectManager.getPlacementForSerialization(true);
        int size = in.readInt();
        boolean maintainSize = true;
        boolean hasPrimaryIndex = false;
        if (size == -1) {
            size = in.readInt();
            maintainSize = in.readBoolean();
            hasPrimaryIndex = in.readBoolean();
        }
        if (hasPrimaryIndex) {
            Class primaryIndexElementType;
            this.tree = null;
            String primaryIndexPath = in.readUTF();
            String primaryIndexElementTypeName = in.readUTF();
            boolean primaryIndexOrdered = in.readBoolean();
            try {
                primaryIndexElementType = Utilities.findClass(primaryIndexElementTypeName);
            }
            catch (ClassNotFoundException e) {
                throw new IndexException("Class not found: " + primaryIndexElementTypeName, e);
            }
            Path p = new Path(primaryIndexElementType, primaryIndexPath);
            BTreeIndex index = new BTreeIndex(p, primaryIndexOrdered, false, placement, false);
            index.maintainSize(maintainSize);
            this.indexes = new IndexesWithPrimary(5, index);
            this.indexes.put(p, index);
        } else {
            this.tree = BTree.create(placement, 4, 3);
            this.tree.maintainSize(maintainSize);
            this.indexes = null;
        }
        ObjectStore.migrate(this, placement, false);
        for (int i = 0; i < size; ++i) {
            this.add(in.readObject());
        }
        int numIndexes = in.readInt();
        for (int i = 0; i < numIndexes; ++i) {
            IndexDescriptor id = (IndexDescriptor)in.readObject();
            this.addIndex(id.elementClass(), id.pathString(), id.ordered(), id.duplicates());
        }
    }

    public static class IndexesWithPrimary
    extends OSHashtable {
        private BTreeIndex primaryIndex;
        private static final ClassInfo classinfo = ClassInfo.register(ClassInfo.getDynamic("com.odi.util.OSTreeSet$IndexesWithPrimary"));

        public IndexesWithPrimary(ClassInfo ignored) {
        }

        @Override
        public void initializeContents(GenericObject genObject) {
            super.initializeContents(genObject);
            this.primaryIndex = (BTreeIndex)genObject.getClassField(1, classinfo);
        }

        @Override
        public void flushContents(GenericObject genObject) {
            super.flushContents(genObject);
            genObject.setClassField(1, this.primaryIndex, classinfo);
        }

        @Override
        public void clearContents() {
            super.clearContents();
            this.primaryIndex = null;
        }

        IndexesWithPrimary(int size, BTreeIndex primaryIndex) {
            super(size);
            this.primaryIndex = primaryIndex;
        }

        final BTreeIndex getPrimaryIndex() {
            ObjectStore.fetch(this);
            return this.primaryIndex;
        }

        final void setPrimaryIndex(BTreeIndex primaryIndex) {
            ObjectStore.dirty(this);
            this.primaryIndex = primaryIndex;
        }
    }
}

