/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.agent;

import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.IIdentity;
import com.sonicsw.mf.common.config.impl.EntityName;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.dirconfig.IDirIdentity;
import com.sonicsw.mf.framework.agent.ContainerImpl;
import com.sonicsw.mx.jndi.MFNameParser;
import com.sonicsw.mx.jndi.ObjHelper;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import javax.naming.Binding;
import javax.naming.CommunicationException;
import javax.naming.Context;
import javax.naming.ContextNotEmptyException;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.spi.NamingManager;

public class MFContext
implements Context {
    private MFNameParser m_parser = MFNameParser.getInstance();
    ContainerImpl m_container;
    String m_ctxName;
    String m_fullCtxName;
    private static final String CONTEXT_CLASSNAME = Context.class.getName();
    private static final String VERBOSE_TRACING = "com.sonicsw.jndi.mfcontext.verbose";
    private boolean m_verboseTracing = false;

    MFContext(MFContext ctx, String ctxName) {
        if (!ctxName.startsWith("/")) {
            ctxName = '/' + ctxName;
        }
        this.m_fullCtxName = ctx.m_fullCtxName + ctxName;
        try {
            this.m_ctxName = new EntityName(this.m_fullCtxName).getBaseName();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MFContext(ContainerImpl container, String ctxDirName) {
        this.m_container = container;
        this.init(ctxDirName);
    }

    private void init(String ctxDirName) {
        String ctxName;
        this.m_fullCtxName = ctxName = '/' + (ctxDirName.length() == 0 ? "_MFContext" : "_MFContext/" + ctxDirName);
    }

    @Override
    public final Object lookup(String name) throws NamingException, NameNotFoundException {
        Object obj = null;
        if (name == null) {
            return null;
        }
        if (name.length() == 0) {
            return this;
        }
        if (!name.startsWith("/")) {
            name = '/' + name;
        }
        try {
            String parent = new EntityName(name).getParent();
            String fullDSName = this.m_fullCtxName + name;
            boolean bExist = false;
            IIdentity[] list = this.m_container.listAll(this.m_fullCtxName + parent);
            for (int i = 0; i < list.length; ++i) {
                if (!fullDSName.equals(list[i].getName())) continue;
                bExist = true;
                if (list[i] instanceof IDirIdentity) {
                    obj = new MFContext(this, name);
                    continue;
                }
                IElement elmnt = this.m_container.getConfiguration(fullDSName);
                String elmntType = elmnt.getIdentity().getType();
                if (elmntType.equals("SerializedObject")) {
                    IAttributeSet attrs = elmnt.getAttributes();
                    byte[] bytes = (byte[])attrs.getAttribute("data");
                    obj = ObjHelper.deserializeObject((byte[])bytes);
                    continue;
                }
                if (!elmntType.equals("ReferenceObject")) continue;
                obj = this.getBindedRefObject(elmnt, fullDSName);
            }
            if (!bExist) {
                throw new NameNotFoundException(name + " not found in the specified context");
            }
        }
        catch (Exception ex) {
            this.throwNamingException(ex);
        }
        return obj;
    }

    @Override
    public final Object lookup(Name name) throws NamingException, NameNotFoundException {
        return this.lookup(this.m_parser.convertToString(name));
    }

    private Object getBindedRefObject(IElement elmnt, String fullDSName) throws NamingException {
        try {
            return NamingManager.getObjectInstance(ObjHelper.convertElementToRef((IElement)elmnt, (boolean)this.m_verboseTracing), this.m_parser.parse(fullDSName), this, null);
        }
        catch (Exception ex) {
            this.throwNamingException(ex);
            return null;
        }
    }

    @Override
    public final void bind(Name name, Object obj) throws NamingException, NameAlreadyBoundException {
        if (name == null || name.toString().length() == 0) {
            throw new InvalidNameException("Cannot bind empty name");
        }
        this.bind(this.m_parser.convertToString(name), obj);
    }

    @Override
    public final void bind(String name, Object obj) throws NamingException, NameAlreadyBoundException {
        throw new OperationNotSupportedException("This Context does not support modifying the store");
    }

    @Override
    public final void rebind(String name, Object obj) throws NamingException, NameNotFoundException {
        throw new OperationNotSupportedException("This Context does not support modifying the store");
    }

    @Override
    public final void rebind(Name name, Object obj) throws NamingException {
        if (name == null || name.isEmpty()) {
            throw new NamingException("Cannot unbind empty name");
        }
        this.rebind(this.m_parser.convertToString(name), obj);
    }

    @Override
    public final void unbind(String name) throws NamingException {
        throw new OperationNotSupportedException("This Context does not support modifying the store");
    }

    @Override
    public final void unbind(Name name) throws NamingException {
        if (name == null || name.toString().length() == 0) {
            throw new NamingException("Cannot unbind empty name");
        }
        this.unbind(this.m_parser.convertToString(name));
    }

    @Override
    public final void rename(String oldname, String newname) throws NamingException {
        throw new OperationNotSupportedException("This Context does not support modifying the store");
    }

    @Override
    public final void rename(Name oldname, Name newname) throws NamingException {
        if (oldname == null || newname == null) {
            throw new InvalidNameException("Cannot rename empty name");
        }
        this.rename(this.m_parser.convertToString(oldname), this.m_parser.convertToString(newname));
    }

    public final NamingEnumeration list(String name) throws NamingException {
        String dsName;
        if (name.length() == 0) {
            dsName = this.m_fullCtxName;
        } else {
            if (!name.startsWith("/")) {
                name = '/' + name;
            }
            dsName = this.m_fullCtxName + name;
        }
        IDirIdentity[] contextList = null;
        IDirElement[] objectList = null;
        try {
            contextList = this.m_container.listDirectories(dsName);
            objectList = this.m_container.getAllElements(dsName);
        }
        catch (Exception ex) {
            this.throwNamingException(ex);
        }
        return new BindingEnumeration(contextList, objectList);
    }

    public final NamingEnumeration list(Name name) throws NamingException {
        if (name == null) {
            throw new InvalidNameException("Name object cannot be null");
        }
        return this.list(name.toString());
    }

    public final NamingEnumeration listBindings(String name) throws NamingException {
        String dsName;
        if (name.length() == 0) {
            dsName = this.m_fullCtxName;
        } else {
            if (!name.startsWith("/")) {
                name = '/' + name;
            }
            dsName = this.m_fullCtxName + name;
        }
        IDirIdentity[] contextList = null;
        IDirElement[] objectList = null;
        try {
            contextList = this.m_container.listDirectories(dsName);
            objectList = this.m_container.getAllElements(dsName);
        }
        catch (Exception ex) {
            this.throwNamingException(ex);
        }
        return new ObjectBindingEnumeration(contextList, objectList);
    }

    public final NamingEnumeration listBindings(Name name) throws NamingException {
        if (name == null) {
            throw new InvalidNameException("Name object cannot be null");
        }
        return this.listBindings(this.m_parser.convertToString(name));
    }

    @Override
    public final void destroySubcontext(String name) throws NamingException, ContextNotEmptyException {
        throw new OperationNotSupportedException("This Context does not support modifying the store");
    }

    @Override
    public final void destroySubcontext(Name name) throws NamingException {
        if (name == null || name.toString().length() == 0) {
            throw new NamingException("Cannot destroy subcontext with an empty name");
        }
        this.destroySubcontext(this.m_parser.convertToString(name));
    }

    @Override
    public final Context createSubcontext(Name name) throws NamingException, NameAlreadyBoundException, CommunicationException {
        if (name == null || name.toString().length() == 0) {
            throw new NamingException("Cannot create subcontext with an empty name");
        }
        return this.createSubcontext(this.m_parser.convertToString(name));
    }

    @Override
    public final Context createSubcontext(String name) throws NamingException, NameAlreadyBoundException, CommunicationException {
        throw new OperationNotSupportedException("This Context does not support modifying the store");
    }

    @Override
    public final Object lookupLink(String name) throws NamingException {
        return this.lookup(name);
    }

    @Override
    public final Object lookupLink(Name name) throws NamingException {
        return this.lookupLink(this.m_parser.convertToString(name));
    }

    @Override
    public final NameParser getNameParser(String name) throws NamingException {
        return this.m_parser;
    }

    @Override
    public final NameParser getNameParser(Name name) throws NamingException {
        return this.m_parser;
    }

    @Override
    public final String composeName(String name, String prefix) throws NamingException {
        if (name.length() == 0 || prefix.length() == 0) {
            throw new NamingException("Names can't be empty");
        }
        return this.composeName(this.m_parser.parse(name), this.m_parser.parse(prefix)).toString();
    }

    @Override
    public final Name composeName(Name name, Name prefix) throws NamingException {
        if (name == null || prefix == null) {
            throw new NamingException("Names can't be empty");
        }
        Name composition = (Name)prefix.clone();
        composition.addAll(name);
        return composition;
    }

    @Override
    public final Object addToEnvironment(String propName, Object propVal) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("addToEnvironment");
    }

    @Override
    public final Object removeFromEnvironment(String propName) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("addToEnvironment");
    }

    public final Hashtable getEnvironment() throws NamingException {
        return new Hashtable();
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        if (this.m_fullCtxName.equals("/_MFContext")) {
            return "";
        }
        return this.m_fullCtxName.substring(1 + "_MFContext".length() + 1);
    }

    @Override
    public void close() throws NamingException {
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    private void throwNamingException(Exception e) throws NamingException {
        ObjHelper.throwNamingException((Exception)e, (boolean)this.m_verboseTracing);
    }

    final class ObjectBindingEnumeration
    implements NamingEnumeration {
        HashSet set = new HashSet();
        Iterator m_iterator;

        ObjectBindingEnumeration(IDirIdentity[] contextList, IDirElement[] objectList) {
            this.init(contextList, objectList);
            this.m_iterator = this.set.iterator();
        }

        @Override
        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        public Object next() throws NamingException {
            return this.nextElement();
        }

        @Override
        public Object nextElement() {
            return this.m_iterator.next();
        }

        @Override
        public boolean hasMoreElements() {
            return this.m_iterator.hasNext();
        }

        @Override
        public void close() {
            this.set.clear();
        }

        private void init(IDirIdentity[] contextList, IDirElement[] objectList) {
            String fullname;
            int i;
            for (i = 0; i < contextList.length; ++i) {
                fullname = contextList[i].getName();
                try {
                    this.set.add(new NameClassPair(new EntityName(fullname).getBaseName(), CONTEXT_CLASSNAME));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            for (i = 0; i < objectList.length; ++i) {
                fullname = objectList[i].getIdentity().getName();
                String elmntType = objectList[i].getIdentity().getType();
                IAttributeSet attrs = objectList[i].getAttributes();
                String className = (String)attrs.getAttribute("classname");
                Object obj = null;
                try {
                    if (elmntType.equals("SerializedObject")) {
                        obj = ObjHelper.deserializeObject((byte[])((byte[])attrs.getAttribute("data")));
                    } else if (elmntType.equals("ReferenceObject")) {
                        obj = MFContext.this.getBindedRefObject((IElement)objectList[i], fullname);
                    }
                    this.set.add(new Binding(new EntityName(fullname).getBaseName(), className, obj));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    final class BindingEnumeration
    implements NamingEnumeration {
        HashSet set = new HashSet();
        Iterator m_iterator;

        BindingEnumeration(IDirIdentity[] contextList, IDirElement[] objectList) {
            this.init(contextList, objectList);
            this.m_iterator = this.set.iterator();
        }

        @Override
        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        @Override
        public boolean hasMoreElements() {
            return this.m_iterator.hasNext();
        }

        public Object next() throws NamingException {
            return this.nextElement();
        }

        @Override
        public Object nextElement() {
            return this.m_iterator.next();
        }

        @Override
        public void close() {
            this.set.clear();
        }

        private void init(IDirIdentity[] contextList, IDirElement[] objectList) {
            String fullname;
            int i;
            for (i = 0; i < contextList.length; ++i) {
                fullname = contextList[i].getName();
                try {
                    this.set.add(new NameClassPair(new EntityName(fullname).getBaseName(), CONTEXT_CLASSNAME));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            for (i = 0; i < objectList.length; ++i) {
                fullname = objectList[i].getIdentity().getName();
                IAttributeSet attrs = objectList[i].getAttributes();
                String className = (String)attrs.getAttribute("classname");
                try {
                    this.set.add(new NameClassPair(new EntityName(fullname).getBaseName(), className));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

