/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.directory.impl;

import com.sonicsw.mf.common.config.ConfigException;
import com.sonicsw.mf.common.config.IAttributeList;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IBasicElement;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mf.common.config.impl.EntityName;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.dirconfig.ElementFactory;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.dirconfig.IDirIdentity;
import com.sonicsw.mf.common.dirconfig.VersionOutofSyncException;
import com.sonicsw.mf.framework.IContainer;
import com.sonicsw.mf.framework.directory.IDebuggingMasks;
import com.sonicsw.mf.framework.directory.ILogger;
import com.sonicsw.mf.framework.directory.impl.AuthSource;
import com.sonicsw.mf.framework.directory.impl.DirectoryService;
import com.sonicsw.mf.framework.directory.impl.IAuthListener;
import com.sonicsw.mf.framework.directory.impl.TimeoutException;
import com.sonicsw.mx.util.ServiceMaintainer;
import com.sonicsw.mx.util.ServiceMaintenance;
import com.sonicsw.security.pass.client.IPasswordUser;
import com.sonicsw.security.pass.mf.IGroup;
import com.sonicsw.security.pass.mf.IManagement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;

final class AuthenticationConfigManager
implements ILogger,
IDebuggingMasks {
    public static final String MF_REFRESH_ELEMENT = "_MFRefreshTime";
    public static final char[] USER_RESTRICTED_CHARS = new char[]{'*', '#', '$', '/', '\\'};
    public static final char[] GROUP_RESTRICTED_CHARS = new char[]{'*', '#', '$', '/', '\\', '.', '=', ','};
    private static final long INITIALIZE_DOMAIN_TIMEOUT = 30000L;
    private static final long ASYNC_UPDATE_TIMEOUT = 60000L;
    private static final int DEFAULT_UPDATE_FREQUENCY_SECS = 600;
    private static final int DEFAULT_REFRESH_FREQUENCY_SECS = 2400;
    static final String DOMAINS_DIRECTORY = "/authentication/domains";
    static final String DOMAIN_DESCRIPTOR = "_MFDomainDescriptor";
    static final String DOMAIN_DESC_TYPE = "MF_AUTHENTICATION_DOMAIN";
    private static final String EXTERNAL_USER_TYPE = "MF_AUTHENTICATION_USER";
    private static final String EXTERNAL_GROUP_TYPE = "MF_AUTHENTICATION_GROUP";
    private static final String REFRESH_TYPE = "MF_REFRESH_TIME";
    private static final String SPI_DESC_TYPE = "MF_MANAGEMENT_SPI";
    private static final String USER_GROUP_MEMBER_TYPE = "user";
    private static final String MEMBER_TYPE = "MEMBER_TYPE";
    private static final String MEMBER_NAME = "MEMBER_NAME";
    private static final String DOMAIN_NAME_ATT = "DOMAIN_NAME";
    static final String DOMAIN_MGMT_SPI_ATT = "MGMT_SPI";
    static final String DOMAIN_EXTERNAL_ATT = "EXTERNAL";
    private static final String DOMAIN_CONNECTION_PARAM_ATT = "MGMT_SPI_CONNECTION_PARAMETERS";
    private static final String EXTERNAL_USER_NAME_ATT = "USER_NAME";
    private static final String EXTERNAL_USER_PASSWORD_ATT = "PASSWORD";
    private static final String EXTERNAL_GROUP_NAME_ATT = "GROUP_NAME";
    private static final String EXTERNAL_GROUP_MEMBERS_ATT = "GROUP_MEMBERS";
    private static final String SPI_SOURCE_TYPE_ATT = "MGMT_SPI_NAME";
    private static final String SPI_CLASS_NAME_ATT = "CLASS_NAME";
    private static final String SPI_CLASSPATH_ATT = "CLASSPATH";
    private static final String REFRESH_TIME_ATT = "RECENT_REFRESH_TIME";
    static final String EXTERNAL_DIR = "external";
    static final String EXTERNAL_USERS_DIR = "external/_MFUsers";
    static final String EXTERNAL_GROUPS_DIR = "external/_MFGroups";
    private DirectoryService m_ds;
    private DSUpdater m_dsUpdater;
    private HashMap m_domains;
    private HashMap m_spis;
    private ILogger m_logger;
    private IDirIdentity[] m_domainIDs;
    private HashMap m_forbiddenDirs;
    private ServiceMaintainer m_DSManagedUpdateThread;
    private boolean m_isStopped = true;
    private boolean m_isClosing = false;
    private long m_updateFrequency;
    private long m_refreshFrequency;

    AuthenticationConfigManager(DirectoryService ds, ILogger logger, boolean isRestrictedBackupDS) throws DirectoryServiceException {
        this.m_ds = ds;
        this.m_dsUpdater = new DSUpdater();
        this.m_logger = logger;
        int updateFrequencyInSeconds = Integer.getInteger("sonicsw.ds.auth.updateFrequency", 600);
        int refreshFrequencyInSeconds = Integer.getInteger("sonicsw.ds.auth.refreshFrequency", 2400);
        this.m_ds.logMessage("Setting external security domain update frequency to " + updateFrequencyInSeconds + " seconds", 3);
        this.m_ds.logMessage("Setting external security domain refresh frequency to " + refreshFrequencyInSeconds + " seconds", 3);
        this.m_updateFrequency = updateFrequencyInSeconds * 1000;
        this.m_refreshFrequency = refreshFrequencyInSeconds * 1000;
        this.getDomainsFromDS();
        ArrayList needInitDomains = this.getNeedUpdateDomains();
        this.initDomains(30000L, needInitDomains);
        if (!isRestrictedBackupDS) {
            this.createAsyncUpdates(this.m_updateFrequency);
        }
    }

    public void logMessage(String message, int severityLevel) {
        this.m_ds.logMessage(message, severityLevel);
    }

    public void logMessage(String message, Throwable throwable, int severityLevel) {
        this.m_ds.logMessage(message, throwable, severityLevel);
    }

    @Override
    public void trace(int mask, String message) {
        this.m_ds.trace(mask, message);
    }

    @Override
    public void trace(int mask, String message, Throwable throwable) {
        this.m_ds.trace(mask, message, throwable);
    }

    public synchronized void modifyDomainConnectionParameters(IElement domainDescriptorElement) {
        DomainConfiguration domainConf;
        block11: {
            HashMap newConnectionParameters;
            if (this.m_isClosing) {
                return;
            }
            EntityName elementName = null;
            try {
                elementName = new EntityName(domainDescriptorElement.getIdentity().getName());
            }
            catch (ConfigException e) {
                this.m_ds.logMessage("Failure to get security domain configuration identity, trace follows...", e, 1);
                return;
            }
            String domainID = elementName.getParent();
            domainConf = (DomainConfiguration)this.m_domains.get(domainID);
            if (domainConf == null) {
                return;
            }
            if (!domainConf.m_external) {
                return;
            }
            if (this.m_isStopped) {
                this.m_ds.logMessage("Ignoring new connection parameters of security domain \"" + domainConf.m_name + "\", with configuration id \"" + domainConf.m_domainID + "\" since the Directory Service is in a read-only state.", 2);
                return;
            }
            IAttributeSet descAttributes = domainDescriptorElement.getAttributes();
            IAttributeSet connectionAttributes = (IAttributeSet)descAttributes.getAttribute(DOMAIN_CONNECTION_PARAM_ATT);
            HashMap hashMap = newConnectionParameters = connectionAttributes == null ? null : connectionAttributes.getAttributes();
            if (!this.validConnectionParameters(newConnectionParameters)) {
                this.m_ds.logMessage("The new connection parameters of security domain \"" + domainConf.m_name + "\", with configuration id \"" + domainConf.m_domainID + "\" are invalid; the new parameters are ignored.", 2);
                return;
            }
            this.stopAsyncUpdate(domainConf);
            this.close(domainConf);
            domainConf.m_connectionParameters = newConnectionParameters;
            this.createAuthSource(domainConf);
            if (domainConf.m_externalSource == null) {
                this.m_ds.logMessage("Failed to connect with new connection parameters of security domain \"" + domainConf.m_name + "\", with configuration id \"" + domainConf.m_domainID + "\"", 2);
                this.m_ds.logMessage("Security domain \"" + domainConf.m_name + "\" is not being updated from the external source", 2);
                this.m_domains.remove(domainID);
                return;
            }
            if (domainConf.m_eventListener != null) {
                try {
                    this.updateAll(domainConf, 60000L, true);
                }
                catch (Exception e) {
                    if (e instanceof TimeoutException) break block11;
                    this.m_ds.logMessage("Failed to update security domain \"" + domainConf.m_name + "\", trace follows...", e, 2);
                    this.close(domainConf);
                    this.m_domains.remove(domainID);
                }
            }
        }
        this.startExternalAsyncUpdate(domainConf, this.m_updateFrequency);
    }

    private static boolean containsChar(String src, char[] chars) {
        if (src == null) {
            return false;
        }
        for (int i = 0; i < chars.length; ++i) {
            if (src.indexOf(chars[i]) == -1) continue;
            return true;
        }
        return false;
    }

    private boolean validConnectionParameters(HashMap paramTable) {
        if (paramTable == null) {
            return true;
        }
        Iterator params = paramTable.values().iterator();
        while (params.hasNext()) {
            if (params.next() instanceof String) continue;
            return false;
        }
        return true;
    }

    private void updateAll(DomainConfiguration domainConfig, long timeout, boolean updateRefreshElement) throws DirectoryServiceException, TimeoutException {
        this.updateExternalUsers(domainConfig, timeout);
        this.updateExternalGroups(domainConfig, timeout);
        if (updateRefreshElement) {
            this.updateRefreshElement(domainConfig);
        }
    }

    private void updateExternalUsers(DomainConfiguration domainConfig, long timeout) throws TimeoutException {
        IPasswordUser[] users = domainConfig.m_externalSource.getUsers(timeout);
        if (users == null) {
            users = new IPasswordUser[]{};
        }
        String domainUsersDir = domainConfig.m_domainID + "/" + EXTERNAL_USERS_DIR;
        IDirElement[] userElements = this.externalUsersToElements(users, domainUsersDir, domainConfig.m_name);
        try {
            this.m_dsUpdater.importFromList(userElements, new String[]{domainUsersDir});
        }
        catch (Throwable t) {
            this.m_ds.logMessage("Failed to update external users for security domain \"" + domainConfig.m_name + "\", trace follows...", t, 2);
        }
    }

    private void appendExternalUsers(IPasswordUser[] users, DomainConfiguration domainConfig) {
        if (users == null) {
            users = new IPasswordUser[]{};
        }
        String domainUsersDir = domainConfig.m_domainID + "/" + EXTERNAL_USERS_DIR;
        IDirElement[] userElements = this.externalUsersToElements(users, domainUsersDir, domainConfig.m_name);
        try {
            this.m_dsUpdater.importFromList(userElements, null);
        }
        catch (Throwable t) {
            this.m_ds.logMessage("Failed to append external users for security domain \"" + domainConfig.m_name + "\", trace follows...", t, 2);
        }
    }

    private void updateExternalGroups(DomainConfiguration domainConfig, long timeout) throws TimeoutException {
        IGroup[] groups = domainConfig.m_externalSource.getGroups(timeout);
        if (groups == null) {
            groups = new IGroup[]{};
        }
        String domainGroupsDir = domainConfig.m_domainID + "/" + EXTERNAL_GROUPS_DIR;
        IDirElement[] groupElements = this.externalGroupsToElements(groups, domainGroupsDir, domainConfig.m_name);
        try {
            this.m_dsUpdater.importFromList(groupElements, new String[]{domainGroupsDir});
        }
        catch (Throwable t) {
            this.m_ds.logMessage("Failed to update external groups for security domain \"" + domainConfig.m_name + "\", trace follows...", t, 2);
        }
    }

    private void appendExternalGroups(IGroup[] groups, DomainConfiguration domainConfig) {
        if (groups == null) {
            groups = new IGroup[]{};
        }
        String domainGroupsDir = domainConfig.m_domainID + "/" + EXTERNAL_GROUPS_DIR;
        IDirElement[] groupElements = this.externalGroupsToElements(groups, domainGroupsDir, domainConfig.m_name);
        try {
            this.m_dsUpdater.importFromList(groupElements, null);
        }
        catch (Throwable t) {
            this.m_ds.logMessage("Failed to append external groups for security domain \"" + domainConfig.m_name + "\", trace follows...", t, 2);
        }
    }

    private void deleteExternalPrincipals(String[] princNames, DomainConfiguration domainConfig, String dirName) {
        try {
            this.m_dsUpdater.deleteElements(this.externalPrincipalToElementNames(princNames, domainConfig.m_domainID + "/" + dirName));
        }
        catch (Throwable t) {
            this.m_ds.logMessage("Failed to delete external principals for security domain \"" + domainConfig.m_name + "\", trace follows...", t, 2);
        }
    }

    private String[] externalPrincipalToElementNames(String[] principalNames, String domainUsersDir) {
        String[] result = new String[principalNames.length];
        for (int i = 0; i < principalNames.length; ++i) {
            result[i] = domainUsersDir + "/" + principalNames[i];
        }
        return result;
    }

    private IDirElement[] externalGroupsToElements(IGroup[] groups, String domainGroupsDir, String domainName) {
        ArrayList<IBasicElement> groupsList = new ArrayList<IBasicElement>();
        HashMap<String, Boolean> duplicationDetection = new HashMap<String, Boolean>();
        for (int i = 0; i < groups.length; ++i) {
            String groupName;
            IPasswordUser[] groupUsers = groups[i].getGroupUsers();
            if (groupUsers == null) {
                groupUsers = new IPasswordUser[]{};
            }
            if ((groupName = groups[i].getName()) == null || groupName.trim().length() == 0) {
                this.m_ds.logMessage("An empty group name was received from external source of domain \"" + domainName + "\" - ignoring this group (name \"" + groupName + "\", idx " + i + ")", 2);
                continue;
            }
            if (duplicationDetection.put(groupName, Boolean.TRUE) != null) {
                this.m_ds.logMessage("A duplicate group \"" + groupName + "\"  was received from external source of domain \"" + domainName + "\" - ignoring the second one", 2);
                continue;
            }
            if (AuthenticationConfigManager.containsChar(groupName, GROUP_RESTRICTED_CHARS)) {
                this.m_ds.logMessage("Group name \"" + groupName + "\"  contains one of the following restricted characters \"" + new String(GROUP_RESTRICTED_CHARS) + "\" - ignoring this group", 2);
                continue;
            }
            String elementName = domainGroupsDir + "/" + groupName;
            IDirElement groupElement = ElementFactory.createElement((String)elementName, (String)EXTERNAL_GROUP_TYPE, (String)"107");
            IAttributeSet groupAttributes = groupElement.getAttributes();
            try {
                groupAttributes.setStringAttribute(EXTERNAL_GROUP_NAME_ATT, groupName);
                IAttributeSet membersSet = groupAttributes.createAttributeSet(EXTERNAL_GROUP_MEMBERS_ATT);
                for (int j = 0; j < groupUsers.length; ++j) {
                    String userName = groupUsers[j].getName();
                    IAttributeSet member = membersSet.createAttributeSet(userName);
                    member.setStringAttribute(MEMBER_NAME, userName);
                    member.setStringAttribute(MEMBER_TYPE, USER_GROUP_MEMBER_TYPE);
                }
                groupsList.add(groupElement.doneUpdate());
                continue;
            }
            catch (Throwable t) {
                this.throwError(t);
            }
        }
        IDirElement[] result = new IDirElement[groupsList.size()];
        groupsList.toArray(result);
        return result;
    }

    private IDirElement[] externalUsersToElements(IPasswordUser[] users, String domainUsersDir, String domainName) {
        ArrayList<IBasicElement> usersList = new ArrayList<IBasicElement>();
        HashMap<String, Boolean> duplicationDetection = new HashMap<String, Boolean>();
        for (int i = 0; i < users.length; ++i) {
            String userName = users[i].getName();
            if (duplicationDetection.put(userName, Boolean.TRUE) != null) {
                this.m_ds.logMessage("A duplicate User \"" + userName + "\"  was received from external source of domain \"" + domainName + "\" - ignoring the second one", 2);
                continue;
            }
            if (AuthenticationConfigManager.containsChar(userName, USER_RESTRICTED_CHARS)) {
                this.m_ds.logMessage("User name \"" + userName + "\"  contains one of the following restricted characters \"" + new String(USER_RESTRICTED_CHARS) + "\" - ignoring this user", 2);
                continue;
            }
            byte[] password = users[i].getPassword();
            String elementName = domainUsersDir + "/" + userName;
            IDirElement userElement = ElementFactory.createElement((String)elementName, (String)EXTERNAL_USER_TYPE, (String)"107");
            IAttributeSet userAttributes = userElement.getAttributes();
            try {
                userAttributes.setStringAttribute(EXTERNAL_USER_NAME_ATT, userName);
                userAttributes.setBytesAttribute(EXTERNAL_USER_PASSWORD_ATT, password);
                usersList.add(userElement.doneUpdate());
                continue;
            }
            catch (Throwable t) {
                this.throwError(t);
            }
        }
        IDirElement[] result = new IDirElement[usersList.size()];
        usersList.toArray(result);
        return result;
    }

    private IBasicElement createRefreshElement(String elementName) {
        IDirElement element = ElementFactory.createElement((String)elementName, (String)REFRESH_TYPE, (String)"107");
        IAttributeSet attributes = element.getAttributes();
        try {
            attributes.setLongAttribute(REFRESH_TIME_ATT, new Long(0L));
            return element.doneUpdate();
        }
        catch (Throwable t) {
            this.throwError(t);
            return null;
        }
    }

    private long getRefreshTime(IElement element) {
        IAttributeSet attributes = element.getAttributes();
        return (Long)attributes.getAttribute(REFRESH_TIME_ATT);
    }

    private void updateRefreshElement(DomainConfiguration domainConfig) {
        try {
            IDirElement element = this.m_ds.getElement(domainConfig.m_domainID + "/" + MF_REFRESH_ELEMENT, true);
            IAttributeSet attributes = element.getAttributes();
            attributes.setLongAttribute(REFRESH_TIME_ATT, new Long(System.currentTimeMillis()));
            this.m_dsUpdater.setElement(element.doneUpdate());
        }
        catch (Throwable t) {
            if (t instanceof VersionOutofSyncException) {
                return;
            }
            this.m_ds.logMessage("Failed to update refresh element for security domain \"" + domainConfig.m_name + "\", trace follows...", t, 2);
        }
    }

    private void throwError(Throwable t) {
        this.m_ds.logMessage("Security domain management failure, trace follows...", t, 2);
        Error e = new Error("Security domain management failure, see cause");
        e.initCause(t);
        throw e;
    }

    private void getDomainsFromDS() throws DirectoryServiceException {
        this.m_domains = new HashMap();
        this.m_spis = new HashMap();
        this.m_domainIDs = new IDirIdentity[0];
        try {
            this.m_domainIDs = this.m_ds.listDirectories(DOMAINS_DIRECTORY);
        }
        catch (DirectoryServiceException e) {
            this.m_ds.trace(64, "AuthenticationConfigManager: No \"/authentication/domains\" directory.");
            return;
        }
        for (int i = 0; i < this.m_domainIDs.length; ++i) {
            String domainID = this.m_domainIDs[i].getName();
            this.getDomainsFromDS(domainID);
        }
    }

    private void getDomainsFromDS(String domainID) throws DirectoryServiceException {
        String descriptorName = domainID + "/" + DOMAIN_DESCRIPTOR;
        IDirElement domainDescriptor = this.m_ds.getElement(descriptorName, false);
        if (domainDescriptor == null) {
            this.m_ds.logMessage("Could not find the domain decriptor for the \"" + domainID + "\" domain", 2);
            return;
        }
        DomainConfiguration domainConf = this.getDomainConfFromElement((IElement)domainDescriptor, domainID);
        if (domainConf == null) {
            return;
        }
        MgmtSPIConfiguration spiConfig = (MgmtSPIConfiguration)this.m_spis.get(domainConf.m_mgmtSpiRef);
        if (domainConf.m_external && spiConfig == null) {
            IDirElement spiDescriptor = this.m_ds.getElement(domainConf.m_mgmtSpiRef, false);
            if (spiDescriptor == null) {
                this.m_ds.logMessage("Could not find the \"" + domainConf.m_mgmtSpiRef + "\" configuration", 2);
                this.logDomainFailure(domainConf.m_name);
                return;
            }
            spiConfig = this.getSPIConfFromElement((IElement)spiDescriptor);
            if (spiConfig == null) {
                this.logDomainFailure(domainConf.m_name);
                return;
            }
            spiConfig.m_spiClass = this.getSPIClass(spiConfig.m_className, spiConfig.m_classpath);
            if (spiConfig.m_spiClass == null) {
                this.logDomainFailure(domainConf.m_name);
                return;
            }
            this.m_spis.put(domainConf.m_mgmtSpiRef, spiConfig);
        }
        if (domainConf.m_external) {
            domainConf.m_managementInstance = this.getSPIInstance(spiConfig.m_spiClass);
            if (domainConf.m_managementInstance == null) {
                this.logDomainFailure(domainConf.m_name);
                return;
            }
            this.createAuthSource(domainConf);
            if (domainConf.m_externalSource == null) {
                this.logDomainFailure(domainConf.m_name);
                return;
            }
        }
        this.m_domains.put(domainID, domainConf);
    }

    ArrayList getNeedUpdateDomains() throws DirectoryServiceException {
        this.m_forbiddenDirs = new HashMap();
        ArrayList<String> needUpdateDomains = new ArrayList<String>();
        for (int i = 0; i < this.m_domainIDs.length; ++i) {
            String domainID = this.m_domainIDs[i].getName();
            String domainIDToUpdate = this.getNeedUpdateDomains(domainID, false);
            if (domainIDToUpdate == null) continue;
            needUpdateDomains.add(domainIDToUpdate);
        }
        return needUpdateDomains;
    }

    void createExternalDirectories(String domainID) throws DirectoryServiceException {
        String externalDir = domainID + "/" + EXTERNAL_DIR;
        String domainUsers = domainID + "/" + EXTERNAL_USERS_DIR;
        String domainGroups = domainID + "/" + EXTERNAL_GROUPS_DIR;
        this.m_forbiddenDirs.put(domainUsers, Boolean.TRUE);
        this.m_forbiddenDirs.put(domainGroups, Boolean.TRUE);
        if (!this.m_ds.directoryExists(externalDir)) {
            this.m_ds.createDirectory(externalDir);
        }
        if (!this.m_ds.directoryExists(domainUsers)) {
            this.m_ds.createDirectory(domainUsers);
        }
        if (!this.m_ds.directoryExists(domainGroups)) {
            this.m_ds.createDirectory(domainGroups);
        }
    }

    private String getNeedUpdateDomains(String domainID, boolean reloadExternalAuthenticationDomain) throws DirectoryServiceException {
        String refreshElementName;
        IDirElement refreshElement;
        DomainConfiguration domainConf = (DomainConfiguration)this.m_domains.get(domainID);
        if (domainConf == null || !domainConf.m_external) {
            return null;
        }
        if (domainConf.m_external) {
            this.createExternalDirectories(domainID);
        }
        if ((refreshElement = this.m_ds.getElement(refreshElementName = domainID + "/" + MF_REFRESH_ELEMENT, false)) == null) {
            if (reloadExternalAuthenticationDomain) {
                this.m_dsUpdater.setElement(this.createRefreshElement(refreshElementName));
            } else {
                this.m_ds.setElement(this.createRefreshElement(refreshElementName), null);
            }
            return domainID;
        }
        if (this.getRefreshTime((IElement)refreshElement) == 0L) {
            return domainID;
        }
        if (domainConf.m_eventListener != null) {
            return domainID;
        }
        return null;
    }

    void initDomains(long timeout, ArrayList newDomains) {
        int i;
        ArrayList<String> failedDomains = new ArrayList<String>();
        for (i = 0; i < newDomains.size(); ++i) {
            String domainID = (String)newDomains.get(i);
            DomainConfiguration domainConf = (DomainConfiguration)this.m_domains.get(domainID);
            if (domainConf == null || !domainConf.m_external) continue;
            try {
                this.updateAll(domainConf, timeout, true);
                continue;
            }
            catch (Exception e) {
                if (e instanceof TimeoutException) {
                    this.m_ds.logMessage("Failed to initialize security domain \"" + domainConf.m_name + "\" due to timeout", 2);
                } else {
                    this.m_ds.logMessage("Failed to initialize security domain \"" + domainConf.m_name + "\", trace follows...", e, 2);
                }
                failedDomains.add(domainID);
            }
        }
        for (i = 0; i < failedDomains.size(); ++i) {
            DomainConfiguration domainConfig = (DomainConfiguration)this.m_domains.remove(failedDomains.get(i));
            this.close(domainConfig);
        }
    }

    private void createAuthSource(DomainConfiguration domainConf) {
        try {
            domainConf.m_externalSource = new AuthSource(domainConf.m_managementInstance, domainConf.m_name, domainConf.m_connectionParameters, this);
            EventListener listener = new EventListener(domainConf);
            domainConf.m_eventListener = domainConf.m_externalSource.registerListener(listener) ? listener : null;
            domainConf.m_externalSource.connect();
        }
        catch (Throwable throwable) {
            this.m_ds.trace(64, "SPI failure, trace follows...", throwable);
            domainConf.m_externalSource = null;
            domainConf.m_eventListener = null;
        }
    }

    private void logDomainFailure(String domainName) {
        this.m_ds.logMessage("Could not load the \"" + domainName + "\" domain", 2);
    }

    private Class getSPIClass(String className, IAttributeList classpathList) {
        try {
            return this.m_ds.loadClass(className, DirectoryService.listToClasspath(classpathList));
        }
        catch (Throwable t) {
            this.m_ds.logMessage("Could not load SPI authentication management class \"" + className + "\", trace follows...", t, 1);
            return null;
        }
    }

    private IManagement getSPIInstance(Class spiClass) {
        try {
            Object SPIInstance = spiClass.newInstance();
            if (!(SPIInstance instanceof IManagement)) {
                this.m_ds.logMessage(spiClass.getName() + " does not implement the authentication management SPI interface", 1);
                return null;
            }
            return (IManagement)SPIInstance;
        }
        catch (Throwable t) {
            this.m_ds.logMessage("Could not create an instance of an authentication management class \"" + spiClass.getName() + "\", trace follows...", t, 1);
            return null;
        }
    }

    private ServiceMaintainer startRefreshElementThread() {
        ServiceMaintenance dsMaintenance = new ServiceMaintenance(){

            public Exception doMaintenance() {
                AuthenticationConfigManager.this.updateRefreshElements();
                return null;
            }

            public void onAccessibilityChange(boolean isAccessible) {
            }
        };
        return new ServiceMaintainer("Element Refresher", dsMaintenance, this.m_refreshFrequency, false);
    }

    private void updateRefreshElements() {
        for (DomainConfiguration domainConf : this.m_domains.values()) {
            if (domainConf.m_eventListener == null || !domainConf.m_externalSource.isConnected()) continue;
            this.updateRefreshElement(domainConf);
        }
    }

    String[] getExternalDomainsDescriptors() {
        ArrayList<String> externalDescNames = new ArrayList<String>();
        for (DomainConfiguration domainConf : this.m_domains.values()) {
            if (!domainConf.m_external) continue;
            externalDescNames.add(domainConf.m_domainID + "/" + DOMAIN_DESCRIPTOR);
        }
        String[] result = new String[externalDescNames.size()];
        externalDescNames.toArray(result);
        return result;
    }

    void startClosingDomain(String domainID) {
        this.m_dsUpdater.registerThread();
        DomainConfiguration domainConf = (DomainConfiguration)this.m_domains.get(domainID);
        if (domainConf == null || !domainConf.m_external) {
            return;
        }
        this.stopAsyncUpdate(domainConf);
        this.close(domainConf);
        this.m_domains.remove(domainID);
    }

    void endClosingDomain() {
        this.m_dsUpdater.unregisterThread();
    }

    private void startExternalAsyncUpdate(DomainConfiguration domainConf, long frequency) {
        if (domainConf.m_eventListener != null) {
            domainConf.m_eventListener.stopDelay();
            return;
        }
        ServiceMaintenance dsMaintenance = new ServiceMaintenance(){

            public Exception doMaintenance(String domainID) {
                return AuthenticationConfigManager.this.updateExternalDomain((DomainConfiguration)AuthenticationConfigManager.this.m_domains.get(domainID));
            }

            public Exception doMaintenance() {
                AuthenticationConfigManager.this.m_ds.logMessage("startExternalAsyncUpdate.doMaintenance() shold never be called", 1);
                return null;
            }

            public void onAccessibilityChange(boolean isAccessible) {
                if (isAccessible) {
                    AuthenticationConfigManager.this.m_ds.trace(64, "External authentication information update started");
                } else {
                    AuthenticationConfigManager.this.m_ds.trace(64, "External authentication information update failed - retrying...");
                }
            }
        };
        domainConf.m_externalUpdateThread = new ServiceMaintainer(dsMaintenance, frequency, false, domainConf.m_domainID);
    }

    private Exception updateExternalDomain(DomainConfiguration domainConfig) {
        try {
            long timeNow = System.currentTimeMillis();
            long timeSinceLastUpdate = timeNow - domainConfig.m_lastUpdateThreadRefresh;
            boolean needRefresh = timeSinceLastUpdate >= this.m_refreshFrequency;
            this.updateAll(domainConfig, 60000L, needRefresh);
            if (needRefresh) {
                domainConfig.m_lastUpdateThreadRefresh = timeNow;
            }
        }
        catch (Exception e) {
            return e;
        }
        return null;
    }

    synchronized void stopAsyncUpdates() {
        this.m_isStopped = true;
        if (this.m_DSManagedUpdateThread != null) {
            this.m_DSManagedUpdateThread.close();
            try {
                this.m_DSManagedUpdateThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.m_DSManagedUpdateThread = null;
        }
        Iterator domains = this.m_domains.values().iterator();
        while (domains.hasNext()) {
            this.stopAsyncUpdate((DomainConfiguration)domains.next());
        }
    }

    synchronized void stopAsyncUpdate(DomainConfiguration domainConfig) {
        if (domainConfig.m_externalUpdateThread != null) {
            domainConfig.m_externalUpdateThread.close();
            try {
                domainConfig.m_externalUpdateThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            domainConfig.m_externalUpdateThread = null;
        } else if (domainConfig.m_eventListener != null) {
            domainConfig.m_eventListener.startDelay();
        }
    }

    void createAsyncUpdates() {
        this.createAsyncUpdates(this.m_updateFrequency);
    }

    private synchronized void createAsyncUpdates(long frequency) {
        this.m_isStopped = false;
        Iterator domains = this.m_domains.values().iterator();
        boolean needRefreshThred = false;
        while (domains.hasNext()) {
            DomainConfiguration domainConf = (DomainConfiguration)domains.next();
            if (!domainConf.m_external) continue;
            this.startExternalAsyncUpdate(domainConf, frequency);
            if (domainConf.m_eventListener == null) continue;
            needRefreshThred = true;
        }
        if (needRefreshThred) {
            this.m_DSManagedUpdateThread = this.startRefreshElementThread();
        }
    }

    synchronized void close() {
        this.m_isClosing = true;
        this.stopAsyncUpdates();
        Iterator domains = this.m_domains.values().iterator();
        while (domains.hasNext()) {
            this.close((DomainConfiguration)domains.next());
        }
    }

    private void close(DomainConfiguration domainConfig) {
        if (!domainConfig.m_external) {
            return;
        }
        if (domainConfig.m_externalSource != null) {
            domainConfig.m_externalSource.disconnect();
        }
        domainConfig.m_externalSource = null;
    }

    public String toString() {
        String result = "";
        if (!this.m_spis.isEmpty()) {
            result = result + "Management SPIs:" + IContainer.NEWLINE;
        }
        for (MgmtSPIConfiguration spiConfig : this.m_spis.values()) {
            result = result + spiConfig.m_sourceType + " " + spiConfig.m_className + IContainer.NEWLINE;
        }
        if (!this.m_domains.isEmpty()) {
            result = result + IContainer.NEWLINE + "Domains:" + IContainer.NEWLINE;
        }
        for (DomainConfiguration domainConfig : this.m_domains.values()) {
            result = result + domainConfig.m_name + (domainConfig.m_external ? " 'external' " : " 'DS managed' ") + (domainConfig.m_mgmtSpiRef != null ? domainConfig.m_mgmtSpiRef : "") + " " + IContainer.NEWLINE;
        }
        if (!this.m_forbiddenDirs.isEmpty()) {
            result = result + IContainer.NEWLINE + "Restricted Directories:" + IContainer.NEWLINE;
        }
        Iterator fDirs = this.m_forbiddenDirs.keySet().iterator();
        while (fDirs.hasNext()) {
            result = result + (String)fDirs.next() + IContainer.NEWLINE;
        }
        return result;
    }

    private DomainConfiguration getDomainConfFromElement(IElement descElement, String domainID) {
        IElementIdentity descID = descElement.getIdentity();
        if (!descID.getType().equals(DOMAIN_DESC_TYPE)) {
            this.m_ds.logMessage("\"" + descID.getName() + "\" has the wrong type. Should be \"" + DOMAIN_DESC_TYPE + "\"", 2);
            return null;
        }
        IAttributeSet descAttributes = descElement.getAttributes();
        DomainConfiguration domainConfig = new DomainConfiguration();
        domainConfig.m_domainID = domainID;
        String name = (String)descAttributes.getAttribute(DOMAIN_NAME_ATT);
        domainConfig.m_name = name == null ? "?" : name;
        Reference spiRef = (Reference)descAttributes.getAttribute(DOMAIN_MGMT_SPI_ATT);
        domainConfig.m_mgmtSpiRef = spiRef == null ? null : spiRef.getElementName();
        Boolean external = (Boolean)descAttributes.getAttribute(DOMAIN_EXTERNAL_ATT);
        domainConfig.m_external = external == null ? false : external;
        IAttributeSet connectionAttributes = (IAttributeSet)descAttributes.getAttribute(DOMAIN_CONNECTION_PARAM_ATT);
        HashMap hashMap = domainConfig.m_connectionParameters = connectionAttributes == null ? null : connectionAttributes.getAttributes();
        if (!this.validConnectionParameters(domainConfig.m_connectionParameters)) {
            this.m_ds.logMessage("The connection parameters of domain \"" + domainConfig.m_name + "\", with configuration id \"" + descID.getName() + "\" are not valid - must be of type String", 2);
            return null;
        }
        if (domainConfig.m_external && domainConfig.m_mgmtSpiRef == null) {
            this.m_ds.logMessage("Domain \"" + domainConfig.m_name + "\", with configuration id \"" + descID.getName() + "\" is external. It does not contain reference to Management SPI class", 2);
            return null;
        }
        return domainConfig;
    }

    private MgmtSPIConfiguration getSPIConfFromElement(IElement descElement) {
        IElementIdentity descID = descElement.getIdentity();
        if (!descID.getType().equals(SPI_DESC_TYPE)) {
            this.m_ds.logMessage("\"" + descID.getName() + "\" has the wrong type. Should be \"" + SPI_DESC_TYPE + "\"", 2);
            return null;
        }
        IAttributeSet descAttributes = descElement.getAttributes();
        MgmtSPIConfiguration spiConfig = new MgmtSPIConfiguration();
        String type = (String)descAttributes.getAttribute(SPI_SOURCE_TYPE_ATT);
        spiConfig.m_sourceType = type == null ? "?" : type;
        spiConfig.m_className = (String)descAttributes.getAttribute(SPI_CLASS_NAME_ATT);
        spiConfig.m_classpath = (IAttributeList)descAttributes.getAttribute(SPI_CLASSPATH_ATT);
        return spiConfig;
    }

    void okToModify(EntityName name) throws DirectoryServiceException {
        String parentDir = name.getParentEntity().getName();
        Thread thisThread = Thread.currentThread();
        if (!(thisThread instanceof ServiceMaintainer) && !this.m_dsUpdater.isAuthorized(thisThread)) {
            if (this.m_forbiddenDirs.get(parentDir) != null) {
                throw new DirectoryServiceException("Elements under the \"" + parentDir + "\" directory cannot be modified.");
            }
            if (name.getBaseName().equals(MF_REFRESH_ELEMENT)) {
                throw new DirectoryServiceException("\"_MFRefreshTime\" cannot be modified.");
            }
        }
    }

    void okToDeleteDir(EntityName nameE) throws DirectoryServiceException {
        String name = nameE.getName();
        if (name.equals("/") || name.equals("/_MFSystem")) {
            throw new DirectoryServiceException("\"" + name + "\" cannot be deleted.");
        }
        if (this.m_forbiddenDirs.get(name) != null && !this.m_dsUpdater.isAuthorized(Thread.currentThread())) {
            throw new DirectoryServiceException("The \"" + name + "\" directory cannot be modified.");
        }
    }

    void okToModify(String name) throws DirectoryServiceException {
        try {
            this.okToModify(new EntityName(name));
        }
        catch (ConfigException e) {
            throw new DirectoryServiceException(e.getMessage());
        }
    }

    Boolean reloadExternalAuthenticationDomain(String domainID) throws DirectoryServiceException {
        this.getDomainsFromDS(domainID);
        ArrayList<String> needUpdateDomains = new ArrayList<String>();
        String domainIDToUpdate = this.getNeedUpdateDomains(domainID, true);
        if (domainIDToUpdate != null) {
            needUpdateDomains.add(domainIDToUpdate);
        }
        this.initDomains(30000L, needUpdateDomains);
        return Boolean.TRUE;
    }

    private final class MgmtSPIConfiguration {
        String m_sourceType;
        String m_className;
        IAttributeList m_classpath;
        Class m_spiClass;

        private MgmtSPIConfiguration() {
        }
    }

    private final class DomainConfiguration {
        String m_name;
        String m_domainID;
        String m_mgmtSpiRef;
        boolean m_external;
        IManagement m_managementInstance = null;
        HashMap m_connectionParameters = null;
        AuthSource m_externalSource = null;
        ServiceMaintainer m_externalUpdateThread = null;
        EventListener m_eventListener = null;
        long m_lastUpdateThreadRefresh = 0L;

        private DomainConfiguration() {
        }
    }

    private final class EventListener
    implements IAuthListener {
        final short UPDATE_USERS = 1;
        final short UPDATE_GROUPS = (short)2;
        final short DELETE_USERS = (short)3;
        final short DELETE_GROUPS = (short)4;
        final short CONNECTION_RECOVERED = (short)5;
        private DomainConfiguration m_domainConfig;
        private boolean m_delayMode;
        private ArrayList m_events;

        EventListener(DomainConfiguration domainConfig) {
            this.m_domainConfig = domainConfig;
            this.m_delayMode = true;
            this.m_events = new ArrayList();
        }

        synchronized void stopDelay() {
            this.m_delayMode = false;
            this.applyDelayedEvents();
        }

        synchronized void startDelay() {
            this.m_delayMode = true;
        }

        @Override
        public synchronized void connectionRecovered() {
            block3: {
                if (this.m_delayMode) {
                    this.m_events.add(new Event(5));
                    return;
                }
                this.startDelay();
                try {
                    AuthenticationConfigManager.this.updateAll(this.m_domainConfig, 60000L, true);
                }
                catch (Exception e) {
                    if (e instanceof TimeoutException) break block3;
                    AuthenticationConfigManager.this.m_ds.logMessage("Failed to update domain \"" + this.m_domainConfig.m_name + "\" from external source, trace follows...", e, 2);
                }
            }
            this.stopDelay();
        }

        @Override
        public synchronized void updateUsers(IPasswordUser[] users) {
            if (this.m_delayMode) {
                this.m_events.add(new Event(users, 1));
            } else {
                AuthenticationConfigManager.this.appendExternalUsers(users, this.m_domainConfig);
                AuthenticationConfigManager.this.updateRefreshElement(this.m_domainConfig);
            }
        }

        @Override
        public synchronized void updateGroups(IGroup[] groups) {
            if (this.m_delayMode) {
                this.m_events.add(new Event(groups, 2));
            } else {
                AuthenticationConfigManager.this.appendExternalGroups(groups, this.m_domainConfig);
                AuthenticationConfigManager.this.updateRefreshElement(this.m_domainConfig);
            }
        }

        @Override
        public synchronized void deletePrincipals(String[] principals, boolean isUsers) {
            if (this.m_delayMode) {
                this.m_events.add(new Event(principals, isUsers ? (short)3 : 4));
            } else {
                AuthenticationConfigManager.this.deleteExternalPrincipals(principals, this.m_domainConfig, isUsers ? AuthenticationConfigManager.EXTERNAL_USERS_DIR : AuthenticationConfigManager.EXTERNAL_GROUPS_DIR);
                AuthenticationConfigManager.this.updateRefreshElement(this.m_domainConfig);
            }
        }

        private void applyDelayedEvents() {
            block7: for (int i = 0; i < this.m_events.size(); ++i) {
                Event event = (Event)this.m_events.get(i);
                switch (event.m_type) {
                    case 5: {
                        this.connectionRecovered();
                        continue block7;
                    }
                    case 1: {
                        AuthenticationConfigManager.this.appendExternalUsers((IPasswordUser[])event.m_data, this.m_domainConfig);
                        continue block7;
                    }
                    case 2: {
                        AuthenticationConfigManager.this.appendExternalGroups((IGroup[])event.m_data, this.m_domainConfig);
                        continue block7;
                    }
                    case 3: {
                        AuthenticationConfigManager.this.deleteExternalPrincipals((String[])event.m_data, this.m_domainConfig, AuthenticationConfigManager.EXTERNAL_USERS_DIR);
                        continue block7;
                    }
                    case 4: {
                        AuthenticationConfigManager.this.deleteExternalPrincipals((String[])event.m_data, this.m_domainConfig, AuthenticationConfigManager.EXTERNAL_GROUPS_DIR);
                    }
                }
            }
            if (!this.m_events.isEmpty()) {
                this.m_events = new ArrayList();
                AuthenticationConfigManager.this.updateRefreshElement(this.m_domainConfig);
            }
        }

        private final class Event {
            Object m_data;
            short m_type;

            Event(Object data, short type) {
                this.m_data = data;
                this.m_type = type;
            }

            Event(short type) {
                this.m_data = null;
                this.m_type = type;
            }
        }
    }

    private final class DSUpdater {
        Hashtable m_authrizedThreads = new Hashtable();

        private DSUpdater() {
        }

        boolean isAuthorized(Thread thread) {
            return this.m_authrizedThreads.containsKey(thread);
        }

        void registerThread() {
            this.m_authrizedThreads.put(Thread.currentThread(), Boolean.TRUE);
        }

        void unregisterThread() {
            this.m_authrizedThreads.remove(Thread.currentThread());
        }

        void importFromList(IDirElement[] elements, String[] deleteList) throws DirectoryServiceException {
            try {
                this.registerThread();
                AuthenticationConfigManager.this.m_ds.importFromList(elements, deleteList);
            }
            finally {
                this.unregisterThread();
            }
        }

        void deleteElements(String[] names) throws DirectoryServiceException {
            try {
                this.registerThread();
                AuthenticationConfigManager.this.m_ds.deleteElements(names);
            }
            finally {
                this.unregisterThread();
            }
        }

        void setElement(IBasicElement element) throws DirectoryServiceException {
            try {
                this.registerThread();
                AuthenticationConfigManager.this.m_ds.setElement(element, null);
            }
            finally {
                this.unregisterThread();
            }
        }
    }
}

