/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.lm.ILockManager;
import com.sonicsw.lm.impl.LockManager;
import com.sonicsw.mtstorage.BTreeLockNeededException;
import com.sonicsw.mtstorage.DeadlockException;
import com.sonicsw.mtstorage.IBTreeManager;
import com.sonicsw.mtstorage.IObjectInfo;
import com.sonicsw.mtstorage.IStorage;
import com.sonicsw.mtstorage.LockTimeoutException;
import com.sonicsw.mtstorage.LockWaitInterruptedException;
import com.sonicsw.mtstorage.StorageFileDoesNotExistException;
import com.sonicsw.mtstorage.StorageFormatException;
import com.sonicsw.mtstorage.impl.AccessSemaphore;
import com.sonicsw.mtstorage.impl.AllocateLogicalNote;
import com.sonicsw.mtstorage.impl.AsyncDeleteManager;
import com.sonicsw.mtstorage.impl.AsyncDeleteNote;
import com.sonicsw.mtstorage.impl.BTreeLockID;
import com.sonicsw.mtstorage.impl.BTreeManager;
import com.sonicsw.mtstorage.impl.BitUtil;
import com.sonicsw.mtstorage.impl.CheckpointNote;
import com.sonicsw.mtstorage.impl.CheckpointV2Note;
import com.sonicsw.mtstorage.impl.Constants;
import com.sonicsw.mtstorage.impl.DataPage;
import com.sonicsw.mtstorage.impl.Dbkey;
import com.sonicsw.mtstorage.impl.DeleteByAsyncThreadLogicalNote;
import com.sonicsw.mtstorage.impl.DeleteLogicalNote;
import com.sonicsw.mtstorage.impl.LogReader;
import com.sonicsw.mtstorage.impl.Logger;
import com.sonicsw.mtstorage.impl.LogicalRollback;
import com.sonicsw.mtstorage.impl.MasterPage;
import com.sonicsw.mtstorage.impl.ObjectFragment;
import com.sonicsw.mtstorage.impl.ObjectInfo;
import com.sonicsw.mtstorage.impl.ObjectsBuffer;
import com.sonicsw.mtstorage.impl.Page;
import com.sonicsw.mtstorage.impl.PageManager;
import com.sonicsw.mtstorage.impl.RecoveryInterruptException;
import com.sonicsw.mtstorage.impl.ReplicationState;
import com.sonicsw.mtstorage.impl.Replicator;
import com.sonicsw.mtstorage.impl.SnapshotManager;
import com.sonicsw.mtstorage.impl.SnapshotStorage;
import com.sonicsw.mtstorage.impl.TransactionManager;
import com.sonicsw.mtstorage.impl.UpdateLogicalNote;
import com.sonicsw.mtstorage.replication.ActiveStorageManager;
import com.sonicsw.mtstorage.replication.IReplicatedStorage;
import com.sonicsw.mtstorage.replication.ReplicationManager;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;

public final class Storage
implements IStorage,
IReplicatedStorage {
    private static final java.util.logging.Logger LOGGER = java.util.logging.Logger.getLogger("pse");
    static final String NO_CHECKPOINT_PARAMETER = "NO_CHECKPOINT";
    static final String NO_READ_LOCK_PARAMETER = "NO_READ_LOCK";
    static final String SNAPSHOT_STORAGE_PARAMETER = "SNAPSHOT_STORAGE_PARAMETER";
    static final String BTREE_LOCKING_LEVEL_PARAMETER = "BTREE_LOCKING_LEVEL";
    static final String ASYNC_PAGE_WRITING_PARAMETER = "ASYNC_PAGE_WRITING";
    private static final String ASYNCHRONOUS_PAGE_WRITE_FREQUENCY_PARAMETER = "ASYNCHRONOUS_PAGE_WRITE_FREQUENCY";
    private static final Integer ASYNCHRONOUS_PAGE_WRITE_FREQUENCY_DEFAULT = new Integer(0);
    private static final boolean CHECK_INTEGRITY = false;
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final String FULL_PAGE_THRESHOLD_PARAMETER = "FULL_PAGE_THRESHOLD";
    private static final String LOCK_FILE_NAME = "lock";
    private static final int FULL_PAGE_THRESHOLD_DEFAULT = Page.PAGE_LENGTH;
    private static final String LOG_CACHE_MAX_SIZE_PARAMETER = "LOG_CACHE_MAX_SIZE";
    private static final int LOG_CACHE_MAX_SIZE_DEFAULT = 1000;
    private static final String CHECKPOINT_LOGID_INTERVAL_PARAMETER = "CHECKPOINT_LOGID_INTERVAL";
    private static final int CHECKPOINT_LOGID_INTERVAL_DEFAULT = 10000000;
    private static final int CHECKPOINT_LOGID_INTERVAL_MIN = 1000000;
    private static final int MAX_REPLICATED_PAGES = 100;
    private static final int MINIMAL_OBJECT_SIZE_FOR_ASYNC_DELETION = 100000;
    static final String SONIC_BACKUP_CHECKPOINT_PARAMETER = "_SONIC_BACKUP_CHECKPOINT_NOTE_ID";
    static final String SONIC_BACKUP_LASTNOTE_PARAMETER = "_SONIC_BACKUP_LAST_NOTE_ID";
    private Logger m_logger;
    private PageManager m_pageManager;
    private TransactionManager m_transactionManager;
    private ILockManager m_lockManager;
    private File m_lockFile;
    private FileLock m_fileLock;
    private File m_dbDir;
    private String m_dbName;
    private HashMap m_parameters;
    private SnapshotManager m_snapshotManager;
    private BTreeManager m_btreeManager;
    private ReplicationState m_replicationState = new ReplicationState(517);
    private AllocateLogicalNote m_allocateLogicalNote;
    private UpdateLogicalNote m_updateLogicalNote;
    private DeleteLogicalNote m_deleteLogicalNote;
    private DeleteByAsyncThreadLogicalNote m_deleteByAsyncThreadLogicalNote;
    private AsyncDeleteNote m_asyncDeleteNote;
    AccessSemaphore m_accessSemaphore;
    private short m_inCritical = 0;
    private boolean m_threadDeath = false;
    private long m_lastCheckpointID;
    private long m_lastCheckpointIDTentative;
    private Long m_oldestTransactionNoteIDAtLastCheckpoint;
    private Long m_oldestTransactionNoteIDAtLastCheckpointTentative;
    private Long m_smallestPinnedDownNoteID;
    private boolean m_asyncPageWriting;
    private boolean m_noCheckpoint;
    private boolean m_noReadLock;
    private boolean m_recoveryInterrupted = false;
    private int m_checkpointLogIDInterval;
    private CheckpointThread m_checkpointThread;
    private SnapshotStorage m_snapshotStorage;
    private boolean m_transactionEndedDuringRecovery;
    private static final int STANDBY_STATE_REPLIACTING = 0;
    private static final int STANDBY_STATE_DEEPSYNC_PAGES = 1;
    private static final int STANDBY_STATE_DEEPSYNC_LOG = 2;
    ActiveStorageManager m_activeReplication = null;
    long m_maxReplicationLog = 0L;
    private boolean m_standby;
    private CheckpointNote m_standbyLastCheckpointNoteSeen;
    private int m_standbyState;
    private RandomAccessFile m_standbyDeepsyncDataFile;
    private Replicator m_replicator;
    private AsyncDeleteManager m_asyncDeleteManager;
    private boolean m_tempStorageAccess;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getMetrics(Properties props, String dbName) {
        try {
            this.m_accessSemaphore.exclusiveLock();
            if (this.m_pageManager != null) {
                this.m_pageManager.getMetrics(props, dbName);
            }
            if (this.m_logger != null) {
                this.m_logger.getMetrics(props, dbName);
            }
            if (this.m_snapshotManager != null) {
                this.m_snapshotManager.getMetrics(props, dbName);
            }
        }
        finally {
            this.m_accessSemaphore.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IObjectInfo get(Long transactionOrSnapshotID, long dbkey, byte[] buffer, int offset) throws IOException {
        try {
            Object action;
            this.m_accessSemaphore.sharedLock();
            if (this.m_snapshotManager.isSnapshot(transactionOrSnapshotID) && (action = this.m_snapshotManager.getAction(transactionOrSnapshotID, new Long(dbkey), false)) != null) {
                IObjectInfo iObjectInfo = action.getObject(buffer, offset);
                return iObjectInfo;
            }
            action = this.doGet(dbkey, buffer, offset);
            return action;
        }
        catch (ThreadDeath td) {
            this.handleThreadDeath(td);
            IObjectInfo iObjectInfo = null;
            return iObjectInfo;
        }
        finally {
            this.m_accessSemaphore.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IObjectInfo get(Long transactionOrSnapshotID, long dbkey) throws IOException {
        try {
            Object action;
            this.m_accessSemaphore.sharedLock();
            if (this.m_snapshotManager.isSnapshot(transactionOrSnapshotID) && (action = this.m_snapshotManager.getAction(transactionOrSnapshotID, new Long(dbkey), true)) != null) {
                IObjectInfo iObjectInfo = action.getObjectInfo();
                return iObjectInfo;
            }
            action = this.getInfo(dbkey);
            return action;
        }
        catch (ThreadDeath td) {
            this.handleThreadDeath(td);
            IObjectInfo iObjectInfo = null;
            return iObjectInfo;
        }
        finally {
            this.m_accessSemaphore.releaseLock();
        }
    }

    private IObjectInfo getInfo(long dbkey) throws IOException {
        DataPage page = (DataPage)this.m_pageManager.getForRead(Dbkey.getPageNumber(dbkey));
        if (page == null) {
            return null;
        }
        ObjectsBuffer objectsBuffer = (ObjectsBuffer)page.getContentBuffer();
        ObjectFragment fragment = objectsBuffer.getObjectFragment(Dbkey.getSlot(dbkey));
        if (fragment == null) {
            return null;
        }
        if (!fragment.isLeadFragment()) {
            return null;
        }
        return new ObjectInfo(fragment.getClassType(), (int)fragment.getObjectLength());
    }

    private IObjectInfo doGet(long dbkey, byte[] buffer, int offset) throws IOException {
        long currentDbkey = dbkey;
        long nextDbkey = 0L;
        boolean last = false;
        boolean leadFragment = true;
        ObjectInfo objectInfo = null;
        int currentDestination = offset;
        while (!last) {
            DataPage page = (DataPage)this.m_pageManager.getForRead(Dbkey.getPageNumber(currentDbkey));
            if (page == null) {
                return null;
            }
            ObjectsBuffer objectsBuffer = (ObjectsBuffer)page.getContentBuffer();
            ObjectFragment fragment = objectsBuffer.getObjectFragment(Dbkey.getSlot(currentDbkey));
            if (fragment == null) {
                if (leadFragment) {
                    return null;
                }
                throw new Error("Fragment is missing");
            }
            if (leadFragment) {
                if (!fragment.isLeadFragment()) {
                    return null;
                }
                objectInfo = new ObjectInfo(fragment.getClassType(), (int)fragment.getObjectLength());
                if (objectInfo.getSize() > buffer.length - offset) {
                    throw new IOException("The size of object " + dbkey + " exceeds the size of the buffer.");
                }
            }
            if (!fragment.isLastFragment()) {
                nextDbkey = fragment.getNextFragmentDbkey();
            } else {
                last = true;
            }
            fragment.getData(buffer, currentDestination);
            if (last) continue;
            currentDestination += fragment.getFragmentLength();
            currentDbkey = nextDbkey;
            leadFragment = false;
        }
        return objectInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] getList(byte pageType) throws IOException {
        try {
            this.m_accessSemaphore.exclusiveLock();
            this.checkInCritical();
            this.m_inCritical = (short)(this.m_inCritical + 1);
            ArrayList<Long> dbkeyList = new ArrayList<Long>();
            long[] pageList = this.m_pageManager.getList(Page.mapPageType(pageType));
            for (int i = 0; i < pageList.length; ++i) {
                DataPage page = (DataPage)this.m_pageManager.getForRead(pageList[i]);
                byte[] leadSlots = ((ObjectsBuffer)page.getContentBuffer()).getUsedSlots(true);
                for (int j = 0; j < leadSlots.length; ++j) {
                    dbkeyList.add(new Long(Dbkey.createDbkey(page.getPageNum(), leadSlots[j])));
                }
            }
            long[] retList = new long[dbkeyList.size()];
            for (int i = 0; i < retList.length; ++i) {
                retList[i] = (Long)dbkeyList.get(i);
            }
            long[] lArray = retList;
            return lArray;
        }
        catch (ThreadDeath td) {
            this.handleThreadDeath(td);
            long[] lArray = null;
            return lArray;
        }
        finally {
            this.m_inCritical = (short)(this.m_inCritical - 1);
            this.m_accessSemaphore.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] getList() throws IOException {
        try {
            int i;
            this.m_accessSemaphore.exclusiveLock();
            long[] indexDbkeys = this.getList((byte)100);
            long[] imutableDbkeys = this.getList((byte)101);
            long[] headerDbkeys = this.getList((byte)102);
            long[] retVal = new long[indexDbkeys.length + imutableDbkeys.length + headerDbkeys.length];
            int indx = 0;
            for (i = 0; i < indexDbkeys.length; ++i) {
                retVal[indx++] = indexDbkeys[i];
            }
            for (i = 0; i < imutableDbkeys.length; ++i) {
                retVal[indx++] = imutableDbkeys[i];
            }
            for (i = 0; i < headerDbkeys.length; ++i) {
                retVal[indx++] = headerDbkeys[i];
            }
            long[] lArray = retVal;
            return lArray;
        }
        finally {
            this.m_accessSemaphore.releaseLock();
        }
    }

    @Override
    public void commit(Long transID) throws IOException {
        if (this.m_transactionManager.isReadonly(transID)) {
            this.m_transactionManager.transactionEnd(transID);
        } else {
            this.endTransaction(transID, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void endTransaction(Long transactionID, boolean commit) throws IOException {
        if (this.m_logger.inRecovery()) {
            this.m_transactionEndedDuringRecovery = true;
        }
        long afterTransactionEnd = 0L;
        try {
            this.m_accessSemaphore.exclusiveLock();
            this.checkInCritical();
            this.m_inCritical = (short)(this.m_inCritical + 1);
            if (commit) {
                this.m_snapshotManager.transactionCommitted(transactionID);
                this.m_btreeManager.transactionCommitted(transactionID);
            } else {
                this.m_snapshotManager.transactionRolledback(transactionID);
                this.m_btreeManager.transactionRolledback(transactionID);
            }
            this.m_transactionManager.transactionEnd(transactionID);
            this.m_logger.endTransaction(transactionID, commit);
            if (this.m_asyncDeleteManager != null) {
                this.m_asyncDeleteManager.transEnd(transactionID, commit);
            }
            afterTransactionEnd = this.getIDAfterLastTransEnd();
        }
        catch (ThreadDeath td) {
            this.handleThreadDeath(td);
        }
        finally {
            this.m_inCritical = (short)(this.m_inCritical - 1);
            this.m_accessSemaphore.releaseLock();
        }
        try {
            this.m_logger.forceToDisk(commit, true);
        }
        catch (ThreadDeath td) {
            this.handleThreadDeath(td);
        }
        try {
            this.m_accessSemaphore.exclusiveLock();
            this.checkInCritical();
            this.m_inCritical = (short)(this.m_inCritical + 1);
            this.releaseUnusedNotes();
        }
        catch (ThreadDeath td) {
            this.handleThreadDeath(td);
        }
        finally {
            this.m_inCritical = (short)(this.m_inCritical - 1);
            this.m_accessSemaphore.releaseLock();
        }
        if (this.m_activeReplication != null && !this.m_logger.inRecovery()) {
            this.m_activeReplication.waitForLogReplication(afterTransactionEnd);
        }
    }

    private void synchronousCheckpoint() throws IOException {
        if (this.m_noCheckpoint) {
            return;
        }
        this.m_pageManager.forceToDisk();
        this.m_lastCheckpointID = this.m_logger.synchronousCheckpoint(this.m_transactionManager, this.m_asyncDeleteManager);
        this.m_oldestTransactionNoteIDAtLastCheckpoint = this.m_transactionManager.getOldsetLogTransactionID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkpointStart() throws IOException {
        boolean syncDeletionStopped = false;
        try {
            if (this.m_asyncDeleteManager != null) {
                syncDeletionStopped = this.m_asyncDeleteManager.stopAsyncDeletion(false);
            }
            this.m_accessSemaphore.exclusiveLock();
            this.checkInCritical();
            this.m_inCritical = (short)(this.m_inCritical + 1);
            this.m_lastCheckpointIDTentative = this.m_logger.checkpointStart(this.m_transactionManager, this.m_asyncDeleteManager);
            this.m_pageManager.forceToDiskPhase1();
            this.m_oldestTransactionNoteIDAtLastCheckpointTentative = this.m_transactionManager.getOldsetLogTransactionID();
        }
        catch (ThreadDeath td) {
            this.handleThreadDeath(td);
        }
        finally {
            if (syncDeletionStopped && this.m_asyncDeleteManager != null && !this.m_tempStorageAccess) {
                this.m_asyncDeleteManager.startAsyncDeletion();
            }
            this.m_inCritical = (short)(this.m_inCritical - 1);
            this.m_accessSemaphore.releaseLock();
        }
    }

    private void checkpointWaitForPagesToBeForced() throws IOException {
        this.m_pageManager.forceToDiskPhase2();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkpointDone() throws IOException {
        try {
            this.m_accessSemaphore.exclusiveLock();
            this.checkInCritical();
            this.m_inCritical = (short)(this.m_inCritical + 1);
            this.m_logger.checkpointDone();
            this.m_lastCheckpointID = this.m_lastCheckpointIDTentative;
            this.m_oldestTransactionNoteIDAtLastCheckpoint = this.m_oldestTransactionNoteIDAtLastCheckpointTentative;
        }
        catch (ThreadDeath td) {
            this.handleThreadDeath(td);
        }
        finally {
            this.m_inCritical = (short)(this.m_inCritical - 1);
            this.m_accessSemaphore.releaseLock();
        }
    }

    void conditionalCheckpoint(long recentNoteID) throws IOException {
        if (this.m_checkpointThread != null && recentNoteID - this.m_lastCheckpointIDTentative > (long)this.m_checkpointLogIDInterval) {
            this.m_checkpointThread.requestCheckpoint();
        }
        if (this.m_checkpointThread == null && recentNoteID - this.m_lastCheckpointID > (long)this.m_checkpointLogIDInterval) {
            this.synchronousCheckpoint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long begin() throws IOException {
        try {
            this.m_accessSemaphore.exclusiveLock();
            this.checkInCritical();
            this.m_inCritical = (short)(this.m_inCritical + 1);
            Long trNum = this.m_transactionManager.transactionBegin();
            long noteID = this.m_logger.startTransaction(trNum);
            this.m_transactionManager.setLogTransactionStartID(trNum, noteID);
            this.conditionalCheckpoint(noteID);
            Long l = trNum;
            return l;
        }
        catch (ThreadDeath td) {
            this.handleThreadDeath(td);
            Long l = null;
            return l;
        }
        finally {
            this.m_inCritical = (short)(this.m_inCritical - 1);
            this.m_accessSemaphore.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long beginReadonly() throws IOException {
        try {
            this.m_accessSemaphore.exclusiveLock();
            this.checkInCritical();
            this.m_inCritical = (short)(this.m_inCritical + 1);
            Long l = this.m_transactionManager.readonlyTransactionBegin();
            return l;
        }
        catch (ThreadDeath td) {
            this.handleThreadDeath(td);
            Long l = null;
            return l;
        }
        finally {
            this.m_inCritical = (short)(this.m_inCritical - 1);
            this.m_accessSemaphore.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long createSnapshot() throws IOException {
        try {
            this.m_accessSemaphore.exclusiveLock();
            this.checkInCritical();
            this.m_inCritical = (short)(this.m_inCritical + 1);
            Long id = new Long(this.m_transactionManager.getNextSnapshotID());
            this.m_snapshotManager.createSnapshot(id);
            this.m_btreeManager.createSnapshot(id);
            Long l = id;
            return l;
        }
        catch (ThreadDeath td) {
            this.handleThreadDeath(td);
            Long l = null;
            return l;
        }
        finally {
            this.m_inCritical = (short)(this.m_inCritical - 1);
            this.m_accessSemaphore.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteSnapshot(Long snapshotID) throws IOException {
        try {
            this.m_accessSemaphore.exclusiveLock();
            this.checkInCritical();
            this.m_inCritical = (short)(this.m_inCritical + 1);
            this.m_snapshotManager.deleteSnapshot(snapshotID);
            this.m_btreeManager.deleteSnapshot(snapshotID);
            this.releaseUnusedNotes();
        }
        catch (ThreadDeath td) {
            this.handleThreadDeath(td);
        }
        finally {
            this.m_inCritical = (short)(this.m_inCritical - 1);
            this.m_accessSemaphore.releaseLock();
        }
    }

    private void rollforwardRecover(Long backupCheckpointNoteID, Long lastBackupNoteID) throws IOException {
        Logger.RollforwardInfo info = null;
        info = backupCheckpointNoteID == null ? this.m_logger.rollforwardPrepare() : this.m_logger.backupRollforwardPrepare(backupCheckpointNoteID, lastBackupNoteID);
        if (this.m_snapshotStorage != null && !this.m_standby) {
            this.m_asyncDeleteManager = info.m_cpNote != null && info.m_cpNote instanceof CheckpointV2Note ? ((CheckpointV2Note)info.m_cpNote).getDeleteManager() : new AsyncDeleteManager();
            this.m_asyncDeleteManager.startAlreadyDeletedCollection();
        } else {
            this.m_asyncDeleteManager = null;
        }
        if (info.m_cpNote == null) {
            this.m_transactionManager = new TransactionManager();
            this.m_pageManager.setTransactionManager(this.m_transactionManager);
            this.m_btreeManager.setTransactionManager(this.m_transactionManager);
            if (this.m_standby) {
                return;
            }
        } else {
            this.m_transactionManager = info.m_cpNote.getTransactionManager();
            this.m_pageManager.setTransactionManager(this.m_transactionManager);
            this.m_btreeManager.setTransactionManager(this.m_transactionManager);
            this.m_logger.rollforward(this.m_transactionManager, this.m_btreeManager, this.m_asyncDeleteManager, info.m_lastWrittenNoteID, !this.m_standby);
            if (this.m_standby) {
                this.m_oldestTransactionNoteIDAtLastCheckpoint = this.m_transactionManager.getOldsetLogTransactionID();
                this.m_lastCheckpointID = info.m_cpNote.getNoteID();
                return;
            }
            this.synchronousCheckpoint();
            this.m_logger.logicalRollback(this, this.m_transactionManager);
        }
        if (this.m_asyncDeleteManager != null) {
            this.m_asyncDeleteManager.endAlreadyDeletedCollection();
        }
        this.synchronousCheckpoint();
    }

    @Override
    public void rollback(Long transactionID) throws IOException {
        this.logicalRollback(transactionID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logicalRollback(Long transactionID) throws IOException {
        LogReader rollbackReader;
        block6: {
            rollbackReader = null;
            try {
                this.m_accessSemaphore.exclusiveLock();
                boolean readonly = this.m_transactionManager.isReadonly(transactionID);
                if (!readonly) {
                    rollbackReader = this.m_logger.getRollbackReader();
                    break block6;
                }
                this.m_transactionManager.transactionEnd(transactionID);
                return;
            }
            catch (ThreadDeath td) {
                this.handleThreadDeath(td);
            }
            finally {
                this.m_accessSemaphore.releaseLock();
            }
        }
        new LogicalRollback(this, this.m_logger, rollbackReader, transactionID).rollback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() throws IOException {
        boolean locked = false;
        try {
            this.close();
            this.m_accessSemaphore.exclusiveLock();
            locked = true;
            Storage.destroy(this.m_dbDir);
        }
        finally {
            if (locked) {
                this.m_accessSemaphore.releaseLock();
            }
        }
    }

    private static void destroy(File dbDir) {
        if (!dbDir.exists()) {
            return;
        }
        File[] fileList = dbDir.listFiles();
        for (int i = 0; i < fileList.length; ++i) {
            fileList[i].delete();
        }
        dbDir.delete();
    }

    @Override
    public void close() throws IOException {
        this.close(!this.m_standby);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(boolean doCheckpoint) throws IOException {
        boolean locked = false;
        try {
            if (this.m_asyncDeleteManager != null) {
                this.m_asyncDeleteManager.stopAsyncDeletion(true);
            }
            if (this.m_checkpointThread != null) {
                this.m_checkpointThread.terminate();
            }
            this.m_accessSemaphore.exclusiveLock();
            locked = true;
            this.m_inCritical = (short)(this.m_inCritical + 1);
            if (this.m_pageManager == null) {
                return;
            }
            if (doCheckpoint) {
                this.synchronousCheckpoint();
                this.releaseUnusedNotes();
            }
            this.m_pageManager.close();
            this.m_pageManager = null;
            if (this.m_btreeManager != null) {
                this.m_btreeManager.close();
                this.m_btreeManager = null;
            }
            if (this.m_snapshotStorage != null) {
                this.m_snapshotStorage.close();
                this.m_snapshotStorage = null;
            }
            this.m_logger.close();
            this.doUnlock();
        }
        catch (ThreadDeath td) {
            this.handleThreadDeath(td);
        }
        finally {
            if (locked) {
                this.m_inCritical = (short)(this.m_inCritical - 1);
                this.m_accessSemaphore.releaseLock();
            }
        }
    }

    @Override
    public long getStorageSize() throws IOException {
        return this.m_pageManager.getFileSize() + this.m_logger.getLogLength();
    }

    @Override
    public boolean isOpen() {
        return this.m_pageManager != null;
    }

    @Override
    public void open(String storageFileName, HashMap parameters, boolean forStandby, boolean requiresDeepSync, long peerTimeStamp) throws IOException {
        if (requiresDeepSync) {
            this.prepareForDeepSync(storageFileName);
        }
        this.open(storageFileName, requiresDeepSync, parameters, forStandby);
    }

    private void prepareForDeepSync(String storageFileName) {
        File dbDir = new File(storageFileName);
        if (dbDir.exists()) {
            File obsoleteDir = new File(dbDir.getParentFile(), "obsolete_" + dbDir.getName());
            long obsoleteAge = 0L;
            if (obsoleteDir.exists()) {
                obsoleteAge = System.currentTimeMillis() - obsoleteDir.lastModified();
            }
            if (!obsoleteDir.exists() || obsoleteAge > 3600000L) {
                Storage.destroy(obsoleteDir);
                try {
                    Replicator.replicateOffLine(dbDir, obsoleteDir);
                    this.setPersistentReplicationState(obsoleteDir.getAbsolutePath(), (short)4);
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            Storage.destroy(dbDir);
        }
    }

    @Override
    public void open(String dbName, boolean create, HashMap parameters) throws IOException {
        this.open(dbName, create, parameters, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void open(String dbName, boolean create, HashMap parameters, boolean forStandby) throws IOException {
        Boolean asyncPageWritingParam;
        this.m_dbDir = new File(dbName);
        this.m_dbName = dbName;
        this.m_parameters = parameters;
        this.m_standby = forStandby;
        this.m_transactionEndedDuringRecovery = false;
        Boolean tmp = (Boolean)this.m_parameters.get("_TEMPORARY_CONNECTION");
        boolean bl = this.m_tempStorageAccess = tmp != null && tmp != false;
        if (this.m_standby) {
            this.m_standbyLastCheckpointNoteSeen = null;
            this.setStandbyState(create ? 1 : 0);
        }
        if (this.m_standbyState == 1) {
            this.m_dbDir.mkdir();
            this.setPersistentReplicationState(dbName, (short)517);
            return;
        }
        boolean openBackupCopyForReconciliation = parameters.get(SONIC_BACKUP_CHECKPOINT_PARAMETER) != null;
        Boolean noCheckpoint = (Boolean)parameters.get(NO_CHECKPOINT_PARAMETER);
        this.m_noCheckpoint = noCheckpoint != null ? noCheckpoint : false;
        Boolean noReadLock = (Boolean)parameters.get(NO_READ_LOCK_PARAMETER);
        this.m_noReadLock = noReadLock != null ? noReadLock : false;
        try {
            block40: {
                Integer fullPageThreshold;
                boolean isSnapshotStorage;
                this.m_accessSemaphore = new AccessSemaphore();
                this.m_accessSemaphore.exclusiveLock();
                this.m_allocateLogicalNote = new AllocateLogicalNote();
                this.m_updateLogicalNote = new UpdateLogicalNote();
                this.m_deleteLogicalNote = new DeleteLogicalNote();
                this.m_deleteByAsyncThreadLogicalNote = new DeleteByAsyncThreadLogicalNote();
                this.m_asyncDeleteNote = new AsyncDeleteNote();
                this.m_lastCheckpointID = 0L;
                this.m_oldestTransactionNoteIDAtLastCheckpoint = null;
                this.m_logger = new Logger(this.m_accessSemaphore);
                if (create) {
                    if (this.m_dbDir.exists()) {
                        throw new StorageFileDoesNotExistException(dbName + " already exists.");
                    }
                    this.m_dbDir.mkdir();
                    this.setPersistentReplicationState(dbName, (short)2);
                } else {
                    if (!this.m_dbDir.exists()) {
                        throw new StorageFileDoesNotExistException(dbName + " does not exist.");
                    }
                    if (!this.m_dbDir.isDirectory()) {
                        throw new StorageFormatException(dbName + " is not a valid database.");
                    }
                    if (this.m_activeReplication == null && !this.m_standby) {
                        if (this.getPersistentReplicationState(dbName) == 517) {
                            throw new StorageFormatException(dbName + " cannot be opened stand-alone - it's in a state of deep synchronization");
                        }
                        this.setPersistentReplicationState(dbName, (short)2);
                    }
                }
                this.doLock();
                Boolean tmpSnap = (Boolean)parameters.get(SNAPSHOT_STORAGE_PARAMETER);
                boolean bl2 = isSnapshotStorage = tmpSnap != null && tmpSnap != false;
                if (!isSnapshotStorage && !this.m_standby) {
                    this.m_snapshotStorage = new SnapshotStorage();
                    this.m_snapshotStorage.open(this.m_dbDir);
                }
                if (Replicator.isBackupInProgress(this.m_dbDir) && !openBackupCopyForReconciliation) {
                    throw new IOException(dbName + " is not ready as a backup copy; it must be discarded.");
                }
                this.m_lockManager = new LockManager(dbName, parameters);
                Integer checkpointLogIDInterval = (Integer)parameters.get(CHECKPOINT_LOGID_INTERVAL_PARAMETER);
                this.m_checkpointLogIDInterval = checkpointLogIDInterval != null ? checkpointLogIDInterval : 10000000;
                if (this.m_checkpointLogIDInterval < 1000000) {
                    this.m_checkpointLogIDInterval = 1000000;
                }
                this.m_pageManager = new PageManager((fullPageThreshold = (Integer)parameters.get(FULL_PAGE_THRESHOLD_PARAMETER)) != null ? fullPageThreshold : FULL_PAGE_THRESHOLD_DEFAULT);
                try {
                    this.m_logger.open(this.m_dbDir, this.m_pageManager, parameters);
                    this.m_pageManager.open(this.m_dbDir, this.m_logger, parameters, create);
                    this.m_snapshotManager = new SnapshotManager(this.m_logger);
                }
                catch (IOException e) {
                    this.doUnlock();
                    throw e;
                }
                this.validateFileVersions(dbName, create);
                int btreeLockLevel = 0;
                Integer tmpLvl = (Integer)parameters.get(BTREE_LOCKING_LEVEL_PARAMETER);
                if (tmpLvl != null) {
                    btreeLockLevel = tmpLvl;
                }
                if (isSnapshotStorage) {
                    btreeLockLevel = 0;
                }
                this.m_btreeManager = new BTreeManager(this, this.m_pageManager, this.m_logger, this.m_snapshotStorage, this.m_accessSemaphore, dbName, btreeLockLevel);
                if (!this.m_recoveryInterrupted) break block40;
                if (!this.m_standby) {
                    this.m_logger.setInRecovery(false);
                }
                return;
            }
            try {
                this.m_logger.setInRecovery(true);
                this.rollforwardRecover((Long)parameters.get(SONIC_BACKUP_CHECKPOINT_PARAMETER), (Long)parameters.get(SONIC_BACKUP_LASTNOTE_PARAMETER));
                if (this.m_standby) {
                    this.releaseUnusedNotes();
                    if (!this.m_standby) {
                        this.m_logger.setInRecovery(false);
                    }
                    return;
                }
                if (!this.m_standby) {
                    this.m_logger.setInRecovery(false);
                }
            }
            catch (RecoveryInterruptException e) {
                if (!this.m_standby) {
                    this.m_logger.setInRecovery(false);
                }
                return;
                catch (Throwable throwable) {
                    if (!this.m_standby) {
                        this.m_logger.setInRecovery(false);
                    }
                    throw throwable;
                }
            }
            this.releaseUnusedNotes();
        }
        catch (Throwable t) {
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            t.printStackTrace();
            throw new IOException(t.toString());
        }
        finally {
            this.m_accessSemaphore.releaseLock();
        }
        this.m_pageManager.forceToDisk();
        Integer logCacheMaxSizeObj = (Integer)parameters.get(LOG_CACHE_MAX_SIZE_PARAMETER);
        this.m_logger.activateCache(logCacheMaxSizeObj == null ? 1000 : logCacheMaxSizeObj);
        Integer asyncWriterFrequency = (Integer)parameters.get(ASYNCHRONOUS_PAGE_WRITE_FREQUENCY_PARAMETER);
        if (asyncWriterFrequency == null) {
            asyncWriterFrequency = ASYNCHRONOUS_PAGE_WRITE_FREQUENCY_DEFAULT;
        }
        this.m_asyncPageWriting = (asyncPageWritingParam = (Boolean)parameters.get(ASYNC_PAGE_WRITING_PARAMETER)) == null || asyncPageWritingParam != false;
        this.m_pageManager.startAsyncMode(this.m_asyncPageWriting ? asyncWriterFrequency : null);
        if (this.m_asyncPageWriting) {
            this.m_checkpointThread = new CheckpointThread();
        }
        if (this.m_asyncDeleteManager != null) {
            this.m_asyncDeleteManager.setStorage(this);
            if (!this.m_tempStorageAccess && this.m_asyncPageWriting) {
                this.m_asyncDeleteManager.startAsyncDeletion();
            }
        }
    }

    MasterPage validateFileVersions(String dbName, boolean create) throws IOException {
        MasterPage master = (MasterPage)this.m_pageManager.getForWrite(0L);
        if (master == null) {
            this.close(false);
            throw new StorageFormatException(dbName + " does not have a master page.");
        }
        if (master.getVersion() == 14) {
            master.setVersion(15);
        } else if (master.getVersion() != 15) {
            this.close(false);
            throw new StorageFormatException("The storage version of database \"" + this.m_dbDir.getPath() + "\" is " + master.getVersion() + " - mismatches the software version - " + 15);
        }
        long newTimestamp = System.currentTimeMillis();
        master.setSessionTimestamp(newTimestamp);
        this.m_pageManager.forceToDisk();
        return master;
    }

    private void doLock() throws IOException {
        this.m_lockFile = new File(this.m_dbDir, LOCK_FILE_NAME);
        RandomAccessFile raf = new RandomAccessFile(this.m_lockFile, "rw");
        FileChannel fc = raf.getChannel();
        this.m_fileLock = fc.tryLock();
        if (this.m_fileLock == null) {
            throw new IOException(this.m_dbDir.getPath() + " is locked by another process");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUnlock() {
        if (this.m_fileLock == null) {
            return;
        }
        try {
            this.m_fileLock.release();
            FileChannel fc = this.m_fileLock.channel();
            if (fc != null) {
                fc.close();
            }
            this.m_fileLock = null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (this.m_lockFile != null) {
                this.m_lockFile.delete();
            }
        }
    }

    private static String getMismatchErrorString(String dataFileName, String dbDirName, long dataTimestamp, long logTimestamp) {
        return "The timestamp [" + logTimestamp + "] of the log files in \"" + dbDirName + "\" mismatches the timestamp [" + dataTimestamp + "] in data file \"" + dataFileName + "\"";
    }

    void validateWriteTransaction(Long transID) throws IOException {
        if (!this.m_transactionManager.writeTransaction(transID)) {
            throw new IOException("Transaction " + transID + " is not active.");
        }
    }

    @Override
    public long allocate(Long transID, int classType, byte pageType, int size) throws IOException {
        return this.allocate(transID, classType, Page.mapPageType(pageType), size, 0L, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long allocate(Long transID, int classType, byte pageType, int size, long useThisDbkey, boolean undoDeletionByAsyncThread) throws IOException {
        try {
            this.m_accessSemaphore.exclusiveLock();
            this.checkInCritical();
            this.m_inCritical = (short)(this.m_inCritical + 1);
            this.validateWriteTransaction(transID);
            if (useThisDbkey != 0L) {
                this.m_transactionManager.pageUnreserveDBK(useThisDbkey);
            }
            this.m_allocateLogicalNote.initNote(transID, true, useThisDbkey);
            this.m_logger.writeNote(this.m_allocateLogicalNote);
            long dbkey = this.doAllocate(transID, classType, pageType, size, null, 0, useThisDbkey);
            this.m_allocateLogicalNote.initNote(transID, false);
            long noteID = this.m_logger.writeNote(this.m_allocateLogicalNote);
            this.m_snapshotManager.objectCreated(transID, new Long(dbkey));
            if (this.m_asyncDeleteManager != null && undoDeletionByAsyncThread) {
                this.m_asyncDeleteManager.undoAlreadyDeleted(new Long(useThisDbkey));
            }
            this.conditionalCheckpoint(noteID);
            long l = dbkey;
            return l;
        }
        catch (ThreadDeath td) {
            this.handleThreadDeath(td);
            long l = 0L;
            return l;
        }
        finally {
            this.m_inCritical = (short)(this.m_inCritical - 1);
            this.m_accessSemaphore.releaseLock();
        }
    }

    private long doAllocate(Long transID, int classType, byte pageType, int size, byte[] src, int srcOffset, long useThisDbkey) throws IOException {
        int spaceNeeded = size;
        long prevPageNum = -1L;
        byte previousSlot = 0;
        long leadDbkey = 0L;
        int dataOffset = srcOffset;
        boolean leadFragment = true;
        boolean done = false;
        while (!done) {
            DataPage page = null;
            boolean useThisSlot = false;
            byte thisSlot = 0;
            if (leadFragment && useThisDbkey != 0L) {
                page = (DataPage)this.m_pageManager.getForWrite(Dbkey.getPageNumber(useThisDbkey));
                useThisSlot = true;
                thisSlot = Dbkey.getSlot(useThisDbkey);
            } else {
                DataPage.AvailablePage availablePage = this.m_pageManager.getAvailablePage(pageType, spaceNeeded, transID);
                page = availablePage.m_page;
                if (availablePage.m_availableSlot != -1) {
                    useThisSlot = true;
                    thisSlot = availablePage.m_availableSlot;
                }
            }
            long pNum = page.getPageNum();
            ObjectsBuffer objectsBuffer = (ObjectsBuffer)page.getContentBuffer();
            short freeSpace = objectsBuffer.getFreeSpace(this.m_transactionManager.reservedSlots(pNum));
            boolean lastFragment = freeSpace >= spaceNeeded;
            short allocationSize = (short)Constants.MIN(spaceNeeded, freeSpace);
            byte slot = objectsBuffer.allocate(allocationSize, classType, leadFragment, lastFragment, useThisSlot, thisSlot, size);
            if (src != null) {
                objectsBuffer.updateData(slot, src, dataOffset);
            }
            long dbkey = Dbkey.createDbkey(pNum, slot);
            if (leadFragment) {
                leadDbkey = dbkey;
            }
            this.m_pageManager.doneUpdate(page, pageType, transID);
            if (prevPageNum != -1L) {
                DataPage prevPage = (DataPage)this.m_pageManager.getForWrite(prevPageNum);
                ((ObjectsBuffer)prevPage.getContentBuffer()).setNextFragmentDbkey(previousSlot, dbkey, true);
                this.m_pageManager.doneUpdate(prevPage, pageType, transID);
            }
            if ((spaceNeeded -= allocationSize) <= 0) {
                done = true;
            }
            dataOffset += allocationSize;
            prevPageNum = pNum;
            previousSlot = slot;
            leadFragment = false;
        }
        return leadDbkey;
    }

    private boolean doUpdate(Long transID, long dbkey, byte[] src, int offset) throws IOException {
        long currentDbkey = dbkey;
        long nextDbkey = 0L;
        boolean last = false;
        boolean leadFragment = true;
        int currentOffset = offset;
        while (!last) {
            DataPage page = (DataPage)this.m_pageManager.getForWrite(Dbkey.getPageNumber(currentDbkey));
            if (page == null) {
                throw new Error("Page " + Dbkey.getPageNumber(currentDbkey) + " is missing. ");
            }
            ObjectsBuffer objectsBuffer = (ObjectsBuffer)page.getContentBuffer();
            ObjectFragment fragment = objectsBuffer.getObjectFragment(Dbkey.getSlot(currentDbkey));
            if (fragment == null) {
                throw new Error("Fragment " + Dbkey.getSlot(currentDbkey) + " is missing.");
            }
            if (!fragment.isLastFragment()) {
                nextDbkey = fragment.getNextFragmentDbkey();
            } else {
                last = true;
            }
            short fragmentLength = fragment.getFragmentLength();
            byte loggingType = fragment.notInitialized() ? (byte)1 : 2;
            objectsBuffer.replace(Dbkey.getSlot(currentDbkey), src, currentOffset, fragmentLength, loggingType);
            this.m_pageManager.doneUpdate(page, page.getPageType(), transID);
            if (last) continue;
            currentOffset += fragmentLength;
            currentDbkey = nextDbkey;
            leadFragment = false;
        }
        return true;
    }

    private long doDelete(Long transID, long dbkey, boolean fromDeleteObject) throws IOException {
        long currentDbkey = dbkey;
        long nextDbkey = 0L;
        boolean last = false;
        boolean leadFragment = true;
        long deletedObjectLength = 0L;
        while (!last) {
            DataPage page = (DataPage)this.m_pageManager.getForWrite(Dbkey.getPageNumber(currentDbkey));
            if (page == null) {
                throw new IOException(dbkey + " was not found");
            }
            ObjectsBuffer objectsBuffer = (ObjectsBuffer)page.getContentBuffer();
            ObjectFragment fragment = objectsBuffer.getObjectFragment(Dbkey.getSlot(currentDbkey));
            if (fragment == null || leadFragment && !fragment.isLeadFragment()) {
                this.m_pageManager.doneUpdate(page, page.getPageType(), transID);
                throw new IOException(dbkey + " was not found");
            }
            if (leadFragment) {
                deletedObjectLength = fragment.getObjectLength();
            }
            if (!fragment.isLastFragment()) {
                nextDbkey = fragment.getNextFragmentDbkey();
            } else {
                last = true;
            }
            objectsBuffer.delete(Dbkey.getSlot(currentDbkey));
            this.m_pageManager.doneUpdate(page, page.getPageType(), transID, fromDeleteObject);
            if (last) continue;
            currentDbkey = nextDbkey;
            leadFragment = false;
        }
        return deletedObjectLength;
    }

    @Override
    public long delete(Long transID, long dbkey) throws IOException {
        return this.delete(transID, dbkey, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long delete(Long transID, long dbkey, boolean asyncOK, boolean byAsynDeleter) throws IOException {
        try {
            long objSize;
            this.m_accessSemaphore.exclusiveLock();
            this.checkInCritical();
            this.m_inCritical = (short)(this.m_inCritical + 1);
            this.validateWriteTransaction(transID);
            if (this.m_asyncDeleteManager != null && asyncOK && (objSize = this.deleteAsync(transID, dbkey)) > -1L) {
                long l = objSize;
                return l;
            }
            this.m_transactionManager.reserveDBK(transID, dbkey);
            DeleteLogicalNote delNote = byAsynDeleter ? this.m_deleteByAsyncThreadLogicalNote : this.m_deleteLogicalNote;
            delNote.initNote(transID, true, dbkey);
            long noteID = this.m_logger.writeNote(delNote);
            this.m_snapshotManager.objectModified(transID, new Long(dbkey), new Long(noteID));
            long objectLength = this.doDelete(transID, dbkey, true);
            delNote.initNote(transID, false);
            noteID = this.m_logger.writeNote(delNote);
            this.conditionalCheckpoint(noteID);
            long l = objectLength;
            return l;
        }
        catch (ThreadDeath td) {
            this.handleThreadDeath(td);
            long l = 0L;
            return l;
        }
        finally {
            this.m_inCritical = (short)(this.m_inCritical - 1);
            this.m_accessSemaphore.releaseLock();
        }
    }

    private long deleteAsync(Long transID, long dbkey) throws IOException {
        IObjectInfo objInfo = this.getInfo(dbkey);
        if (objInfo.getSize() >= 100000) {
            this.m_asyncDeleteNote.initNote(transID, dbkey);
            long noteID = this.m_logger.writeNote(this.m_asyncDeleteNote);
            this.m_asyncDeleteManager.markDeleted(transID, dbkey);
            this.conditionalCheckpoint(noteID);
            return objInfo.getSize();
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Long transID, long dbkey, byte[] src, int offset, int length) throws IOException {
        try {
            this.m_accessSemaphore.exclusiveLock();
            this.m_updateLogicalNote.initNote(transID, true);
            long noteID = this.m_logger.writeNote(this.m_updateLogicalNote);
            this.m_snapshotManager.objectModified(transID, new Long(dbkey), new Long(noteID));
            this.doUpdate(transID, dbkey, src, offset, length);
            this.m_updateLogicalNote.initNote(transID, false);
            noteID = this.m_logger.writeNote(this.m_updateLogicalNote);
            this.conditionalCheckpoint(noteID);
        }
        finally {
            this.m_accessSemaphore.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdate(Long transID, long dbkey, byte[] src, int offset, int length) throws IOException {
        try {
            boolean newDataExactlyMatches;
            boolean blobPage;
            this.checkInCritical();
            this.m_inCritical = (short)(this.m_inCritical + 1);
            this.validateWriteTransaction(transID);
            long pageNum = Dbkey.getPageNumber(dbkey);
            DataPage page = (DataPage)this.m_pageManager.getForRead(pageNum);
            if (page == null) {
                throw new IOException(dbkey + " was not found ");
            }
            byte pageType = page.getPageType();
            ObjectsBuffer objectsBuffer = (ObjectsBuffer)page.getContentBuffer();
            byte slotNum = Dbkey.getSlot(dbkey);
            ObjectFragment fragment = objectsBuffer.getObjectFragment(slotNum);
            boolean notInitialized = fragment.notInitialized();
            boolean bl = blobPage = page.getPageType() == 1;
            if (fragment == null || !fragment.isLeadFragment()) {
                throw new IOException(dbkey + " was not found ");
            }
            ObjectInfo objectInfo = new ObjectInfo(fragment.getClassType(), (int)fragment.getObjectLength());
            boolean hasRoomForExpansion = objectsBuffer.getFreeSpace(this.m_transactionManager.reservedSlots(pageNum)) + fragment.getFragmentLength() >= length;
            boolean singleFragmentReplacement = fragment.isLastFragment() && hasRoomForExpansion;
            boolean bl2 = newDataExactlyMatches = (long)length == fragment.getObjectLength();
            if (!notInitialized && blobPage && !newDataExactlyMatches) {
                throw new Error("Cannot update objects in immutable pages");
            }
            if (singleFragmentReplacement) {
                page = (DataPage)this.m_pageManager.getForWrite(pageNum);
                objectsBuffer = (ObjectsBuffer)page.getContentBuffer();
                byte slot = Dbkey.getSlot(dbkey);
                objectsBuffer.replace(slot, src, offset, (short)length, !notInitialized || !newDataExactlyMatches ? (byte)2 : 1);
                this.m_pageManager.doneUpdate(page, page.getPageType(), transID);
            } else if (newDataExactlyMatches) {
                this.doUpdate(transID, dbkey, src, offset);
            } else {
                this.doDelete(transID, dbkey, false);
                this.doAllocate(transID, objectInfo.getClassType(), pageType, length, src, offset, dbkey);
            }
        }
        catch (ThreadDeath td) {
            this.handleThreadDeath(td);
        }
        finally {
            this.m_inCritical = (short)(this.m_inCritical - 1);
        }
    }

    private void checkInCritical() {
        if (this.m_threadDeath || this.m_inCritical > 0) {
            throw new Error("Tried to access database " + this.m_dbDir.getPath() + " during the shutdown sequence.");
        }
    }

    private void handleThreadDeath(ThreadDeath td) {
        this.m_threadDeath = true;
        throw td;
    }

    void pinDownNotes(long smallestNoteID) {
        if (this.m_smallestPinnedDownNoteID != null) {
            throw new Error("The logged is already pnned down.");
        }
        this.m_smallestPinnedDownNoteID = new Long(smallestNoteID);
    }

    void unPinDownNotes() {
        this.m_smallestPinnedDownNoteID = null;
    }

    long getLastCheckpointID() {
        return this.m_lastCheckpointID;
    }

    long getOldestNoteNeededAtLastCheckpoint() {
        long oldestNeedAtLastCheckpoint = this.m_lastCheckpointID;
        if (this.m_oldestTransactionNoteIDAtLastCheckpoint != null) {
            oldestNeedAtLastCheckpoint = this.m_oldestTransactionNoteIDAtLastCheckpoint;
        }
        return oldestNeedAtLastCheckpoint;
    }

    private void releaseUnusedNotes() throws IOException {
        long replicationReleaseNote;
        long oldestNeeded;
        long oldestNeedAtLastCheckpoint = this.getOldestNoteNeededAtLastCheckpoint();
        Long oldestNeededBySnapshots = this.m_snapshotManager.getSmallestPointer();
        long l = oldestNeeded = oldestNeededBySnapshots == null ? oldestNeedAtLastCheckpoint : Constants.MIN(oldestNeededBySnapshots, oldestNeedAtLastCheckpoint);
        if (this.m_smallestPinnedDownNoteID != null) {
            oldestNeeded = Constants.MIN(oldestNeeded, this.m_smallestPinnedDownNoteID);
        }
        if ((oldestNeeded = Constants.MIN(oldestNeeded, replicationReleaseNote = this.m_logger.getNextNoteID() - this.m_maxReplicationLog)) < 0L) {
            return;
        }
        this.m_logger.releaseNotes(oldestNeeded);
    }

    void tryLock(Long transactionOrSnapshotID, BTreeLockID lockID, int lockMode, boolean doNotHold, String pathInfo0) throws BTreeLockNeededException, IOException {
        if (this.m_noReadLock) {
            if (lockMode == 1) {
                return;
            }
        }
        int lockHeld = 0;
        try {
            lockHeld = this.m_lockManager.getLockMode(lockID, transactionOrSnapshotID);
            String pathInfo = pathInfo0 != null ? pathInfo0 : "unknown";
            this.m_lockManager.lock(lockID, lockMode, 0L, transactionOrSnapshotID, -1, pathInfo);
            if (doNotHold) {
                this.m_lockManager.unlock(lockID, transactionOrSnapshotID);
                if (lockHeld != 0) {
                    this.m_lockManager.lock(lockID, lockHeld, 0L, transactionOrSnapshotID, -1, pathInfo);
                }
            }
        }
        catch (com.sonicsw.lm.LockTimeoutException e) {
            throw new BTreeLockNeededException(lockMode, lockID, doNotHold, lockHeld);
        }
        catch (com.sonicsw.lm.LockWaitInterruptedException e) {
            throw new IOException(e.toString());
        }
        catch (com.sonicsw.lm.DeadlockException e) {
            throw new BTreeLockNeededException(lockMode, lockID, doNotHold, lockHeld);
        }
    }

    boolean isSnapshot(Long transactionOrSnapshotID) {
        return this.m_snapshotManager.isSnapshot(transactionOrSnapshotID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acquireLock(Object lockOwner, BTreeLockNeededException lockDetails, long timeoutMillis, String pathInfo0) throws LockTimeoutException, LockWaitInterruptedException, DeadlockException {
        block8: {
            try {
                String pathInfo = pathInfo0 != null ? pathInfo0 : "unknown";
                this.m_lockManager.lock(lockDetails.getLockID(), lockDetails.getLockType(), timeoutMillis, lockOwner, -1, pathInfo);
                if (!lockDetails.doNotHold()) break block8;
                if (lockDetails.lockHeld() == 0) {
                    this.m_lockManager.unlock(lockDetails.getLockID(), lockOwner);
                    break block8;
                }
                try {
                    this.m_accessSemaphore.sharedLock();
                    this.m_lockManager.unlock(lockDetails.getLockID(), lockOwner);
                    this.m_lockManager.lock(lockDetails.getLockID(), lockDetails.lockHeld(), 0L, lockOwner, -1, pathInfo);
                }
                finally {
                    this.m_accessSemaphore.releaseLock();
                }
            }
            catch (com.sonicsw.lm.LockTimeoutException ex) {
                throw new LockTimeoutException(ex.toString());
            }
            catch (com.sonicsw.lm.LockWaitInterruptedException ex1) {
                throw new LockWaitInterruptedException(ex1.toString());
            }
            catch (com.sonicsw.lm.DeadlockException ex2) {
                throw new DeadlockException(ex2.toString());
            }
        }
    }

    @Override
    public void acquireLock(Object lockOwner, long dbkey, int lockmode, long timeoutMillis, int objectType, String className) throws LockTimeoutException, LockWaitInterruptedException, DeadlockException {
        int mode = 0;
        if (lockmode == 1) {
            mode = 1;
        } else if (lockmode == 2) {
            mode = 2;
        } else {
            throw new Error("Invalid lockmode " + lockmode);
        }
        if (this.m_noReadLock) {
            if (mode == 1) {
                return;
            }
        }
        try {
            this.m_lockManager.lock(new Long(dbkey), mode, timeoutMillis, lockOwner, objectType, className);
        }
        catch (com.sonicsw.lm.LockTimeoutException ex) {
            throw new LockTimeoutException(ex.toString());
        }
        catch (com.sonicsw.lm.LockWaitInterruptedException ex1) {
            throw new LockWaitInterruptedException(ex1.toString());
        }
        catch (com.sonicsw.lm.DeadlockException ex2) {
            throw new DeadlockException(ex2.toString());
        }
    }

    @Override
    public void releaseAllLocks(Object lockOwner, boolean convertToCacheLocks) {
        this.m_lockManager.unlockAll(lockOwner, convertToCacheLocks);
    }

    @Override
    public void releaseLock(Object lockOwner, long dbkey) {
        this.m_lockManager.unlock(new Long(dbkey), lockOwner);
    }

    @Override
    public void backup(String backupDBPath) throws IOException {
        if (this.m_standby) {
            throw new IOException("Cannot perform backup of non active storage.");
        }
        new Replicator(backupDBPath, this, this.m_pageManager, this.m_logger).replicate();
    }

    @Override
    public IBTreeManager getBTreeManager() throws IOException {
        if (this.m_btreeManager == null) {
            throw new Error(this.m_dbDir.getPath() + " is closed");
        }
        return this.m_btreeManager;
    }

    @Override
    public void setActiveReplicationContext(ActiveStorageManager activeReplication, long maxReplicationLog) {
        this.m_maxReplicationLog = maxReplicationLog;
        this.m_activeReplication = activeReplication;
    }

    @Override
    public long getIDAfterLastTransEnd() {
        return this.m_logger.getIDAfterLastTransEnd();
    }

    @Override
    public ReplicationManager.ReplicationDataIndicator getLogDataForReplication(long startingID, long deepSyncLastNoteWrittenAfterPageReplication) throws InterruptedException, IOException {
        ReplicationManager.ReplicationDataIndicator indicator = this.m_logger.getReplicationData(startingID, false);
        if (indicator == null) {
            return null;
        }
        indicator.m_deepSyncLogData = indicator.m_dataID + (long)indicator.m_dataLength <= deepSyncLastNoteWrittenAfterPageReplication;
        indicator.m_deepSyncLastNoteWrittenAfterPageReplication = indicator.m_deepSyncLogData ? deepSyncLastNoteWrittenAfterPageReplication : -1L;
        return indicator;
    }

    @Override
    public void stopWaitingForData() {
        this.m_logger.stopWaitingForData();
    }

    @Override
    public void applyLogOrPage(ReplicationManager.ReplicationDataIndicator indicator, byte[] buffer, int dataOffset, int dataLength) throws IOException {
        if (!indicator.m_logData) {
            int numPages = BitUtil.getShort(buffer, dataOffset);
            int pagePointer = dataOffset + 2;
            if (indicator.m_dataID == 0L) {
                long newTimestamp;
                this.m_replicator = new Replicator(this.m_dbDir, indicator.m_deepSyncCheckpointID);
                long initialTimestamp = this.getCreationTimestamp(this.m_dbName, this.m_parameters);
                if (initialTimestamp != (newTimestamp = MasterPage.getDBTimestamp(buffer, pagePointer)) && this.m_dbName.indexOf("data.odb") > 0) {
                    String filename = this.m_dbName.substring(0, this.m_dbName.indexOf("data.odb") - 1);
                    if (initialTimestamp == 0L) {
                        LOGGER.log(Level.INFO, "Setting storage timestamp for " + filename + " to " + newTimestamp);
                    } else {
                        LOGGER.log(Level.SEVERE, "Resetting storage timestamp for " + filename + " from " + initialTimestamp + " to " + newTimestamp + ", trace follows...", new Exception());
                    }
                }
            }
            for (int i = 0; i < numPages; ++i) {
                this.m_replicator.writePage(buffer, pagePointer, Page.PAGE_LENGTH);
                pagePointer += Page.PAGE_LENGTH;
            }
            return;
        }
        if (this.m_standbyState == 1) {
            this.setStandbyState(2);
            this.m_replicator.endDataReplication(indicator.m_deepSyncLastNoteWrittenAfterPageReplication);
        }
        if (this.m_standbyState == 2) {
            this.m_replicator.replicateLog(indicator.m_dataID, buffer, dataOffset, dataLength, indicator.m_firstPageEndNotePointer);
            if (indicator.m_deepSyncLogData) {
                return;
            }
        }
        if (!indicator.m_deepSyncLogData && this.m_standbyState == 2) {
            this.setStandbyState(0);
            this.m_replicator.endLogReplication();
            HashMap afterDeepSyncParam = (HashMap)this.m_parameters.clone();
            afterDeepSyncParam.put(SONIC_BACKUP_CHECKPOINT_PARAMETER, new Long(this.m_replicator.getDeepSyncCheckpointID()));
            afterDeepSyncParam.put(SONIC_BACKUP_LASTNOTE_PARAMETER, new Long(this.m_replicator.getDeepSyncLastNoteWrittenAfterPageReplication()));
            this.open(this.m_dbName, false, afterDeepSyncParam, true);
            return;
        }
        int noteOffset = -1;
        int newDataLength = Logger.removePageHeaders(buffer, dataOffset, indicator.m_dataID, dataLength);
        while (true) {
            long[] lastNoteID = new long[1];
            CheckpointNote[] checkpointNote = new CheckpointNote[1];
            noteOffset = this.m_logger.replicateNotes(buffer, indicator.m_dataID, dataOffset, newDataLength, noteOffset, lastNoteID, checkpointNote);
            if (lastNoteID[0] != -1L) {
                this.m_logger.forceToDisk(false, false);
                this.m_logger.rollforward(this.m_transactionManager, this.m_btreeManager, null, lastNoteID[0], false);
            }
            if (noteOffset == -1) break;
            this.m_pageManager.forceToDisk();
            if (this.m_standbyLastCheckpointNoteSeen != null) {
                this.m_lastCheckpointID = this.m_standbyLastCheckpointNoteSeen.getNoteID();
                this.m_oldestTransactionNoteIDAtLastCheckpoint = this.m_standbyLastCheckpointNoteSeen.getTransactionManager().getOldsetLogTransactionID();
            }
            this.m_standbyLastCheckpointNoteSeen = checkpointNote[0];
        }
        this.releaseUnusedNotes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReplicationManager.ReplicationDataIndicator startDeepSync() throws IOException {
        try {
            this.m_accessSemaphore.sharedLock();
            ReplicationManager.ReplicationDataIndicator indicator = this.packReplicatedPages(0L);
            indicator.m_deepSyncOldestNeededNote = this.getOldestNoteNeededAtLastCheckpoint();
            indicator.m_deepSyncCheckpointID = this.m_lastCheckpointID;
            ReplicationManager.ReplicationDataIndicator replicationDataIndicator = indicator;
            return replicationDataIndicator;
        }
        finally {
            this.m_accessSemaphore.releaseLock();
        }
    }

    private ReplicationManager.ReplicationDataIndicator packReplicatedPages(long firstPageNum) throws IOException {
        int count;
        ReplicationManager.ReplicationDataIndicator dataIndicator = new ReplicationManager.ReplicationDataIndicator();
        byte[] buffer = new byte[100 * Page.PAGE_LENGTH + 2];
        int offset = 2;
        long pageNum = firstPageNum;
        for (count = 0; count < 100 && pageNum <= this.m_pageManager.getHighestAllocatedPageNum(); ++count) {
            Page srcPage = this.m_pageManager.getForRead(pageNum++);
            srcPage.copyIntoBuffer(buffer, offset);
            offset += Page.PAGE_LENGTH;
        }
        BitUtil.putShort(buffer, 0, (short)count);
        dataIndicator.m_dataOffset = 0;
        dataIndicator.m_dataLength = 2 + Page.PAGE_LENGTH * count;
        dataIndicator.m_buffer = buffer;
        dataIndicator.m_okStatus = true;
        dataIndicator.m_logData = false;
        dataIndicator.m_dataID = firstPageNum;
        return dataIndicator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReplicationManager.ReplicationDataIndicator getDeepSyncData(ReplicationManager.DeepSyncRequest request) throws IOException, InterruptedException {
        if (!request.m_logRequest && request.m_requestDataID == 0L) {
            return this.startDeepSync();
        }
        try {
            this.m_accessSemaphore.sharedLock();
            if (request.m_requestDataID > this.m_pageManager.getHighestAllocatedPageNum()) {
                long lastWrittenNoteID = this.m_logger.getLastWrittenNoteID();
                ReplicationManager.ReplicationDataIndicator indicator = this.m_logger.getReplicationData(request.m_deepSyncOldestNeededNote, true);
                indicator.m_deepSyncLogData = indicator.m_dataID + (long)indicator.m_dataLength <= lastWrittenNoteID;
                indicator.m_deepSyncLastNoteWrittenAfterPageReplication = lastWrittenNoteID;
                ReplicationManager.ReplicationDataIndicator replicationDataIndicator = indicator;
                return replicationDataIndicator;
            }
            ReplicationManager.ReplicationDataIndicator indicator = this.packReplicatedPages(request.m_requestDataID);
            indicator.m_deepSyncOldestNeededNote = request.m_deepSyncOldestNeededNote;
            ReplicationManager.ReplicationDataIndicator replicationDataIndicator = indicator;
            return replicationDataIndicator;
        }
        finally {
            this.m_accessSemaphore.releaseLock();
        }
    }

    @Override
    public boolean transactionEndedDuringRecovery() throws IOException {
        return this.m_transactionEndedDuringRecovery;
    }

    @Override
    public void stopRecoveryCloseImmediately() throws IOException {
        this.m_recoveryInterrupted = true;
        if (this.m_logger != null) {
            this.m_logger.interruptRecovery();
        }
        this.close();
    }

    @Override
    public boolean requiresDeepSync() throws IOException {
        return this.m_standbyState == 1;
    }

    @Override
    public long getLogEndID() throws IOException {
        return this.m_logger.getNextNoteID();
    }

    @Override
    public long getCreationTimestamp(String dbName, HashMap parameters) throws IOException {
        File f;
        File dbDir = new File(dbName);
        String datafileName = (String)parameters.get("DATA_FILE");
        if (datafileName == null) {
            datafileName = "data";
        }
        if (!(f = new File(dbDir, datafileName)).exists() || f.length() == 0L) {
            return 0L;
        }
        RandomAccessFile dataFile = new RandomAccessFile(f, "r");
        MasterPage page = new MasterPage();
        dataFile.read(page.getBuffer());
        return page.getDBTimestamp();
    }

    @Override
    public boolean dbExists(String dbName) {
        return new File(dbName).exists();
    }

    @Override
    public void setPersistentReplicationState(String storageName, short state) throws IOException {
        this.m_replicationState.setPersistentReplicationState(storageName, state);
    }

    @Override
    public short getPersistentReplicationState(String storageName) throws IOException {
        return this.m_replicationState.getPersistentReplicationState(storageName);
    }

    @Override
    public void checkWhetherMiddleOfBackup(String dbName) throws IOException {
        if (Replicator.isBackupInProgress(new File(dbName))) {
            throw new IOException(dbName + " is not ready as a backup copy; it must be discarded.");
        }
    }

    private void setStandbyState(int state) {
        this.m_standbyState = state;
    }

    private final class CheckpointThread
    extends Thread {
        boolean m_doingCheckpoint;
        boolean m_terminate;
        boolean m_doCheckpoint;
        IOException failure;

        CheckpointThread() {
            super("Sonic DB checkpoint thread");
            this.m_doingCheckpoint = false;
            this.m_terminate = false;
            this.m_doCheckpoint = false;
            this.failure = null;
            this.setDaemon(true);
            this.start();
        }

        synchronized void requestCheckpoint() throws IOException {
            if (this.failure != null) {
                throw this.failure;
            }
            if (this.m_doingCheckpoint) {
                return;
            }
            this.m_doCheckpoint = true;
            this.notifyAll();
        }

        synchronized void terminate() {
            boolean interrupted = false;
            do {
                interrupted = false;
                try {
                    while (this.m_doingCheckpoint) {
                        this.wait();
                    }
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            } while (interrupted);
            this.m_terminate = true;
            this.notifyAll();
        }

        @Override
        public void run() {
            try {
                while (true) {
                    Boolean needToCheckpoint;
                    if ((needToCheckpoint = this.needToCheckpoint()) == null) {
                        return;
                    }
                    if (needToCheckpoint.booleanValue()) {
                        Storage.this.checkpointStart();
                        Storage.this.checkpointWaitForPagesToBeForced();
                        Storage.this.checkpointDone();
                        this.doneCheckpoint();
                    }
                    this.waitForRequest();
                }
            }
            catch (IOException e) {
                this.failure = e;
                return;
            }
        }

        private synchronized void waitForRequest() {
            boolean interrupted = false;
            do {
                interrupted = false;
                try {
                    if (this.m_terminate || this.m_doCheckpoint) {
                        return;
                    }
                    this.wait();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            } while (interrupted);
        }

        private synchronized Boolean needToCheckpoint() {
            if (this.m_terminate) {
                return null;
            }
            if (!this.m_doCheckpoint) {
                return Boolean.FALSE;
            }
            this.m_doCheckpoint = false;
            this.m_doingCheckpoint = true;
            return Boolean.TRUE;
        }

        private synchronized void doneCheckpoint() {
            this.m_doingCheckpoint = false;
            this.notifyAll();
        }
    }
}

