/*
 * Decompiled with CFR 0.152.
 */
package com.odi;

import com.odi.FatalInternalException;
import com.odi.imp.ArrayField;
import com.odi.imp.ClassField;
import com.odi.imp.ReferenceType;
import com.odi.imp.StringField;
import com.odi.imp.Utilities;

public abstract class Field {
    protected String name;
    protected byte type;
    protected boolean indexable = false;
    public static final byte ByteType = 1;
    public static final byte CharType = 2;
    public static final byte ShortType = 3;
    public static final byte IntType = 4;
    public static final byte LongType = 5;
    public static final byte FloatType = 6;
    public static final byte DoubleType = 7;
    public static final byte BooleanType = 8;
    protected static final byte LastPrimitiveType = 8;
    public static final byte StringType = 9;
    public static final byte ReferenceType = 10;
    public static final byte ReferenceTypeMax = 14;
    public static final byte ClassType = 15;
    public static final byte InterfaceType = 16;
    public static final byte ArrayType = 17;

    protected Field(String fieldName, byte fieldType) {
        if (fieldName == null) {
            throw new IllegalArgumentException("The \"fieldName\" argument to the field creation method was null.");
        }
        this.name = fieldName;
        this.type = fieldType;
    }

    public String getName() {
        return this.name;
    }

    public byte getType() {
        return this.type;
    }

    public Field makeIndexable() {
        this.indexable = true;
        return this;
    }

    public Field makeEmbedded() {
        throw new IllegalArgumentException("\"" + this.name + "\" cannot be embedded, since it is not a class, array or string type");
    }

    public Field makeEmbedded(int arrayLength) {
        throw new IllegalArgumentException("\"" + this.name + "\" cannot be embedded, since it is not a class, array or string type");
    }

    public boolean isEmbedded() {
        return false;
    }

    public boolean isIndexable() {
        return this.indexable;
    }

    public abstract String getTypeName();

    public static Field createByte(String fieldName) {
        return new com.odi.imp.Field(fieldName, 1);
    }

    public static Field createChar(String fieldName) {
        return new com.odi.imp.Field(fieldName, 2);
    }

    public static Field createShort(String fieldName) {
        return new com.odi.imp.Field(fieldName, 3);
    }

    public static Field createInt(String fieldName) {
        return new com.odi.imp.Field(fieldName, 4);
    }

    public static Field createLong(String fieldName) {
        return new com.odi.imp.Field(fieldName, 5);
    }

    public static Field createFloat(String fieldName) {
        return new com.odi.imp.Field(fieldName, 6);
    }

    public static Field createDouble(String fieldName) {
        return new com.odi.imp.Field(fieldName, 7);
    }

    public static Field createBoolean(String fieldName) {
        return new com.odi.imp.Field(fieldName, 8);
    }

    public static Field createString(String fieldName) {
        return new com.odi.imp.Field(fieldName, 9);
    }

    public static Field createEmbeddedString(String fieldName, int maxSize) {
        return new StringField(fieldName).makeEmbedded(maxSize);
    }

    public static Field createEmbeddedString(String fieldName) {
        return new StringField(fieldName);
    }

    public static Field createClass(String fieldName, String className) {
        if (className == null) {
            Utilities.throwNullArgumentException("Field", "createClass", "className");
        }
        if (className.equals("java.lang.String")) {
            return new com.odi.imp.Field(fieldName, 9);
        }
        return new ClassField(fieldName, className, false);
    }

    public static Field createInterface(String fieldName, String interfaceName) {
        if (interfaceName == null) {
            Utilities.throwNullArgumentException("Field", "createInterface", "interfaceName");
        }
        return new ClassField(fieldName, interfaceName, true);
    }

    public static Field createLazyReference(String fieldName, ReferenceType refType) {
        return new com.odi.imp.Field(fieldName, (byte)(10 + (byte)refType.getEnumeratedValue()));
    }

    public static Field createByteArray(String fieldName, int dimensions) {
        return new ArrayField(fieldName, 1, dimensions);
    }

    public static Field createCharArray(String fieldName, int dimensions) {
        return new ArrayField(fieldName, 2, dimensions);
    }

    public static Field createShortArray(String fieldName, int dimensions) {
        return new ArrayField(fieldName, 3, dimensions);
    }

    public static Field createIntArray(String fieldName, int dimensions) {
        return new ArrayField(fieldName, 4, dimensions);
    }

    public static Field createLongArray(String fieldName, int dimensions) {
        return new ArrayField(fieldName, 5, dimensions);
    }

    public static Field createFloatArray(String fieldName, int dimensions) {
        return new ArrayField(fieldName, 6, dimensions);
    }

    public static Field createDoubleArray(String fieldName, int dimensions) {
        return new ArrayField(fieldName, 7, dimensions);
    }

    public static Field createBooleanArray(String fieldName, int dimensions) {
        return new ArrayField(fieldName, 8, dimensions);
    }

    public static Field createStringArray(String fieldName, int dimensions) {
        return new ArrayField(fieldName, 9, dimensions);
    }

    public static Field createClassArray(String fieldName, String className, int dimensions) {
        if (className == null) {
            Utilities.throwNullArgumentException("Field", "createClassArray", "className");
        }
        return new ArrayField(fieldName, 15, className, dimensions);
    }

    public static Field createInterfaceArray(String fieldName, String interfaceName, int dimensions) {
        if (interfaceName == null) {
            Utilities.throwNullArgumentException("Field", "createInterfaceArray", "interfaceName");
        }
        return new ArrayField(fieldName, 16, interfaceName, dimensions);
    }

    public static Field createReferenceArray(String fieldName, int dimensions, ReferenceType refType) {
        return new ArrayField(fieldName, (byte)(10 + (byte)refType.getEnumeratedValue()), dimensions);
    }

    public static byte getPrimFieldTypeEnum(Class fieldType) {
        if (fieldType == Byte.TYPE) {
            return 1;
        }
        if (fieldType == Character.TYPE) {
            return 2;
        }
        if (fieldType == Short.TYPE) {
            return 3;
        }
        if (fieldType == Integer.TYPE) {
            return 4;
        }
        if (fieldType == Long.TYPE) {
            return 5;
        }
        if (fieldType == Boolean.TYPE) {
            return 8;
        }
        if (fieldType == Float.TYPE) {
            return 6;
        }
        if (fieldType == Double.TYPE) {
            return 7;
        }
        throw new FatalInternalException("Unrecognized Java primitive type: " + fieldType);
    }

    public static final boolean isReferenceType(byte type) {
        return type > 10 && type <= 14;
    }
}

