/*
 * Decompiled with CFR 0.152.
 */
package com.odi.imp;

import com.odi.FatalInternalException;
import com.odi.Placement;
import com.odi.imp.Cluster;
import com.odi.imp.Database;
import com.odi.imp.ObjectManager;
import com.odi.imp.ObjectReference;
import com.odi.imp.SchemaManager;
import com.odi.imp.Segment;
import com.odi.imp.Utilities;

public class ObjRefUtils
implements ObjectReference.Constants {
    static String nullOIDString = "<null>";

    public static boolean isNull(ObjectReference objRef) {
        return objRef.getAFTypeCode() == 0;
    }

    public static Database getDatabase(ObjectReference objRef) {
        return ObjRefUtils.getSegment(objRef).getDatabaseInternal();
    }

    public static int getDatabaseId(ObjectReference objRef) {
        return ObjRefUtils.getDatabase(objRef).getDatabaseId();
    }

    public static Segment getSegment(ObjectReference objRef) {
        return (Segment)objRef.getPlacement().getSegment();
    }

    public static int getSegmentId(ObjectReference objRef) {
        return objRef.getPlacement().getSegment().getSegmentId();
    }

    public static Cluster getCluster(ObjectReference objRef) {
        Placement place = objRef.getPlacement();
        try {
            return (Cluster)place;
        }
        catch (ClassCastException e) {
            throw new FatalInternalException("Attempt to get the cluster of an exported object reference.");
        }
    }

    public static int getClusterId(ObjectReference objRef) {
        if (ObjRefUtils.isExportedForm(objRef)) {
            return -4;
        }
        return ObjRefUtils.getCluster(objRef).getClusterId();
    }

    public static long getExportId(ObjectReference objRef) {
        if (!ObjRefUtils.isExportedForm(objRef)) {
            throw new FatalInternalException("getExportId() on an unexported ObjectReference");
        }
        return objRef.getLocation();
    }

    public static boolean isArray(ObjectReference objRef) {
        return objRef.getArrayElementCount() != -1;
    }

    public static void makeReadable(ObjectReference objRef) {
        objRef.setFlags((short)(objRef.getFlags() & 0xFFFFFF7E | 2));
    }

    public static void makeCached(ObjectReference objRef) {
        objRef.setFlags((short)(objRef.getFlags() | 1 | 2 | 0x80));
    }

    public static void makeWritable(ObjectReference objRef) {
        objRef.setFlags((short)(objRef.getFlags() & 0xFFFFFF7E & 0xFFFFFFFD));
    }

    public static void makeHollow(ObjectReference objRef) {
        objRef.setFlags((short)(objRef.getFlags() & 0xFFFFFF7F | 2 | 1));
    }

    public static void setStale(ObjectReference objRef) {
        objRef.setFlags((short)(objRef.getFlags() & 0xFFFFFF7F | 4));
    }

    public static void setDestroyed(ObjectReference objRef, boolean destroyed) {
        short flags = objRef.getFlags();
        objRef.setFlags((short)(destroyed ? (flags | 8) & 0xFFFFFFFB : flags & 0xFFFFFFF7));
    }

    public static void setNewlyPersistent(ObjectReference objRef, boolean newlyPersistent) {
        short flags = objRef.getFlags();
        objRef.setFlags((short)(newlyPersistent ? flags | 0x10 : flags & 0xFFFFFFEF));
    }

    public static void setNewlyExported(ObjectReference objRef, boolean newlyExported) {
        short flags = objRef.getFlags();
        if (newlyExported) {
            if (ObjRefUtils.isExportedForm(objRef)) {
                throw new FatalInternalException("newlyExported bit should only be set for the local reference form of an ObjectReference");
            }
            objRef.setFlags((short)(flags | 0x20));
        } else {
            objRef.setFlags((short)(flags & 0xFFFFFFDF));
        }
    }

    public static void setHasExportedForm(ObjectReference objRef, boolean exportedMapEntry) {
        short flags = objRef.getFlags();
        if (exportedMapEntry) {
            if (ObjRefUtils.isExportedForm(objRef)) {
                throw new FatalInternalException("HAS_EXPORTED_FORM_BIT bit should only be set for the local reference form of an ObjectReference");
            }
            objRef.setFlags((short)(flags | 0x40));
        } else {
            objRef.setFlags((short)(flags & 0xFFFFFFBF));
        }
    }

    public static boolean hasRB(ObjectReference objRef) {
        return (objRef.getFlags() & 1) != 0;
    }

    public static boolean hasWB(ObjectReference objRef) {
        return (objRef.getFlags() & 2) != 0;
    }

    public static boolean isCached(ObjectReference objRef) {
        return (objRef.getFlags() & 0x80) != 0;
    }

    public static boolean isNewlyPersistent(ObjectReference objRef) {
        return (objRef.getFlags() & 0x10) != 0;
    }

    public static boolean isStale(ObjectReference objRef) {
        return (objRef.getFlags() & 4) != 0;
    }

    public static boolean isDestroyed(ObjectReference objRef) {
        return (objRef.getFlags() & 8) != 0;
    }

    public static boolean isNewlyExported(ObjectReference objRef) {
        return (objRef.getFlags() & 0x20) != 0;
    }

    public static boolean isInvalid(ObjectReference objRef) {
        return (objRef.getFlags() & 0xC) != 0;
    }

    public static boolean hasExportedForm(ObjectReference objRef) {
        return (objRef.getFlags() & 0x40) != 0;
    }

    public static long getStorageOffset(ObjectReference objRef) {
        return ObjectManager.assureCurrent().sv.serverGetStorageOffset(objRef);
    }

    public static boolean isExportedObject(ObjectReference objRef) {
        return ObjRefUtils.isExportedForm(objRef) || ObjRefUtils.hasExportedForm(objRef);
    }

    public static boolean isExportedForm(ObjectReference objRef) {
        return objRef.getPlacement() instanceof Segment;
    }

    public static String typeString(ObjectReference objRef) {
        SchemaManager sm = ((ObjectManager)ObjectManager.getCurrent()).schemaManager;
        int AFTypeCode = objRef.getAFTypeCode();
        int dimensions = objRef.getArrayDimensions();
        if (dimensions == 0) {
            return ObjRefUtils.isNull(objRef) ? "" : sm.getTypeName(AFTypeCode);
        }
        if (dimensions == 1 && Utilities.isStringTypeCode(AFTypeCode)) {
            return "String";
        }
        String dims = "[" + objRef.getArrayElementCount() + "]";
        if (dimensions == 1) {
            return sm.getTypeName(Utilities.arrayElementTypeCode(AFTypeCode)) + dims;
        }
        int arrayElementTypeCode = Utilities.arrayElementTypeCode(AFTypeCode);
        if (arrayElementTypeCode == Utilities.arrayElementTypeCode(Utilities.getStringTypeCode())) {
            for (int i = 2; i < dimensions; ++i) {
                dims = dims + "[]";
            }
            return "String" + dims;
        }
        for (int i = 1; i < dimensions; ++i) {
            dims = dims + "[]";
        }
        return sm.getTypeName(arrayElementTypeCode) + dims;
    }

    public static String OIDString(long oid) {
        return "<" + Long.toHexString(oid) + ">";
    }

    public static String OIDString(ObjectReference objRef) {
        if (ObjRefUtils.isNull(objRef)) {
            return nullOIDString;
        }
        return ObjRefUtils.OIDString(objRef.getLocation());
    }

    public static String typedOIDString(ObjectReference objRef) {
        if (ObjRefUtils.isNull(objRef)) {
            return nullOIDString;
        }
        return "( " + ObjRefUtils.typeString(objRef) + " )" + ObjRefUtils.OIDString(objRef);
    }
}

