/*
 * Decompiled with CFR 0.152.
 */
package com.odi.util;

import com.odi.FatalInternalException;
import com.odi.util.BTreeImpl;
import com.odi.util.BTreeNode;
import com.odi.util.KeyType;
import java.util.NoSuchElementException;

public abstract class KeyFixedSizeType
extends KeyType {
    public KeyFixedSizeType(int enumVal) {
        super(enumVal);
    }

    @Override
    public int compare(byte[] givenKey, byte[] key, int offset, BTreeImpl btree) {
        return BTreeNode.compareKeys(givenKey, 0, givenKey.length, key, offset, this.size());
    }

    @Override
    public int compare(byte[] key1, int offset1, byte[] key2, int offset2, BTreeImpl btree) {
        return BTreeNode.compareKeys(key1, offset1, this.size(), key2, offset2, this.size());
    }

    @Override
    public byte[] getKey(byte[] key, int offset, byte[] keyBuffer, BTreeImpl btree) {
        return BTreeNode.dupKey(key, offset, this.size(), keyBuffer);
    }

    @Override
    public void setKey(byte[] key, byte[] nodeKeys, int offset, BTreeImpl btree) {
        BTreeNode.copyKey(key, 0, BTreeNode.keyLength(key), nodeKeys, offset, this.size());
    }

    @Override
    public boolean substringMatch(byte[] keyRep, int offset, byte[] substring, boolean caseInsensitive, BTreeImpl btree) {
        throw new FatalInternalException("findSubstringMatch called on BTree with fixed sized keys");
    }

    @Override
    public void destroy(byte[] rep, int offset, boolean isLeaf, BTreeImpl btree) {
    }

    @Override
    public KeyType.ByteIterator getByteIterator(byte[] rep, int offset, BTreeImpl btree) {
        return new FixedSizeKeyByteIterator(rep, offset);
    }

    public class FixedSizeKeyByteIterator
    implements KeyType.ByteIterator {
        private final byte[] rep;
        private final int offset;
        private int pos = 0;

        public FixedSizeKeyByteIterator(byte[] rep, int offset) {
            this.rep = rep;
            this.offset = offset;
        }

        @Override
        public boolean hasNext() {
            return this.pos < KeyFixedSizeType.this.size();
        }

        @Override
        public byte next() {
            if (this.pos < KeyFixedSizeType.this.size()) {
                return this.rep[this.offset + this.pos++];
            }
            throw new NoSuchElementException();
        }

        @Override
        public void reset() {
            this.pos = 0;
        }
    }
}

