/*
 * Decompiled with CFR 0.152.
 */
package com.odi.util;

import com.odi.ClassInfo;
import com.odi.GenericObject;
import com.odi.NoSessionException;
import com.odi.ObjectStore;
import com.odi.util.OSHashtable;
import java.util.Map;
import java.util.Set;

public class OSHashMap
extends OSHashtable
implements Map {
    static final long serialVersionUID = 5213330779784873681L;
    private static final ClassInfo classinfo = ClassInfo.register(ClassInfo.getDynamic("com.odi.util.OSHashMap"));
    int modificationTick;

    public OSHashMap(ClassInfo ignored) {
        super(ignored);
    }

    @Override
    public void initializeContents(GenericObject genObject) {
        super.initializeContents(genObject);
        this.modificationTick = genObject.getIntField(1, classinfo);
    }

    @Override
    public void flushContents(GenericObject genObject) {
        super.flushContents(genObject);
        genObject.setIntField(1, this.modificationTick, classinfo);
    }

    @Override
    public void clearContents() {
        super.clearContents();
        this.modificationTick = 0;
    }

    public OSHashMap(int initialCapacity) {
        super(initialCapacity);
        this.modificationTick = 0;
    }

    public OSHashMap() {
        this.modificationTick = 0;
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        Object result = super.put(key, value);
        ObjectStore.dirty(this);
        ++this.modificationTick;
        return result;
    }

    @Override
    public synchronized Object remove(Object key) {
        Object result = super.remove(key);
        if (result != null) {
            ObjectStore.dirty(this);
            ++this.modificationTick;
        }
        return result;
    }

    @Override
    public synchronized boolean removeValue(Object value) {
        if (super.removeValue(value)) {
            ObjectStore.fetch(this);
            ++this.modificationTick;
            return true;
        }
        return false;
    }

    @Override
    public synchronized void clear() {
        ++this.modificationTick;
        super.clear();
    }

    @Override
    public boolean equals(Object obj) {
        Set keys2;
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Map)) {
            return false;
        }
        Map otherMap = (Map)obj;
        Set keys1 = this.keySet();
        if (!keys1.equals(keys2 = otherMap.keySet())) {
            return false;
        }
        for (Object k : keys1) {
            if (this.get(k).equals(otherMap.get(k))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hash;
        block3: {
            hash = 0;
            try {
                for (Object obj : this.entrySet()) {
                    hash += obj.hashCode();
                }
            }
            catch (NoSessionException e) {
                if (Boolean.getBoolean("com.odi.debugHashCodes")) break block3;
                throw e;
            }
        }
        return hash;
    }

    @Override
    int getTick() {
        ObjectStore.fetch(this);
        return this.modificationTick;
    }
}

