/*
 * Decompiled with CFR 0.152.
 */
package com.progress.blackbird.sys;

import com.progress.blackbird.sys.SysConfig;
import com.progress.blackbird.sys.SysListElement;
import com.progress.blackbird.sys.SysListHead;
import java.io.PrintStream;

public abstract class SysLogger {
    boolean init;
    private SysListHead log;
    private long size;
    private int prunePolicy = 0;
    private int pruneData;
    public static final int PRUNE_POLICY_OFF = 0;
    public static final int PRUNE_POLICY_AGE = 1;
    public static final int PRUNE_POLICY_SIZE = 2;
    public static final int PRUNE_POLICY_DEFAULT = 0;

    protected SysLogger() {
        switch (this.prunePolicy) {
            case 1: {
                this.pruneData = 15;
                break;
            }
            case 2: {
                this.pruneData = 1024;
            }
        }
    }

    private int getPrunePolicyFromString(String string) {
        int n = string.compareToIgnoreCase("off") == 0 ? 0 : (string.compareToIgnoreCase("age") == 0 ? 1 : (string.compareToIgnoreCase("size") == 0 ? 2 : 0));
        return n;
    }

    private void init() {
        if (!this.init) {
            this.log = SysListHead.create(null);
            this.size = 0L;
            String string = SysConfig.getConfigValue(SysConfig.getProperties(), "bb.logger.prunePolicy");
            this.prunePolicy = string != null ? this.getPrunePolicyFromString(string) : this.prunePolicy;
            switch (this.prunePolicy) {
                case 1: {
                    this.pruneData = (int)SysConfig.getConfigValue(SysConfig.getProperties(), "bb.logger.pruneAge", this.pruneData);
                    break;
                }
                case 2: {
                    this.pruneData = (int)SysConfig.getConfigValue(SysConfig.getProperties(), "bb.logger.pruneSize", this.pruneData);
                }
            }
            this.init = true;
        }
    }

    private void addElementToLog(Element element) {
        this.log.append(element);
        this.size += (long)(element.msg.length() * 2);
    }

    private void removeElementFromLog(Element element) {
        element.remove();
        this.size -= (long)(element.msg.length() * 2);
    }

    public final void setPrunePolicy(int n, Object object) {
        switch (n) {
            case 0: {
                this.prunePolicy = n;
                this.pruneData = 0;
                break;
            }
            case 1: 
            case 2: {
                if (object == null || object instanceof Integer) {
                    this.prunePolicy = n;
                    if (object == null) break;
                    int n2 = (Integer)object;
                    if (n2 > 0) {
                        this.pruneData = n2;
                        break;
                    }
                    throw new IllegalArgumentException("Data for PRUNE_POLICY_AGE or PRUNE_POLICY_SIZE needs to be a positive value");
                }
                throw new IllegalArgumentException("Data for PRUNE_POLICY_AGE or PRUNE_POLICY_SIZE needs to be an Integer");
            }
            default: {
                throw new IllegalArgumentException("Invalid policy specified");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void log(String string) {
        SysLogger sysLogger = this;
        synchronized (sysLogger) {
            this.init();
            long l = System.currentTimeMillis();
            if (this.prunePolicy != 0) {
                this.addElementToLog(new Element(string, l));
                if (this.prunePolicy == 1) {
                    Element element = (Element)this.log.getNext();
                    while (element != null && l - element.ts > (long)this.pruneData * 60L * 1000L) {
                        this.removeElementFromLog(element);
                        element = (Element)this.log.getNext();
                    }
                } else if (this.prunePolicy == 2) {
                    Element element = (Element)this.log.getNext();
                    while (element != null && this.size > (long)(this.pruneData * 1024)) {
                        this.removeElementFromLog(element);
                        element = (Element)this.log.getNext();
                    }
                }
            }
            this.out(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getHistorySize() {
        SysLogger sysLogger = this;
        synchronized (sysLogger) {
            this.init();
            return this.log.getListSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String[] getHistory() {
        SysLogger sysLogger = this;
        synchronized (sysLogger) {
            this.init();
            String[] stringArray = new String[this.log.getListSize()];
            int n = 0;
            Element element = (Element)this.log.getNext();
            while (element != null) {
                stringArray[n] = element.msg;
                element = (Element)element.getNext();
                ++n;
            }
            return stringArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dumpHistory(PrintStream printStream) {
        SysLogger sysLogger = this;
        synchronized (sysLogger) {
            this.init();
            for (Element element = (Element)this.log.getNext(); element != null; element = (Element)element.getNext()) {
                if (printStream == null) {
                    this.out(element.msg);
                    continue;
                }
                printStream.print(element.msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void flushHistory() {
        SysLogger sysLogger = this;
        synchronized (sysLogger) {
            this.init = false;
            this.init();
        }
    }

    public abstract void out(String var1);

    private final class Element
    extends SysListElement {
        final String msg;
        final long ts;

        Element(String string, long l) {
            super(null);
            this.msg = string;
            this.ts = l;
        }
    }
}

