/*
 * Decompiled with CFR 0.152.
 */
package com.progress.blackbird.tools.interactive;

import com.progress.blackbird.sys.ESysHnameFormatException;
import com.progress.blackbird.sys.SysHname;
import com.progress.blackbird.sys.SysHnameTable;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Random;
import java.util.StringTokenizer;

public class Hname {
    private static SysHnameTable table = SysHnameTable.create(null, 0);
    private static Random random = new Random(System.currentTimeMillis());

    private static char genChar() {
        return (char)(random.nextInt(26) + 97);
    }

    private static String genElement(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = n2 > n ? random.nextInt(n2 - n) + n : n;
        for (int i = 0; i < n3; ++i) {
            stringBuffer.append(Hname.genChar());
        }
        return stringBuffer.toString();
    }

    private static String genHname(int n, int n2, int n3, int n4) {
        StringBuffer stringBuffer = new StringBuffer();
        int n5 = n4 > n3 ? random.nextInt(n4 - n3) + n3 : n3;
        for (int i = 0; i < n5; ++i) {
            stringBuffer.append(Hname.genElement(n, n2));
            if (i == n5 - 1) continue;
            stringBuffer.append(SysHname.getElementSeparator());
        }
        return stringBuffer.toString();
    }

    private static void processMatch(String string, String string2) {
        try {
            if (SysHname.isMatch(string, string2)) {
                System.out.println("'" + string + "' and '" + string2 + "' match");
            } else {
                System.out.println("'" + string + "' and '" + string2 + "' do not match");
            }
        }
        catch (ESysHnameFormatException eSysHnameFormatException) {
            System.out.println("One of the arguments is invalid [" + eSysHnameFormatException.getMessage() + "]");
        }
    }

    private static void processAdd(String string) {
        try {
            System.out.println("Adding '" + string + "' to table...");
            String string2 = new String(string);
            table.add(string, string2);
            System.out.println("Successfully added '" + string + "' to table");
        }
        catch (ESysHnameFormatException eSysHnameFormatException) {
            System.out.println("Argument is invalid [" + eSysHnameFormatException.getMessage() + "]");
        }
    }

    private static void processGet(String string) {
        try {
            System.out.println("Finding '" + string + "' in table...");
            String string2 = (String)table.get(string);
            if (string2 == null) {
                System.out.println("Failed to find '" + string + "' in table");
            } else if (SysHname.normalize(string2).compareTo(SysHname.normalize(string)) == 0) {
                System.out.println("Found hname in table and associated object is correct");
            } else {
                System.out.println("Found '" + string + "' in table but associated object is not correct! [" + string2 + "]");
            }
        }
        catch (ESysHnameFormatException eSysHnameFormatException) {
            System.out.println("Argument is invalid [" + eSysHnameFormatException.getMessage() + "]");
        }
    }

    private static void processMatches(String string) {
        try {
            System.out.println("Finding set of names matching '" + string + "' in table...");
            LinkedHashMap linkedHashMap = table.matches(string);
            if (linkedHashMap == null) {
                System.out.println("Failed to find '" + string + "' in table");
            } else if (linkedHashMap.size() > 0) {
                System.out.println("Match list:");
                for (String string2 : ((HashMap)linkedHashMap).keySet()) {
                    System.out.println("  " + string2);
                }
                System.out.println("Number of matches=" + linkedHashMap.size());
            } else {
                System.out.println("No matches.");
            }
        }
        catch (ESysHnameFormatException eSysHnameFormatException) {
            System.out.println("Argument is invalid [" + eSysHnameFormatException.getMessage() + "]");
        }
    }

    private static void processRemove(String string) {
        try {
            System.out.println("Removing '" + string + "' from table...");
            String string2 = (String)table.remove(string);
            if (string2 != null) {
                if (SysHname.normalize(string2).compareTo(SysHname.normalize(string)) == 0) {
                    System.out.println("Successfully removed '" + string + "' from table and associated object is correct");
                } else {
                    System.out.println("Successfully removed '" + string + "' from table and associated object is not correct! [" + string2 + "]");
                }
            } else {
                System.out.println("Failed to find '" + string + "' in table");
            }
        }
        catch (ESysHnameFormatException eSysHnameFormatException) {
            System.out.println("Argument is invalid [" + eSysHnameFormatException.getMessage() + "]");
        }
    }

    private static void processBulk(int n, int n2, int n3, int n4, int n5) {
        for (int i = 0; i < n; ++i) {
            System.out.print(i + 1 + "\r");
            String string = Hname.genHname(n2, n3, n4, n5);
            try {
                table.add(string, new Object());
                continue;
            }
            catch (ESysHnameFormatException eSysHnameFormatException) {
                throw new InternalError("");
            }
        }
    }

    private static void processCount() {
        System.out.println("Table size = " + table.size());
    }

    public static void main(String[] stringArray) throws Exception {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            String[] stringArray2;
            System.out.print("> ");
            String string = bufferedReader.readLine();
            if (string == null) break;
            if (string.length() <= 0) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            String string2 = stringTokenizer.nextToken();
            if (stringTokenizer.countTokens() > 0) {
                stringArray2 = new String[stringTokenizer.countTokens()];
                int n = 0;
                while (stringTokenizer.hasMoreElements()) {
                    stringArray2[n++] = stringTokenizer.nextToken();
                }
            } else {
                stringArray2 = new String[]{};
            }
            if (string2.compareToIgnoreCase("bye") == 0 || string2.compareToIgnoreCase("exit") == 0) {
                System.out.println("Goodbye");
                break;
            }
            if (string2.compareToIgnoreCase("elementSeparator") == 0) {
                if (stringArray2.length < 1) {
                    System.out.println("Syntax error: elementSeparator <separator string>");
                    continue;
                }
                System.out.println("Setting element separator string to '" + stringArray2[0] + "'.");
                SysHname.setElementSeparator(stringArray2[0]);
                continue;
            }
            if (string2.compareToIgnoreCase("elementWildcard") == 0) {
                if (stringArray2.length < 1) {
                    System.out.println("Syntax error: elementWildcard <element wildcard character>");
                    continue;
                }
                System.out.println("Setting element wildcard character to '" + stringArray2[0].toCharArray()[0] + "'.");
                SysHname.setElementWildcard(stringArray2[0].toCharArray()[0]);
                continue;
            }
            if (string2.compareToIgnoreCase("levelWildcard") == 0) {
                if (stringArray2.length < 1) {
                    System.out.println("Syntax error: levelWildcard <level wildcard string>");
                    continue;
                }
                System.out.println("Setting level wildcard string to '" + stringArray2[0] + "'.");
                SysHname.setLevelWildcard(stringArray2[0]);
                continue;
            }
            if (string2.compareToIgnoreCase("match") == 0) {
                if (stringArray2.length < 2) {
                    System.out.println("Syntax error: match <hname1> <hname2>");
                    continue;
                }
                Hname.processMatch(stringArray2[0], stringArray2[1]);
                continue;
            }
            if (string2.compareToIgnoreCase("add") == 0) {
                if (stringArray2.length < 1) {
                    System.out.println("Syntax error: add <hname>");
                    continue;
                }
                Hname.processAdd(stringArray2[0]);
                continue;
            }
            if (string2.compareToIgnoreCase("get") == 0) {
                if (stringArray2.length < 1) {
                    System.out.println("Syntax error: get <hname>");
                    continue;
                }
                Hname.processGet(stringArray2[0]);
                continue;
            }
            if (string2.compareToIgnoreCase("matches") == 0) {
                if (stringArray2.length < 1) {
                    System.out.println("Syntax error: matches <hname>");
                    continue;
                }
                Hname.processMatches(stringArray2[0]);
                continue;
            }
            if (string2.compareToIgnoreCase("remove") == 0) {
                if (stringArray2.length < 1) {
                    System.out.println("Syntax error: remove <hname>");
                    continue;
                }
                Hname.processRemove(stringArray2[0]);
                continue;
            }
            if (string2.compareToIgnoreCase("bulk") == 0) {
                if (stringArray2.length < 5) {
                    System.out.println("Syntax error: bulk <numHnames> <minElementLen> <maxElementLen> <minLevels> < maxLevels>");
                    continue;
                }
                Hname.processBulk(new Integer(stringArray2[0]), new Integer(stringArray2[1]), new Integer(stringArray2[2]), new Integer(stringArray2[3]), new Integer(stringArray2[4]));
                continue;
            }
            if (string2.compareToIgnoreCase("count") == 0) {
                Hname.processCount();
                continue;
            }
            if (string2.compareToIgnoreCase("clear") == 0) {
                table.clear();
                continue;
            }
            if (string2.compareToIgnoreCase("dump") == 0) {
                table.dump(System.out);
                continue;
            }
            if (string2.compareToIgnoreCase("gc") == 0) {
                System.gc();
                continue;
            }
            System.out.println("Unknown command [" + string2 + "]");
        }
    }
}

