/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.directory.impl;

import com.sonicsw.mf.common.IDirectoryFileSystemService;
import com.sonicsw.mf.common.config.IBlob;
import com.sonicsw.mf.framework.directory.impl.DirectoryService;
import com.sonicsw.mx.config.util.SonicFSException;
import com.sonicsw.mx.config.util.SonicFSFile;
import com.sonicsw.mx.config.util.SonicFSFileSystem;
import java.io.File;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class ExtendedSonicFSFileSystem
extends SonicFSFileSystem {
    private static String TEMP_FILE_NAME = "_tmp_ExtendedSonicFSFileSystem";
    private File m_tempDir;

    public ExtendedSonicFSFileSystem(IDirectoryFileSystemService dfs, String user, File tempDir) {
        super(dfs, user);
        this.m_tempDir = tempDir;
    }

    public SonicFSFile getFileDetails(String path0) throws SonicFSException {
        String path = this.getCanonical(path0);
        SonicFSFile file = null;
        try {
            file = this.getDetails(path);
        }
        catch (Exception e) {
            // empty catch block
        }
        return file;
    }

    public void copyFiles(String srcPath0, String trgtPath0) throws SonicFSException {
        String srcPath = this.getCanonical(srcPath0);
        String trgtPath = this.getCanonical(trgtPath0);
        if (trgtPath.equals(srcPath)) {
            throw new SonicFSException("The source path and the target path are equal - \"" + srcPath + "\"");
        }
        SonicFSFile srcFile = this.getDetails(srcPath);
        SonicFSFile trgtFile = this.getFileDetails(trgtPath);
        if (trgtFile != null && trgtFile.isFile()) {
            this.deleteFile(trgtFile.getFullName());
            trgtFile = null;
        }
        if (trgtFile != null) {
            this.copyInto(srcFile, trgtFile.getFullName());
        } else {
            String targetParent = this.getParent(trgtPath);
            SonicFSFile targetParentFile = this.getDetails(targetParent);
            if (targetParentFile.isFile()) {
                throw new SonicFSException("Cannot copy to \"" + trgtPath + "\" - \"" + targetParent + "\" is not a directory");
            }
            if (srcFile.isFile()) {
                this.copyFile(srcFile.getFullName(), trgtPath);
            } else {
                this.createDirectory(trgtPath);
                try {
                    ((DirectoryService)this.m_dfs).copyConfigurePermissions(srcPath, trgtPath, 1);
                }
                catch (Exception e) {
                    throw new SonicFSException("Failed to copy permission(s) from \"" + srcPath + "\" - " + e.getMessage());
                }
                this.copyContent(srcFile.getFullName(), trgtPath);
            }
        }
    }

    public SonicFSFile[] deepListDetails(String srcPath) throws SonicFSException {
        ArrayList<SonicFSFile> resultList = new ArrayList<SonicFSFile>();
        SonicFSFile file = this.getDetails(srcPath);
        resultList.add(file);
        if (file.isDirectory()) {
            this.listDirectoryContent(srcPath, resultList);
        }
        return resultList.toArray(new SonicFSFile[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(String srcFile, String trgtPath) throws SonicFSException {
        File tempFile = null;
        try {
            SonicFSFile targetFile = this.getFileDetails(trgtPath);
            if (targetFile != null && targetFile.isFile()) {
                this.deleteFile(trgtPath);
            }
            tempFile = this.getFile(srcFile);
            this.createFile(trgtPath, tempFile);
            try {
                ((DirectoryService)this.m_dfs).copyConfigurePermissions(srcFile, trgtPath, 3);
            }
            catch (Exception e) {
                throw new SonicFSException("Failed to copy permission(s) from \"" + srcFile + "\" - " + e.getMessage());
            }
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    private void listDirectoryContent(String srcPath, ArrayList resultList) throws SonicFSException {
        SonicFSFile[] list = this.listDetails(srcPath);
        for (int i = 0; i < list.length; ++i) {
            SonicFSFile currentFile = list[i];
            resultList.add(currentFile);
            if (!currentFile.isDirectory()) continue;
            this.listDirectoryContent(currentFile.getFullName(), resultList);
        }
    }

    private void copyContent(String srcPath, String trgtPath) throws SonicFSException {
        SonicFSFile[] list = this.listDetails(srcPath);
        for (int i = 0; i < list.length; ++i) {
            this.copyInto(list[i], trgtPath);
        }
    }

    private void copyInto(SonicFSFile srcFile, String hostDir) throws SonicFSException {
        String srcName = srcFile.getName();
        String targetPath = this.createChildName(hostDir, srcName);
        SonicFSFile targetFile = this.getFileDetails(targetPath);
        if (srcFile.isFile()) {
            this.copyFile(srcFile.getFullName(), targetPath);
        } else {
            if (targetFile != null) {
                if (targetFile.isFile()) {
                    this.deleteFile(targetPath);
                } else {
                    this.copyContent(srcFile.getFullName(), targetPath);
                    return;
                }
            }
            this.createDirectory(targetPath);
            try {
                ((DirectoryService)this.m_dfs).copyConfigurePermissions(srcFile.getFullName(), targetPath, 1);
            }
            catch (Exception e) {
                throw new SonicFSException("Failed to copy permission(s) from \"" + srcFile.getFullName() + "\" - " + e.getMessage());
            }
            this.copyContent(srcFile.getFullName(), targetPath);
        }
    }

    private String createChildName(String parentPath, String childName) {
        String[] parentComponents = ExtendedSonicFSFileSystem.split(parentPath);
        String[] childComponents = new String[parentComponents.length + 1];
        for (int i = 0; i < parentComponents.length; ++i) {
            childComponents[i] = parentComponents[i];
        }
        childComponents[parentComponents.length] = childName;
        return ExtendedSonicFSFileSystem.combine(childComponents, 0, childComponents.length);
    }

    public String getParent(String path) {
        String[] components = ExtendedSonicFSFileSystem.split(path);
        return ExtendedSonicFSFileSystem.combine(components, 0, components.length - 1);
    }

    public String getCanonical(String path) throws SonicFSException {
        if (!path.startsWith("/")) {
            throw new SonicFSException("\"" + path + "\" does not start with /");
        }
        StringBuffer sb = new StringBuffer();
        int pathLength = path.length();
        boolean prevWasSeparator = false;
        for (int i = 0; i < pathLength; ++i) {
            char c = path.charAt(i);
            if (prevWasSeparator && c == '/') continue;
            sb.append(c);
            prevWasSeparator = c == '/';
        }
        String canonical = sb.toString();
        int canonicalLength = canonical.length();
        if (canonicalLength > 1 && canonical.charAt(canonicalLength - 1) == '/') {
            return canonical.substring(0, canonicalLength - 1);
        }
        return canonical;
    }

    private static String[] split(String name) {
        StringTokenizer st = new StringTokenizer(name, "/");
        String[] res = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            res[i++] = st.nextToken();
        }
        return res;
    }

    private static String combine(String[] s, int start, int stop) {
        StringBuffer sb = new StringBuffer("/");
        for (int i = start; i < stop; ++i) {
            if (i != start) {
                sb.append('/');
            }
            sb.append(s[i]);
        }
        return sb.toString();
    }

    private File getFile(String path) throws SonicFSException {
        RandomAccessFile tempDataFile = null;
        File tempFile = null;
        try {
            int avail;
            IBlob blob = this.m_dfs.getFSBlob(path, false);
            tempFile = new File(this.m_tempDir, TEMP_FILE_NAME);
            tempFile.delete();
            tempDataFile = new RandomAccessFile(tempFile, "rw");
            InputStream is = blob.getBlobStream();
            byte[] buffer = new byte[1024];
            while ((avail = is.read(buffer)) != -1) {
                tempDataFile.write(buffer, 0, avail);
            }
            is.close();
            File file = tempFile;
            return file;
        }
        catch (Exception e) {
            throw new SonicFSException("Failed to get file \"" + path + "\" - " + e.getMessage());
        }
        finally {
            if (tempDataFile != null) {
                try {
                    tempDataFile.close();
                }
                catch (Exception e) {}
            }
        }
    }
}

