/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.directory.impl;

import com.sonicsw.mf.common.config.ConfigException;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.config.IIdentity;
import com.sonicsw.mf.common.config.impl.DirIdentity;
import com.sonicsw.mf.common.config.impl.EntityName;
import com.sonicsw.mf.common.dirconfig.DirectoryDoesNotExistException;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.dirconfig.ElementFactory;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.framework.directory.impl.DirectoryService;
import com.sonicsw.mf.framework.directory.storage.IStorage;
import com.sonicsw.mf.framework.directory.storage.StorageException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

class IDCache {
    private static final String CACHE_DATA_ATT = "CAHCE_DATA";
    private HashMap m_root;
    private transient IStorage m_storage;
    private ArrayList m_events = null;

    IDCache(DirectoryService ds) throws DirectoryServiceException {
        this.m_root = new HashMap();
        this.m_storage = ds.getStorage();
        this.buildDir("/");
    }

    IDCache(IDirElement cacheElement) throws DirectoryServiceException {
        try {
            byte[] cacheData = (byte[])cacheElement.getAttributes().getAttribute(CACHE_DATA_ATT);
            ByteArrayInputStream in = new ByteArrayInputStream(cacheData);
            ObjectInputStream objectIn = new ObjectInputStream(in);
            this.m_root = (HashMap)objectIn.readObject();
            this.m_storage = null;
        }
        catch (Exception e) {
            throw new DirectoryServiceException(e.toString());
        }
    }

    void startTransaction() {
        this.m_events = new ArrayList();
    }

    void commitTransaction() {
        this.m_events = null;
    }

    void rollBackTransaction() {
        ArrayList events = this.m_events;
        this.m_events = null;
        try {
            for (int i = events.size() - 1; i >= 0; --i) {
                Object event = events.get(i);
                if (event instanceof EntityName) {
                    this.remove((EntityName)event);
                    continue;
                }
                IIdentity id = (IIdentity)event;
                EntityName name = new EntityName(id.getName());
                if (id instanceof IElementIdentity) {
                    this.addElement(new EntityName(id.getName()), (IElementIdentity)id);
                    continue;
                }
                this.addDirectory(new EntityName(id.getName()));
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e.toString());
        }
    }

    IDirElement wrapAsElement(String elementName) {
        try {
            IDirElement cacheElement = ElementFactory.createElement((String)elementName, (String)"idCache", (String)"100");
            IAttributeSet attributes = cacheElement.getAttributes();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream objectOut = new ObjectOutputStream(out);
            objectOut.writeObject(this.m_root);
            byte[] bytes = out.toByteArray();
            objectOut.close();
            attributes.setBytesAttribute(CACHE_DATA_ATT, bytes);
            return (IDirElement)cacheElement.doneUpdate();
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new Error(e);
        }
    }

    static IDirElement createEmptyForOnlineBackup(String elementName) {
        try {
            IDirElement cacheElement = ElementFactory.createElement((String)elementName, (String)"idCache", (String)"100");
            IAttributeSet attributes = cacheElement.getAttributes();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream objectOut = new ObjectOutputStream(out);
            objectOut.writeObject(new HashMap());
            byte[] bytes = out.toByteArray();
            objectOut.close();
            attributes.setBytesAttribute(CACHE_DATA_ATT, bytes);
            return (IDirElement)cacheElement.doneUpdate();
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new Error(e);
        }
    }

    boolean isEmpty() {
        return this.m_root.isEmpty();
    }

    private void buildDir(String dirName) throws DirectoryServiceException {
        try {
            IIdentity[] ids = this.m_storage.listAll(new EntityName(dirName));
            for (int i = 0; i < ids.length; ++i) {
                if (ids[i] == null) continue;
                if (ids[i] instanceof IElementIdentity) {
                    this.addElement(new EntityName(ids[i].getName()), (IElementIdentity)ids[i]);
                    continue;
                }
                String subDirName = ids[i].getName();
                this.addDirectory(new EntityName(subDirName));
                this.buildDir(subDirName);
            }
        }
        catch (ConfigException e) {
            throw new Error(e.toString());
        }
        catch (StorageException e) {
            throw new Error(e.toString());
        }
    }

    void addElement(EntityName name, IElementIdentity id) throws DirectoryServiceException {
        this.addEntity(name, id);
    }

    void addDirectory(EntityName name) throws DirectoryServiceException {
        this.addEntity(name, new HashMap());
    }

    private void addEntity(EntityName name, Object entity) throws DirectoryServiceException {
        Object oldEntity = this.getParentDirectory(name).put(name.getBaseName(), entity);
        if (this.m_events != null) {
            if (oldEntity == null) {
                this.m_events.add(name);
            } else if (oldEntity instanceof IElementIdentity) {
                this.m_events.add(oldEntity);
            }
        }
    }

    void remove(EntityName name) throws DirectoryServiceException {
        Object entity = this.getParentDirectory(name).remove(name.getBaseName());
        if (this.m_events == null) {
            return;
        }
        if (entity instanceof IElementIdentity) {
            this.m_events.add(entity);
        } else {
            this.m_events.add(new DirIdentity(name.getName()));
        }
    }

    IIdentity get(EntityName name) throws DirectoryServiceException {
        if (name.isRoot()) {
            return new DirIdentity(name.getName());
        }
        Object node = this.getParentDirectory(name).get(name.getBaseName());
        if (node == null) {
            return null;
        }
        if (node instanceof HashMap) {
            return new DirIdentity(name.getName());
        }
        return (IIdentity)node;
    }

    IIdentity[] list(EntityName dirName, boolean directories, boolean elements) throws DirectoryServiceException {
        Object dirObject = this.entityForComponents(this.m_root, dirName.getNameComponents());
        if (dirObject == null) {
            throw new DirectoryDoesNotExistException("Directory '" + dirName.getName() + "' does not exist.");
        }
        if (!(dirObject instanceof HashMap)) {
            throw new DirectoryServiceException("'" + dirName.getName() + "' is not a directory.");
        }
        Iterator keys = ((HashMap)dirObject).keySet().iterator();
        ArrayList<Object> idObjects = new ArrayList<Object>();
        while (keys.hasNext()) {
            String currentKey = (String)keys.next();
            Object node = ((HashMap)dirObject).get(currentKey);
            if (node instanceof HashMap && directories) {
                idObjects.add(new DirIdentity(dirName.createKidName(currentKey)));
                continue;
            }
            if (!(node instanceof IElementIdentity) || !elements) continue;
            idObjects.add(node);
        }
        IIdentity[] ids = new IIdentity[idObjects.size()];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = (IIdentity)idObjects.get(i);
        }
        return ids;
    }

    private HashMap getParentDirectory(EntityName name) throws DirectoryServiceException {
        String[] parentComponents = name.getParentComponents();
        if (parentComponents == null) {
            throw new Error("Tried to get the parent of the root directory.");
        }
        Object lastInPath = this.entityForComponents(this.m_root, parentComponents);
        if (lastInPath == null || !(lastInPath instanceof HashMap)) {
            throw new DirectoryDoesNotExistException("Parent directory of '" + name.getName() + "' does not exist.");
        }
        return (HashMap)lastInPath;
    }

    private Object entityForComponents(HashMap initialDir, String[] components) throws DirectoryServiceException {
        if (components.length == 0) {
            return initialDir;
        }
        HashMap currentDir = initialDir;
        for (int i = 0; i < components.length; ++i) {
            Object nextInPath = currentDir.get(components[i]);
            if (i + 1 == components.length) {
                return nextInPath;
            }
            if (nextInPath == null || !(nextInPath instanceof HashMap)) {
                throw new DirectoryDoesNotExistException(components[i] + " not a directory.");
            }
            currentDir = (HashMap)nextInPath;
        }
        throw new Error();
    }
}

