/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.mtstorage.impl.BTreeNoteInterface;
import com.sonicsw.mtstorage.impl.BitUtil;
import com.sonicsw.mtstorage.impl.INoteWriter;
import com.sonicsw.mtstorage.impl.LogicalNote;
import java.io.IOException;

final class BTreePutLogicalNote
extends LogicalNote
implements BTreeNoteInterface {
    static final byte NOTE_TYPE = 57;
    private static final byte KEY_NULL = 1;
    private static final byte NEW_VALUE_NULL = 2;
    private static final byte HAS_OLD_VALUE = 4;
    private static final byte OLD_VALUE_NULL = 8;
    private static final byte VALUE_ALREADY_EXISTED = 16;
    private long m_treeDbk;
    private boolean m_keyNull;
    private byte[] m_key;
    private int m_keyLength;
    private int m_keyOffset;
    private boolean m_valueNull;
    private byte[] m_value;
    private int m_valueLength;
    private int m_valueOffset;
    private boolean m_hasOldValue;
    private boolean m_oldValueNull;
    private byte[] m_oldValue;
    private int m_oldValueLength;
    private int m_oldValueOffset;
    private boolean m_valueExisted;

    BTreePutLogicalNote() {
    }

    @Override
    byte getType() {
        return 57;
    }

    @Override
    public int writeNote(INoteWriter writer) throws IOException {
        writer.write(this.getType());
        writer.write((byte)(this.m_start ? 1 : 0));
        int noteLength = 2;
        if (!this.m_start) {
            byte flags = 0;
            if (this.m_keyNull) {
                flags = (byte)(flags | 1);
            }
            if (this.m_valueNull) {
                flags = (byte)(flags | 2);
            }
            if (this.m_hasOldValue) {
                flags = (byte)(flags | 4);
            }
            if (this.m_oldValueNull) {
                flags = (byte)(flags | 8);
            }
            if (this.m_valueExisted) {
                flags = (byte)(flags | 0x10);
            }
            writer.write(flags);
            ++noteLength;
            if (!this.m_keyNull) {
                BitUtil.putShort(this.m_scratchBuffer, 0, (short)this.m_keyLength);
                writer.write(this.m_scratchBuffer, 0, 2);
                noteLength += 2;
                writer.write(this.m_key, 0, this.m_keyLength);
                noteLength += this.m_keyLength;
            }
            if (!this.m_valueNull) {
                BitUtil.putShort(this.m_scratchBuffer, 0, (short)this.m_valueLength);
                writer.write(this.m_scratchBuffer, 0, 2);
                noteLength += 2;
                writer.write(this.m_value, 0, this.m_valueLength);
                noteLength += this.m_valueLength;
            }
            if (!this.m_oldValueNull && this.m_hasOldValue) {
                BitUtil.putShort(this.m_scratchBuffer, 0, (short)this.m_oldValueLength);
                writer.write(this.m_scratchBuffer, 0, 2);
                noteLength += 2;
                writer.write(this.m_oldValue, 0, this.m_oldValueLength);
                noteLength += this.m_oldValueLength;
            }
            BitUtil.putLong(this.m_scratchBuffer, 0, this.m_transactionNum);
            writer.write(this.m_scratchBuffer, 0, 8);
            noteLength += 8;
            BitUtil.putLong(this.m_scratchBuffer, 0, this.m_treeDbk);
            writer.write(this.m_scratchBuffer, 0, 8);
            noteLength += 8;
        }
        return noteLength;
    }

    @Override
    public void initNote(byte[] buffer, int offset) {
        int currentOffset = offset;
        boolean bl = this.m_start = buffer[currentOffset++] == 1;
        if (!this.m_start) {
            this.m_keyNull = (buffer[currentOffset] & 1) != 0;
            this.m_valueNull = (buffer[currentOffset] & 2) != 0;
            this.m_oldValueNull = (buffer[currentOffset] & 8) != 0;
            this.m_hasOldValue = (buffer[currentOffset] & 4) != 0;
            this.m_valueExisted = (buffer[currentOffset] & 0x10) != 0;
            ++currentOffset;
            if (!this.m_keyNull) {
                this.m_key = buffer;
                this.m_keyLength = BitUtil.getShort(buffer, currentOffset);
                this.m_keyOffset = currentOffset += 2;
                currentOffset += this.m_keyLength;
            }
            if (!this.m_valueNull) {
                this.m_value = buffer;
                this.m_valueLength = BitUtil.getShort(buffer, currentOffset);
                this.m_valueOffset = currentOffset += 2;
                currentOffset += this.m_valueLength;
            }
            if (!this.m_oldValueNull && this.m_hasOldValue) {
                this.m_oldValue = buffer;
                this.m_oldValueLength = BitUtil.getShort(buffer, currentOffset);
                this.m_oldValueOffset = currentOffset += 2;
                currentOffset += this.m_oldValueLength;
            }
            this.m_transactionNum = BitUtil.getLong(buffer, currentOffset);
            this.m_treeDbk = BitUtil.getLong(buffer, currentOffset += 8);
        } else {
            this.m_transactionNum = 0L;
            this.m_treeDbk = 0L;
        }
    }

    void initNote() {
        this.m_start = true;
    }

    void initNote(long transactionNum, long treeDbk, byte[] key, byte[] value, boolean hasOldValue, byte[] oldValue, boolean valueExisted) {
        this.m_transactionNum = transactionNum;
        this.m_start = false;
        this.m_treeDbk = treeDbk;
        this.m_keyNull = key == null;
        this.m_keyLength = key == null ? 0 : key.length;
        this.m_valueNull = value == null;
        this.m_valueLength = value == null ? 0 : value.length;
        this.m_hasOldValue = hasOldValue;
        this.m_oldValueNull = oldValue == null;
        this.m_oldValueLength = oldValue == null ? 0 : oldValue.length;
        this.m_key = key;
        this.m_value = value;
        this.m_oldValue = oldValue;
        this.m_valueExisted = valueExisted;
    }

    byte[] getKey() {
        if (this.m_keyNull) {
            return null;
        }
        return this.m_key;
    }

    int keyLength() {
        return this.m_keyLength;
    }

    int keyOffset() {
        return this.m_keyOffset;
    }

    byte[] getValue() {
        if (this.m_valueNull) {
            return null;
        }
        return this.m_value;
    }

    int valueLength() {
        return this.m_valueLength;
    }

    int valueOffset() {
        return this.m_valueOffset;
    }

    boolean hasOldValue() {
        return this.m_hasOldValue;
    }

    byte[] getOldValue() {
        if (this.m_oldValueNull) {
            return null;
        }
        return this.m_oldValue;
    }

    int oldValueLength() {
        return this.m_oldValueLength;
    }

    int oldValueOffset() {
        return this.m_oldValueOffset;
    }

    boolean valueExisted() {
        return this.m_valueExisted;
    }

    public long getBTreeDbk() {
        return this.m_treeDbk;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + " transaction: " + this.m_transactionNum + " start: " + this.m_start + " tree page: " + this.m_treeDbk;
    }
}

