/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.replication.ftchannel.blackbird;

import com.progress.blackbird.io.EIOException;
import com.progress.blackbird.io.EIOTimeoutException;
import com.progress.blackbird.io.IIOConnection;
import com.progress.blackbird.io.evs.IOMultiNetworkConnection;
import com.progress.blackbird.io.evs.IONetworkConnection;
import com.progress.blackbird.io.multi.IOMultiConnectionWeightedFlowBalancer;
import com.progress.blackbird.pdu.PDUPacketMultiConnectionPacketManager;
import com.progress.blackbird.pdu.PDUPacketNetworkConnectionPingPacketManager;
import com.progress.blackbird.pdu.PDUPacketSerializer;
import com.sonicsw.mtstorage.replication.ftchannel.ChannelConstants;
import com.sonicsw.mtstorage.replication.ftchannel.IActiveChannel;
import com.sonicsw.mtstorage.replication.ftchannel.IChannelListener;
import com.sonicsw.mtstorage.replication.ftchannel.IPassiveChannel;
import com.sonicsw.mtstorage.replication.ftchannel.blackbird.ActiveChannel;
import com.sonicsw.mtstorage.replication.util.Tracer;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.HashMap;

public class PassiveChannel
implements IPassiveChannel,
ChannelConstants {
    private String[] m_urls = null;
    private IONetworkConnection.Parameters[] m_urlConnectionParameters = null;
    private IIOConnection m_serverConnection = null;
    private volatile boolean m_interruptAccept = false;
    private boolean m_alwaysRetry = false;
    private boolean m_connOpen = false;
    private HashMap m_parameters = null;
    private boolean m_isPrimary;
    private boolean m_reportConnFailuers = true;
    private int[] m_connectionsByWeights;
    private AcceptLock m_acceptLock = new AcceptLock();

    public static void main(String[] args) throws Exception {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("HOST", args[0]);
        config.put("PORT", new Integer(args[1]));
        config.put("PROTOCOL", "tcp");
        HashMap[] configs = new HashMap[]{config};
        PassiveChannel pch = new PassiveChannel();
        pch.open(configs, null, false, false, true);
        IActiveChannel ach = pch.accept(new TestListener());
        Thread.sleep(1000000000L);
    }

    @Override
    public void open(HashMap[] connections, HashMap parameters, boolean alwaysRetry, boolean isPrimary, boolean reportConnFailuers) throws IOException {
        this.m_reportConnFailuers = reportConnFailuers;
        this.m_isPrimary = isPrimary;
        this.m_parameters = parameters;
        this.m_alwaysRetry = alwaysRetry;
        this.m_urls = new String[connections.length];
        this.m_urlConnectionParameters = new IONetworkConnection.Parameters[connections.length];
        for (int i = 0; i < this.m_urls.length; ++i) {
            this.m_urls[i] = PassiveChannel.mapToURL(connections[i], parameters, isPrimary, false);
            this.m_urlConnectionParameters[i] = ActiveChannel.createUrlConnectionParameters(parameters);
            Tracer.TRACE("PassiveChannel Accept on replication connection " + this.m_urls[i]);
        }
        this.m_connectionsByWeights = PassiveChannel.sortByWeight(connections);
    }

    @Override
    public void doNotReportFailure() {
        this.m_reportConnFailuers = false;
    }

    @Override
    public void interruptAccept() {
        this.m_interruptAccept = true;
        this.m_acceptLock.waitForOutOfAccept();
    }

    @Override
    public IActiveChannel accept(IChannelListener listener) throws IOException {
        try {
            ActiveChannel channel = new ActiveChannel();
            boolean loggedMessage = false;
            while (true) {
                try {
                    this.m_serverConnection = IOMultiNetworkConnection.create(false, this.m_urls, true, this.m_urlConnectionParameters, PDUPacketSerializer.create(), PDUPacketNetworkConnectionPingPacketManager.create(), channel, PDUPacketMultiConnectionPacketManager.create(), IOMultiConnectionWeightedFlowBalancer.create(), ActiveChannel.createParameters(this.m_parameters));
                    if (!this.m_reportConnFailuers || !loggedMessage) break;
                    System.out.println("...PSE replication: Binding succeded");
                }
                catch (EIOException e) {
                    if (this.m_interruptAccept) {
                        throw e;
                    }
                    if (e.toString().indexOf("Cannot assign requested address: bind") != -1) {
                        if (!loggedMessage && this.m_reportConnFailuers) {
                            String urlsString = "";
                            for (int i = 0; i < this.m_urls.length; ++i) {
                                urlsString = urlsString + this.m_urls[i] + " ";
                            }
                            System.out.println("PSE replication warning: Cannot bind to urls " + urlsString + ", retrying...");
                            loggedMessage = true;
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Exception e1) {}
                        continue;
                    }
                    throw e;
                }
                break;
            }
            this.m_connOpen = true;
            IIOConnection ioConn = null;
            this.m_acceptLock.inLoop();
            while (ioConn == null && !this.m_interruptAccept) {
                try {
                    ioConn = this.m_serverConnection.accept(1000);
                    Tracer.TRACE("PassiveChannel Accepted!");
                }
                catch (EIOTimeoutException e) {}
            }
            this.m_acceptLock.outOfLoop();
            if (this.m_interruptAccept) {
                if (ioConn != null) {
                    ioConn.close();
                }
                this.m_interruptAccept = false;
                throw new InterruptedIOException();
            }
            channel.open(ioConn, this.m_urls, this.m_connectionsByWeights, this.m_parameters, listener, this.m_alwaysRetry, this.m_isPrimary, this.m_reportConnFailuers);
            ActiveChannel activeChannel = channel;
            return activeChannel;
        }
        catch (EIOException e) {
            if (this.m_reportConnFailuers) {
                e.printStackTrace();
            }
            throw new IOException(e.getMessage());
        }
        finally {
            this.m_acceptLock.outOfLoop();
        }
    }

    @Override
    public void accepted() {
    }

    @Override
    public void close() {
        if (!this.m_connOpen) {
            return;
        }
        try {
            this.m_serverConnection.close();
            this.m_connOpen = false;
        }
        catch (Exception e) {
            Tracer.TRACE(e);
        }
    }

    static int[] sortByWeight(HashMap[] connMaps) {
        return PassiveChannel.orderByWeight(PassiveChannel.getWeights(connMaps));
    }

    private static int[] getWeights(HashMap[] connMaps) {
        int[] weights = new int[connMaps.length];
        for (int i = 0; i < connMaps.length; ++i) {
            weights[i] = (Integer)connMaps[i].get("WEIGHT");
        }
        return weights;
    }

    private static int[] orderByWeight(int[] weights) {
        ArrayList<WeightedIndex> byWeights = new ArrayList<WeightedIndex>();
        for (int i = 0; i < weights.length; ++i) {
            int insertedCount = byWeights.size();
            for (int j = 0; j < byWeights.size(); ++j) {
                WeightedIndex wIndex = (WeightedIndex)byWeights.get(j);
                if (wIndex.weight > weights[i]) continue;
                byWeights.add(j, new WeightedIndex(weights[i], i));
                break;
            }
            if (insertedCount != byWeights.size()) continue;
            byWeights.add(new WeightedIndex(weights[i], i));
        }
        int[] result = new int[weights.length];
        for (int i = 0; i < weights.length; ++i) {
            result[i] = ((WeightedIndex)byWeights.get((int)i)).index;
        }
        return result;
    }

    static String mapToURL(HashMap connMap, HashMap storageParameters, boolean isPrimary, boolean setLocalAddress) {
        String protocol = storageParameters != null ? (String)connMap.get("PROTOCOL") : "TCP";
        int weight = (Integer)connMap.get("WEIGHT");
        String host = (String)connMap.get("HOST");
        String myHost = (String)connMap.get("MY_HOST");
        if (!host.startsWith("[") && host.contains(":")) {
            host = "[" + host + "]";
        }
        String port = ((Integer)connMap.get("PORT")).toString();
        String url = protocol + "://" + host + ":" + port + "&weight=" + weight;
        if (setLocalAddress) {
            url = url + "&localifaddr=" + myHost;
        }
        if (storageParameters == null || !protocol.equalsIgnoreCase("ssl")) {
            return url;
        }
        HashMap sslParamsMap = (HashMap)storageParameters.get("REPLICATION_SSL");
        ArrayList sslParamList = PassiveChannel.getSSLParameters(sslParamsMap, isPrimary);
        for (int i = 0; i < sslParamList.size(); ++i) {
            url = url + "&" + (String)sslParamList.get(i);
        }
        return url;
    }

    private static ArrayList getSSLParameters(HashMap sslParameters, boolean isPrimary) {
        String trustStorePasswordAtt;
        String trustStorePassword;
        String keyStorePasswordAtt;
        String keyStorePassword;
        String trustStoreFileAtt;
        String trustStoreFile;
        String keyStoreFileAtt;
        String keyStoreFile;
        Integer closeTimeout;
        Integer handshakeTimeout;
        ArrayList<String> sslList = new ArrayList<String>();
        sslList.add("needClientAuth=true");
        if (sslParameters == null) {
            return sslList;
        }
        String cipherSuite = (String)sslParameters.get("CIPHER_SUITE");
        if (cipherSuite != null && cipherSuite.length() > 0) {
            sslList.add("cipherSuites=" + cipherSuite);
        }
        if ((handshakeTimeout = (Integer)sslParameters.get("HANDSHAKE_TIMEOUT")) != null) {
            sslList.add("handshakeTimeout=" + handshakeTimeout);
        }
        if ((closeTimeout = (Integer)sslParameters.get("CLOSE_TIMEOUT")) != null) {
            sslList.add("closeTimeout=" + closeTimeout);
        }
        if ((keyStoreFile = (String)sslParameters.get(keyStoreFileAtt = isPrimary ? "PRIMARY_KEY_STORE_FILE" : "BACKUP_KEY_STORE_FILE")) != null && keyStoreFile.length() > 0) {
            sslList.add("keyStoreFilename=" + keyStoreFile);
        }
        if ((trustStoreFile = (String)sslParameters.get(trustStoreFileAtt = isPrimary ? "PRIMARY_TRUST_STORE_FILE" : "BACKUP_TRUST_STORE_FILE")) != null && trustStoreFile.length() > 0) {
            sslList.add("trustStoreFilename=" + trustStoreFile);
        }
        if ((keyStorePassword = (String)sslParameters.get(keyStorePasswordAtt = isPrimary ? "PRIMARY_KEY_STORE_PASSWORD" : "BACKUP_KEY_STORE_PASSWORD")) != null && keyStorePassword.length() > 0) {
            sslList.add("keyStorePassword=" + keyStorePassword);
        }
        if ((trustStorePassword = (String)sslParameters.get(trustStorePasswordAtt = isPrimary ? "PRIMARY_TRUST_STORE_PASSWORD" : "BACKUP_TRUST_STORE_PASSWORD")) != null && trustStorePassword.length() > 0) {
            sslList.add("trustStorePassword=" + trustStorePassword);
        }
        return sslList;
    }

    private class AcceptLock {
        volatile boolean m_inAcceptLock = false;

        private AcceptLock() {
        }

        synchronized void inLoop() {
            this.m_inAcceptLock = true;
        }

        synchronized void outOfLoop() {
            this.m_inAcceptLock = false;
            this.notifyAll();
        }

        synchronized void waitForOutOfAccept() {
            while (this.m_inAcceptLock) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }
    }

    static class TestListener
    implements IChannelListener {
        TestListener() {
        }

        @Override
        public void connectionDropped(String message) {
            System.out.println("connectionDropped: " + message);
        }

        @Override
        public void reportEvent(String event, boolean warning) {
            System.out.println("reportEvent: " + event);
        }

        @Override
        public void messageReceived(byte[] message) {
            System.out.println("messageReceived: " + message.length + " bytes ");
        }
    }

    private static class WeightedIndex {
        int weight;
        int index;

        WeightedIndex(int w, int i) {
            this.weight = w;
            this.index = i;
        }
    }
}

