/*
 * Decompiled with CFR 0.152.
 */
package com.odi.imp;

import com.odi.FatalInternalException;
import com.odi.imp.ByteIterator;
import com.odi.imp.Cluster;
import com.odi.imp.GenericObject;
import com.odi.imp.JavaPrimInfo;
import com.odi.imp.ObjRefUtils;
import com.odi.imp.ObjectManager;
import com.odi.imp.ObjectReference;
import com.odi.imp.Reference;
import com.odi.imp.ReferenceType;
import com.odi.imp.Server;
import com.odi.imp.TypeCodeConstants;
import com.odi.imp.Utilities;
import java.util.NoSuchElementException;

public abstract class ObjectAccess
implements TypeCodeConstants {
    public static final byte byteSize = 1;
    public static final byte charSize = 2;
    public static final byte shortSize = 2;
    public static final byte intSize = 4;
    public static final byte longSize = 8;
    public static final byte floatSize = 4;
    public static final byte doubleSize = 8;
    public static final byte booleanSize = 1;
    public byte referenceSize;
    private boolean sessionUsesImmediateStrings;

    protected ObjectAccess(Server sv, boolean useImmediateStringsDefault) {
        this.sessionUsesImmediateStrings = Boolean.valueOf(sv.om.getProperty("com.odi.useImmediateStrings", useImmediateStringsDefault ? "true" : "false"));
    }

    public abstract long decodeObjRefLocation(byte[] var1, int var2);

    public abstract int decodeObjRefDatabaseId(byte[] var1, int var2);

    public abstract int decodeObjRefSegmentId(byte[] var1, int var2);

    public abstract int decodeObjRefClusterId(byte[] var1, int var2);

    public abstract boolean isNull(byte[] var1, int var2);

    public abstract boolean isImmediateObject(byte[] var1, int var2);

    public abstract boolean isImmediateString(byte[] var1, int var2);

    public abstract int decodeObjRefTypeCode(byte[] var1, int var2);

    public abstract int decodeObjRefArrayElementCount(byte[] var1, int var2);

    public abstract byte decodeImmByteRef(byte[] var1, int var2);

    public abstract char decodeImmCharRef(byte[] var1, int var2);

    public abstract short decodeImmShortRef(byte[] var1, int var2);

    public abstract int decodeImmIntegerRef(byte[] var1, int var2);

    public abstract long decodeImmLongRef(byte[] var1, int var2);

    public abstract float decodeImmFloatRef(byte[] var1, int var2);

    public abstract double decodeImmDoubleRef(byte[] var1, int var2);

    public abstract boolean decodeImmBooleanRef(byte[] var1, int var2);

    public abstract String decodeImmStringRef(byte[] var1, int var2);

    public final boolean isImmRefEncodable(Object object, boolean useImmediateStrings) {
        if (object instanceof String) {
            return this.sessionUsesImmediateStrings && useImmediateStrings && this.isImmRefEncodable((String)object);
        }
        JavaPrimInfo primInfo = Utilities.findPrimitiveWrapperInfo(object);
        return primInfo != null && this.isImmRefEncodable(primInfo.typeCode);
    }

    protected abstract boolean isImmRefEncodable(int var1);

    protected abstract boolean isImmRefEncodable(String var1);

    public abstract void encodeImmByteRef(byte[] var1, int var2, byte var3);

    public abstract void encodeImmCharRef(byte[] var1, int var2, char var3);

    public abstract void encodeImmShortRef(byte[] var1, int var2, short var3);

    public abstract void encodeImmIntegerRef(byte[] var1, int var2, int var3);

    public abstract void encodeImmLongRef(byte[] var1, int var2, long var3);

    public abstract void encodeImmFloatRef(byte[] var1, int var2, float var3);

    public abstract void encodeImmDoubleRef(byte[] var1, int var2, double var3);

    public abstract void encodeImmBooleanRef(byte[] var1, int var2, boolean var3);

    public abstract void encodeImmStringRef(byte[] var1, int var2, String var3);

    public abstract void encodeObjRef(byte[] var1, int var2, ObjectReference var3);

    public abstract void encodeNull(byte[] var1, int var2);

    public static byte decodeByte(byte[] buffer, int startIndex) {
        return buffer[startIndex];
    }

    public static char decodeChar(byte[] buffer, int startIndex) {
        return (char)ObjectAccess.decodeShort(buffer, startIndex);
    }

    public static short decodeShort(byte[] buffer, int startIndex) {
        return (short)(buffer[startIndex] << 8 | buffer[startIndex + 1] & 0xFF);
    }

    public static int decodeInt(byte[] buffer, int i) {
        return buffer[i] << 24 | (buffer[i + 1] & 0xFF) << 16 | (buffer[i + 2] & 0xFF) << 8 | buffer[i + 3] & 0xFF;
    }

    public static int decode3ByteInt(byte[] buffer, int i) {
        return buffer[i] << 16 | (buffer[i + 1] & 0xFF) << 8 | buffer[i + 2] & 0xFF;
    }

    public static long decodeLong(byte[] buffer, int i) {
        return (long)ObjectAccess.decodeInt(buffer, i) << 32 | 0xFFFFFFFFL & (long)ObjectAccess.decodeInt(buffer, i + 4);
    }

    public static float decodeFloat(byte[] buffer, int startIndex) {
        return Float.intBitsToFloat(ObjectAccess.decodeInt(buffer, startIndex));
    }

    public static double decodeDouble(byte[] buffer, int startIndex) {
        return Double.longBitsToDouble(ObjectAccess.decodeLong(buffer, startIndex));
    }

    public static boolean decodeBoolean(byte[] buffer, int startIndex) {
        return buffer[startIndex] != 0;
    }

    public static void encodeByte(byte[] buffer, int startIndex, byte value) {
        buffer[startIndex] = value;
    }

    public static void encodeChar(byte[] buffer, int startIndex, char value) {
        ObjectAccess.encodeShort(buffer, startIndex, (short)value);
    }

    public static void encodeShort(byte[] buffer, int startIndex, short value) {
        buffer[startIndex++] = (byte)(value >>> 8);
        buffer[startIndex] = (byte)value;
    }

    public static void encodeInt(byte[] buffer, int startIndex, int value) {
        buffer[startIndex++] = (byte)(value >>> 24);
        buffer[startIndex++] = (byte)(value >>> 16);
        buffer[startIndex++] = (byte)(value >>> 8);
        buffer[startIndex] = (byte)value;
    }

    protected static void encodeIntZero(byte[] buffer, int startIndex) {
        buffer[startIndex + 3] = 0;
        buffer[startIndex + 2] = 0;
        buffer[startIndex + 1] = 0;
        buffer[startIndex] = 0;
    }

    protected static void encodeIntMinusOne(byte[] buffer, int startIndex) {
        buffer[startIndex + 3] = -1;
        buffer[startIndex + 2] = -1;
        buffer[startIndex + 1] = -1;
        buffer[startIndex] = -1;
    }

    public static void encode3ByteInt(byte[] buffer, int startIndex, int v) {
        buffer[startIndex++] = (byte)(v >>> 16);
        buffer[startIndex++] = (byte)(v >>> 8);
        buffer[startIndex] = (byte)v;
    }

    public static void encodeLong(byte[] buffer, int startIndex, long value) {
        ObjectAccess.encodeInt(buffer, startIndex, (int)(value >>> 32));
        ObjectAccess.encodeInt(buffer, startIndex + 4, (int)value);
    }

    public static void encodeFloat(byte[] buffer, int startIndex, float value) {
        ObjectAccess.encodeInt(buffer, startIndex, Float.floatToIntBits(value));
    }

    public static void encodeDouble(byte[] buffer, int startIndex, double value) {
        ObjectAccess.encodeLong(buffer, startIndex, Double.doubleToLongBits(value));
    }

    public static void encodeBoolean(byte[] buffer, int startIndex, boolean value) {
        buffer[startIndex] = value ? (byte)1 : 0;
    }

    void decodeArrayContents(GenericObject genObj, int startIndex, Object array) {
        Class<?> elementType = array.getClass().getComponentType();
        if (elementType == Byte.TYPE) {
            ObjectAccess.decodeByteArray(genObj, startIndex, (byte[])array);
        } else if (elementType == Character.TYPE) {
            ObjectAccess.decodeCharArray(genObj, startIndex, (char[])array);
        } else if (elementType == Short.TYPE) {
            ObjectAccess.decodeShortArray(genObj, startIndex, (short[])array);
        } else if (elementType == Integer.TYPE) {
            ObjectAccess.decodeIntArray(genObj, startIndex, (int[])array);
        } else if (elementType == Long.TYPE) {
            ObjectAccess.decodeLongArray(genObj, startIndex, (long[])array);
        } else if (elementType == Float.TYPE) {
            ObjectAccess.decodeFloatArray(genObj, startIndex, (float[])array);
        } else if (elementType == Double.TYPE) {
            ObjectAccess.decodeDoubleArray(genObj, startIndex, (double[])array);
        } else if (elementType == Boolean.TYPE) {
            ObjectAccess.decodeBooleanArray(genObj, startIndex, (boolean[])array);
        } else if (elementType == Reference.class) {
            ObjectAccess.decodeReferenceArray(genObj, startIndex, (Reference[])array);
        } else {
            this.decodeObjectReferenceArray(genObj, startIndex, (Object[])array);
        }
    }

    void decodeReferenceArrayContents(GenericObject genObj, int startIndex, Reference[] array, ReferenceType refType) {
        ObjectAccess.decodeReferenceArray(genObj, startIndex, array, refType);
    }

    void decodeArrayContents(GenericObject genObj, Object array) {
        this.decodeArrayContents(genObj, 0, array);
    }

    void decodeReferenceArrayContents(GenericObject genObj, Reference[] array, ReferenceType refType) {
        this.decodeReferenceArrayContents(genObj, 0, array, refType);
    }

    private static void decodeByteArray(GenericObject object, int startIndex, byte[] value) {
        if (value.length == 0) {
            return;
        }
        System.arraycopy(object.rep, startIndex + 1, value, 1, value.length - 1);
        value[0] = object.rep[startIndex];
    }

    private static void decodeCharArray(GenericObject object, int startIndex, char[] value) {
        int max = value.length;
        if (max == 0) {
            return;
        }
        byte[] rep = object.rep;
        int elem0 = startIndex;
        startIndex += 2;
        int i = 1;
        while (i < max) {
            value[i] = ObjectAccess.decodeChar(rep, startIndex);
            ++i;
            startIndex += 2;
        }
        value[0] = ObjectAccess.decodeChar(rep, elem0);
    }

    private static void decodeShortArray(GenericObject object, int startIndex, short[] value) {
        int max = value.length;
        if (max == 0) {
            return;
        }
        byte[] rep = object.rep;
        int elem0 = startIndex;
        startIndex += 2;
        int i = 1;
        while (i < max) {
            value[i] = ObjectAccess.decodeShort(rep, startIndex);
            ++i;
            startIndex += 2;
        }
        value[0] = ObjectAccess.decodeShort(rep, elem0);
    }

    private static void decodeIntArray(GenericObject object, int startIndex, int[] value) {
        int max = value.length;
        if (max == 0) {
            return;
        }
        byte[] rep = object.rep;
        int elem0 = startIndex;
        startIndex += 4;
        int i = 1;
        while (i < max) {
            value[i] = ObjectAccess.decodeInt(rep, startIndex);
            ++i;
            startIndex += 4;
        }
        value[0] = ObjectAccess.decodeInt(rep, elem0);
    }

    private static void decodeReferenceArray(GenericObject object, int startIndex, Reference[] value) {
        int max = value.length;
        if (max == 0) {
            return;
        }
        byte[] rep = object.rep;
        int elem0 = startIndex;
        ReferenceType refType = ReferenceType.getReferenceType(value.getClass().getComponentType());
        startIndex += refType.size();
        int i = 1;
        while (i < max) {
            value[i] = refType.decode(rep, startIndex);
            ++i;
            startIndex += refType.size();
        }
        value[0] = refType.decode(rep, elem0);
    }

    private static void decodeReferenceArray(GenericObject object, int startIndex, Reference[] value, ReferenceType refType) {
        int max = value.length;
        if (max == 0) {
            return;
        }
        byte[] rep = object.rep;
        int elem0 = startIndex;
        startIndex += refType.size();
        int i = 1;
        while (i < max) {
            value[i] = refType.decode(rep, startIndex);
            ++i;
            startIndex += refType.size();
        }
        value[0] = refType.decode(rep, elem0);
    }

    private static void decodeLongArray(GenericObject object, int startIndex, long[] value) {
        int max = value.length;
        if (max == 0) {
            return;
        }
        byte[] rep = object.rep;
        int elem0 = startIndex;
        startIndex += 8;
        int i = 1;
        while (i < max) {
            value[i] = ObjectAccess.decodeLong(rep, startIndex);
            ++i;
            startIndex += 8;
        }
        value[0] = ObjectAccess.decodeLong(rep, elem0);
    }

    private static void decodeFloatArray(GenericObject object, int startIndex, float[] value) {
        int max = value.length;
        if (max == 0) {
            return;
        }
        byte[] rep = object.rep;
        int elem0 = startIndex;
        startIndex += 4;
        int i = 1;
        while (i < max) {
            value[i] = ObjectAccess.decodeFloat(rep, startIndex);
            ++i;
            startIndex += 4;
        }
        value[0] = ObjectAccess.decodeFloat(rep, elem0);
    }

    private static void decodeDoubleArray(GenericObject object, int startIndex, double[] value) {
        int max = value.length;
        if (max == 0) {
            return;
        }
        byte[] rep = object.rep;
        int elem0 = startIndex;
        startIndex += 8;
        int i = 1;
        while (i < max) {
            value[i] = ObjectAccess.decodeDouble(rep, startIndex);
            ++i;
            startIndex += 8;
        }
        value[0] = ObjectAccess.decodeDouble(rep, elem0);
    }

    private static void decodeBooleanArray(GenericObject object, int startIndex, boolean[] value) {
        int max = value.length;
        if (max == 0) {
            return;
        }
        byte[] rep = object.rep;
        int elem0 = startIndex++;
        int i = 1;
        while (i < max) {
            value[i] = ObjectAccess.decodeBoolean(rep, startIndex);
            ++i;
            ++startIndex;
        }
        value[0] = ObjectAccess.decodeBoolean(rep, elem0);
    }

    private void decodeObjectReferenceArray(GenericObject object, int startIndex, Object[] value) {
        ObjectManager om = ObjectManager.assureCurrent();
        int max = value.length;
        if (max == 0) {
            return;
        }
        byte[] rep = object.rep;
        int elem0 = startIndex;
        startIndex += this.referenceSize;
        int i = 1;
        while (i < max) {
            value[i] = om.getJavaReference(rep, startIndex);
            ++i;
            startIndex += this.referenceSize;
        }
        value[0] = om.getJavaReference(rep, elem0);
    }

    static String printBytes(byte[] rep) {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < rep.length; ++i) {
            buff.append(Integer.toHexString(rep[i] & 0xFF));
            buff.append(" ");
        }
        return buff.toString();
    }

    void encodeArrayContents(GenericObject genObj, int startIndex, Object array) {
        Class<?> elementType = array.getClass().getComponentType();
        if (elementType == Byte.TYPE) {
            ObjectAccess.encodeByteArray(genObj, startIndex, (byte[])array);
        } else if (elementType == Character.TYPE) {
            ObjectAccess.encodeCharArray(genObj, startIndex, (char[])array);
        } else if (elementType == Short.TYPE) {
            ObjectAccess.encodeShortArray(genObj, startIndex, (short[])array);
        } else if (elementType == Integer.TYPE) {
            ObjectAccess.encodeIntArray(genObj, startIndex, (int[])array);
        } else if (elementType == Long.TYPE) {
            ObjectAccess.encodeLongArray(genObj, startIndex, (long[])array);
        } else if (elementType == Float.TYPE) {
            ObjectAccess.encodeFloatArray(genObj, startIndex, (float[])array);
        } else if (elementType == Double.TYPE) {
            ObjectAccess.encodeDoubleArray(genObj, startIndex, (double[])array);
        } else if (elementType == Boolean.TYPE) {
            ObjectAccess.encodeBooleanArray(genObj, startIndex, (boolean[])array);
        } else if (elementType == Reference.class) {
            ObjectAccess.encodeReferenceArray(genObj, startIndex, (Reference[])array);
        } else {
            this.encodeObjectReferenceArray(genObj, startIndex, (Object[])array);
        }
    }

    void encodeArrayContents(GenericObject genObj, Object array) {
        this.encodeArrayContents(genObj, 0, array);
    }

    void encodeReferenceArrayContents(GenericObject genObj, int startIndex, Reference[] array, ReferenceType refType) {
        ObjectAccess.encodeReferenceArray(genObj, startIndex, array, refType);
    }

    void encodeReferenceArrayContents(GenericObject genObj, Reference[] array, ReferenceType refType) {
        this.encodeReferenceArrayContents(genObj, 0, array, refType);
    }

    private static void encodeByteArray(GenericObject object, int startIndex, byte[] value) {
        System.arraycopy(value, 0, object.rep, startIndex, value.length);
    }

    private static void encodeCharArray(GenericObject object, int startIndex, char[] value) {
        int max = value.length;
        byte[] rep = object.rep;
        int i = 0;
        while (i < max) {
            ObjectAccess.encodeChar(rep, startIndex, value[i]);
            ++i;
            startIndex += 2;
        }
    }

    private static void encodeShortArray(GenericObject object, int startIndex, short[] value) {
        int max = value.length;
        byte[] rep = object.rep;
        int i = 0;
        while (i < max) {
            ObjectAccess.encodeShort(rep, startIndex, value[i]);
            ++i;
            startIndex += 2;
        }
    }

    private static void encodeIntArray(GenericObject object, int startIndex, int[] value) {
        int max = value.length;
        byte[] rep = object.rep;
        int i = 0;
        while (i < max) {
            ObjectAccess.encodeInt(rep, startIndex, value[i]);
            ++i;
            startIndex += 4;
        }
    }

    private static void encodeReferenceArray(GenericObject object, int startIndex, Reference[] value) {
        int max = value.length;
        if (max == 0) {
            return;
        }
        ReferenceType refType = value[0].REFTYPE();
        byte[] rep = object.rep;
        int i = 0;
        while (i < max) {
            refType.encode(rep, startIndex, value[i]);
            ++i;
            startIndex += refType.size();
        }
    }

    private static void encodeReferenceArray(GenericObject object, int startIndex, Reference[] value, ReferenceType refType) {
        int max = value.length;
        byte[] rep = object.rep;
        int i = 0;
        while (i < max) {
            refType.encode(rep, startIndex, value[i]);
            ++i;
            startIndex += refType.size();
        }
    }

    private static void encodeLongArray(GenericObject object, int startIndex, long[] value) {
        int max = value.length;
        byte[] rep = object.rep;
        int i = 0;
        while (i < max) {
            ObjectAccess.encodeLong(rep, startIndex, value[i]);
            ++i;
            startIndex += 8;
        }
    }

    private static void encodeFloatArray(GenericObject object, int startIndex, float[] value) {
        int max = value.length;
        byte[] rep = object.rep;
        int i = 0;
        while (i < max) {
            ObjectAccess.encodeFloat(rep, startIndex, value[i]);
            ++i;
            startIndex += 4;
        }
    }

    private static void encodeDoubleArray(GenericObject object, int startIndex, double[] value) {
        int max = value.length;
        byte[] rep = object.rep;
        int i = 0;
        while (i < max) {
            ObjectAccess.encodeDouble(rep, startIndex, value[i]);
            ++i;
            startIndex += 8;
        }
    }

    private static void encodeBooleanArray(GenericObject object, int startIndex, boolean[] value) {
        int max = value.length;
        byte[] rep = object.rep;
        int i = 0;
        while (i < max) {
            ObjectAccess.encodeBoolean(rep, startIndex, value[i]);
            ++i;
            ++startIndex;
        }
    }

    private void encodeObjectReferenceArray(GenericObject object, int startIndex, Object[] value) {
        ObjectManager om = ObjectManager.assureCurrent();
        Cluster cluster = ObjRefUtils.getCluster(object.objRef);
        int max = value.length;
        byte[] rep = object.rep;
        int i = 0;
        while (i < max) {
            om.putJavaReference(rep, startIndex, value[i], cluster, true);
            ++i;
            startIndex += this.referenceSize;
        }
    }

    public boolean isRawLocation(byte[] buffer, int offset) {
        return this.decodeObjRefTypeCode(buffer, offset) == 16;
    }

    public static int UTF8Length(char[] chars, int strlen) {
        int encodedLength = 0;
        for (int i = 0; i < strlen; ++i) {
            char c = chars[i];
            if (c >= '\u0001' && c <= '\u007f') {
                ++encodedLength;
                continue;
            }
            encodedLength += c > '\u07ff' ? 3 : 2;
        }
        return encodedLength;
    }

    public static int encodeString(byte[] rep, int offset, char[] chars, int strlen) {
        for (int i = 0; i < strlen; ++i) {
            char c = chars[i];
            if (c >= '\u0001' && c <= '\u007f') {
                rep[offset++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                rep[offset++] = (byte)(0xE0 | c >> 12 & 0xF);
                rep[offset++] = (byte)(0x80 | c >> 6 & 0x3F);
                rep[offset++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            rep[offset++] = (byte)(0xC0 | c >> 6 & 0x1F);
            rep[offset++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
        return offset;
    }

    public static String decodeString(byte[] rep, int start, int utflen, char[] charBuffer) {
        int strlen = 0;
        int max = start + utflen;
        int i = start;
        block5: while (i < max) {
            byte c1;
            if ((0x80 & (c1 = rep[i++])) == 0) {
                charBuffer[strlen++] = (char)(c1 & 0x7F);
                continue;
            }
            switch ((c1 & 0xFF) >>> 4) {
                case 12: 
                case 13: {
                    byte c2;
                    if (i >= max) {
                        throw new FatalInternalException("Invalid UTF8 encoding.  Encountered a truncated utf8 string.");
                    }
                    if (((c2 = rep[i++]) & 0xC0) != 128) {
                        throw new FatalInternalException("Invalid UTF8 encoding.  Incorrect trailer byte encoding.");
                    }
                    charBuffer[strlen++] = (char)((c1 & 0x1F) << 6 | c2 & 0x3F);
                    continue block5;
                }
                case 14: {
                    if (i + 1 >= max) {
                        throw new FatalInternalException("Invalid UTF8 encoding");
                    }
                    byte c2 = rep[i++];
                    byte c3 = rep[i++];
                    if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128) {
                        throw new FatalInternalException("Invalid UTF8 encoding.  Incorrect trailer byte encoding.");
                    }
                    charBuffer[strlen++] = (char)((c1 & 0xF) << 12 | (c2 & 0x3F) << 6 | (c3 & 0x3F) << 0);
                    continue block5;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    throw new FatalInternalException("Invalid UTF8 encoding.  Out of sequence trailer byte encountered.");
                }
            }
            throw new FatalInternalException("Invalid UTF8 encoding. A byte encoding exceeding three bytes was detected.");
        }
        return new String(charBuffer, 0, strlen);
    }

    public static char decodeUTF8Bytes(ByteIterator bytes) {
        byte c1 = bytes.next();
        if ((0x80 & c1) == 0) {
            return (char)(c1 & 0x7F);
        }
        switch ((c1 & 0xFF) >>> 4) {
            case 12: 
            case 13: {
                try {
                    byte c2 = bytes.next();
                    if ((c2 & 0xC0) != 128) {
                        throw new FatalInternalException("Invalid UTF8 encoding.  Incorrect trailer byte encoding.");
                    }
                    return (char)((c1 & 0x1F) << 6 | c2 & 0x3F);
                }
                catch (NoSuchElementException e) {
                    throw new FatalInternalException("Invalid UTF8 encoding.  Encountered a truncated utf8 string.");
                }
            }
            case 14: {
                try {
                    byte c2 = bytes.next();
                    byte c3 = bytes.next();
                    if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128) {
                        throw new FatalInternalException("Invalid UTF8 encoding.  Incorrect trailer byte encoding.");
                    }
                    return (char)((c1 & 0xF) << 12 | (c2 & 0x3F) << 6 | (c3 & 0x3F) << 0);
                }
                catch (NoSuchElementException e) {
                    throw new FatalInternalException("Invalid UTF8 encoding");
                }
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                throw new FatalInternalException("Invalid UTF8 encoding.  Out of sequence trailer byte encountered.");
            }
        }
        throw new FatalInternalException("Invalid UTF8 encoding. A byte encoding exceeding three bytes was detected.");
    }

    public int arrayElementSize(int AFTypeCode) {
        int elementTypeCode = Utilities.arrayElementTypeCode(AFTypeCode);
        return Utilities.isPrimitiveTypeCode(elementTypeCode) && Utilities.arrayDimensions(AFTypeCode) == 1 ? Utilities.primitiveLinearRepSize(elementTypeCode) : this.referenceSize;
    }
}

