/*
 * Decompiled with CFR 0.152.
 */
package com.odi.imp;

import com.odi.imp.Database;
import com.odi.imp.MutatingObjRef;
import com.odi.imp.ObjectReference;
import com.odi.imp.Segment;
import com.odi.imp.Utilities;
import com.odi.util.BitSet;
import java.util.NoSuchElementException;

public class SegmentObjectReferenceEnumeration {
    private Segment segment;
    private int refSize;
    private byte[] buffer;
    private int position;
    private int length;
    private MutatingObjRef last = null;
    private BitSet AFTs = null;
    private int[] sizes = null;
    private Class ofType = null;
    private boolean isUserDefinedType;
    private boolean hasAdvanced;
    private int schemaClassCount;

    public SegmentObjectReferenceEnumeration(Segment segment) {
        this(segment, null);
    }

    public SegmentObjectReferenceEnumeration(Segment segment, Class ofType) {
        Database db = (Database)segment.getDatabase();
        this.segment = segment;
        if (ofType != null) {
            this.ofType = ofType;
            this.isUserDefinedType = Utilities.isUserDefinedType(ofType);
            this.AFTs = segment.om.schemaManager.getAFTSubClasses(ofType, db);
            this.schemaClassCount = db.serverGetSchemaClassCount();
            if (!ofType.isArray() && ofType != String.class) {
                this.sizes = segment.om.schemaManager.getAFTSizes(this.AFTs);
            }
        }
        this.refSize = segment.om.objectAccess.referenceSize;
        this.buffer = new byte[segment.serverGetObjectsBufferSize() * this.refSize];
        this.position = -this.refSize;
        this.hasAdvanced = false;
    }

    public boolean hasMoreElements() {
        if (!this.hasAdvanced) {
            this.advance();
            this.hasAdvanced = true;
        }
        return this.buffer != null;
    }

    public ObjectReference nextElement() {
        if (!this.hasMoreElements()) {
            throw new NoSuchElementException("No more objects.");
        }
        this.last = this.segment.om.objRefFactory.createMutating(this.buffer, this.position);
        this.advance();
        return this.last;
    }

    private void advance() {
        Database db;
        int newSchemaClassCount;
        if (this.ofType != null && this.isUserDefinedType && this.schemaClassCount != (newSchemaClassCount = (db = (Database)this.segment.getDatabase()).serverGetSchemaClassCount())) {
            this.segment.om.schemaManager.extendAFTSubClasses(this.ofType, this.AFTs, db);
            this.schemaClassCount = newSchemaClassCount;
            if (!this.ofType.isArray() && this.ofType != String.class) {
                this.sizes = this.segment.om.schemaManager.getAFTSizes(this.AFTs);
            }
        }
        this.position += this.refSize;
        if (this.position < this.length) {
            return;
        }
        int nObjects = this.ofType == null ? this.segment.serverGetObjects(this.buffer, this.last) : this.segment.serverGetObjects(this.buffer, this.last, this.AFTs, this.sizes, this.ofType.isArray());
        if (nObjects == 0) {
            this.buffer = null;
            return;
        }
        this.length = nObjects * this.refSize;
        this.position = 0;
    }
}

