/*
 * Decompiled with CFR 0.152.
 */
package com.odi.imp.mtsonic;

import com.odi.FatalInternalException;
import com.odi.NoTransactionInProgressException;
import com.odi.ObjectStoreException;
import com.odi.TransactionInProgressException;
import com.odi.UpdateReadOnlyException;
import com.odi.imp.ObjectManager;
import com.odi.imp.mtsonic.Server;
import java.io.IOException;

public final class Transaction
extends com.odi.imp.Transaction {
    Server sv;
    long currentTransactionId;

    @Override
    public void serverBegin() {
        try {
            this.sv.objectTable.begin(this.type);
        }
        catch (IOException e) {
            this.sv.IOFailure(e);
        }
        this.currentTransactionId = this.sv.allocateTransactionId();
    }

    @Override
    public void serverAfterBegin() {
        if (this.sv.currentDatabase != null) {
            this.sv.currentDatabase.makeInUse();
        }
    }

    @Override
    public boolean serverPrepare() {
        throw new ObjectStoreException("two phase commit is not implemented");
    }

    @Override
    public void serverCommit(boolean onePhase) {
        if (!onePhase) {
            this.serverPrepare();
        }
        try {
            this.sv.objectTable.commit();
        }
        catch (IOException e) {
            this.sv.IOFailure(e);
        }
    }

    @Override
    public void serverAbort() {
        try {
            this.sv.objectTable.abort();
        }
        catch (IOException e) {
            throw new FatalInternalException("IOException inside abort");
        }
    }

    @Override
    public void serverCheckpoint() {
        this.serverCommit(true);
    }

    @Override
    public void serverAfterCheckpoint() {
        this.serverBegin();
        this.serverAfterBegin();
    }

    @Override
    public boolean serverHasLockContention() {
        return false;
    }

    @Override
    public long getCurrentTransactionId() {
        return this.currentTransactionId;
    }

    Transaction(Server sv, int type, ObjectManager om) {
        super(type, om);
        this.sv = sv;
    }

    static void assureNone(String operationName) {
        if (Transaction.inTransaction()) {
            throw new TransactionInProgressException("Attempt to " + operationName + " with a transaction in progress.");
        }
    }

    static void assure(String operationName) {
        if (!Transaction.inTransaction()) {
            throw new NoTransactionInProgressException("Attempt to " + operationName + " without a transaction in progress.");
        }
    }

    static void assureUpdate(String operationName) {
        Transaction.assure(operationName);
        int type = com.odi.Transaction.current().getType();
        if (type != 7 && type != 4) {
            throw new UpdateReadOnlyException("Attempt to " + operationName + " without an update transaction in progress.");
        }
    }
}

