/*
 * Decompiled with CFR 0.152.
 */
package com.odi.util;

import java.io.Serializable;
import java.util.Objects;

public class BitSet
implements Cloneable,
Serializable {
    static final long serialVersionUID = 2791362315121771548L;
    private int logicalSize;
    private java.util.BitSet bitSet;

    public BitSet() {
        this.bitSet = new java.util.BitSet();
        this.logicalSize = 0;
    }

    public BitSet(int size) {
        this.bitSet = new java.util.BitSet(size);
        this.logicalSize = 0;
    }

    public void set(int bit) {
        this.bitSet.set(bit);
        if (bit > this.logicalSize) {
            this.logicalSize = bit;
        }
    }

    public void clear(int bit) {
        this.bitSet.clear(bit);
        if (bit > this.logicalSize) {
            this.logicalSize = bit;
        }
    }

    public boolean get(int bit) {
        return this.bitSet.get(bit);
    }

    public void and(BitSet other) {
        this.logicalSize = Math.max(this.logicalSize, other.logicalSize);
        this.bitSet.and(other.bitSet);
    }

    public void or(BitSet other) {
        this.logicalSize = Math.max(this.logicalSize, other.logicalSize);
        this.bitSet.or(other.bitSet);
    }

    public void xor(BitSet other) {
        this.logicalSize = Math.max(this.logicalSize, other.logicalSize);
        this.bitSet.xor(other.bitSet);
    }

    public int length() {
        return this.logicalSize;
    }

    public int size() {
        return this.bitSet.size();
    }

    public Object clone() {
        BitSet obj = new BitSet();
        obj.bitSet = (java.util.BitSet)this.bitSet.clone();
        obj.logicalSize = this.logicalSize;
        return obj;
    }

    public boolean equals(Object other) {
        return other instanceof BitSet ? this.bitSet.equals(((BitSet)other).bitSet) : false;
    }

    public int hashCode() {
        return Objects.hash(this.bitSet);
    }
}

