/*
 * Decompiled with CFR 0.152.
 */
package com.odi.util;

import com.odi.util.OSVector;
import java.util.Enumeration;
import java.util.ListIterator;
import java.util.NoSuchElementException;

class OSVectorIterator
implements Enumeration,
ListIterator {
    private int nextindex;
    private int lastindex;
    private OSVector vector;

    @Override
    public boolean hasMoreElements() {
        return this.hasNext();
    }

    public Object nextElement() {
        return this.next();
    }

    OSVectorIterator(OSVector v) {
        this.vector = v;
        this.nextindex = 0;
        this.lastindex = -1;
    }

    OSVectorIterator(OSVector v, int index) {
        this.vector = v;
        this.nextindex = index;
        this.lastindex = -1;
    }

    public void add(Object obj) {
        this.vector.insertElementAt(obj, this.nextindex);
        if (this.lastindex == this.nextindex) {
            --this.lastindex;
        }
    }

    @Override
    public boolean hasNext() {
        return this.nextindex < this.vector.size();
    }

    @Override
    public boolean hasPrevious() {
        return this.nextindex > 0;
    }

    @Override
    public Object next() {
        this.lastindex = this.nextindex;
        try {
            return this.vector.elementAt(this.nextindex++);
        }
        catch (IndexOutOfBoundsException e) {
            throw new NoSuchElementException("OSVectorIterator");
        }
    }

    public Object previous() {
        this.lastindex = --this.nextindex;
        try {
            return this.vector.elementAt(this.nextindex);
        }
        catch (IndexOutOfBoundsException e) {
            throw new NoSuchElementException("OSVectorIterator");
        }
    }

    @Override
    public int nextIndex() {
        return this.nextindex;
    }

    @Override
    public int previousIndex() {
        return this.nextindex - 1;
    }

    @Override
    public void remove() {
        if (this.lastindex == -1) {
            throw new IllegalStateException("OSVectorIterator");
        }
        this.vector.removeElementAt(this.lastindex);
        this.lastindex = -1;
        --this.nextindex;
    }

    public void set(Object obj) {
        if (this.lastindex == -1) {
            throw new IllegalStateException("OSVectorIterator");
        }
        this.vector.setElementAt(obj, this.lastindex);
    }
}

