/*
 * Decompiled with CFR 0.152.
 */
package com.progress.blackbird.io.multi;

import cern.colt.function.LongObjectProcedure;
import cern.colt.list.LongArrayList;
import cern.colt.list.ObjectArrayList;
import cern.colt.map.OpenLongObjectHashMap;
import com.progress.blackbird.evs.EEvsObjectHotException;
import com.progress.blackbird.evs.IEvsDispatcher;
import com.progress.blackbird.evs.IEvsPortEvent;
import com.progress.blackbird.evs.IEvsPortEventHandler;
import com.progress.blackbird.evs.IEvsTimerPort;
import com.progress.blackbird.evs.nio.EvsDPCPort;
import com.progress.blackbird.evs.nio.EvsTimerPort;
import com.progress.blackbird.io.EIOConnectionAlreadyConnectedException;
import com.progress.blackbird.io.EIOConnectionClosedException;
import com.progress.blackbird.io.EIOConnectionFailedException;
import com.progress.blackbird.io.EIOConnectionNotConnectedException;
import com.progress.blackbird.io.EIOException;
import com.progress.blackbird.io.EIOFlushPendingException;
import com.progress.blackbird.io.EIOInboundStreamClosedException;
import com.progress.blackbird.io.EIOInboundStreamOpenException;
import com.progress.blackbird.io.EIOTimeoutException;
import com.progress.blackbird.io.IIOConnection;
import com.progress.blackbird.io.IIOConnectionEventHandler;
import com.progress.blackbird.io.IIOConnectionPacketHandler;
import com.progress.blackbird.io.IIOConnectionStatistics;
import com.progress.blackbird.io.IIOPacket;
import com.progress.blackbird.io.multi.IIOMultiConnectionFlowBalancer;
import com.progress.blackbird.io.multi.IIOMultiConnectionPacketManager;
import com.progress.blackbird.io.multi.IOMultiConnectionEvents;
import com.progress.blackbird.io.multi.IOMultiObject;
import com.progress.blackbird.sys.SysConfig;
import com.progress.blackbird.sys.SysListElement;
import com.progress.blackbird.sys.SysListHead;
import com.progress.blackbird.sys.SysStatistics;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;

public final class IOMultiConnection
extends IOMultiObject
implements IIOConnection {
    private final ObjectArrayList connections = new ObjectArrayList();
    private final ObjectArrayList deferredAddConnections = new ObjectArrayList();
    private final InProcessor inProcessor = new InProcessor();
    private final OutProcessor outProcessor = new OutProcessor();
    private final IIOConnectionEventHandler eventHandler;
    private final IIOMultiConnectionPacketManager packetManager;
    private final IIOMultiConnectionFlowBalancer flowBalancer;
    private final Statistics statistics;
    private final Parameters parameters;
    private boolean flgInboundStreamOpen;
    private boolean flgFailed;
    private boolean flgClosed;

    private IOMultiConnection(IIOConnection[] iIOConnectionArray, IIOConnectionEventHandler iIOConnectionEventHandler, IIOMultiConnectionPacketManager iIOMultiConnectionPacketManager, IIOMultiConnectionFlowBalancer iIOMultiConnectionFlowBalancer, boolean bl, Parameters parameters) {
        this.eventHandler = iIOConnectionEventHandler;
        this.packetManager = iIOMultiConnectionPacketManager;
        this.flowBalancer = iIOMultiConnectionFlowBalancer;
        this.threaded = bl;
        this.statistics = new Statistics(bl);
        int n = (int)SysConfig.getConfigValue(SysConfig.getProperties(), "bb.io.multi.packetStatsInterval", 0.0);
        if (n == 0) {
            n = (int)SysConfig.getConfigValue(SysConfig.getProperties(), "bb.io.packetStatsInterval", 0.0);
        }
        if (n > 0) {
            this.statistics.startDump(n);
        }
        this.parameters = parameters;
        for (int i = 0; i < iIOConnectionArray.length; ++i) {
            try {
                this.add(iIOConnectionArray[i]);
                continue;
            }
            catch (EIOConnectionNotConnectedException eIOConnectionNotConnectedException) {
                throw new IllegalStateException("one or more of the provided connections are not connected");
            }
            catch (EIOException eIOException) {
                // empty catch block
            }
        }
        this.trace.outln("Created multi-connection with parameters " + this.parameters, 4);
    }

    private void dispatchCloseNotifications(EIOException eIOException) {
        this.outProcessor.handleFailure(eIOException);
        this.inProcessor.handleFailure(eIOException);
    }

    private boolean handleConnectionFailureCore(Connection connection, EIOException eIOException) {
        this.trace.outln("Underlying connection failure [" + eIOException.getMessage() + "]", 2);
        ++this.statistics.numConnectionFailures;
        this.connections.delete(connection, false);
        connection.close();
        if (this.connections.size() == 0) {
            this.processDeferredAddList();
        }
        if (this.connections.size() == 0) {
            this.flgFailed = true;
            this.flgInboundStreamOpen = false;
            return true;
        }
        this.outProcessor.migrateOutflowsFromFailedConnection(connection);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleConnectionFailure(Connection connection, EIOException eIOException) {
        boolean bl = false;
        if (this.threaded) {
            IOMultiConnection iOMultiConnection = this;
            synchronized (iOMultiConnection) {
                bl = this.handleConnectionFailureCore(connection, eIOException);
            }
        } else {
            bl = this.handleConnectionFailureCore(connection, eIOException);
        }
        if (this.eventHandler != null) {
            this.eventHandler.handleEvent(101, new IOMultiConnectionEvents.ConnectionRemoveEventData(connection.getUnderlyingConnection(), eIOException));
        }
        if (bl) {
            this.dispatchCloseNotifications(eIOException);
        }
    }

    private void openAllConnectionsInboundStreams(IEvsDispatcher iEvsDispatcher) throws EIOException {
        Object[] objectArray = this.connections.elements();
        int n = this.connections.size();
        for (int i = 0; i < n; ++i) {
            try {
                ((Connection)objectArray[i]).read(iEvsDispatcher);
                continue;
            }
            catch (EIOInboundStreamOpenException eIOInboundStreamOpenException) {
                continue;
            }
            catch (EIOInboundStreamClosedException eIOInboundStreamClosedException) {
                throw new InternalError("Stream reported closed when trying to open it!");
            }
        }
    }

    private boolean areAllConnectionsInboundStreamsClosed() throws EIOException {
        Object[] objectArray = this.connections.elements();
        int n = this.connections.size();
        for (int i = 0; i < n; ++i) {
            if (!((Connection)objectArray[i]).isInboundStreamOpen()) continue;
            return false;
        }
        return true;
    }

    private void closeAllConnectionsInboundStreams() throws EIOException {
        Object[] objectArray = this.connections.elements();
        int n = this.connections.size();
        for (int i = 0; i < n; ++i) {
            try {
                ((Connection)objectArray[i]).read(null);
                continue;
            }
            catch (EIOInboundStreamClosedException eIOInboundStreamClosedException) {
                continue;
            }
            catch (EIOInboundStreamOpenException eIOInboundStreamOpenException) {
                throw new InternalError("Stream reported open when trying to close it!");
            }
        }
    }

    private void closeAllConnections() throws EIOInboundStreamOpenException, EIOFlushPendingException, EIOException {
        Object[] objectArray = this.connections.elements();
        int n = this.connections.size();
        for (int i = 0; i < n; ++i) {
            ((Connection)objectArray[i]).close();
        }
    }

    private List getInDoubtPacketsInternal() throws EIOException {
        return this.outProcessor.getInDoubtPackets();
    }

    private void processDeferredAddList() {
        Object[] objectArray = this.deferredAddConnections.elements();
        int n = this.deferredAddConnections.size();
        for (int i = 0; i < n; ++i) {
            IIOConnection iIOConnection = ((Connection)objectArray[i]).getUnderlyingConnection();
            try {
                this.add(iIOConnection);
                continue;
            }
            catch (Exception exception) {
                this.trace.outln("Error in deferred add of connection to multi-connection [" + exception.getMessage() + "]. Closing connection...", 1);
                try {
                    iIOConnection.close();
                    continue;
                }
                catch (Exception exception2) {
                    this.trace.outln("Failure in closing connection after error in deferred add of connection to multi-connection [" + exception2.getMessage() + "]. Ignoring.", 2);
                }
            }
        }
        this.deferredAddConnections.clear();
    }

    private void closeDeferredAddList() {
        Object[] objectArray = this.deferredAddConnections.elements();
        int n = this.deferredAddConnections.size();
        for (int i = 0; i < n; ++i) {
            IIOConnection iIOConnection = ((Connection)objectArray[i]).getUnderlyingConnection();
            try {
                iIOConnection.close();
                continue;
            }
            catch (Exception exception) {
                this.trace.outln("Failure in closing connection deferred add list [" + exception.getMessage() + "]. Ignoring.", 2);
            }
        }
        this.deferredAddConnections.clear();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addInternal(IIOConnection iIOConnection) throws EIOConnectionClosedException, EIOConnectionFailedException, EIOInboundStreamOpenException, EIOConnectionNotConnectedException, EIOException {
        if (this.trace.debug) {
            this.trace.debugln("Adding new connection..." + iIOConnection);
        }
        if (this.flgClosed) throw new EIOConnectionClosedException();
        if (this.flgFailed) throw new EIOConnectionFailedException();
        if (!iIOConnection.isConnected()) {
            throw new EIOConnectionNotConnectedException();
        }
        if (iIOConnection.isInboundStreamOpen()) {
            throw new EIOInboundStreamOpenException();
        }
        Object[] objectArray = this.connections.elements();
        int n = this.connections.size();
        for (int i = 0; i < n; ++i) {
            if (((Connection)objectArray[i]).getUnderlyingConnection() != iIOConnection) continue;
            throw new IllegalArgumentException("duplicate connection");
        }
        Connection connection = new Connection(iIOConnection);
        boolean bl = false;
        if (this.flgInboundStreamOpen) {
            if (this.inProcessor.getDispatcher() == null) {
                throw new InternalError("Inbound stream is open but dispatcher is null!");
            }
            if (this.inProcessor.getDispatcher().getOwner() == Thread.currentThread()) {
                if (this.trace.debug) {
                    this.trace.debugln("Multi-connection inbound stream started and calling thread is dispatcher owner. Starting added connection inbound stream...");
                }
                connection.read(this.inProcessor.getDispatcher());
                bl = true;
            } else {
                if (this.trace.debug) {
                    this.trace.debugln("Multi-connection inbound stream started but calling thread is not dispatcher owner. Dererring connection inbound stream start...");
                }
                this.deferredAddConnections.add(connection);
                EvsDPCPort.create(this.threaded).post(this.inProcessor.getDispatcher(), (byte)31, new DeferredAddHandler(), null);
            }
        } else {
            if (this.trace.debug) {
                this.trace.debugln("Multi-connection inbound stream stopped. Not starting added connection inbound stream...");
            }
            bl = true;
        }
        if (!bl) return;
        if (this.trace.debug) {
            this.trace.debugln("Adding connection " + connection.getUnderlyingConnection() + " to connection list");
        }
        this.connections.add(connection);
        if (this.eventHandler == null) return;
        this.eventHandler.handleEvent(100, new IOMultiConnectionEvents.ConnectionAddEventData(connection.getUnderlyingConnection()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readInternal(IEvsDispatcher iEvsDispatcher, IIOConnectionPacketHandler iIOConnectionPacketHandler) throws EIOConnectionClosedException, EIOConnectionFailedException, EIOInboundStreamOpenException, EIOInboundStreamClosedException, EIOException {
        if (this.flgClosed) throw new EIOConnectionClosedException();
        if (this.flgFailed) throw new EIOConnectionFailedException();
        if (iIOConnectionPacketHandler != null) {
            if (iEvsDispatcher == null) {
                throw new IllegalArgumentException("dispatcher cannot be null");
            }
            if (this.isInboundStreamOpenInternal()) throw new EIOInboundStreamOpenException();
            this.openAllConnectionsInboundStreams(iEvsDispatcher);
            this.inProcessor.open(iEvsDispatcher, iIOConnectionPacketHandler);
            this.flgInboundStreamOpen = true;
            return;
        } else {
            if (!this.isInboundStreamOpenInternal()) throw new EIOInboundStreamClosedException();
            this.closeAllConnectionsInboundStreams();
            this.flgInboundStreamOpen = false;
        }
    }

    private IIOConnectionPacketHandler setPacketHandlerInternal(IIOConnectionPacketHandler iIOConnectionPacketHandler) throws EIOConnectionClosedException, EIOConnectionFailedException, EIOInboundStreamClosedException, EIOException {
        if (iIOConnectionPacketHandler == null) {
            throw new IllegalArgumentException("replacement packet handler cannot be null");
        }
        if (!this.flgClosed) {
            if (!this.flgFailed) {
                if (this.isInboundStreamOpenInternal()) {
                    return this.inProcessor.setPacketHandler(iIOConnectionPacketHandler);
                }
                throw new EIOInboundStreamClosedException();
            }
            throw new EIOConnectionFailedException();
        }
        throw new EIOConnectionClosedException();
    }

    private boolean writeInternal(IIOPacket iIOPacket, IIOConnection.FlushContext flushContext, int n) throws EIOConnectionClosedException, EIOConnectionFailedException, EIOFlushPendingException, EIOException {
        if (this.checked && iIOPacket == null) {
            throw new IllegalArgumentException("packet cannot be null");
        }
        if (!this.flgClosed) {
            if (!this.flgFailed) {
                return this.outProcessor.write(iIOPacket, flushContext, n);
            }
            throw new EIOConnectionFailedException();
        }
        throw new EIOConnectionClosedException();
    }

    private int preFlushInternal(IIOConnection.FlushContext flushContext) throws EIOConnectionClosedException, EIOConnectionFailedException, EIOFlushPendingException, EIOException {
        if (!this.flgClosed) {
            if (!this.flgFailed) {
                return this.outProcessor.preFlush(flushContext);
            }
            throw new EIOConnectionFailedException();
        }
        throw new EIOConnectionClosedException();
    }

    private void flushNonBlockingInternal(int n, IIOConnection.FlushContext flushContext) throws EIOException {
        this.outProcessor.flushNonBlocking(n, flushContext);
    }

    private void flushBlockingInternal(int n, ObjectArrayList objectArrayList, IIOConnection.FlushContext flushContext) throws EIOException {
        this.outProcessor.flushBlocking(n, objectArrayList, flushContext);
    }

    private boolean isInboundStreamOpenInternal() throws EIOConnectionClosedException, EIOException {
        if (!this.flgClosed) {
            if (!this.flgInboundStreamOpen && this.areAllConnectionsInboundStreamsClosed()) {
                this.inProcessor.close();
                return false;
            }
            return true;
        }
        throw new EIOConnectionClosedException();
    }

    private int getOutboundStreamBufferSizeInternal() throws EIOConnectionClosedException, EIOConnectionFailedException, EIOException {
        if (!this.flgClosed) {
            if (!this.flgFailed) {
                return this.outProcessor.getOutboundStreamBufferSize();
            }
            throw new EIOConnectionFailedException();
        }
        throw new EIOConnectionClosedException();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void closeInternal() throws EIOInboundStreamOpenException, EIOFlushPendingException, EIOException {
        if (this.flgClosed) return;
        if (this.isInboundStreamOpenInternal()) throw new EIOInboundStreamOpenException();
        if (this.outProcessor.isAsyncFlushInProgress()) throw new EIOFlushPendingException();
        try {
            this.closeAllConnections();
            return;
        }
        catch (EIOInboundStreamOpenException eIOInboundStreamOpenException) {
            throw new InternalError("Inbound stream open reported by underlying connection during close!");
        }
        catch (EIOFlushPendingException eIOFlushPendingException) {
            throw new InternalError("Flush pending reported by underlying connection during close!");
        }
        finally {
            this.closeDeferredAddList();
            this.statistics.stopDump();
            this.flgClosed = true;
        }
    }

    private boolean isClosedInternal() throws EIOException {
        return this.flgClosed;
    }

    private boolean isFailedInternal() throws EIOConnectionClosedException, EIOException {
        if (!this.flgClosed) {
            return this.flgFailed;
        }
        throw new EIOConnectionClosedException();
    }

    public static IIOConnection create(IIOConnection[] iIOConnectionArray, IIOConnectionEventHandler iIOConnectionEventHandler, IIOMultiConnectionPacketManager iIOMultiConnectionPacketManager, IIOMultiConnectionFlowBalancer iIOMultiConnectionFlowBalancer, boolean bl, Parameters parameters) {
        if (iIOConnectionArray == null) {
            throw new IllegalArgumentException("connection list cannot be null");
        }
        if (iIOConnectionArray.length == 0) {
            throw new IllegalArgumentException("connection list cannot be empty");
        }
        return new IOMultiConnection(iIOConnectionArray, iIOConnectionEventHandler, iIOMultiConnectionPacketManager, iIOMultiConnectionFlowBalancer, bl, parameters == null ? Parameters.create() : parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void add(IIOConnection iIOConnection) throws EIOConnectionClosedException, EIOConnectionFailedException, EIOConnectionNotConnectedException, EIOInboundStreamOpenException, EIOException {
        if (this.threaded) {
            IOMultiConnection iOMultiConnection = this;
            synchronized (iOMultiConnection) {
                this.addInternal(iIOConnection);
            }
        } else {
            this.addInternal(iIOConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getConnectionCount() {
        if (this.threaded) {
            IOMultiConnection iOMultiConnection = this;
            synchronized (iOMultiConnection) {
                return this.connections.size();
            }
        }
        return this.connections.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List getInDoubtPackets() throws EIOException {
        if (this.threaded) {
            IOMultiConnection iOMultiConnection = this;
            synchronized (iOMultiConnection) {
                return this.getInDoubtPacketsInternal();
            }
        }
        return this.getInDoubtPacketsInternal();
    }

    @Override
    public final boolean isThreaded() {
        return this.threaded;
    }

    @Override
    public final IIOConnectionStatistics getStatistics() {
        return this.statistics;
    }

    @Override
    public final void connect() throws EIOConnectionAlreadyConnectedException, EIOConnectionClosedException, EIOException {
    }

    @Override
    public final boolean isConnected() throws EIOConnectionClosedException, EIOException {
        return true;
    }

    @Override
    public final IIOConnection accept(int n) throws EIOConnectionClosedException, EIOTimeoutException, EIOException {
        throw new UnsupportedOperationException("accept() method not supported");
    }

    @Override
    public final SysListHead receive(int n) throws EIOConnectionNotConnectedException, EIOConnectionClosedException, EIOConnectionFailedException, EIOTimeoutException, EIOInboundStreamOpenException, EIOException {
        throw new UnsupportedOperationException("method not implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void read(IEvsDispatcher iEvsDispatcher, IIOConnectionPacketHandler iIOConnectionPacketHandler) throws EIOConnectionNotConnectedException, EIOConnectionClosedException, EIOConnectionFailedException, EIOInboundStreamOpenException, EIOInboundStreamClosedException, EIOException {
        if (this.threaded) {
            IOMultiConnection iOMultiConnection = this;
            synchronized (iOMultiConnection) {
                this.readInternal(iEvsDispatcher, iIOConnectionPacketHandler);
            }
        } else {
            this.readInternal(iEvsDispatcher, iIOConnectionPacketHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IIOConnectionPacketHandler setPacketHandler(IIOConnectionPacketHandler iIOConnectionPacketHandler) throws EIOConnectionNotConnectedException, EIOConnectionClosedException, EIOConnectionFailedException, EIOInboundStreamClosedException, EIOException {
        if (this.threaded) {
            IOMultiConnection iOMultiConnection = this;
            synchronized (iOMultiConnection) {
                return this.setPacketHandlerInternal(iIOConnectionPacketHandler);
            }
        }
        return this.setPacketHandlerInternal(iIOConnectionPacketHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean write(IIOPacket iIOPacket, IIOConnection.FlushContext flushContext, int n) throws EIOConnectionNotConnectedException, EIOConnectionClosedException, EIOConnectionFailedException, EIOFlushPendingException, EIOException {
        boolean bl;
        if (this.threaded) {
            IOMultiConnection iOMultiConnection = this;
            synchronized (iOMultiConnection) {
                bl = this.writeInternal(iIOPacket, flushContext, n);
            }
        } else {
            bl = this.writeInternal(iIOPacket, flushContext, n);
        }
        if (bl) {
            this.flush(flushContext);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void flush(IIOConnection.FlushContext flushContext) throws EIOConnectionNotConnectedException, EIOConnectionClosedException, EIOConnectionFailedException, EIOFlushPendingException, EIOException {
        int n;
        boolean bl = flushContext == null || flushContext.flushMode == 0;
        boolean bl2 = flushContext != null && flushContext.flushMode == 1;
        boolean bl3 = flushContext != null && flushContext.flushMode == 2;
        ObjectArrayList objectArrayList = null;
        if (this.threaded) {
            IOMultiConnection iOMultiConnection = this;
            synchronized (iOMultiConnection) {
                n = this.preFlushInternal(flushContext);
                if (bl2 || bl3) {
                    this.flushNonBlockingInternal(n, flushContext);
                } else {
                    objectArrayList = this.connections.copy();
                }
            }
        } else {
            n = this.preFlushInternal(flushContext);
            if (bl2 || bl3) {
                this.flushNonBlockingInternal(n, flushContext);
            } else {
                objectArrayList = this.connections.copy();
            }
        }
        if (bl) {
            this.flushBlockingInternal(n, objectArrayList, flushContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isInboundStreamOpen() throws EIOConnectionClosedException, EIOException {
        if (this.threaded) {
            IOMultiConnection iOMultiConnection = this;
            synchronized (iOMultiConnection) {
                return this.isInboundStreamOpenInternal();
            }
        }
        return this.isInboundStreamOpenInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int getOutboundStreamBufferSize() throws EIOConnectionNotConnectedException, EIOConnectionClosedException, EIOConnectionFailedException, EIOException {
        if (this.threaded) {
            IOMultiConnection iOMultiConnection = this;
            synchronized (iOMultiConnection) {
                return this.getOutboundStreamBufferSizeInternal();
            }
        }
        return this.getOutboundStreamBufferSizeInternal();
    }

    @Override
    public final void fail(Exception exception) throws EIOConnectionNotConnectedException, EIOConnectionClosedException, EIOConnectionFailedException, EIOInboundStreamClosedException, EIOException {
        throw new UnsupportedOperationException("fail() not supported on multi connections");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws EIOInboundStreamOpenException, EIOFlushPendingException, EIOException {
        if (this.threaded) {
            IOMultiConnection iOMultiConnection = this;
            synchronized (iOMultiConnection) {
                this.closeInternal();
            }
        } else {
            this.closeInternal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isClosed() throws EIOException {
        if (this.threaded) {
            IOMultiConnection iOMultiConnection = this;
            synchronized (iOMultiConnection) {
                return this.isClosedInternal();
            }
        }
        return this.isClosedInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isFailed() throws EIOConnectionClosedException, EIOException {
        if (this.threaded) {
            IOMultiConnection iOMultiConnection = this;
            synchronized (iOMultiConnection) {
                return this.isFailedInternal();
            }
        }
        return this.isFailedInternal();
    }

    public class Statistics
    extends SysStatistics
    implements IIOConnectionStatistics {
        private NumberFormat format = NumberFormat.getInstance();
        private long startTime;
        private long deltaStartTime;
        private long numPacketsReadLast;
        private long numLessExpDataPacketsReadLast;
        private long numAtExpDataPacketsReadLast;
        private long numGreaterExpDataPacketsReadLast;
        private long numAckPacketsReadLast;
        private long numNackPacketsReadLast;
        private long numSyncPacketsReadLast;
        private long numLessExpSyncPacketsReadLast;
        private long numAtExpSyncPacketsReadLast;
        private long numGreaterExpSyncPacketsReadLast;
        private long numPacketsWrittenLast;
        private long numAckPacketsWrittenLast;
        private long numNackPacketsWrittenLast;
        private long numSyncPacketsWrittenLast;
        private int numUnackedPacketsLast;
        private int numConnectionFailuresLast;
        long numPacketsRead;
        long numLessExpDataPacketsRead;
        long numAtExpDataPacketsRead;
        long numGreaterExpDataPacketsRead;
        long numAckPacketsRead;
        long numNackPacketsRead;
        long numSyncPacketsRead;
        long numLessExpSyncPacketsRead;
        long numAtExpSyncPacketsRead;
        long numGreaterExpSyncPacketsRead;
        long numPacketsWritten;
        long numAckPacketsWritten;
        long numNackPacketsWritten;
        long numSyncPacketsWritten;
        int numUnackedPackets;
        int numConnectionFailures;

        private Statistics(boolean bl) {
            this.format.setMaximumFractionDigits(2);
        }

        @Override
        protected final void init() {
            this.startTime = this.deltaStartTime = System.currentTimeMillis();
            this.numPacketsReadLast = this.numPacketsRead;
            this.numLessExpDataPacketsReadLast = this.numLessExpDataPacketsRead;
            this.numAtExpDataPacketsReadLast = this.numAtExpDataPacketsRead;
            this.numGreaterExpDataPacketsReadLast = this.numGreaterExpDataPacketsRead;
            this.numAckPacketsReadLast = this.numAckPacketsRead;
            this.numNackPacketsReadLast = this.numNackPacketsRead;
            this.numSyncPacketsReadLast = this.numSyncPacketsRead;
            this.numLessExpSyncPacketsReadLast = this.numLessExpSyncPacketsRead;
            this.numAtExpSyncPacketsReadLast = this.numAtExpSyncPacketsRead;
            this.numGreaterExpSyncPacketsReadLast = this.numGreaterExpSyncPacketsRead;
            this.numPacketsWrittenLast = this.numPacketsWritten;
            this.numAckPacketsWrittenLast = this.numAckPacketsWritten;
            this.numNackPacketsWrittenLast = this.numNackPacketsWritten;
            this.numSyncPacketsWrittenLast = this.numSyncPacketsWritten;
            this.numUnackedPacketsLast = this.numUnackedPackets;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected final void dump() {
            long l = System.currentTimeMillis();
            long l2 = this.numPacketsRead;
            long l3 = this.numLessExpDataPacketsRead;
            long l4 = this.numAtExpDataPacketsRead;
            long l5 = this.numGreaterExpDataPacketsRead;
            long l6 = this.numAckPacketsRead;
            long l7 = this.numNackPacketsRead;
            long l8 = this.numSyncPacketsRead;
            long l9 = this.numLessExpSyncPacketsRead;
            long l10 = this.numAtExpSyncPacketsRead;
            long l11 = this.numGreaterExpSyncPacketsRead;
            long l12 = this.numPacketsWritten;
            long l13 = this.numAckPacketsWritten;
            long l14 = this.numNackPacketsWritten;
            long l15 = this.numSyncPacketsWritten;
            int n = this.numUnackedPackets;
            int n2 = this.numConnectionFailures;
            long l16 = l - this.startTime;
            long l17 = l - this.deltaStartTime;
            String string = this.format.format(l2);
            String string2 = this.format.format(l2 - this.numPacketsReadLast);
            String string3 = this.format.format(l2 * 1000L / l16);
            String string4 = this.format.format((l2 - this.numPacketsReadLast) * 1000L / l17);
            String string5 = this.format.format(l3);
            String string6 = this.format.format(l3 - this.numLessExpDataPacketsReadLast);
            String string7 = this.format.format(l4);
            String string8 = this.format.format(l4 - this.numAtExpDataPacketsReadLast);
            String string9 = this.format.format(l5);
            String string10 = this.format.format(l5 - this.numGreaterExpDataPacketsReadLast);
            String string11 = this.format.format(l6);
            String string12 = this.format.format(l6 - this.numAckPacketsReadLast);
            String string13 = this.format.format(l6 * 1000L / l16);
            String string14 = this.format.format((l6 - this.numAckPacketsReadLast) * 1000L / l17);
            String string15 = this.format.format(l7);
            String string16 = this.format.format(l7 - this.numNackPacketsReadLast);
            String string17 = this.format.format(l7 * 1000L / l16);
            String string18 = this.format.format((l7 - this.numNackPacketsReadLast) * 1000L / l17);
            String string19 = this.format.format(l8);
            String string20 = this.format.format(l8 - this.numSyncPacketsReadLast);
            String string21 = this.format.format(l8 * 1000L / l16);
            String string22 = this.format.format((l8 - this.numSyncPacketsReadLast) * 1000L / l17);
            String string23 = this.format.format(l12);
            String string24 = this.format.format(l12 - this.numPacketsWrittenLast);
            String string25 = this.format.format(l12 * 1000L / l16);
            String string26 = this.format.format((l12 - this.numPacketsWrittenLast) * 1000L / l17);
            String string27 = this.format.format(l13);
            String string28 = this.format.format(l13 - this.numAckPacketsWrittenLast);
            String string29 = this.format.format(l13 * 1000L / l16);
            String string30 = this.format.format((l13 - this.numAckPacketsWrittenLast) * 1000L / l17);
            String string31 = this.format.format(l14);
            String string32 = this.format.format(l14 - this.numNackPacketsWrittenLast);
            String string33 = this.format.format(l14 * 1000L / l16);
            String string34 = this.format.format((l14 - this.numNackPacketsWrittenLast) * 1000L / l17);
            String string35 = this.format.format(l15);
            String string36 = this.format.format(l15 - this.numSyncPacketsWrittenLast);
            String string37 = this.format.format(l15 * 1000L / l16);
            String string38 = this.format.format((l15 - this.numSyncPacketsWrittenLast) * 1000L / l17);
            String string39 = this.format.format(l9);
            String string40 = this.format.format(l9 - this.numLessExpSyncPacketsReadLast);
            String string41 = this.format.format(l10);
            String string42 = this.format.format(l10 - this.numAtExpSyncPacketsReadLast);
            String string43 = this.format.format(l11);
            String string44 = this.format.format(l11 - this.numGreaterExpSyncPacketsReadLast);
            int n3 = n - this.numUnackedPacketsLast;
            int n4 = n2 - this.numConnectionFailuresLast;
            this.deltaStartTime = l;
            this.numPacketsReadLast = l2;
            this.numLessExpDataPacketsReadLast = l3;
            this.numAtExpDataPacketsReadLast = l4;
            this.numGreaterExpDataPacketsReadLast = l5;
            this.numAckPacketsReadLast = l6;
            this.numNackPacketsReadLast = l7;
            this.numSyncPacketsReadLast = l8;
            this.numLessExpSyncPacketsReadLast = l9;
            this.numAtExpSyncPacketsReadLast = l10;
            this.numGreaterExpSyncPacketsReadLast = l11;
            this.numPacketsWrittenLast = l12;
            this.numAckPacketsWrittenLast = l13;
            this.numNackPacketsWrittenLast = l14;
            this.numSyncPacketsWrittenLast = l15;
            this.numUnackedPacketsLast = n;
            this.numConnectionFailuresLast = n2;
            String string45 = "\n[" + IOMultiConnection.this + " STATS] DT=" + l17 + "\n";
            string45 = string45 + " Read{";
            string45 = string45 + "Data[";
            string45 = string45 + string + "(" + string2 + ") ";
            string45 = string45 + string3 + "(" + string4 + ") ";
            string45 = string45 + string5 + "(" + string6 + ") ";
            string45 = string45 + string7 + "(" + string8 + ") ";
            string45 = string45 + string9 + "(" + string10 + ")";
            string45 = string45 + "]";
            string45 = string45 + " Ack[";
            string45 = string45 + string11 + "(" + string12 + ") ";
            string45 = string45 + string13 + "(" + string14 + ")";
            string45 = string45 + "]";
            string45 = string45 + " Nack[";
            string45 = string45 + string15 + "(" + string16 + ") ";
            string45 = string45 + string17 + "(" + string18 + ")";
            string45 = string45 + "]";
            string45 = string45 + " Sync[";
            string45 = string45 + string19 + "(" + string20 + ") ";
            string45 = string45 + string21 + "(" + string22 + ") ";
            string45 = string45 + string39 + "(" + string40 + ") ";
            string45 = string45 + string41 + "(" + string42 + ") ";
            string45 = string45 + string43 + "(" + string44 + ")";
            string45 = string45 + "]";
            string45 = string45 + "}";
            string45 = string45 + " Write{";
            string45 = string45 + "Data[";
            string45 = string45 + string23 + "(" + string24 + ") ";
            string45 = string45 + string25 + "(" + string26 + ")";
            string45 = string45 + "]";
            string45 = string45 + " Ack[";
            string45 = string45 + string27 + "(" + string28 + ") ";
            string45 = string45 + string29 + "(" + string30 + ")";
            string45 = string45 + "]";
            string45 = string45 + " Nack[";
            string45 = string45 + string31 + "(" + string32 + ") ";
            string45 = string45 + string33 + "(" + string34 + ")";
            string45 = string45 + "]";
            string45 = string45 + " Sync[";
            string45 = string45 + string35 + "(" + string36 + ") ";
            string45 = string45 + string37 + "(" + string38 + ")";
            string45 = string45 + "]";
            string45 = string45 + "}";
            string45 = string45 + " Unack{";
            string45 = string45 + n + "(" + n3 + ")";
            string45 = string45 + "}";
            string45 = string45 + " Failures{";
            string45 = string45 + n2 + "(" + n4 + ")";
            string45 = string45 + "}";
            string45 = string45 + "\n";
            IOMultiConnection.this.trace.out(string45, -1);
            OutProcessor outProcessor = IOMultiConnection.this.outProcessor;
            synchronized (outProcessor) {
                IOMultiConnection.this.outProcessor.outflows.forEachPair(new LongObjectProcedure(){

                    @Override
                    public final boolean apply(long l, Object object) {
                        long l2 = l;
                        OutFlow outFlow = (OutFlow)object;
                        IOMultiConnection.this.trace.outln("Outflow [" + l2 + "] information");
                        IOMultiConnection.this.trace.outln(outFlow.toString(), -1);
                        return true;
                    }
                });
            }
        }
    }

    private final class DeferredAddHandler
    implements IEvsPortEventHandler {
        private DeferredAddHandler() {
        }

        @Override
        public final void handleEvent(IEvsPortEvent iEvsPortEvent) {
            if (((IOMultiConnection)IOMultiConnection.this).trace.debug) {
                IOMultiConnection.this.trace.debugln("Received deferred add event. Processing deferred add list...");
            }
            IOMultiConnection.this.processDeferredAddList();
        }
    }

    public static class Parameters {
        final int flags;
        final int autoFlushSize;
        public static final int FLAG_LOAD_BALANCED = 1;
        public static final int FLAG_RELIABLE = 2;

        private Parameters(int n, int n2) {
            this.flags = n;
            this.autoFlushSize = n2 == 0 ? (int)SysConfig.getConfigValue(System.getProperties(), "bb.io.conn.autoFlushSize", 8192.0) : n2;
        }

        public final boolean isReliable() {
            return (this.flags & 2) == 2;
        }

        public final boolean isLoadBalanced() {
            return (this.flags & 1) == 1;
        }

        public final int getAutoFlushSize() {
            return this.autoFlushSize;
        }

        public static Parameters create(int n, int n2) {
            return new Parameters(n, n2);
        }

        public static Parameters create() {
            return Parameters.create(2, 0);
        }

        public Object clone() {
            return Parameters.create(this.flags, this.autoFlushSize);
        }

        public final String toString() {
            return "[reliable=" + this.isReliable() + " loadBalanced=" + this.isLoadBalanced() + " autoFlushSize=" + this.getAutoFlushSize() + "]";
        }
    }

    private class OutProcessor {
        private final OpenLongObjectHashMap outflows = new OpenLongObjectHashMap();
        private volatile Connection stoppedFlushAt;

        OutProcessor() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void assignOutflowToConnection(OutFlow outFlow) {
            if (((IOMultiConnection)IOMultiConnection.this).trace.debug) {
                IOMultiConnection.this.trace.debugln("Assigning flow [" + outFlow.id + "] to connection...");
            }
            if (IOMultiConnection.this.checked && IOMultiConnection.this.connections.size() == 0) {
                throw new InternalError("no active connections for outbound packet");
            }
            if (IOMultiConnection.this.flowBalancer != null) {
                int n;
                Object[] objectArray = IOMultiConnection.this.connections.elements();
                int n2 = IOMultiConnection.this.connections.size();
                IIOConnection[] iIOConnectionArray = new IIOConnection[n2];
                for (n = 0; n < n2; ++n) {
                    iIOConnectionArray[n] = ((Connection)objectArray[n]).getUnderlyingConnection();
                }
                n = IOMultiConnection.this.flowBalancer.assignFlow(outFlow.id, iIOConnectionArray, IOMultiConnection.this.parameters);
                if (n < 0 || n >= n2) throw new InternalError("Flow balancer returned an invalid connection index!");
                if (((IOMultiConnection)IOMultiConnection.this).trace.debug) {
                    IOMultiConnection.this.trace.debugln("Flow balancer assigned connection index=" + n + " to flow.");
                }
                outFlow.setConnection((Connection)IOMultiConnection.this.connections.get(n));
                return;
            } else {
                if (((IOMultiConnection)IOMultiConnection.this).trace.debug) {
                    IOMultiConnection.this.trace.debugln("No flow balancer. Assigning to connection index=0.");
                }
                outFlow.setConnection((Connection)IOMultiConnection.this.connections.get(0));
            }
        }

        private boolean checkAutoFlushSizeExceeded() throws EIOException {
            return this.getOutboundStreamBufferSize() >= IOMultiConnection.this.parameters.getAutoFlushSize();
        }

        private boolean checkAutoFlushDisabled() throws EIOException {
            return IOMultiConnection.this.parameters.getAutoFlushSize() < 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void flushSyncBlocking(Object[] objectArray, int n, int n2, IIOConnection.SyncBlockingFlushContext syncBlockingFlushContext) {
            int n3 = n;
            boolean bl = true;
            if (((IOMultiConnection)IOMultiConnection.this).trace.debug) {
                IOMultiConnection.this.trace.debugln("Flushing (sync blocking)...");
            }
            for (int i = 0; i < n2; ++i) {
                Connection connection = (Connection)objectArray[n3];
                try {
                    if (syncBlockingFlushContext != null) {
                        syncBlockingFlushContext.reset();
                    }
                    connection.flush(syncBlockingFlushContext);
                }
                catch (EIOFlushPendingException eIOFlushPendingException) {
                    if (((IOMultiConnection)IOMultiConnection.this).trace.debug) {
                        IOMultiConnection.this.trace.debugln("Flush failed [" + eIOFlushPendingException.getMessage() + "] complete=" + (syncBlockingFlushContext != null ? (syncBlockingFlushContext.complete ? "yes" : "no") : "??") + "...");
                    }
                }
                catch (EIOException eIOException) {
                    if (((IOMultiConnection)IOMultiConnection.this).trace.debug) {
                        IOMultiConnection.this.trace.debugln("Flush failed [" + eIOException.getMessage() + "] complete=" + (syncBlockingFlushContext != null ? (syncBlockingFlushContext.complete ? "yes" : "no") : "??") + "...");
                    }
                }
                finally {
                    if (syncBlockingFlushContext != null) {
                        bl &= syncBlockingFlushContext.complete;
                    }
                }
                n3 = n3 == n2 - 1 ? 0 : n3 + 1;
            }
            if (syncBlockingFlushContext != null) {
                syncBlockingFlushContext.complete = bl;
            }
            if (((IOMultiConnection)IOMultiConnection.this).trace.debug) {
                IOMultiConnection.this.trace.debugln("Flush done [complete=" + (syncBlockingFlushContext != null ? (syncBlockingFlushContext.complete ? "yes" : "no") : "??") + "]...");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Connection flushSyncNonBlocking(Object[] objectArray, int n, int n2, IIOConnection.SyncNonBlockingFlushContext syncNonBlockingFlushContext) {
            int n3 = n;
            boolean bl = true;
            for (int i = 0; i < n2; ++i) {
                Connection connection = (Connection)objectArray[n3];
                try {
                    syncNonBlockingFlushContext.reset();
                    connection.flush(syncNonBlockingFlushContext);
                }
                catch (EIOConnectionFailedException eIOConnectionFailedException) {
                }
                catch (EIOFlushPendingException eIOFlushPendingException) {
                    throw new InternalError("flush reported pending from underlying connection!");
                }
                catch (EIOException eIOException) {
                }
                finally {
                    bl &= syncNonBlockingFlushContext.complete;
                }
                n3 = n3 == n2 - 1 ? 0 : n3 + 1;
            }
            syncNonBlockingFlushContext.complete = bl;
            return null;
        }

        private Connection flushAsync(Object[] objectArray, int n, int n2, IIOConnection.AsyncFlushContext asyncFlushContext) {
            throw new UnsupportedOperationException("async flushes are not supported as yet in the multi-connection");
        }

        private boolean writeInternal(IIOPacket iIOPacket, IIOConnection.FlushContext flushContext, int n) throws EIOFlushPendingException, EIOException {
            boolean bl = false;
            if (!this.isAsyncFlushInProgress()) {
                boolean bl2 = (n & 2) == 2;
                boolean bl3 = ((n &= 0xFFFFFFFD) & 4) == 4;
                n &= 0xFFFFFFFB;
                OutFlow outFlow = this.idToOutflow(IOMultiConnection.this.packetManager.getDataFlowId(iIOPacket), true);
                if (outFlow.connection == null) {
                    this.assignOutflowToConnection(outFlow);
                }
                if (IOMultiConnection.this.parameters.isReliable()) {
                    if ((n & 1) == 0) {
                        iIOPacket = (IIOPacket)iIOPacket.clone();
                    }
                    IOMultiConnection.this.packetManager.setDataSequenceNumber(iIOPacket, outFlow.enque(iIOPacket));
                }
                try {
                    ++((IOMultiConnection)IOMultiConnection.this).statistics.numPacketsWritten;
                    outFlow.connection.write(iIOPacket, n);
                    return !bl2 && !this.checkAutoFlushDisabled() && (bl3 || this.checkAutoFlushSizeExceeded());
                }
                catch (EIOConnectionFailedException eIOConnectionFailedException) {
                }
                catch (EIOFlushPendingException eIOFlushPendingException) {
                    throw new InternalError("write() on connection reported flush still pending!");
                }
                catch (EIOException eIOException) {}
            } else {
                throw new EIOFlushPendingException();
            }
            return false;
        }

        private OutFlow idToOutflow(long l, boolean bl) {
            OutFlow outFlow = (OutFlow)this.outflows.get(l);
            if (outFlow == null && bl) {
                outFlow = new OutFlow(l);
                this.outflows.put(l, outFlow);
            }
            if (IOMultiConnection.this.checked && outFlow == null) {
                throw new InternalError("Failed to find outflow for id=" + l);
            }
            return outFlow;
        }

        final OutFlow[] idsToOutflows(long[] lArray, boolean bl) {
            OutFlow[] outFlowArray = new OutFlow[lArray.length];
            for (int i = 0; i < outFlowArray.length; ++i) {
                outFlowArray[i] = this.idToOutflow(lArray[i], bl);
            }
            return outFlowArray;
        }

        final int getOutboundStreamBufferSize() throws EIOException {
            Object[] objectArray = IOMultiConnection.this.connections.elements();
            int n = IOMultiConnection.this.connections.size();
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                try {
                    n2 += ((Connection)objectArray[i]).getOutboundStreamBufferSize();
                    continue;
                }
                catch (EIOConnectionFailedException eIOConnectionFailedException) {
                    continue;
                }
                catch (EIOException eIOException) {
                    // empty catch block
                }
            }
            return n2;
        }

        final void migrateOutflowsFromFailedConnection(final Connection connection) {
            this.outflows.forEachPair(new LongObjectProcedure(){

                @Override
                public final boolean apply(long l, Object object) {
                    long l2 = l;
                    OutFlow outFlow = (OutFlow)object;
                    if (outFlow.getConnection() == connection) {
                        OutProcessor.this.assignOutflowToConnection(outFlow);
                        IOMultiConnection.this.inProcessor.scheduleSync(outFlow);
                    }
                    return true;
                }
            });
        }

        List getInDoubtPackets() throws EIOException {
            final LinkedList linkedList = new LinkedList();
            this.outflows.forEachPair(new LongObjectProcedure(){

                @Override
                public final boolean apply(long l, Object object) {
                    long l2 = l;
                    OutFlow outFlow = (OutFlow)object;
                    outFlow.getInDoubtPackets(linkedList);
                    return true;
                }
            });
            return linkedList;
        }

        final boolean isAsyncFlushInProgress() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final boolean write(IIOPacket iIOPacket, IIOConnection.FlushContext flushContext, int n) throws EIOFlushPendingException, EIOException {
            if (IOMultiConnection.this.threaded) {
                OutProcessor outProcessor = this;
                synchronized (outProcessor) {
                    return this.writeInternal(iIOPacket, flushContext, n);
                }
            }
            return this.writeInternal(iIOPacket, flushContext, n);
        }

        final int preFlush(IIOConnection.FlushContext flushContext) throws EIOFlushPendingException {
            if (!this.isAsyncFlushInProgress()) {
                int n;
                if (flushContext != null) {
                    flushContext.reset();
                }
                Connection connection = null;
                if (this.stoppedFlushAt != null) {
                    connection = this.stoppedFlushAt;
                }
                int n2 = n = connection != null ? IOMultiConnection.this.connections.indexOf(connection, false) : 0;
                if (n == -1) {
                    n = 0;
                }
                this.stoppedFlushAt = null;
                return n;
            }
            throw new EIOFlushPendingException();
        }

        final void flushNonBlocking(int n, IIOConnection.FlushContext flushContext) {
            Object[] objectArray = IOMultiConnection.this.connections.elements();
            int n2 = IOMultiConnection.this.connections.size();
            if (flushContext.flushMode == 1) {
                this.stoppedFlushAt = this.flushSyncNonBlocking(objectArray, n, n2, (IIOConnection.SyncNonBlockingFlushContext)flushContext);
            } else if (flushContext.flushMode == 2) {
                this.stoppedFlushAt = this.flushAsync(objectArray, n, n2, (IIOConnection.AsyncFlushContext)flushContext);
            } else {
                throw new IllegalArgumentException("Invalid flush context");
            }
        }

        final void flushBlocking(int n, ObjectArrayList objectArrayList, IIOConnection.FlushContext flushContext) {
            if (flushContext != null && flushContext.flushMode != 0) {
                throw new IllegalArgumentException("Invalid flush context");
            }
            Object[] objectArray = objectArrayList.elements();
            int n2 = objectArrayList.size();
            this.flushSyncBlocking(objectArray, n, n2, (IIOConnection.SyncBlockingFlushContext)flushContext);
        }

        final void handleFailure(EIOException eIOException) {
        }
    }

    private class InProcessor
    implements IEvsPortEventHandler {
        private final OpenLongObjectHashMap inflows = new OpenLongObjectHashMap();
        private final DeferredWriteContext deferredWriteContext = new DeferredWriteContext();
        private final ObjectArrayList connectionsPendingDeferredFlush = new ObjectArrayList();
        private IEvsDispatcher dispatcher;
        private IIOConnectionPacketHandler packetHandler;
        private volatile boolean flgClosed = true;

        InProcessor() {
        }

        private InFlow idToInflow(long l, boolean bl) {
            InFlow inFlow = (InFlow)this.inflows.get(l);
            if (inFlow == null && bl) {
                inFlow = new InFlow(l);
                this.inflows.put(l, inFlow);
            }
            if (IOMultiConnection.this.checked && inFlow == null) {
                throw new InternalError("Failed to find inflow for id=" + l);
            }
            return inFlow;
        }

        private InFlow[] idsToInflows(long[] lArray, boolean bl) {
            InFlow[] inFlowArray = new InFlow[lArray.length];
            for (int i = 0; i < inFlowArray.length; ++i) {
                inFlowArray[i] = this.idToInflow(lArray[i], bl);
            }
            return inFlowArray;
        }

        private void handleAckPacketCore(Connection connection, IIOPacket iIOPacket) {
            OutFlow[] outFlowArray = IOMultiConnection.this.outProcessor.idsToOutflows(IOMultiConnection.this.packetManager.getAckFlowIds(iIOPacket), false);
            long[] lArray = IOMultiConnection.this.packetManager.getAckSnos(iIOPacket);
            for (int i = 0; i < outFlowArray.length; ++i) {
                outFlowArray[i].prune(lArray[i]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleAckPacket(Connection connection, IIOPacket iIOPacket) {
            if (((IOMultiConnection)IOMultiConnection.this).trace.debug) {
                IOMultiConnection.this.trace.debugln("Received ACK [" + iIOPacket + "]");
            }
            if (IOMultiConnection.this.threaded) {
                OutProcessor outProcessor = IOMultiConnection.this.outProcessor;
                synchronized (outProcessor) {
                    this.handleAckPacketCore(connection, iIOPacket);
                }
            } else {
                this.handleAckPacketCore(connection, iIOPacket);
            }
        }

        private void handleNackPacketCore(Connection connection, IIOPacket iIOPacket) {
            OutFlow[] outFlowArray = IOMultiConnection.this.outProcessor.idsToOutflows(IOMultiConnection.this.packetManager.getNackFlowIds(iIOPacket), false);
            Object[] objectArray = IOMultiConnection.this.packetManager.getNackSnoSets(iIOPacket);
            for (int i = 0; i < outFlowArray.length; ++i) {
                long[] lArray = (long[])objectArray[i];
                outFlowArray[i].prune(lArray[0] - 1L);
                this.deferredWriteContext.scheduleRetransmit(outFlowArray[i], lArray);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleNackPacket(Connection connection, IIOPacket iIOPacket) {
            if (((IOMultiConnection)IOMultiConnection.this).trace.debug) {
                IOMultiConnection.this.trace.debugln("Received NACK [" + iIOPacket + "]");
            }
            if (IOMultiConnection.this.threaded) {
                OutProcessor outProcessor = IOMultiConnection.this.outProcessor;
                synchronized (outProcessor) {
                    this.handleNackPacketCore(connection, iIOPacket);
                }
            } else {
                this.handleNackPacketCore(connection, iIOPacket);
            }
        }

        private void handleSyncPacket(Connection connection, IIOPacket iIOPacket) {
            if (((IOMultiConnection)IOMultiConnection.this).trace.debug) {
                IOMultiConnection.this.trace.debugln("Received SYNC [" + iIOPacket + "]");
            }
            InFlow[] inFlowArray = this.idsToInflows(IOMultiConnection.this.packetManager.getSyncFlowIds(iIOPacket), true);
            long[] lArray = IOMultiConnection.this.packetManager.getSyncSnos(iIOPacket);
            for (int i = 0; i < inFlowArray.length; ++i) {
                inFlowArray[i].enque(lArray[i], null);
                if (inFlowArray[i].getInputQueueSize() == 0) {
                    this.deferredWriteContext.scheduleAck(inFlowArray[i]);
                    continue;
                }
                this.deferredWriteContext.scheduleNack(inFlowArray[i]);
            }
        }

        private void handleDataPacket(Connection connection, IIOPacket iIOPacket) {
            InFlow inFlow = this.idToInflow(IOMultiConnection.this.packetManager.getDataFlowId(iIOPacket), true);
            long l = IOMultiConnection.this.packetManager.getDataSequenceNumber(iIOPacket);
            inFlow.enque(l, iIOPacket);
            while ((iIOPacket = inFlow.getNextPacketForDispatch()) != null) {
                this.packetHandler.handlePacket(null, iIOPacket);
            }
            if (l > 0L) {
                if (inFlow.getInputQueueSize() == 0) {
                    this.deferredWriteContext.scheduleAck(inFlow);
                } else {
                    this.deferredWriteContext.scheduleNack(inFlow);
                }
            }
        }

        private void writeDeferredPackets(LinkedList linkedList, ObjectArrayList objectArrayList, ObjectArrayList objectArrayList2) {
            if (linkedList.size() > 0) {
                Object[] objectArray = objectArrayList.elements();
                int n = objectArrayList.size();
                for (int i = n - 1; i >= 0; --i) {
                    Connection connection = (Connection)objectArray[i];
                    try {
                        boolean bl = false;
                        while (linkedList.size() > 0) {
                            IIOPacket iIOPacket = (IIOPacket)linkedList.getFirst();
                            connection.write(iIOPacket, 0);
                            if (!bl) {
                                objectArrayList2.add(connection);
                                bl = true;
                            }
                            linkedList.removeFirst();
                        }
                        break;
                    }
                    catch (EIOException eIOException) {
                        continue;
                    }
                }
            }
        }

        private void flushDeferredPackets(ObjectArrayList objectArrayList) {
            int n;
            ObjectArrayList objectArrayList2 = new ObjectArrayList();
            IIOConnection.SyncNonBlockingFlushContext syncNonBlockingFlushContext = new IIOConnection.SyncNonBlockingFlushContext();
            Object[] objectArray = objectArrayList.elements();
            int n2 = objectArrayList.size();
            for (n = 0; n < n2; ++n) {
                Connection connection = (Connection)objectArray[n];
                try {
                    syncNonBlockingFlushContext.reset();
                    connection.flush(syncNonBlockingFlushContext);
                    if (!syncNonBlockingFlushContext.complete) continue;
                    objectArrayList2.add(connection);
                    continue;
                }
                catch (EIOFlushPendingException eIOFlushPendingException) {
                    throw new InternalError("Received flush pending exception during deferred flush");
                }
                catch (EIOException eIOException) {
                    objectArrayList2.add(connection);
                }
            }
            objectArray = objectArrayList2.elements();
            n2 = objectArrayList2.size();
            for (n = 0; n < n2; ++n) {
                objectArrayList.delete((Connection)objectArray[n], false);
            }
        }

        final void handleConnectionFailure(Connection connection, EIOException eIOException) {
            this.connectionsPendingDeferredFlush.delete(connection, false);
            IOMultiConnection.this.handleConnectionFailure(connection, eIOException);
        }

        final void open(IEvsDispatcher iEvsDispatcher, IIOConnectionPacketHandler iIOConnectionPacketHandler) {
            this.dispatcher = iEvsDispatcher;
            this.packetHandler = iIOConnectionPacketHandler;
            this.flgClosed = false;
        }

        final IIOConnectionPacketHandler setPacketHandler(IIOConnectionPacketHandler iIOConnectionPacketHandler) {
            IIOConnectionPacketHandler iIOConnectionPacketHandler2 = this.packetHandler;
            this.packetHandler = iIOConnectionPacketHandler;
            return iIOConnectionPacketHandler2;
        }

        final IEvsDispatcher getDispatcher() {
            return this.dispatcher;
        }

        final void scheduleSync(OutFlow outFlow) {
            this.deferredWriteContext.scheduleSync(outFlow);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        final void handlePacket(Connection connection, EIOException eIOException, IIOPacket iIOPacket) {
            if (eIOException == null) {
                if (this.flgClosed) throw new InternalError("packet arrived in a closed in processor");
                if (IOMultiConnection.this.packetManager.isAck(iIOPacket)) {
                    ++((IOMultiConnection)IOMultiConnection.this).statistics.numAckPacketsRead;
                    this.handleAckPacket(connection, iIOPacket);
                    return;
                } else if (IOMultiConnection.this.packetManager.isNack(iIOPacket)) {
                    ++((IOMultiConnection)IOMultiConnection.this).statistics.numNackPacketsRead;
                    this.handleNackPacket(connection, iIOPacket);
                    return;
                } else if (IOMultiConnection.this.packetManager.isSync(iIOPacket)) {
                    ++((IOMultiConnection)IOMultiConnection.this).statistics.numSyncPacketsRead;
                    this.handleSyncPacket(connection, iIOPacket);
                    return;
                } else {
                    ++((IOMultiConnection)IOMultiConnection.this).statistics.numPacketsRead;
                    this.handleDataPacket(connection, iIOPacket);
                }
                return;
            } else {
                this.handleConnectionFailure(connection, eIOException);
            }
        }

        final void handleFailure(EIOException eIOException) {
            this.packetHandler.handlePacket(eIOException, null);
        }

        final void close() {
            if (!this.flgClosed) {
                this.deferredWriteContext.stopTimer();
                this.flgClosed = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void handleEvent(IEvsPortEvent iEvsPortEvent) {
            if (!this.flgClosed) {
                Object object;
                if (iEvsPortEvent.getType() == 1) {
                    this.deferredWriteContext.scheduleDPC(false);
                }
                LinkedList linkedList = null;
                if (this.connectionsPendingDeferredFlush.size() == 0) {
                    if (IOMultiConnection.this.threaded) {
                        object = IOMultiConnection.this.outProcessor;
                        synchronized (object) {
                            linkedList = this.deferredWriteContext.preparePacketsForWrite();
                        }
                    } else {
                        linkedList = this.deferredWriteContext.preparePacketsForWrite();
                    }
                }
                if (IOMultiConnection.this.threaded) {
                    IOMultiConnection iOMultiConnection = IOMultiConnection.this;
                    synchronized (iOMultiConnection) {
                        object = IOMultiConnection.this.connections.copy();
                    }
                } else {
                    object = IOMultiConnection.this.connections.copy();
                }
                if (linkedList != null) {
                    this.writeDeferredPackets(linkedList, (ObjectArrayList)object, this.connectionsPendingDeferredFlush);
                }
                this.flushDeferredPackets(this.connectionsPendingDeferredFlush);
                if (linkedList != null && linkedList.size() == 0 && this.connectionsPendingDeferredFlush.size() == 0) {
                    this.deferredWriteContext.clearScheduleState();
                    this.deferredWriteContext.stopTimer();
                } else {
                    this.deferredWriteContext.startTimer();
                }
            }
        }

        private final class DeferredWriteContext {
            private final OpenLongObjectHashMap inflows = new OpenLongObjectHashMap();
            private final OpenLongObjectHashMap outflows = new OpenLongObjectHashMap();
            private boolean flgDPCScheduled;
            private IEvsTimerPort timer;
            private long lastTimerDispatch;

            DeferredWriteContext() {
            }

            final void scheduleDPC(boolean bl) {
                if (bl && !this.flgDPCScheduled) {
                    EvsDPCPort.create(IOMultiConnection.this.isThreaded()).post(InProcessor.this.dispatcher, (byte)31, InProcessor.this, null);
                }
                this.flgDPCScheduled = bl;
            }

            final void startTimer() {
                if (this.timer == null) {
                    try {
                        this.timer = EvsTimerPort.create(IOMultiConnection.this.isThreaded());
                        this.timer.start(InProcessor.this.dispatcher, (byte)31, 100, InProcessor.this, null);
                    }
                    catch (EEvsObjectHotException eEvsObjectHotException) {
                        throw new InternalError("Timer reported as hot when just created!");
                    }
                    this.lastTimerDispatch = System.currentTimeMillis();
                } else {
                    long l = System.currentTimeMillis();
                    long l2 = l - this.lastTimerDispatch;
                    this.timer.reset(l + l2);
                    this.lastTimerDispatch = l;
                }
            }

            final void stopTimer() {
                if (this.timer != null) {
                    this.timer.stop();
                    this.timer = null;
                }
            }

            private void scheduleAck(InFlow inFlow) {
                this.inflows.put(inFlow.id, inFlow);
                this.scheduleDPC(true);
            }

            private void scheduleNack(InFlow inFlow) {
                this.inflows.put(inFlow.id, inFlow);
                this.scheduleDPC(true);
            }

            private void scheduleSync(OutFlow outFlow) {
                outFlow.setSyncScheduled(true);
                this.outflows.put(outFlow.id, outFlow);
                this.scheduleDPC(true);
            }

            private void scheduleRetransmit(OutFlow outFlow, long[] lArray) {
                outFlow.addRetransmitSet(lArray);
                this.outflows.put(outFlow.id, outFlow);
                this.scheduleDPC(true);
            }

            final void clearScheduleState() {
                this.outflows.forEachPair(new LongObjectProcedure(){

                    @Override
                    public final boolean apply(long l, Object object) {
                        long l2 = l;
                        OutFlow outFlow = (OutFlow)object;
                        outFlow.setSyncScheduled(false);
                        outFlow.clearRetransmitSet();
                        return true;
                    }
                });
                this.inflows.clear();
                this.outflows.clear();
            }

            final LinkedList preparePacketsForWrite() {
                final LinkedList<IIOPacket> linkedList = new LinkedList<IIOPacket>();
                final LongArrayList longArrayList = new LongArrayList();
                final LongArrayList longArrayList2 = new LongArrayList();
                final LongArrayList longArrayList3 = new LongArrayList();
                final ObjectArrayList objectArrayList = new ObjectArrayList();
                final LongArrayList longArrayList4 = new LongArrayList();
                final LongArrayList longArrayList5 = new LongArrayList();
                this.inflows.forEachPair(new LongObjectProcedure(){

                    @Override
                    public final boolean apply(long l, Object object) {
                        long l2 = l;
                        InFlow inFlow = (InFlow)object;
                        if (inFlow.getInputQueueSize() == 0) {
                            longArrayList.add(l2);
                            longArrayList2.add(inFlow.getLastRcvdSno());
                        } else {
                            longArrayList3.add(l2);
                            objectArrayList.add(inFlow.getHoles());
                        }
                        return true;
                    }
                });
                if (longArrayList.size() > 0) {
                    ++((IOMultiConnection)IOMultiConnection.this).statistics.numAckPacketsWritten;
                    linkedList.add(IOMultiConnection.this.packetManager.createAck(longArrayList.size(), longArrayList.elements(), longArrayList2.elements()));
                }
                if (longArrayList3.size() > 0) {
                    ++((IOMultiConnection)IOMultiConnection.this).statistics.numNackPacketsWritten;
                    linkedList.add(IOMultiConnection.this.packetManager.createNack(longArrayList3.size(), longArrayList3.elements(), objectArrayList.elements()));
                }
                this.outflows.forEachPair(new LongObjectProcedure(){

                    @Override
                    public final boolean apply(long l, Object object) {
                        long l2 = l;
                        OutFlow outFlow = (OutFlow)object;
                        if (outFlow.getSyncScheduled()) {
                            longArrayList4.add(l2);
                            longArrayList5.add(outFlow.getLastSno());
                        }
                        outFlow.getRetransmitPackets(linkedList);
                        return true;
                    }
                });
                if (longArrayList4.size() > 0) {
                    ++((IOMultiConnection)IOMultiConnection.this).statistics.numSyncPacketsWritten;
                    linkedList.add(IOMultiConnection.this.packetManager.createSync(longArrayList4.size(), longArrayList4.elements(), longArrayList5.elements()));
                }
                return linkedList;
            }
        }
    }

    private final class InFlow
    extends Flow {
        private long expectedSno;

        InFlow(long l) {
            super(l);
            this.expectedSno = 1L;
        }

        private boolean isSyncElement(Flow.QueueElement queueElement) {
            return queueElement.packet == null;
        }

        final void enque(long l, IIOPacket iIOPacket) {
            Flow.QueueElement queueElement = new Flow.QueueElement(l, iIOPacket);
            if (l <= 0L) {
                this.queue.prepend(queueElement);
            } else if (l >= this.expectedSno) {
                Flow.QueueElement queueElement2;
                if (l == this.expectedSno) {
                    if (this.isSyncElement(queueElement)) {
                        ++((IOMultiConnection)IOMultiConnection.this).statistics.numAtExpSyncPacketsRead;
                    } else {
                        ++((IOMultiConnection)IOMultiConnection.this).statistics.numAtExpDataPacketsRead;
                    }
                } else if (this.isSyncElement(queueElement)) {
                    ++((IOMultiConnection)IOMultiConnection.this).statistics.numGreaterExpSyncPacketsRead;
                } else {
                    ++((IOMultiConnection)IOMultiConnection.this).statistics.numGreaterExpDataPacketsRead;
                }
                SysListElement sysListElement = this.queue;
                SysListElement sysListElement2 = sysListElement;
                while ((sysListElement = sysListElement2.getNext()) != null) {
                    queueElement2 = (Flow.QueueElement)sysListElement;
                    if (queueElement2.sno >= l) {
                        if (queueElement2.sno != l) break;
                        queueElement2.remove();
                        if (this.isSyncElement(queueElement2)) break;
                        queueElement = queueElement2;
                        break;
                    }
                    sysListElement2 = sysListElement;
                }
                sysListElement2.insertAfter(queueElement);
                sysListElement = this.queue;
                while ((sysListElement = sysListElement.getNext()) != null && !this.isSyncElement(queueElement2 = (Flow.QueueElement)sysListElement) && queueElement2.sno <= this.expectedSno) {
                    ++this.expectedSno;
                }
            } else if (this.isSyncElement(queueElement)) {
                ++((IOMultiConnection)IOMultiConnection.this).statistics.numLessExpSyncPacketsRead;
            } else {
                ++((IOMultiConnection)IOMultiConnection.this).statistics.numLessExpDataPacketsRead;
            }
        }

        final IIOPacket getNextPacketForDispatch() {
            Flow.QueueElement queueElement = (Flow.QueueElement)this.queue.getNext();
            if (queueElement != null && (queueElement.sno <= 0L || queueElement.sno < this.expectedSno)) {
                queueElement.remove();
                if (this.isSyncElement(queueElement)) {
                    throw new InternalError("Packet element dispatchable but no packet set!");
                }
                return queueElement.packet;
            }
            return null;
        }

        final int getInputQueueSize() {
            return this.queue.getListSize();
        }

        final long getLastRcvdSno() {
            return this.expectedSno - 1L;
        }

        final long[] getHoles() {
            Flow.QueueElement queueElement;
            LongArrayList longArrayList = new LongArrayList();
            SysListElement sysListElement = this.queue;
            while ((sysListElement = this.queue.getNext()) != null) {
                queueElement = (Flow.QueueElement)sysListElement;
                if (this.expectedSno > queueElement.sno) continue;
                break;
            }
            queueElement = (Flow.QueueElement)sysListElement;
            long l = this.expectedSno;
            while (true) {
                if (l == queueElement.sno) {
                    if (this.isSyncElement(queueElement)) {
                        longArrayList.add(l);
                    }
                    if ((queueElement = (Flow.QueueElement)(sysListElement = sysListElement.getNext())) == null) {
                        break;
                    }
                } else {
                    longArrayList.add(l);
                }
                ++l;
            }
            longArrayList.trimToSize();
            return longArrayList.elements();
        }

        public final String toString() {
            String string = "[";
            string = string + super.toString(false);
            string = string + ",";
            string = string + "exp=" + this.expectedSno;
            string = string + ",";
            string = string + "holes=" + this.getHoles().length;
            string = string + "]";
            return string;
        }
    }

    private final class OutFlow
    extends Flow {
        private Connection connection;
        private long nextSno;
        private long highestAckSno;
        private boolean syncScheduled;
        private LinkedHashSet retransmitSet;

        OutFlow(long l) {
            super(l);
            this.nextSno = 1L;
            this.retransmitSet = new LinkedHashSet();
        }

        final void setConnection(Connection connection) {
            this.connection = connection;
        }

        final Connection getConnection() {
            return this.connection;
        }

        final long enque(IIOPacket iIOPacket) {
            this.queue.append(new Flow.QueueElement(this.nextSno, iIOPacket));
            ++((IOMultiConnection)IOMultiConnection.this).statistics.numUnackedPackets;
            return this.nextSno++;
        }

        final long getLastSno() {
            return this.nextSno - 1L;
        }

        final void setSyncScheduled(boolean bl) {
            this.syncScheduled = bl;
        }

        final boolean getSyncScheduled() {
            return this.syncScheduled;
        }

        final void addRetransmitSet(long[] lArray) {
            for (int i = 0; i < lArray.length; ++i) {
                this.retransmitSet.add(new Long(lArray[i]));
            }
        }

        final void getRetransmitPackets(LinkedList linkedList) {
            if (this.retransmitSet.size() > 0 && this.queue.getListSize() > 0) {
                SysListElement sysListElement = this.queue;
                Iterator iterator = this.retransmitSet.iterator();
                block0: while (sysListElement != null && iterator.hasNext()) {
                    long l = (Long)iterator.next();
                    while ((sysListElement = sysListElement.getNext()) != null) {
                        Flow.QueueElement queueElement = (Flow.QueueElement)sysListElement;
                        if (queueElement.sno < l) continue;
                        if (queueElement.sno == l) {
                            linkedList.add(queueElement.packet);
                            continue block0;
                        }
                        sysListElement = sysListElement.getPrevious();
                        continue block0;
                    }
                }
            }
        }

        final void clearRetransmitSet() {
            this.retransmitSet.clear();
        }

        final void prune(long l) {
            SysListElement sysListElement = this.queue;
            while ((sysListElement = this.queue.getNext()) != null) {
                Flow.QueueElement queueElement = (Flow.QueueElement)sysListElement;
                if (queueElement.sno > l) break;
                queueElement.remove();
                --((IOMultiConnection)IOMultiConnection.this).statistics.numUnackedPackets;
            }
            this.highestAckSno = Math.max(this.highestAckSno, l);
        }

        final void getInDoubtPackets(LinkedList linkedList) {
            SysListElement sysListElement = this.queue;
            while ((sysListElement = sysListElement.getNext()) != null) {
                Flow.QueueElement queueElement = (Flow.QueueElement)sysListElement;
                linkedList.add(queueElement.packet);
            }
        }

        public final String toString() {
            String string = "[";
            string = string + super.toString(false);
            string = string + ",";
            string = string + "conn=" + this.connection.hashCode();
            string = string + ",";
            string = string + "next=" + this.nextSno;
            string = string + ",";
            string = string + "high=" + this.highestAckSno;
            string = string + ",";
            string = string + "sync=" + this.syncScheduled;
            string = string + ",";
            string = string + "rexmit={";
            if (this.retransmitSet.size() > 0) {
                string = string + "count=" + this.retransmitSet.size() + " first=" + (Long)this.retransmitSet.iterator().next();
            }
            string = string + "}";
            string = string + "]";
            return string;
        }
    }

    private class Flow {
        final long id;
        final SysListHead queue;

        Flow(long l) {
            this.id = l;
            this.queue = SysListHead.create(null);
        }

        public String toString(boolean bl) {
            String string = "[";
            string = string + "id=" + this.id;
            string = string + ",";
            string = string + "qcnt=" + this.queue.getListSize();
            if (bl) {
                string = string + "<";
                SysListElement sysListElement = this.queue;
                while ((sysListElement = sysListElement.getNext()) != null) {
                    string = string + ((QueueElement)sysListElement).sno;
                    if (sysListElement.getNext() == null) continue;
                    string = string + ",";
                }
                string = string + ">";
            }
            string = string + "]";
            return string;
        }

        final class QueueElement
        extends SysListElement {
            final long sno;
            final IIOPacket packet;

            QueueElement(long l, IIOPacket iIOPacket) {
                super(null);
                this.sno = l;
                this.packet = iIOPacket;
            }
        }
    }

    private final class Connection
    implements IIOConnectionPacketHandler {
        private final IIOConnection ioconnection;

        Connection(IIOConnection iIOConnection) {
            this.ioconnection = iIOConnection;
        }

        final IIOConnection getUnderlyingConnection() {
            return this.ioconnection;
        }

        final void read(IEvsDispatcher iEvsDispatcher) throws EIOConnectionFailedException, EIOInboundStreamOpenException, EIOInboundStreamClosedException, EIOException {
            try {
                this.ioconnection.read(iEvsDispatcher, iEvsDispatcher == null ? null : this);
            }
            catch (EIOConnectionNotConnectedException eIOConnectionNotConnectedException) {
                throw new InternalError("read on connection underlying multi-connection reported 'not connected'!");
            }
            catch (EIOConnectionClosedException eIOConnectionClosedException) {
                throw new InternalError("read on connection underlying multi-connection reported 'closed'!");
            }
        }

        final void write(IIOPacket iIOPacket, int n) throws EIOConnectionFailedException, EIOFlushPendingException, EIOException {
            try {
                this.ioconnection.write(iIOPacket, null, n | 2);
            }
            catch (EIOConnectionNotConnectedException eIOConnectionNotConnectedException) {
                throw new InternalError("write on connection underlying multi-connection reported 'not connected'!");
            }
            catch (EIOConnectionClosedException eIOConnectionClosedException) {
                throw new InternalError("write on connection underlying multi-connection reported 'closed'!");
            }
        }

        final void flush(IIOConnection.FlushContext flushContext) throws EIOConnectionClosedException, EIOConnectionFailedException, EIOFlushPendingException, EIOException {
            try {
                this.ioconnection.flush(flushContext);
            }
            catch (EIOConnectionNotConnectedException eIOConnectionNotConnectedException) {
                throw new InternalError("flush on connection underlying multi-connection reported 'not connected'!");
            }
        }

        final boolean isInboundStreamOpen() throws EIOConnectionClosedException, EIOException {
            return this.ioconnection.isInboundStreamOpen();
        }

        final int getOutboundStreamBufferSize() throws EIOConnectionFailedException, EIOException {
            try {
                return this.ioconnection.getOutboundStreamBufferSize();
            }
            catch (EIOConnectionNotConnectedException eIOConnectionNotConnectedException) {
                throw new InternalError("read on connection underlying multi-connection reported 'not connected'!");
            }
            catch (EIOConnectionClosedException eIOConnectionClosedException) {
                throw new InternalError("read on connection underlying multi-connection reported 'closed'!");
            }
        }

        final void close() {
            try {
                this.ioconnection.close();
            }
            catch (EIOInboundStreamOpenException eIOInboundStreamOpenException) {
                throw new InternalError("close on connection underlying multi-connection reported 'inbound stream open'!");
            }
            catch (EIOException eIOException) {
                IOMultiConnection.this.trace.outln("Failure during closing connection underlying multi-connection [" + eIOException.getMessage() + "]", 2);
            }
        }

        @Override
        public final void handlePacket(EIOException eIOException, IIOPacket iIOPacket) {
            IOMultiConnection.this.inProcessor.handlePacket(this, eIOException, iIOPacket);
        }
    }
}

