/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.agent;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ExpandedSonicArchive {
    private String m_name;
    private File m_rootDirectory;
    private ArrayList m_privateClasspath;
    private HashMap m_sharedLibraries;
    private ArrayList m_globalClasspath;
    private ArrayList m_bootClasspath;
    private ArrayList m_bootAppendClasspath;
    private ArrayList m_bootPrependClasspath;
    private ArrayList m_launchClasspath;
    private ArrayList m_dependsOn;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final URL[] EMPTY_URL_ARRAY = new URL[0];

    public ExpandedSonicArchive(File archive) throws ParserConfigurationException, SAXException, IOException {
        this.m_rootDirectory = archive;
        if (!this.m_rootDirectory.exists()) {
            throw new IOException("Archive path does not exist: " + archive);
        }
        if (!this.m_rootDirectory.isDirectory()) {
            throw new IOException("Archive path is not a directory: " + archive);
        }
        File sonicXML = new File(this.m_rootDirectory, "META-INF/sonic.xml");
        if (!sonicXML.exists()) {
            throw new IOException("Archive descriptor does not exist: " + sonicXML.toString());
        }
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = builder.parse(sonicXML);
        NodeList nodes = document.getDocumentElement().getChildNodes();
        for (int i = nodes.getLength() - 1; i >= 0; --i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            if (((Element)node).getTagName().equals("name")) {
                this.m_name = node.getFirstChild().getNodeValue();
                if (this.m_name != null && this.m_name.length() >= 1) continue;
                throw new IOException("Invalid name name");
            }
            if (((Element)node).getTagName().equals("private-classpath")) {
                this.m_privateClasspath = this.parseClasspath(node.getChildNodes());
                continue;
            }
            if (((Element)node).getTagName().equals("shared-library")) {
                if (this.m_sharedLibraries == null) {
                    this.m_sharedLibraries = new HashMap();
                }
                this.parseSharedLibrary(node.getChildNodes());
                continue;
            }
            if (((Element)node).getTagName().equals("global-classpath")) {
                this.m_globalClasspath = this.parseClasspath(node.getChildNodes());
                continue;
            }
            if (((Element)node).getTagName().equals("launch-classpath")) {
                this.m_launchClasspath = this.parseClasspath(node.getChildNodes());
                continue;
            }
            if (((Element)node).getTagName().equals("boot-classpath")) {
                this.m_bootClasspath = this.parseClasspath(node.getChildNodes());
                continue;
            }
            if (((Element)node).getTagName().equals("boot-append-classpath")) {
                this.m_bootAppendClasspath = this.parseClasspath(node.getChildNodes());
                continue;
            }
            if (((Element)node).getTagName().equals("boot-prepend-classpath")) {
                this.m_bootPrependClasspath = this.parseClasspath(node.getChildNodes());
                continue;
            }
            if (!((Element)node).getTagName().equals("depends-on")) continue;
            this.m_dependsOn = this.parseDependsOn(node.getChildNodes());
        }
    }

    public String getName() {
        return this.m_name;
    }

    public URL[] getPrivateClasspath() {
        return this.retrieveURLArray(this.m_privateClasspath);
    }

    public String[] getSharedLibraryNames() {
        if (this.m_sharedLibraries == null) {
            return EMPTY_STRING_ARRAY;
        }
        return this.m_sharedLibraries.keySet().toArray(EMPTY_STRING_ARRAY);
    }

    public ArrayList getSharedLibraryList(String sharedLibraryName) {
        ArrayList list = (ArrayList)this.m_sharedLibraries.get(sharedLibraryName);
        if (list == null) {
            return new ArrayList();
        }
        return list;
    }

    public URL[] getSharedLibraryClasspath(String sharedLibraryName) {
        ArrayList classpath = (ArrayList)this.m_sharedLibraries.get(sharedLibraryName);
        if (classpath == null) {
            return EMPTY_URL_ARRAY;
        }
        return classpath == null ? null : classpath.toArray(EMPTY_URL_ARRAY);
    }

    public URL[] getGlobalClasspath() {
        return this.retrieveURLArray(this.m_globalClasspath);
    }

    public URL[] getLaunchClasspath() {
        return this.retrieveURLArray(this.m_launchClasspath);
    }

    public URL[] getBootClasspath() {
        return this.retrieveURLArray(this.m_bootClasspath);
    }

    public URL[] getBootAppendClasspath() {
        return this.retrieveURLArray(this.m_bootAppendClasspath);
    }

    public URL[] getBootPrependClasspath() {
        return this.retrieveURLArray(this.m_bootPrependClasspath);
    }

    private URL[] retrieveURLArray(ArrayList list) {
        if (list == null) {
            return EMPTY_URL_ARRAY;
        }
        return list.toArray(EMPTY_URL_ARRAY);
    }

    public String[] getDependsOn() {
        if (this.m_dependsOn == null) {
            return EMPTY_STRING_ARRAY;
        }
        return this.m_dependsOn.toArray(EMPTY_STRING_ARRAY);
    }

    private ArrayList parseClasspath(NodeList nodes) throws IOException {
        ArrayList<URL> classpath = new ArrayList<URL>();
        int numberOfNodes = nodes.getLength();
        for (int i = 0; i < numberOfNodes; ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || !((Element)node).getTagName().equals("path-element")) continue;
            File pathElement = new File(this.m_rootDirectory, node.getFirstChild().getNodeValue());
            if (!pathElement.exists()) {
                throw new IOException("Archive content does not exist: " + pathElement.toString());
            }
            classpath.add(pathElement.toURL());
        }
        return classpath;
    }

    private void parseSharedLibrary(NodeList nodes) throws IOException {
        String sharedLibraryName = null;
        ArrayList sharedLibraryClasspath = null;
        for (int i = nodes.getLength() - 1; i >= 0; --i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            if (((Element)node).getTagName().equals("shared-library-name")) {
                sharedLibraryName = node.getFirstChild().getNodeValue();
                continue;
            }
            if (!((Element)node).getTagName().equals("shared-library-classpath")) continue;
            sharedLibraryClasspath = this.parseClasspath(node.getChildNodes());
        }
        this.checkSharedLibraryName(sharedLibraryName);
        this.m_sharedLibraries.put(sharedLibraryName, sharedLibraryClasspath == null ? new ArrayList() : sharedLibraryClasspath);
    }

    private ArrayList parseDependsOn(NodeList nodes) throws IOException {
        ArrayList<String> dependsOn = new ArrayList<String>();
        int numberOfNodes = nodes.getLength();
        for (int i = 0; i < numberOfNodes; ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || !((Element)node).getTagName().equals("shared-library-name")) continue;
            String sharedLibraryName = node.getFirstChild().getNodeValue();
            this.checkSharedLibraryName(sharedLibraryName);
            dependsOn.add(sharedLibraryName);
        }
        return dependsOn;
    }

    private void checkSharedLibraryName(String sharedLibraryName) throws IOException {
        if (sharedLibraryName == null || sharedLibraryName.length() < 1) {
            throw new IOException("Invalid shared-library-name");
        }
    }
}

