/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.agent;

import com.sonicsw.mx.util.IEmptyArray;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;

class NotificationHandlerDelegate
implements Serializable {
    private static final long serialVersionUID = 8484344976480223320L;
    private static final short m_serialVersion = 0;
    private String m_destination;
    private String[] m_handledNotificationTypes = IEmptyArray.EMPTY_STRING_ARRAY;
    private long m_notificationSubscriptionTimeout;
    private transient long m_expirationTime;
    private transient boolean m_isDirty = false;

    NotificationHandlerDelegate(String destination) {
        this.m_destination = destination;
    }

    String getDestination() {
        return this.m_destination;
    }

    synchronized void setHandledNotificationTypes(String[] handledNotificationTypes) {
        boolean isDirty = false;
        if (handledNotificationTypes.length != this.m_handledNotificationTypes.length) {
            isDirty = true;
        } else {
            for (int i = 0; i < handledNotificationTypes.length; ++i) {
                boolean match = false;
                for (int j = 0; j < this.m_handledNotificationTypes.length; ++j) {
                    if (!handledNotificationTypes[i].equals(this.m_handledNotificationTypes[j])) continue;
                    match = true;
                    break;
                }
                if (match) continue;
                isDirty = true;
                break;
            }
        }
        if (isDirty) {
            this.m_handledNotificationTypes = handledNotificationTypes;
            this.m_isDirty = true;
        }
    }

    synchronized boolean handlesNotificationType(String notificationType) {
        for (int i = 0; i < this.m_handledNotificationTypes.length; ++i) {
            String prefix;
            if (this.m_handledNotificationTypes[i].equals(notificationType)) {
                return true;
            }
            int index = this.m_handledNotificationTypes[i].indexOf(42);
            if (index <= -1 || !notificationType.startsWith(prefix = this.m_handledNotificationTypes[i].substring(0, index - 1))) continue;
            return true;
        }
        return false;
    }

    long getNotificationSubscriptionTimeout() {
        return this.m_notificationSubscriptionTimeout;
    }

    void setNotificationSubscriptionTimeout(long timeout) {
        if (timeout != this.m_notificationSubscriptionTimeout) {
            this.m_notificationSubscriptionTimeout = timeout;
            this.m_isDirty = true;
        }
        this.m_expirationTime = System.currentTimeMillis() + this.m_notificationSubscriptionTimeout;
    }

    boolean hasExpired() {
        return System.currentTimeMillis() > this.m_expirationTime;
    }

    boolean isDirty() {
        return this.m_isDirty;
    }

    byte[] toByteArray() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(this);
        oos.close();
        byte[] bytes = baos.toByteArray();
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static NotificationHandlerDelegate fromByteArray(byte[] bytes) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bais;
        ByteArrayInputStream byteArrayInputStream = bais = new ByteArrayInputStream(bytes);
        synchronized (byteArrayInputStream) {
            ObjectInputStream ois = new ObjectInputStream(bais);
            return (NotificationHandlerDelegate)ois.readObject();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream stream) throws IOException {
        NotificationHandlerDelegate notificationHandlerDelegate = this;
        synchronized (notificationHandlerDelegate) {
            stream.writeInt(4);
            stream.writeUTF("serialVersion");
            stream.writeObject(new Short(0));
            stream.writeUTF("destination");
            stream.writeObject(this.m_destination);
            stream.writeUTF("handledTypes");
            stream.writeObject(this.m_handledNotificationTypes);
            stream.writeUTF("timeout");
            stream.writeObject(new Long(this.m_notificationSubscriptionTimeout));
        }
        this.m_isDirty = false;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        int count = stream.readInt();
        HashMap<String, Object> map = new HashMap<String, Object>(count);
        for (int i = 0; i < count; ++i) {
            String key = stream.readUTF();
            Object value = stream.readObject();
            map.put(key, value);
        }
        switch ((Short)map.remove("serialVersion")) {
            default: 
        }
        try {
            this.m_destination = (String)map.get("destination");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.m_handledNotificationTypes = (String[])map.get("handledTypes");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.setNotificationSubscriptionTimeout((Long)map.get("timeout"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_isDirty = false;
    }
}

