/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.directory.impl;

import com.sonicsw.mf.common.config.IBasicElement;
import com.sonicsw.mf.common.config.IDeltaElement;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.config.ITriggerDSContext;
import com.sonicsw.mf.common.config.query.Query;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.dirconfig.IDirIdentity;
import com.sonicsw.mf.framework.directory.impl.DirectoryService;

final class TriggerDSContext
implements ITriggerDSContext {
    private DirectoryService m_ds;

    TriggerDSContext(DirectoryService ds) {
        this.m_ds = ds;
    }

    public IDirElement getElement(String elementName) throws DirectoryServiceException {
        return this.m_ds.getElement(elementName, true, true);
    }

    public IDirElement[] getElements(Query query, boolean forUpdate) throws DirectoryServiceException {
        return this.m_ds.getElements(query, forUpdate, true);
    }

    public void setElement(IDeltaElement delta) throws DirectoryServiceException {
        this.setElement(delta, true);
    }

    public void setElement(IDeltaElement delta, boolean fireTriggers) throws DirectoryServiceException {
        this.m_ds.setElement(fireTriggers, (IBasicElement)delta, null);
    }

    public void deleteElement(String elementName) throws DirectoryServiceException {
        this.m_ds.deleteElements(new String[]{elementName});
    }

    public boolean directoryExists(String dirName) throws DirectoryServiceException {
        return this.m_ds.directoryExists(dirName);
    }

    public IElementIdentity[] listElements(String dirName) throws DirectoryServiceException {
        return this.m_ds.listElements(dirName);
    }

    public IDirIdentity[] listDirectories(String dirName) throws DirectoryServiceException {
        return this.m_ds.listDirectories(dirName);
    }

    public void deleteDirectory(String dirName) throws DirectoryServiceException {
        this.m_ds.deleteDirectory(dirName);
    }

    public void logMessage(String message, int severityLevel) {
        this.m_ds.logMessage(message, severityLevel);
    }

    public void logMessage(String message, Throwable throwable, int severityLevel) {
        this.m_ds.logMessage(message, throwable, severityLevel);
    }
}

