/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.mtstorage.impl.BTreeNoteInterface;
import com.sonicsw.mtstorage.impl.BitUtil;
import com.sonicsw.mtstorage.impl.INoteWriter;
import com.sonicsw.mtstorage.impl.LogicalNote;
import java.io.IOException;

abstract class BTreeKeyValuePairAbstractLogicalNote
extends LogicalNote
implements BTreeNoteInterface {
    private static final byte KEY_NULL = 1;
    private static final byte NEW_VALUE_NULL = 2;
    private static final byte NO_ACTION = 4;
    long m_treeDbk;
    boolean m_keyNull;
    byte[] m_key;
    int m_keyLength;
    int m_keyOffset;
    boolean m_valueNull;
    byte[] m_value;
    int m_valueLength;
    int m_valueOffset;
    boolean m_noAction;

    BTreeKeyValuePairAbstractLogicalNote() {
    }

    @Override
    abstract byte getType();

    @Override
    public int writeNote(INoteWriter writer) throws IOException {
        writer.write(this.getType());
        writer.write((byte)(this.m_start ? 1 : 0));
        int noteLength = 2;
        if (!this.m_start) {
            byte flags = 0;
            if (this.m_keyNull) {
                flags = (byte)(flags | 1);
            }
            if (this.m_valueNull) {
                flags = (byte)(flags | 2);
            }
            if (this.m_noAction) {
                flags = (byte)(flags | 4);
            }
            writer.write(flags);
            ++noteLength;
            if (!this.m_keyNull) {
                BitUtil.putShort(this.m_scratchBuffer, 0, (short)this.m_keyLength);
                writer.write(this.m_scratchBuffer, 0, 2);
                noteLength += 2;
                writer.write(this.m_key, 0, this.m_keyLength);
                noteLength += this.m_keyLength;
            }
            if (!this.m_valueNull) {
                BitUtil.putShort(this.m_scratchBuffer, 0, (short)this.m_valueLength);
                writer.write(this.m_scratchBuffer, 0, 2);
                noteLength += 2;
                writer.write(this.m_value, 0, this.m_valueLength);
                noteLength += this.m_valueLength;
            }
            BitUtil.putLong(this.m_scratchBuffer, 0, this.m_transactionNum);
            writer.write(this.m_scratchBuffer, 0, 8);
            noteLength += 8;
            BitUtil.putLong(this.m_scratchBuffer, 0, this.m_treeDbk);
            writer.write(this.m_scratchBuffer, 0, 8);
            noteLength += 8;
        }
        return noteLength;
    }

    @Override
    public void initNote(byte[] buffer, int offset) {
        int currentOffset = offset;
        boolean bl = this.m_start = buffer[currentOffset++] == 1;
        if (!this.m_start) {
            this.m_keyNull = (buffer[currentOffset] & 1) != 0;
            this.m_valueNull = (buffer[currentOffset] & 2) != 0;
            this.m_noAction = (buffer[currentOffset] & 4) != 0;
            ++currentOffset;
            if (!this.m_keyNull) {
                this.m_key = buffer;
                this.m_keyLength = BitUtil.getShort(buffer, currentOffset);
                this.m_keyOffset = currentOffset += 2;
                currentOffset += this.m_keyLength;
            }
            if (!this.m_valueNull) {
                this.m_value = buffer;
                this.m_valueLength = BitUtil.getShort(buffer, currentOffset);
                this.m_valueOffset = currentOffset += 2;
                currentOffset += this.m_valueLength;
            }
            this.m_transactionNum = BitUtil.getLong(buffer, currentOffset);
            this.m_treeDbk = BitUtil.getLong(buffer, currentOffset += 8);
        } else {
            this.m_transactionNum = 0L;
            this.m_treeDbk = 0L;
        }
    }

    void initNote() {
        this.m_start = true;
    }

    void initNote(long transactionNum, long treeDbk, byte[] key, byte[] value, boolean noAction) {
        this.m_transactionNum = transactionNum;
        this.m_start = false;
        this.m_treeDbk = treeDbk;
        this.m_keyNull = key == null;
        this.m_keyLength = key == null ? 0 : key.length;
        this.m_valueNull = value == null;
        this.m_valueLength = value == null ? 0 : value.length;
        this.m_key = key;
        this.m_value = value;
        this.m_noAction = noAction;
    }

    byte[] getKey() {
        if (this.m_keyNull) {
            return null;
        }
        return this.m_key;
    }

    int keyLength() {
        return this.m_keyLength;
    }

    int keyOffset() {
        return this.m_keyOffset;
    }

    byte[] getValue() {
        if (this.m_valueNull) {
            return null;
        }
        return this.m_value;
    }

    int valueLength() {
        return this.m_valueLength;
    }

    int valueOffset() {
        return this.m_valueOffset;
    }

    public long getBTreeDbk() {
        return this.m_treeDbk;
    }

    boolean getNoAction() {
        return this.m_noAction;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + " transaction: " + this.m_transactionNum + " start: " + this.m_start + " tree page: " + this.m_treeDbk;
    }
}

