/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.mtstorage.impl.AbstractNote;
import com.sonicsw.mtstorage.impl.BitUtil;
import com.sonicsw.mtstorage.impl.INote;
import com.sonicsw.mtstorage.impl.INoteWriter;
import com.sonicsw.mtstorage.impl.IRedoNoteInfo;
import java.io.IOException;

final class PageAllocationNote
extends AbstractNote
implements INote,
IRedoNoteInfo {
    static final byte NOTE_TYPE = 5;
    byte[] m_scratchBuffer = new byte[8];
    long m_allocatedPage;

    PageAllocationNote() {
    }

    @Override
    public long getPageNum() {
        return 0L;
    }

    @Override
    public int writeNote(INoteWriter writer) throws IOException {
        writer.write((byte)5);
        BitUtil.putLong(this.m_scratchBuffer, 0, this.m_allocatedPage);
        writer.write(this.m_scratchBuffer, 0, 8);
        return 9;
    }

    @Override
    public void initNote(byte[] buffer, int offset) {
        this.m_allocatedPage = BitUtil.getLong(buffer, offset);
    }

    void initNote(long allocatedPage) {
        this.m_allocatedPage = allocatedPage;
    }
}

