/*
 * Decompiled with CFR 0.152.
 */
package com.odi.imp;

import com.odi.ClassInfo;
import com.odi.FatalInternalException;
import com.odi.IPersistent;
import com.odi.ObjectException;
import com.odi.ObjectStoreException;
import com.odi.Placement;
import com.odi.imp.ArrayField;
import com.odi.imp.ClassField;
import com.odi.imp.Field;
import com.odi.imp.MutatingObjRef;
import com.odi.imp.ObjRefUtils;
import com.odi.imp.ObjectAccess;
import com.odi.imp.ObjectManager;
import com.odi.imp.ObjectReference;
import com.odi.imp.ObjectReferencesEnumeration;
import com.odi.imp.PoolElement;
import com.odi.imp.Reference;
import com.odi.imp.ReferenceType;
import com.odi.imp.StringField;
import com.odi.imp.Utilities;
import com.odi.tools.Accumulator;
import com.odi.tools.AccumulatorEntry;
import java.io.PrintStream;

public abstract class GenericObject
extends com.odi.GenericObject
implements PoolElement {
    protected byte[] rep;
    private int length;
    protected int[] mappingTable;
    protected ObjectManager objectManager;
    PoolElement next;
    protected ObjectReference objRef;
    private MutatingObjRef cachedObjRef;
    private static final int FIND_OBJECTS = 1;
    private static final int MIGRATE_STRINGS = 2;
    private static final int THROW_NON_STRING_EXCEPTION = 3;
    private static final int THROW_ANY_EXCEPTION = 4;
    private static final int FOUND_STRING = 1;
    private static final int FOUND_NON_STRING = 2;
    private static final int FOUND_NOTHING = 3;

    protected GenericObject(ObjectManager om) {
        this.objectManager = om;
    }

    @Override
    public Class getGenericObjectClass() throws ClassNotFoundException {
        return this.objectManager.schemaManager.getClassDescriptor(this.objRef.getAFTypeCode());
    }

    private static final GenericObject allocate(ObjectManager objectManager, ObjectReference objRef, boolean soft) {
        int AFTypeCode = objRef.getAFTypeCode();
        int size = objectManager.schemaManager.linearRepSize(AFTypeCode, objRef.getArrayElementCount());
        GenericObject go = (GenericObject)objectManager.theGOPool.get(objectManager, size, soft);
        if (go != null) {
            go.initialize(objectManager, objRef, AFTypeCode);
        }
        return go;
    }

    static GenericObject allocateEmbedded(ObjectManager objectManager, ObjectReference owningObjRef, int AFTypeCode) {
        int size = objectManager.schemaManager.linearRepSize(AFTypeCode, 0);
        GenericObject go = (GenericObject)objectManager.theGOPool.get(objectManager, size, false);
        go.initialize(objectManager, owningObjRef, AFTypeCode);
        return go;
    }

    public static final GenericObject allocate(ObjectManager objectManager, Placement place, Object object, boolean soft) {
        int arrayElementCount;
        int AFTypeCode = objectManager.schemaManager.getAFTypeCode(object);
        int size = objectManager.schemaManager.linearRepSize(AFTypeCode, arrayElementCount = objectManager.computeArrayElementCount(object));
        GenericObject go = (GenericObject)objectManager.theGOPool.get(objectManager, size, soft);
        if (go == null) {
            return null;
        }
        if (go.cachedObjRef == null) {
            go.cachedObjRef = objectManager.objRefFactory.createMutating();
        }
        go.cachedObjRef.place = place;
        go.cachedObjRef.AFTypeCode = AFTypeCode;
        go.cachedObjRef.arrayElementCount = arrayElementCount;
        go.initialize(objectManager, go.cachedObjRef, AFTypeCode);
        return go;
    }

    public static final GenericObject allocate(ObjectManager objectManager, ObjectReference objRef) {
        return GenericObject.allocate(objectManager, objRef, false);
    }

    public void deallocate() {
        if (this.objectManager != null) {
            this.objectManager.theGOPool.ret(this);
        }
    }

    public void setDefaultContents() {
        int len = this.rep.length;
        for (int i = 0; i < len; ++i) {
            this.rep[i] = 0;
        }
        this.makeReferencesNull();
    }

    public void makeReferencesNull() {
        ObjectReferencesEnumeration objRefEnum = this.objectManager.schemaManager.getObjectReferencesEnumeration(this.objRef.getAFTypeCode(), this.objRef.getArrayElementCount());
        if (objRefEnum == null) {
            return;
        }
        while (objRefEnum.hasMoreElements()) {
            int offset = objRefEnum.nextElement();
            if (objRefEnum.isLazyRef()) {
                objRefEnum.getLazyRefType().encodeNull(this.rep, offset, this.objectManager.objectAccess);
                continue;
            }
            this.objectManager.objectAccess.encodeNull(this.rep, offset);
        }
    }

    private void explainBadReference(PrintStream out, ObjectReference badRef, String explanation, int offset) {
        out.println();
        if (Utilities.isArrayTypeCode(this.objRef.getAFTypeCode())) {
            out.println("The array element " + offset / this.objectManager.objectAccess.referenceSize);
        } else {
            out.println("The data member at offset " + offset);
        }
        out.println("in the object: " + ObjRefUtils.typedOIDString(this.objRef));
        out.println("contains an invalid reference to " + ObjRefUtils.OIDString(badRef));
        out.println("The reference is invalid because " + explanation);
    }

    private boolean verifyReference(PrintStream out, int offset) {
        if (this.objectManager.objectAccess.isNull(this.rep, offset)) {
            return true;
        }
        if (this.objectManager.objectAccess.isImmediateObject(this.rep, offset)) {
            return true;
        }
        MutatingObjRef tempObjRef = this.objectManager.objRefFactory.createMutating();
        tempObjRef.setAttributes(this.rep, offset);
        try {
            this.objectManager.sv.validate(tempObjRef);
        }
        catch (ObjectException e) {
            this.explainBadReference(out, tempObjRef, e.getMessage(), offset);
            return false;
        }
        return true;
    }

    private boolean verifyLazyReference(PrintStream out, int offset, ReferenceType refType) {
        if (refType.isNullEncoding(this.rep, offset, this.objectManager.objectAccess)) {
            return true;
        }
        ObjectReference lazyObjRef = this.objectManager.objRefFactory.createLazyReference(this.objRef, this.objectManager.objectAccess, this.rep, offset, refType);
        try {
            this.objectManager.sv.validate(lazyObjRef);
        }
        catch (ObjectException e) {
            this.explainBadReference(out, lazyObjRef, e.getMessage(), offset);
            return false;
        }
        return true;
    }

    boolean check(PrintStream out) {
        boolean ok = true;
        ObjectReferencesEnumeration objRefEnum = this.objectManager.schemaManager.getObjectReferencesEnumeration(this.objRef.getAFTypeCode(), this.objRef.getArrayElementCount());
        if (objRefEnum == null) {
            return ok;
        }
        while (objRefEnum.hasMoreElements()) {
            int offset = objRefEnum.nextElement();
            if (objRefEnum.isLazyRef()) {
                ok &= this.verifyLazyReference(out, offset, objRefEnum.getLazyRefType());
                continue;
            }
            ok &= this.verifyReference(out, offset);
        }
        return ok;
    }

    void showObj(ObjectReference objRef, PrintStream out, Accumulator acc, boolean showObj, boolean showData) {
        int totalSize = this.serverStorageSize();
        String typeName = null;
        int AFTypeCode = objRef.getAFTypeCode();
        boolean isArray = Utilities.isArrayTypeCode(AFTypeCode);
        boolean isString = false;
        int arrayElementCount = 0;
        if (isArray) {
            arrayElementCount = objRef.getArrayElementCount();
            int elementTypeCode = Utilities.arrayElementTypeCode(AFTypeCode);
            int nDims = Utilities.arrayDimensions(AFTypeCode);
            if (Utilities.isStringTypeCode(AFTypeCode) || elementTypeCode == 15) {
                typeName = "java.lang.String";
                if (nDims == 1) {
                    isString = true;
                }
                --nDims;
            } else {
                typeName = this.objectManager.schemaManager.getTypeName(elementTypeCode);
            }
            for (int i = 0; i < nDims; ++i) {
                typeName = typeName + "[]";
            }
        } else {
            typeName = ObjRefUtils.typeString(objRef);
        }
        acc.Accumulate(typeName, totalSize);
        if (showObj || showData) {
            String oid = ObjRefUtils.OIDString(objRef);
            String size = Integer.toString(totalSize);
            String count = "";
            if (isArray) {
                count = Integer.toString(arrayElementCount);
            }
            out.println(AccumulatorEntry.padLeft(oid, 18) + AccumulatorEntry.padLeft(count, 12) + AccumulatorEntry.padLeft(size, 12) + "  " + typeName);
        }
        if (showData) {
            if (isString) {
                this.showStringValue(arrayElementCount, out);
            } else if (isArray) {
                this.showReferences(AFTypeCode, arrayElementCount, out);
            } else {
                this.showReferences(AFTypeCode, 0, out);
            }
            out.println();
        }
    }

    private void showStringValue(int length, PrintStream out) {
        ObjectAccess acc = this.objectManager.objectAccess;
        out.println("        Value: \"" + ObjectAccess.decodeString(this.rep, 0, length, new char[length]) + "\"");
    }

    private void showReferences(int AFTypeCode, int count, PrintStream out) {
        ObjectManager mgr = this.objectManager;
        ObjectAccess acc = mgr.objectAccess;
        MutatingObjRef tempObjRef = mgr.objRefFactory.createMutating();
        ObjectReferencesEnumeration refs = mgr.schemaManager.getObjectReferencesEnumeration(AFTypeCode, count);
        if (refs == null || !refs.hasMoreElements()) {
            return;
        }
        out.println("        Contains references:");
        StringBuffer buf = new StringBuffer();
        while (refs.hasMoreElements()) {
            int offset = refs.nextElement();
            buf.append(AccumulatorEntry.padLeft(Integer.toString(offset), 15));
            if (refs.isLazyRef()) {
                buf.append(":: ");
                ReferenceType refType = refs.getLazyRefType();
                if (refType.isNullEncoding(this.rep, offset, acc)) {
                    buf.append(ObjRefUtils.nullOIDString);
                } else {
                    long oid = refType.decode(this.rep, offset, acc).getOID();
                    buf.append(ObjRefUtils.OIDString(oid));
                }
            } else {
                buf.append(": ");
                if (acc.isNull(this.rep, offset)) {
                    buf.append(ObjRefUtils.nullOIDString);
                } else if (acc.isImmediateObject(this.rep, offset)) {
                    buf.append(mgr.decodeImmediateObject(this.rep, offset));
                } else {
                    tempObjRef.setAttributes(this.rep, offset);
                    buf.append(ObjRefUtils.OIDString(tempObjRef));
                }
            }
            out.println(buf);
            buf.setLength(0);
        }
    }

    private void initialize(ObjectManager objectManager, ObjectReference objRef, int AFTypeCode) {
        this.objRef = objRef;
        this.mappingTable = objectManager.schemaManager.getMappingTable(AFTypeCode);
    }

    @Override
    public final byte getByteField(int fieldNumber, ClassInfo fieldClass) {
        ObjectAccess cfr_ignored_0 = this.objectManager.objectAccess;
        return ObjectAccess.decodeByte(this.rep, this.mappingTable[fieldNumber + fieldClass.fieldNumberOffset]);
    }

    @Override
    public final char getCharField(int fieldNumber, ClassInfo fieldClass) {
        ObjectAccess cfr_ignored_0 = this.objectManager.objectAccess;
        return ObjectAccess.decodeChar(this.rep, this.mappingTable[fieldNumber + fieldClass.fieldNumberOffset]);
    }

    @Override
    public final short getShortField(int fieldNumber, ClassInfo fieldClass) {
        ObjectAccess cfr_ignored_0 = this.objectManager.objectAccess;
        return ObjectAccess.decodeShort(this.rep, this.mappingTable[fieldNumber + fieldClass.fieldNumberOffset]);
    }

    @Override
    public final int getIntField(int fieldNumber, ClassInfo fieldClass) {
        ObjectAccess cfr_ignored_0 = this.objectManager.objectAccess;
        return ObjectAccess.decodeInt(this.rep, this.mappingTable[fieldNumber + fieldClass.fieldNumberOffset]);
    }

    @Override
    public final Reference getLazyReferenceField(int fieldNumber, ClassInfo fieldClass, ReferenceType referenceType) {
        return referenceType.decode(this.rep, this.mappingTable[fieldNumber + fieldClass.fieldNumberOffset], this.objectManager.objectAccess);
    }

    @Override
    public final long getLongField(int fieldNumber, ClassInfo fieldClass) {
        ObjectAccess cfr_ignored_0 = this.objectManager.objectAccess;
        return ObjectAccess.decodeLong(this.rep, this.mappingTable[fieldNumber + fieldClass.fieldNumberOffset]);
    }

    @Override
    public final float getFloatField(int fieldNumber, ClassInfo fieldClass) {
        ObjectAccess cfr_ignored_0 = this.objectManager.objectAccess;
        return ObjectAccess.decodeFloat(this.rep, this.mappingTable[fieldNumber + fieldClass.fieldNumberOffset]);
    }

    @Override
    public final double getDoubleField(int fieldNumber, ClassInfo fieldClass) {
        ObjectAccess cfr_ignored_0 = this.objectManager.objectAccess;
        return ObjectAccess.decodeDouble(this.rep, this.mappingTable[fieldNumber + fieldClass.fieldNumberOffset]);
    }

    @Override
    public final boolean getBooleanField(int fieldNumber, ClassInfo fieldClass) {
        ObjectAccess cfr_ignored_0 = this.objectManager.objectAccess;
        return ObjectAccess.decodeBoolean(this.rep, this.mappingTable[fieldNumber + fieldClass.fieldNumberOffset]);
    }

    @Override
    public final String getStringField(int fieldNumber, ClassInfo fieldClass) {
        return (String)this.objectManager.getJavaReference(this.rep, this.mappingTable[fieldNumber + fieldClass.fieldNumberOffset]);
    }

    @Override
    public final Object getClassField(int fieldNumber, ClassInfo fieldClass) {
        return this.objectManager.getJavaReference(this.rep, this.mappingTable[fieldNumber + fieldClass.fieldNumberOffset]);
    }

    @Override
    public final Object getArrayField(int fieldNumber, ClassInfo fieldClass) {
        return this.objectManager.getJavaReference(this.rep, this.mappingTable[fieldNumber + fieldClass.fieldNumberOffset]);
    }

    @Override
    public final Object getInterfaceField(int fieldNumber, ClassInfo fieldClass) {
        return this.objectManager.getJavaReference(this.rep, this.mappingTable[fieldNumber + fieldClass.fieldNumberOffset]);
    }

    public final ObjectReference getObjectReferenceField(int fieldNumber, ClassInfo fieldClass) {
        int offset = this.mappingTable[fieldNumber + fieldClass.fieldNumberOffset];
        if (this.objectManager.objectAccess.isImmediateObject(this.rep, offset) || this.objectManager.objectAccess.isNull(this.rep, offset)) {
            return null;
        }
        MutatingObjRef objRef = this.objectManager.objRefFactory.createMutating();
        objRef.setAttributes(this.rep, offset);
        return objRef;
    }

    public final int getFieldOffset(int fieldNumber, ClassInfo fieldClass) {
        return this.mappingTable[fieldNumber + fieldClass.fieldNumberOffset];
    }

    @Override
    public final Object getEmbeddedClassField(int fieldNumber, ClassInfo fieldClass, IPersistent object) {
        ClassField cf = (ClassField)fieldClass.getFields()[fieldNumber - 1];
        if (!cf.isEmbedded()) {
            throw new IllegalArgumentException("getEmbeddedClassField() on non-embedded field:" + cf.getName());
        }
        String cname = cf.getClassName();
        if (!cname.equals(object.getClass().getName())) {
            throw new IllegalArgumentException("The declared type of the embedded field \"" + cname + "\" differs from the type of the \"" + object + "\" argument.");
        }
        int start = this.mappingTable[fieldNumber + fieldClass.fieldNumberOffset];
        return this.objectManager.getEmbeddedObject(this.rep, start, object);
    }

    @Override
    public final Object getEmbeddedArrayField(int fieldNumber, ClassInfo fieldClass, Object array) {
        ArrayField af = (ArrayField)fieldClass.getFields()[fieldNumber - 1];
        if (!af.isEmbedded()) {
            throw new IllegalArgumentException("getEmbeddedClassField() on non-embedded field:" + af.getName());
        }
        if (!af.verifyEmbeddedArray(array)) {
            throw new IllegalArgumentException("the type of the array argument:" + array.getClass() + "is incompatible with the embedded array field declaration: " + af.getTypeName());
        }
        this.objectManager.objectAccess.decodeArrayContents(this, this.mappingTable[fieldNumber + fieldClass.fieldNumberOffset], array);
        return array;
    }

    @Override
    public final Reference[] getEmbeddedLazyReferenceArrayField(int fieldNumber, ClassInfo fieldClass, int arraySize, ReferenceType refType) {
        ArrayField af = (ArrayField)fieldClass.getFields()[fieldNumber - 1];
        if (!af.isEmbedded()) {
            throw new IllegalArgumentException("getEmbeddedClassField() on non-embedded field:" + af.getName());
        }
        Reference[] array = new Reference[arraySize];
        this.objectManager.objectAccess.decodeReferenceArrayContents(this, this.mappingTable[fieldNumber + fieldClass.fieldNumberOffset], array, refType);
        return array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String getEmbeddedStringField(int fieldNumber, ClassInfo fieldClass) {
        StringField sf = (StringField)fieldClass.getFields()[fieldNumber - 1];
        if (!sf.isEmbedded()) {
            throw new IllegalArgumentException("getEmbeddedStringField() on non-embedded field:" + sf.getName());
        }
        int j = this.mappingTable[fieldNumber + fieldClass.fieldNumberOffset];
        ObjectAccess cfr_ignored_0 = this.objectManager.objectAccess;
        int stringLength = ObjectAccess.decodeShort(this.rep, j);
        if (stringLength == Short.MIN_VALUE) {
            return null;
        }
        j += 2;
        ObjectManager objectManager = this.objectManager;
        synchronized (objectManager) {
            char[] buffer = this.objectManager.getCharBuffer(stringLength);
            int i = 0;
            while (i < stringLength) {
                buffer[i] = (char)(this.rep[j] << 8 | this.rep[j + 1]);
                ++i;
                j += 2;
            }
            return new String(buffer, 0, stringLength);
        }
    }

    @Override
    public final void setByteField(int fieldNumber, byte fieldValue, ClassInfo fieldClass) {
        ObjectAccess cfr_ignored_0 = this.objectManager.objectAccess;
        ObjectAccess.encodeByte(this.rep, this.mappingTable[fieldNumber + fieldClass.fieldNumberOffset], fieldValue);
    }

    @Override
    public final void setCharField(int fieldNumber, char fieldValue, ClassInfo fieldClass) {
        ObjectAccess cfr_ignored_0 = this.objectManager.objectAccess;
        ObjectAccess.encodeChar(this.rep, this.mappingTable[fieldNumber + fieldClass.fieldNumberOffset], fieldValue);
    }

    @Override
    public final void setShortField(int fieldNumber, short fieldValue, ClassInfo fieldClass) {
        ObjectAccess cfr_ignored_0 = this.objectManager.objectAccess;
        ObjectAccess.encodeShort(this.rep, this.mappingTable[fieldNumber + fieldClass.fieldNumberOffset], fieldValue);
    }

    @Override
    public final void setIntField(int fieldNumber, int fieldValue, ClassInfo fieldClass) {
        ObjectAccess cfr_ignored_0 = this.objectManager.objectAccess;
        ObjectAccess.encodeInt(this.rep, this.mappingTable[fieldNumber + fieldClass.fieldNumberOffset], fieldValue);
    }

    @Override
    public final void setLazyReferenceField(int fieldNumber, Reference referenceValue, ClassInfo fieldClass, ReferenceType refType) {
        refType.encode(this.rep, this.mappingTable[fieldNumber + fieldClass.fieldNumberOffset], referenceValue, this.objectManager.objectAccess);
    }

    @Override
    public final void setLongField(int fieldNumber, long fieldValue, ClassInfo fieldClass) {
        ObjectAccess cfr_ignored_0 = this.objectManager.objectAccess;
        ObjectAccess.encodeLong(this.rep, this.mappingTable[fieldNumber + fieldClass.fieldNumberOffset], fieldValue);
    }

    @Override
    public final void setFloatField(int fieldNumber, float fieldValue, ClassInfo fieldClass) {
        ObjectAccess cfr_ignored_0 = this.objectManager.objectAccess;
        ObjectAccess.encodeFloat(this.rep, this.mappingTable[fieldNumber + fieldClass.fieldNumberOffset], fieldValue);
    }

    @Override
    public final void setDoubleField(int fieldNumber, double fieldValue, ClassInfo fieldClass) {
        ObjectAccess cfr_ignored_0 = this.objectManager.objectAccess;
        ObjectAccess.encodeDouble(this.rep, this.mappingTable[fieldNumber + fieldClass.fieldNumberOffset], fieldValue);
    }

    @Override
    public final void setBooleanField(int fieldNumber, boolean fieldValue, ClassInfo fieldClass) {
        ObjectAccess cfr_ignored_0 = this.objectManager.objectAccess;
        ObjectAccess.encodeBoolean(this.rep, this.mappingTable[fieldNumber + fieldClass.fieldNumberOffset], fieldValue);
    }

    @Override
    public final void setStringField(int fieldNumber, String fieldValue, ClassInfo fieldClass) {
        this.setClassField(fieldNumber, fieldValue, fieldClass);
    }

    @Override
    public final void setClassField(int fieldNumber, Object fieldValue, ClassInfo fieldClass) {
        this.objectManager.putJavaReference(this.rep, this.mappingTable[fieldNumber + fieldClass.fieldNumberOffset], fieldValue, ObjRefUtils.getCluster(this.objRef), true);
    }

    @Override
    public final void setArrayField(int fieldNumber, Object fieldValue, ClassInfo fieldClass) {
        this.objectManager.putJavaReference(this.rep, this.mappingTable[fieldNumber + fieldClass.fieldNumberOffset], fieldValue, ObjRefUtils.getCluster(this.objRef), false);
    }

    @Override
    public final void setInterfaceField(int fieldNumber, Object fieldValue, ClassInfo fieldClass) {
        this.objectManager.putJavaReference(this.rep, this.mappingTable[fieldNumber + fieldClass.fieldNumberOffset], fieldValue, ObjRefUtils.getCluster(this.objRef), false);
    }

    @Override
    public final void setEmbeddedClassField(int fieldNumber, IPersistent fieldValue, ClassInfo fieldClass) {
        ClassField cf = (ClassField)fieldClass.getFields()[fieldNumber - 1];
        if (!cf.isEmbedded()) {
            throw new IllegalArgumentException("getEmbeddedClassField() on non-embedded field:" + cf.getName());
        }
        String cname = cf.getClassName();
        if (!cname.equals(fieldValue.getClass().getName())) {
            throw new IllegalArgumentException("The declared type of the embedded field \"" + cname + "\" differs from the type of the \"" + fieldValue + "\" argument.");
        }
        this.objectManager.setEmbeddedObject(this, this.mappingTable[fieldNumber + fieldClass.fieldNumberOffset], fieldValue);
    }

    @Override
    public final void setEmbeddedArrayField(int fieldNumber, Object fieldValue, ClassInfo fieldClass) {
        ArrayField af = (ArrayField)fieldClass.getFields()[fieldNumber - 1];
        if (!af.isEmbedded()) {
            throw new IllegalArgumentException("getEmbeddedClassField() on non-embedded field:" + af.getName());
        }
        if (!af.verifyEmbeddedArray(fieldValue)) {
            throw new IllegalArgumentException("the type of the array argument:" + fieldValue.getClass() + "is incompatible with the embedded array field declaration: " + af.getTypeName());
        }
        this.objectManager.objectAccess.encodeArrayContents(this, this.mappingTable[fieldNumber + fieldClass.fieldNumberOffset], fieldValue);
    }

    @Override
    public final void setEmbeddedLazyReferenceArrayField(int fieldNumber, Reference[] fieldValue, ClassInfo fieldClass, ReferenceType refType) {
        ArrayField af = (ArrayField)fieldClass.getFields()[fieldNumber - 1];
        if (!af.isEmbedded()) {
            throw new IllegalArgumentException("getEmbeddedClassField() on non-embedded field:" + af.getName());
        }
        if (!af.verifyEmbeddedArray(fieldValue)) {
            throw new IllegalArgumentException("the type of the array argument:" + fieldValue.getClass() + "is incompatible with the embedded array field declaration: " + af.getTypeName());
        }
        this.objectManager.objectAccess.encodeReferenceArrayContents(this, this.mappingTable[fieldNumber + fieldClass.fieldNumberOffset], fieldValue, refType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setEmbeddedStringField(int fieldNumber, String fieldValue, ClassInfo fieldClass) {
        Field f = (Field)fieldClass.getFields()[fieldNumber - 1];
        StringField sf = (StringField)fieldClass.getFields()[fieldNumber - 1];
        if (!sf.isEmbedded()) {
            throw new ObjectStoreException("setEmbeddedStringField() on non-embedded field:" + sf.getName());
        }
        int j = this.mappingTable[fieldNumber + fieldClass.fieldNumberOffset];
        if (fieldValue == null) {
            ObjectAccess cfr_ignored_0 = this.objectManager.objectAccess;
            ObjectAccess.encodeShort(this.rep, j, (short)Short.MIN_VALUE);
            return;
        }
        int stringLength = fieldValue.length();
        if (stringLength > sf.getMaxEmbeddedLength()) {
            throw new ObjectStoreException("string length:" + stringLength + " exceeds maximum the maximum length:" + sf.getMaxEmbeddedLength() + " for field:" + sf.getName());
        }
        ObjectAccess cfr_ignored_1 = this.objectManager.objectAccess;
        ObjectAccess.encodeShort(this.rep, j, (short)stringLength);
        j += 2;
        ObjectManager objectManager = this.objectManager;
        synchronized (objectManager) {
            char[] buffer = this.objectManager.getChars(fieldValue, stringLength);
            int i = 0;
            while (i < stringLength) {
                char c = buffer[i];
                this.rep[j] = (byte)(c >> 8);
                this.rep[j + 1] = (byte)c;
                ++i;
                j += 2;
            }
        }
    }

    public abstract void fetch();

    public void store(Object object) {
        this.serverStore(0);
    }

    public void createFullObject(Object object) {
        this.serverCreateFullObject(0);
    }

    protected abstract void serverStore(int var1);

    protected abstract void serverCreateFullObject(int var1);

    public abstract int serverStorageSize();

    @Override
    public void initialize(int size) {
        this.rep = new byte[size];
    }

    @Override
    public PoolElement getNext() {
        return this.next;
    }

    @Override
    public void setNext(PoolElement pelt) {
        this.next = pelt;
    }

    @Override
    public int getSize() {
        return this.rep.length;
    }

    @Override
    public void setSize(int l) {
        this.length = l;
    }

    public int getLength() {
        return this.length;
    }

    @Override
    public byte[] getData() {
        return this.rep;
    }

    @Override
    public void setData(byte[] newBytes) {
        this.rep = newBytes;
    }

    @Override
    public Object getAuxData() {
        return this.objectManager;
    }

    @Override
    public void setAuxData(Object o) {
        if (o != this.objectManager) {
            throw new FatalInternalException("wrong ObjectManager");
        }
    }

    public final ObjectReference getObjRef() {
        return this.objRef;
    }
}

