/*
 * Decompiled with CFR 0.152.
 */
package com.odi.util;

import java.util.Enumeration;
import java.util.Properties;

public class MetricsAnalysis {
    String m_pattern;
    Properties m_oldFiltered;
    Properties m_filtered;
    Properties m_incremental;
    Properties m_oldIncremental;

    public MetricsAnalysis(String metricsPattern) {
        this.m_pattern = metricsPattern;
    }

    public Properties filterMetrics(Properties props) {
        this.m_oldFiltered = this.m_filtered;
        this.m_filtered = new Properties();
        Enumeration<?> propKeys = props.propertyNames();
        while (propKeys.hasMoreElements()) {
            String key = (String)propKeys.nextElement();
            if (key.indexOf(this.m_pattern) == -1) continue;
            this.m_filtered.setProperty(key, props.getProperty(key));
        }
        return this.m_filtered;
    }

    public Properties getIncremental() {
        this.m_oldIncremental = this.m_oldIncremental;
        this.m_incremental = new Properties();
        if (this.m_oldFiltered == null) {
            return this.m_filtered;
        }
        Enumeration<?> propKeys = this.m_filtered.propertyNames();
        while (propKeys.hasMoreElements()) {
            String key = (String)propKeys.nextElement();
            Long newValue = new Long(this.m_filtered.getProperty(key));
            Long oldValue = new Long(this.m_oldFiltered.getProperty(key));
            this.m_incremental.setProperty(key, new Long(newValue - oldValue).toString());
        }
        return this.m_incremental;
    }

    public Properties getPrecentIncrease() {
        Properties precnetIncrease = new Properties();
        if (this.m_oldIncremental == null) {
            return new Properties();
        }
        Enumeration<?> propKeys = this.m_incremental.propertyNames();
        while (propKeys.hasMoreElements()) {
            String key = (String)propKeys.nextElement();
            Long newValue = new Long(this.m_incremental.getProperty(key));
            Long oldValue = new Long(this.m_incremental.getProperty(key));
            this.m_incremental.setProperty(key, new Float(newValue * 100L / oldValue).toString());
        }
        return precnetIncrease;
    }
}

