/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.directory.impl;

import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IDeltaAttributeSet;
import com.sonicsw.mf.common.config.IDeltaElement;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.NotModifiedAttException;
import com.sonicsw.mf.common.config.query.AttributeName;
import com.sonicsw.mf.framework.IAuditManager;
import com.sonicsw.mf.framework.directory.impl.DirectoryService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

class ChangeAuditor {
    private DirectoryService m_ds;
    private IAuditManager m_auditManager;
    private ArrayList m_auditRecords;

    ChangeAuditor(DirectoryService ds, IAuditManager auditManager) {
        this.m_ds = ds;
        this.m_auditManager = auditManager;
        this.m_auditRecords = new ArrayList();
    }

    private String auditAttribute(String name, Object value) {
        return this.auditAttribute(name, value, null);
    }

    private String auditAttribute(String name, Object value, String action) {
        String valueString = null;
        if (value instanceof IAttributeSet) {
            valueString = this.auditAttributeSet((IAttributeSet)value);
            if (valueString.length() == 0) {
                return "";
            }
        } else {
            valueString = value.toString();
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<").append(name);
        if (action != null) {
            sb.append(" action=\"").append(action).append("\"");
        }
        sb.append(">");
        sb.append(valueString);
        sb.append("</").append(name).append(">");
        return sb.toString();
    }

    private String auditAttributeSet(IAttributeSet set) {
        StringBuffer sb = new StringBuffer();
        HashMap map = set.getAttributes();
        for (Map.Entry entry : map.entrySet()) {
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            sb.append(this.auditAttribute(name, value));
        }
        return sb.toString();
    }

    private String auditDeltaAttributeSet(IDeltaAttributeSet set, AttributeName setName, IElement beforeImage) {
        AttributeName fullName;
        String name;
        int i;
        StringBuffer sb = new StringBuffer();
        String[] delAttrs = set.getDeletedAttributesNames();
        String[] newAttrs = set.getNewAttributesNames();
        String[] modAttrs = set.getModifiedAttributesNames();
        if (delAttrs != null) {
            for (i = 0; i < delAttrs.length; ++i) {
                name = delAttrs[i];
                fullName = setName.createClone().setNextComponent(name);
                Object value = beforeImage.getAttribute(fullName);
                sb.append(this.auditAttribute(name, value, "delete"));
            }
        }
        if (newAttrs != null) {
            for (i = 0; i < newAttrs.length; ++i) {
                name = newAttrs[i];
                Object value = this.retrieveValue(set, name);
                sb.append(this.auditAttribute(name, value, "create"));
            }
        }
        if (modAttrs != null) {
            for (i = 0; i < modAttrs.length; ++i) {
                name = modAttrs[i];
                fullName = setName.createClone().setNextComponent(name);
                Object newValue = this.retrieveValue(set, name);
                if (newValue instanceof IDeltaAttributeSet) {
                    String attrs = this.auditDeltaAttributeSet((IDeltaAttributeSet)newValue, fullName, beforeImage);
                    if (attrs.length() <= 0) continue;
                    sb.append(this.auditAttribute(name, attrs, "update"));
                    continue;
                }
                Object oldValue = beforeImage.getAttribute(fullName);
                sb.append(this.auditAttribute(name, oldValue, "delete"));
                sb.append(this.auditAttribute(name, newValue, "create"));
            }
        }
        return sb.toString();
    }

    private Object retrieveValue(IDeltaAttributeSet set, String name) {
        Object newValue = null;
        try {
            newValue = set.getNewValue(name);
        }
        catch (NotModifiedAttException notModifiedAttException) {
            // empty catch block
        }
        return newValue;
    }

    private String auditLogicalName(String storageName) {
        String logicalName = null;
        try {
            logicalName = this.m_ds.storageToLogical(storageName);
        }
        catch (Exception e) {
            logicalName = null;
        }
        return logicalName;
    }

    private String auditContents(IElement element) {
        String type = element.getIdentity().getType();
        IAttributeSet attributes = element.getAttributes();
        StringBuffer sb = new StringBuffer();
        sb.append("<").append(type).append(">");
        sb.append(this.auditAttributeSet(attributes));
        sb.append("</").append(type).append(">");
        return sb.toString();
    }

    private String auditDelta(IDeltaElement delta, IElement beforeImage) {
        String type = delta.getIdentity().getType();
        IDeltaAttributeSet set = (IDeltaAttributeSet)delta.getDeltaAttributes();
        StringBuffer sb = new StringBuffer();
        sb.append("<").append(type).append(">");
        sb.append(this.auditDeltaAttributeSet(set, new AttributeName(), beforeImage));
        sb.append("</").append(type).append(">");
        return sb.toString();
    }

    void auditCreate(IElement element) {
        AuditRecord rec = new AuditRecord();
        rec.storagePath = element.getIdentity().getName();
        rec.logicalPath = this.auditLogicalName(rec.storagePath);
        rec.action = 0;
        rec.detail = this.auditContents(element);
        this.m_auditRecords.add(rec);
    }

    void auditDelete(IElement element, String logicalName) {
        AuditRecord rec = new AuditRecord();
        rec.storagePath = element.getIdentity().getName();
        rec.logicalPath = logicalName;
        rec.action = 2;
        rec.detail = this.auditContents(element);
        this.m_auditRecords.add(rec);
    }

    void auditUpdate(IDeltaElement delta, IElement beforeImage) {
        AuditRecord rec = new AuditRecord();
        rec.storagePath = delta.getIdentity().getName();
        rec.logicalPath = this.auditLogicalName(rec.storagePath);
        rec.action = 1;
        rec.detail = this.auditDelta(delta, beforeImage);
        this.m_auditRecords.add(rec);
    }

    void auditFolderCreate(String path) {
        AuditRecord rec = new AuditRecord();
        rec.storagePath = null;
        rec.logicalPath = path;
        rec.action = 0;
        rec.detail = "<MF_PATH>" + path + "</MF_PATH>";
        this.m_auditRecords.add(rec);
    }

    void auditFolderDelete(String path) {
        AuditRecord rec = new AuditRecord();
        rec.storagePath = null;
        rec.logicalPath = path;
        rec.action = 2;
        rec.detail = "<MF_PATH>" + path + "</MF_PATH>";
        this.m_auditRecords.add(rec);
    }

    void auditRename(String oldPath, String newPath, String storagePath) {
        AuditRecord rec = new AuditRecord();
        rec.storagePath = storagePath;
        rec.logicalPath = newPath;
        rec.action = 3;
        StringBuffer sb = new StringBuffer();
        sb.append("<MF_PATH action=\"delete\">").append(oldPath).append("</MF_PATH>");
        sb.append("<MF_PATH action=\"create\">").append(newPath).append("</MF_PATH>");
        rec.detail = sb.toString();
        this.m_auditRecords.add(rec);
    }

    void recordAudit() {
        for (int i = 0; i < this.m_auditRecords.size(); ++i) {
            AuditRecord rec = (AuditRecord)this.m_auditRecords.get(i);
            if (rec.storagePath == null || !rec.storagePath.startsWith("/_MFRuntime")) continue;
            this.m_auditRecords.remove(i);
            --i;
        }
        int size = this.m_auditRecords.size();
        if (size == 0) {
            return;
        }
        String[] logicalPaths = new String[size];
        String[] storagePaths = new String[size];
        int[] actions = new int[size];
        String[] details = new String[size];
        for (int i = 0; i < size; ++i) {
            AuditRecord rec = (AuditRecord)this.m_auditRecords.get(i);
            logicalPaths[i] = rec.logicalPath;
            storagePaths[i] = rec.storagePath;
            actions[i] = rec.action;
            details[i] = rec.detail;
        }
        this.m_auditManager.recordConfigureEvent(logicalPaths, storagePaths, actions, details);
    }

    private class AuditRecord {
        String logicalPath;
        String storagePath;
        int action;
        String detail;

        private AuditRecord() {
        }
    }
}

