/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.replication;

import com.odi.ReplicationController;
import com.odi.ReplicationStateHandler;
import com.sonicsw.mtstorage.IStorage;
import com.sonicsw.mtstorage.StorageFileDoesNotExistException;
import com.sonicsw.mtstorage.impl.Storage;
import com.sonicsw.mtstorage.replication.AbstractCommunicationManager;
import com.sonicsw.mtstorage.replication.ActiveStorageManager;
import com.sonicsw.mtstorage.replication.BlackbirdCommunicationManager;
import com.sonicsw.mtstorage.replication.ICommunicationStatusHandler;
import com.sonicsw.mtstorage.replication.IMessageHandler;
import com.sonicsw.mtstorage.replication.IReplicatedStorage;
import com.sonicsw.mtstorage.replication.IStateListener;
import com.sonicsw.mtstorage.replication.StandbyStorageManager;
import com.sonicsw.mtstorage.replication.StateManager;
import com.sonicsw.mtstorage.replication.TestCreateStorage;
import com.sonicsw.mtstorage.replication.util.Tracer;
import com.sonicsw.sdf.AbstractDiagnosticsProvider;
import com.sonicsw.sdf.IDiagnosticsContext;
import com.sonicsw.sdf.IStateWriter;
import java.io.IOException;
import java.util.HashMap;

public final class ReplicationManager {
    private static final String FAILURE_DETECT_TIMEOUT_PARAMETER = "REPLICATION_FAILURE_DETECTION_TIMEOUT";
    private static final Integer FAILURE_DETECT_TIMEOUT_DEFAULT = new Integer(0);
    static final String RESPONSE_DATA_ID = "RESPONSE_DATA_ID";
    static final String RESPONSE_REQUEST_ID = "RESPONSE_REQUEST_ID";
    static final String RESPONSE_DEEPSYNC_CHECKPOINT_ID = "RESPONSE_DEEPSYNC_CHECKPOINT_ID";
    static final String RESPONSE_DEEPSYNC_OLDEST_NEEDED_NOTE = "RESPONSE_DEEPSYNC_OLDEST_NEEDED_NOTE";
    static final String RESPONSE_FIRST_PAGE_END_NOTE_POINTER = "RESPONSE_FIRST_PAGE_END_NOTE_POINTER";
    static final String RESPONSE_DEEPSYNC_LAST_NOTE_AFTER_PAGE_REPLICATION = "RESPONSE_DEEPSYNC_LAST_NOTE_AFTER_PAGE_REPLICATION";
    static final String RESPONSE_FLAGS = "RESPONSE_FLAGS";
    private static final int RESPONSE_DIRTY_FLAG = 1;
    private static final int RESPONSE_LOG_DATA_FLAG = 2;
    private static final int RESPONSE_DEEP_SYNC_LOG_DATA_FLAG = 4;
    private static final int RESPONSE_SYNC_LOG_FLAG = 16;
    static final String REQUEST_ID = "REQUEST_ID";
    static final String REQUEST_LOG_DATA = "REQUEST_LOG_DATA";
    static final String REQUEST_DATAID = "REQUEST_DATAID";
    static final String REQUEST_DEEPSYNC_OLDEST_NEEDED_NOTE = "REQUEST_DEEPSYNC_OLDEST_NEEDED_NOTE";
    static final String REQUEST_DEEPSYNC_LAST_NOTE_AFTER_PAGE_REPLICATION = "REQUEST_DEEPSYNC_LAST_NOTE_AFTER_PAGE_REPLICATION";
    static final int DATA_SENT_RESULT = 0;
    static final int DATA_SEND_FAILED_RESULT = 1;
    private StateManager m_stateManager;
    private AbstractCommunicationManager m_commManager;
    private ActiveStorageManager m_activeStorageManager;
    private StandbyStorageManager m_standbyStorageManager;
    private boolean m_peerAccessible;
    private StateHandler m_stateHandler;
    private String m_dbName;
    private HashMap m_storageParameters;
    private HashMap m_savedRequest;
    private boolean m_closing;
    private boolean m_thisPrimary;
    private ReplicationStateHandler m_callerListener;
    private IDiagnosticsContext m_diagnosticsContext;
    static final int HISTORY_SIZE = 20;
    static final String NEWLINE = System.getProperty("line.separator");
    private static String[] OPERATIONS;
    private static HashMap DUMP_STATE_PARAM_DESCIPTOR;
    private static HashMap DESCRIBE_PARAM_DESCIPTOR;
    private static HashMap PARAM_DESCRIPTOR;

    public static void main(String[] args) throws Exception {
        String PRIMARY_STORAGE_NAME = "primary.odb";
        if (args[0].equals("create")) {
            Storage storage = new Storage();
            storage.open("primary.odb", true, new HashMap());
            storage.close();
            return;
        }
        if (args[0].equals("update")) {
            Storage storage = new Storage();
            storage.open("primary.odb", false, new HashMap());
            System.out.println("START UPDATING");
            TestCreateStorage.updateObjects(storage, 0);
            System.out.println("END UPDATING");
            storage.close();
            return;
        }
        boolean primary = args[0].equals("primary");
        HashMap<String, Object> commConfig = new HashMap<String, Object>();
        commConfig.put("PROTOCOL", "TCP");
        commConfig.put("PRIMARY_HOST", "localhost");
        commConfig.put("WEIGHT", new Integer(1));
        commConfig.put("PRIMARY_PORT", new Integer(2506));
        commConfig.put("BACKUP_HOST", "localhost");
        commConfig.put("BACKUP_PORT", new Integer(2507));
        commConfig.put("RECONNECT_FREQUENCY", "10");
        HashMap[] commConfigs = new HashMap[]{commConfig};
        HashMap<String, Integer> storageParameters = new HashMap<String, Integer>();
        storageParameters.put("REPLICATION_PING_INTERVAL", new Integer(30));
        storageParameters.put("REPLICATION_RETRY_INTERVAL", new Integer(180));
        TestReplicationStateHandler testStateListener = new TestReplicationStateHandler();
        ReplicationManager repManager = new ReplicationManager(new TestReplicationController(), testStateListener, args[0] + ".odb", storageParameters, false, primary, false, false, commConfigs);
        Thread.sleep(2000L);
        if (primary) {
            System.out.println("createDeleteLoop");
            TestCreateStorage.createDeleteLoop(repManager.getActiveStorage());
        }
        Thread.sleep(2000000000L);
    }

    public static void setTracing(boolean trace, boolean trace_verbose) {
        Tracer.setTrace(trace, trace_verbose);
    }

    public ReplicationManager(ReplicationController controller, ReplicationStateHandler callerListener, String dbName, HashMap storageParameters, boolean createNew, boolean thisPrimary, boolean startActive, boolean autoDualActiveResolve, HashMap[] channelConfigs) throws IOException {
        ReplicationDiagnostics replicationDiagnostics = new ReplicationDiagnostics();
        this.m_diagnosticsContext = replicationDiagnostics.register();
        this.m_thisPrimary = thisPrimary;
        if (channelConfigs == null || channelConfigs.length == 0) {
            throw new IOException("At least one replication connection must be configured.");
        }
        Integer detectionFailureTimeout = (Integer)storageParameters.get(FAILURE_DETECT_TIMEOUT_PARAMETER);
        if (detectionFailureTimeout == null) {
            detectionFailureTimeout = FAILURE_DETECT_TIMEOUT_DEFAULT;
        }
        this.m_closing = false;
        if (createNew && !thisPrimary) {
            throw new IOException("The backup instance cannot create a new database");
        }
        this.m_dbName = dbName;
        this.m_storageParameters = storageParameters;
        this.m_peerAccessible = true;
        Storage tmp = new Storage();
        IReplicatedStorage storage = tmp;
        boolean dbExists = storage.dbExists(this.m_dbName);
        if (dbExists && createNew) {
            throw new StorageFileDoesNotExistException(this.m_dbName + " already exists");
        }
        if (!dbExists && !createNew && startActive) {
            throw new StorageFileDoesNotExistException(this.m_dbName + " does not exist; cannot start active");
        }
        if (!dbExists && createNew) {
            Storage newStorage = new Storage();
            newStorage.open(this.m_dbName, true, new HashMap());
            newStorage.close();
            dbExists = true;
        }
        short persistentReplicationState = 0;
        long dbTimestamp = 0L;
        if (dbExists) {
            storage.checkWhetherMiddleOfBackup(dbName);
            persistentReplicationState = storage.getPersistentReplicationState(this.m_dbName);
            dbTimestamp = storage.getCreationTimestamp(this.m_dbName, storageParameters);
        } else {
            persistentReplicationState = 517;
            String peerRole = thisPrimary ? "BACKUP" : "PRIMARY";
            callerListener.newMessage("Storage is uninitialized, data will be copied from " + peerRole, false);
        }
        this.m_stateManager = new StateManager(controller, thisPrimary, startActive, dbTimestamp, autoDualActiveResolve, persistentReplicationState, detectionFailureTimeout);
        boolean wasActive = persistentReplicationState == 3 || persistentReplicationState == 2;
        this.m_commManager = new BlackbirdCommunicationManager(this.m_stateManager.getMessageHandler(), new ReplicationMessageHandler(), thisPrimary, wasActive || startActive);
        this.m_commManager.addListener(new CommListener());
        this.m_commManager.addListener(this.m_stateManager.getCommHandler());
        this.m_stateManager.addListener(this.m_commManager.getStateReporter());
        this.m_stateHandler = new StateHandler();
        this.m_stateManager.addListener(this.m_stateHandler);
        this.m_callerListener = callerListener;
        this.m_stateManager.addListener(new CallerListener());
        this.m_commManager.open(channelConfigs, this.m_storageParameters);
        this.m_stateManager.announceInitialState();
    }

    public synchronized IStorage getActiveStorage() {
        if (this.m_activeStorageManager != null) {
            return this.m_activeStorageManager.getStorage();
        }
        return null;
    }

    private void openActive() {
        try {
            this.closeStandby(true);
            this.m_activeStorageManager.open(this.m_dbName, this.m_storageParameters, this.m_commManager, this.m_stateManager, this.m_peerAccessible);
            this.setDelayedRequest();
        }
        catch (IOException e) {
            Tracer.TRACE(e);
            this.m_stateManager.shutdownState(e);
        }
        catch (Exception e) {
            Tracer.TRACE(e);
        }
    }

    private synchronized void setDelayedRequest() {
        if (this.m_savedRequest != null) {
            this.m_activeStorageManager.setRequest(this.m_savedRequest);
            this.m_savedRequest = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openStandby() {
        try {
            ReplicationManager replicationManager = this;
            synchronized (replicationManager) {
                this.closeStandby(false);
                this.closeActive(true);
            }
            this.m_standbyStorageManager.open(this.m_dbName, this.m_storageParameters, this.m_stateManager, this.m_commManager);
            this.m_standbyStorageManager.sendInitialRequest();
        }
        catch (IOException e) {
            Tracer.TRACE(e);
            this.m_stateManager.shutdownState(e);
        }
        catch (Exception e) {
            Tracer.TRACE(e);
        }
        catch (Throwable t) {
            Tracer.TRACE(t);
        }
    }

    private synchronized void handleData(HashMap msgProperties, byte[] data, int dataOffset, int dataLength) {
        try {
            if (this.m_standbyStorageManager != null) {
                this.m_standbyStorageManager.setData(msgProperties, data, dataOffset, dataLength);
            }
        }
        catch (Exception e) {
            Tracer.TRACE(e);
        }
    }

    private synchronized void handleRequest(HashMap msgProperties) {
        try {
            if (this.m_activeStorageManager != null) {
                this.m_activeStorageManager.setRequest(msgProperties);
            } else {
                this.m_savedRequest = msgProperties;
            }
        }
        catch (Exception e) {
            Tracer.TRACE(e);
        }
    }

    private synchronized void closeActive(boolean createStandby) throws IOException {
        if (this.m_activeStorageManager != null) {
            this.m_activeStorageManager.close();
            this.m_activeStorageManager = null;
        }
        if (createStandby) {
            if (this.m_standbyStorageManager != null) {
                throw new IOException("ERROR: Try to create a new m_standbyStorageManager when one already exists");
            }
            this.m_standbyStorageManager = new StandbyStorageManager(this.m_diagnosticsContext);
        }
    }

    private synchronized void closeStandby(boolean createActive) throws IOException {
        if (this.m_standbyStorageManager != null) {
            this.m_standbyStorageManager.close();
            this.m_standbyStorageManager = null;
        }
        if (createActive) {
            if (this.m_activeStorageManager != null) {
                throw new IOException("ERROR: Try to create a new m_activeStorageManager when one already exists");
            }
            this.m_activeStorageManager = new ActiveStorageManager(this.m_diagnosticsContext);
        }
    }

    private synchronized void peerAccessible(boolean ok) {
        if (!this.m_peerAccessible && ok && this.m_callerListener != null) {
            String peerRole = this.m_thisPrimary ? "BACKUP" : "PRIMARY";
            this.m_callerListener.newMessage("(Re)Established access to the " + peerRole + " replication peer", false);
        }
        this.m_peerAccessible = ok;
        if (this.m_activeStorageManager != null) {
            this.m_activeStorageManager.peerAccessible(ok);
        }
        if (ok && this.m_stateManager.inAnyStandby()) {
            this.m_stateHandler.startStandby();
        }
    }

    void shutdown(String reason) {
        this.m_stateManager.shutdownState(reason);
    }

    public void close() throws IOException {
        this.m_closing = true;
        this.closeStandby(false);
        this.closeActive(false);
        this.m_commManager.close();
    }

    static void printMap(HashMap map, StringBuffer buffer) {
        for (Object key : map.keySet()) {
            Object value = map.get(key);
            buffer.append(key).append(" ").append(value).append(NEWLINE);
        }
        buffer.append("------------------------------------------" + NEWLINE);
    }

    static {
        DUMP_STATE_PARAM_DESCIPTOR = new HashMap();
        DESCRIBE_PARAM_DESCIPTOR = new HashMap();
        PARAM_DESCRIPTOR = new HashMap();
        PARAM_DESCRIPTOR.put("dumpState", DUMP_STATE_PARAM_DESCIPTOR);
        PARAM_DESCRIPTOR.put("describe", DESCRIBE_PARAM_DESCIPTOR);
        OPERATIONS = AbstractDiagnosticsProvider.toOpnameArray((HashMap)PARAM_DESCRIPTOR);
    }

    class ReplicationDiagnostics
    extends AbstractDiagnosticsProvider {
        ReplicationDiagnostics() {
            super("sonic.pse.replication");
        }

        public String describe() {
            return "Provides in-memory history tracking for PSE replication";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void appendStateDump(String doiIDNotUsed, HashMap ParametersNotUsed, StringBuffer statusBuffer) {
            try (IStateWriter writer = null;){
                writer = this.m_diagnosticsContext.getStateWriter();
                StringBuffer stateBuffer = new StringBuffer();
                if (ReplicationManager.this.m_activeStorageManager != null) {
                    ReplicationManager.this.m_activeStorageManager.printState(stateBuffer);
                }
                if (ReplicationManager.this.m_standbyStorageManager != null) {
                    ReplicationManager.this.m_standbyStorageManager.printState(stateBuffer);
                }
                writer.write(stateBuffer.toString());
            }
            statusBuffer.append("PSE ReplicationDiagnostics state was written to file " + writer.getFilePath());
            writer.close();
        }

        public HashMap describeParameters(String operationName) {
            return (HashMap)PARAM_DESCRIPTOR.get(operationName);
        }

        public void updateTraceLevel(String doiID, HashMap parameters, StringBuffer buffer) {
        }

        public String[] getOperations() {
            return OPERATIONS;
        }
    }

    protected static class SDFRequestTracker {
        long m_receptionTime = 0L;
        HashMap m_request = null;
        Boolean m_successfulSend;
        String m_sendError;

        SDFRequestTracker() {
        }

        synchronized void setRequest(HashMap request, Boolean successfulSend, String sendError) {
            this.m_receptionTime = System.currentTimeMillis();
            this.m_request = (HashMap)request.clone();
            this.m_successfulSend = successfulSend;
            this.m_sendError = sendError;
        }

        void setRequest(HashMap request) {
            this.setRequest(request, null, null);
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            String timeLabel = this.m_successfulSend == null ? " Reception time " : " Send time ";
            buffer.append(timeLabel + this.m_receptionTime + "UTC");
            if (this.m_successfulSend != null) {
                buffer.append(this.m_successfulSend != false ? " Successfully sent " : " Send failed: " + this.m_sendError);
            }
            buffer.append(NEWLINE);
            ReplicationManager.printMap(this.m_request, buffer);
            return buffer.toString();
        }

        static SDFRequestTracker[] getCache() {
            SDFRequestTracker[] cache = new SDFRequestTracker[20];
            for (int i = 0; i < 20; ++i) {
                cache[i] = new SDFRequestTracker();
            }
            return cache;
        }
    }

    protected static class SDFResponseTracker {
        long m_sendTime = 0L;
        HashMap m_response = null;
        Boolean m_successfulSend;
        int m_dataLength;
        long m_psendingRequestID;
        String m_errorMsg;

        SDFResponseTracker() {
        }

        void setResponse(HashMap response, int dataLength, Boolean success, long psendingRequestID, String errorMsg) {
            this.m_sendTime = System.currentTimeMillis();
            this.m_response = (HashMap)response.clone();
            this.m_dataLength = dataLength;
            this.m_successfulSend = success;
            this.m_psendingRequestID = psendingRequestID;
            this.m_errorMsg = errorMsg;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Send time " + this.m_sendTime + "UTC Data length " + this.m_dataLength);
            if (this.m_successfulSend != null) {
                buffer.append(this.m_successfulSend != false ? " Successful send " : " Send failed with exception message " + this.m_errorMsg);
            } else {
                buffer.append(" Pending request ID " + this.m_psendingRequestID);
            }
            buffer.append(NEWLINE);
            ReplicationManager.printMap(this.m_response, buffer);
            return buffer.toString();
        }

        static SDFResponseTracker[] getCache() {
            SDFResponseTracker[] cache = new SDFResponseTracker[20];
            for (int i = 0; i < 20; ++i) {
                cache[i] = new SDFResponseTracker();
            }
            return cache;
        }
    }

    protected static class SDFTransactionTracker {
        long m_afterTransEndLogID;
        long m_starttime = 0L;
        long m_timetowait;
        boolean m_peerAccessible;
        long m_nextLogIDToReplicate;
        boolean m_isDirty;
        boolean m_toldStandbyItsNotDirty;
        long m_doneWaitingTime;
        Boolean m_wasNotReplicated = null;

        protected SDFTransactionTracker() {
        }

        void waitingTransaction(long afterTransEndLogID, long starttime, long timetowait, boolean peerAccessible, long nextLogIDToReplicate, boolean isDirty, boolean toldStandbyItsNotDirty) {
            this.m_afterTransEndLogID = afterTransEndLogID;
            this.m_starttime = starttime;
            this.m_timetowait = timetowait;
            this.m_peerAccessible = peerAccessible;
            this.m_nextLogIDToReplicate = nextLogIDToReplicate;
            this.m_isDirty = isDirty;
            this.m_toldStandbyItsNotDirty = toldStandbyItsNotDirty;
            this.m_wasNotReplicated = null;
        }

        void doneWaitingTransaction(boolean wasNotReplicated) {
            this.m_wasNotReplicated = wasNotReplicated ? Boolean.TRUE : Boolean.FALSE;
            this.m_doneWaitingTime = System.currentTimeMillis();
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("afterTransEndLogID " + this.m_afterTransEndLogID + NEWLINE);
            buffer.append("starttime " + this.m_starttime + "UTC" + NEWLINE);
            buffer.append("timetowait " + this.m_timetowait + NEWLINE);
            buffer.append("peerAccessible " + this.m_peerAccessible + NEWLINE);
            buffer.append("nextLogIDToReplicate " + this.m_nextLogIDToReplicate + NEWLINE);
            buffer.append("isDirty " + this.m_isDirty + NEWLINE);
            buffer.append("toldStandbyItsNotDirty " + this.m_toldStandbyItsNotDirty + NEWLINE);
            if (this.m_wasNotReplicated == null) {
                buffer.append("TRANSACTION IS WAITING" + NEWLINE);
            } else {
                buffer.append("Time " + this.m_doneWaitingTime + (this.m_wasNotReplicated != false ? " Done Waiting NOT REPLIACTED " : " Done Waiting WAS REPLIACTED ") + NEWLINE);
            }
            buffer.append("------------------------------------------");
            return buffer.toString();
        }

        static SDFTransactionTracker[] getCache() {
            SDFTransactionTracker[] cache = new SDFTransactionTracker[20];
            for (int i = 0; i < 20; ++i) {
                cache[i] = new SDFTransactionTracker();
            }
            return cache;
        }
    }

    static class TestReplicationStateHandler
    extends ReplicationStateHandler {
        TestReplicationStateHandler() {
        }
    }

    private class CallerListener
    implements IStateListener {
        private CallerListener() {
        }

        @Override
        public void preShutdown() {
        }

        @Override
        public void stateComment(String comment) {
            ReplicationManager.this.m_callerListener.newMessage(comment, true);
        }

        @Override
        public void newState(StateManager.State state, boolean toPeerOnly) {
            if (toPeerOnly) {
                return;
            }
            switch (state.m_currentState) {
                case 1: 
                case 1026: 
                case 1027: {
                    break;
                }
                case 4: {
                    ReplicationManager.this.m_callerListener.newState((short)3);
                    break;
                }
                case 5: {
                    ReplicationManager.this.m_callerListener.newState((short)4);
                    break;
                }
                case 517: {
                    ReplicationManager.this.m_callerListener.newState((short)5);
                    break;
                }
                case 2: {
                    ReplicationManager.this.m_callerListener.newState((short)2);
                    break;
                }
                case 3: {
                    ReplicationManager.this.m_callerListener.newState((short)1);
                    break;
                }
                case 6: {
                    ReplicationManager.this.m_callerListener.shutdownState(state.m_shutdownReason, state.m_shutdownException);
                }
            }
        }
    }

    static class TestReplicationController
    extends ReplicationController {
        TestReplicationController() {
        }

        @Override
        public boolean allowedToGetActive() {
            return true;
        }
    }

    private class StateHandler
    implements IStateListener {
        private IReplicatedStorage m_storage;

        StateHandler() {
            Storage tmp = new Storage();
            this.m_storage = tmp;
        }

        @Override
        public void stateComment(String comment) {
        }

        @Override
        public void preShutdown() {
            if (ReplicationManager.this.m_activeStorageManager != null) {
                try {
                    ReplicationManager.this.m_activeStorageManager.preShutdown();
                }
                catch (Throwable t) {
                    Tracer.TRACE(t);
                }
            }
        }

        @Override
        public void newState(StateManager.State state, boolean toPeerOnly) {
            if (toPeerOnly || ReplicationManager.this.m_closing) {
                return;
            }
            Tracer.TRACE("ReplicationManager reported " + state);
            try {
                short stateToPersist = StateManager.removePrepareFlag(state.m_currentState);
                if (stateToPersist != 1 && stateToPersist != 6) {
                    this.m_storage.setPersistentReplicationState(ReplicationManager.this.m_dbName, stateToPersist);
                }
            }
            catch (IOException e) {
                Tracer.TRACE(e);
                ReplicationManager.this.m_stateManager.shutdownState(e);
            }
            switch (state.m_currentState) {
                case 1027: {
                    if (state.m_prevState == 1026) break;
                    this.startActive();
                    break;
                }
                case 1026: {
                    if (state.m_prevState == 1027) break;
                    this.startActive();
                    break;
                }
                case 4: {
                    if (state.m_prevState == 5 || state.m_prevState == 517) break;
                    this.startStandby();
                    break;
                }
                case 5: {
                    if (state.m_prevState == 4 || state.m_prevState == 517) break;
                    this.startStandby();
                    break;
                }
                case 517: {
                    this.startStandby();
                    break;
                }
            }
        }

        private void startStandby() {
            if (ReplicationManager.this.m_closing) {
                return;
            }
            Tracer.TRACE("ReplicationManager startStandby");
            Thread standbyOpener = new Thread("ReplicationManager.StateHandler Open Standby Thread"){

                @Override
                public void run() {
                    ReplicationManager.this.openStandby();
                }
            };
            standbyOpener.setDaemon(true);
            standbyOpener.start();
        }

        private void startActive() {
            if (ReplicationManager.this.m_closing) {
                return;
            }
            Tracer.TRACE("ReplicationManager startActive");
            Thread activeOpener = new Thread("ReplicationManager.StateHandler Open Active Thread"){

                @Override
                public void run() {
                    ReplicationManager.this.openActive();
                    ReplicationManager.this.m_stateManager.activationDone();
                }
            };
            activeOpener.setDaemon(true);
            activeOpener.start();
        }
    }

    private class CommListener
    implements ICommunicationStatusHandler {
        private CommListener() {
        }

        @Override
        public void permanentCommFailure(Exception e) {
        }

        @Override
        public void connected(boolean ok) {
            ReplicationManager.this.peerAccessible(ok);
        }

        @Override
        public void reportException(String reporter, Exception e) {
        }

        @Override
        public void reportEvent(String event, boolean warning) {
            ReplicationManager.this.m_callerListener.newMessage(event, warning);
        }
    }

    private class ReplicationMessageHandler
    implements IMessageHandler {
        private ReplicationMessageHandler() {
        }

        @Override
        public void handleMessage(HashMap msgProperties, byte[] data, int dataOffset, int dataLength) {
            ReplicationManager.this.handleData(msgProperties, data, dataOffset, dataLength);
        }

        @Override
        public void handleMessage(HashMap msgProperties) {
            ReplicationManager.this.handleRequest(msgProperties);
        }
    }

    public static final class DeepSyncRequest {
        public boolean m_logRequest;
        public long m_requestDataID;
        public long m_requestID;
        public long m_deepSyncOldestNeededNote;

        DeepSyncRequest(HashMap request) {
            this.m_logRequest = (Boolean)request.get(ReplicationManager.REQUEST_LOG_DATA);
            this.m_requestDataID = (Long)request.get(ReplicationManager.REQUEST_DATAID);
            this.m_requestID = (Long)request.get(ReplicationManager.REQUEST_ID);
            this.m_deepSyncOldestNeededNote = (Long)request.get(ReplicationManager.REQUEST_DEEPSYNC_OLDEST_NEEDED_NOTE);
        }
    }

    public static final class ReplicationDataIndicator {
        public boolean m_okStatus;
        public boolean m_dirtyFlag;
        public boolean m_logData;
        public boolean m_deepSyncLogData;
        public boolean m_syncLog;
        public long m_dataID;
        public long m_requestID;
        public long m_deepSyncCheckpointID;
        public Integer m_firstPageEndNotePointer;
        public long m_deepSyncOldestNeededNote;
        public long m_deepSyncLastNoteWrittenAfterPageReplication;
        public byte[] m_buffer;
        public int m_dataOffset;
        public int m_dataLength;

        public ReplicationDataIndicator() {
        }

        ReplicationDataIndicator(HashMap map) {
            this.m_dataID = (Long)map.get(ReplicationManager.RESPONSE_DATA_ID);
            this.m_requestID = (Long)map.get(ReplicationManager.RESPONSE_REQUEST_ID);
            this.m_deepSyncCheckpointID = (Long)map.get(ReplicationManager.RESPONSE_DEEPSYNC_CHECKPOINT_ID);
            this.m_deepSyncOldestNeededNote = (Long)map.get(ReplicationManager.RESPONSE_DEEPSYNC_OLDEST_NEEDED_NOTE);
            this.m_firstPageEndNotePointer = (Integer)map.get(ReplicationManager.RESPONSE_FIRST_PAGE_END_NOTE_POINTER);
            this.m_deepSyncLastNoteWrittenAfterPageReplication = (Long)map.get(ReplicationManager.RESPONSE_DEEPSYNC_LAST_NOTE_AFTER_PAGE_REPLICATION);
            int flags = (Integer)map.get(ReplicationManager.RESPONSE_FLAGS);
            this.m_dirtyFlag = (flags & 1) != 0;
            this.m_logData = (flags & 2) != 0;
            this.m_deepSyncLogData = (flags & 4) != 0;
            this.m_syncLog = (flags & 0x10) != 0;
        }

        HashMap toHashmap() {
            HashMap<String, Number> map = new HashMap<String, Number>();
            map.put(ReplicationManager.RESPONSE_DATA_ID, new Long(this.m_dataID));
            map.put(ReplicationManager.RESPONSE_REQUEST_ID, new Long(this.m_requestID));
            map.put(ReplicationManager.RESPONSE_DEEPSYNC_CHECKPOINT_ID, new Long(this.m_deepSyncCheckpointID));
            map.put(ReplicationManager.RESPONSE_DEEPSYNC_OLDEST_NEEDED_NOTE, new Long(this.m_deepSyncOldestNeededNote));
            map.put(ReplicationManager.RESPONSE_DEEPSYNC_LAST_NOTE_AFTER_PAGE_REPLICATION, new Long(this.m_deepSyncLastNoteWrittenAfterPageReplication));
            if (this.m_firstPageEndNotePointer != null) {
                map.put(ReplicationManager.RESPONSE_FIRST_PAGE_END_NOTE_POINTER, this.m_firstPageEndNotePointer);
            }
            int flags = 0;
            if (this.m_dirtyFlag) {
                flags |= 1;
            }
            if (this.m_logData) {
                flags |= 2;
            }
            if (this.m_deepSyncLogData) {
                flags |= 4;
            }
            if (this.m_syncLog) {
                flags |= 0x10;
            }
            map.put(ReplicationManager.RESPONSE_FLAGS, new Integer(flags));
            return map;
        }
    }
}

