/*
 * Decompiled with CFR 0.152.
 */
package com.odi.filter.classfile;

import com.odi.filter.classfile.AttributeVector;
import com.odi.filter.classfile.ClassAttribute;
import com.odi.filter.classfile.ClassMember;
import com.odi.filter.classfile.ClassPrint;
import com.odi.filter.classfile.CodeAttribute;
import com.odi.filter.classfile.ConstUtf8;
import com.odi.filter.classfile.ConstantPool;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;

public class ClassMethod
extends ClassMember {
    public static final String intializerName = "<init>";
    public static final String staticIntializerName = "<clinit>";
    private int accessFlags;
    private ConstUtf8 methodName;
    private ConstUtf8 methodSignature;
    private AttributeVector methodAttributes;

    @Override
    public int access() {
        return this.accessFlags;
    }

    @Override
    public void setAccess(int newFlags) {
        this.accessFlags = newFlags;
    }

    public boolean isAbstract() {
        return (this.accessFlags & 0x400) != 0;
    }

    public boolean isNative() {
        return (this.accessFlags & 0x100) != 0;
    }

    @Override
    public ConstUtf8 name() {
        return this.methodName;
    }

    public void changeName(ConstUtf8 name) {
        this.methodName = name;
    }

    @Override
    public ConstUtf8 signature() {
        return this.methodSignature;
    }

    public void changeSignature(ConstUtf8 newSig) {
        this.methodSignature = newSig;
    }

    @Override
    public AttributeVector attributes() {
        return this.methodAttributes;
    }

    public ClassMethod(int accFlags, ConstUtf8 name, ConstUtf8 sig, AttributeVector methodAttrs) {
        this.accessFlags = accFlags;
        this.methodName = name;
        this.methodSignature = sig;
        this.methodAttributes = methodAttrs;
    }

    int codeSize() {
        CodeAttribute codeAttr = this.codeAttribute();
        return codeAttr == null ? 0 : codeAttr.codeSize();
    }

    public CodeAttribute codeAttribute() {
        Enumeration e = this.methodAttributes.elements();
        while (e.hasMoreElements()) {
            ClassAttribute attr = (ClassAttribute)e.nextElement();
            if (!(attr instanceof CodeAttribute)) continue;
            return (CodeAttribute)attr;
        }
        return null;
    }

    static ClassMethod read(DataInputStream data, ConstantPool pool) throws IOException {
        int accessFlags = data.readUnsignedShort();
        int nameIndex = data.readUnsignedShort();
        int sigIndex = data.readUnsignedShort();
        ClassMethod f = new ClassMethod(accessFlags, (ConstUtf8)pool.constantAt(nameIndex), (ConstUtf8)pool.constantAt(sigIndex), null);
        f.methodAttributes = AttributeVector.readAttributes(data, pool);
        return f;
    }

    void write(DataOutputStream data) throws IOException {
        CodeAttribute codeAttr = this.codeAttribute();
        data.writeShort(this.accessFlags);
        data.writeShort(this.methodName.getIndex());
        data.writeShort(this.methodSignature.getIndex());
        this.methodAttributes.write(data);
    }

    void print(PrintStream out, int indent) {
        ClassPrint.spaces(out, indent);
        out.print("'" + this.methodName.asString() + "'");
        out.print(" sig = " + this.methodSignature.asString());
        out.print(" accessFlags = " + Integer.toString(this.accessFlags));
        out.println(" attributes:");
        this.methodAttributes.print(out, indent + 2);
    }
}

