/*
 * Decompiled with CFR 0.152.
 */
package com.odi.util.query;

import com.odi.util.FastContains;
import com.odi.util.OSHashSet;
import com.odi.util.query.FreeVariableBindings;
import com.odi.util.query.Methods;
import com.odi.util.query.MethodsGenerator;
import com.odi.util.query.QueryEvalNode;
import com.odi.util.query.QueryEvalTree;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public final class CollectionEvalNode
extends QueryEvalNode {
    private Collection collection;
    private int lookups;

    @Override
    protected void computeMethodsInternal(MethodsGenerator generator) {
    }

    @Override
    protected QueryEvalNode bindInternal(FreeVariableBindings freeVariableBindings, Collection collection, Methods methods) {
        CollectionEvalNode result = new CollectionEvalNode();
        result.collection = collection;
        return result;
    }

    @Override
    protected void collectStatisticsInternal(QueryEvalTree tree) {
        tree.nonIndexLookups += this.lookups;
    }

    @Override
    protected boolean hasFastContainsInternal() {
        return this.collection instanceof FastContains;
    }

    @Override
    protected boolean containsInternal(Object object) {
        ++this.lookups;
        return this.collection.contains(object);
    }

    @Override
    protected Iterator iteratorInternal(boolean allowDuplicates) {
        return new NodeIterator(this.collection.iterator());
    }

    @Override
    protected Set computeSet() {
        if (this.collection.isEmpty()) {
            return new OSHashSet(1);
        }
        OSHashSet result = new OSHashSet(this.collection.size());
        result.addAll(this.collection);
        this.lookups += this.collection.size();
        return result;
    }

    @Override
    protected void estimateSize() {
        this.minSize = this.maxSize = this.collection.size();
    }

    @Override
    public String toString() {
        return this.identityToString() + ": collection=" + this.collection + ", " + super.toString();
    }

    @Override
    String toPrintString() {
        if (this.collection == null) {
            return "{unbound collection}";
        }
        return "{collection of " + this.collection.size() + " elements" + (this.lookups != 0 ? ", lookups=" + this.lookups : "") + "}";
    }

    @Override
    public void print(PrintWriter out, int indentLevel) {
        out.println(this.indentedString(indentLevel, this.toPrintString()));
    }

    final class NodeIterator
    implements Iterator {
        private Iterator iterator;

        NodeIterator(Iterator iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            Object result = this.iterator.next();
            CollectionEvalNode.this.lookups++;
            return result;
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

