/*
 * Decompiled with CFR 0.152.
 */
package com.progress.blackbird.evs.nio;

import com.progress.blackbird.evs.nio.EvsDispatcherEvent;
import com.progress.blackbird.evs.nio.EvsListHead;
import com.progress.blackbird.evs.nio.EvsObject;
import com.progress.blackbird.sys.SysListElement;

final class EvsScheduler
extends EvsObject {
    private EvsListHead[] prioQueues = new EvsListHead[32];
    private int prioQueuesMask;
    private int size;

    private EvsScheduler() {
        for (int i = 0; i < this.prioQueues.length; ++i) {
            this.prioQueues[i] = EvsListHead.create();
        }
    }

    static EvsScheduler create() {
        return new EvsScheduler();
    }

    final void addEvent(EvsDispatcherEvent evsDispatcherEvent) {
        if (this.checked && evsDispatcherEvent == null) {
            throw new IllegalArgumentException("null event");
        }
        byte by = evsDispatcherEvent.getPriority();
        if (this.checked && (by > 31 || by < 0)) {
            throw new IllegalArgumentException("Invalid priority");
        }
        evsDispatcherEvent.remove();
        this.prioQueues[by].append(evsDispatcherEvent);
        this.prioQueuesMask |= 1 << by;
        ++this.size;
    }

    final void addEvents(EvsListHead evsListHead) {
        SysListElement sysListElement;
        if (this.checked && evsListHead == null) {
            throw new IllegalArgumentException("null event list head");
        }
        while ((sysListElement = evsListHead.getNext()) != null) {
            sysListElement.remove();
            this.addEvent((EvsDispatcherEvent)sysListElement);
        }
    }

    final void removeEvent(EvsDispatcherEvent evsDispatcherEvent) {
        if (this.checked && evsDispatcherEvent == null) {
            throw new IllegalArgumentException("null event");
        }
        byte by = evsDispatcherEvent.getPriority();
        if (this.checked && (by > 31 || by < 0)) {
            throw new IllegalArgumentException("Invalid priority");
        }
        int n = this.prioQueues[by].getListSize();
        evsDispatcherEvent.remove();
        if (this.prioQueues[by].getListSize() == 0) {
            this.prioQueuesMask &= ~(1 << by);
        }
        this.size = this.size - n + this.prioQueues[by].getListSize();
    }

    final EvsListHead getReadyList(EvsListHead evsListHead) {
        EvsListHead evsListHead2 = evsListHead;
        if (this.checked) {
            if (evsListHead == null) {
                throw new IllegalArgumentException("null event list head");
            }
            if (evsListHead.getListSize() != 0) {
                throw new IllegalArgumentException("non-empty event list head");
            }
        }
        if (this.prioQueuesMask != 0) {
            for (int i = 31; i >= 0; --i) {
                if ((this.prioQueuesMask & 1 << i) == 0) continue;
                evsListHead2 = this.prioQueues[i];
                this.prioQueues[i] = evsListHead;
                this.prioQueuesMask &= ~(1 << i);
                break;
            }
        }
        this.size -= evsListHead2.getListSize();
        return evsListHead2;
    }

    final int getSize() {
        return this.size;
    }
}

