/*
 * Decompiled with CFR 0.152.
 */
package com.progress.blackbird.io.evs;

import com.progress.blackbird.evs.EEvsException;
import com.progress.blackbird.evs.EEvsIOCancelledException;
import com.progress.blackbird.evs.EEvsIOException;
import com.progress.blackbird.evs.EEvsIOPendingException;
import com.progress.blackbird.evs.EEvsNotOwnerException;
import com.progress.blackbird.evs.EEvsObjectBusyException;
import com.progress.blackbird.evs.EEvsObjectHotException;
import com.progress.blackbird.evs.EEvsTimeoutException;
import com.progress.blackbird.evs.IEvsDispatcher;
import com.progress.blackbird.evs.IEvsNetworkPort;
import com.progress.blackbird.evs.IEvsNetworkPortPortEvent;
import com.progress.blackbird.evs.IEvsPortEvent;
import com.progress.blackbird.evs.IEvsPortEventHandler;
import com.progress.blackbird.evs.IEvsTimerPort;
import com.progress.blackbird.evs.nio.EvsDispatcher;
import com.progress.blackbird.evs.nio.EvsNetworkPort;
import com.progress.blackbird.evs.nio.EvsTimerPort;
import com.progress.blackbird.io.EIOConnectionAlreadyConnectedException;
import com.progress.blackbird.io.EIOConnectionClosedException;
import com.progress.blackbird.io.EIOConnectionFailedException;
import com.progress.blackbird.io.EIOConnectionNotConnectedException;
import com.progress.blackbird.io.EIOException;
import com.progress.blackbird.io.EIOFlushPendingException;
import com.progress.blackbird.io.EIOInboundStreamClosedException;
import com.progress.blackbird.io.EIOInboundStreamOpenException;
import com.progress.blackbird.io.EIOTimeoutException;
import com.progress.blackbird.io.IIOConnection;
import com.progress.blackbird.io.IIOConnectionPacketHandler;
import com.progress.blackbird.io.IIOConnectionStatistics;
import com.progress.blackbird.io.IIOPacket;
import com.progress.blackbird.io.IIOPacketSerializer;
import com.progress.blackbird.io.evs.IIONetworkConnectionPingPacketManager;
import com.progress.blackbird.io.evs.IONetworkConnectionInputStream;
import com.progress.blackbird.io.evs.IONetworkConnectionOutputStream;
import com.progress.blackbird.io.evs.IONetworkConnectionPingManager;
import com.progress.blackbird.io.evs.IOObject;
import com.progress.blackbird.sys.ESysIoctlException;
import com.progress.blackbird.sys.ISysIoctl;
import com.progress.blackbird.sys.SysConfig;
import com.progress.blackbird.sys.SysListElement;
import com.progress.blackbird.sys.SysListHead;
import com.progress.blackbird.sys.SysStatistics;
import com.progress.blackbird.sys.SysTrace;
import java.text.NumberFormat;
import java.util.Random;

public final class IONetworkConnection
extends IOObject
implements IEvsPortEventHandler,
IIOConnection,
ISysIoctl {
    private final boolean active;
    private final Parameters parameters;
    private final IIOPacketSerializer packetSerializer;
    private final IEvsNetworkPort port;
    private final IEvsDispatcher dispatcher;
    private final IONetworkConnectionPingManager pingManager;
    private final IONetworkConnectionOutputStream outputStream;
    private final IONetworkConnectionInputStream inputStream;
    private final SysTrace packetTrace;
    private final Statistics statistics;
    private final FailureGovernor failureGovernor;
    private IIOConnectionPacketHandler packetHandler;
    private SyncReadContext syncReadContext;
    private boolean flgConnected;
    private boolean flgForceFailed;
    private boolean flgFailed;
    private boolean flgClosed;

    private IONetworkConnection(IEvsNetworkPort iEvsNetworkPort, boolean bl, IIOPacketSerializer iIOPacketSerializer, IIONetworkConnectionPingPacketManager iIONetworkConnectionPingPacketManager, Parameters parameters, boolean bl2) throws EEvsIOException {
        super(bl);
        this.parameters = parameters == null ? parameters.create() : (Parameters)parameters.clone();
        this.port = iEvsNetworkPort;
        this.active = iEvsNetworkPort.getNetworkPortType() == 1;
        this.packetSerializer = iIOPacketSerializer;
        this.dispatcher = EvsDispatcher.create("Internal IO Dispatcher", false, null);
        this.pingManager = new IONetworkConnectionPingManager(this, iIONetworkConnectionPingPacketManager, this.parameters.pingInterval, bl);
        if (this.active) {
            this.packetTrace = SysTrace.create(SysConfig.getProperties(), "bb.io.packet.trace");
            this.statistics = new Statistics(bl);
            int n = (int)SysConfig.getConfigValue(SysConfig.getProperties(), "bb.io.evs.packetStatsInterval", 0.0);
            if (n == 0) {
                n = (int)SysConfig.getConfigValue(SysConfig.getProperties(), "bb.io.packetStatsInterval", 0.0);
            }
            if (n > 0) {
                this.statistics.startDump(n);
            }
            this.failureGovernor = new FailureGovernor();
            this.outputStream = new IONetworkConnectionOutputStream(this, iEvsNetworkPort, this.dispatcher, iIOPacketSerializer, this.trace, this.packetTrace, this.parameters.autoFlushSize);
            this.inputStream = new IONetworkConnectionInputStream(this, iEvsNetworkPort, iIOPacketSerializer, this.pingManager, this.trace, this.packetTrace);
            this.pingManager.bind(this.inputStream, this.outputStream);
            this.flgConnected = bl2;
            this.flgFailed = false;
        } else {
            this.packetTrace = null;
            this.statistics = null;
            this.failureGovernor = null;
            this.inputStream = null;
            this.outputStream = null;
        }
        this.trace.outln("Created network connection (active=" + this.active + ") with parameters " + this.parameters, 4);
    }

    private void connectInternal() throws EIOConnectionAlreadyConnectedException, EIOConnectionClosedException, EIOException {
        if (this.active) {
            if (!this.flgClosed) {
                if (!this.flgConnected) {
                    this.trace.outln("Establishing connection...", 3);
                    try {
                        SyncConnectContext syncConnectContext = new SyncConnectContext();
                        try {
                            this.dispatcher.acquire();
                            if (this.trace.debug) {
                                this.trace.debugln("Posting connect...");
                            }
                            this.port.connectPost(this.dispatcher, (byte)15, this, syncConnectContext, 0);
                            if (this.trace.debug) {
                                this.trace.debugln("Waiting for connect to complete...");
                            }
                            while (!syncConnectContext.done) {
                                this.dispatcher.dispatch(-1);
                            }
                        }
                        catch (EEvsObjectHotException eEvsObjectHotException) {
                            throw new InternalError("Acquisition of internal dispatcher failed - " + eEvsObjectHotException.getMessage());
                        }
                        catch (EEvsObjectBusyException eEvsObjectBusyException) {
                            throw new InternalError("Acquisition of internal dispatcher failed - " + eEvsObjectBusyException.getMessage());
                        }
                        catch (EEvsTimeoutException eEvsTimeoutException) {
                            throw new InternalError("Dispatch of internal dispatcher failed - " + eEvsTimeoutException.getMessage());
                        }
                        catch (EEvsNotOwnerException eEvsNotOwnerException) {
                            throw new InternalError("Dispatch of internal dispatcher failed - " + eEvsNotOwnerException.getMessage());
                        }
                        if (syncConnectContext.status != null) {
                            this.trace.outln("Connection establishment failed [" + syncConnectContext.status.getMessage() + "]", 3);
                            throw new EIOException(syncConnectContext.status);
                        }
                        this.flgConnected = true;
                        this.trace.outln("Connection successfully established.", 3);
                    }
                    catch (EEvsIOException eEvsIOException) {
                        throw new EIOException(eEvsIOException);
                    }
                }
                throw new EIOConnectionAlreadyConnectedException();
            }
            throw new EIOConnectionClosedException();
        }
        throw new IllegalStateException("operation not permitted on a passive connection");
    }

    private boolean isConnectedInternal() throws EIOConnectionClosedException, EIOException {
        if (this.active) {
            if (!this.flgClosed) {
                return this.flgConnected && !this.flgFailed;
            }
            throw new EIOConnectionClosedException();
        }
        throw new IllegalStateException("operation not permitted on a passive connection");
    }

    private IIOConnection acceptInternal(int n) throws EIOConnectionClosedException, EIOTimeoutException, EIOException {
        if (!this.active) {
            if (!this.flgClosed) {
                IONetworkConnection iONetworkConnection = null;
                this.trace.outln("Accepting connection with timeout=" + n + " ms...", 3);
                try {
                    SyncAcceptContext syncAcceptContext = new SyncAcceptContext();
                    try {
                        this.dispatcher.acquire();
                        if (this.trace.debug) {
                            this.trace.debugln("Posting accept...");
                        }
                        this.port.acceptPost(this.dispatcher, (byte)15, this, syncAcceptContext, 0);
                        while (true) {
                            try {
                                long l = System.currentTimeMillis();
                                while (!syncAcceptContext.done) {
                                    int n2 = Math.max(0, n - (int)(System.currentTimeMillis() - l));
                                    if (this.trace.debug) {
                                        this.trace.debugln("Entering dispatch (remaining=" + n2 + ")...");
                                    }
                                    this.dispatcher.dispatch(n2);
                                }
                            }
                            catch (EEvsTimeoutException eEvsTimeoutException) {
                                if (this.trace.debug) {
                                    this.trace.debugln("Accept timed out. Cancelling...");
                                }
                                this.port.acceptCancel();
                                continue;
                            }
                            break;
                        }
                    }
                    catch (EEvsObjectHotException eEvsObjectHotException) {
                        throw new InternalError("Acquisition of internal dispatcher failed - " + eEvsObjectHotException.getMessage());
                    }
                    catch (EEvsObjectBusyException eEvsObjectBusyException) {
                        throw new InternalError("Acquisition of internal dispatcher failed - " + eEvsObjectBusyException.getMessage());
                    }
                    catch (EEvsNotOwnerException eEvsNotOwnerException) {
                        throw new InternalError("Dispatch of internal dispatcher failed - " + eEvsNotOwnerException.getMessage());
                    }
                    if (syncAcceptContext.status != null) {
                        if (syncAcceptContext.status instanceof EEvsIOCancelledException) {
                            this.trace.outln("Accept timed out.", 3);
                            throw new EIOTimeoutException("Timeout occured during accept");
                        }
                        this.trace.outln("Connection acceptance failed [" + syncAcceptContext.status.getMessage() + "]", 3);
                        throw new EIOException(syncAcceptContext.status);
                    }
                    this.trace.outln("Successfully accepted connection.", 3);
                    iONetworkConnection = new IONetworkConnection(syncAcceptContext.acceptedPort, this.threaded, this.packetSerializer, this.pingManager.getPingPacketManager(), this.parameters, true);
                }
                catch (EEvsIOException eEvsIOException) {
                    throw new EIOException(eEvsIOException);
                }
                return iONetworkConnection;
            }
            throw new EIOConnectionClosedException();
        }
        throw new IllegalStateException("operation not permitted on an active connection");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SysListHead receiveInternal(int n) throws EIOConnectionNotConnectedException, EIOConnectionClosedException, EIOConnectionFailedException, EIOInboundStreamOpenException, EIOTimeoutException, EIOException {
        if (!this.active) throw new IllegalStateException("operation not permitted on a passive connection");
        if (this.flgClosed) throw new EIOConnectionClosedException();
        if (this.flgFailed) throw new EIOConnectionFailedException();
        if (!this.flgConnected) throw new EIOConnectionNotConnectedException();
        if (this.inputStream.isOpen()) throw new EIOInboundStreamOpenException();
        SysListHead sysListHead = null;
        SyncReadContext syncReadContext = null;
        int n2 = n;
        if (this.trace.debug) {
            this.trace.debugln("Receiving packet with timeout=" + n + " ms");
        }
        this.syncReadContext = new SyncReadContext();
        try {
            this.dispatcher.acquire();
            if (this.trace.debug) {
                this.trace.debugln("Receive starting async read...");
            }
            this.readInternal(this.dispatcher, new SyncReadPacketHandler(), false);
            try {
                while (!this.syncReadContext.done) {
                    long l = System.currentTimeMillis();
                    this.dispatcher.dispatch(n2);
                    n2 = n < 0 ? n : Math.max(0, n2 - (int)(System.currentTimeMillis() - l));
                    if (n2 != 0) continue;
                    break;
                }
            }
            catch (EEvsTimeoutException eEvsTimeoutException) {
                n2 = 0;
            }
            finally {
                if (!this.syncReadContext.done || this.syncReadContext.status == null) {
                    if (this.trace.debug) {
                        this.trace.debugln("Receive cancelling async read...");
                    }
                    this.readInternal(this.dispatcher, null, false);
                    while (this.isInboundStreamOpen()) {
                        this.dispatcher.dispatch(-1);
                    }
                } else if (this.trace.debug) {
                    this.trace.debugln("Receive encountered error on connection. Async read implicitly cancelled.");
                }
            }
            syncReadContext = this.syncReadContext;
        }
        catch (EIOConnectionClosedException eIOConnectionClosedException) {
            throw new InternalError("Starting/stopping async read failed - " + eIOConnectionClosedException.getMessage());
        }
        catch (EIOConnectionFailedException eIOConnectionFailedException) {
            throw new InternalError("Starting/stopping async read failed - " + eIOConnectionFailedException.getMessage());
        }
        catch (EIOInboundStreamOpenException eIOInboundStreamOpenException) {
            throw new InternalError("Starting/stopping async read failed - " + eIOInboundStreamOpenException.getMessage());
        }
        catch (EIOInboundStreamClosedException eIOInboundStreamClosedException) {
            throw new InternalError("Starting/stopping async read failed - " + eIOInboundStreamClosedException.getMessage());
        }
        catch (EEvsObjectHotException eEvsObjectHotException) {
            throw new InternalError("Acquisition of internal dispatcher failed - " + eEvsObjectHotException.getMessage());
        }
        catch (EEvsObjectBusyException eEvsObjectBusyException) {
            throw new InternalError("Acquisition of internal dispatcher failed - " + eEvsObjectBusyException.getMessage());
        }
        catch (EEvsNotOwnerException eEvsNotOwnerException) {
            throw new InternalError("Dispatch of internal dispatcher failed - " + eEvsNotOwnerException.getMessage());
        }
        catch (EEvsTimeoutException eEvsTimeoutException) {
            throw new InternalError("Dispatch of internal dispatcher failed - " + eEvsTimeoutException.getMessage());
        }
        finally {
            this.syncReadContext = null;
        }
        if (syncReadContext.status == null) {
            if (syncReadContext.done) {
                if (!this.trace.debug) return syncReadContext.packetList;
                this.trace.debugln("Received packet successfully.");
                return syncReadContext.packetList;
            }
            if (this.checked && n2 != 0) {
                throw new InternalError("Completed sync receive with no error on connection, no packet received and no timeout!");
            }
            if (!this.trace.debug) throw new EIOTimeoutException("timed out on receive");
            this.trace.debugln("Timed out in receive.");
            throw new EIOTimeoutException("timed out on receive");
        }
        if (!this.trace.debug) throw new EIOException(syncReadContext.status);
        this.trace.debugln("Receive encountered error [" + syncReadContext.status.getMessage() + "]");
        throw new EIOException(syncReadContext.status);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readInternal(IEvsDispatcher iEvsDispatcher, IIOConnectionPacketHandler iIOConnectionPacketHandler, boolean bl) throws EIOConnectionNotConnectedException, EIOConnectionClosedException, EIOConnectionFailedException, EIOInboundStreamOpenException, EIOInboundStreamClosedException, EIOException {
        if (!this.active) throw new IllegalStateException("operation not permitted on a passive connection");
        if (this.flgClosed) throw new EIOConnectionClosedException();
        if (this.flgFailed) throw new EIOConnectionFailedException();
        if (!this.flgConnected) throw new EIOConnectionNotConnectedException();
        if (iIOConnectionPacketHandler != null) {
            if (this.trace.debug) {
                this.trace.debugln("Opening inbound stream...");
            }
            this.inputStream.open(iEvsDispatcher);
            this.pingManager.start(iEvsDispatcher);
            this.failureGovernor.start(iEvsDispatcher);
            this.packetHandler = iIOConnectionPacketHandler;
            return;
        } else {
            if (this.trace.debug) {
                this.trace.debugln("Closing inbound stream...");
            }
            this.failureGovernor.stop();
            this.pingManager.stop();
            this.inputStream.cloze();
        }
    }

    private IIOConnectionPacketHandler setPacketHandlerInternal(IIOConnectionPacketHandler iIOConnectionPacketHandler) throws EIOConnectionNotConnectedException, EIOConnectionClosedException, EIOConnectionFailedException, EIOInboundStreamClosedException, EIOException {
        if (this.active) {
            if (iIOConnectionPacketHandler == null) {
                throw new IllegalArgumentException("replacement packet handler cannot null");
            }
            if (!this.flgClosed) {
                if (!this.flgFailed) {
                    if (this.flgConnected) {
                        if (this.inputStream.isOpen()) {
                            if (this.trace.debug) {
                                this.trace.debugln("Replacing packet handler...");
                            }
                            IIOConnectionPacketHandler iIOConnectionPacketHandler2 = this.packetHandler;
                            this.packetHandler = iIOConnectionPacketHandler;
                            return iIOConnectionPacketHandler2;
                        }
                        throw new EIOInboundStreamClosedException();
                    }
                    throw new EIOConnectionNotConnectedException();
                }
                throw new EIOConnectionFailedException();
            }
            throw new EIOConnectionClosedException();
        }
        throw new IllegalStateException("operation not permitted on a passive connection");
    }

    private boolean writeInternal(IIOPacket iIOPacket, IIOConnection.FlushContext flushContext, int n) throws EIOConnectionNotConnectedException, EIOConnectionClosedException, EIOConnectionFailedException, EIOFlushPendingException, EIOException {
        if (this.active) {
            if (!this.flgClosed) {
                if (!this.flgFailed) {
                    if (this.flgConnected) {
                        if (this.failureGovernor.failOnWrite()) {
                            this.trace.outln("Intentionally failing connection (random on write)...", 2);
                            try {
                                this.fail(new Exception("Random force fail on write"));
                                if (this.failureGovernor.failWriteCall()) {
                                    throw new EIOException("random force fail on write");
                                }
                            }
                            catch (EIOException eIOException) {
                                this.trace.outln("Failed to intentionally fail connection [" + eIOException.getMessage() + "]", 2);
                            }
                        }
                        if (!this.flgForceFailed) {
                            ++this.statistics.numPacketsWritten;
                            return this.pingManager.write(iIOPacket, flushContext, n);
                        }
                        return false;
                    }
                    throw new EIOConnectionNotConnectedException();
                }
                throw new EIOConnectionFailedException();
            }
            throw new EIOConnectionClosedException();
        }
        throw new IllegalStateException("operation not permitted on a passive connection");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void flushInternal(IIOConnection.FlushContext flushContext) throws EIOConnectionNotConnectedException, EIOConnectionClosedException, EIOConnectionFailedException, EIOFlushPendingException, EIOException {
        if (!this.active) throw new IllegalStateException("operation not permitted on a passive connection");
        if (this.flgClosed) throw new EIOConnectionClosedException();
        if (this.flgFailed) throw new EIOConnectionFailedException();
        if (!this.flgConnected) throw new EIOConnectionNotConnectedException();
        if (this.flgForceFailed) return;
        this.pingManager.flush(flushContext);
    }

    private boolean isInboundStreamOpenInternal() throws EIOConnectionClosedException, EIOException {
        if (this.active) {
            if (!this.flgClosed) {
                return this.inputStream.isOpen();
            }
            throw new EIOConnectionClosedException();
        }
        throw new IllegalStateException("operation not permitted on a passive connection");
    }

    private int getOutboundStreamBufferSizeInternal() throws EIOConnectionNotConnectedException, EIOConnectionClosedException, EIOConnectionFailedException, EIOException {
        if (this.active) {
            if (!this.flgClosed) {
                if (!this.flgFailed) {
                    if (this.flgConnected) {
                        return this.outputStream.getBufferSize();
                    }
                    throw new EIOConnectionNotConnectedException();
                }
                throw new EIOConnectionFailedException();
            }
            throw new EIOConnectionClosedException();
        }
        throw new IllegalStateException("operation not permitted on a passive connection");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void failInternal(Exception exception) throws EIOConnectionNotConnectedException, EIOConnectionClosedException, EIOConnectionFailedException, EIOInboundStreamClosedException, EIOException {
        if (!this.active) throw new IllegalStateException("operation not permitted on a passive connection");
        if (this.flgClosed) throw new EIOConnectionClosedException();
        if (this.flgFailed) throw new EIOConnectionFailedException();
        if (!this.flgConnected) throw new EIOConnectionNotConnectedException();
        if (this.flgForceFailed) return;
        this.inputStream.fail(exception);
        this.flgForceFailed = true;
    }

    private void closeInternal() throws EIOInboundStreamOpenException, EIOFlushPendingException, EIOException {
        if (!this.flgClosed) {
            if (this.active) {
                if (!this.inputStream.isOpen()) {
                    this.outputStream.shutdown();
                } else {
                    throw new EIOInboundStreamOpenException();
                }
            }
            try {
                this.dispatcher.acquire();
                this.dispatcher.close();
                this.port.close();
            }
            catch (EEvsObjectBusyException eEvsObjectBusyException) {
                throw new InternalError("Dispatcher busy with no sync operation in progress!");
            }
            catch (EEvsNotOwnerException eEvsNotOwnerException) {
                throw new InternalError("Dispatcher hot with no sync operation in progress!");
            }
            catch (EEvsObjectHotException eEvsObjectHotException) {
                throw new InternalError("Dispatcher hot with no sync operation in progress!");
            }
            catch (EEvsIOPendingException eEvsIOPendingException) {
                throw new InternalError("I/O operation pending on port with input and output streams shut down!");
            }
            catch (EEvsIOException eEvsIOException) {
                throw new EIOException(eEvsIOException);
            }
            finally {
                if (this.statistics != null) {
                    this.statistics.stopDump();
                }
                this.flgClosed = true;
                this.trace.outln("Connection closed.", 3);
            }
        }
    }

    private boolean isClosedInternal() throws EIOException {
        if (this.active) {
            return this.flgClosed;
        }
        throw new IllegalStateException("operation not permitted on a passive connection");
    }

    private boolean isFailedInternal() throws EIOConnectionClosedException, EIOException {
        if (this.active) {
            if (!this.flgClosed) {
                return this.flgFailed;
            }
            throw new EIOConnectionClosedException();
        }
        throw new IllegalStateException("operation not permitted on a passive connection");
    }

    private Object ioctlInternal(String string, Object object) throws ESysIoctlException, EIOConnectionFailedException, EIOConnectionClosedException, EIOException {
        if (!this.flgClosed) {
            if (!this.flgFailed) {
                try {
                    return ((ISysIoctl)((Object)this.port)).ioctl(string, object);
                }
                catch (ESysIoctlException eSysIoctlException) {
                    throw eSysIoctlException;
                }
                catch (Exception exception) {
                    throw new EIOException(exception);
                }
            }
            throw new EIOConnectionFailedException();
        }
        throw new EIOConnectionClosedException();
    }

    private void handleConnectionFailure(EIOException eIOException) {
        this.flgFailed = true;
        this.failureGovernor.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void handlePacket(EIOException eIOException, IIOPacket iIOPacket) {
        if (eIOException == null) {
            if (this.failureGovernor.failOnRead()) {
                this.trace.outln("Intentionally failing connection (random on read)...", 2);
                try {
                    this.fail(new Exception("Random force fail on read"));
                }
                catch (EIOException eIOException2) {
                    this.trace.outln("Failed to intentionally fail connection [" + eIOException2.getMessage() + "]", 2);
                }
            }
            if (!this.flgForceFailed) {
                this.packetHandler.handlePacket(eIOException, iIOPacket);
            }
        } else {
            if (this.threaded) {
                IONetworkConnection iONetworkConnection = this;
                synchronized (iONetworkConnection) {
                    this.handleConnectionFailure(eIOException);
                }
            } else {
                this.handleConnectionFailure(eIOException);
            }
            this.packetHandler.handlePacket(eIOException, iIOPacket);
        }
    }

    public static IIOConnection create(IEvsNetworkPort iEvsNetworkPort, boolean bl, boolean bl2, IIOPacketSerializer iIOPacketSerializer, IIONetworkConnectionPingPacketManager iIONetworkConnectionPingPacketManager, Parameters parameters) throws EIOException {
        try {
            return new IONetworkConnection(iEvsNetworkPort, bl, iIOPacketSerializer, iIONetworkConnectionPingPacketManager, parameters, bl2);
        }
        catch (EEvsIOException eEvsIOException) {
            throw new EIOException(eEvsIOException);
        }
    }

    public static IIOConnection create(boolean bl, String string, boolean bl2, IIOPacketSerializer iIOPacketSerializer, IIONetworkConnectionPingPacketManager iIONetworkConnectionPingPacketManager, Parameters parameters) throws EIOException {
        IEvsNetworkPort iEvsNetworkPort = null;
        try {
            iEvsNetworkPort = EvsNetworkPort.create(bl ? 1 : 0, string, false);
            return IONetworkConnection.create(iEvsNetworkPort, bl2, false, iIOPacketSerializer, iIONetworkConnectionPingPacketManager, parameters);
        }
        catch (EEvsException eEvsException) {
            if (iEvsNetworkPort != null) {
                try {
                    iEvsNetworkPort.close();
                }
                catch (Exception exception) {
                    throw new InternalError("Closing of port failed - " + exception.getMessage());
                }
            }
            throw new EIOException(eEvsException);
        }
    }

    public final FailureGovernor getFailureGovernor() {
        return this.failureGovernor;
    }

    @Override
    public final void handleEvent(IEvsPortEvent iEvsPortEvent) {
        switch (iEvsPortEvent.getType()) {
            case 2: {
                SyncConnectContext syncConnectContext = (SyncConnectContext)iEvsPortEvent.getData();
                syncConnectContext.done = true;
                syncConnectContext.status = ((IEvsNetworkPortPortEvent)iEvsPortEvent).getStatus();
                break;
            }
            case 3: {
                SyncAcceptContext syncAcceptContext = (SyncAcceptContext)iEvsPortEvent.getData();
                syncAcceptContext.done = true;
                syncAcceptContext.status = ((IEvsNetworkPortPortEvent)iEvsPortEvent).getStatus();
                syncAcceptContext.acceptedPort = ((IEvsNetworkPortPortEvent)iEvsPortEvent).getNetworkPort();
            }
        }
    }

    @Override
    public final boolean isThreaded() {
        return this.threaded;
    }

    @Override
    public final IIOConnectionStatistics getStatistics() {
        return this.statistics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void connect() throws EIOConnectionAlreadyConnectedException, EIOConnectionClosedException, EIOException {
        if (this.threaded) {
            IONetworkConnection iONetworkConnection = this;
            synchronized (iONetworkConnection) {
                this.connectInternal();
            }
        } else {
            this.connectInternal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isConnected() throws EIOConnectionClosedException, EIOException {
        if (this.threaded) {
            IONetworkConnection iONetworkConnection = this;
            synchronized (iONetworkConnection) {
                return this.isConnectedInternal();
            }
        }
        return this.isConnectedInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final IIOConnection accept(int n) throws EIOConnectionClosedException, EIOTimeoutException, EIOException {
        IIOConnection iIOConnection = null;
        if (n < 0) {
            throw new IllegalArgumentException("timeout must be non-negative");
        }
        if (this.threaded) {
            IONetworkConnection iONetworkConnection = this;
            synchronized (iONetworkConnection) {
                iIOConnection = this.acceptInternal(n);
            }
        } else {
            iIOConnection = this.acceptInternal(n);
        }
        return iIOConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final SysListHead receive(int n) throws EIOConnectionNotConnectedException, EIOConnectionClosedException, EIOConnectionFailedException, EIOTimeoutException, EIOInboundStreamOpenException, EIOException {
        SysListHead sysListHead = null;
        if (this.threaded) {
            IONetworkConnection iONetworkConnection = this;
            synchronized (iONetworkConnection) {
                sysListHead = this.receiveInternal(n);
            }
        } else {
            sysListHead = this.receiveInternal(n);
        }
        return sysListHead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void read(IEvsDispatcher iEvsDispatcher, IIOConnectionPacketHandler iIOConnectionPacketHandler) throws EIOConnectionNotConnectedException, EIOConnectionClosedException, EIOConnectionFailedException, EIOInboundStreamOpenException, EIOInboundStreamClosedException, EIOException {
        if (this.threaded) {
            IONetworkConnection iONetworkConnection = this;
            synchronized (iONetworkConnection) {
                this.readInternal(iEvsDispatcher, iIOConnectionPacketHandler, true);
            }
        } else {
            this.readInternal(iEvsDispatcher, iIOConnectionPacketHandler, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IIOConnectionPacketHandler setPacketHandler(IIOConnectionPacketHandler iIOConnectionPacketHandler) throws EIOConnectionNotConnectedException, EIOConnectionClosedException, EIOConnectionFailedException, EIOInboundStreamClosedException, EIOException {
        if (this.threaded) {
            IONetworkConnection iONetworkConnection = this;
            synchronized (iONetworkConnection) {
                return this.setPacketHandlerInternal(iIOConnectionPacketHandler);
            }
        }
        return this.setPacketHandlerInternal(iIOConnectionPacketHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean write(IIOPacket iIOPacket, IIOConnection.FlushContext flushContext, int n) throws EIOConnectionNotConnectedException, EIOConnectionClosedException, EIOConnectionFailedException, EIOFlushPendingException, EIOException {
        if (this.threaded) {
            IONetworkConnection iONetworkConnection = this;
            synchronized (iONetworkConnection) {
                return this.writeInternal(iIOPacket, flushContext, n);
            }
        }
        return this.writeInternal(iIOPacket, flushContext, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void flush(IIOConnection.FlushContext flushContext) throws EIOConnectionNotConnectedException, EIOConnectionClosedException, EIOConnectionFailedException, EIOFlushPendingException, EIOException {
        if (this.threaded) {
            IONetworkConnection iONetworkConnection = this;
            synchronized (iONetworkConnection) {
                this.flushInternal(flushContext);
            }
        } else {
            this.flushInternal(flushContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isInboundStreamOpen() throws EIOConnectionClosedException, EIOException {
        if (this.threaded) {
            IONetworkConnection iONetworkConnection = this;
            synchronized (iONetworkConnection) {
                return this.isInboundStreamOpenInternal();
            }
        }
        return this.isInboundStreamOpenInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int getOutboundStreamBufferSize() throws EIOConnectionNotConnectedException, EIOConnectionClosedException, EIOConnectionFailedException, EIOException {
        if (this.threaded) {
            IONetworkConnection iONetworkConnection = this;
            synchronized (iONetworkConnection) {
                return this.getOutboundStreamBufferSizeInternal();
            }
        }
        return this.getOutboundStreamBufferSizeInternal();
    }

    @Override
    public final void fail(Exception exception) throws EIOConnectionNotConnectedException, EIOConnectionClosedException, EIOConnectionFailedException, EIOInboundStreamClosedException, EIOException {
        this.failInternal(exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws EIOInboundStreamOpenException, EIOFlushPendingException, EIOException {
        if (this.threaded) {
            IONetworkConnection iONetworkConnection = this;
            synchronized (iONetworkConnection) {
                this.closeInternal();
            }
        } else {
            this.closeInternal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isClosed() throws EIOException {
        if (this.threaded) {
            IONetworkConnection iONetworkConnection = this;
            synchronized (iONetworkConnection) {
                return this.isClosedInternal();
            }
        }
        return this.isClosedInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isFailed() throws EIOConnectionClosedException, EIOException {
        if (this.threaded) {
            IONetworkConnection iONetworkConnection = this;
            synchronized (iONetworkConnection) {
                return this.isFailedInternal();
            }
        }
        return this.isFailedInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Object ioctl(String string, Object object) throws ESysIoctlException, EIOConnectionFailedException, EIOConnectionClosedException, EIOException {
        if (this.threaded) {
            IONetworkConnection iONetworkConnection = this;
            synchronized (iONetworkConnection) {
                return this.ioctlInternal(string, object);
            }
        }
        return this.ioctlInternal(string, object);
    }

    public final class FailureGovernor {
        private final int writeFailPct = Math.max(Math.min((int)(SysConfig.getConfigValue(SysConfig.getProperties(), "bb.io.nwconn.randomFailures.writeFailPct", 0.0) * 1000.0), 100000), 0);
        private final int readFailPct = Math.max(Math.min((int)(SysConfig.getConfigValue(SysConfig.getProperties(), "bb.io.nwconn.randomFailures.readFailPct", 0.0) * 1000.0), 100000), 0);
        private final int timerFailPct = Math.max(Math.min((int)(SysConfig.getConfigValue(SysConfig.getProperties(), "bb.io.nwconn.randomFailures.timerFailPct", 0.0) * 1000.0), 100000), 0);
        private final Random writeRandom;
        private final Random readRandom;
        private final Random timerRandom;
        private final IEvsTimerPort timer;
        private volatile boolean forceFailOnNextRead;
        private volatile boolean forceFailOnNextWrite;

        FailureGovernor() {
            Random random = new Random(System.currentTimeMillis());
            this.writeRandom = this.writeFailPct > 0 ? new Random(System.currentTimeMillis() + (long)random.nextInt(Integer.MAX_VALUE)) : null;
            this.readRandom = this.readFailPct > 0 ? new Random(System.currentTimeMillis() + (long)random.nextInt(Integer.MAX_VALUE)) : null;
            this.timerRandom = this.timerFailPct > 0 ? new Random(System.currentTimeMillis() + (long)random.nextInt(Integer.MAX_VALUE)) : null;
            this.timer = this.timerFailPct > 0 ? EvsTimerPort.create(true) : null;
            IONetworkConnection.this.trace.outln("Connection - Random failures parameters:\n  Write failure=" + (double)this.writeFailPct / 1000.0 + "%\n" + "  Read failure=" + (double)this.readFailPct / 1000.0 + "%\n" + "  Timer failure=" + (double)this.timerFailPct / 1000.0 + "%", 4);
        }

        private void handleTimerEvent() {
            if (((IONetworkConnection)IONetworkConnection.this).trace.debug) {
                IONetworkConnection.this.trace.debugln("Received failure timer event...");
            }
            if (this.failOnTimer()) {
                IONetworkConnection.this.trace.outln("Intentionally failing connection (random on timer)...", 2);
                try {
                    IONetworkConnection.this.fail(new Exception("Random force fail on timer"));
                }
                catch (EIOException eIOException) {
                    IONetworkConnection.this.trace.outln("Failed to intentionally fail connection [" + eIOException.getMessage() + "]", 2);
                }
            } else if (((IONetworkConnection)IONetworkConnection.this).trace.debug) {
                IONetworkConnection.this.trace.debugln("Not failing connection.");
            }
        }

        final void start(IEvsDispatcher iEvsDispatcher) {
            if (this.timer != null) {
                try {
                    this.timer.start(iEvsDispatcher, (byte)15, 1000, new TimerEventHandler(), null);
                }
                catch (EEvsObjectHotException eEvsObjectHotException) {
                    // empty catch block
                }
            }
        }

        final boolean failOnWrite() {
            if (this.forceFailOnNextWrite) {
                this.forceFailOnNextWrite = false;
                return true;
            }
            return this.writeFailPct > 0 ? this.writeRandom.nextInt(100000) < this.writeFailPct : false;
        }

        final boolean failWriteCall() {
            return this.writeFailPct > 0 ? this.writeRandom.nextInt(100000) < 50000 : false;
        }

        final boolean failOnRead() {
            if (this.forceFailOnNextRead) {
                this.forceFailOnNextRead = false;
                return true;
            }
            return this.readFailPct > 0 ? this.readRandom.nextInt(100000) < this.readFailPct : false;
        }

        final boolean failOnTimer() {
            return this.timerFailPct > 0 ? this.timerRandom.nextInt(100000) < this.timerFailPct : false;
        }

        final void stop() {
            if (this.timer != null) {
                this.timer.stop();
            }
        }

        public final void forceFailOnNextRead() {
            this.forceFailOnNextRead = true;
        }

        public final void forceFailOnNextWrite() {
            this.forceFailOnNextWrite = true;
        }

        public final void forceFail() throws EIOException {
            IONetworkConnection.this.fail(new Exception("Explicit force failed by user"));
        }

        private final class TimerEventHandler
        implements IEvsPortEventHandler {
            private TimerEventHandler() {
            }

            @Override
            public void handleEvent(IEvsPortEvent iEvsPortEvent) {
                FailureGovernor.this.handleTimerEvent();
            }
        }
    }

    public final class Statistics
    extends SysStatistics
    implements IIOConnectionStatistics {
        private NumberFormat format = NumberFormat.getInstance();
        private long startTime;
        private long deltaStartTime;
        private long numReadsPostedLast;
        private long numPacketsReadLast;
        private long numBytesReadLast;
        private long numPacketsWrittenLast;
        private long numFlushesLast;
        private long numFlushesSyncLast;
        long numReadsPosted;
        long numPacketsRead;
        long numBytesRead;
        long numPacketsWritten;
        long numFlushes;
        long numFlushesSync;

        private Statistics(boolean bl) {
            this.format.setMaximumFractionDigits(2);
        }

        @Override
        protected final void init() {
            this.startTime = this.deltaStartTime = System.currentTimeMillis();
            this.numReadsPostedLast = this.numReadsPosted;
            this.numPacketsReadLast = this.numPacketsRead;
            this.numBytesReadLast = this.numBytesRead;
            this.numPacketsWrittenLast = this.numPacketsWritten;
            this.numFlushesLast = this.numFlushes;
            this.numFlushesSyncLast = this.numFlushesSync;
        }

        @Override
        protected final void dump() {
            long l = System.currentTimeMillis();
            long l2 = this.numReadsPosted;
            long l3 = this.numPacketsRead;
            long l4 = this.numBytesRead;
            long l5 = this.numPacketsWritten;
            long l6 = this.numFlushes;
            long l7 = this.numFlushesSync;
            long l8 = l - this.startTime;
            long l9 = l - this.deltaStartTime;
            String string = this.format.format(l2);
            String string2 = this.format.format(l2 - this.numReadsPostedLast);
            String string3 = this.format.format(l2 * 1000L / l8);
            String string4 = this.format.format((l2 - this.numReadsPostedLast) * 1000L / l9);
            String string5 = this.format.format(l3);
            String string6 = this.format.format(l3 - this.numPacketsReadLast);
            String string7 = this.format.format(l3 * 1000L / l8);
            String string8 = this.format.format((l3 - this.numPacketsReadLast) * 1000L / l9);
            String string9 = this.format.format(l4);
            String string10 = this.format.format(l4 - this.numBytesReadLast);
            String string11 = this.format.format(l4 * 1000L / l8);
            String string12 = this.format.format((l4 - this.numBytesReadLast) * 1000L / l9);
            String string13 = l2 > 0L ? this.format.format(l3 / l2) : "0";
            String string14 = l2 - this.numReadsPostedLast > 0L ? this.format.format((l3 - this.numPacketsReadLast) / (l2 - this.numReadsPostedLast)) : "0";
            String string15 = l2 > 0L ? this.format.format(l4 / l2) : "0";
            String string16 = l2 - this.numReadsPostedLast > 0L ? this.format.format((l4 - this.numBytesReadLast) / (l2 - this.numReadsPostedLast)) : "0";
            String string17 = this.format.format(l5);
            String string18 = this.format.format(l5 - this.numPacketsWrittenLast);
            String string19 = this.format.format(l5 * 1000L / l8);
            String string20 = this.format.format((l5 - this.numPacketsWrittenLast) * 1000L / l9);
            String string21 = this.format.format(l6);
            String string22 = this.format.format(l6 - this.numFlushesLast);
            String string23 = this.format.format(l6 * 1000L / l8);
            String string24 = this.format.format((l6 - this.numFlushesLast) * 1000L / l9);
            String string25 = this.format.format(l7);
            String string26 = this.format.format(l7 - this.numFlushesSyncLast);
            String string27 = this.format.format(l7 * 1000L / l8);
            String string28 = this.format.format((l7 - this.numFlushesSyncLast) * 1000L / l9);
            String string29 = this.format.format(l6 > 0L ? l7 * 100L / l6 : 0L);
            String string30 = this.format.format(l6 - this.numFlushesLast > 0L ? (l7 - this.numFlushesSyncLast) * 100L / (l6 - this.numFlushesLast) : 0L);
            this.deltaStartTime = l;
            this.numReadsPostedLast = l2;
            this.numPacketsReadLast = l3;
            this.numBytesReadLast = l4;
            this.numPacketsWrittenLast = l5;
            this.numFlushesLast = l6;
            this.numFlushesSyncLast = l7;
            String string31 = "[" + IONetworkConnection.this + " STATS] DT=" + l9 + "\n";
            string31 = string31 + " Read{";
            string31 = string31 + string + "(" + string2 + ") ";
            string31 = string31 + string3 + "(" + string4 + ") ";
            string31 = string31 + string5 + "(" + string6 + ") ";
            string31 = string31 + string7 + "(" + string8 + ") ";
            string31 = string31 + string9 + "(" + string10 + ") ";
            string31 = string31 + string11 + "(" + string12 + ") ";
            string31 = string31 + string13 + "(" + string14 + ") ";
            string31 = string31 + string15 + "(" + string16 + ")";
            string31 = string31 + "}";
            string31 = string31 + " Write{";
            string31 = string31 + string17 + "(" + string18 + ") ";
            string31 = string31 + string19 + "(" + string20 + ")";
            string31 = string31 + "}";
            string31 = string31 + " Flush{";
            string31 = string31 + string21 + "(" + string22 + ") ";
            string31 = string31 + string23 + "(" + string24 + ") ";
            string31 = string31 + string25 + "(" + string26 + ") ";
            string31 = string31 + string27 + "(" + string28 + ") ";
            string31 = string31 + string29 + "%" + "(" + string30 + "%)";
            string31 = string31 + "}";
            string31 = string31 + IONetworkConnection.this.inputStream.getStatisticsString();
            string31 = string31 + IONetworkConnection.this.outputStream.getStatisticsString();
            string31 = string31 + "\n";
            IONetworkConnection.this.trace.out(string31, -1);
        }
    }

    public static final class Parameters {
        final int pingInterval;
        final int autoFlushSize;

        private Parameters(int n, int n2) {
            this.pingInterval = n == 0 ? (int)SysConfig.getConfigValue(System.getProperties(), "bb.io.nwconn.pingInterval", -1.0) : n;
            this.autoFlushSize = n2 == 0 ? (int)SysConfig.getConfigValue(System.getProperties(), "bb.io.conn.autoFlushSize", 8192.0) : n2;
        }

        public final int getPingInterval() {
            return this.pingInterval;
        }

        public final int getAutoFlushSize() {
            return this.autoFlushSize;
        }

        public static Parameters create(int n, int n2) {
            return new Parameters(n, n2);
        }

        public static Parameters create() {
            return new Parameters(0, 0);
        }

        public final Object clone() {
            return Parameters.create(this.pingInterval, this.autoFlushSize);
        }

        public final String toString() {
            return "[pingInterval=" + this.pingInterval + " autoFlushSize=" + this.autoFlushSize + "]";
        }
    }

    private final class SyncReadPacketHandler
    implements IIOConnectionPacketHandler {
        private SyncReadPacketHandler() {
        }

        @Override
        public final void handlePacket(EIOException eIOException, IIOPacket iIOPacket) {
            ((IONetworkConnection)IONetworkConnection.this).syncReadContext.done = true;
            if (eIOException != null) {
                ((IONetworkConnection)IONetworkConnection.this).syncReadContext.status = eIOException;
            } else {
                ((IONetworkConnection)IONetworkConnection.this).syncReadContext.packetList.append((SysListElement)((Object)iIOPacket));
            }
        }
    }

    private final class SyncReadContext
    extends SyncContext {
        SysListHead packetList;

        SyncReadContext() {
            this.packetList = SysListHead.create(null);
        }

        @Override
        final void reset() {
            super.reset();
            this.packetList = null;
        }
    }

    private final class SyncAcceptContext
    extends SyncContext {
        IEvsNetworkPort acceptedPort;

        private SyncAcceptContext() {
        }

        @Override
        final void reset() {
            super.reset();
            this.acceptedPort = null;
        }
    }

    private final class SyncConnectContext
    extends SyncContext {
        private SyncConnectContext() {
        }
    }

    private class SyncContext {
        boolean done;
        Exception status;

        private SyncContext() {
        }

        void reset() {
            this.done = false;
            this.status = null;
        }
    }
}

