/*
 * Decompiled with CFR 0.152.
 */
package com.progress.blackbird.pdu;

import com.progress.blackbird.io.EIOException;
import com.progress.blackbird.io.EIOInsufficientDataException;
import com.progress.blackbird.pdu.PDUPacket;
import com.progress.blackbird.pdu.PDUPacketHeader;
import com.progress.blackbird.pdu.PDUPacketRequest;
import com.progress.blackbird.sys.SysInteractive;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public final class PDUPacketLeaveRequest
extends PDUPacketRequest {
    private String topic;

    private PDUPacketLeaveRequest(String string) {
        super((short)9);
        this.setTopic(string);
        this.getHeader().setClazz((short)3);
    }

    private PDUPacketLeaveRequest(PDUPacketHeader pDUPacketHeader, DataInputStream dataInputStream) throws EIOInsufficientDataException, EIOException {
        super(pDUPacketHeader, dataInputStream);
        if (this.checked && pDUPacketHeader.getType() != 9) {
            throw new InternalError("LEAVE packet being constructed from stream but header indicates otherwise");
        }
    }

    private PDUPacketLeaveRequest(PDUPacketHeader pDUPacketHeader, PrintStream printStream, BufferedReader bufferedReader) throws IOException {
        super(pDUPacketHeader, printStream, bufferedReader);
        if (this.checked && pDUPacketHeader.getType() != 9) {
            throw new InternalError("LEAVE packet being constructed interactively but header indicates otherwise");
        }
    }

    @Override
    final void serializeBody(DataOutputStream dataOutputStream) throws EIOException {
        super.serializeBody(dataOutputStream);
        try {
            String string = this.topic == null ? "" : this.topic;
            dataOutputStream.writeShort(this.getBodyWireSize() - super.getBodyWireSize() - 2);
            dataOutputStream.writeUTF(string);
        }
        catch (IOException iOException) {
            throw new EIOException(iOException.getMessage());
        }
    }

    @Override
    final void deserializeBody(DataInputStream dataInputStream) throws EIOInsufficientDataException, EIOException {
        super.deserializeBody(dataInputStream);
        try {
            if (dataInputStream.available() >= 2) {
                short s = dataInputStream.readShort();
                if (dataInputStream.available() < s) {
                    throw new EIOInsufficientDataException(s - dataInputStream.available());
                }
            } else {
                throw new EIOInsufficientDataException();
            }
            this.setTopic(dataInputStream.readUTF());
        }
        catch (IOException iOException) {
            throw new EIOException(iOException.getMessage());
        }
    }

    @Override
    final void deserializeBody(PrintStream printStream, BufferedReader bufferedReader) throws IOException {
        super.deserializeBody(printStream, bufferedReader);
        this.setTopic(SysInteractive.ask("Topic to leave", printStream, bufferedReader, null));
    }

    @Override
    final void cloneBody(PDUPacket pDUPacket) {
    }

    @Override
    final int getBodyWireSize() {
        return super.getBodyWireSize() + 2 + 2 + (this.topic == null ? 0 : this.topic.length());
    }

    @Override
    final String bodyToString() {
        return "{" + super.bodyToString() + ", " + this.topic + "}";
    }

    public static PDUPacketLeaveRequest create(String string) {
        return new PDUPacketLeaveRequest(string);
    }

    static PDUPacketLeaveRequest create(PDUPacketHeader pDUPacketHeader, DataInputStream dataInputStream) throws EIOInsufficientDataException, EIOException {
        return new PDUPacketLeaveRequest(pDUPacketHeader, dataInputStream);
    }

    static PDUPacketLeaveRequest create(PDUPacketHeader pDUPacketHeader, PrintStream printStream, BufferedReader bufferedReader) throws IOException {
        return new PDUPacketLeaveRequest(pDUPacketHeader, printStream, bufferedReader);
    }

    public final void setTopic(String string) {
        this.topic = string;
    }

    public final String getTopic() {
        return this.topic;
    }
}

