/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.agent;

import java.lang.reflect.InvocationTargetException;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;

final class ExceptionMapper {
    ExceptionMapper() {
    }

    static void throwMappedException(Throwable e) throws Exception {
        ExceptionMapper.throwMappedException(e, true, true);
    }

    static void throwMappedException(Throwable e, boolean mapRuntimeExceptions, boolean mapRuntimeErrors) throws Exception {
        if (e instanceof InvocationTargetException) {
            ExceptionMapper.throwMappedException(((InvocationTargetException)e).getTargetException());
        }
        if (e instanceof ReflectionException) {
            throw (Exception)e;
        }
        if (e instanceof ClassNotFoundException) {
            throw new ReflectionException((Exception)e);
        }
        if (e instanceof InstantiationException) {
            throw new ReflectionException((Exception)e);
        }
        if (e instanceof IllegalAccessException) {
            throw new ReflectionException((Exception)e);
        }
        if (e instanceof NoSuchMethodException) {
            throw new ReflectionException((Exception)e);
        }
        if (e instanceof RuntimeOperationsException) {
            throw (Exception)e;
        }
        if (e instanceof IllegalArgumentException) {
            if (mapRuntimeExceptions) {
                throw new RuntimeOperationsException((RuntimeException)e);
            }
            throw (IllegalArgumentException)e;
        }
        if (e instanceof IndexOutOfBoundsException) {
            if (mapRuntimeExceptions) {
                throw new RuntimeOperationsException((RuntimeException)e);
            }
            throw (IndexOutOfBoundsException)e;
        }
        if (e instanceof NullPointerException) {
            if (mapRuntimeExceptions) {
                throw new RuntimeOperationsException((RuntimeException)e);
            }
            throw (NullPointerException)e;
        }
        if (e instanceof RuntimeMBeanException) {
            throw (Exception)e;
        }
        if (e instanceof RuntimeException) {
            if (mapRuntimeExceptions) {
                throw new RuntimeMBeanException((RuntimeException)e);
            }
            throw (RuntimeException)e;
        }
        if (e instanceof RuntimeErrorException) {
            throw (Exception)e;
        }
        if (e instanceof Error) {
            if (mapRuntimeErrors) {
                throw new RuntimeErrorException((Error)e);
            }
            throw (Error)e;
        }
        if (e instanceof JMException) {
            throw (Exception)e;
        }
        throw new MBeanException((Exception)e);
    }
}

