/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.directory;

import com.odi.ReplicationController;
import com.odi.ReplicationStateHandler;
import com.odi.Storage;
import com.sonicsw.ma.mgmtapi.config.IMgmtBeanBase;
import com.sonicsw.ma.mgmtapi.config.MgmtException;
import com.sonicsw.mf.comm.IGlobalComponentListener;
import com.sonicsw.mf.common.DSNotStartedException;
import com.sonicsw.mf.common.IComponentContext;
import com.sonicsw.mf.common.IDSTransaction;
import com.sonicsw.mf.common.IDirectoryAdminService;
import com.sonicsw.mf.common.IDirectoryFileSystemService;
import com.sonicsw.mf.common.ILogger;
import com.sonicsw.mf.common.MFException;
import com.sonicsw.mf.common.MFRuntimeException;
import com.sonicsw.mf.common.MFServiceNotActiveException;
import com.sonicsw.mf.common.Version;
import com.sonicsw.mf.common.config.ConfigException;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IBasicElement;
import com.sonicsw.mf.common.config.IBlob;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.IElementChange;
import com.sonicsw.mf.common.config.IElementDeleteNotification;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.config.IEnvelope;
import com.sonicsw.mf.common.config.IFolderDeleteNotification;
import com.sonicsw.mf.common.config.IHandlerConstants;
import com.sonicsw.mf.common.config.IIdentity;
import com.sonicsw.mf.common.config.INamingNotification;
import com.sonicsw.mf.common.config.INextVersionToken;
import com.sonicsw.mf.common.config.IRenameNotification;
import com.sonicsw.mf.common.config.IValidationConstants;
import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mf.common.config.impl.Blob;
import com.sonicsw.mf.common.config.impl.Element;
import com.sonicsw.mf.common.config.impl.EntityName;
import com.sonicsw.mf.common.config.query.AttributeName;
import com.sonicsw.mf.common.config.query.From;
import com.sonicsw.mf.common.config.query.FromElementList;
import com.sonicsw.mf.common.config.query.Query;
import com.sonicsw.mf.common.config.query.QueryBatch;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.dirconfig.ElementFactory;
import com.sonicsw.mf.common.dirconfig.IDeltaDirElement;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.dirconfig.IDirIdentity;
import com.sonicsw.mf.common.runtime.IBackupStatus;
import com.sonicsw.mf.common.runtime.IFaultTolerantState;
import com.sonicsw.mf.common.runtime.INotification;
import com.sonicsw.mf.common.runtime.IStateController;
import com.sonicsw.mf.common.runtime.IStateListener;
import com.sonicsw.mf.common.runtime.IStateManager;
import com.sonicsw.mf.common.runtime.NonRecoverableStateChangeException;
import com.sonicsw.mf.common.runtime.RecoverableStateChangeException;
import com.sonicsw.mf.common.runtime.impl.CanonicalName;
import com.sonicsw.mf.common.security.ConfigurePermissionDeniedException;
import com.sonicsw.mf.common.security.IManagementPermission;
import com.sonicsw.mf.common.util.Container;
import com.sonicsw.mf.common.util.MFLogger;
import com.sonicsw.mf.common.util.ZipUtils;
import com.sonicsw.mf.common.view.IDeltaView;
import com.sonicsw.mf.common.view.INamingListener;
import com.sonicsw.mf.common.view.IView;
import com.sonicsw.mf.framework.AbstractFrameworkComponent;
import com.sonicsw.mf.framework.IContainer;
import com.sonicsw.mf.framework.IFrameworkComponentContext;
import com.sonicsw.mf.framework.IGlobalFrameworkComponent;
import com.sonicsw.mf.framework.agent.ClassLoaderFactory;
import com.sonicsw.mf.framework.agent.ContainerImpl;
import com.sonicsw.mf.framework.agent.JMSConnectorServer;
import com.sonicsw.mf.framework.directory.DirectoryServiceFactory;
import com.sonicsw.mf.framework.directory.DistributedLockManager;
import com.sonicsw.mf.framework.directory.IClassLoaderUtility;
import com.sonicsw.mf.framework.directory.IDebuggingMasks;
import com.sonicsw.mf.framework.directory.IDirectoryService;
import com.sonicsw.mf.framework.directory.IFaultTolerantDS;
import com.sonicsw.mf.framework.directory.IPersistSubscribers;
import com.sonicsw.mf.framework.directory.SharedPermissionChecks;
import com.sonicsw.mf.framework.directory.SizedArrayList;
import com.sonicsw.mf.framework.directory.SubscriptionRegistry;
import com.sonicsw.mf.framework.directory.impl.DiskFileDSHandler;
import com.sonicsw.mf.framework.directory.impl.ExtendedSonicFSFileSystem;
import com.sonicsw.mf.framework.elementversion.IArrayElementNotificationListener;
import com.sonicsw.mf.framework.elementversion.INotificationConsumer;
import com.sonicsw.mf.framework.util.ContainerCompatibility;
import com.sonicsw.mf.framework.util.StateManager;
import com.sonicsw.mf.framework.util.URLUtility;
import com.sonicsw.mf.mgmtapi.config.IActivationDaemonBean;
import com.sonicsw.mf.mgmtapi.config.IContainerBean;
import com.sonicsw.mf.mgmtapi.config.IHostManagerBean;
import com.sonicsw.mf.mgmtapi.config.MFMgmtBeanFactory;
import com.sonicsw.mx.config.impl.Util;
import com.sonicsw.mx.config.util.SonicFSFile;
import com.sonicsw.mx.util.IEmptyArray;
import com.sonicsw.sdf.AbstractMFComponentTracing;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.jms.JMSException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import progress.message.client.api.IUserAlreadyConnected;

public class DSComponent
extends AbstractFrameworkComponent
implements IGlobalFrameworkComponent,
ILogger,
IClassLoaderUtility,
IValidationConstants,
IHandlerConstants,
IDebuggingMasks,
IFaultTolerantDS,
IGlobalComponentListener {
    public static final String GLOBAL_ID = "DIRECTORY SERVICE";
    public static final String READER_ROLE = "READER";
    public static final long SUBSCRIPTION_DURATION = 10800000L;
    private static final String DOMAIN_DESC_TYPE = "MF_AUTHENTICATION_DOMAIN";
    private static final IBasicElement[] EMPTY_ELEMENT_ARRAY = new IBasicElement[0];
    public static final String DS_STARTUP_ELEMENT = "/_MFSystem/dsStartup";
    public static final String DS_RENAMING_ELEMENT = "/_MFSystem/dsRenaming";
    private static IDirElement m_dsStartupElement = null;
    private static String methodsWithErrors = "";
    private static final String[] LEASE_LOCK_SIGNATURE = new String[]{String.class.getName(), String.class.getName(), Integer.class.getName()};
    private static final String[] RELEASE_LOCK_SIGNATURE = new String[]{String.class.getName(), String.class.getName()};
    public static final String CHANGE_NOTIFICATION_TYPE = "Change";
    public static final String FSCHANGE_NOTIFICATION_TYPE = "FSChange";
    public static final String NAMING_NOTIFICATION_TYPE = "Naming";
    public static final String FAILOVER_NOTIFICATION_TYPE = "Failover";
    public static final String REVERT_TO_STANDBY_NOTIFICATION_TYPE = "RevertToStandby";
    public static final String CONFIGURE_PERMISSION_DENIED_NOTIFICATION_TYPE = "ConfigurePermissionDenied";
    public static final String FAULT_TOLERANCE_ROLE_DEFAULT = "";
    public static final String FAULT_TOLERANCE_ROLE_PRIMARY = "PRIMARY";
    public static final String FAULT_TOLERANCE_ROLE_BACKUP = "BACKUP";
    public static final String MF_DIR_SEPARATOR_STRING = new String(new char[]{'/'});
    public static final String MFCONTEXT_ROOT_DIR = "/_MFContext";
    public static final String HIERARCHICAL_TYPES_PATH = "/mx/hierarchicalTypes/";
    private short m_startState;
    private static final short STARTUP_STATE_STARTING = 0;
    private static final short STARTUP_STATE_STARTED = 1;
    private static final short STARTUP_STATE_RESTARTED = 2;
    private static final short STARTUP_STATE_FAILED = 3;
    public static final boolean AUTOMATIC_DUAL_ACTIVE_RESOLUTION_DEFAULT = false;
    public static final boolean BACKUP_FAILOVER_READ_ONLY_DEFAULT = false;
    private static boolean m_startActive;
    private ContainerImpl m_containerImpl;
    private String m_id;
    private String m_hostDir;
    private String m_domainName;
    private String m_encryptionPassword;
    private String m_hostDirDepricated;
    private DSStateHandler m_replicationStateHandler;
    private String m_faultToleranceRole = "";
    private String m_partnerRole = "";
    private String m_FTpartnerAddress;
    private int m_replicationRetryInterval;
    private int m_replicationPingInterval;
    private int m_replicationFailureDetectionTimeout;
    private int m_maxReplicationLogSize;
    private int m_replicationTimeout;
    private boolean m_dualActiveResolution;
    private boolean m_backupFailoverReadOnly;
    private HashMap[] m_replConnections;
    private HashMap m_replSSLParams;
    private String m_uniqunessCallID;
    private boolean m_dsStarted;
    private boolean m_dsStartedAtLeasetOnce = false;
    private IDirectoryService m_ds;
    private Storage m_dsStorage;
    private Thread m_uniquenessCheckThread;
    private boolean m_uniquenessCallReceived;
    private boolean m_responseSent;
    private SubscriptionRegistry m_registry;
    private INotificationConsumer m_consumer;
    private URLClassLoader m_sharedLoader = (URLClassLoader)DSComponent.class.getClassLoader().getParent();
    private DistributedLockManager m_lockManager;
    private IStateManager m_faultToleranceStateManager;
    private boolean m_isNotFaultTolerant;
    private boolean m_isPrimary;
    private boolean m_isBackup;
    private boolean m_allowFailover = true;
    private Object m_shutdownLock = new Object();
    private SdfMFTracingIntegration m_SdfMFTracingIntegration;
    private MFLogger m_pseLogger;
    private Object m_uniquenessCheckLockObj = new Object();
    private static final ArrayList ATTRIBUTE_INFOS;
    private static final ArrayList OPERATION_INFOS;
    private static final ArrayList NOTIFICATION_INFOS;

    public void setContainer(ContainerImpl container) {
        this.m_containerImpl = container;
    }

    public DSComponent() {
        this.clearDSState();
        this.clearDSAccessParameters();
        this.m_SdfMFTracingIntegration = new SdfMFTracingIntegration();
        this.m_SdfMFTracingIntegration.register();
        if (!m_startActive) {
            m_startActive = DSComponent.testStartActive(true);
        }
    }

    private void clearDSAccessParameters() {
        this.m_id = null;
        this.m_hostDir = null;
        this.m_domainName = null;
        this.m_encryptionPassword = null;
        this.m_hostDirDepricated = null;
        this.m_dsStorage = null;
        this.m_replicationStateHandler = null;
    }

    private void clearDSState() {
        this.m_uniquenessCheckThread = null;
        this.m_uniqunessCallID = null;
        this.m_consumer = null;
        this.m_ds = null;
        this.m_uniquenessCallReceived = false;
        this.m_responseSent = false;
        this.m_dsStarted = false;
        this.m_registry = null;
    }

    public String getTraceMaskValues() {
        return super.getTraceMaskValues() + "," + "16=startup,32=updates,64=pass,128=container access,256=configuration notifications,512=validation triggers,1024=all directory service access,2048=fault detection";
    }

    public void setTraceMask(IAttributeSet dsAtts) {
        Integer traceMaskObject = (Integer)dsAtts.getAttribute("TRACE_MASK");
        if (traceMaskObject == null) {
            traceMaskObject = new Integer(0);
        }
        this.setTraceMask(traceMaskObject);
    }

    public void setTraceMask(Integer traceMask) {
        this.setTraceMask(traceMask, false);
    }

    private void setTraceMask(Integer traceMask, boolean fromSDF) {
        if (!fromSDF) {
            if (this.m_SdfMFTracingIntegration.wasUpdated()) {
                return;
            }
            this.m_SdfMFTracingIntegration.setTraceMask(traceMask);
        }
        super.setTraceMask(traceMask);
        if (this.m_ds != null) {
            this.m_ds.setTraceMask(traceMask);
        }
        DSComponent.setReplicationTracing(traceMask);
    }

    IStateManager getFaultToleranceStateManager() {
        return this.m_faultToleranceStateManager;
    }

    IFrameworkComponentContext getContext() {
        return this.m_frameworkContext;
    }

    void sendFTStateChange(boolean failover) {
        if (this.m_context == null) {
            return;
        }
        INotification notification = this.m_context.createNotification((short)0, INotification.SUBCATEGORY_TEXT[0], failover ? FAILOVER_NOTIFICATION_TYPE : REVERT_TO_STANDBY_NOTIFICATION_TYPE, 2);
        notification.setLogType((short)1);
        notification.setAttribute("FaultToleranceRole", (Object)this.m_faultToleranceRole);
        this.m_context.sendNotification(notification);
    }

    public String getFaultToleranceRole() {
        return this.m_faultToleranceRole;
    }

    @Override
    public Short getFaultTolerantState() {
        return new Short(this.m_faultToleranceStateManager.getState(null));
    }

    public String getFaultTolerantStateString() {
        String storageState = null;
        if (this.m_replicationStateHandler != null) {
            storageState = this.m_replicationStateHandler.getStandbyStorageState();
        }
        storageState = storageState != null ? "; " + storageState : FAULT_TOLERANCE_ROLE_DEFAULT;
        return IFaultTolerantState.STATE_TEXT[this.m_faultToleranceStateManager.getState(null)] + storageState;
    }

    public Boolean getAllowFailover() {
        return this.m_isNotFaultTolerant ? null : new Boolean(this.m_allowFailover);
    }

    public void setAllowFailover(Boolean allowFailover) {
        if (this.m_isNotFaultTolerant) {
            throw new IllegalStateException("Setting of this attribute is not supported for a non-fault tolerant Directory Service");
        }
        boolean allow = allowFailover;
        if (allow != this.m_allowFailover) {
            if (this.m_faultToleranceStateManager.getState(null) != 2) {
                this.m_context.logMessage("Failover " + (allow ? "reenabled" : "disabled"), allow ? 3 : 2);
            }
            this.m_allowFailover = allow;
        }
    }

    @Override
    public String getGlobalID() {
        return GLOBAL_ID;
    }

    public MBeanAttributeInfo[] getAttributeInfos() {
        return ATTRIBUTE_INFOS.toArray(IEmptyArray.EMPTY_ATTRIBUTE_INFO_ARRAY);
    }

    public MBeanOperationInfo[] getOperationInfos() {
        return OPERATION_INFOS.toArray(IEmptyArray.EMPTY_OPERATION_INFO_ARRAY);
    }

    public MBeanNotificationInfo[] getNotificationInfos() {
        return NOTIFICATION_INFOS.toArray(IEmptyArray.EMPTY_NOTIFICATION_INFO_ARRAY);
    }

    @Override
    public void init(IComponentContext context) {
        super.init(context);
        this.m_pseLogger = new MFLogger(context, "pse");
        this.readConfiguration(context);
        this.m_FTpartnerAddress = this.getPartnerAddress();
        try {
            if (this.m_isNotFaultTolerant) {
                this.m_container.addGlobalComponentSupport(GLOBAL_ID, null, this);
                this.m_container.addGlobalComponentSupport(GLOBAL_ID, FAULT_TOLERANCE_ROLE_PRIMARY, this);
            } else {
                StringBuffer sb = new StringBuffer();
                sb.append(IContainer.NEWLINE);
                sb.append(IContainer.NEWLINE);
                sb.append('\t');
                sb.append("Fault tolerant role \"").append(this.m_faultToleranceRole).append("\".");
                if (this.m_isBackup) {
                    sb.append(IContainer.NEWLINE);
                    sb.append('\t');
                    sb.append("Start active is ").append(m_startActive ? "enabled." : "disabled.");
                }
                sb.append(IContainer.NEWLINE);
                this.m_context.logMessage(sb.toString(), 4);
                this.m_container.addGlobalComponentSupport(GLOBAL_ID, this.m_faultToleranceRole, this);
            }
        }
        catch (Exception e) {
            String msgPrefix;
            Exception linkedException = null;
            if (e instanceof JMSException) {
                linkedException = ((JMSException)((Object)e)).getLinkedException();
            }
            String string = msgPrefix = this.m_isNotFaultTolerant ? FAULT_TOLERANCE_ROLE_DEFAULT : '[' + this.m_faultToleranceRole + "] ";
            if (linkedException instanceof IUserAlreadyConnected) {
                this.m_context.logMessage(msgPrefix + "Failed communications initialization (probably already running)", 1);
                this.m_container.shutdown(5);
            }
            this.m_context.logMessage(msgPrefix + "Failed communications initialization, trace follows...", (Throwable)e, 1);
            this.m_container.shutdown(9);
        }
        if (this.m_isNotFaultTolerant) {
            this.m_container.setLocalDS(this);
            this.m_faultToleranceStateManager = new StateManager(IFaultTolerantState.STATE_VALUES, 0);
        } else {
            this.m_context.logMessage("Initial state: \"" + IFaultTolerantState.STATE_TEXT[1] + '\"', 3);
            this.m_faultToleranceStateManager = new StateManager(IFaultTolerantState.STATE_VALUES, 1);
            Object controller = null;
            controller = new ToStandbyStateController();
            this.m_faultToleranceStateManager.registerStateController((IStateController)controller, (short)1, (short)3, null);
            this.m_faultToleranceStateManager.registerStateController((IStateController)controller, (short)2, (short)3, null);
            controller = new ToActiveStateController();
            this.m_faultToleranceStateManager.registerStateController((IStateController)controller, (short)1, (short)2, null);
            this.m_faultToleranceStateManager.registerStateController((IStateController)controller, (short)3, (short)2, null);
            this.m_faultToleranceStateManager.registerStateListener((IStateListener)new StateListener(), null);
        }
        this.m_lockManager = new DistributedLockManager(this, this.m_frameworkContext);
        this.makeGlobalComponentUniquenessCall();
    }

    private String getPartnerAddress() {
        StringBuffer partner = new StringBuffer();
        partner.append(this.getContext().getComponentName().getDomainName());
        partner.append('.');
        partner.append(JMSConnectorServer.getPseudoContainerID((String)GLOBAL_ID, (String)this.m_partnerRole));
        partner.append(':').append("ID=");
        partner.append(GLOBAL_ID);
        return partner.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start() {
        if (this.m_state == 3) {
            return;
        }
        if (this.m_isNotFaultTolerant) {
            if (3 == this.startDirectoryService()) {
                this.shutdown(null, new Integer(4));
            }
            this.announceDirectoryServiceIsAvailable(this.m_startState == 2, false);
            super.start();
            this.makeConfigChangeSubscriptions();
        } else {
            try {
                this.openStorageForReplication();
            }
            catch (Throwable t) {
                this.m_startState = (short)3;
                this.shutdown(t.getMessage(), new Integer(4));
            }
            super.start();
            IStateManager iStateManager = this.m_faultToleranceStateManager;
            synchronized (iStateManager) {
                while (this.m_faultToleranceStateManager.getState(null) == 1) {
                    try {
                        this.m_faultToleranceStateManager.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this.m_container.isClosing()) {
                        return;
                    }
                    if (this.m_startState != 3) continue;
                    this.shutdown(null, new Integer(4));
                }
            }
        }
    }

    public synchronized void stop() {
        if (this.m_state == 1) {
            return;
        }
        if (this.m_isNotFaultTolerant) {
            this.stopDirectoryService(false);
        } else {
            this.closeReplicationStateHandler();
            if (this.m_faultToleranceStateManager.getState(null) == 2) {
                this.m_container.removeGlobalComponentSupport(GLOBAL_ID, null);
                this.closeMdsStorage();
            }
        }
        super.stop();
    }

    public void destroy() {
        this.m_container.removeGlobalComponentSupport(GLOBAL_ID, null);
        if (this.m_isNotFaultTolerant) {
            this.m_container.removeGlobalComponentSupport(GLOBAL_ID, FAULT_TOLERANCE_ROLE_PRIMARY);
        } else {
            this.m_container.removeGlobalComponentSupport(GLOBAL_ID, this.m_faultToleranceRole);
            this.closeReplicationStateHandler();
        }
        this.closeMdsStorage();
        this.m_lockManager.cleanup();
        super.destroy();
    }

    private void closeMdsStorage() {
        this.stopDirectoryService(false);
        if (this.m_dsStorage != null) {
            this.m_dsStorage.close();
        }
        this.m_dsStorage = null;
    }

    private void closeReplicationStateHandler() {
        if (this.m_replicationStateHandler != null) {
            this.m_replicationStateHandler.close();
        }
    }

    private short startDirectoryService() {
        this.m_startState = 0;
        boolean restarted = this.m_dsStartedAtLeasetOnce;
        try {
            Hashtable<String, Object> directoryEnv = new Hashtable<String, Object>();
            directoryEnv.put("STORAGE_TYPE_ATTRIBUTE", "PSE_STORAGE");
            if (this.m_hostDirDepricated != null) {
                directoryEnv.put("FS_HOST_DIRECTORY_ATTRIBUTE", this.m_hostDirDepricated);
            }
            if (this.m_hostDir != null) {
                directoryEnv.put("HOST_DIRECTORY_ATTRIBUTE", this.m_hostDir);
            }
            if (this.m_encryptionPassword != null && this.m_encryptionPassword.length() != 0) {
                directoryEnv.put("PASSWORD", this.m_encryptionPassword);
            }
            if (this.m_isBackup && this.m_backupFailoverReadOnly) {
                directoryEnv.put("IS_RESTRICTED_BACKUP", Boolean.TRUE);
            }
            DirectoryServiceFactory factory = new DirectoryServiceFactory(directoryEnv);
            IFrameworkComponentContext context = (IFrameworkComponentContext)this.m_context;
            this.m_ds = factory.createDirectoryServiceInContainer(this.m_domainName, context, this, context);
            this.m_registry = new SubscriptionRegistry(10800000L, (IPersistSubscribers)((Object)this.m_ds));
            this.m_consumer = this.m_ds.subscribeAll(new DSListener());
            this.m_ds.subscribeNaming(new DSNamingListener());
            this.readHierarchicalTypes();
        }
        catch (Exception e) {
            this.m_context.logMessage("Directory Service failure, trace follows...", (Throwable)e, 1);
            this.m_startState = (short)3;
            return this.m_startState;
        }
        this.setTraceMask(super.getTraceMask());
        this.m_dsStarted = true;
        this.m_dsStartedAtLeasetOnce = true;
        this.m_startState = (short)(restarted ? 2 : 1);
        return this.m_startState;
    }

    private void readHierarchicalTypes() throws DirectoryServiceException {
        HashMap<String, String> hierarchicalTypes = new HashMap<String, String>();
        IDirIdentity[] dirs = this.m_ds.listDirectories(HIERARCHICAL_TYPES_PATH);
        for (int i = 0; i < dirs.length; ++i) {
            IDirElement[] types = this.m_ds.getAllElements(dirs[i].getName(), false);
            for (int j = 0; j < types.length; ++j) {
                IDirElement type = types[j];
                String elName = type.getIdentity().getName();
                hierarchicalTypes.put(elName, elName);
            }
        }
        this.m_ds.setHierarchicalTypes(hierarchicalTypes);
    }

    private void stopDirectoryService(boolean force) {
        if (!this.m_dsStarted) {
            return;
        }
        if (this.m_uniquenessCheckThread != null) {
            this.m_uniquenessCheckThread.interrupt();
        }
        this.m_dsStarted = false;
        this.m_consumer.close();
        try {
            this.m_registry.close();
            if (force) {
                this.m_ds.close(false);
            } else {
                this.m_ds.close();
            }
        }
        catch (Exception e) {
            throw this.createMFRuntimeException(e);
        }
        this.clearDSState();
    }

    private void readConfiguration(IComponentContext context) {
        IAttributeSet fsStorage;
        IElement dsElement = context.getConfiguration(true);
        this.m_id = dsElement.getIdentity().getName();
        IAttributeSet dsAttributes = dsElement.getAttributes();
        this.m_hostDir = (String)dsAttributes.getAttribute("HOST_DIRECTORY");
        if (dsElement.getIdentity().getType().equals("MF_BACKUP_DIRECTORY_SERVICE")) {
            this.m_faultToleranceRole = FAULT_TOLERANCE_ROLE_BACKUP;
            IAttributeSet references = (IAttributeSet)dsAttributes.getAttribute("CONFIG_ELEMENT_REFERENCES");
            if (references == null) {
                throw new MFRuntimeException("Backup DS configuration " + this.m_id + " does not reference a primary configuration");
            }
            Reference primaryRef = (Reference)references.getAttribute("PRIMARY_CONFIG_ELEMENT_REF");
            if (primaryRef == null) {
                throw new MFRuntimeException("Backup DS configuration " + this.m_id + " does not reference a primary configuration");
            }
            IElement primaryEl = context.getConfiguration(primaryRef.getElementName(), true);
            dsAttributes = primaryEl.getAttributes();
        }
        this.m_domainName = (String)dsAttributes.getAttribute("DOMAIN_NAME");
        if (this.m_domainName == null) {
            this.m_domainName = "Domain1";
        }
        if ((fsStorage = (IAttributeSet)dsAttributes.getAttribute("FILE_SYSTEM_STORAGE")) != null) {
            this.m_hostDirDepricated = (String)fsStorage.getAttribute("HOST_DIRECTORY");
            this.m_encryptionPassword = (String)fsStorage.getAttribute("PASSWORD");
        }
        if (this.m_hostDir == null && this.m_hostDirDepricated == null) {
            this.m_hostDir = ".";
        }
        this.readReplicationParameters(dsAttributes, context);
        this.m_isNotFaultTolerant = this.m_faultToleranceRole.equals(FAULT_TOLERANCE_ROLE_DEFAULT);
        this.m_isPrimary = this.m_faultToleranceRole.equals(FAULT_TOLERANCE_ROLE_PRIMARY);
        this.m_isBackup = this.m_faultToleranceRole.equals(FAULT_TOLERANCE_ROLE_BACKUP);
        String string = this.m_partnerRole = this.m_isPrimary ? FAULT_TOLERANCE_ROLE_BACKUP : FAULT_TOLERANCE_ROLE_PRIMARY;
        if (!this.m_isNotFaultTolerant) {
            boolean primaryAccordingBootFile;
            boolean bacupAccordingBootFile = System.getProperty("sonicsw.mf.ds.backup") != null;
            boolean bl = primaryAccordingBootFile = System.getProperty("sonicsw.mf.ds.primary") != null;
            if (!bacupAccordingBootFile && !primaryAccordingBootFile) {
                String errorMsg = "Mismatch between the boot files and the configuration: According to the boot files this container does not host the Directory Service or the Directory Service is not Fault Tolerant.";
                this.shutdown(errorMsg, new Integer(4));
            } else if (bacupAccordingBootFile != this.m_isBackup) {
                String errorMsg = "Mismatch between the Directory Service boot file and the configuration: The fault tolerance role of the Directory Service according to the boot file is " + (bacupAccordingBootFile ? FAULT_TOLERANCE_ROLE_BACKUP : FAULT_TOLERANCE_ROLE_PRIMARY);
                this.shutdown(errorMsg, new Integer(4));
            }
        }
    }

    private void readReplicationParameters(IAttributeSet dsAttributes, IComponentContext context) {
        Reference replConnectionsRef;
        IAttributeSet references;
        IAttributeSet tmpSet;
        IAttributeSet replParams = (IAttributeSet)dsAttributes.getAttribute("REPLICATION_PARAMETERS");
        if (replParams == null) {
            IDirElement tmpEl = ElementFactory.createElement((String)"/tmp", (String)"tmp", (String)"tmp");
            IAttributeSet tmpPrimaryAtts = tmpEl.getAttributes();
            try {
                replParams = tmpPrimaryAtts.createAttributeSet("REPLICATION_PARAMETERS");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Object tmp = null;
        tmp = replParams.getAttribute("RETRY_INTERVAL");
        this.m_replicationRetryInterval = tmp == null ? 180 : (Integer)tmp;
        tmp = replParams.getAttribute("PING_INTERVAL");
        this.m_replicationPingInterval = tmp == null ? 30 : (Integer)tmp;
        tmp = replParams.getAttribute("FAILURE_DETECTION_TIMEOUT");
        this.m_replicationFailureDetectionTimeout = tmp == null ? 0 : (Integer)tmp;
        tmp = replParams.getAttribute("MAX_REPLICATION_LOG_SIZE");
        this.m_maxReplicationLogSize = tmp == null ? 80 : (Integer)tmp;
        tmp = replParams.getAttribute("REPLICATION_TIMEOUT");
        this.m_replicationTimeout = tmp == null ? -1 : (Integer)tmp;
        tmp = replParams.getAttribute("DUAL_ACTIVE_RESOLUTION");
        this.m_dualActiveResolution = tmp == null ? false : (Boolean)tmp;
        tmp = replParams.getAttribute("BACKUP_FAILOVER_READ_ONLY");
        boolean bl = this.m_backupFailoverReadOnly = tmp == null ? false : (Boolean)tmp;
        if (this.m_backupFailoverReadOnly) {
            this.m_dualActiveResolution = true;
        }
        if ((tmpSet = (IAttributeSet)replParams.getAttribute("SSL_PARAMETERS")) != null) {
            this.m_replSSLParams = (HashMap)tmpSet.getAttributes().clone();
        }
        if ((references = (IAttributeSet)dsAttributes.getAttribute("CONFIG_ELEMENT_REFERENCES")) != null && (replConnectionsRef = (Reference)references.getAttribute("REPLICATION_CONNECTIONS_ELEMENT_REF")) != null) {
            IAttributeSet connectionsSet;
            IElement replConnectionsEl;
            if (this.m_faultToleranceRole.equals(FAULT_TOLERANCE_ROLE_DEFAULT)) {
                this.m_faultToleranceRole = FAULT_TOLERANCE_ROLE_PRIMARY;
            }
            if ((replConnectionsEl = context.getConfiguration(replConnectionsRef.getElementName(), true)) != null && (connectionsSet = (IAttributeSet)replConnectionsEl.getAttributes().getAttribute("REPLICATION_CONNECTIONS")) != null) {
                HashMap connectionsMap = connectionsSet.getAttributes();
                Collection connCol = connectionsMap.values();
                Iterator connIt = connCol.iterator();
                this.m_replConnections = new HashMap[connCol.size()];
                int replConnIndex = 0;
                while (connIt.hasNext()) {
                    IAttributeSet connectionInfo = (IAttributeSet)connIt.next();
                    HashMap<String, Object> connectionMap = new HashMap<String, Object>();
                    Object value = connectionInfo.getAttribute("PROTOCOL");
                    if (value == null) {
                        value = "TCP";
                    }
                    connectionMap.put("PROTOCOL", value);
                    value = connectionInfo.getAttribute("PRIMARY_ADDR");
                    if (value != null) {
                        connectionMap.put("PRIMARY_ADDR", value);
                    }
                    if ((value = connectionInfo.getAttribute("PRIMARY_PORT")) == null) {
                        value = new Integer(22516);
                    }
                    connectionMap.put("PRIMARY_PORT", value);
                    value = connectionInfo.getAttribute("BACKUP_ADDR");
                    if (value != null) {
                        connectionMap.put("BACKUP_ADDR", value);
                    }
                    if ((value = connectionInfo.getAttribute("BACKUP_PORT")) == null) {
                        value = new Integer(22516);
                    }
                    connectionMap.put("BACKUP_PORT", value);
                    value = connectionInfo.getAttribute("WEIGHT");
                    if (value == null) {
                        value = new Integer(1);
                    }
                    connectionMap.put("WEIGHT", value);
                    this.m_replConnections[replConnIndex++] = connectionMap;
                }
            }
        }
    }

    public synchronized void handleElementChange(IElementChange elementChange) {
        String elementType = elementChange.getElement().getIdentity().getType();
        String elementName = elementChange.getElement().getIdentity().getName();
        if (elementType.equals("MF_BACKUP_DIRECTORY_SERVICE") || elementType.equals("MF_DIRECTORY_SERVICE") || elementType.equals("MF_REPLICATION_CONNECTION")) {
            this.m_containerImpl.generateDSBootFile(this.m_id);
        }
        if (elementType.equals("MF_DIRECTORY_SERVICE")) {
            try {
                Reference replRef;
                IDirElement DSEl = this.getElement(elementName, Boolean.FALSE);
                IAttributeSet refs = (IAttributeSet)DSEl.getAttributes().getAttribute("CONFIG_ELEMENT_REFERENCES");
                if (refs != null && (replRef = (Reference)refs.getAttribute("REPLICATION_CONNECTIONS_ELEMENT_REF")) != null) {
                    this.getContext().getConfiguration(replRef.getElementName(), true);
                }
            }
            catch (MFException mfE) {
                this.logMessage("Unable to check for the existance of a replication connection element while handling element change, trace follows...", mfE, 2);
            }
        }
        try {
            this.validateStarted();
            this.validateActive();
        }
        catch (DSNotStartedException e) {
            return;
        }
        catch (MFServiceNotActiveException e) {
            return;
        }
        if (elementName.equals(this.m_id)) {
            IElement dsElement = this.m_context.getConfiguration(elementName, true);
            this.setTraceMask(dsElement.getAttributes());
            return;
        }
        if (this.m_ds == null) {
            return;
        }
        if (elementType.equals("MF_VALIDATOR")) {
            this.m_context.logMessage("Load validation information from /_MFLibrary/validators.", 3);
            this.m_ds.newTriggerValidator();
        } else if (elementType.equals("MF_DS_HANDLER")) {
            this.m_context.logMessage("Load Directory Service handler information from /_MFLibrary/ds_handlers.", 3);
            this.m_ds.newDSHandlers();
        } else if (elementType.equals(DOMAIN_DESC_TYPE)) {
            if (elementChange.getChangeType() == 2) {
                return;
            }
            this.m_ds.newAuthenticationDescriptor(this.m_context.getConfiguration(elementName, true));
        }
    }

    private void makeGlobalComponentUniquenessCall() {
        String localHost = null;
        try {
            localHost = InetAddress.getLocalHost().toString();
        }
        catch (Exception e) {
            localHost = e.toString();
        }
        StringBuffer sb = new StringBuffer();
        sb.append(localHost);
        sb.append('|');
        try {
            sb.append(new File(this.m_hostDir == null ? this.m_hostDirDepricated : this.m_hostDir, this.m_context.getComponentName().getDomainName()).getCanonicalPath());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!this.m_isNotFaultTolerant) {
            sb.append('|');
            sb.append(this.m_faultToleranceRole);
        }
        this.m_uniqunessCallID = sb.toString();
        this.m_uniquenessCheckThread = new Thread("DIRECTORY SERVICE - Uniqueness Checker"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!DSComponent.this.m_uniquenessCallReceived) {
                    try {
                        DSComponent.this.m_frameworkContext.makeGlobalComponentUniquenessCall(DSComponent.GLOBAL_ID, DSComponent.this.m_uniqunessCallID);
                        if (!DSComponent.this.m_isNotFaultTolerant) {
                            DSComponent.this.m_frameworkContext.makeGlobalComponentUniquenessCall(DSComponent.GLOBAL_ID, DSComponent.this.m_uniqunessCallID, DSComponent.this.m_faultToleranceRole);
                        }
                    }
                    catch (Exception e) {
                        throw DSComponent.this.createMFRuntimeException(e);
                    }
                    if (DSComponent.this.m_uniquenessCallReceived) {
                        return;
                    }
                    try {
                        Object object = DSComponent.this.m_uniquenessCheckLockObj;
                        synchronized (object) {
                            DSComponent.this.m_uniquenessCheckLockObj.wait(3000L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        };
        this.m_uniquenessCheckThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uniquenessCheck(String containerID, String responderID) {
        String thisContainerName = this.m_frameworkContext.getContainer().getContainerIdentity().getCanonicalName();
        Object object = this.m_uniquenessCheckLockObj;
        synchronized (object) {
            this.m_uniquenessCallReceived = true;
            this.m_uniquenessCheckLockObj.notifyAll();
        }
        if (this.m_responseSent) {
            return;
        }
        StringTokenizer st = new StringTokenizer(responderID, "|");
        boolean isFaultTolerantResponder = st.countTokens() == 3;
        StringBuffer errorMessage = new StringBuffer();
        if (this.m_isNotFaultTolerant) {
            if (isFaultTolerantResponder) {
                errorMessage.append("Domain has both fault tolerant and non-fault tolerant Directory Service instances");
            } else if (!containerID.equals(thisContainerName)) {
                errorMessage.append("Domain has two active Directory Service instances");
            }
        } else if (isFaultTolerantResponder) {
            if (!containerID.equals(thisContainerName)) {
                st.nextToken();
                st.nextToken();
                String responderRole = st.nextToken();
                if (responderRole.equals(this.m_faultToleranceRole)) {
                    errorMessage.append("Domain has two " + responderRole + " Directory Service instances");
                }
            }
        } else {
            errorMessage.append("Domain has both fault tolerant and non-fault tolerant Directory Service instances");
        }
        if (errorMessage.length() > 0) {
            try {
                this.m_frameworkContext.makeGlobalComponentUniquenessCall(GLOBAL_ID, this.m_uniqunessCallID);
                this.m_responseSent = true;
                Thread.sleep(3000L);
            }
            catch (Exception e) {
                throw this.createMFRuntimeException(e);
            }
            errorMessage.append(" (this container will be shutdown to allow configuration resolution):");
            errorMessage.append(IContainer.NEWLINE).append(IContainer.NEWLINE).append('\t');
            errorMessage.append("One is in container      : ").append(thisContainerName);
            errorMessage.append(IContainer.NEWLINE).append('\t');
            errorMessage.append("The other is in container: ").append(containerID);
            errorMessage.append(IContainer.NEWLINE);
            this.shutdown(errorMessage.toString(), new Integer(5));
        }
    }

    public void shutdown(String errorMessage, Integer exitCode) {
        this.shutdown(errorMessage, null, exitCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown(String errorMessage, Throwable e, Integer exitCode) {
        Object object = this.m_shutdownLock;
        synchronized (object) {
            if (this.m_container.isClosing()) {
                return;
            }
            if (errorMessage != null && this.m_context != null) {
                if (e == null) {
                    this.m_context.logMessage(errorMessage, 1);
                } else {
                    this.m_context.logMessage(errorMessage, e, 1);
                }
            }
            this.m_container.shutdown(exitCode);
        }
    }

    private void announceDirectoryServiceIsAvailable(final boolean isRestart, boolean isGlobalAnnouncement) {
        String[] tmp = null;
        if (isGlobalAnnouncement) {
            try {
                IDirElement[] elements = this.m_ds.getAllElements("/containers", false);
                ArrayList<String> containers = new ArrayList<String>();
                for (int i = 0; i < elements.length; ++i) {
                    IAttributeSet attrs = elements[i].getAttributes();
                    String containerName = (String)attrs.getAttribute("CONTAINER_NAME");
                    containers.add(this.m_domainName + '.' + containerName);
                }
                tmp = containers.toArray(IEmptyArray.EMPTY_STRING_ARRAY);
            }
            catch (MFException e) {
                this.shutdown(e.getMessage(), new Integer(4));
            }
        } else {
            try {
                tmp = ((IPersistSubscribers)((Object)this.m_ds)).getCollectionSubscribers();
            }
            catch (DirectoryServiceException e) {
                this.shutdown(e.getMessage(), new Integer(4));
            }
        }
        final String[] subscribers = tmp;
        Runnable announcer = new Runnable(){

            @Override
            public void run() {
                DSComponent.this.waitForContainerBoot();
                if (DSComponent.this.m_container.isClosing()) {
                    return;
                }
                boolean debugNotifications = (DSComponent.this.m_traceMask & 0x100) > 0;
                DSComponent.this.sendChangedElement((IBasicElement)m_dsStartupElement, subscribers, isRestart, debugNotifications);
            }
        };
        this.m_frameworkContext.scheduleTask(announcer, new Date(System.currentTimeMillis()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForContainerBoot() {
        IContainer iContainer = this.m_container;
        synchronized (iContainer) {
            try {
                while (!this.m_container.isBooted() && !this.m_container.isClosing()) {
                    this.m_container.wait(1000L);
                }
            }
            catch (InterruptedException ie) {
                return;
            }
        }
    }

    private void makeConfigChangeSubscriptions() {
        try {
            this.m_context.getConfigurations("/_MFLibrary/validators", true);
            this.m_context.getConfigurations("/_MFLibrary/ds_handlers", true);
        }
        catch (Exception e) {
            this.m_context.logMessage(e.toString() + ":  Configuration validation will not be performed.", 3);
        }
        try {
            String[] descriptors = this.m_ds.getExternalDomainsDescriptors();
            boolean[] acceptIndicators = new boolean[descriptors.length];
            for (int i = 0; i < descriptors.length; ++i) {
                acceptIndicators[i] = true;
            }
            this.m_context.getConfigurations(descriptors, acceptIndicators);
        }
        catch (Exception e) {
            this.m_context.logMessage(e.toString() + ":  on-the-fly modifications of external authentication connection parameters is not supported.", 3);
        }
    }

    public void sendChangedElement(IBasicElement element, String target, boolean tellThisContainerDSstarted, boolean doDebug) {
        block4: {
            try {
                if (this.m_ds.areNotificationsSuspended(target)) {
                    this.trace(256, "Notifications suspended for \"" + target + "\"; will not notify it about \"" + element.getIdentity().getName() + "\" modification");
                    return;
                }
                CanonicalName cName = new CanonicalName(target);
                CanonicalName remoteAgentName = new CanonicalName(cName.getDomainName(), cName.getContainerName(), "AGENT");
                this.m_frameworkContext.invoke(remoteAgentName.getCanonicalName(), "receiveChangedElement", new Object[]{element}, new String[]{IBasicElement.class.getName()}, false, 0L);
                if ((this.m_traceMask & 1) > 0) {
                    this.trace(256, "Notified \"" + target + "\" about \"" + element.getIdentity().getName() + "\" modification");
                }
            }
            catch (Throwable t) {
                if (!doDebug) break block4;
                this.m_context.logMessage("Failed to send configuration change to container " + target + ", trace follows...", t, 7);
            }
        }
    }

    public void sendChangedElements(IBasicElement[] elements, String target, boolean tellThisContainerDSstarted, boolean doDebug) {
        block6: {
            try {
                if (this.m_ds.areNotificationsSuspended(target)) {
                    if ((this.m_traceMask & 0x100) > 0) {
                        for (int i = 0; i < elements.length; ++i) {
                            this.trace(256, "Notifications suspended for \"" + target + "\"; will not notify it about \"" + elements[i].getIdentity().getName() + "\" modification");
                        }
                    }
                    return;
                }
                CanonicalName cName = new CanonicalName(target);
                CanonicalName remoteAgentName = new CanonicalName(cName.getDomainName(), cName.getContainerName(), "AGENT");
                this.m_frameworkContext.invoke(remoteAgentName.getCanonicalName(), "receiveChangedElements", new Object[]{elements}, new String[]{IBasicElement[].class.getName()}, false, 0L);
                if ((this.m_traceMask & 1) > 0) {
                    this.trace(256, "Notified \"" + target + "\" about \"" + elements.length + "\" modifications");
                }
            }
            catch (Throwable t) {
                if (!doDebug) break block6;
                this.m_context.logMessage("Failed to send configurations change to container " + target + ", trace follows...", t, 7);
            }
        }
    }

    public void sendChangedElements(IDirElement[] elements, String target, boolean doDebug) {
        block6: {
            try {
                if (this.m_ds.areNotificationsSuspended(target)) {
                    if ((this.m_traceMask & 0x100) > 0) {
                        for (int i = 0; i < elements.length; ++i) {
                            this.trace(256, "Notifications suspended for \"" + target + "\"; will not notify it about \"" + elements[i].getIdentity().getName() + "\" modification");
                        }
                    }
                    return;
                }
                CanonicalName cName = new CanonicalName(target);
                CanonicalName remoteAgentName = new CanonicalName(cName.getDomainName(), cName.getContainerName(), "AGENT");
                this.m_frameworkContext.invoke(remoteAgentName.getCanonicalName(), "receiveChangedElements", new Object[]{elements}, new String[]{elements.getClass().getName()}, false, 0L);
                if ((this.m_traceMask & 1) > 0) {
                    this.trace(256, "Notified \"" + target + "\" about \"" + elements.length + "\" modifications");
                }
            }
            catch (Throwable t) {
                if (!doDebug) break block6;
                this.m_context.logMessage("Failed to send configurations change to container " + target + ", trace follows...", t, 7);
            }
        }
    }

    public void sendChangedElement(final IBasicElement element, final String[] targets, final boolean tellThisContainerDSstarted, final boolean doDebug) {
        Runnable invoker = new Runnable(){

            @Override
            public void run() {
                try {
                    for (int i = 0; i < targets.length; ++i) {
                        DSComponent.this.sendChangedElement(element, targets[i], tellThisContainerDSstarted, doDebug);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.m_context.scheduleTask(invoker, new Date());
    }

    public String getDomain() throws MFException {
        this.validateStarted();
        return this.m_ds.getDomain();
    }

    public HashMap getStorageToLogicalMap() throws MFException {
        this.validateStarted();
        HashMap map = this.m_ds.getStorageToLogicalMap();
        this.configurePermissionReadCheck(MF_DIR_SEPARATOR_STRING, null, false);
        return map;
    }

    public IDirElement[] getElements(String subscriber, String[] elementNames) throws MFException {
        this.trace(128, subscriber + ": getElements - ");
        this.traceData(elementNames, 128);
        this.validateStarted();
        this.validateActive();
        this.m_registry.subscribe(subscriber, elementNames);
        FromElementList f = new FromElementList(elementNames);
        Query q = new Query().setFrom((From)f);
        return this.m_ds.getElements(q, false);
    }

    public IElement[] getCreateContainerConfiguration(String containerPath, String activationPath, String hostManagerPath, Hashtable defaultContainerParams, Hashtable defaultConnectionParams) throws MFException {
        this.validateStarted();
        this.validateActive();
        IDirElement containerConfig = (IDirElement)this.m_ds.getElementByLogicalName(containerPath);
        if (containerConfig != null) {
            this.configurePermissionReadCheck(containerPath, containerConfig.getIdentity().getName(), true);
        }
        if (containerConfig == null) {
            String activationName = null;
            String hostManagerName = null;
            try {
                if (activationPath != null) {
                    activationName = new EntityName(activationPath).getBaseName();
                }
                if (hostManagerPath != null) {
                    hostManagerName = new EntityName(hostManagerPath).getBaseName();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.createContainerWithADandHM(containerPath, activationPath, activationName, hostManagerPath, hostManagerName);
                String containerStorageName = this.m_ds.logicalToStorage(containerPath);
                containerConfig = this.m_ds.getElement(containerStorageName, true);
                IDeltaDirElement delta = Container.initializeNewContainer((IDirElement)containerConfig, (Hashtable)defaultContainerParams, (Hashtable)defaultConnectionParams);
                this.m_ds.setElement((IBasicElement)delta, null);
            }
            catch (ConfigurePermissionDeniedException denied) {
                throw denied;
            }
            catch (Exception e) {
                if (e instanceof MFException) {
                    throw (MFException)((Object)e);
                }
                throw new MFException(e.toString());
            }
            containerConfig = (IDirElement)this.m_ds.getElementByLogicalName(containerPath);
        }
        IElement[] retConfigurations = new IElement[]{containerConfig};
        return retConfigurations;
    }

    public IElement getElementByLogicalName(String subscriber, String logicalName) throws MFException {
        this.trace(128, subscriber + ": getElementByLogicalName - " + logicalName);
        return this.getElementByLogicalNameInternal(subscriber, logicalName);
    }

    public IElement[] getElementsByLogicalNames(String subscriber, String[] logicalNames) throws MFException {
        this.trace(128, subscriber + ": getElementsByLogicalNames");
        return this.getElementsByLogicalNamesInternal(subscriber, logicalNames);
    }

    public IDirElement[] getElementIfUpdated(Long callerBackupVersion, String elementName, IElementIdentity id) throws MFException {
        this.trace(128, "getElementIfUpdated");
        try {
            IDirElement[] eArray = this.m_ds.getElementIfUpdated(callerBackupVersion, elementName, id);
            this.configurePermissionReadCheckWithLogicalName(elementName);
            return eArray;
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            System.out.println("m_ds=" + this.m_ds);
            System.out.println("callerBackupVersion=" + callerBackupVersion);
            System.out.println("elementName=" + elementName);
            System.out.println("id=" + id);
            throw e;
        }
    }

    public IElement[] getElementsByLogicalNames(String[] logicalNames) throws MFException {
        this.trace(128, "getElementsByLogicalNames");
        return this.getElementsByLogicalNamesInternal(null, logicalNames);
    }

    private IElement[] getElementsByLogicalNamesInternal(String subscriber, String[] logicalNames) throws MFException {
        this.validateStarted();
        this.validateActive();
        IElement[] elements = this.m_ds.getElementsByLogicalNames(logicalNames);
        if (subscriber == null) {
            ArrayList<IElement> returnElements = new ArrayList<IElement>();
            for (int i = 0; i < elements.length; ++i) {
                try {
                    if (elements[i] == null) continue;
                    String storageName = elements[i].getIdentity().getName();
                    this.configurePermissionReadCheck(storageName, storageName, true);
                    returnElements.add(elements[i]);
                    continue;
                }
                catch (ConfigurePermissionDeniedException denied) {
                    // empty catch block
                }
            }
            IElement[] prunedArray = new IElement[returnElements.size()];
            returnElements.toArray(prunedArray);
            return prunedArray;
        }
        for (int i = 0; i < elements.length; ++i) {
            if (elements[i] == null) continue;
            this.m_registry.subscribe(subscriber, elements[i].getIdentity().getName());
            this.m_registry.addLogicalSubscriber(logicalNames[i], subscriber);
        }
        return elements;
    }

    public void registerInterestInChanges(String subscriber, String logicalName) throws MFException {
        this.trace(128, subscriber + ": registerInterestInChanges for " + logicalName);
        this.getElementByLogicalNameInternal(subscriber, logicalName);
    }

    private IElement getElementByLogicalNameInternal(String subscriber, String logicalName) throws MFException {
        this.validateStarted();
        this.validateActive();
        IElement element = this.m_ds.getElementByLogicalName(logicalName);
        if (element == null) {
            return null;
        }
        String archiveName = this.getArchiveName(element);
        this.m_registry.subscribe(subscriber, element.getIdentity().getName());
        if (archiveName != null) {
            this.m_registry.addLogicalSubscriber(archiveName, subscriber);
        } else {
            this.m_registry.addLogicalSubscriber(logicalName, subscriber);
        }
        return element;
    }

    private String getArchiveName(IElement el) {
        String archiveName = null;
        IAttributeSet topSet = el.getAttributes();
        IAttributeSet systemAttrs = (IAttributeSet)topSet.getAttribute("_MF_SYSTEM_ATTRIBUTES");
        if (systemAttrs != null) {
            archiveName = (String)systemAttrs.getAttribute("ARCHIVE_NAME");
        }
        return archiveName;
    }

    public IBlob getBlobByLogicalName(String logicalName) throws MFException {
        this.trace(128, "getBlobByLogicalName - " + logicalName);
        this.validateStarted();
        this.validateActive();
        IBlob blob = this.m_ds.getBlobByLogicalName(logicalName);
        if (blob != null) {
            this.configurePermissionReadCheck(logicalName, blob.getElement().getIdentity().getName(), true);
        }
        return blob;
    }

    public IBlob getBlobByLogicalName(String subscriber, String logicalName) throws MFException {
        this.trace(128, subscriber + ": getBlobByLogicalName - " + logicalName);
        if (this.m_ds.isHandlerPath(logicalName)) {
            return this.m_ds.getBlobByLogicalName(logicalName);
        }
        IElement element = this.getElementByLogicalNameInternal(subscriber, logicalName);
        if (element == null) {
            return null;
        }
        String archiveName = this.getArchiveName(element);
        IBlob blob = this.getBlob(element.getIdentity().getName(), Boolean.FALSE);
        element = blob.getElement();
        if (archiveName != null) {
            try {
                Blob.markBlobState((Element)((Element)element), (Object)archiveName, (String)"ARCHIVE_NAME");
            }
            catch (Exception e) {
                throw new MFException(e.toString());
            }
        }
        return blob;
    }

    public IDirElement getElement(String subscriber, String elementName) throws MFException {
        this.trace(128, subscriber + ": getElement - " + elementName);
        this.validateStarted();
        this.validateActive();
        this.m_registry.subscribe(subscriber, elementName);
        return this.m_ds.getElement(elementName, false);
    }

    public IDirElement getElement(String elementName, Boolean forUpdate) throws MFException {
        this.validateStarted();
        this.validateActive();
        IDirElement el = this.m_ds.getElement(elementName, forUpdate);
        return this.doReadPermissionsCheck(el, elementName);
    }

    public String logicalToStorage(String path) throws MFException {
        this.validateStarted();
        this.validateActive();
        String storage = this.m_ds.logicalToStorage(path);
        this.configurePermissionReadCheck(path, storage, true);
        return storage;
    }

    public String storageToLogical(String storageName) throws MFException {
        this.validateStarted();
        this.validateActive();
        String logical = this.m_ds.storageToLogical(storageName);
        if (logical != null) {
            try {
                this.checkAndConfigurePermissionReadCheck(logical, storageName);
            }
            catch (ConfigException configE) {
                throw new DirectoryServiceException("Unable to check permissions in storageToLogical for " + storageName);
            }
        } else {
            this.configurePermissionReadCheck(MF_DIR_SEPARATOR_STRING, storageName, false);
        }
        return logical;
    }

    public IDirElement getElement(String elementName, Boolean forUpdate, Boolean getSubclassingDelta) throws MFException {
        this.validateStarted();
        this.validateActive();
        IDirElement el = this.m_ds.getElement(elementName, forUpdate, getSubclassingDelta);
        return this.doReadPermissionsCheck(el, elementName);
    }

    private IDirElement doReadPermissionsCheck(IDirElement el, String elementName) throws DirectoryServiceException {
        String logicalName = this.m_ds.storageToLogical(elementName);
        if (logicalName != null) {
            this.configurePermissionReadCheck(logicalName, elementName, true);
        } else if (!elementName.startsWith("/mx/configTypes/")) {
            this.configurePermissionReadCheck(MF_DIR_SEPARATOR_STRING, elementName, false);
        }
        return el;
    }

    public IDirElement[] getElements(Query query, Boolean forUpdate) throws MFException {
        this.validateStarted();
        this.validateActive();
        IDirElement[] elements = this.m_ds.getElements(query, forUpdate);
        return this.checckAllowRead(elements);
    }

    public IDirElement[] getElements(Query query, Boolean forUpdate, Boolean getSubclassingDelta) throws MFException {
        this.validateStarted();
        this.validateActive();
        IDirElement[] elements = this.m_ds.getElements(query, forUpdate, getSubclassingDelta);
        return this.checckAllowRead(elements);
    }

    public IBlob getBlob(String subscriber, String elementName) throws MFException {
        this.trace(128, subscriber + ": getBlob - " + elementName);
        this.validateStarted();
        this.validateActive();
        this.m_registry.subscribe(subscriber, elementName);
        return this.m_ds.getBlob(elementName, false);
    }

    public IBlob getBlob(String elementName, Boolean forUpdate) throws MFException {
        return this.getBlob(elementName, forUpdate, new Integer(0));
    }

    public IBlob getBlob(String elementName, Boolean forUpdate, Integer offset) throws MFException {
        this.validateStarted();
        this.validateActive();
        IBlob blob = null;
        try {
            blob = this.m_ds.getBlob(elementName, forUpdate, offset);
        }
        catch (MFException mfE) {
            throw mfE;
        }
        catch (Exception e) {
            throw new MFException(e.toString());
        }
        this.configurePermissionReadCheckWithLogicalName(elementName);
        return blob;
    }

    public IIdentity getIdentity(String name) throws MFException {
        this.validateStarted();
        this.validateActive();
        IIdentity id = this.m_ds.getIdentity(name);
        String logicalName = this.retrieveLogicalNameFromStorage(name);
        if (logicalName != null) {
            try {
                this.checkAndConfigurePermissionReadCheck(logicalName, name);
            }
            catch (ConfigException configE) {
                throw new DirectoryServiceException("Unable to check permissions in getIdentity for " + name);
            }
        } else {
            this.configurePermissionReadCheck(MF_DIR_SEPARATOR_STRING, name, false);
        }
        return id;
    }

    public IIdentity lookupIdentity(String name) throws MFException {
        this.validateStarted();
        this.validateActive();
        IIdentity id = this.m_ds.lookupIdentity(name);
        String logicalName = this.retrieveLogicalNameFromStorage(name);
        if (logicalName != null) {
            try {
                this.checkAndConfigurePermissionReadCheck(logicalName, name);
            }
            catch (ConfigException configE) {
                throw new DirectoryServiceException("Unable to check permissions in lookupIdentity for " + name);
            }
        } else {
            this.configurePermissionReadCheck(MF_DIR_SEPARATOR_STRING, name, false);
        }
        return id;
    }

    private void checkAndConfigurePermissionReadCheck(String logicalName, String name) throws ConfigException, DirectoryServiceException {
        EntityName eName = new EntityName(logicalName);
        String parent = DSComponent.checkParentSeparator(eName);
        this.configurePermissionReadCheck(parent, name, true);
    }

    private String retrieveLogicalNameFromStorage(String name) {
        String logicalName = null;
        try {
            logicalName = this.m_ds.storageToLogical(name);
        }
        catch (DirectoryServiceException directoryServiceException) {
            // empty catch block
        }
        return logicalName;
    }

    public IDirElement[] getAllElements(String dirName, Boolean forUpdate) throws MFException {
        this.validateStarted();
        this.validateActive();
        IDirElement[] elements = this.m_ds.getAllElements(dirName, forUpdate);
        return this.checckAllowRead(elements);
    }

    private IDirElement[] checckAllowRead(IDirElement[] elements) throws DirectoryServiceException {
        ArrayList<IDirElement> prunedList = new ArrayList<IDirElement>();
        for (int i = 0; i < elements.length; ++i) {
            try {
                String storageName = elements[i].getIdentity().getName();
                this.configurePermissionReadCheckWithLogicalName(storageName);
                prunedList.add(elements[i]);
                continue;
            }
            catch (ConfigurePermissionDeniedException denied) {
                // empty catch block
            }
        }
        return DSComponent.clonePrunedList(prunedList);
    }

    public byte[] getAllElementsCompressed(String dirName, Boolean forUpdate) throws MFException {
        this.validateStarted();
        this.validateActive();
        IDirElement[] prunedElements = this.getAllElements(dirName, forUpdate);
        try {
            return ZipUtils.asZippedBytes((IDirElement[])prunedElements);
        }
        catch (IOException e) {
            throw new DirectoryServiceException("Failed to compress elements in " + dirName);
        }
    }

    public IDirElement[] getAllElements(String subscriber, String dirName) throws MFException {
        this.trace(128, subscriber + ": getAllElements - " + dirName);
        this.validateStarted();
        this.validateActive();
        this.m_registry.subscribe(subscriber, dirName);
        return this.m_ds.getAllElements(dirName, false);
    }

    public IIdentity[] listAll(String dirName) throws MFException {
        this.validateStarted();
        this.validateActive();
        IIdentity[] all = this.m_ds.listAll(dirName);
        ArrayList<IIdentity> prunedList = new ArrayList<IIdentity>();
        if (this.checkPermissions(dirName)) {
            for (int i = 0; i < all.length; ++i) {
                String id = all[i].getName();
                String logicalName = null;
                String folderName = null;
                if (all[i] instanceof IElementIdentity) {
                    logicalName = this.m_ds.storageToLogical(id);
                }
                if (logicalName != null) {
                    try {
                        EntityName eName = new EntityName(logicalName);
                        folderName = eName.getParent();
                    }
                    catch (Exception e) {
                        throw new DirectoryServiceException("Unable to check permissions while executing listAll " + e.toString());
                    }
                }
                try {
                    if (folderName != null) {
                        if (folderName.equals(MF_DIR_SEPARATOR_STRING)) {
                            this.configurePermissionReadCheck(MF_DIR_SEPARATOR_STRING, id, true);
                        } else {
                            this.configurePermissionReadCheck(folderName + MF_DIR_SEPARATOR_STRING, id, true);
                        }
                    } else {
                        this.configurePermissionReadCheck(MF_DIR_SEPARATOR_STRING, id, false);
                    }
                }
                catch (ConfigurePermissionDeniedException denied) {
                    continue;
                }
                prunedList.add(all[i]);
            }
            IIdentity[] prunedArray = new IIdentity[prunedList.size()];
            prunedList.toArray(prunedArray);
            return prunedArray;
        }
        return all;
    }

    public IDirIdentity[] listDirectories(String dirName) throws MFException {
        this.validateStarted();
        this.validateActive();
        IDirIdentity[] ids = this.m_ds.listDirectories(dirName);
        this.configurePermissionReadCheck(MF_DIR_SEPARATOR_STRING, dirName, false);
        return ids;
    }

    public IElementIdentity[] listElements(String dirName) throws MFException {
        this.validateStarted();
        this.validateActive();
        IElementIdentity[] all = this.m_ds.listElements(dirName);
        ArrayList<IElementIdentity> prunedList = new ArrayList<IElementIdentity>();
        for (int i = 0; i < all.length; ++i) {
            String id = all[i].getName();
            String logicalName = this.m_ds.storageToLogical(id);
            String folderName = null;
            if (logicalName != null) {
                try {
                    EntityName eName = new EntityName(logicalName);
                    folderName = eName.getParent();
                }
                catch (Exception e) {
                    throw new DirectoryServiceException("Unable to check permissions while executing listAll " + e.toString());
                }
            }
            try {
                if (folderName != null) {
                    if (folderName.equals(MF_DIR_SEPARATOR_STRING)) {
                        this.configurePermissionReadCheck(MF_DIR_SEPARATOR_STRING, id, true);
                    } else {
                        this.configurePermissionReadCheck(folderName + MF_DIR_SEPARATOR_STRING, id, true);
                    }
                } else {
                    this.configurePermissionReadCheck(MF_DIR_SEPARATOR_STRING, id, false);
                }
            }
            catch (ConfigurePermissionDeniedException denied) {
                continue;
            }
            prunedList.add(all[i]);
        }
        IElementIdentity[] prunedArray = new IElementIdentity[prunedList.size()];
        prunedList.toArray(prunedArray);
        return prunedArray;
    }

    public void detachBlob(IDeltaDirElement delta, IDeltaView view) throws MFException {
        String storageName = this.validateAndRetrieveName((IBasicElement)delta);
        this.configurePermissionDeleteCheck(storageName);
        this.m_ds.detachBlob(delta, view);
    }

    public void deleteElement(String elementName, IDeltaView view) throws MFException {
        this.validateStarted();
        this.validateActive();
        this.configurePermissionDeleteCheck(elementName);
        this.m_ds.deleteElement(elementName, view);
    }

    private void configurePermissionDeleteCheck(String elementName) throws DirectoryServiceException {
        String logicalName = this.m_ds.storageToLogical(elementName);
        if (logicalName != null) {
            this.configurePermissionDeleteCheck(logicalName, elementName, true);
        } else {
            this.configurePermissionDeleteCheck(MF_DIR_SEPARATOR_STRING, elementName, false);
        }
    }

    public void unSubclassElement(String elementName, IDeltaView view) throws MFException {
        String superName;
        this.validateStarted();
        this.validateActive();
        String logicalName = this.m_ds.storageToLogical(elementName);
        IDirElement el = this.m_ds.getElement(elementName, false);
        this.configurePermissionWriteCheck(logicalName, elementName);
        if (el != null && (superName = el.getSuperElementName()) != null) {
            String superLogicalName = this.m_ds.storageToLogical(superName);
            this.configurePermissionWriteCheck(superLogicalName, superName);
        }
        this.m_ds.unSubclassElement(elementName, view);
    }

    private void configurePermissionWriteCheck(String superLogicalName, String superName) throws DirectoryServiceException {
        if (superLogicalName != null) {
            this.configurePermissionWriteCheck(superLogicalName, superName, true);
        } else {
            this.configurePermissionWriteCheck(MF_DIR_SEPARATOR_STRING, null, false);
        }
    }

    public void createDirectory(String dirName) throws MFException {
        this.validateStarted();
        this.validateActive();
        this.configurePermissionWriteCheck(MF_DIR_SEPARATOR_STRING, dirName, false);
        this.m_ds.createDirectory(dirName);
    }

    public void deleteDirectory(String dirName) throws MFException {
        this.validateBeforeDeleteDirectory(dirName);
        this.m_ds.deleteDirectory(dirName);
    }

    public void deleteDirectory(String dirName, IDeltaView view) throws MFException {
        this.validateBeforeDeleteDirectory(dirName);
        this.m_ds.deleteDirectory(dirName, view);
    }

    private void validateBeforeDeleteDirectory(String dirName) throws DirectoryServiceException {
        this.validateStarted();
        this.validateActive();
        this.configurePermissionDeleteCheck(MF_DIR_SEPARATOR_STRING, dirName, false);
    }

    public void attachBlob(IBasicElement element, byte[] blob, IDeltaView view) throws MFException {
        this.validateAndConfigStorageName(element);
        this.m_ds.attachBlob(element, blob, view);
    }

    public void appendBlob(IBasicElement element, byte[] blob, Integer offset, Boolean last, IDeltaView view) throws MFException {
        this.validateAndConfigStorageName(element);
        this.m_ds.appendBlob(element, blob, offset, last, view);
    }

    public INextVersionToken setElement(IBasicElement element, IDeltaView view) throws MFException {
        this.validateAndConfigStorageName(element);
        return this.m_ds.setElement(element, view);
    }

    private void validateAndConfigStorageName(IBasicElement element) throws DirectoryServiceException {
        String storageName = this.validateAndRetrieveName(element);
        this.configurePermissionWriteCheckWithStorageName(storageName);
    }

    public void upgrade5to6(String configType, String configLogicalPath) throws MFException {
        this.validateStarted();
        this.validateActive();
        this.m_ds.upgrade5to6(configType, configLogicalPath);
    }

    public void setElementReleaseVersion(String elementName, String newVersion) throws MFException {
        this.validateStarted();
        this.validateActive();
        this.configurePermissionWriteCheckWithStorageName(elementName);
        this.m_ds.setElementReleaseVersion(elementName, newVersion);
    }

    public INextVersionToken setElements(IBasicElement[] elements, String[] deleteList, IDeltaView view) throws MFException {
        int i;
        this.validateStarted();
        this.validateActive();
        if (elements != null) {
            for (i = 0; i < elements.length; ++i) {
                if (elements[i] == null) continue;
                String storageName = elements[i].getIdentity().getName();
                this.configurePermissionWriteCheckWithStorageName(storageName);
            }
        }
        if (deleteList != null) {
            for (i = 0; i < deleteList.length; ++i) {
                if (deleteList[i] == null) continue;
                String logical = this.m_ds.storageToLogical(deleteList[i]);
                if (logical != null) {
                    this.configurePermissionDeleteCheck(logical, deleteList[i], true);
                    continue;
                }
                this.configurePermissionDeleteCheck(MF_DIR_SEPARATOR_STRING, deleteList[i], false);
            }
        }
        return this.m_ds.setElements(elements, deleteList, view);
    }

    private void configurePermissionWriteCheckWithStorageName(String storageName) throws DirectoryServiceException {
        String logicalName = this.m_ds.storageToLogical(storageName);
        if (logicalName != null) {
            this.configurePermissionWriteCheck(logicalName, storageName, true);
        } else {
            this.configurePermissionWriteCheck(MF_DIR_SEPARATOR_STRING, storageName, false);
        }
    }

    public IDirElement cloneElement(String elementName, String newName, IDeltaView view) throws MFException {
        this.cloneElementValidateElementName(elementName, newName);
        return this.m_ds.cloneElement(elementName, newName, view);
    }

    public IDirElement cloneElement(IBasicElement delta, String newName, IDeltaView view) throws MFException {
        this.cloneElementValidateDelta(delta, newName);
        return this.m_ds.cloneElement(delta, newName, view);
    }

    public IDirElement cloneElement(String elementName, String newName, Boolean createTemplate, IDeltaView view) throws MFException {
        this.cloneElementValidateElementName(elementName, newName);
        return this.m_ds.cloneElement(elementName, newName, createTemplate, view);
    }

    private void cloneElementValidateElementName(String elementName, String newName) throws DirectoryServiceException {
        this.validateStarted();
        this.validateActive();
        this.configurePermissionReadCheckWithLogicalName(elementName);
        this.configurePermissionWriteCheck(MF_DIR_SEPARATOR_STRING, newName, false);
    }

    public IDirElement cloneElement(IBasicElement delta, String newName, Boolean createTemplate, IDeltaView view) throws MFException {
        this.cloneElementValidateDelta(delta, newName);
        return this.m_ds.cloneElement(delta, newName, createTemplate, view);
    }

    private void cloneElementValidateDelta(IBasicElement delta, String newName) throws DirectoryServiceException {
        String storageName = this.validateAndRetrieveName(delta);
        this.configurePermissionReadCheckWithLogicalName(storageName);
        this.configurePermissionWriteCheck(MF_DIR_SEPARATOR_STRING, newName, false);
    }

    public IDirElement subclassElement(IBasicElement delta, String newName, IDeltaView view) throws MFException {
        String storageName = this.validateAndRetrieveName(delta);
        String sourceLogical = this.m_ds.storageToLogical(storageName);
        if (sourceLogical != null) {
            this.configurePermissionReadCheck(sourceLogical, storageName, true);
        } else {
            this.configurePermissionReadCheck(MF_DIR_SEPARATOR_STRING, null, false);
        }
        this.configurePermissionWriteCheck(MF_DIR_SEPARATOR_STRING, null, false);
        return this.m_ds.subclassElement(delta, newName, view);
    }

    private String validateAndRetrieveName(IBasicElement delta) {
        this.validateStarted();
        this.validateActive();
        String storageName = delta.getIdentity().getName();
        return storageName;
    }

    public String ping(String pingMessage) throws MFException {
        this.validateStarted();
        this.validateActive();
        return pingMessage;
    }

    public String ping(String containerID, Short[] versionInfo) throws MFException {
        this.validateStarted();
        this.validateActive();
        ContainerCompatibility.addContainer((String)containerID, (short)versionInfo[0], (short)versionInfo[1], (short)versionInfo[2], (short)versionInfo[3]);
        return "PONG";
    }

    public IDirElement[] getUpdatedList(String subscriber, IElementIdentity[] identities, HashMap deletedConfs, Long callerBackupVersion) throws MFException {
        this.trace(128, subscriber + ": getUpdatedList ");
        this.validateStarted();
        this.validateActive();
        this.registerElementSubscriptions(subscriber, identities, deletedConfs);
        long callerBV = callerBackupVersion != null ? callerBackupVersion : 0L;
        return this.m_ds.getUpdatedList(identities, deletedConfs, callerBV);
    }

    public IDirElement[] getNewElements(String subscriber, String dirName, IElementIdentity[] identities) throws MFException {
        this.trace(128, subscriber + ": getNewElements");
        this.validateStarted();
        this.validateActive();
        this.m_registry.subscribe(subscriber, dirName);
        return this.m_ds.getNewElements(dirName, identities);
    }

    public IDirElement[][] getCacheElements(String subscriber, Long callerBackupVersion, IElementIdentity[] identities, HashMap deletedConfs, String[] dirNames) throws MFException {
        this.trace(128, subscriber + ": getCacheElements");
        this.validateStarted();
        this.validateActive();
        if (deletedConfs != null) {
            this.registerElementSubscriptions(subscriber, identities, deletedConfs);
        }
        if (dirNames != null) {
            for (int i = 0; i < dirNames.length; ++i) {
                this.m_registry.subscribe(subscriber, dirNames[i]);
            }
        }
        long callerBV = callerBackupVersion != null ? callerBackupVersion : 0L;
        return this.m_ds.getCacheElements(callerBV, identities, deletedConfs, dirNames);
    }

    public Object[] reconcileCache(String containerID, Short[] versionInfo, Long callerBackupVersion, IElementIdentity[] identities, HashMap deletedConfs, String[] dirNames, HashMap logicalMap) throws MFException {
        ContainerCompatibility.addContainer((String)containerID, (short)versionInfo[0], (short)versionInfo[1], (short)versionInfo[2], (short)versionInfo[3]);
        if (this.m_ds.areNotificationsSuspended(containerID)) {
            if (versionInfo[0] == Version.getMajorVersion() && versionInfo[1] == Version.getMinorVersion() && versionInfo[2] == Version.getPointVersion()) {
                this.m_ds.resumeChangeNotifications(containerID);
            } else {
                return new Object[]{null, null, null};
            }
        }
        this.trace(128, containerID + ": reconcile");
        IDirElement[][] cacheElements = this.getCacheElements(containerID, callerBackupVersion, identities, deletedConfs, dirNames);
        HashMap corrections = null;
        if (logicalMap != null) {
            corrections = this.m_ds.getUpdatedLogicalNames(logicalMap);
        }
        return new Object[]{cacheElements[0], cacheElements[1], corrections};
    }

    private void registerElementSubscriptions(String subscriber, IElementIdentity[] identities, HashMap deletedConfs) {
        String[] elementNames = new String[identities.length];
        for (int i = 0; i < identities.length; ++i) {
            elementNames[i] = identities[i].getName();
        }
        this.m_registry.subscribe(subscriber, elementNames);
        Iterator iterator = deletedConfs.keySet().iterator();
        while (iterator.hasNext()) {
            this.m_registry.subscribe(subscriber, (String)iterator.next());
        }
    }

    public HashMap getUpdatedLogicalNames(HashMap names) throws MFException {
        this.trace(128, "getUpdatedLogicalNames");
        this.validateStarted();
        this.validateActive();
        return this.m_ds.getUpdatedLogicalNames(names);
    }

    public Long subscribe(String subscriber, String[] dirAndEntitieNames) throws MFException {
        this.trace(128, subscriber + ": subscribe");
        if ((this.m_traceMask & 1) > 0) {
            this.traceData(dirAndEntitieNames, 1024);
        }
        this.validateStarted();
        this.validateActive();
        this.m_registry.subscribe(subscriber, dirAndEntitieNames);
        return new Long(this.m_ds.getBackupTimestamp());
    }

    private void traceData(String[] dirAndEntitieNames, int TRACE_ALL_DS_ACCESS) {
        for (int i = 0; i < dirAndEntitieNames.length; ++i) {
            this.trace(TRACE_ALL_DS_ACCESS, dirAndEntitieNames[i]);
        }
    }

    public Integer getDirectoryServiceVersion() {
        return new Integer(4);
    }

    public String getDirectoryServiceReleaseVersion() {
        return this.m_ds.getDirectoryServiceReleaseVersion();
    }

    public IView getView() throws MFException {
        this.validateStarted();
        this.validateActive();
        IView view = this.m_ds.getView();
        this.configurePermissionReadCheck(MF_DIR_SEPARATOR_STRING, null, false);
        return view;
    }

    public IView setView(IDeltaView view) throws MFException {
        this.validateBeforeSetView();
        return this.m_ds.setView(view);
    }

    public INextVersionToken setViewGetToken(IDeltaView view) throws MFException {
        this.validateBeforeSetView();
        return this.m_ds.setViewGetToken(view);
    }

    public String exportElementToXML(String elementName) throws MFException {
        this.validateStarted();
        this.validateActive();
        String xml = this.m_ds.exportElementToXML(elementName);
        this.configurePermissionReadCheckWithLogicalName(elementName);
        return xml;
    }

    public String exportDSBootFileString(String elementName) throws MFException {
        this.validateStarted();
        this.validateActive();
        String xml = this.m_ds.exportDSBootFileString(elementName);
        this.configurePermissionReadCheckWithLogicalName(elementName);
        return xml;
    }

    private void configurePermissionReadCheckWithLogicalName(String elementName) throws DirectoryServiceException {
        String logicalName = this.m_ds.storageToLogical(elementName);
        if (logicalName != null) {
            this.configurePermissionReadCheck(logicalName, elementName, true);
        } else {
            this.configurePermissionReadCheck(MF_DIR_SEPARATOR_STRING, elementName, false);
        }
    }

    public String exportDirectoryToXML(String dirName) throws MFException {
        this.validateStarted();
        this.validateActive();
        return this.m_ds.exportDirectoryToXML(dirName);
    }

    public void dumpContentsToXML() {
        this.validateStarted();
        this.validateActive();
        this.m_ds.dumpContentsToXML();
    }

    public void importFromXML(String XMLDocument) throws MFException {
        this.validateStarted();
        this.validateActive();
        this.m_ds.importFromXML(XMLDocument);
    }

    public Boolean leaseLock(String lockName, String key, Integer leaseDurationParam) throws MFException {
        Integer leaseDuration = leaseDurationParam;
        if (leaseDuration == 0) {
            throw new IllegalArgumentException("Lease duration must be > 0");
        }
        this.validateStarted();
        if (leaseDuration < 0) {
            leaseDuration = new Integer(0 - leaseDuration);
        } else {
            this.validateActive();
        }
        Boolean leased = new Boolean(this.m_lockManager.leaseLock(lockName, key, leaseDuration * 1000));
        if (!this.m_isNotFaultTolerant && this.m_faultToleranceStateManager.getState(null) == 2 && leased.booleanValue()) {
            try {
                this.m_frameworkContext.invoke(this.m_FTpartnerAddress, "leaseLock", new Object[]{lockName, key, new Integer(0 - leaseDuration)}, LEASE_LOCK_SIGNATURE, false, 0L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return leased;
    }

    public void releaseLock(String lockName, String key) throws MFException {
        this.validateStarted();
        this.m_lockManager.releaseLock(lockName, key);
    }

    @Override
    public Class loadClass(String className, String classpath) throws Exception {
        URL[] applicationURLs = URLUtility.classpathToURLArray((String)classpath, (String)";");
        String containerName = this.m_frameworkContext.getContainer().getContainerIdentity().getCanonicalName();
        ClassLoader classLoader = ClassLoaderFactory.createDelegatingLoader(containerName, className, applicationURLs, this.m_sharedLoader, new String[]{"$MQclient"});
        return Class.forName(className, false, classLoader);
    }

    public void logMessage(String message, int severityLevel) {
        if (this.m_context != null) {
            this.m_context.logMessage(message, severityLevel);
        }
    }

    public void logMessage(String message, Throwable throwable, int severityLevel) {
        if (this.m_context != null) {
            this.m_context.logMessage(message, throwable, severityLevel);
        }
    }

    public void trace(int mask, String message) {
        if ((this.m_traceMask & mask) > 0 && this.m_context != null) {
            this.m_context.logMessage(message, 7);
        }
    }

    public void trace(int mask, String message, Throwable throwable) {
        if ((this.m_traceMask & mask) > 0 && this.m_context != null) {
            this.m_context.logMessage(message, throwable, 7);
        }
    }

    private void validateStarted() throws DSNotStartedException {
        if (this.m_state != 3) {
            throw new DSNotStartedException("The Directory Service is not started.");
        }
    }

    private void validateActive() {
        if (!this.m_isNotFaultTolerant && this.m_faultToleranceStateManager.getState(null) != 2) {
            throw new MFServiceNotActiveException('[' + this.m_faultToleranceRole + "] Directory Service not active");
        }
    }

    private MFRuntimeException createMFRuntimeException(Exception e) {
        MFRuntimeException mfe = new MFRuntimeException(e.toString());
        mfe.setLinkedException(e);
        return mfe;
    }

    private void sendLogicalRenamings(ArrayList notifications, String[] interestedContainers) {
        if (interestedContainers.length == 0) {
            return;
        }
        IDirElement notificationElement = ElementFactory.createElement((String)DS_RENAMING_ELEMENT, (String)"renaming notification", (String)"2.0");
        IAttributeSet attributes = notificationElement.getAttributes();
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream objectOut = new ObjectOutputStream(out);
            objectOut.writeObject(notifications);
            byte[] notificationsBytes = out.toByteArray();
            objectOut.close();
            attributes.setBytesAttribute("notifications", notificationsBytes);
        }
        catch (Exception e) {
            throw new Error();
        }
        for (int i = 0; i < interestedContainers.length; ++i) {
            this.sendChangedElement((IBasicElement)notificationElement, interestedContainers[i], false, (this.m_traceMask & 0x100) > 0);
        }
    }

    private HashSet updateLogicalRegistry(ArrayList notifications, ArrayList renameNotifications) {
        HashSet interestedContainers = new HashSet();
        for (int i = 0; i < notifications.size(); ++i) {
            INamingNotification notification = (INamingNotification)notifications.get(i);
            if (notification instanceof IFolderDeleteNotification || notification instanceof IElementDeleteNotification) {
                this.m_registry.deleteLogicalPath(notification.getName());
                continue;
            }
            if (!(notification instanceof IRenameNotification)) continue;
            interestedContainers.addAll(this.m_registry.renameLogicalPath(((IRenameNotification)notification).getName(), ((IRenameNotification)notification).getNewName()));
            renameNotifications.add(notification);
        }
        return interestedContainers;
    }

    public void defineFolderMetaAttributes(String[] attributeNames) throws MFException {
        this.validateBeforeSetView();
        this.m_ds.defineFolderMetaAttributes(attributeNames);
    }

    public String[] getDefinedFolderMetaAttributes() throws MFException {
        this.validateStarted();
        this.validateActive();
        String[] attributes = this.m_ds.getDefinedFolderMetaAttributes();
        this.configurePermissionReadCheck(MF_DIR_SEPARATOR_STRING, null, false);
        return attributes;
    }

    public void defineElementMetaAttributes(String[] attributeNames) throws MFException {
        this.validateBeforeSetView();
        this.m_ds.defineElementMetaAttributes(attributeNames);
    }

    public String[] getDefinedElementMetaAttributes() throws MFException {
        this.validateStarted();
        this.validateActive();
        String[] attributes = this.m_ds.getDefinedElementMetaAttributes();
        this.configurePermissionReadCheck(MF_DIR_SEPARATOR_STRING, null, false);
        return attributes;
    }

    public void rename(String oldPath, String newPath) throws MFException {
        this.validateStarted();
        this.validateActive();
        SharedPermissionChecks checks = new SharedPermissionChecks(this.getContext(), this.m_ds);
        checks.renameCheck(oldPath, newPath);
        this.m_ds.rename(oldPath, newPath);
    }

    public void renameFolder(String oldPath, String newPath) throws MFException {
        this.validateStarted();
        this.validateActive();
        this.m_ds.renameFolder(oldPath, newPath);
    }

    public void renameFile(String oldPath, String newPath) throws MFException {
        this.validateStarted();
        this.validateActive();
        this.m_ds.renameFile(oldPath, newPath);
    }

    public void createFolder(String folderPath) throws MFException {
        this.validateStarted();
        this.validateActive();
        new SharedPermissionChecks(this.getContext(), this.m_ds).createFolderCheck(folderPath, false);
        this.m_ds.createFolder(folderPath);
    }

    public void createFolder(String folderPath, Boolean existingOk) throws MFException {
        this.validateStarted();
        this.validateActive();
        new SharedPermissionChecks(this.getContext(), this.m_ds).createFolderCheck(folderPath, existingOk);
        this.m_ds.createFolder(folderPath, existingOk);
    }

    public void copyFiles(String fromPath, String toPath) throws MFException {
        this.validateStarted();
        this.validateActive();
        try {
            ExtendedSonicFSFileSystem extendedFS = new ExtendedSonicFSFileSystem(this.m_ds, null, null);
            String canonicalFrom = extendedFS.getCanonical(fromPath);
            String canonicalTo = extendedFS.getCanonical(toPath);
            String canonicalToParent = canonicalTo.equals("/") ? null : extendedFS.getParent(canonicalTo);
            SonicFSFile fromFile = extendedFS.getFileDetails(canonicalFrom);
            SonicFSFile toFile = extendedFS.getFileDetails(canonicalTo);
            SonicFSFile toParentFile = null;
            if (canonicalToParent != null) {
                toParentFile = extendedFS.getFileDetails(canonicalToParent);
            }
            if (fromFile != null) {
                SonicFSFile[] files = extendedFS.deepListDetails(canonicalFrom);
                for (int i = 0; i < files.length; ++i) {
                    SonicFSFile file = files[i];
                    String checkPath = file.getFullName();
                    if (file.isDirectory()) {
                        checkPath = DSComponent.checkSeparatorCheckPath(checkPath);
                    }
                    this.configurePermissionReadCheck(checkPath, null, true);
                }
            }
            if (toFile != null) {
                if (toFile.isFile()) {
                    this.configurePermissionDeleteCheck(canonicalTo, null, true);
                    this.configurePermissionWriteCheck(canonicalToParent, null, true);
                } else {
                    this.configurePermissionWriteCheck(canonicalTo);
                }
            } else if (toParentFile != null) {
                this.configurePermissionWriteCheck(canonicalToParent);
            }
        }
        catch (Exception e) {
            throw new MFException(e.toString());
        }
        try {
            this.m_ds.copyFiles(fromPath, toPath);
        }
        catch (DirectoryServiceException e) {
            throw new MFException(e.toString());
        }
    }

    private void configurePermissionWriteCheck(String canonicalToParent) throws DirectoryServiceException {
        String checkPath = canonicalToParent;
        checkPath = DSComponent.checkSeparatorCheckPath(checkPath);
        this.configurePermissionWriteCheck(checkPath, null, true);
    }

    private static String checkSeparatorCheckPath(String checkPathParam) {
        String checkPath = checkPathParam;
        if (!checkPath.endsWith(MF_DIR_SEPARATOR_STRING)) {
            checkPath = checkPath + MF_DIR_SEPARATOR_STRING;
        }
        return checkPath;
    }

    public void deleteFolder(String folderPath) throws MFException {
        this.validateStarted();
        this.validateActive();
        new SharedPermissionChecks(this.getContext(), this.m_ds).deleteFolderCheck(folderPath);
        this.m_ds.deleteFolder(folderPath);
    }

    public HashMap[] listFolders(String folderPath) throws MFException {
        this.validateStarted();
        this.validateActive();
        HashMap[] folders = this.m_ds.listFolders(folderPath);
        return this.checkSeparatorCheckFolderNameReturnElements(folderPath, folders);
    }

    public HashMap[] listAllFolders() throws MFException {
        this.validateStarted();
        this.validateActive();
        HashMap[] allFolders = this.m_ds.listAllFolders();
        ArrayList<HashMap> prunedList = new ArrayList<HashMap>();
        for (int i = 0; i < allFolders.length; ++i) {
            EntityName folderEName;
            HashMap folder = allFolders[i];
            String folderName = (String)folder.get("_FOLDER_NAME");
            if (folderName.equals(MF_DIR_SEPARATOR_STRING)) {
                prunedList.add(folder);
                continue;
            }
            try {
                folderEName = new EntityName(folderName);
            }
            catch (Exception e) {
                throw new DirectoryServiceException("Unable to check permissions for " + folderName);
            }
            String parentFolder = folderEName.getParent();
            try {
                this.configurePermissionReadCheck(parentFolder);
                prunedList.add(folder);
                continue;
            }
            catch (ConfigurePermissionDeniedException configurePermissionDeniedException) {
                // empty catch block
            }
        }
        HashMap[] prunedFolders = new HashMap[prunedList.size()];
        prunedList.toArray(prunedFolders);
        return prunedFolders;
    }

    public HashMap[] listFSAll(String path) throws MFException {
        return this.listFSAll(path, true, null);
    }

    public HashMap[] listFSAll(String path, Boolean getFolders, String extension) throws MFException {
        this.validateStarted();
        this.validateActive();
        HashMap[] all = this.m_ds.listFSAll(path, getFolders, extension);
        return this.checkSeparatorCheckFolderNameReturnElements(path, all);
    }

    public ArrayList<HashMap> recursiveList(String path, Boolean getFolders, Boolean getElements, String extension) throws MFException {
        ArrayList<HashMap> recursiveResult = this.validateAndCreateMap();
        try {
            String checkFolderName = path;
            this.checkSeparatorCheckFolderName(checkFolderName);
        }
        catch (ConfigurePermissionDeniedException denied) {
            return recursiveResult;
        }
        this.checkFolderName(path);
        ArrayList localResult = this.m_ds.listFSAll(path, true, true, extension);
        for (HashMap childMap : localResult) {
            String folderName = (String)childMap.get("_FOLDER_NAME");
            IElementIdentity elementID = (IElementIdentity)childMap.get("_ELEMENT_IDENTITY");
            if (folderName != null) {
                boolean isRealFolder = this.isRealFolder(childMap);
                if (getFolders.booleanValue() && isRealFolder) {
                    recursiveResult.add(childMap);
                }
                if (!isRealFolder) continue;
                recursiveResult.addAll(this.recursiveList(folderName, getFolders, getElements, extension));
                continue;
            }
            if (!getElements.booleanValue()) continue;
            recursiveResult.add(childMap);
        }
        return recursiveResult;
    }

    private boolean isRealFolder(Map map) {
        try {
            Map res = Util.splitToolMetaAttributes((Map)map);
            return !res.containsKey("_FOLDER_NAME") || !res.containsKey("TYPE");
        }
        catch (Exception exception) {
            return false;
        }
    }

    public HashMap[] listFSElements(String folderPath) throws MFException {
        this.validateStarted();
        this.validateActive();
        HashMap[] elements = this.m_ds.listFSElements(folderPath);
        return this.checkSeparatorCheckFolderNameReturnElements(folderPath, elements);
    }

    private HashMap[] checkSeparatorCheckFolderNameReturnElements(String folderPath, HashMap[] elements) throws DirectoryServiceException {
        String checkFolderName = folderPath;
        this.checkSeparatorCheckFolderName(checkFolderName);
        return elements;
    }

    public void setMetaAttributes(String path, HashMap attributes) throws MFException {
        this.validateStarted();
        this.validateActive();
        new SharedPermissionChecks(this.getContext(), this.m_ds).setMetaAttributesCheck(path);
        this.m_ds.setMetaAttributes(path, attributes);
    }

    public HashMap getMetaAttributes(String path) throws MFException {
        this.validateStarted();
        this.validateActive();
        HashMap attrs = this.m_ds.getMetaAttributes(path);
        if (attrs != null) {
            String checkName = attrs.get("_FOLDER_NAME") != null && !path.endsWith(MF_DIR_SEPARATOR_STRING) ? path + MF_DIR_SEPARATOR_STRING : path;
            this.configurePermissionReadCheck(checkName, null, true);
        }
        return attrs;
    }

    public void setStorageHint(String elementType, String directoryPath) throws MFException {
        this.validateBeforeSetView();
        this.m_ds.setStorageHint(elementType, directoryPath);
    }

    public void setStorageHint(String elementType, String postfix, String directoryPath) throws MFException {
        this.validateBeforeSetView();
        this.m_ds.setStorageHint(elementType, postfix, directoryPath);
    }

    public void setComplexStorageHint(String elementType, String directoryPath) throws MFException {
        this.validateBeforeSetView();
        this.m_ds.setComplexStorageHint(elementType, directoryPath);
    }

    public void setBackReferenceTypes(String[] types) throws MFException {
        this.validateBeforeSetView();
        this.configurePermissionDeleteCheck(MF_DIR_SEPARATOR_STRING, null, false);
        this.m_ds.setBackReferenceTypes(types);
    }

    public IDirElement[] getFSElements(Query query, Boolean forUpdate, Boolean getSubclassingDelta) throws MFException {
        this.validateStarted();
        this.validateActive();
        IDirElement[] elements = this.m_ds.getFSElements(query, forUpdate, getSubclassingDelta);
        IDirElement[] prunedElements = this.checkAllowReadAndPruneList(elements);
        return prunedElements;
    }

    public QueryBatch getFSElements(Query query, Boolean forUpdate, Boolean getSubclassingDelta, QueryBatch qb) throws MFException {
        this.validateStarted();
        this.validateActive();
        IDirElement[] elements = this.m_ds.getFSElements(query, forUpdate, getSubclassingDelta, qb).getElements();
        IDirElement[] prunedElements = this.checkAllowReadAndPruneList(elements);
        return new QueryBatch(prunedElements, qb);
    }

    public IDirElement[] getFSElements(Query query, Boolean forUpdate) throws MFException {
        this.validateStarted();
        this.validateActive();
        IDirElement[] elements = this.m_ds.getFSElements(query, forUpdate);
        IDirElement[] prunedElements = this.checkAllowReadAndPruneList(elements);
        return prunedElements;
    }

    public IDirElement getFSElement(String elementPath, Boolean forUpdate) throws MFException {
        this.validateStarted();
        this.validateActive();
        IDirElement el = this.m_ds.getFSElement(elementPath, forUpdate);
        this.configurePermissionReadCheck(elementPath, null, true);
        return el;
    }

    public IDirElement[] getFSElements(String folderPath, Boolean forUpdate) throws MFException {
        this.validateStarted();
        this.validateActive();
        IDirElement[] elements = this.m_ds.getFSElements(folderPath, forUpdate);
        IDirElement[] prunedElements = this.checkAllowReadAndPruneList(elements);
        return prunedElements;
    }

    private IDirElement[] checkAllowReadAndPruneList(IDirElement[] elements) throws DirectoryServiceException {
        ArrayList<IDirElement> prunedList = new ArrayList<IDirElement>();
        for (int i = 0; i < elements.length; ++i) {
            try {
                String storageName = elements[i].getIdentity().getName();
                this.configurePermissionReadCheck(storageName, null, true);
                prunedList.add(elements[i]);
                continue;
            }
            catch (ConfigurePermissionDeniedException denied) {
                // empty catch block
            }
        }
        return DSComponent.clonePrunedList(prunedList);
    }

    private static IDirElement[] clonePrunedList(ArrayList prunedList) {
        IDirElement[] prunedElements = new IDirElement[prunedList.size()];
        prunedList.toArray(prunedElements);
        return prunedElements;
    }

    public IDirElement getFSElement(String elementPath, Boolean forUpdate, Boolean getSubclassingDelta) throws MFException {
        this.validateStarted();
        this.validateActive();
        IDirElement el = this.m_ds.getFSElement(elementPath, forUpdate, getSubclassingDelta);
        this.configurePermissionReadCheck(elementPath, null, true);
        return el;
    }

    public IElementIdentity getFSIdentity(String elementPath) throws MFException {
        this.validateStarted();
        this.validateActive();
        IElementIdentity id = this.m_ds.getFSIdentity(elementPath);
        try {
            EntityName eName = new EntityName(elementPath);
            String parent = DSComponent.checkParentSeparator(eName);
            this.configurePermissionReadCheck(parent, null, true);
        }
        catch (ConfigException configE) {
            throw new DirectoryServiceException("Unable to check permissions in getFSIdentity for " + elementPath);
        }
        return id;
    }

    private static String checkParentSeparator(EntityName eName) {
        String parent = eName.getParent();
        parent = DSComponent.checkAndAddSeparator(parent);
        return parent;
    }

    public IElementIdentity deleteFSElement(String elementPath) throws MFException {
        this.validateStarted();
        this.validateActive();
        new SharedPermissionChecks(this.getContext(), this.m_ds).deleteFSElementCheck(elementPath);
        return this.m_ds.deleteFSElement(elementPath);
    }

    public INextVersionToken createFSElement(IDirElement element) throws MFException {
        this.validateStarted();
        this.validateActive();
        new SharedPermissionChecks(this.getContext(), this.m_ds).createFSElementsCheck(new IDirElement[]{element});
        return this.m_ds.createFSElement(element);
    }

    public INextVersionToken updateFSElement(IDeltaDirElement element) throws MFException {
        this.validateStarted();
        this.validateActive();
        new SharedPermissionChecks(this.getContext(), this.m_ds).updateFSElementCheck(element.getIdentity().getName());
        return this.m_ds.updateFSElement(element);
    }

    public IDirElement cloneFSBlob(String elementPath, String newElementPath) throws MFException {
        EntityName newEName;
        this.validateStarted();
        this.validateActive();
        this.configurePermissionReadCheck(elementPath, elementPath, true);
        try {
            newEName = new EntityName(newElementPath);
        }
        catch (Exception e) {
            throw new DirectoryServiceException("Unable to check permissions while cloning " + elementPath + e.toString());
        }
        String parentFolder = newEName.getParent();
        if (parentFolder.equals(MF_DIR_SEPARATOR_STRING)) {
            this.configurePermissionWriteCheck(parentFolder, null, true);
        } else {
            this.configurePermissionWriteCheck(parentFolder + '/', null, true);
        }
        return this.m_ds.cloneFSBlob(elementPath, newElementPath);
    }

    public IDirElement cloneFSElement(String elementPath, String newElementPath) throws MFException {
        this.closeFSElementValidateElementPath(elementPath, newElementPath);
        return this.m_ds.cloneFSElement(elementPath, newElementPath);
    }

    public IDirElement cloneFSElement(IBasicElement delta, String newElementPath) throws MFException {
        this.closeFSElementValidateDelta(delta, newElementPath);
        return this.m_ds.cloneFSElement(delta, newElementPath);
    }

    public IDirElement cloneFSElement(String elementPath, String newElementPath, Boolean createTemplate) throws MFException {
        this.closeFSElementValidateElementPath(elementPath, newElementPath);
        return this.m_ds.cloneFSElement(elementPath, newElementPath, createTemplate);
    }

    private void closeFSElementValidateElementPath(String elementPath, String newElementPath) throws DirectoryServiceException {
        this.validateStarted();
        this.validateActive();
        new SharedPermissionChecks(this.getContext(), this.m_ds).cloneFSElementCheck(elementPath, newElementPath);
    }

    public IDirElement cloneFSElement(IBasicElement delta, String newElementPath, Boolean createTemplate) throws MFException {
        this.closeFSElementValidateDelta(delta, newElementPath);
        return this.m_ds.cloneFSElement(delta, newElementPath, createTemplate);
    }

    private void closeFSElementValidateDelta(IBasicElement delta, String newElementPath) throws DirectoryServiceException {
        this.validateStarted();
        this.validateActive();
        new SharedPermissionChecks(this.getContext(), this.m_ds).cloneFSElementCheck(delta.getIdentity().getName(), newElementPath);
    }

    public void attachFSBlob(IBasicElement element, byte[] bytes) throws MFException {
        this.validateStarted();
        this.validateActive();
        new SharedPermissionChecks(this.getContext(), this.m_ds).attachFSBlobCheck(element.getIdentity().getName());
        this.m_ds.attachFSBlob(element, bytes);
    }

    public void appendFSBlob(IBasicElement element, byte[] bytes, Integer offset, Boolean last) throws MFException {
        this.validateStarted();
        this.validateActive();
        new SharedPermissionChecks(this.getContext(), this.m_ds).appendFSBlobCheck(element.getIdentity().getName());
        this.m_ds.appendFSBlob(element, bytes, offset, last);
    }

    public IBlob getFSBlob(String elementPath, Boolean forUpdate) throws MFException {
        return this.getFSBlob(elementPath, forUpdate, new Integer(0));
    }

    public IBlob getFSBlob(String elementPath, Boolean forUpdate, Integer offset) throws MFException {
        this.validateStarted();
        this.validateActive();
        IBlob blob = null;
        try {
            blob = this.m_ds.getFSBlob(elementPath, forUpdate, offset);
        }
        catch (MFException mfE) {
            throw mfE;
        }
        catch (Exception e) {
            throw new MFException(e.toString());
        }
        this.configurePermissionReadCheck(elementPath, null, true);
        return blob;
    }

    public IBlob getFiles(String[] fileNames) throws DirectoryServiceException {
        this.validateStarted();
        this.validateActive();
        ArrayList<String> filtered = new ArrayList<String>();
        for (String fileName : fileNames) {
            try {
                this.configurePermissionReadCheck(fileName, fileName, true);
                filtered.add(fileName);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        String[] filteredArray = new String[filtered.size()];
        filtered.toArray(filteredArray);
        return this.m_ds.getFiles(filteredArray);
    }

    public IBlob getFiles(String path, Boolean recurse, String extension) throws MFException {
        ArrayList filesToGet = this.validateAndCreateMap();
        if (!recurse.booleanValue()) {
            try {
                String checkFolderName = path;
                this.checkSeparatorCheckFolderName(checkFolderName);
            }
            catch (ConfigurePermissionDeniedException denied) {
                return this.getFiles(new String[0]);
            }
            this.checkFolderName(path);
            filesToGet = this.m_ds.listFSAll(path, false, true, extension);
        } else {
            filesToGet = this.recursiveList(path, false, true, extension);
        }
        String[] filteredArray = new String[filesToGet.size()];
        int arrayIndex = 0;
        for (HashMap map : filesToGet) {
            filteredArray[arrayIndex++] = ((IElementIdentity)map.get("_ELEMENT_IDENTITY")).getName();
        }
        return this.getFiles(filteredArray);
    }

    private void checkFolderName(String path) throws MFException {
        HashMap pathAttributes = this.getMetaAttributes(path);
        if (pathAttributes.get("_FOLDER_NAME") == null) {
            throw new MFException(path + " is not a folder name");
        }
    }

    private ArrayList<HashMap> validateAndCreateMap() {
        this.validateStarted();
        this.validateActive();
        ArrayList<HashMap> filesToGet = new ArrayList<HashMap>();
        return filesToGet;
    }

    private void checkSeparatorCheckFolderName(String checkFolderNameParam) throws DirectoryServiceException {
        String checkFolderName = checkFolderNameParam;
        checkFolderName = DSComponent.checkAndAddSeparator(checkFolderName);
        this.configurePermissionReadCheck(checkFolderName, null, true);
    }

    private static String checkAndAddSeparator(String checkFolderNameParam) {
        String checkFolderName = checkFolderNameParam;
        if (!checkFolderName.endsWith(MF_DIR_SEPARATOR_STRING)) {
            checkFolderName = checkFolderName + MF_DIR_SEPARATOR_STRING;
        }
        return checkFolderName;
    }

    public void detachFSBlob(IDeltaDirElement delta) throws MFException {
        this.validateStarted();
        this.validateActive();
        new SharedPermissionChecks(this.getContext(), this.m_ds).detachFSBlobCheck(delta.getIdentity().getName());
        this.m_ds.detachFSBlob(delta);
    }

    public IDirElement subclassFSElement(IBasicElement delta, String newElementPath) throws MFException {
        this.validateStarted();
        this.validateActive();
        new SharedPermissionChecks(this.getContext(), this.m_ds).subclassFSElementCheck(delta.getIdentity().getName(), newElementPath);
        return this.m_ds.subclassFSElement(delta, newElementPath);
    }

    public void unSubclassFSElement(String elementPath) throws MFException {
        this.validateStarted();
        this.validateActive();
        IDirElement el = this.m_ds.getFSElement(elementPath, false);
        String superName = null;
        if (el != null && (superName = el.getSuperElementName()) != null) {
            this.configurePermissionWriteCheck(superName, null, true);
            this.configurePermissionWriteCheck(elementPath, null, true);
        }
        this.m_ds.unSubclassFSElement(elementPath);
    }

    public INextVersionToken executeTransaction(IDSTransaction transaction) throws MFException {
        this.validateStarted();
        this.validateActive();
        return this.m_ds.executeTransaction(transaction, this.getContext());
    }

    public String[] getBackReferenceTypes() throws MFException {
        this.validateStarted();
        this.validateActive();
        return this.m_ds.getBackReferenceTypes();
    }

    public AttributeName[] getReferences(String elementPath) throws MFException {
        this.validateStarted();
        this.validateActive();
        AttributeName[] names = this.m_ds.getReferences(elementPath);
        this.configurePermissionReadCheck(elementPath, null, true);
        return names;
    }

    public void repairReferences(String[] exclusions) throws MFException {
        this.validateBeforeSetView();
        this.m_ds.repairReferences(exclusions);
    }

    public void rebuildBackReferences() throws MFException {
        this.validateBeforeSetView();
        this.configurePermissionDeleteCheck(MF_DIR_SEPARATOR_STRING, null, false);
        this.m_ds.rebuildBackReferences();
    }

    public void resetBackReferences() throws MFException {
        this.validateBeforeSetView();
        this.configurePermissionDeleteCheck(MF_DIR_SEPARATOR_STRING, null, false);
        this.m_ds.resetBackReferences();
    }

    public IDirElement revertToTemplate(String elementName, AttributeName[] attributes) throws MFException {
        this.validateStarted();
        this.validateActive();
        this.configurePermissionWriteCheck(elementName, null, true);
        IDirElement el = this.m_ds.getFSElement(elementName, false);
        String superClass = null;
        if (el != null) {
            superClass = el.getSuperElementName();
        }
        if (superClass != null) {
            this.configurePermissionWriteCheck(superClass, null, true);
        }
        return this.m_ds.revertToTemplate(elementName, attributes);
    }

    public IDirElement getDomainElement(Boolean forUpdate) throws MFException {
        this.validateStarted();
        this.validateActive();
        IDirElement el = this.m_ds.getDomainElement(forUpdate);
        this.configurePermissionReadCheck(MF_DIR_SEPARATOR_STRING, null, false);
        return el;
    }

    public void setDomainElement(IDeltaDirElement element) throws MFException {
        this.validateBeforeSetView();
        this.m_ds.setDomainElement(element);
    }

    private void validateBeforeSetView() throws DirectoryServiceException {
        this.validateStarted();
        this.validateActive();
        this.configurePermissionWriteCheck(MF_DIR_SEPARATOR_STRING, null, false);
    }

    public String resolveURL(String url) {
        this.validateStarted();
        this.validateActive();
        try {
            return (String)new URL(url).getContent();
        }
        catch (Exception e) {
            this.m_context.logMessage("Failed request to resolve URL \"" + url + "\",  trace follows...", (Throwable)e, 2);
            return FAULT_TOLERANCE_ROLE_DEFAULT;
        }
    }

    public String[] listExternalDomainWithManagementSPI() throws MFException {
        this.validateStarted();
        this.validateActive();
        String[] domainList = this.m_ds.listExternalDomainWithManagementSPI();
        ArrayList<String> prunedDomainList = new ArrayList<String>();
        for (int i = 0; i < domainList.length; ++i) {
            String logicalName = this.m_ds.storageToLogical(domainList[i]);
            try {
                if (logicalName != null) {
                    String parentName = new EntityName(logicalName).getParent();
                    this.configurePermissionReadCheck(parentName);
                } else {
                    this.configurePermissionReadCheck(MF_DIR_SEPARATOR_STRING, null, false);
                }
                prunedDomainList.add(domainList[i]);
                continue;
            }
            catch (ConfigException configE) {
                throw new DirectoryServiceException("Unable to check permissions in listExternalDomainWithManagementSPI: " + configE.toString());
            }
            catch (ConfigurePermissionDeniedException denied) {
                // empty catch block
            }
        }
        String[] prunedDomainArray = new String[prunedDomainList.size()];
        prunedDomainList.toArray(prunedDomainArray);
        return prunedDomainArray;
    }

    private void configurePermissionReadCheck(String parentName) throws DirectoryServiceException {
        if (parentName.equals(MF_DIR_SEPARATOR_STRING)) {
            this.configurePermissionReadCheck(MF_DIR_SEPARATOR_STRING, null, true);
        } else {
            this.configurePermissionReadCheck(parentName + MF_DIR_SEPARATOR_STRING, null, true);
        }
    }

    public Boolean reloadExternalAuthenticationDomain(String mfDomainDescriptor) throws MFException {
        this.validateStarted();
        this.validateActive();
        return this.m_ds.reloadExternalAuthenticationDomain(mfDomainDescriptor);
    }

    private void createContainerWithADandHM(String containerPath, String activationPath, String daemonName, String hostManagerPath, String hostManagerName) throws Exception {
        MFMgmtBeanFactory factory = new MFMgmtBeanFactory();
        factory.connect((IDirectoryFileSystemService)this.m_ds);
        this.ensureFolderExists(containerPath, factory);
        this.ensureFolderExists(activationPath, factory);
        this.ensureFolderExists(hostManagerPath, factory);
        IContainerBean container = factory.createContainerBean(containerPath);
        this.configurePermissionWriteCheck(containerPath, null, true);
        if (hostManagerPath != null) {
            IHostManagerBean hm = null;
            try {
                hm = factory.getHostManagerBean(hostManagerPath);
                this.configurePermissionReadCheck(hostManagerPath, null, true);
            }
            catch (ConfigurePermissionDeniedException denied) {
                throw denied;
            }
            catch (Exception denied) {
                // empty catch block
            }
            if (hm == null) {
                this.configurePermissionWriteCheck(hostManagerPath, null, true);
                hm = factory.createHostManagerBean(hostManagerPath);
                factory.saveHostManagerBean(hm);
            }
            this.addEntryInComponents(container, (IMgmtBeanBase)hm, hostManagerName);
        }
        if (activationPath != null) {
            IActivationDaemonBean daemon = null;
            try {
                daemon = factory.getActivationDaemonBean(activationPath);
                this.configurePermissionReadCheck(activationPath, null, true);
            }
            catch (ConfigurePermissionDeniedException denied) {
                throw denied;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (daemon == null) {
                this.configurePermissionWriteCheck(activationPath, null, true);
                daemon = factory.createActivationDaemonBean(activationPath);
                factory.saveActivationDaemonBean(daemon);
            }
            this.addEntryInComponents(container, (IMgmtBeanBase)daemon, daemonName);
        }
        factory.saveContainerBean(container);
        factory.commit();
    }

    private void addEntryInComponents(IContainerBean container, IMgmtBeanBase daemon, String daemonName) throws MgmtException {
        IContainerBean.IComponentsType components = container.getComponents();
        IContainerBean.IStartupParams entry = components.createEntry();
        entry.setAutoStart(true);
        entry.setConfigRef(daemon);
        components.addEntry(daemonName, entry);
    }

    private void ensureFolderExists(String path, MFMgmtBeanFactory factory) {
        try {
            factory.createFolder(new EntityName(path).getParent());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public IDirectoryAdminService getDS() {
        return this.m_ds;
    }

    public void startBackup(String backupDir, Boolean overwrite) throws MFException {
        this.validateStarted();
        this.validateActive();
        this.m_ds.startBackup(backupDir, overwrite);
    }

    public IBackupStatus getBackupStatus() throws MFException {
        this.validateStarted();
        this.validateActive();
        return this.m_ds.getBackupStatus();
    }

    public void globalComponentAlreadyExists(String name) {
        if (this.m_isNotFaultTolerant) {
            this.m_context.logMessage("A non-fault tolerant or \"PRIMARY\" Directory Service appears to be running elsewhere; it must be shutdown prior to starting this container hosting the \"PRIMARY\" Directory Service", 1);
            this.abortContainer(5);
        } else if (name.startsWith('[' + this.m_faultToleranceRole + ']')) {
            this.m_context.logMessage("A \"" + this.m_faultToleranceRole + "\" Directory Service appears to be running elsewhere; it must be shutdown prior to starting this container hosting the \"" + this.m_faultToleranceRole + "\" Directory Service", 1);
            this.abortContainer(5);
        }
    }

    private static void setReplicationTracing(int traceMask) {
        Storage.setReplicationTracing((traceMask & 0x800) > 0, false);
    }

    void openStorageForReplication() {
        File domainDir = new File(new File(this.m_hostDir), this.m_domainName);
        File storageDir = new File(domainDir, "data.odb");
        HashMap<String, Object> storageParameters = new HashMap<String, Object>();
        storageParameters.put("NO_READ_LOCK", Boolean.TRUE);
        storageParameters.put("REPLICATION_RETRY_INTERVAL", new Integer(this.m_replicationRetryInterval));
        storageParameters.put("REPLICATION_PING_INTERVAL", new Integer(this.m_replicationPingInterval));
        storageParameters.put("REPLICATION_FAILURE_DETECTION_TIMEOUT", new Integer(this.m_replicationFailureDetectionTimeout));
        storageParameters.put("MAX_REPLICATION_LOG_SIZE", new Integer(this.m_maxReplicationLogSize));
        storageParameters.put("REPLICATION_TIMEOUT", new Integer(this.m_replicationTimeout));
        if (this.m_replSSLParams != null) {
            storageParameters.put("REPLICATION_SSL", this.m_replSSLParams);
        }
        DSComponent.setReplicationTracing(this.m_traceMask);
        this.m_replicationStateHandler = new DSStateHandler(this.m_faultToleranceStateManager);
        this.m_dsStorage = Storage.openStorage(new DSReplicationConroller(), this.m_replicationStateHandler, storageDir.getAbsolutePath(), storageParameters, !this.m_isBackup, m_startActive, this.m_dualActiveResolution, this.m_replConnections);
    }

    private static boolean testStartActive(boolean deleteFile) {
        String testFileName = System.getProperty("_TEST_DSReplication_startActive");
        if (testFileName == null) {
            return false;
        }
        File testFile = new File(testFileName);
        if (!testFile.exists()) {
            return false;
        }
        if (deleteFile) {
            testFile.delete();
        }
        return true;
    }

    private void abortContainer(final int exitCode) {
        this.m_context.logMessage("Aborting container", 1);
        new Thread("DIRECTORY SERVICE - Shutdown Handler"){

            @Override
            public void run() {
                DSComponent.this.m_frameworkContext.getContainer().shutdown(exitCode);
            }
        }.start();
    }

    public void setManagementPermissions(String[] paths, String type, IManagementPermission[][] permissions) throws MFException {
        if (!this.m_ds.isPermissionsCheckingEnabled()) {
            return;
        }
        this.validateStarted();
        this.validateActive();
        this.m_ds.setManagementPermissions(paths, type, permissions, this.getContext());
    }

    public void removeManagementPermissions(String[] paths, String type, String[][] principals) throws MFException {
        if (!this.m_ds.isPermissionsCheckingEnabled()) {
            return;
        }
        this.validateStarted();
        this.validateActive();
        this.m_ds.removeManagementPermissions(paths, type, principals, this.getContext(), true);
    }

    public void removeManagementPermissions(String[] paths, String type) throws MFException {
        if (!this.m_ds.isPermissionsCheckingEnabled()) {
            return;
        }
        this.validateStarted();
        this.validateActive();
        this.m_ds.removeManagementPermissions(paths, type, this.getContext(), true);
    }

    public IManagementPermission[][] getManagementPermissions(String[] paths, String type) throws MFException {
        if (!this.m_ds.isPermissionsCheckingEnabled()) {
            return new IManagementPermission[0][0];
        }
        this.validateStarted();
        this.validateActive();
        return this.m_ds.getManagementPermissions(paths, type, this.getContext(), true);
    }

    public void removeAllManagementPermissions() throws MFException {
        if (!this.m_ds.isPermissionsCheckingEnabled()) {
            return;
        }
        this.validateStarted();
        this.validateActive();
        this.m_ds.removeAllManagementPermissions();
    }

    public void suspendChangeNotifications(String containerID, String[] allowTypes) throws MFException {
        this.validateResolveURL(containerID);
        this.m_ds.suspendChangeNotifications(containerID, allowTypes);
    }

    public void resumeChangeNotifications(String containerID) throws MFException {
        this.validateResolveURL(containerID);
        this.m_ds.resumeChangeNotifications(containerID);
    }

    private void validateResolveURL(String containerID) throws DirectoryServiceException {
        this.validateStarted();
        this.validateActive();
        this.configurePermissionWriteCheck(containerID, containerID, true);
    }

    public void resumeAllChangeNotifications() throws MFException {
        this.validateStarted();
        this.validateActive();
        this.configurePermissionWriteCheck(MF_DIR_SEPARATOR_STRING, null, false);
        this.m_ds.resumeAllChangeNotifications();
    }

    public void setDefaultManagementPermissions() throws MFException {
        this.validateStarted();
        this.validateActive();
        this.m_ds.setDefaultManagementPermissions();
    }

    private void configurePermissionReadCheck(String path, String originalPath, boolean isLogical) throws DirectoryServiceException {
        this.configurePermissionCheck(path, originalPath, 1, isLogical);
    }

    private void configurePermissionWriteCheck(String path, String originalPath, boolean isLogical) throws DirectoryServiceException {
        this.configurePermissionCheck(path, originalPath, 4, isLogical);
    }

    private void configurePermissionDeleteCheck(String path, String originalPath, boolean isLogical) throws DirectoryServiceException {
        this.configurePermissionCheck(path, originalPath, 16, isLogical);
    }

    private void configurePermissionCheck(String path, String originalPath, int permission, boolean isLogical) throws DirectoryServiceException {
        if (originalPath != null && originalPath.startsWith(MFCONTEXT_ROOT_DIR)) {
            return;
        }
        if (path != null && path.startsWith(DiskFileDSHandler.getHandlerName())) {
            return;
        }
        if (this.getContext().getPermissionsManager().isPermissionsCheckingEnabled()) {
            this.getContext().getPermissionsManager().configurePermissionCheck(this.getContext(), this.m_ds.getPermissionsPath(path), isLogical, permission);
        }
    }

    private boolean checkPermissions(String elementOrDirName) {
        return this.getContext().getPermissionsManager().isPermissionsCheckingEnabled() && !elementOrDirName.startsWith(MFCONTEXT_ROOT_DIR);
    }

    static {
        ATTRIBUTE_INFOS = new ArrayList();
        OPERATION_INFOS = new ArrayList();
        NOTIFICATION_INFOS = new ArrayList();
        m_startActive = System.getProperty("sonicsw.mf.DS.startactive", "false").equalsIgnoreCase("true");
        Method method = null;
        ATTRIBUTE_INFOS.add(new MBeanAttributeInfo("FaultToleranceRole", String.class.getName(), "The fault tolerant role of the DS (primary or backup) or null if not fault tolerant.", true, false, false));
        ATTRIBUTE_INFOS.add(new MBeanAttributeInfo("FaultTolerantState", Short.class.getName(), "The current fault tolerant state of this Directory Service.", true, false, false));
        ATTRIBUTE_INFOS.add(new MBeanAttributeInfo("FaultTolerantStateString", String.class.getName(), "The description of the current fault tolerant state of this Directory Service.", true, false, false));
        ATTRIBUTE_INFOS.add(new MBeanAttributeInfo("AllowFailover", Boolean.class.getName(), "When this Directory Service is in a standby state and this attribute is set to 'false', fault tolerant failover to active will not occur.", true, true, false));
        MBeanParameterInfo[] mbParamInfos = null;
        OPERATION_INFOS.add(new MBeanOperationInfo("getDomain", "Gets the domain name for the configuration domain the Directory Service maintains.", IEmptyArray.EMPTY_PARAMETER_INFO_ARRAY, String.class.getName(), 0));
        try {
            method = DSComponent.class.getMethod("getView", IEmptyArray.EMPTY_CLASS_ARRAY);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("getView", method));
        OPERATION_INFOS.add(new MBeanOperationInfo("getDirectoryServiceVersion", "Gets the Directory Service version.", IEmptyArray.EMPTY_PARAMETER_INFO_ARRAY, Integer.class.getName(), 0));
        OPERATION_INFOS.add(new MBeanOperationInfo("getDirectoryServiceReleaseVersion", "Gets the Directory Service release version.", IEmptyArray.EMPTY_PARAMETER_INFO_ARRAY, String.class.getName(), 0));
        try {
            method = DSComponent.class.getMethod("setView", IDeltaView.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("setView", method));
        try {
            method = DSComponent.class.getMethod("setViewGetToken", IDeltaView.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("setViewGetToken", method));
        try {
            method = DSComponent.class.getMethod("getBlob", String.class, Boolean.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("getBlob", method));
        try {
            method = DSComponent.class.getMethod("getBlob", String.class, Boolean.class, Integer.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("getBlob", method));
        try {
            method = DSComponent.class.getMethod("getBlobByLogicalName", String.class);
        }
        catch (Exception e) {
            methodsWithErrors = methodsWithErrors + ", getBlobByLogicalName";
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("getBlobByLogicalName", method));
        try {
            method = DSComponent.class.getMethod("getElement", String.class, Boolean.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("getElement", method));
        try {
            method = DSComponent.class.getMethod("logicalToStorage", String.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("logicalToStorage", method));
        try {
            method = DSComponent.class.getMethod("storageToLogical", String.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("storageToLogical", method));
        try {
            method = DSComponent.class.getMethod("getElement", String.class, Boolean.class, Boolean.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("getElement", method));
        try {
            method = DSComponent.class.getMethod("getElementIfUpdated", Long.class, String.class, IElementIdentity.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("getElementIfUpdated", method));
        try {
            method = DSComponent.class.getMethod("getElements", Query.class, Boolean.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("getElements", method));
        try {
            method = DSComponent.class.getMethod("getElements", Query.class, Boolean.class, Boolean.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("getElements", method));
        try {
            method = DSComponent.class.getMethod("getIdentity", String.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("getIdentity", method));
        try {
            method = DSComponent.class.getMethod("lookupIdentity", String.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("lookupIdentity", method));
        try {
            method = DSComponent.class.getMethod("getAllElements", String.class, Boolean.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("getAllElements", method));
        try {
            method = DSComponent.class.getMethod("getAllElementsCompressed", String.class, Boolean.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("getAllElementsCompressed", method));
        try {
            method = DSComponent.class.getMethod("listAll", String.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("listAll", method));
        try {
            method = DSComponent.class.getMethod("listDirectories", String.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("listDirectories", method));
        try {
            method = DSComponent.class.getMethod("listElements", String.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("listElements", method));
        try {
            method = DSComponent.class.getMethod("detachBlob", IDeltaDirElement.class, IDeltaView.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("detachBlob", method));
        try {
            method = DSComponent.class.getMethod("deleteElement", String.class, IDeltaView.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("deleteElement", method));
        try {
            method = DSComponent.class.getMethod("unSubclassElement", String.class, IDeltaView.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("unSubclassElement", method));
        try {
            method = DSComponent.class.getMethod("createDirectory", String.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("createDirectory", method));
        try {
            method = DSComponent.class.getMethod("deleteDirectory", String.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("deleteDirectory", method));
        try {
            method = DSComponent.class.getMethod("deleteDirectory", String.class, IDeltaView.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("deleteDirectory", method));
        try {
            method = DSComponent.class.getMethod("attachBlob", IBasicElement.class, byte[].class, IDeltaView.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("attachBlob", method));
        try {
            method = DSComponent.class.getMethod("appendBlob", IBasicElement.class, byte[].class, Integer.class, Boolean.class, IDeltaView.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("appendBlob", method));
        try {
            method = DSComponent.class.getMethod("setElement", IBasicElement.class, IDeltaView.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("setElement", method));
        try {
            method = DSComponent.class.getMethod("upgrade5to6", String.class, String.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("upgrade5to6", method));
        try {
            method = DSComponent.class.getMethod("setElementReleaseVersion", String.class, String.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("setElementReleaseVersion", method));
        try {
            method = DSComponent.class.getMethod("setElements", IBasicElement[].class, String[].class, IDeltaView.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("setElements", method));
        try {
            method = DSComponent.class.getMethod("cloneElement", String.class, String.class, IDeltaView.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("cloneElement", method));
        try {
            method = DSComponent.class.getMethod("cloneElement", IBasicElement.class, String.class, IDeltaView.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("cloneElement", method));
        try {
            method = DSComponent.class.getMethod("cloneElement", String.class, String.class, Boolean.class, IDeltaView.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("cloneElement", method));
        try {
            method = DSComponent.class.getMethod("cloneElement", IBasicElement.class, String.class, Boolean.class, IDeltaView.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("cloneElement", method));
        try {
            method = DSComponent.class.getMethod("subclassElement", IBasicElement.class, String.class, IDeltaView.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("subclassElement", method));
        try {
            method = DSComponent.class.getMethod("exportElementToXML", String.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("exportElementToXML", method));
        try {
            method = DSComponent.class.getMethod("exportDSBootFileString", String.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("exportDSBootFileString", method));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("dirName", String.class.getName(), "The Directory Service directory to export.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("exportDirectoryToXML", "Exports (returns) the given Directory Service directory as an single XML document. Warning: The returned string may be very large.", mbParamInfos, String.class.getName(), 1));
        OPERATION_INFOS.add(new MBeanOperationInfo("dumpContentsToXML", "Dumps an entire directory into an XML document in the current working directory of the container hosting the DS. The dump file will be named \"dump.<domain name>.<n>.xml\" where <n> is a version number one greater than existing dump files (starting at 0).", IEmptyArray.EMPTY_PARAMETER_INFO_ARRAY, Void.class.getName(), 1));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("XMLDocument", String.class.getName(), "The XML formatted content to be imported.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("importFromXML", "Import a directory or an element from an XML document.", mbParamInfos, Void.class.getName(), 1));
        OPERATION_INFOS.add(new MBeanOperationInfo("listExternalDomainWithManagementSPI", "Return list of external domain descriptors that have been configured with Management SPI.", IEmptyArray.EMPTY_PARAMETER_INFO_ARRAY, String[].class.getName(), 0));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("mfDomainDescriptor", String.class.getName(), "The name of the external domain")};
        OPERATION_INFOS.add(new MBeanOperationInfo("reloadExternalAuthenticationDomain", "Reloads the external domain that matches the descriptor passed in.", mbParamInfos, Boolean.class.getName(), 1));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("backupDir", String.class.getName(), "The directory to use for the backup"), new MBeanParameterInfo("overwrite", Boolean.class.getName(), "Overwrite the existing DS if there is one in the backup directory")};
        OPERATION_INFOS.add(new MBeanOperationInfo("startBackup", "Start the backup process asynchronously", mbParamInfos, Void.class.getName(), 1));
        OPERATION_INFOS.add(new MBeanOperationInfo("getBackupStatus", "Return a BackupStatus object with information about the last backup", IEmptyArray.EMPTY_PARAMETER_INFO_ARRAY, IBackupStatus.class.getName(), 0));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("lockName", String.class.getName(), "The name of the lock to be acquired."), new MBeanParameterInfo("key", String.class.getName(), "The key under which the lock (if acquired) should be held."), new MBeanParameterInfo("leaseDuration", Integer.class.getName(), "The duration the lock lease will remain in effect (cannot be (re)acquired using a different key). After the duration has expired the lock can be acquired under a different key.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("leaseLock", "Leases the named lock against the given key for the given period. Returns true if the the lock was successfully acquired, false if not.", mbParamInfos, Boolean.class.getName(), 1));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("lockName", String.class.getName(), "The name of the acquired lock."), new MBeanParameterInfo("key", String.class.getName(), "The key under which the lock was acquired.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("releaseLock", "Releases a previously acquired lock (if that lock is still held against the given key).", mbParamInfos, Void.class.getName(), 1));
        try {
            method = DSComponent.class.getMethod("attachFSBlob", IBasicElement.class, byte[].class);
        }
        catch (Exception e) {
            methodsWithErrors = methodsWithErrors + ", attachFSBlob2";
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("attachFSBlob", method));
        try {
            method = DSComponent.class.getMethod("appendFSBlob", IBasicElement.class, byte[].class, Integer.class, Boolean.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("appendFSBlob", method));
        try {
            method = DSComponent.class.getMethod("cloneFSBlob", String.class, String.class);
        }
        catch (Exception e) {
            methodsWithErrors = methodsWithErrors + ", cloneFSBlob";
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("cloneFSBlob", method));
        try {
            method = DSComponent.class.getMethod("cloneFSElement", IBasicElement.class, String.class);
        }
        catch (Exception e) {
            methodsWithErrors = methodsWithErrors + ", cloneFSElement1";
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("cloneFSElement", method));
        try {
            method = DSComponent.class.getMethod("cloneFSElement", IBasicElement.class, String.class, Boolean.class);
        }
        catch (Exception e) {
            methodsWithErrors = methodsWithErrors + ", cloneFSElement2";
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("cloneFSElement", method));
        try {
            method = DSComponent.class.getMethod("cloneFSElement", String.class, String.class);
        }
        catch (Exception e) {
            methodsWithErrors = methodsWithErrors + ", cloneFSElement3";
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("cloneFSElement", method));
        try {
            method = DSComponent.class.getMethod("cloneFSElement", String.class, String.class, Boolean.class);
        }
        catch (Exception e) {
            methodsWithErrors = methodsWithErrors + ", cloneFSElement4";
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("cloneFSElement", method));
        try {
            method = DSComponent.class.getMethod("createFolder", String.class);
        }
        catch (Exception e) {
            methodsWithErrors = methodsWithErrors + ", createFolder";
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("createFolder", method));
        try {
            method = DSComponent.class.getMethod("createFolder", String.class, Boolean.class);
        }
        catch (Exception e) {
            methodsWithErrors = methodsWithErrors + ", createFolder";
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("createFolder", method));
        try {
            method = DSComponent.class.getMethod("copyFiles", String.class, String.class);
        }
        catch (Exception e) {
            methodsWithErrors = methodsWithErrors + ", copyFiles";
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("copyFiles", method));
        try {
            method = DSComponent.class.getMethod("createFSElement", IDirElement.class);
        }
        catch (Exception e) {
            methodsWithErrors = methodsWithErrors + ", createFSElement";
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("createFSElement", method));
        try {
            method = DSComponent.class.getMethod("defineElementMetaAttributes", String[].class);
        }
        catch (Exception e) {
            methodsWithErrors = methodsWithErrors + ", defineElementMetaAttributes";
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("defineElementMetaAttributes", method));
        try {
            method = DSComponent.class.getMethod("defineFolderMetaAttributes", String[].class);
        }
        catch (Exception e) {
            methodsWithErrors = methodsWithErrors + ", defineFolderMetaAttributes";
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("defineFolderMetaAttributes", method));
        try {
            method = DSComponent.class.getMethod("deleteFolder", String.class);
        }
        catch (Exception e) {
            methodsWithErrors = methodsWithErrors + ", deleteFolder";
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("deleteFolder", method));
        try {
            method = DSComponent.class.getMethod("deleteFSElement", String.class);
        }
        catch (Exception e) {
            methodsWithErrors = methodsWithErrors + ", deleteFSElement";
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("deleteFSElement", method));
        try {
            method = DSComponent.class.getMethod("detachFSBlob", IDeltaDirElement.class);
        }
        catch (Exception e) {
            methodsWithErrors = methodsWithErrors + ", detachFSBlob";
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("detachFSBlob", method));
        try {
            method = DSComponent.class.getMethod("executeTransaction", IDSTransaction.class);
        }
        catch (Exception e) {
            methodsWithErrors = methodsWithErrors + ", executeTransaction";
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("executeTransaction", method));
        try {
            method = DSComponent.class.getMethod("getBackReferenceTypes", IEmptyArray.EMPTY_CLASS_ARRAY);
        }
        catch (Exception e) {
            methodsWithErrors = methodsWithErrors + ", getBackReferenceTypes";
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("getBackReferenceTypes", method));
        try {
            method = DSComponent.class.getMethod("getCreateContainerConfiguration", String.class, String.class, String.class, Hashtable.class, Hashtable.class);
        }
        catch (Exception e) {
            methodsWithErrors = methodsWithErrors + ", getCreateContainerConfiguration";
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("getCreateContainerConfiguration", method));
        try {
            method = DSComponent.class.getMethod("getReferences", String.class);
        }
        catch (Exception e) {
            methodsWithErrors = methodsWithErrors + ", getReferences";
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("getReferences", method));
        try {
            method = DSComponent.class.getMethod("getDefinedElementMetaAttributes", IEmptyArray.EMPTY_CLASS_ARRAY);
        }
        catch (Exception e) {
            methodsWithErrors = methodsWithErrors + ", getDefinedElementMetaAttributes";
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("getDefinedElementMetaAttributes", method));
        try {
            method = DSComponent.class.getMethod("getDefinedFolderMetaAttributes", IEmptyArray.EMPTY_CLASS_ARRAY);
        }
        catch (Exception e) {
            methodsWithErrors = methodsWithErrors + ", getDefinedFolderMetaAttributes";
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("getDefinedFolderMetaAttributes", method));
        try {
            method = DSComponent.class.getMethod("getElementsByLogicalNames", String[].class);
        }
        catch (Exception e) {
            methodsWithErrors = methodsWithErrors + ", getElementsByLogicalNames ";
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("getElementsByLogicalNames", method));
        try {
            method = DSComponent.class.getMethod("getFSBlob", String.class, Boolean.class);
        }
        catch (Exception e) {
            methodsWithErrors = methodsWithErrors + ", getFSBlob";
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("getFSBlob", method));
        try {
            method = DSComponent.class.getMethod("getFSBlob", String.class, Boolean.class, Integer.class);
        }
        catch (Exception e) {
            methodsWithErrors = methodsWithErrors + ", getFSBlob";
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("getFSBlob", method));
        try {
            method = DSComponent.class.getMethod("getFiles", String[].class);
        }
        catch (Exception e) {
            methodsWithErrors = methodsWithErrors + ", getFiles";
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("getFiles", method));
        try {
            method = DSComponent.class.getMethod("getFiles", String.class, Boolean.class, String.class);
        }
        catch (Exception e) {
            methodsWithErrors = methodsWithErrors + ", getFiles";
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("getFiles", method));
        try {
            method = DSComponent.class.getMethod("getFSElement", String.class, Boolean.class);
        }
        catch (Exception e) {
            methodsWithErrors = methodsWithErrors + ", getFSElement1";
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("getFSElement", method));
        try {
            method = DSComponent.class.getMethod("getFSElement", String.class, Boolean.class, Boolean.class);
        }
        catch (Exception e) {
            methodsWithErrors = methodsWithErrors + ", getFSElement2";
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("getFSElement", method));
        try {
            method = DSComponent.class.getMethod("getFSElement", String.class, Boolean.class, Boolean.class);
        }
        catch (Exception e) {
            methodsWithErrors = methodsWithErrors + ", getFSElement3";
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("getFSElement", method));
        try {
            method = DSComponent.class.getMethod("getFSElements", Query.class, Boolean.class);
        }
        catch (Exception e) {
            methodsWithErrors = methodsWithErrors + ", getFSElements1";
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("getFSElements", method));
        try {
            method = DSComponent.class.getMethod("getFSElements", Query.class, Boolean.class, Boolean.class);
        }
        catch (Exception e) {
            methodsWithErrors = methodsWithErrors + ", getFSElements2";
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("getFSElements", method));
        try {
            method = DSComponent.class.getMethod("getFSElements", Query.class, Boolean.class, Boolean.class, QueryBatch.class);
        }
        catch (Exception e) {
            methodsWithErrors = methodsWithErrors + ", getFSElements3";
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("getFSElements", method));
        try {
            method = DSComponent.class.getMethod("getFSElements", String.class, Boolean.class);
        }
        catch (Exception e) {
            methodsWithErrors = methodsWithErrors + ", getFSElements4";
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("getFSElements", method));
        try {
            method = DSComponent.class.getMethod("getFSIdentity", String.class);
        }
        catch (Exception e) {
            methodsWithErrors = methodsWithErrors + ", getFSIdentity";
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("getFSIdentity", method));
        try {
            method = DSComponent.class.getMethod("getMetaAttributes", String.class);
        }
        catch (Exception e) {
            methodsWithErrors = methodsWithErrors + ", getMetaAttributes";
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("getMetaAttributes", method));
        try {
            method = DSComponent.class.getMethod("listFolders", String.class);
        }
        catch (Exception e) {
            methodsWithErrors = methodsWithErrors + ", listFolders";
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("listFolders", method));
        try {
            method = DSComponent.class.getMethod("listAllFolders", IEmptyArray.EMPTY_CLASS_ARRAY);
        }
        catch (Exception e) {
            methodsWithErrors = methodsWithErrors + ", listAllFolders";
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("listAllFolders", method));
        try {
            method = DSComponent.class.getMethod("listFSAll", String.class);
        }
        catch (Exception e) {
            methodsWithErrors = methodsWithErrors + ", listFSAll";
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("listFSAll", method));
        try {
            method = DSComponent.class.getMethod("listFSAll", String.class, Boolean.class, String.class);
        }
        catch (Exception e) {
            methodsWithErrors = methodsWithErrors + ", listFSAll";
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("listFSAll", method));
        try {
            method = DSComponent.class.getMethod("recursiveList", String.class, Boolean.class, Boolean.class, String.class);
        }
        catch (Exception e) {
            methodsWithErrors = methodsWithErrors + ", recursiveList";
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("recursiveList", method));
        try {
            method = DSComponent.class.getMethod("listFSElements", String.class);
        }
        catch (Exception e) {
            methodsWithErrors = methodsWithErrors + ", listFSElements";
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("listFSElements", method));
        try {
            method = DSComponent.class.getMethod("rebuildBackReferences", IEmptyArray.EMPTY_CLASS_ARRAY);
        }
        catch (Exception e) {
            methodsWithErrors = methodsWithErrors + ", rebuildBackReferences";
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("rebuildBackReferences", method));
        try {
            method = DSComponent.class.getMethod("repairReferences", String[].class);
        }
        catch (Exception e) {
            methodsWithErrors = methodsWithErrors + ", repairReferences";
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("repairReferences", method));
        try {
            method = DSComponent.class.getMethod("rename", String.class, String.class);
        }
        catch (Exception e) {
            methodsWithErrors = methodsWithErrors + ", rename";
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("rename", method));
        try {
            method = DSComponent.class.getMethod("renameFolder", String.class, String.class);
        }
        catch (Exception e) {
            methodsWithErrors = methodsWithErrors + ", renameFolder";
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("renameFolder", method));
        try {
            method = DSComponent.class.getMethod("renameFile", String.class, String.class);
        }
        catch (Exception e) {
            methodsWithErrors = methodsWithErrors + ", renameFile";
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("renameFile", method));
        try {
            method = DSComponent.class.getMethod("resetBackReferences", IEmptyArray.EMPTY_CLASS_ARRAY);
        }
        catch (Exception e) {
            methodsWithErrors = methodsWithErrors + ", resetBackReferences";
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("resetBackReferences", method));
        try {
            method = DSComponent.class.getMethod("revertToTemplate", String.class, AttributeName[].class);
        }
        catch (Exception e) {
            methodsWithErrors = methodsWithErrors + ", revertToTemplate";
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("revertToTemplate", method));
        try {
            method = DSComponent.class.getMethod("setBackReferenceTypes", String[].class);
        }
        catch (Exception e) {
            methodsWithErrors = methodsWithErrors + ", setBackReferenceTypes";
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("setBackReferenceTypes", method));
        try {
            method = DSComponent.class.getMethod("setComplexStorageHint", String.class, String.class);
        }
        catch (Exception e) {
            methodsWithErrors = methodsWithErrors + ", setComplexStorageHint";
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("setComplexStorageHint", method));
        try {
            method = DSComponent.class.getMethod("setMetaAttributes", String.class, HashMap.class);
        }
        catch (Exception e) {
            methodsWithErrors = methodsWithErrors + ", setMetaAttributes";
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("setMetaAttributes", method));
        try {
            method = DSComponent.class.getMethod("getStorageToLogicalMap", IEmptyArray.EMPTY_CLASS_ARRAY);
        }
        catch (Exception e) {
            methodsWithErrors = methodsWithErrors + ", setMetaAttributes";
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("getStorageToLogicalMap", method));
        try {
            method = DSComponent.class.getMethod("setStorageHint", String.class, String.class);
        }
        catch (Exception e) {
            methodsWithErrors = methodsWithErrors + ", setStorageHint1";
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("setStorageHint", method));
        try {
            method = DSComponent.class.getMethod("setStorageHint", String.class, String.class, String.class);
        }
        catch (Exception e) {
            methodsWithErrors = methodsWithErrors + ", setStorageHint2";
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("setStorageHint", method));
        try {
            method = DSComponent.class.getMethod("subclassFSElement", IBasicElement.class, String.class);
        }
        catch (Exception e) {
            methodsWithErrors = methodsWithErrors + ", subclassFSElement";
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("subclassFSElement", method));
        try {
            method = DSComponent.class.getMethod("unSubclassFSElement", String.class);
        }
        catch (Exception e) {
            methodsWithErrors = methodsWithErrors + ", unSubclassFSElement";
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("unSubclassFSElement", method));
        try {
            method = DSComponent.class.getMethod("updateFSElement", IDeltaDirElement.class);
        }
        catch (Exception e) {
            methodsWithErrors = methodsWithErrors + ", updateFSElement";
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("updateFSElement", method));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("paths", String[][].class.getName(), "Logical paths of folders, components and elements to set permissions on"), new MBeanParameterInfo("type", String.class.getName(), "Type of permissions, manage or configure"), new MBeanParameterInfo("permissions", IManagementPermission[][].class.getName(), "Permissions to set on the paths")};
        OPERATION_INFOS.add(new MBeanOperationInfo("setManagementPermissions", "Set manage or configure permissions to the paths indicated", mbParamInfos, Void.class.getName(), 1));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("paths", String[][].class.getName(), "Logical paths of folders, components and elements to get permissions for"), new MBeanParameterInfo("type", String.class.getName(), "Type of permissions, manage or configure")};
        OPERATION_INFOS.add(new MBeanOperationInfo("getManagementPermissions", "Return the manage or configure permissions for the paths indicated", mbParamInfos, IManagementPermission[][].class.getName(), 0));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("paths", String[][].class.getName(), "Logical paths of folders, components and elements to remove permissions from"), new MBeanParameterInfo("type", String.class.getName(), "Type of permissions, manage or configure"), new MBeanParameterInfo("principals", String[][].class.getName(), "Principals with permissions to be removed")};
        OPERATION_INFOS.add(new MBeanOperationInfo("removeManagementPermissions", "Remove manage or configure permissions from the paths indicated", mbParamInfos, Void.class.getName(), 1));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("paths", String[][].class.getName(), "Logical paths of folders, components and elements to remove permissions from"), new MBeanParameterInfo("type", String.class.getName(), "Type of permissions, manage or configure")};
        OPERATION_INFOS.add(new MBeanOperationInfo("removeManagementPermissions", "Remove manage or configure permissions from the paths indicated", mbParamInfos, Void.class.getName(), 1));
        OPERATION_INFOS.add(new MBeanOperationInfo("removeAllManagementPermissions", "Remove all management permissions", IEmptyArray.EMPTY_PARAMETER_INFO_ARRAY, Void.class.getName(), 1));
        OPERATION_INFOS.add(new MBeanOperationInfo("setDefaultManagementPermissions", "Set default permissions for the Administrators group", IEmptyArray.EMPTY_PARAMETER_INFO_ARRAY, Void.class.getName(), 1));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("forUpdate", Boolean.class.getName(), "Whether the returned element should allow updates to it")};
        OPERATION_INFOS.add(new MBeanOperationInfo("getDomainElement", "Return the element containing the domain-wide management security and auditing settings", mbParamInfos, IDirElement.class.getName(), 0));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("element", IDeltaDirElement.class.getName(), "The element modifications")};
        OPERATION_INFOS.add(new MBeanOperationInfo("setDomainElement", "Sets the domain-wide security and audit settings", mbParamInfos, IDeltaDirElement.class.getName(), 0));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("containerID", String.class.getName(), "Name of the container to which we halt notifications"), new MBeanParameterInfo("allowTypes", String[].class.getName(), "The container will continue to receive notifications for changes of this type")};
        OPERATION_INFOS.add(new MBeanOperationInfo("suspendChangeNotifications", "Stops sending change notifications to a container, optionally lets notifications through for element types in allowTypes", mbParamInfos, Void.class.getName(), 0));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("containerID", String.class.getName(), "Name of the container to which the DS will resume notifications")};
        OPERATION_INFOS.add(new MBeanOperationInfo("resumeChangeNotifications", "Resumes sending change notifications to a container, used in testing", mbParamInfos, Void.class.getName(), 0));
        OPERATION_INFOS.add(new MBeanOperationInfo("resumeAllChangeNotifications", "Resumes sending change notifications to all containers, used in testing", IEmptyArray.EMPTY_PARAMETER_INFO_ARRAY, Void.class.getName(), 1));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("subscriber", String.class.getName(), "Runtime ID of the container registering notifications"), new MBeanParameterInfo("logicalName", String.class.getName(), "Logical name of the configuration which the container is interested in")};
        OPERATION_INFOS.add(new MBeanOperationInfo("registerInterestInChanges", "Register the interest of the container in changes to the configuration named by the logical name", mbParamInfos, Void.class.getName(), 1));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("url", String.class.getName(), "\"sonicrn:///\" URL to be resolved")};
        OPERATION_INFOS.add(new MBeanOperationInfo("resolveURL", "Resolve the given \"sonicrn:///\" URL to its full substituted form. For internal (Sonic) use.", mbParamInfos, String.class.getName(), 0));
        String[] notifTypes = null;
        notifTypes = new String[]{INotification.CATEGORY_TEXT[3], INotification.SUBCATEGORY_TEXT[3], CHANGE_NOTIFICATION_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "Configuration change(s) propagated by the Directory Services."));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[0], INotification.SUBCATEGORY_TEXT[0], FAILOVER_NOTIFICATION_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "Standby service has failed over to become the active service."));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[0], INotification.SUBCATEGORY_TEXT[5], CONFIGURE_PERMISSION_DENIED_NOTIFICATION_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "User has been denied permission to perform a configuration task."));
        m_dsStartupElement = ElementFactory.createElement((String)DS_STARTUP_ELEMENT, (String)"startup", (String)"2.0");
        if (methodsWithErrors.length() > 0) {
            System.out.println("Methods with errors == " + methodsWithErrors);
        }
    }

    private class SdfMFTracingIntegration
    extends AbstractMFComponentTracing {
        private boolean m_updateTraceLevelWasCalled;

        SdfMFTracingIntegration() {
            super("sonic.mf.ds", DSComponent.this.getTraceMaskValues());
            this.m_updateTraceLevelWasCalled = false;
            this.setTraceMask();
        }

        private void setTraceMask() {
            this.setTraceMask(new Integer(DSComponent.this.m_traceMask));
        }

        boolean wasUpdated() {
            return this.m_updateTraceLevelWasCalled;
        }

        public void updateTraceLevel(String doiIDNotUsed, HashMap parameters, StringBuffer buffer) {
            super.updateTraceLevel(doiIDNotUsed, parameters, buffer);
            this.m_updateTraceLevelWasCalled = true;
            DSComponent.this.setTraceMask(this.getCurrentMask(), true);
        }
    }

    private class DSReplicationConroller
    extends ReplicationController {
        private DSReplicationConroller() {
        }

        @Override
        public boolean allowedToGetActive() {
            return DSComponent.this.getAllowFailover();
        }
    }

    private class DSStateHandler
    extends ReplicationStateHandler {
        private static final int NO_NEW_STATE = 0;
        private static final int TO_ACTIVE = 1;
        private static final int TO_STANDBY = 2;
        private IStateManager m_stateManager;
        private int m_currentState = 0;
        private int m_inStateActivation = 0;
        private int m_newState = 0;
        private int m_storageState = 0;
        private boolean m_closing = false;
        private boolean m_firstPhaseOfDeepSyncDone = false;

        DSStateHandler(IStateManager stateManager) {
            this.m_stateManager = stateManager;
            Thread stateModifier = new Thread("DSComponent.DSStateHandler replication state activator "){

                @Override
                public void run() {
                    while (true) {
                        boolean toActive = DSStateHandler.this.waitForNewState();
                        if (DSStateHandler.this.m_closing || DSComponent.this.m_container.isClosing()) {
                            return;
                        }
                        DSStateHandler.this.activateNewState(toActive);
                        DSStateHandler.this.finishedActivation();
                    }
                }
            };
            stateModifier.setDaemon(true);
            stateModifier.start();
        }

        String getStandbyStorageState() {
            switch (this.m_storageState) {
                case 5: {
                    return "Copying data (deep synchronization)";
                }
                case 4: {
                    return "Synchronizing";
                }
            }
            return null;
        }

        @Override
        public void newState(short state) {
            if (DSComponent.this.m_context != null && (this.m_firstPhaseOfDeepSyncDone && state == 3 || this.m_storageState == 5 && state == 3)) {
                DSComponent.this.m_context.logMessage("...completed copying data from " + DSComponent.this.m_partnerRole, 3);
            }
            this.m_firstPhaseOfDeepSyncDone = this.m_storageState == 5 && state == 4;
            this.m_storageState = state;
            if (this.m_closing || DSComponent.this.m_container.isClosing()) {
                return;
            }
            if ((DSComponent.this.m_traceMask & 0x800) > 0) {
                DSComponent.this.m_context.logMessage("Storage replication state chaned to: " + DSStateHandler.stateToString(state), 7);
            }
            this.stateChanged(state == 2 || state == 1);
        }

        @Override
        public void newMessage(String message, boolean warning) {
            if (DSComponent.this.m_context != null) {
                DSComponent.this.m_context.logMessage(message, warning ? 2 : 3);
            }
        }

        @Override
        public void shutdownState(String shutdownReason, Exception e) {
            if (e != null) {
                DSComponent.this.m_context.logMessage(shutdownReason, (Throwable)e, 1);
            } else {
                DSComponent.this.m_context.logMessage(shutdownReason, 1);
            }
            int exitCode = 4;
            if (shutdownReason != null && shutdownReason.indexOf("Both") != -1 && shutdownReason.indexOf("unreplicated") != -1) {
                exitCode = 11;
            }
            DSComponent.this.abortContainer(exitCode);
        }

        synchronized void close() {
            this.m_closing = true;
            this.notifyAll();
        }

        private void activateNewState(boolean toActive) {
            short oldState = this.m_stateManager.getState(null);
            try {
                this.m_stateManager.requestStateChange(this.m_stateManager.getState(null), toActive ? (short)2 : 3, null);
                if (!toActive && this.m_storageState == 5) {
                    DSComponent.this.m_context.logMessage("Copying data from " + DSComponent.this.m_partnerRole + " (deep synchronization)...", 3);
                }
            }
            catch (Exception e) {
                Throwable cause;
                boolean tryRestart = false;
                if (!(oldState != 3 || e instanceof IOException || (cause = e.getCause()) != null && cause instanceof IOException)) {
                    tryRestart = true;
                }
                if (tryRestart) {
                    DSComponent.this.m_context.logMessage("The transition to active state failed, recovering by restarting the container...", (Throwable)e, 2);
                    DSComponent.this.abortContainer(14);
                }
                DSComponent.this.m_context.logMessage("The transition to active state failed...", (Throwable)e, 1);
                DSComponent.this.abortContainer(4);
            }
        }

        private synchronized boolean waitForNewState() {
            while (this.m_newState == 0 && !this.m_closing) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {}
            }
            if (this.m_closing || DSComponent.this.m_container.isClosing()) {
                return false;
            }
            this.m_inStateActivation = this.m_newState;
            this.m_newState = 0;
            return this.m_inStateActivation == 1;
        }

        private synchronized void finishedActivation() {
            this.m_currentState = this.m_inStateActivation;
            this.m_inStateActivation = 0;
        }

        private synchronized void stateChanged(boolean active) {
            int inCommingState;
            int n = inCommingState = active ? 1 : 2;
            if (this.m_inStateActivation == 0 && inCommingState != this.m_currentState) {
                this.m_newState = inCommingState;
            } else if (this.m_newState == 0 && this.m_inStateActivation != inCommingState) {
                this.m_newState = inCommingState;
            } else if (this.m_newState != inCommingState) {
                this.m_newState = 0;
            }
            this.notifyAll();
        }
    }

    private class DSNamingListener
    implements INamingListener {
        private DSNamingListener() {
        }

        public void onNotification(INamingNotification notification) {
            ArrayList<INamingNotification> notifications = new ArrayList<INamingNotification>();
            notifications.add(notification);
            this.onNotifications(notifications);
        }

        public void onNotifications(ArrayList notifications) {
            ArrayList renameNotifications = new ArrayList();
            HashSet interestedContainers = DSComponent.this.updateLogicalRegistry(notifications, renameNotifications);
            DSComponent.this.sendLogicalRenamings(renameNotifications, interestedContainers.toArray(IEmptyArray.EMPTY_STRING_ARRAY));
            INotification fsNotification = DSComponent.this.m_context.createNotification((short)3, INotification.SUBCATEGORY_TEXT[3], DSComponent.NAMING_NOTIFICATION_TYPE, 4);
            fsNotification.setLogType((short)0);
            fsNotification.setAttribute("Elements", (Object)notifications);
            DSComponent.this.m_context.sendNotification(fsNotification);
        }
    }

    private class DSListener
    implements IArrayElementNotificationListener {
        private HashMap queuedChangeSenders = new HashMap();

        private DSListener() {
        }

        @Override
        public void elementsChanged(IBasicElement[] elements) {
            this.elementsChanged(elements, null);
        }

        @Override
        public void elementsChanged(IDirElement[] elements) {
            HashMap handledDirSubscribers = this.internalElementsChanged(elements);
            this.elementsChanged((IBasicElement[])elements, handledDirSubscribers);
        }

        private HashMap internalElementsChanged(final IDirElement[] elements) {
            if (elements == null || elements.length == 0) {
                return null;
            }
            HashMap<String, Boolean> handledDirSubscribers = new HashMap<String, Boolean>();
            String parentDir = this.getParentName(elements[0].getIdentity().getName());
            this.checkHierarchicalTypes(parentDir);
            String[] dirSubscribers = DSComponent.this.m_registry.getSubscribers(parentDir);
            final boolean debugNotifications = (DSComponent.this.m_traceMask & 0x100) > 0;
            for (int i = 0; i < dirSubscribers.length; ++i) {
                handledDirSubscribers.put(dirSubscribers[i], Boolean.TRUE);
                if ((DSComponent.this.m_traceMask & 1) > 0) {
                    DSComponent.this.trace(256, "Queue notify \"" + dirSubscribers[i] + "\" about \"" + parentDir + "\" directory modifications.");
                }
                final String subscriber = dirSubscribers[i];
                Runnable changeSender = new Runnable(){

                    @Override
                    public void run() {
                        DSComponent.this.sendChangedElements(elements, subscriber, debugNotifications);
                    }
                };
                this.queueChangeSender(subscriber, changeSender);
            }
            return handledDirSubscribers;
        }

        private void elementsChanged(IBasicElement[] elements, HashMap handledDirSubscribers) {
            if (elements == null || elements.length == 0) {
                return;
            }
            final boolean debugNotifications = (DSComponent.this.m_traceMask & 0x100) > 0;
            this.sendElementChangeNotification(elements);
            String groupParent = null;
            HashMap batchSubscribers = new HashMap();
            for (int i = 0; i < elements.length; ++i) {
                int i1;
                String elementName = elements[i].getIdentity().getName();
                String parentDir = this.getParentName(elementName);
                this.checkHierarchicalTypes(parentDir);
                if (handledDirSubscribers != null) {
                    if (groupParent != null && !groupParent.equals(parentDir)) {
                        String message = "IllegalStateException: All the elements of the group must be under the same directory.";
                        DSComponent.this.m_context.logMessage(message, 1);
                        throw new IllegalStateException(message);
                    }
                    if (groupParent == null) {
                        groupParent = parentDir;
                    }
                }
                String[] elementSubscribers = DSComponent.this.m_registry.getSubscribers(elementName);
                String[] dirSubscribers = DSComponent.this.m_registry.getSubscribers(parentDir);
                HashMap<String, String> elementSubscribersTable = new HashMap<String, String>();
                for (i1 = 0; i1 < elementSubscribers.length; ++i1) {
                    if (handledDirSubscribers != null && handledDirSubscribers.get(elementSubscribers[i1]) != null) continue;
                    elementSubscribersTable.put(elementSubscribers[i1], elementSubscribers[i1]);
                    this.addBatchSubscribersAndPopulateNotifs(batchSubscribers, elementSubscribers, i1, elements, i);
                }
                if (handledDirSubscribers != null) continue;
                for (i1 = 0; i1 < dirSubscribers.length; ++i1) {
                    if (elementSubscribersTable.containsKey(dirSubscribers[i1])) continue;
                    this.addBatchSubscribersAndPopulateNotifs(batchSubscribers, dirSubscribers, i1, elements, i);
                }
            }
            for (Map.Entry entry : batchSubscribers.entrySet()) {
                int i;
                final String subscriber = (String)entry.getKey();
                IBasicElement[] updatedElements = ((ArrayList)entry.getValue()).toArray(EMPTY_ELEMENT_ARRAY);
                if ((DSComponent.this.m_traceMask & 1) > 0) {
                    StringBuffer sb = new StringBuffer("Notify " + subscriber + " about:");
                    sb.append(IContainer.NEWLINE);
                    for (i = 0; i < updatedElements.length; ++i) {
                        sb.append(IContainer.NEWLINE).append('\t').append(updatedElements[i]);
                    }
                    sb.append(IContainer.NEWLINE);
                    DSComponent.this.trace(256, sb.toString());
                }
                SizedArrayList updateList = new SizedArrayList();
                i = 0;
                while (i < updatedElements.length) {
                    updateList.add(updatedElements[i]);
                    if (updatedElements[i] instanceof IEnvelope && ((IEnvelope)updatedElements[i]).getProperty("DRE") != null && i + 1 < updatedElements.length) {
                        updateList.add(updatedElements[++i]);
                    }
                    if (++i != updatedElements.length && updateList.getEstimatedContentSize() <= 0x100000) continue;
                    final SizedArrayList list = updateList;
                    Runnable changeSender = new Runnable(){

                        @Override
                        public void run() {
                            DSComponent.this.sendChangedElements(list.toArray(EMPTY_ELEMENT_ARRAY), subscriber, false, debugNotifications);
                        }
                    };
                    this.queueChangeSender(subscriber, changeSender);
                    if (i >= updatedElements.length) continue;
                    updateList = new SizedArrayList();
                }
            }
        }

        private void addBatchSubscribersAndPopulateNotifs(HashMap batchSubscribers, String[] dirSubscribers, int i1, IBasicElement[] elements, int i) {
            ArrayList<IBasicElement> notifs = (ArrayList<IBasicElement>)batchSubscribers.get(dirSubscribers[i1]);
            if (notifs == null) {
                notifs = new ArrayList<IBasicElement>();
                batchSubscribers.put(dirSubscribers[i1], notifs);
            }
            notifs.add(elements[i]);
        }

        private void checkHierarchicalTypes(String parentDir) {
            if (parentDir.startsWith(DSComponent.HIERARCHICAL_TYPES_PATH)) {
                try {
                    DSComponent.this.readHierarchicalTypes();
                }
                catch (DirectoryServiceException dirE) {
                    DSComponent.this.m_context.logMessage("Failed to refresh hierarchical types: " + dirE.getMessage(), 1);
                }
            }
        }

        private String getParentName(String name) {
            EntityName eName = null;
            try {
                eName = new EntityName(name);
            }
            catch (ConfigException e) {
                throw new Error(e.toString());
            }
            return eName.getParent();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void queueChangeSender(String subscriber, Runnable changeSender) {
            HashMap hashMap = this.queuedChangeSenders;
            synchronized (hashMap) {
                SenderManager manager = (SenderManager)this.queuedChangeSenders.get(subscriber);
                if (manager == null) {
                    manager = new SenderManager();
                    manager.subscriber = subscriber;
                    this.queuedChangeSenders.put(subscriber, manager);
                    DSComponent.this.m_context.scheduleTask((Runnable)manager, new Date());
                }
                manager.changeSenders.add(changeSender);
            }
        }

        private void sendElementChangeNotification(IBasicElement[] elements) {
            INotification notification = DSComponent.this.m_context.createNotification((short)3, INotification.SUBCATEGORY_TEXT[3], DSComponent.CHANGE_NOTIFICATION_TYPE, 4);
            notification.setLogType((short)0);
            notification.setAttribute("Elements", (Object)elements);
            DSComponent.this.m_context.sendNotification(notification);
            if (DSComponent.this.m_ds.isFSInterfaceInUse()) {
                IBasicElement[] elements1 = DSComponent.this.m_ds.translateElementsToLogical(elements);
                INotification fsNotification = DSComponent.this.m_context.createNotification((short)3, INotification.SUBCATEGORY_TEXT[3], DSComponent.FSCHANGE_NOTIFICATION_TYPE, 4);
                fsNotification.setLogType((short)0);
                fsNotification.setAttribute("Elements", (Object)elements1);
                DSComponent.this.m_context.sendNotification(fsNotification);
            }
        }

        private class SenderManager
        implements Runnable {
            private ArrayList changeSenders = new ArrayList();
            private String subscriber;

            private SenderManager() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Runnable changeSender = null;
                while (true) {
                    HashMap hashMap = DSListener.this.queuedChangeSenders;
                    synchronized (hashMap) {
                        if (this.changeSenders.isEmpty()) {
                            DSListener.this.queuedChangeSenders.remove(this.subscriber);
                            break;
                        }
                        changeSender = (Runnable)this.changeSenders.remove(0);
                    }
                    changeSender.run();
                }
            }
        }
    }

    public class StateListener
    implements IStateListener {
        public void stateChanging(short currentState, short intendedState) {
        }

        public void stateChanged(short previousState, short currentState) {
            switch (previousState) {
                case 1: {
                    switch (currentState) {
                        case 2: 
                        case 3: {
                            DSComponent.this.m_context.logMessage("Transition to state: \"" + IFaultTolerantState.STATE_TEXT[currentState] + '\"', 3);
                        }
                    }
                    break;
                }
                case 3: {
                    if (currentState != 2) break;
                    String stateString = IFaultTolerantState.STATE_TEXT[currentState];
                    if (DSComponent.this.m_backupFailoverReadOnly && DSComponent.this.m_isBackup) {
                        stateString = stateString + " (Read Only)";
                    }
                    DSComponent.this.m_context.logMessage("Failover to state: \"" + stateString + '\"', 2);
                    DSComponent.this.sendFTStateChange(true);
                    break;
                }
                case 2: {
                    if (currentState != 3) break;
                    DSComponent.this.m_context.logMessage("Reverting to state: \"" + IFaultTolerantState.STATE_TEXT[currentState] + '\"', 2);
                    DSComponent.this.sendFTStateChange(false);
                }
            }
            if (currentState == 2) {
                DSComponent.this.makeConfigChangeSubscriptions();
            }
        }

        public void stateChangeFailed(short currentState, short intendedState) {
        }
    }

    public class ToStandbyStateController
    implements IStateController {
        public boolean changeState() throws NonRecoverableStateChangeException {
            DSComponent.this.m_container.removeGlobalComponentSupport(DSComponent.GLOBAL_ID, null);
            DSComponent.this.m_container.setLocalDS(null);
            DSComponent.this.stopDirectoryService(true);
            return true;
        }
    }

    public class ToActiveStateController
    implements IStateController {
        public boolean changeState() throws NonRecoverableStateChangeException, RecoverableStateChangeException {
            if (3 == DSComponent.this.startDirectoryService()) {
                throw new NonRecoverableStateChangeException("Directory Service startup failure");
            }
            try {
                DSComponent.this.m_container.addGlobalComponentSupport(DSComponent.GLOBAL_ID, null, DSComponent.this);
            }
            catch (Exception e) {
                DSComponent.this.m_container.removeGlobalComponentSupport(DSComponent.GLOBAL_ID, null);
                DSComponent.this.m_context.logMessage("Failed communications initialization, trace follows...", (Throwable)e, 1);
                DSComponent.this.m_container.shutdown(9);
            }
            DSComponent.this.m_container.setLocalDS(DSComponent.this);
            DSComponent.this.announceDirectoryServiceIsAvailable(DSComponent.this.m_startState == 2, true);
            return true;
        }
    }
}

